<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

include("../config/conexion.php");

$mensaje = "";
$prestamo_detalle = null;

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $usuario_id = $_POST['usuario_id']; // RUT
    $libro_id = $_POST['libro_id'];
    $fecha_prestamo = $_POST['fecha_prestamo'];
    $fecha_devolucion = $_POST['fecha_devolucion'];

    // Verificar libro por ID y stock disponible
    $stmt_libro = $conn->prepare("SELECT titulo, stock_disponible FROM libros WHERE id = ?");
    $stmt_libro->bind_param("i", $libro_id);
    $stmt_libro->execute();
    $res_libro = $stmt_libro->get_result();

    if ($res_libro->num_rows > 0) {
        $libro = $res_libro->fetch_assoc();

        if ((int)$libro['stock_disponible'] <= 0) {
            $mensaje = "⚠️ No hay stock disponible del libro '{$libro['titulo']}'.";
        } else {
            // Insertar préstamo
            $stmt = $conn->prepare("INSERT INTO prestamos (usuario_id, libro_id, fecha_prestamo, fecha_devolucion) VALUES (?, ?, ?, ?)");
            $stmt->bind_param("siss", $usuario_id, $libro_id, $fecha_prestamo, $fecha_devolucion);

            if ($stmt->execute()) {
                // Reducir stock_disponible y asignar rut_usuario al libro
                $update = $conn->prepare("UPDATE libros SET stock_disponible = stock_disponible - 1, rut_usuario = ? WHERE id = ?");
                $update->bind_param("si", $usuario_id, $libro_id);
                $update->execute();

                // Detalle del préstamo
                $ultimo_id = $stmt->insert_id;

                $sql_detalle = "
                    SELECT 
                        p.usuario_id AS rut_usuario,
                        l.titulo,
                        a.nombre_alumno,
                        c.nivel,
                        c.seccion,
                        p.fecha_prestamo,
                        p.fecha_devolucion
                    FROM prestamos p
                    INNER JOIN libros l ON p.libro_id = l.id
                    LEFT JOIN alumnos a ON a.rut = p.usuario_id
                    LEFT JOIN cursos c ON a.curso_id = c.id
                    WHERE p.id = ?
                ";

                $detalle = $conn->prepare($sql_detalle);
                $detalle->bind_param("i", $ultimo_id);
                $detalle->execute();
                $prestamo_detalle = $detalle->get_result()->fetch_assoc();

                $mensaje = "✅ Préstamo registrado correctamente.";
                $detalle->close();
            } else {
                $mensaje = "❌ Error al registrar el préstamo.";
            }

            $stmt->close();
            $update->close();
        }
    } else {
        $mensaje = "❌ El libro no existe.";
    }

    $stmt_libro->close();
    $conn->close();
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title>Resultado del Préstamo</title>
  <link rel="stylesheet" href="/css/procesar_prestamo.css">
</head>
<body>
  <div class="detalle-prestamo">
    <img src="/img/INSIGNIA SF.png" alt="Logo" class="logo">
    <h3>Resultado del Préstamo</h3>
    <p><?php echo $mensaje; ?></p>

    <?php if ($prestamo_detalle): ?>
      <hr>
      <?php if (!empty($prestamo_detalle['nombre_alumno'])): ?>
        <p><strong>Alumno:</strong> <?php echo htmlspecialchars($prestamo_detalle['nombre_alumno']); ?></p>
        <p><strong>Curso:</strong> <?php echo htmlspecialchars($prestamo_detalle['nivel'] . ' ' . $prestamo_detalle['seccion']); ?></p>
      <?php else: ?>
        <p><strong>Usuario:</strong> <?php echo htmlspecialchars($prestamo_detalle['rut_usuario']); ?></p>
      <?php endif; ?>
      <p><strong>Libro:</strong> <?php echo htmlspecialchars($prestamo_detalle['titulo']); ?></p>
      <p><strong>Fecha de Préstamo:</strong> <?php echo htmlspecialchars($prestamo_detalle['fecha_prestamo']); ?></p>
      <p><strong>Fecha Estimada de Devolución:</strong> <?php echo htmlspecialchars($prestamo_detalle['fecha_devolucion']); ?></p>
    <?php endif; ?>

    <div style="margin-top: 20px;">
      <a href="/index.php">← Volver a Inicio</a>
    </div>
  </div>
</body>
</html>