<?php

ini_set('display_errors', 1);
error_reporting(E_ALL);

require_once "../config/conexion.php";
require_once "../vendor/autoload.php";

use PhpOffice\PhpSpreadsheet\IOFactory;

$mensaje = "";

// Obtener cursos para los select
$sql_cursos = "SELECT id, nivel, seccion FROM cursos ORDER BY nivel ASC, seccion ASC";
$resultado_cursos = $conn->query($sql_cursos);
$cursos = $resultado_cursos->fetch_all(MYSQLI_ASSOC);

// Registrar nuevo alumno manualmente
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['action'])) {
    if ($_POST['action'] == 'register') {
        $nombre = trim($_POST['nombre_usuario']);
        $rut = trim($_POST['rut_usuario']);
        $clave = $_POST['contraseña'];
        $curso_id = intval($_POST['curso_id']);

        if (!empty($nombre) && !empty($rut) && !empty($clave) && $curso_id > 0) {
            $sql_check = "SELECT id FROM alumnos WHERE rut = ?";
            $stmt_check = $conn->prepare($sql_check);
            $stmt_check->bind_param("s", $rut);
            $stmt_check->execute();
            $stmt_check->store_result();

            if ($stmt_check->num_rows > 0) {
                $mensaje = "⚠️ El RUT ya existe.";
            } else {
                $clave_hash = password_hash($clave, PASSWORD_DEFAULT);

                $sql = "INSERT INTO alumnos (nombre_alumno, rut, contraseña, curso_id, activo) 
                        VALUES (?, ?, ?, ?, 1)";
                $stmt = $conn->prepare($sql);
                $stmt->bind_param("sssi", $nombre, $rut, $clave_hash, $curso_id);

                if ($stmt->execute()) {
                    header("Location: registro_alumnos.php?registro=ok");
                    exit();
                } else {
                    $mensaje = "❌ Error al registrar alumno.";
                }
            }

            $stmt_check->close();
        } else {
            $mensaje = "⚠️ Por favor, completa todos los campos correctamente.";
        }
    }

// Importar desde Excel
elseif ($_POST['action'] == 'import_excel') {
    $curso_excel = intval($_POST['curso_excel']);

    if (isset($_FILES['excel_file']) && $_FILES['excel_file']['error'] == 0 && $curso_excel > 0) {
        $archivoExcel = $_FILES['excel_file']['tmp_name'];
        $spreadsheet = IOFactory::load($archivoExcel);
        $sheet = $spreadsheet->getActiveSheet();
        $rows = $sheet->toArray();

        $rowCount = 0;

        foreach ($rows as $index => $row) {
            if ($index == 0) continue; // Saltar encabezado

            $nombre = trim($row[0]) . ' ' . trim($row[1]) . ' ' . trim($row[2]); // Nombre completo
            $rut = trim($row[3]);
            $clave = trim($row[4]);
            $activo = isset($row[5]) ? intval($row[5]) : 1;

            if ($nombre && $rut && $clave !== '') {
                $clave_hash = password_hash($clave, PASSWORD_DEFAULT);
                $id_rol = 3; // Rol alumno

                // Verificar si ya existe el alumno
                $sql_check = "SELECT id FROM alumnos WHERE rut = ?";
                $stmt_check = $conn->prepare($sql_check);
                $stmt_check->bind_param("s", $rut);
                $stmt_check->execute();
                $stmt_check->store_result();

                if ($stmt_check->num_rows > 0) {
                    // Ya existe: hacer UPDATE
                    $sql_update = "UPDATE alumnos SET nombre_alumno = ?, contraseña = ?, curso_id = ?, activo = ?, id_rol = ? WHERE rut = ?";
                    $stmt_update = $conn->prepare($sql_update);
                    $stmt_update->bind_param("sssiss", $nombre, $clave_hash, $curso_excel, $activo, $id_rol, $rut);
                    if ($stmt_update->execute()) {
                        $rowCount++;
                    } else {
                        echo "❌ Error al actualizar alumno RUT $rut: " . $stmt_update->error . "<br>";
                    }
                    $stmt_update->close();
                } else {
                    // No existe: hacer INSERT
                    $sql_insert = "INSERT INTO alumnos (nombre_alumno, rut, contraseña, curso_id, activo, id_rol) 
                                   VALUES (?, ?, ?, ?, ?, ?)";
                    $stmt_insert = $conn->prepare($sql_insert);
                    $stmt_insert->bind_param("sssiii", $nombre, $rut, $clave_hash, $curso_excel, $activo, $id_rol);
                    if ($stmt_insert->execute()) {
                        $rowCount++;
                    } else {
                        echo "❌ Error al insertar alumno RUT $rut: " . $stmt_insert->error . "<br>";
                    }
                    $stmt_insert->close();
                }

                $stmt_check->close();
            }
        }

        $mensaje = "✅ Se importaron o actualizaron $rowCount alumnos correctamente.";
    } else {
        $mensaje = "❌ Error al cargar el archivo o curso no seleccionado.";
    }
}
}

// Obtener alumnos registrados
$sql_usuarios = "SELECT id, nombre_alumno, rut, curso_id FROM alumnos";
$resultado = $conn->query($sql_usuarios);
$usuarios = $resultado->fetch_all(MYSQLI_ASSOC);
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Registrar Alumno</title>
    <link rel="stylesheet" href="/css/registro_usuarios.css">
</head>
<body>

<div class="registro-container">
    <img src="/img/INSIGNIA SF.png" alt="Logo" class="logo">
    <h2>Registrar Nuevo Alumno</h2>

    <?php if ($mensaje): ?>
        <div class="mensaje"><?php echo $mensaje; ?></div>
    <?php endif; ?>

    <!-- Registro individual -->
    <form method="POST">
        <input type="hidden" name="action" value="register">

        <label for="rut_usuario">RUT del Alumno:</label>
        <input type="text" name="rut_usuario" id="rut_usuario" required>

        <label for="nombre_usuario">Nombre Completo:</label>
        <input type="text" name="nombre_usuario" id="nombre_usuario" required>

        <label for="contraseña">Contraseña:</label>
        <input type="password" name="contraseña" id="contraseña" required>

        <label for="curso_id">Curso del Alumno:</label>
        <select name="curso_id" id="curso_id" required>
            <option value="">-- Selecciona un curso --</option>
            <?php foreach ($cursos as $curso): ?>
                <option value="<?php echo $curso['id']; ?>">
                    <?php echo htmlspecialchars($curso['nivel'] . "° " . strtoupper($curso['seccion'])); ?>
                </option>
            <?php endforeach; ?>
        </select>

        <button type="submit">Registrar Alumno</button>
    </form>

    <hr>

    <!-- Formulario de importación -->
<h3>Importar Alumnos desde Excel (.xlsx)</h3>
<form method="POST" enctype="multipart/form-data">
    <input type="hidden" name="action" value="import_excel">

    <label for="excel_file">Selecciona el archivo Excel:</label>
    <input type="file" name="excel_file" id="excel_file" accept=".xlsx" required>

    <label for="curso_excel">Curso para los alumnos del archivo:</label>
    <select name="curso_excel" id="curso_excel" required>
        <option value="">-- Selecciona un curso --</option>
        <?php foreach ($cursos as $curso): ?>
            <option value="<?php echo $curso['id']; ?>">
                <?php echo htmlspecialchars($curso['nivel'] . "° " . strtoupper($curso['seccion'])); ?>
            </option>
        <?php endforeach; ?>
    </select>

    <button type="submit">📥 Importar Archivo</button>
</form>

    <div class="botones-container">
        <a href="../controllers/lista_usuarios.php" class="btn-ver-usuarios">👥 Alumnos Registrados</a>
        <a href="/index.php" class="volver-btn">🏠 Volver al Inicio</a>
    </div>
</div>

<script src="/js/notificacion_registro.js"></script>

</body>
</html>