<?php
// Incluir conexión a la base de datos
require_once "../config/conexion.php";

$mensaje = "";

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Obtener los datos del formulario
    $nombre = trim($_POST['nombre']);
    $fecha_nacimiento = $_POST['fecha_nacimiento'];
    $pais_origen = $_POST['pais_origen'];

    // Validar campos básicos
    if (!empty($nombre) && !empty($fecha_nacimiento) && !empty($pais_origen)) {
        // Insertar el nuevo autor en la base de datos
        $sql = "INSERT INTO autores (nombre, fecha_nacimiento, pais_origen) 
                VALUES (?, ?, ?)";

        $stmt = $conn->prepare($sql);
        $stmt->bind_param("sss", $nombre, $fecha_nacimiento, $pais_origen);

        if ($stmt->execute()) {
            $mensaje = "✅ Autor registrado exitosamente.";
        } else {
            $mensaje = "❌ Error al registrar el autor.";
        }
        $stmt->close();
    } else {
        $mensaje = "⚠️ Por favor, completa todos los campos requeridos.";
    }
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Registrar Autor</title>
    <link rel="stylesheet" href="/css/registro_autores.css">
</head>
<body>

<div class="registro-container">
    <h2>Registrar Autor de Libro</h2>

    <!-- Mostrar mensaje si hay -->
    <?php if ($mensaje): ?>
        <div class="mensaje"><?php echo $mensaje; ?></div>
    <?php endif; ?>

    <!-- Formulario para registrar autor -->
    <form method="POST">
        <label for="nombre">Nombre del Autor:</label>
        <input type="text" name="nombre" id="nombre" required>

        <label for="fecha_nacimiento">Fecha de Nacimiento:</label>
        <input type="date" name="fecha_nacimiento" id="fecha_nacimiento" required>

        <label for="pais_origen">País de Origen:</label>
        <input type="text" name="pais_origen" id="pais_origen" required>

        <button type="submit">Registrar Autor</button>
    </form>

    <!-- Enlace para volver al inicio -->
    <div class="volver-container">
        <a href="../public/index.php" class="volver-btn">🏠 Volver al Inicio</a>
    </div>
</div>

</body>
</html>

<?php
// Cerrar conexión a la base de datos
$conn->close();
?>
