<?php
session_start();
require_once "config/conexion.php";

// Redirige si ya hay sesión activa
if (isset($_SESSION['nombre_usuario']) && isset($_SESSION['id_rol'])) {
    $rol = (int) $_SESSION['id_rol'];
    switch ($rol) {
        case 1:
            header("Location: index.php"); // Admin
            break;
        case 2:
            header("Location: dashboard_funcionario.php"); // Funcionario
            break;
        default:
            header("Location: login.php?error=rol_desconocido");
            break;
    }
    exit();
}

// Procesar formulario
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $rut = $_POST['username']; // RUT del usuario
    $clave = $_POST['password']; // Contraseña ingresada

    // Limpiar el RUT para eliminar puntos, pero mantener el guion
    $rut_limpio = preg_replace('/[^0-9kK\-]/', '', $rut);

    $sql = "SELECT * FROM usuarios WHERE rut_usuario = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("s", $rut_limpio);
    $stmt->execute();
    $resultado = $stmt->get_result();

    if ($resultado->num_rows === 1) {
        $fila = $resultado->fetch_assoc();

        if (password_verify($clave, $fila['contraseña'])) {
            // Inicio de sesión correcto
            $_SESSION['id_usuario'] = $fila['id'];
            $_SESSION['nombre_usuario'] = $fila['nombre_usuario'];
            $_SESSION['id_rol'] = $fila['id_rol'];

            switch ($fila['id_rol']) {
                case 1:
                    header("Location: index.php");
                    break;
                case 2:
                    header("Location: ../views/dashboard_funcionario.php");
                    break;
                case 3:
                    header("Location: ../views/dashboard_user.php");
                    break;
                default:
                    $error = "Rol no reconocido.";
                    break;
            }
            exit();
        } else {
            $error = "Contraseña incorrecta.";
        }
    } else {
        $error = "Usuario no encontrado.";
    }    
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="/css/login.css">
    <title>Login</title>
</head>
<body>

    <div class="wrapper">
        <img src="/img/INSIGNIA SF.png" alt="Logo" class="logo">
        <div class="title">Inicia Sesión</div>

        <?php if (!empty($error)) : ?>
            <p style="color:red; text-align:center;"><?php echo $error; ?></p>
        <?php endif; ?>

        <form method="POST">
            <div class="field">
            <input type="text" name="username" required>
                <label>Rut del Usuario</label>
            </div>

            <div class="field password-field">
                <input type="password" name="password" id="contraseña" required>
                <label>Contraseña</label>
                <span class="toggle-password" onclick="togglePassword()" title="Mostrar u ocultar contraseña">
                    <svg id="icon-eye" xmlns="http://www.w3.org/2000/svg" height="20" width="20" fill="#555" viewBox="0 0 20 20">
                        <path d="M10 4.5c-5.5 0-9 5.5-9 5.5s3.5 5.5 9 5.5 9-5.5 9-5.5-3.5-5.5-9-5.5zm0 9c-1.93 0-3.5-1.57-3.5-3.5S8.07 6.5 10 6.5s3.5 1.57 3.5 3.5S11.93 13.5 10 13.5z"/>
                        <circle cx="10" cy="10" r="2.5"/>
                    </svg>
                    <svg id="icon-eye-off" xmlns="http://www.w3.org/2000/svg" height="20" width="20" fill="#555" viewBox="0 0 20 20" style="display:none;">
                        <path d="M4.03 3.47L2.61 4.89l2.43 2.42A8.834 8.834 0 0 0 1 10s3.5 5.5 9 5.5c1.61 0 3.1-.43 4.41-1.18l2.56 2.56 1.41-1.41L4.03 3.47zM10 13.5c-1.93 0-3.5-1.57-3.5-3.5 0-.48.1-.93.27-1.35l1.58 1.58c.08.91.84 1.67 1.75 1.75l1.58 1.58c-.42.17-.87.27-1.35.27zm3.23-1.15l-1.58-1.58a2.5 2.5 0 0 0-3.07-3.07L6.61 6.12A8.502 8.502 0 0 1 10 4.5c5.5 0 9 5.5 9 5.5a9.05 9.05 0 0 1-5.77 4.83l-1.01-1.48z"/>
                    </svg>
                </span>
            </div>
            
            <div class="field">
                <input type="submit" value="Ingresar">
            </div>
        </form>
    </div>

    <script src="../js/login.js"></script>
</body>
</html>