<?php
header('Content-Type: text/html; charset=utf-8'); // Establecer la codificación de caracteres

include '../includes/db.php';
include '../includes/auth.php';
checkAuth();
if (!isAdmin()) {
    header("Location: index.php");
    exit();
}

// Establecer la codificación de caracteres para la conexión de la base de datos
$conn->set_charset("utf8");

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $nombre = $_POST['nombre'];
    $rut = $_POST['rut'];
    $contrasena = password_hash($_POST['contrasena'], PASSWORD_BCRYPT);
    $curso = $_POST['curso'];

    $sql = "INSERT INTO usuarios (nombre, rut, contrasena, rol, curso) VALUES ('$nombre', '$rut', '$contrasena', 'profesor', '$curso')";
    $conn->query($sql);
    header("Location: add_teacher.php");
}

$profesores = $conn->query("SELECT * FROM usuarios WHERE rol='profesor'");
?>
<!DOCTYPE html>
<html>
<head>
    <title>Agregar Profesor</title>
    <link rel="stylesheet" type="text/css" href="css/style.css">
    <meta charset="UTF-8"> <!-- Establecer la codificación de caracteres en HTML -->
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
</head>
<body>
    <header>
        <h1>Agregar Profesor</h1>
    </header>
    <nav>
        <ul>
            <li><a href="index.php">Inicio</a></li>
            <li><a href="schedule.php">Agendar Horas</a></li>
            <li><a href="logout.php">Cerrar Sesión</a></li>
            <?php if (isAdmin()): ?>
                <li><a href="admin.php">Administrar Usuarios</a></li>
                <li><a href="reports.php">Generar Informes</a></li>
                <li><a href="add_subject.php">Agregar Asignaturas</a></li>
                <li><a href="add_grade.php">Agregar Notas</a></li>
                <li><a href="add_teacher.php">Agregar Profesor</a></li>
            <?php endif; ?>
            <?php if ($_SESSION['rol'] == 'profesor'): ?>
                <li><a href="add_subject.php">Agregar Asignaturas</a></li>
                <li><a href="add_grade.php">Agregar Notas</a></li>
                <li><a href="add_student.php">Agregar Alumnos</a></li>
            <?php endif; ?>
        </ul>
    </nav>
    <main>
        <form method="POST" action="add_teacher.php">
            <label for="nombre">Nombre del Profesor:</label>
            <input type="text" id="nombre" name="nombre" required>
            <label for="rut">RUT:</label>
            <input type="text" id="rut" name="rut" required>
            <label for="contrasena">Contraseña:</label>
            <input type="password" id="contrasena" name="contrasena" required>
            <label for="curso">Curso:</label>
            <input type="text" id="curso" name="curso" required>
            <button type="submit">Agregar Profesor</button>
        </form>
        <h2>Profesores Existentes</h2>
        <ul>
            <?php while ($row = $profesores->fetch_assoc()): ?>
                <li><?php echo htmlspecialchars($row['nombre'], ENT_QUOTES, 'UTF-8'); ?> (<?php echo htmlspecialchars($row['curso'], ENT_QUOTES, 'UTF-8'); ?>) - RUT: <?php echo htmlspecialchars($row['rut'], ENT_QUOTES, 'UTF-8'); ?></li>
            <?php endwhile; ?>
        </ul>
    </main>
</body>
</html>
