<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Respaldo de Base de Datos</title>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="../css/respaldo.css">
    <style>

    </style>
</head>
<body>
    <header>
    <img src="../images/INSIGNIA SF.png" alt="Escuela Porongo Insignia">
    <h1>Respaldo de Base de Datos</h1>

<nav>
        <ul>
            <li><a href="../index.php">Inicio</a></li>
            <li><a href="datos.php">Volver</a></li>
        </ul>
    </nav>
    </header>
    

    <form id="backupForm">
        <button type="submit">📦 Realizar Respaldo</button>
    </form>

    <div class="progress-container" id="progressContainer">
        <div class="progress-bar" id="progressBar"></div>
        <div class="progress-text" id="progressText">0%</div>
    </div>

    <div class="message" id="resultMessage"></div>

    <script>
        document.getElementById('backupForm').addEventListener('submit', function(e) {
            e.preventDefault();

            const progressBar = document.getElementById('progressBar');
            const progressText = document.getElementById('progressText');
            const progressContainer = document.getElementById('progressContainer');
            const resultMessage = document.getElementById('resultMessage');

            progressContainer.style.display = 'block';
            progressBar.style.width = '0%';
            progressText.textContent = '0%';
            resultMessage.textContent = '';
            resultMessage.className = 'message';

            let progress = 0;
            const simulateProgress = setInterval(() => {
                if (progress < 90) {
                    progress += Math.floor(Math.random() * 4) + 1;
                    progressBar.style.width = progress + '%';
                    progressText.textContent = progress + '%';
                }
            }, 150);

            fetch('hacer_respaldo.php')
                .then(response => response.json())
                .then(data => {
                    clearInterval(simulateProgress);
                    progressBar.style.width = '100%';
                    progressText.textContent = '100%';

                    resultMessage.textContent = data.message;
                    if (data.type === 'error') {
                        resultMessage.classList.add('error');
                    }

                    setTimeout(() => {
                        window.location.href = '../index.php';
                    }, 3000);
                })
                .catch(error => {
                    clearInterval(simulateProgress);
                    resultMessage.textContent = 'Error en la solicitud: ' + error;
                    resultMessage.classList.add('error');
                });
        });
    </script>
</body>
</html>
