<?php
$host = 'srv57.benzahosting.cl';
$usuario = 'escuel94_admin';
$contrasena = '8vG#KLccT0_*';
$base_datos = 'escuel94_escuela';

$nombre_archivo = 'respaldo_' . date('Y-m-d_H-i-s') . '.sql';

$conexion = new mysqli($host, $usuario, $contrasena, $base_datos);

// Verifica la conexión
if ($conexion->connect_error) {
    die("Error de conexión: " . $conexion->connect_error);
}

// Obtiene todas las tablas de la base de datos
$tablas = array();
$resultado = $conexion->query('SHOW TABLES');
while ($fila = $resultado->fetch_row()) {
    $tablas[] = $fila[0];
}

$sql = "-- Respaldo de la base de datos $base_datos\n";
$sql .= "-- Fecha: " . date('Y-m-d H:i:s') . "\n\n";
$sql .= "SET FOREIGN_KEY_CHECKS=0;\n\n"; // Opcional, ayuda con relaciones

// Exporta cada tabla
foreach ($tablas as $tabla) {
    $sql .= "-- Estructura de la tabla: $tabla\n";
    $sql .= "DROP TABLE IF EXISTS `$tabla`;\n"; // <-- Esto es lo nuevo

    $resultado = $conexion->query("SHOW CREATE TABLE `$tabla`");
    $fila = $resultado->fetch_row();
    $sql .= $fila[1] . ";\n\n";

    // Exporta los datos de la tabla
    $resultado = $conexion->query("SELECT * FROM `$tabla`");
    while ($fila = $resultado->fetch_assoc()) {
        $valores = array_map(function ($valor) use ($conexion) {
            return $valor === null ? "NULL" : "'" . $conexion->real_escape_string($valor) . "'";
        }, array_values($fila));

        $sql .= "INSERT INTO `$tabla` (`" . implode("`, `", array_keys($fila)) . "`) VALUES (" . implode(", ", $valores) . ");\n";
    }
    $sql .= "\n\n";
}

$sql .= "SET FOREIGN_KEY_CHECKS=1;\n";

// Cierra la conexión a la base de datos
$conexion->close();

// Enviar encabezados para descarga
header('Content-Type: application/octet-stream');
header("Content-Disposition: attachment; filename=\"$nombre_archivo\"");
header('Pragma: no-cache');
header('Expires: 0');

// Imprime el contenido SQL y lo envía al navegador para descargar
echo $sql;
exit;
?>
