<?php
include '../includes/db.php';
require '../vendor/autoload.php'; // Asegúrate de que PhpSpreadsheet esté instalado

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

// Crear hoja de cálculo
$spreadsheet = new Spreadsheet();
$sheet = $spreadsheet->getActiveSheet();

// Encabezados
$sheet->setCellValue('A1', 'Fecha Préstamo');
$sheet->setCellValue('B1', 'Fecha Devolución');
$sheet->setCellValue('C1', 'Equipo');
$sheet->setCellValue('D1', 'Usuario');
$sheet->setCellValue('E1', 'Estado');

// Consulta de préstamos
$query = "
    SELECT p.fecha_prestamo, p.fecha_devolucion, e.nombre_equipo,
           CONCAT(u.nombre, ' ', u.apellido_paterno, ' ', u.apellido_materno) AS nombre_completo, p.estado
    FROM prestamos p
    JOIN equipo e ON p.equipo_id = e.id
    JOIN usuario u ON p.usuario_id = u.id
    WHERE u.id NOT IN (SELECT id FROM usuario WHERE rol_id = (SELECT id FROM roles WHERE nombre = 'Estudiante'))
    ORDER BY p.fecha_prestamo DESC
";
$result = $conn->query($query);

$fila = 2;
while ($row = $result->fetch_assoc()) {
    $sheet->setCellValue("A$fila", $row['fecha_prestamo']);
    $sheet->setCellValue("B$fila", $row['fecha_devolucion'] ?: 'N/A');
    $sheet->setCellValue("C$fila", $row['nombre_equipo']);
    $sheet->setCellValue("D$fila", $row['nombre_completo']);
    $sheet->setCellValue("E$fila", $row['estado']);
    $fila++;
}

// Descargar archivo
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment;filename="prestamos.xlsx"');
header('Cache-Control: max-age=0');

$writer = new Xlsx($spreadsheet);
$writer->save('php://output');
exit;
