<?php
header('Content-Type: text/html; charset=utf-8');

session_start();

include '../includes/db.php';
include '../includes/auth.php';
checkAuth();

if (!isAdmin()) {
    header("Location: ../index.php");
    exit();
}

error_reporting(E_ALL);
ini_set('display_errors', 1);

$message = '';
$message_type = '';

// Manejo de creación de roles
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['crear_rol'])) {
    $nombre_rol = trim(filter_input(INPUT_POST, 'nombre_rol', FILTER_SANITIZE_SPECIAL_CHARS));

    if (empty($nombre_rol)) {
        $message = "Error: El nombre del rol no puede estar vacío o contener solo espacios.";
        $message_type = 'error';
    } else {
        $stmt = $conn->prepare("SELECT id FROM roles WHERE nombre = ?");
        $stmt->bind_param("s", $nombre_rol);
        $stmt->execute();
        $stmt->store_result();

        if ($stmt->num_rows > 0) {
            $message = "Error: El rol ya existe.";
            $message_type = 'error';
        } else {
            $stmt->close();
            $stmt = $conn->prepare("INSERT INTO roles (nombre) VALUES (?)");
            $stmt->bind_param("s", $nombre_rol);

            if ($stmt->execute()) {
                $message = "Rol creado exitosamente.";
                $message_type = 'success';
            } else {
                $message = "Error: " . $stmt->error;
                $message_type = 'error';
            }
            $stmt->close();
        }
    }
}

// Manejo de edición de roles
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['editar_rol'])) {
    $rol_id = filter_input(INPUT_POST, 'rol_id', FILTER_VALIDATE_INT);
    $nombre_rol = trim(filter_input(INPUT_POST, 'nombre_rol', FILTER_SANITIZE_SPECIAL_CHARS));

    if (empty($nombre_rol)) {
        $message = "Error: El nombre del rol no puede estar vacío o contener solo espacios.";
        $message_type = 'error';
    } else {
        $stmt = $conn->prepare("UPDATE roles SET nombre = ? WHERE id = ?");
        $stmt->bind_param("si", $nombre_rol, $rol_id);

        if ($stmt->execute()) {
            $message = "Rol actualizado exitosamente.";
            $message_type = 'success';
        } else {
            $message = "Error: " . $stmt->error;
            $message_type = 'error';
        }
        $stmt->close();
    }
}

// Manejo de eliminación de roles
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['eliminar_rol'])) {
    $rol_id = filter_input(INPUT_POST, 'rol_id', FILTER_VALIDATE_INT);

    if ($rol_id) {
        $stmt = $conn->prepare("DELETE FROM roles WHERE id = ?");
        $stmt->bind_param("i", $rol_id);

        if ($stmt->execute()) {
            $message = "Rol eliminado exitosamente.";
            $message_type = 'success';
        } else {
            $message = "Error al eliminar el rol: " . $stmt->error;
            $message_type = 'error';
        }
        $stmt->close();
    } else {
        $message = "Error: No se pudo determinar el ID del rol.";
        $message_type = 'error';
    }
}

// Consultar roles existentes
$roles = $conn->query("SELECT id, nombre FROM roles");

if ($roles === FALSE) {
    die("Error al obtener los roles: " . $conn->error);
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Gestionar Roles</title>
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Roboto:400,700&display=swap">
    <link rel="stylesheet" href="../css/admin.css">
    
</head>
<body>

<header>
    <img src="../images/INSIGNIA%20SF.png" alt="Logo de la Empresa">
    <h1>Gestión de Roles</h1>
    <nav>
        <ul>
            <li><a href="../index.php">Inicio</a></li>

        </ul>
    </nav>
</header>

<main>
    <?php if ($message): ?>
        <div class="mensaje <?= $message_type ?> show">
            <?= $message ?>
        </div>
    <?php endif; ?>

    <form method="post">
        <label for="nombre_rol">Nombre del Rol:</label>
        <input type="text" id="nombre_rol" name="nombre_rol" required>
        <button type="submit" name="crear_rol">Crear Rol</button>
    </form>

    <h2>Roles Existentes</h2>
    <table>
        <thead>
            <tr>
                <th>ID</th>
                <th>Nombre</th>
                <th>Acciones</th>
            </tr>
        </thead>
        <tbody>
            <?php while ($rol = $roles->fetch_assoc()): ?>
                <tr>
                    <form method="post">
                        <input type="hidden" name="rol_id" value="<?= $rol['id'] ?>">
                        <td><?= $rol['id'] ?></td>
                        <td><input type="text" name="nombre_rol" value="<?= $rol['nombre'] ?>" required></td>
                        <td class="actions">
                            <button type="submit" name="editar_rol" class="btn btn-edit">Guardar</button>
                            <button type="submit" name="eliminar_rol" class="btn btn-delete" onclick="return confirm('¿Estás seguro de que deseas eliminar este rol?');">Eliminar</button>
                        </td>
                    </form>
                </tr>
            <?php endwhile; ?>
        </tbody>
    </table>
</main>

<script>
    // Mensaje de error o éxito
    setTimeout(function() {
        const mensaje = document.querySelector('.mensaje');
        if (mensaje) {
            mensaje.classList.remove('show');
        }
    }, 3000);
</script>

</body>
</html>
