<?php
header('Content-Type: application/json');

$host = 'srv57.benzahosting.cl';
$user = 'escuel94_admin';
$password = '8vG#KLccT0_*';
$dbname = 'escuel94_escuela';

$message = '';
$message_type = '';

try {
    if (!file_exists('respaldos')) {
        mkdir('respaldos', 0777, true);
    }

    $backup_file = 'respaldos/' . $dbname . '_backup_' . date('Y-m-d_H-i-s') . '.sql';

    $connection = new mysqli($host, $user, $password, $dbname);
    if ($connection->connect_error) {
        throw new Exception("Conexión fallida: " . $connection->connect_error);
    }

    $result = $connection->query("SHOW TABLES");
    if ($result === false) {
        throw new Exception("Error obteniendo las tablas: " . $connection->error);
    }

    $backup_content = '';

    while ($row = $result->fetch_row()) {
        $table = $row[0];

        $create_table_query = $connection->query("SHOW CREATE TABLE $table");
        if ($create_table_query === false) {
            throw new Exception("Error creando la tabla $table: " . $connection->error);
        }
        $create_table_sql = $create_table_query->fetch_row()[1];

        $backup_content .= "\n\nDROP TABLE IF EXISTS `$table`;\n";
        $backup_content .= $create_table_sql . ";\n\n";

        $table_data = $connection->query("SELECT * FROM $table");
        if ($table_data === false) {
            throw new Exception("Error obteniendo los datos de $table: " . $connection->error);
        }

        while ($data_row = $table_data->fetch_row()) {
            $backup_content .= "INSERT INTO `$table` VALUES(";
            $values = array_map(function($value) use ($connection) {
                return isset($value) ? "'" . $connection->real_escape_string($value) . "'" : "NULL";
            }, $data_row);
            $backup_content .= implode(", ", $values) . ");\n";
        }

        $backup_content .= "\n\n";
    }

    $connection->close();

    if (file_put_contents($backup_file, $backup_content) === false) {
        throw new Exception("No se pudo escribir el respaldo en el archivo.");
    }

    $message = "Respaldo completado con éxito: $backup_file";
    $message_type = "success";

} catch (Exception $e) {
    $message = "Error durante el respaldo: " . $e->getMessage();
    $message_type = "error";
}

echo json_encode([
    'type' => $message_type,
    'message' => $message
]);
exit;
