<?php
session_start();
include '../includes/db.php';
include '../includes/auth.php';
checkAuth();

$conn->set_charset("utf8");

// Obtener todos los roles
$stmt_roles = $conn->prepare("SELECT id, nombre FROM roles");
$stmt_roles->execute();
$result_roles = $stmt_roles->get_result();

// Obtener todos los usuarios
$stmt_usuarios = $conn->prepare("SELECT id, nombre, apellido_paterno, apellido_materno FROM usuario WHERE id NOT IN (SELECT id FROM usuario WHERE rol_id = (SELECT id FROM roles WHERE nombre = 'Estudiante'))");
$stmt_usuarios->execute();
$result_usuarios = $stmt_usuarios->get_result();

// Obtener todos los permisos
$stmt_permisos = $conn->prepare("SELECT id, nombre FROM permisos");
$stmt_permisos->execute();
$result_permisos = $stmt_permisos->get_result();

// Obtener permisos asignados a un rol o usuario
$permisos_asignados = [];
$rol_id = null;
$usuario_id = null;

if (isset($_POST['rol_id'])) {
    $rol_id = intval($_POST['rol_id']);
    $stmt_permiso_rol = $conn->prepare("SELECT permiso_id FROM roles_permisos WHERE rol_id = ?");
    $stmt_permiso_rol->bind_param("i", $rol_id);
    $stmt_permiso_rol->execute();
    $result_permiso_rol = $stmt_permiso_rol->get_result();

    while ($row = $result_permiso_rol->fetch_assoc()) {
        $permisos_asignados[] = $row['permiso_id'];
    }
}

if (isset($_POST['usuario_id'])) {
    $usuario_id = intval($_POST['usuario_id']);
    $stmt_permiso_usuario = $conn->prepare("SELECT permiso_id FROM usuario_permisos WHERE usuario_id = ?");
    $stmt_permiso_usuario->bind_param("i", $usuario_id);
    $stmt_permiso_usuario->execute();
    $result_permiso_usuario = $stmt_permiso_usuario->get_result();

    while ($row = $result_permiso_usuario->fetch_assoc()) {
        $permisos_asignados[] = $row['permiso_id'];
    }
}

// Guardar permisos asignados
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['guardar_permisos'])) {
    $permisos = isset($_POST['permisos']) ? $_POST['permisos'] : [];

    if ($rol_id) {
        $stmt_eliminar = $conn->prepare("DELETE FROM roles_permisos WHERE rol_id = ?");
        $stmt_eliminar->bind_param("i", $rol_id);
        $stmt_eliminar->execute();

        foreach ($permisos as $permiso_id) {
            $stmt_insertar = $conn->prepare("INSERT INTO roles_permisos (rol_id, permiso_id) VALUES (?, ?)");
            $stmt_insertar->bind_param("ii", $rol_id, $permiso_id);
            $stmt_insertar->execute();
        }
    }

    if ($usuario_id) {
        $stmt_eliminar = $conn->prepare("DELETE FROM usuario_permisos WHERE usuario_id = ?");
        $stmt_eliminar->bind_param("i", $usuario_id);
        $stmt_eliminar->execute();

        foreach ($permisos as $permiso_id) {
            $stmt_insertar = $conn->prepare("INSERT INTO usuario_permisos (usuario_id, permiso_id) VALUES (?, ?)");
            $stmt_insertar->bind_param("ii", $usuario_id, $permiso_id);
            $stmt_insertar->execute();
        }
    }

    header("Location: permisos.php?mensaje=Permisos actualizados correctamente");
    exit();
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="../css/permisos.css">
    <title>Gestión de Permisos</title>
    <style>
        
    </style>
</head>
<body>

<header>
    <img src="../images/INSIGNIA SF.png" alt="Escuela Porongo Insignia">
    <h1>Gestión de Permisos</h1>

<nav>
        <ul>
            <li><a href="../index.php">Inicio</a></li>
        </ul>
    </nav>
    </header>
<main>
    <div class="form-container">
        <form method="POST" action="">
            <!-- Selección del Rol -->
            <label for="rol_id">Seleccionar Rol:</label>
            <select name="rol_id" id="rol_id" onchange="this.form.submit()">
                <option value="">Seleccione un rol</option>
                <?php
                while ($rol = $result_roles->fetch_assoc()) {
                    $selected = isset($rol_id) && $rol['id'] == $rol_id ? 'selected' : '';
                    echo "<option value='" . $rol['id'] . "' $selected>" . htmlspecialchars($rol['nombre'], ENT_QUOTES, 'UTF-8') . "</option>";
                }
                ?>
            </select>

            <!-- Selección del Usuario -->
            <label for="usuario_id">Seleccionar Usuario:</label>
            <select name="usuario_id" id="usuario_id" onchange="this.form.submit()">
                <option value="">Seleccione un usuario</option>
                <?php
                while ($usuario = $result_usuarios->fetch_assoc()) {
                    $selected = isset($usuario_id) && $usuario['id'] == $usuario_id ? 'selected' : '';
                    echo "<option value='" . $usuario['id'] . "' $selected>" . htmlspecialchars($usuario['nombre'] . " " . $usuario['apellido_paterno'] . " " . $usuario['apellido_materno'], ENT_QUOTES, 'UTF-8') . "</option>";
                }
                ?>
            </select>

            <?php if ($rol_id || $usuario_id): ?>
                <h3>Permisos Asignados</h3>
                <ul>
                    <?php
                    $result_permisos->data_seek(0);

                    while ($permiso = $result_permisos->fetch_assoc()) {
                        $checked = in_array($permiso['id'], $permisos_asignados) ? 'checked' : '';
                        echo '<li><input type="checkbox" name="permisos[]" value="' . $permiso['id'] . '" ' . $checked . '> ' . htmlspecialchars($permiso['nombre'], ENT_QUOTES, 'UTF-8') . '</li>';
                    }
                    ?>
                </ul>
                <button type="submit" name="guardar_permisos">Guardar Permisos</button>
            <?php endif; ?>
        </form>
    </div>
</main>

</body>
</html>
