<?php
session_start();  // Iniciar la sesión
include '../includes/db.php';
include '../includes/auth.php';
checkAuth();

$usuario_id = $_SESSION['usuario_id'];
$conn->set_charset("utf8");

$message = ''; // Variable para almacenar el mensaje
$message_type = ''; // Variable para el tipo de mensaje (success o error)

// NUEVO: Obtener mensaje de sesión si existe
if (isset($_SESSION['message'])) {
    $message = $_SESSION['message'];
    $message_type = $_SESSION['message_type'];
    unset($_SESSION['message'], $_SESSION['message_type']);
}

// Eliminar préstamo
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['eliminar_prestamo'])) {
    $prestamo_id = intval($_POST['prestamo_id']);

    try {
        $stmt_eliminar = $conn->prepare("DELETE FROM prestamos WHERE id = ?");
        $stmt_eliminar->bind_param("i", $prestamo_id);
        $stmt_eliminar->execute();
        $stmt_eliminar->close();

        $_SESSION['message'] = "Préstamo eliminado exitosamente."; // NUEVO
        $_SESSION['message_type'] = 'success'; // NUEVO
    } catch (Exception $e) {
        $_SESSION['message'] = "Error al eliminar el préstamo: " . $e->getMessage(); // NUEVO
        $_SESSION['message_type'] = 'error'; // NUEVO
    }

    header("Location: prestamo.php");
    exit();
}

// Editar préstamo
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['editar_prestamo'])) {
    $prestamo_id = intval($_POST['prestamo_id']);
    $fecha_prestamo = $_POST['fecha_prestamo'];
    $fecha_devolucion = $_POST['fecha_devolucion'] ?? null;
    $equipo_id = intval($_POST['equipo_id']);
    $usuario_id = intval($_POST['usuario_id']);
    $estado = $_POST['estado'];

    try {
        $stmt_editar = $conn->prepare("UPDATE prestamos SET fecha_prestamo = ?, fecha_devolucion = ?, equipo_id = ?, usuario_id = ?, estado = ? WHERE id = ?");
        $stmt_editar->bind_param("ssissi", $fecha_prestamo, $fecha_devolucion, $equipo_id, $usuario_id, $estado, $prestamo_id);
        $stmt_editar->execute();
        $stmt_editar->close();

        $_SESSION['message'] = "Préstamo actualizado exitosamente."; // NUEVO
        $_SESSION['message_type'] = 'success'; // NUEVO
    } catch (Exception $e) {
        $_SESSION['message'] = "Error al actualizar el préstamo: " . $e->getMessage(); // NUEVO
        $_SESSION['message_type'] = 'error'; // NUEVO
    }

    header("Location: prestamo.php");
    exit();
}

// Agregar préstamo
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['agregar_prestamo'])) {
    $fecha_prestamo = $_POST['fecha_prestamo'];
    $fecha_devolucion = $_POST['fecha_devolucion'] ?? null;
    $equipo_id = intval($_POST['equipo_id']);
    $usuario_id = intval($_POST['usuario_id']);
    $estado = 'Prestado';

    try {
        $stmt_agregar = $conn->prepare("INSERT INTO prestamos (fecha_prestamo, fecha_devolucion, equipo_id, usuario_id, estado) VALUES (?, ?, ?, ?, ?)");
        $stmt_agregar->bind_param("ssiss", $fecha_prestamo, $fecha_devolucion, $equipo_id, $usuario_id, $estado);
        $stmt_agregar->execute();
        $stmt_agregar->close();

        $_SESSION['message'] = "Préstamo agregado exitosamente."; // NUEVO
        $_SESSION['message_type'] = 'success'; // NUEVO
    } catch (Exception $e) {
        $_SESSION['message'] = "Error al agregar el préstamo: " . $e->getMessage(); // NUEVO
        $_SESSION['message_type'] = 'error'; // NUEVO
    }

    header("Location: prestamo.php");
    exit();
}

// Configuración de paginación
$limite = 20; // Número de registros por página
$pagina = isset($_GET['pagina']) ? intval($_GET['pagina']) : 1;
$offset = ($pagina - 1) * $limite;

// Búsqueda
$search_query = "";
if (isset($_GET['search']) && !empty($_GET['search'])) {
    $search_term = '%' . $conn->real_escape_string($_GET['search']) . '%';
    $search_query = " AND (e.nombre_equipo LIKE ? OR CONCAT(u.nombre, ' ', u.apellido_paterno, ' ', u.apellido_materno) LIKE ?)";
}

// Obtener préstamos con paginación y búsqueda
$stmt_prestamos = $conn->prepare("SELECT p.id, p.fecha_prestamo, p.fecha_devolucion, e.nombre_equipo, CONCAT(u.nombre, ' ', u.apellido_paterno, ' ', u.apellido_materno) AS nombre_completo, p.estado 
                                   FROM prestamos p
                                   JOIN equipo e ON p.equipo_id = e.id
                                   JOIN usuario u ON p.usuario_id = u.id
                                   WHERE u.id NOT IN (SELECT id FROM usuario WHERE rol_id = (SELECT id FROM roles WHERE nombre = 'Estudiante')) $search_query
                                   ORDER BY p.fecha_prestamo DESC
                                   LIMIT ?, ?");

if ($search_query) {
    $stmt_prestamos->bind_param("ssii", $search_term, $search_term, $offset, $limite);
} else {
    $stmt_prestamos->bind_param("ii", $offset, $limite);
}
$stmt_prestamos->execute();
$result_prestamos = $stmt_prestamos->get_result();

// Obtener el total de registros
$total_resultados = $conn->query("SELECT COUNT(*) as total FROM prestamos")->fetch_assoc()['total'];
$total_paginas = ceil($total_resultados / $limite);

// Manejo de la edición
$prestamo_a_editar = null;
if (isset($_GET['edit'])) {
    $prestamo_id = intval($_GET['edit']);
    $stmt_edit = $conn->prepare("SELECT * FROM prestamos WHERE id = ?");
    $stmt_edit->bind_param("i", $prestamo_id);
    $stmt_edit->execute();
    $prestamo_a_editar = $stmt_edit->get_result()->fetch_assoc();
    $stmt_edit->close();
}

$equipos_disponibles = $conn->query("
    SELECT e.id, e.nombre_equipo 
    FROM equipo e
    WHERE e.id NOT IN (
        SELECT equipo_id FROM prestamos WHERE estado = 'Prestado'
    )
    ORDER BY e.nombre_equipo ASC
");
$equipo_actual_id = $prestamo_a_editar ? intval($prestamo_a_editar['equipo_id']) : 0;

$equipos_disponibles = $conn->query("
    SELECT e.id, e.nombre_equipo 
    FROM equipo e
    WHERE e.id = $equipo_actual_id
    OR e.id NOT IN (
        SELECT equipo_id FROM prestamos WHERE estado = 'Prestado'
    )
    ORDER BY e.nombre_equipo ASC
");



// Obtener equipos en orden alfabético
$equipos = $conn->query("SELECT id, nombre_equipo FROM equipo ORDER BY nombre_equipo ASC");
// Obtener usuarios disponibles
$stmt_usuario = $conn->prepare("SELECT id, nombre, apellido_paterno, apellido_materno FROM usuario WHERE id NOT IN (SELECT id FROM usuario WHERE rol_id = (SELECT id FROM roles WHERE nombre = 'Estudiante'))");
$stmt_usuario->execute();
$result_usuario = $stmt_usuario->get_result();
$stmt_prestamos->close();
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Préstamo de Equipos</title>
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Roboto:400,700&display=swap">
    <link rel="stylesheet" href="../css/prestamos.css">
    <style>
        
    </style>
    <script>
        function showMessage(message, type) {
        const messageBox = document.getElementById('messageBox');
        messageBox.textContent = message;
        messageBox.className = 'message ' + (type === 'success' ? 'success' : 'error');
        messageBox.style.display = 'block';
        setTimeout(() => {
            messageBox.style.display = 'none';
        }, 3000);
    }

    <?php if (!empty($message)): ?>
    window.onload = function() {
        showMessage('<?php echo htmlspecialchars($message, ENT_QUOTES, 'UTF-8'); ?>', '<?php echo htmlspecialchars($message_type, ENT_QUOTES, 'UTF-8'); ?>');
    }
    <?php endif; ?>
    </script>
</head>
<body>
    <!-- Caja de mensajes -->
<div id="messageBox" style="display: none;"></div>

    <header>
        <img src="../images/INSIGNIA SF.png" alt="Escuela Porongo Insignia">
        <h1>Gestión de Préstamos de Equipos</h1>
    
    <nav>
        <ul>
            <li><a href="../index.php">Inicio</a></li>
        </ul>
    </nav>
        </header>
    <main>
       <div class="form-container">
    <h2><?php echo $prestamo_a_editar ? "Editar Préstamo" : "Agregar Préstamo"; ?></h2>
    <form method="POST" action="">
        <input type="hidden" name="prestamo_id" value="<?php echo $prestamo_a_editar ? htmlspecialchars($prestamo_a_editar['id'], ENT_QUOTES, 'UTF-8') : ''; ?>">
        
        <label for="fecha_prestamo">Fecha de Préstamo:</label>
        <input type="date" name="fecha_prestamo" required 
               value="<?php echo $prestamo_a_editar ? htmlspecialchars($prestamo_a_editar['fecha_prestamo'], ENT_QUOTES, 'UTF-8') : ''; ?>">
        
        <label for="fecha_devolucion">Fecha de Devolución:</label>
        <input type="date" name="fecha_devolucion" 
               value="<?php echo $prestamo_a_editar ? htmlspecialchars($prestamo_a_editar['fecha_devolucion'], ENT_QUOTES, 'UTF-8') : ''; ?>">
        
        <label for="equipo_id">Seleccionar Equipo:</label>
<select name="equipo_id" required>
    <option value="">Seleccione un equipo</option>
    <?php while ($equipo = $equipos_disponibles->fetch_assoc()): ?>
        <option value="<?php echo $equipo['id']; ?>"
            <?php echo ($prestamo_a_editar && $prestamo_a_editar['equipo_id'] == $equipo['id']) ? 'selected' : ''; ?>>
            <?php echo htmlspecialchars($equipo['nombre_equipo'], ENT_QUOTES, 'UTF-8'); ?>
        </option>
    <?php endwhile; ?>
</select>
        
        <label for="usuario_id">Seleccionar Usuario:</label>
        <select name="usuario_id" required>
            <?php while ($usuario = $result_usuario->fetch_assoc()): ?>
                <option value="<?php echo $usuario['id']; ?>" 
                        <?php echo $prestamo_a_editar && $prestamo_a_editar['usuario_id'] == $usuario['id'] ? 'selected' : ''; ?>>
                    <?php echo htmlspecialchars($usuario['nombre'], ENT_QUOTES, 'UTF-8') . " " . htmlspecialchars($usuario['apellido_paterno'], ENT_QUOTES, 'UTF-8') . " " . htmlspecialchars($usuario['apellido_materno'], ENT_QUOTES, 'UTF-8'); ?>
                </option>
            <?php endwhile; ?>
        </select>

        <label for="estado">Estado:</label>
        <select name="estado" required>
            <option value="Prestado" <?php echo $prestamo_a_editar && $prestamo_a_editar['estado'] == 'Prestado' ? 'selected' : ''; ?>>Prestado</option>
            <option value="Devuelto" <?php echo $prestamo_a_editar && $prestamo_a_editar['estado'] == 'Devuelto' ? 'selected' : ''; ?>>Devuelto</option>
        </select>

        <button type="submit" name="<?php echo $prestamo_a_editar ? 'editar_prestamo' : 'agregar_prestamo'; ?>">
            <?php echo $prestamo_a_editar ? 'Actualizar' : 'Agregar'; ?> Préstamo
        </button>
    </form>
</div>
        <!-- Mensajes -->
        <?php if ($message): ?>
        <div id="messageBox" class="<?php echo htmlspecialchars($message_type, ENT_QUOTES, 'UTF-8'); ?>" style="display: none;"></div>
        <?php endif; ?>

        <div class="search-container">
    <h2>Buscar Préstamos</h2>
    <form method="GET" action="">
        <input type="text" name="search" placeholder="Buscar por equipo o usuario" 
               value="<?php echo isset($_GET['search']) ? htmlspecialchars($_GET['search'], ENT_QUOTES, 'UTF-8') : ''; ?>">
        <button type="submit">Buscar</button>
    </form>
</div>
        <div style="margin-top: 20px;">
    <form action="exportar_prestamos.php" method="post">
        <button type="submit" style="padding: 10px 15px; background-color: #4CAF50; color: white; border: none; border-radius: 5px;">
            Descargar Excel
        </button>
    </form>
</div>

<table style="width: 100%; margin-top: 20px; border-collapse: collapse;">
    <thead>
        <tr>
            <!-- <th>ID</th> --> <!-- Comentado para ocultar el encabezado del ID -->
            <th>Fecha Préstamo</th>
            <th>Fecha Devolución</th>
            <th>Equipo</th>
            <th>Usuario</th>
            <th>Estado</th>
            <th>Acciones</th>
        </tr>
    </thead>
    <tbody>
        <?php while ($prestamo = $result_prestamos->fetch_assoc()): ?>
        <tr>
            <!-- <td><?php echo $prestamo['id']; ?></td> --> <!-- Comentado para ocultar el ID -->
            <td><?php echo $prestamo['fecha_prestamo']; ?></td>
            <td><?php echo $prestamo['fecha_devolucion'] ?: 'N/A'; ?></td>
            <td><?php echo htmlspecialchars($prestamo['nombre_equipo'], ENT_QUOTES, 'UTF-8'); ?></td>
            <td><?php echo htmlspecialchars($prestamo['nombre_completo'], ENT_QUOTES, 'UTF-8'); ?></td>
            <td><?php echo htmlspecialchars($prestamo['estado'], ENT_QUOTES, 'UTF-8'); ?></td>
            <td class="actions">
                <a href="?edit=<?php echo $prestamo['id']; ?>">Editar</a>
                <form method="POST" action="" style="display: inline;">
                    <input type="hidden" name="prestamo_id" value="<?php echo $prestamo['id']; ?>">
                    <button type="submit" name="eliminar_prestamo" class="delete" onclick="return confirm('¿Estás seguro de que deseas eliminar este préstamo?');">Eliminar</button>
                </form>
            </td>
        </tr>
        <?php endwhile; ?>
    </tbody>
</table>
        <div class="pagination">
            <?php for ($i = 1; $i <= $total_paginas; $i++): ?>
                <a href="?pagina=<?php echo $i; ?>&search=<?php echo htmlspecialchars($search_query, ENT_QUOTES, 'UTF-8'); ?>"
                   style="padding: 10px; text-decoration: none; color: #3f51b5;"><?php echo $i; ?></a>
            <?php endfor; ?>
        </div>
    </main>
</body>
</html>
