

DROP TABLE IF EXISTS `alergias_alimentarias`;
CREATE TABLE `alergias_alimentarias` (
  `id` int NOT NULL AUTO_INCREMENT,
  `matricula_id` int DEFAULT NULL,
  `alergia` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `matricula_id` (`matricula_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;





DROP TABLE IF EXISTS `apoderados`;
CREATE TABLE `apoderados` (
  `id` int NOT NULL AUTO_INCREMENT,
  `matricula_id` int DEFAULT NULL,
  `rut` varchar(12) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `nombre` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `telefono` varchar(15) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `celular` varchar(15) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `parentesco` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `matricula_id` (`matricula_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;





DROP TABLE IF EXISTS `asignatura`;
CREATE TABLE `asignatura` (
  `id` int NOT NULL AUTO_INCREMENT,
  `nombre` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `asignatura` VALUES('1', 'Lenguaje y Comunicación');
INSERT INTO `asignatura` VALUES('2', 'Matemática');
INSERT INTO `asignatura` VALUES('3', 'Música');
INSERT INTO `asignatura` VALUES('4', 'Artes Visuales');
INSERT INTO `asignatura` VALUES('5', 'Educación Física y Salud');
INSERT INTO `asignatura` VALUES('6', 'Ciencias Naturales');
INSERT INTO `asignatura` VALUES('7', 'Historia, Geografía y Ciencias Sociales');
INSERT INTO `asignatura` VALUES('8', 'Inglés');
INSERT INTO `asignatura` VALUES('9', 'Orientación');
INSERT INTO `asignatura` VALUES('10', 'Religión');
INSERT INTO `asignatura` VALUES('11', 'Lengua y Literatura');
INSERT INTO `asignatura` VALUES('12', 'Tecnología');




DROP TABLE IF EXISTS `curso`;
CREATE TABLE `curso` (
  `id` int NOT NULL AUTO_INCREMENT,
  `nombre` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `profesor_jefe_id` int DEFAULT NULL,
  `activo` tinyint(1) DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `profesor_jefe_id` (`profesor_jefe_id`)
) ENGINE=InnoDB AUTO_INCREMENT=66 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `curso` VALUES('49', 'Pre Kinder A', '250', '1');
INSERT INTO `curso` VALUES('50', 'Kinder A', '242', '1');
INSERT INTO `curso` VALUES('51', 'Kinder B', '274', '1');
INSERT INTO `curso` VALUES('52', '1° Año A', '241', '1');
INSERT INTO `curso` VALUES('53', '1° Año B', '1373', '1');
INSERT INTO `curso` VALUES('54', '2° Año A', '825', '1');
INSERT INTO `curso` VALUES('55', '3° Año A', '273', '1');
INSERT INTO `curso` VALUES('56', '3° Año B', '253', '1');
INSERT INTO `curso` VALUES('57', '4° Año A', '267', '1');
INSERT INTO `curso` VALUES('58', '4° Año B', '259', '1');
INSERT INTO `curso` VALUES('59', '5° Año A', '263', '1');
INSERT INTO `curso` VALUES('60', '5° Año B', '945', '1');
INSERT INTO `curso` VALUES('61', '6° Año A', '269', '1');
INSERT INTO `curso` VALUES('62', '7° Año A', '260', '1');
INSERT INTO `curso` VALUES('63', '7° Año B', '266', '1');
INSERT INTO `curso` VALUES('64', '8° Año A', '257', '1');
INSERT INTO `curso` VALUES('65', '8° Año B', '243', '1');




DROP TABLE IF EXISTS `detalles_equipo`;
CREATE TABLE `detalles_equipo` (
  `id` int NOT NULL AUTO_INCREMENT,
  `equipo_id` int DEFAULT NULL,
  `marca` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `modelo` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `numero_serie` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `procesador` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `memoria_ram` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `almacenamiento` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tarjeta_grafica` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sistema_operativo` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `version_so` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `imagen` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `equipo_id` (`equipo_id`)
) ENGINE=InnoDB AUTO_INCREMENT=64 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `detalles_equipo` VALUES('10', '7', 'HP', '240 G6', '3549-1 0000773', 'i3 6000', '4 GB', '500 GB HDD', 'Integrada', 'Windows 10 LTCS', '64 bits', '../uploads/equipos/68306db4c0b052.64028307.jpg');
INSERT INTO `detalles_equipo` VALUES('11', '8', 'EPSON', 'M100', 'NO POSEE', 'NO APLICA', 'NO APLICA', 'NO APLICA', 'NO APLICA', 'NO APLICA', 'NO APLICA', '../uploads/equipos/68306d87bbb835.71354856.jpg');
INSERT INTO `detalles_equipo` VALUES('16', '13', 'Generico', 'Generico', 'No aplica', 'No aplica', 'No aplica', 'No aplica', 'No aplica', 'No aplica', 'No aplica', '../uploads/equipos/68306d5c8f1694.47971183.webp');
INSERT INTO `detalles_equipo` VALUES('17', '14', 'No aplica', 'No aplica', 'No aplica', 'No aplica', 'No aplica', 'No aplica', 'No aplica', 'No aplica', 'No aplica', '../uploads/equipos/68306d18409941.24762555.webp');
INSERT INTO `detalles_equipo` VALUES('18', '15', 'No aplica', 'No aplica', 'No aplica', 'No aplica', 'No aplica', 'No aplica', 'No aplica', 'No aplica', 'No aplica', '../uploads/equipos/68306d2a643274.28134685.webp');
INSERT INTO `detalles_equipo` VALUES('20', '17', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `detalles_equipo` VALUES('21', '18', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `detalles_equipo` VALUES('22', '19', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `detalles_equipo` VALUES('23', '20', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `detalles_equipo` VALUES('24', '21', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `detalles_equipo` VALUES('25', '22', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `detalles_equipo` VALUES('26', '23', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `detalles_equipo` VALUES('27', '24', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `detalles_equipo` VALUES('28', '25', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `detalles_equipo` VALUES('29', '26', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `detalles_equipo` VALUES('30', '27', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `detalles_equipo` VALUES('31', '28', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `detalles_equipo` VALUES('32', '29', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `detalles_equipo` VALUES('33', '30', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `detalles_equipo` VALUES('34', '31', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `detalles_equipo` VALUES('35', '32', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `detalles_equipo` VALUES('36', '33', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `detalles_equipo` VALUES('37', '34', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `detalles_equipo` VALUES('38', '35', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `detalles_equipo` VALUES('39', '36', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `detalles_equipo` VALUES('40', '37', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `detalles_equipo` VALUES('41', '38', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `detalles_equipo` VALUES('42', '39', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `detalles_equipo` VALUES('43', '40', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `detalles_equipo` VALUES('44', '41', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `detalles_equipo` VALUES('45', '42', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `detalles_equipo` VALUES('46', '43', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `detalles_equipo` VALUES('47', '44', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `detalles_equipo` VALUES('48', '45', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `detalles_equipo` VALUES('49', '46', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `detalles_equipo` VALUES('50', '47', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `detalles_equipo` VALUES('51', '48', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `detalles_equipo` VALUES('52', '49', 'itab', 'SP50W', 'No aplica.', 'No aplica.', 'No aplica.', 'No aplica.', 'No aplica.', 'No aplica.', 'No aplica.', '../uploads/equipos/68306ded701db4.33369923.PNG');
INSERT INTO `detalles_equipo` VALUES('53', '50', 'HP', '240 G6', 'NO POSEE', 'i3 6000', '4 GB', '500 GB HDD', 'Tarjeta Gráfica	Integrada', 'Windows 10 LTCS', '64 bits', '../uploads/equipos/68306dced2be92.59291074.jpg');
INSERT INTO `detalles_equipo` VALUES('54', '51', 'HP', '240 G6', '3549-1 0000456', 'i3 6000', '4 GB', '500 GB HDD', 'Tarjeta Gráfica	Integrada', 'Windows 10 LTCS', '64 bits', '../uploads/equipos/68306ddd559dd9.00794546.jpg');
INSERT INTO `detalles_equipo` VALUES('55', '52', 'Generica', 'Optico USB', 'NO APLICA', 'NO APLICA', 'NO APLICA', 'NO APLICA', 'NO APLICA', 'NO APLICA', 'NO APLICA', '../uploads/equipos/68306da2246893.69358645.webp');
INSERT INTO `detalles_equipo` VALUES('56', '53', 'DATAWORLD', 'NO APLICA', 'DAEM 3549-1 0000484', 'NO APLICA', 'NO APLICA', 'NO APLICA', 'NO APLICA', 'NO APLICA', 'NO APLICA', '../uploads/equipos/68306e06910107.52308324.webp');
INSERT INTO `detalles_equipo` VALUES('57', '54', 'DATAWORLD', 'NO APLICA', 'NO APLICA', 'NO APLICA', 'NO APLICA', 'NO APLICA', 'NO APLICA', 'NO APLICA', 'NO APLICA', '../uploads/equipos/68306e11f330a0.12807175.webp');
INSERT INTO `detalles_equipo` VALUES('60', '57', 'Generico', 'Generico', 'No posee', 'No posee', 'No posee', 'No posee', 'No posee', 'No posee', 'No posee', '../uploads/equipos/68306d50845bf6.60902594.webp');
INSERT INTO `detalles_equipo` VALUES('61', '58', 'e4u', 'Generico', 'Generico', 'Generico', 'Generico', 'Generico', 'Generico', 'Generico', 'Generico', '../uploads/equipos/6818f566ae4d11.53083669.jpg');
INSERT INTO `detalles_equipo` VALUES('62', '59', 'Generico', 'Generico', 'no aplica', 'no aplica', 'no aplica', 'no aplica', 'no aplica', 'no aplica', 'no aplica', '../uploads/equipos/681e18c99a6371.46295239.jpg');
INSERT INTO `detalles_equipo` VALUES('63', '60', 'Generico', 'Generico', 'No aplica', 'No aplica', 'No aplica', 'No aplica', 'No aplica', 'No aplica', 'No aplica', '../uploads/equipos/681e282635fae6.33808231.avif');




DROP TABLE IF EXISTS `equipo`;
CREATE TABLE `equipo` (
  `id` int NOT NULL AUTO_INCREMENT,
  `nombre_equipo` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ubicacion` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `estado_equipo_id` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `estado_equipo_id` (`estado_equipo_id`)
) ENGINE=InnoDB AUTO_INCREMENT=61 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `equipo` VALUES('7', 'Notebook Enlaces 1', 'Laboratorio de Enlaces', '1');
INSERT INTO `equipo` VALUES('8', 'Impresora Epson', 'Laboratorio de Enlaces', '1');
INSERT INTO `equipo` VALUES('13', 'Cable HDMI Negro-Rojo', 'Laboratorio de Enlaces', '1');
INSERT INTO `equipo` VALUES('14', 'Alargador 1', 'Laboratorio de Enlaces', '1');
INSERT INTO `equipo` VALUES('15', 'Alargador 2', 'Laboratorio de Enlaces', '1');
INSERT INTO `equipo` VALUES('49', 'Parlante Bluetooth', 'Laboratorio de Enlaces', '1');
INSERT INTO `equipo` VALUES('50', 'Notebook Enlaces 2', 'Laboratorio de Enlaces', '1');
INSERT INTO `equipo` VALUES('51', 'Notebook Enlaces 3', 'Laboratorio de Enlaces', '1');
INSERT INTO `equipo` VALUES('52', 'Mouse USB Azul', 'Laboratorio de Enlaces', '1');
INSERT INTO `equipo` VALUES('53', 'TELON + PEDESTAL 1', 'Laboratorio de Enlaces', '1');
INSERT INTO `equipo` VALUES('54', 'TELON + PEDESTAL 2', 'Laboratorio de Enlaces', '1');
INSERT INTO `equipo` VALUES('57', 'Cable HDMI Negro', 'Laboratorio de Enlaces', '1');
INSERT INTO `equipo` VALUES('58', 'Maleta Tablet (13)', 'Laboratorio de Enlaces', '1');
INSERT INTO `equipo` VALUES('59', 'Cable Auxiliar', 'Laboratorio de Enlaces', '1');
INSERT INTO `equipo` VALUES('60', 'Cable Tipo C', 'Laboratorio de Enlaces', '1');




DROP TABLE IF EXISTS `estado_equipo`;
CREATE TABLE `estado_equipo` (
  `id` int NOT NULL AUTO_INCREMENT,
  `nombre_estado` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `estado_equipo` VALUES('1', 'Operativo');
INSERT INTO `estado_equipo` VALUES('2', 'En reparación');
INSERT INTO `estado_equipo` VALUES('3', 'Fuera de servicio');
INSERT INTO `estado_equipo` VALUES('4', 'Dado de baja');




DROP TABLE IF EXISTS `familiares`;
CREATE TABLE `familiares` (
  `id` int NOT NULL AUTO_INCREMENT,
  `matricula_id` int DEFAULT NULL,
  `rut` varchar(12) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `nombre` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `apellido_paterno` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `apellido_materno` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `domicilio` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `escolaridad` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `trabaja` tinyint(1) DEFAULT NULL,
  `tipo_trabajo` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `dentro_fuera_hogar` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `parentesco` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `matricula_id` (`matricula_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;





DROP TABLE IF EXISTS `historial_cursos`;
CREATE TABLE `historial_cursos` (
  `id` int NOT NULL AUTO_INCREMENT,
  `usuario_id` int NOT NULL,
  `curso_id` int NOT NULL,
  `fecha` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `usuario_id` (`usuario_id`),
  KEY `curso_id` (`curso_id`),
  CONSTRAINT `historial_cursos_ibfk_1` FOREIGN KEY (`usuario_id`) REFERENCES `usuario` (`id`) ON DELETE CASCADE,
  CONSTRAINT `historial_cursos_ibfk_2` FOREIGN KEY (`curso_id`) REFERENCES `curso` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;





DROP TABLE IF EXISTS `horario`;
CREATE TABLE `horario` (
  `id` int NOT NULL AUTO_INCREMENT,
  `usuario_id` int DEFAULT NULL,
  `fecha` date NOT NULL,
  `hora_inicio` time NOT NULL,
  `hora_fin` time NOT NULL,
  `curso_id` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `usuario_id` (`usuario_id`),
  KEY `curso_id` (`curso_id`)
) ENGINE=InnoDB AUTO_INCREMENT=674 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `horario` VALUES('205', '945', '2025-03-12', '10:20:00', '11:05:00', '59');
INSERT INTO `horario` VALUES('206', '945', '2025-03-12', '11:05:00', '11:50:00', '59');
INSERT INTO `horario` VALUES('207', '945', '2025-03-12', '12:00:00', '12:45:00', '61');
INSERT INTO `horario` VALUES('208', '945', '2025-03-12', '12:45:00', '13:30:00', '61');
INSERT INTO `horario` VALUES('211', '253', '2025-03-13', '10:20:00', '11:05:00', '56');
INSERT INTO `horario` VALUES('212', '253', '2025-03-13', '11:05:00', '11:50:00', '56');
INSERT INTO `horario` VALUES('213', '825', '2025-03-14', '10:20:00', '11:05:00', '54');
INSERT INTO `horario` VALUES('215', '825', '2025-03-14', '11:05:00', '11:50:00', '54');
INSERT INTO `horario` VALUES('216', '825', '2025-03-14', '12:00:00', '12:45:00', '54');
INSERT INTO `horario` VALUES('217', '825', '2025-03-14', '12:45:00', '13:30:00', '54');
INSERT INTO `horario` VALUES('218', '945', '2025-03-12', '15:10:00', '15:55:00', '62');
INSERT INTO `horario` VALUES('219', '945', '2025-03-12', '14:25:00', '15:10:00', '62');
INSERT INTO `horario` VALUES('221', '247', '2025-03-19', '15:10:00', '15:55:00', '59');
INSERT INTO `horario` VALUES('222', '247', '2025-03-19', '14:25:00', '15:10:00', '59');
INSERT INTO `horario` VALUES('223', '241', '2025-03-17', '10:20:00', '11:05:00', '52');
INSERT INTO `horario` VALUES('224', '241', '2025-03-17', '11:05:00', '11:50:00', '52');
INSERT INTO `horario` VALUES('225', '241', '2025-03-17', '12:00:00', '12:45:00', '52');
INSERT INTO `horario` VALUES('226', '241', '2025-03-17', '12:45:00', '13:30:00', '52');
INSERT INTO `horario` VALUES('227', '257', '2025-03-13', '12:00:00', '12:45:00', '62');
INSERT INTO `horario` VALUES('228', '257', '2025-03-13', '12:45:00', '13:30:00', '62');
INSERT INTO `horario` VALUES('230', '257', '2025-03-20', '10:20:00', '11:05:00', '62');
INSERT INTO `horario` VALUES('231', '257', '2025-03-20', '11:05:00', '11:50:00', '62');
INSERT INTO `horario` VALUES('232', '269', '2025-03-17', '08:30:00', '09:15:00', '61');
INSERT INTO `horario` VALUES('233', '269', '2025-03-17', '09:15:00', '10:00:00', '61');
INSERT INTO `horario` VALUES('234', '266', '2025-03-10', '14:25:00', '15:10:00', '65');
INSERT INTO `horario` VALUES('235', '266', '2025-03-10', '15:10:00', '15:55:00', '65');
INSERT INTO `horario` VALUES('237', '253', '2025-03-18', '09:15:00', '10:00:00', '56');
INSERT INTO `horario` VALUES('241', '253', '2025-03-18', '08:30:00', '09:15:00', '56');
INSERT INTO `horario` VALUES('242', '253', '2025-03-19', '10:20:00', '11:05:00', '56');
INSERT INTO `horario` VALUES('243', '253', '2025-03-19', '11:05:00', '11:50:00', '56');
INSERT INTO `horario` VALUES('244', '825', '2025-03-18', '10:20:00', '11:05:00', '54');
INSERT INTO `horario` VALUES('245', '825', '2025-03-18', '11:05:00', '11:50:00', '54');
INSERT INTO `horario` VALUES('246', '257', '2025-03-21', '08:30:00', '09:15:00', '65');
INSERT INTO `horario` VALUES('247', '257', '2025-03-21', '09:15:00', '10:00:00', '65');
INSERT INTO `horario` VALUES('248', '243', '2025-03-19', '12:00:00', '12:45:00', '63');
INSERT INTO `horario` VALUES('249', '243', '2025-03-19', '12:45:00', '13:30:00', '63');
INSERT INTO `horario` VALUES('250', '825', '2025-03-18', '14:25:00', '15:10:00', '54');
INSERT INTO `horario` VALUES('251', '825', '2025-03-18', '15:10:00', '15:55:00', '54');
INSERT INTO `horario` VALUES('252', '825', '2025-03-19', '08:30:00', '09:15:00', '54');
INSERT INTO `horario` VALUES('253', '825', '2025-03-19', '09:15:00', '10:00:00', '54');
INSERT INTO `horario` VALUES('254', '825', '2025-03-21', '10:20:00', '11:05:00', '54');
INSERT INTO `horario` VALUES('255', '825', '2025-03-21', '11:05:00', '11:50:00', '54');
INSERT INTO `horario` VALUES('256', '259', '2025-03-20', '08:30:00', '09:15:00', '58');
INSERT INTO `horario` VALUES('257', '259', '2025-03-20', '09:15:00', '10:00:00', '58');
INSERT INTO `horario` VALUES('258', '259', '2025-03-20', '12:00:00', '12:45:00', '58');
INSERT INTO `horario` VALUES('259', '259', '2025-03-20', '12:45:00', '13:30:00', '58');
INSERT INTO `horario` VALUES('260', '267', '2025-03-25', '08:30:00', '09:15:00', '57');
INSERT INTO `horario` VALUES('261', '267', '2025-03-25', '09:15:00', '10:00:00', '57');
INSERT INTO `horario` VALUES('262', '259', '2025-03-24', '10:20:00', '11:05:00', '58');
INSERT INTO `horario` VALUES('263', '259', '2025-03-24', '11:05:00', '11:50:00', '58');
INSERT INTO `horario` VALUES('264', '259', '2025-03-24', '14:25:00', '15:10:00', '59');
INSERT INTO `horario` VALUES('265', '259', '2025-03-24', '15:10:00', '15:55:00', '59');
INSERT INTO `horario` VALUES('267', '259', '2025-03-25', '12:00:00', '12:45:00', '58');
INSERT INTO `horario` VALUES('269', '259', '2025-03-25', '12:45:00', '13:30:00', '58');
INSERT INTO `horario` VALUES('270', '273', '2025-03-25', '14:25:00', '15:10:00', '55');
INSERT INTO `horario` VALUES('271', '273', '2025-03-25', '15:10:00', '15:55:00', '55');
INSERT INTO `horario` VALUES('272', '273', '2025-03-26', '10:20:00', '11:05:00', '55');
INSERT INTO `horario` VALUES('278', '273', '2025-03-26', '11:05:00', '11:50:00', '55');
INSERT INTO `horario` VALUES('279', '267', '2025-03-27', '12:00:00', '12:45:00', '57');
INSERT INTO `horario` VALUES('280', '267', '2025-03-27', '12:45:00', '13:30:00', '57');
INSERT INTO `horario` VALUES('281', '271', '2025-04-01', '12:00:00', '12:45:00', '61');
INSERT INTO `horario` VALUES('282', '271', '2025-04-01', '12:45:00', '13:30:00', '61');
INSERT INTO `horario` VALUES('285', '271', '2025-04-01', '08:30:00', '09:15:00', '59');
INSERT INTO `horario` VALUES('286', '271', '2025-04-01', '09:15:00', '10:00:00', '59');
INSERT INTO `horario` VALUES('291', '825', '2025-03-26', '12:00:00', '12:45:00', '52');
INSERT INTO `horario` VALUES('292', '825', '2025-03-28', '08:30:00', '09:15:00', '55');
INSERT INTO `horario` VALUES('293', '273', '2025-03-28', '09:15:00', '10:00:00', '55');
INSERT INTO `horario` VALUES('294', '266', '2025-03-24', '08:30:00', '09:15:00', '63');
INSERT INTO `horario` VALUES('295', '266', '2025-03-27', '09:15:00', '10:00:00', '63');
INSERT INTO `horario` VALUES('296', '266', '2025-03-24', '09:15:00', '10:00:00', '63');
INSERT INTO `horario` VALUES('297', '266', '2025-03-31', '08:30:00', '09:15:00', '63');
INSERT INTO `horario` VALUES('298', '271', '2025-04-04', '12:00:00', '12:45:00', '60');
INSERT INTO `horario` VALUES('299', '271', '2025-04-04', '12:45:00', '13:30:00', '60');
INSERT INTO `horario` VALUES('300', '271', '2025-04-01', '14:25:00', '15:10:00', '61');
INSERT INTO `horario` VALUES('301', '271', '2025-04-01', '15:10:00', '15:55:00', '61');
INSERT INTO `horario` VALUES('302', '271', '2025-04-07', '10:20:00', '11:05:00', '61');
INSERT INTO `horario` VALUES('303', '271', '2025-04-07', '11:05:00', '11:50:00', '61');
INSERT INTO `horario` VALUES('304', '271', '2025-04-04', '08:30:00', '09:15:00', '63');
INSERT INTO `horario` VALUES('305', '271', '2025-04-04', '09:15:00', '10:00:00', '63');
INSERT INTO `horario` VALUES('306', '825', '2025-04-02', '12:00:00', '12:45:00', '52');
INSERT INTO `horario` VALUES('307', '825', '2025-04-02', '10:20:00', '11:05:00', '61');
INSERT INTO `horario` VALUES('308', '1', '2025-04-02', '14:25:00', '15:10:00', '55');
INSERT INTO `horario` VALUES('309', '1', '2025-04-02', '15:10:00', '15:55:00', '56');
INSERT INTO `horario` VALUES('310', '1', '2025-04-03', '14:25:00', '15:10:00', '56');
INSERT INTO `horario` VALUES('311', '1', '2025-04-03', '15:10:00', '15:55:00', '55');
INSERT INTO `horario` VALUES('314', '945', '2025-04-04', '10:20:00', '11:05:00', '64');
INSERT INTO `horario` VALUES('315', '945', '2025-04-04', '11:05:00', '11:50:00', '64');
INSERT INTO `horario` VALUES('316', '259', '2025-04-07', '14:25:00', '15:10:00', '59');
INSERT INTO `horario` VALUES('317', '259', '2025-04-07', '15:10:00', '15:55:00', '59');
INSERT INTO `horario` VALUES('318', '825', '2025-04-09', '12:00:00', '12:45:00', '52');
INSERT INTO `horario` VALUES('319', '825', '2025-04-11', '08:30:00', '09:15:00', '55');
INSERT INTO `horario` VALUES('321', '253', '2025-04-09', '08:30:00', '09:15:00', '56');
INSERT INTO `horario` VALUES('322', '253', '2025-04-09', '09:15:00', '10:00:00', '56');
INSERT INTO `horario` VALUES('323', '259', '2025-04-09', '14:25:00', '15:10:00', '58');
INSERT INTO `horario` VALUES('324', '259', '2025-04-09', '15:10:00', '15:55:00', '58');
INSERT INTO `horario` VALUES('325', '825', '2025-04-10', '14:25:00', '15:10:00', '52');
INSERT INTO `horario` VALUES('326', '825', '2025-04-10', '15:10:00', '15:55:00', '52');
INSERT INTO `horario` VALUES('335', '1753', '2025-04-09', '10:20:00', '11:05:00', '55');
INSERT INTO `horario` VALUES('337', '1753', '2025-04-16', '12:45:00', '13:30:00', '54');
INSERT INTO `horario` VALUES('338', '1753', '2025-04-16', '12:00:00', '12:45:00', '54');
INSERT INTO `horario` VALUES('339', '1753', '2025-04-16', '14:25:00', '15:10:00', '55');
INSERT INTO `horario` VALUES('340', '1753', '2025-04-16', '15:10:00', '15:55:00', '56');
INSERT INTO `horario` VALUES('341', '273', '2025-04-11', '09:15:00', '10:00:00', '55');
INSERT INTO `horario` VALUES('343', '266', '2025-04-11', '12:00:00', '12:45:00', '63');
INSERT INTO `horario` VALUES('344', '266', '2025-04-11', '12:45:00', '13:30:00', '63');
INSERT INTO `horario` VALUES('345', '825', '2025-04-14', '08:30:00', '09:15:00', '54');
INSERT INTO `horario` VALUES('346', '825', '2025-04-14', '09:15:00', '10:00:00', '54');
INSERT INTO `horario` VALUES('347', '825', '2025-04-16', '10:20:00', '11:05:00', '61');
INSERT INTO `horario` VALUES('348', '825', '2025-04-17', '14:25:00', '15:10:00', '52');
INSERT INTO `horario` VALUES('349', '825', '2025-04-17', '15:10:00', '15:55:00', '52');
INSERT INTO `horario` VALUES('350', '263', '2025-04-14', '10:20:00', '11:05:00', '59');
INSERT INTO `horario` VALUES('351', '263', '2025-04-14', '11:05:00', '11:50:00', '59');
INSERT INTO `horario` VALUES('352', '269', '2025-04-14', '12:00:00', '12:45:00', '62');
INSERT INTO `horario` VALUES('353', '269', '2025-04-14', '12:45:00', '13:30:00', '62');
INSERT INTO `horario` VALUES('354', '825', '2025-04-16', '11:05:00', '11:50:00', '61');
INSERT INTO `horario` VALUES('356', '1753', '2025-04-17', '12:00:00', '12:45:00', '55');
INSERT INTO `horario` VALUES('357', '1753', '2025-04-17', '12:45:00', '13:30:00', '56');
INSERT INTO `horario` VALUES('358', '825', '2025-04-21', '08:30:00', '09:15:00', '54');
INSERT INTO `horario` VALUES('359', '825', '2025-04-21', '09:15:00', '10:00:00', '54');
INSERT INTO `horario` VALUES('362', '259', '2025-04-21', '14:25:00', '15:10:00', '59');
INSERT INTO `horario` VALUES('363', '259', '2025-04-21', '15:10:00', '15:55:00', '59');
INSERT INTO `horario` VALUES('366', '266', '2025-04-21', '10:20:00', '11:05:00', '60');
INSERT INTO `horario` VALUES('367', '266', '2025-04-21', '11:05:00', '11:50:00', '60');
INSERT INTO `horario` VALUES('374', '825', '2025-04-25', '08:20:00', '09:05:00', '55');
INSERT INTO `horario` VALUES('377', '825', '2025-04-23', '10:10:00', '10:55:00', '61');
INSERT INTO `horario` VALUES('378', '825', '2025-04-23', '12:00:00', '12:45:00', '52');
INSERT INTO `horario` VALUES('383', '1753', '2025-04-24', '14:15:00', '15:00:00', '55');
INSERT INTO `horario` VALUES('384', '1753', '2025-04-24', '15:00:00', '15:45:00', '55');
INSERT INTO `horario` VALUES('385', '259', '2025-04-24', '12:00:00', '12:45:00', '58');
INSERT INTO `horario` VALUES('386', '259', '2025-04-24', '12:45:00', '13:30:00', '58');
INSERT INTO `horario` VALUES('387', '266', '2025-04-25', '12:00:00', '12:45:00', '63');
INSERT INTO `horario` VALUES('388', '266', '2025-04-25', '12:45:00', '13:30:00', '63');
INSERT INTO `horario` VALUES('389', '1753', '2025-04-29', '08:20:00', '09:05:00', '54');
INSERT INTO `horario` VALUES('390', '1753', '2025-04-29', '09:05:00', '09:50:00', '55');
INSERT INTO `horario` VALUES('391', '266', '2025-04-25', '10:10:00', '10:55:00', '65');
INSERT INTO `horario` VALUES('392', '266', '2025-04-25', '10:55:00', '11:40:00', '65');
INSERT INTO `horario` VALUES('393', '269', '2025-04-28', '14:15:00', '15:00:00', '61');
INSERT INTO `horario` VALUES('394', '269', '2025-04-28', '15:00:00', '15:45:00', '61');
INSERT INTO `horario` VALUES('395', '825', '2025-04-30', '10:10:00', '10:55:00', '61');
INSERT INTO `horario` VALUES('396', '825', '2025-04-30', '12:00:00', '12:45:00', '52');
INSERT INTO `horario` VALUES('400', '1373', '2025-04-29', '14:15:00', '15:00:00', '63');
INSERT INTO `horario` VALUES('405', '269', '2025-04-30', '08:20:00', '09:05:00', '59');
INSERT INTO `horario` VALUES('406', '269', '2025-04-30', '09:05:00', '09:50:00', '59');
INSERT INTO `horario` VALUES('407', '266', '2025-04-28', '10:10:00', '10:55:00', '60');
INSERT INTO `horario` VALUES('408', '266', '2025-04-28', '10:55:00', '11:40:00', '60');
INSERT INTO `horario` VALUES('409', '266', '2025-05-05', '10:10:00', '10:55:00', '60');
INSERT INTO `horario` VALUES('410', '266', '2025-05-05', '10:55:00', '11:40:00', '60');
INSERT INTO `horario` VALUES('412', '266', '2025-05-05', '15:00:00', '15:45:00', '65');
INSERT INTO `horario` VALUES('414', '1373', '2025-05-05', '12:00:00', '12:45:00', '65');
INSERT INTO `horario` VALUES('415', '1373', '2025-05-05', '12:45:00', '13:30:00', '65');
INSERT INTO `horario` VALUES('420', '259', '2025-05-05', '14:15:00', '15:00:00', '59');
INSERT INTO `horario` VALUES('429', '241', '2025-05-06', '08:20:00', '09:05:00', '52');
INSERT INTO `horario` VALUES('430', '241', '2025-05-06', '09:05:00', '09:50:00', '52');
INSERT INTO `horario` VALUES('431', '241', '2025-05-06', '10:10:00', '10:55:00', '52');
INSERT INTO `horario` VALUES('432', '241', '2025-05-06', '10:55:00', '11:40:00', '52');
INSERT INTO `horario` VALUES('433', '241', '2025-05-06', '12:00:00', '12:45:00', '52');
INSERT INTO `horario` VALUES('434', '241', '2025-05-06', '12:45:00', '13:30:00', '52');
INSERT INTO `horario` VALUES('435', '241', '2025-05-06', '14:15:00', '15:00:00', '52');
INSERT INTO `horario` VALUES('436', '241', '2025-05-06', '15:00:00', '15:45:00', '52');
INSERT INTO `horario` VALUES('437', '241', '2025-05-07', '08:20:00', '09:05:00', '52');
INSERT INTO `horario` VALUES('438', '241', '2025-05-07', '09:05:00', '09:50:00', '52');
INSERT INTO `horario` VALUES('439', '241', '2025-05-07', '10:10:00', '10:55:00', '52');
INSERT INTO `horario` VALUES('440', '241', '2025-05-07', '10:55:00', '11:40:00', '52');
INSERT INTO `horario` VALUES('441', '241', '2025-05-07', '12:00:00', '12:45:00', '52');
INSERT INTO `horario` VALUES('442', '241', '2025-05-07', '12:45:00', '13:30:00', '52');
INSERT INTO `horario` VALUES('443', '241', '2025-05-07', '14:15:00', '15:00:00', '52');
INSERT INTO `horario` VALUES('444', '241', '2025-05-07', '15:00:00', '15:45:00', '52');
INSERT INTO `horario` VALUES('445', '241', '2025-05-08', '08:20:00', '09:05:00', '52');
INSERT INTO `horario` VALUES('446', '241', '2025-05-08', '09:05:00', '09:50:00', '52');
INSERT INTO `horario` VALUES('447', '241', '2025-05-08', '10:10:00', '10:55:00', '52');
INSERT INTO `horario` VALUES('448', '241', '2025-05-08', '10:55:00', '11:40:00', '52');
INSERT INTO `horario` VALUES('449', '241', '2025-05-08', '12:00:00', '12:45:00', '52');
INSERT INTO `horario` VALUES('450', '241', '2025-05-08', '12:45:00', '13:30:00', '52');
INSERT INTO `horario` VALUES('451', '241', '2025-05-08', '14:15:00', '15:00:00', '52');
INSERT INTO `horario` VALUES('452', '241', '2025-05-08', '15:00:00', '15:45:00', '52');
INSERT INTO `horario` VALUES('453', '241', '2025-05-09', '08:20:00', '09:05:00', '52');
INSERT INTO `horario` VALUES('454', '241', '2025-05-09', '09:05:00', '09:50:00', '52');
INSERT INTO `horario` VALUES('455', '241', '2025-05-09', '10:10:00', '10:55:00', '52');
INSERT INTO `horario` VALUES('456', '241', '2025-05-09', '10:55:00', '11:40:00', '52');
INSERT INTO `horario` VALUES('457', '241', '2025-05-09', '12:00:00', '12:45:00', '52');
INSERT INTO `horario` VALUES('458', '241', '2025-05-09', '12:45:00', '13:30:00', '52');
INSERT INTO `horario` VALUES('459', '253', '2025-05-13', '12:45:00', '13:30:00', '62');
INSERT INTO `horario` VALUES('461', '1373', '2025-05-13', '14:15:00', '15:00:00', '63');
INSERT INTO `horario` VALUES('462', '266', '2025-05-13', '10:10:00', '10:55:00', '59');
INSERT INTO `horario` VALUES('463', '266', '2025-05-13', '10:55:00', '11:40:00', '59');
INSERT INTO `horario` VALUES('466', '273', '2025-05-13', '12:00:00', '12:45:00', '62');
INSERT INTO `horario` VALUES('467', '273', '2025-05-20', '12:00:00', '12:45:00', '62');
INSERT INTO `horario` VALUES('468', '253', '2025-05-20', '12:45:00', '13:30:00', '62');
INSERT INTO `horario` VALUES('469', '825', '2025-05-14', '10:10:00', '10:55:00', '61');
INSERT INTO `horario` VALUES('470', '825', '2025-05-14', '12:00:00', '12:45:00', '52');
INSERT INTO `horario` VALUES('471', '825', '2025-05-16', '08:20:00', '09:05:00', '55');
INSERT INTO `horario` VALUES('472', '1373', '2025-05-20', '14:15:00', '15:00:00', '63');
INSERT INTO `horario` VALUES('473', '1373', '2025-05-19', '14:15:00', '15:00:00', '53');
INSERT INTO `horario` VALUES('474', '266', '2025-05-19', '10:10:00', '10:55:00', '60');
INSERT INTO `horario` VALUES('475', '266', '2025-05-12', '10:10:00', '10:55:00', '60');
INSERT INTO `horario` VALUES('476', '266', '2025-05-12', '10:55:00', '11:40:00', '60');
INSERT INTO `horario` VALUES('478', '259', '2025-05-19', '15:00:00', '15:45:00', '59');
INSERT INTO `horario` VALUES('479', '825', '2025-05-19', '08:20:00', '09:05:00', '54');
INSERT INTO `horario` VALUES('480', '825', '2025-05-19', '09:05:00', '09:50:00', '54');
INSERT INTO `horario` VALUES('483', '266', '2025-05-22', '10:10:00', '10:55:00', '64');
INSERT INTO `horario` VALUES('484', '266', '2025-05-22', '10:55:00', '11:40:00', '64');
INSERT INTO `horario` VALUES('485', '1373', '2025-05-22', '12:45:00', '13:30:00', '63');
INSERT INTO `horario` VALUES('486', '257', '2025-05-23', '10:10:00', '10:55:00', '62');
INSERT INTO `horario` VALUES('487', '257', '2025-05-23', '10:55:00', '11:40:00', '62');
INSERT INTO `horario` VALUES('488', '273', '2025-05-22', '12:00:00', '12:45:00', '64');
INSERT INTO `horario` VALUES('489', '825', '2025-05-23', '08:20:00', '09:05:00', '55');
INSERT INTO `horario` VALUES('491', '273', '2025-05-23', '09:05:00', '09:50:00', '55');
INSERT INTO `horario` VALUES('492', '825', '2025-05-26', '08:20:00', '09:05:00', '54');
INSERT INTO `horario` VALUES('493', '825', '2025-05-26', '09:05:00', '09:50:00', '54');
INSERT INTO `horario` VALUES('495', '825', '2025-05-28', '12:00:00', '12:45:00', '52');
INSERT INTO `horario` VALUES('496', '273', '2025-05-26', '10:10:00', '10:55:00', '63');
INSERT INTO `horario` VALUES('497', '273', '2025-05-26', '10:55:00', '11:40:00', '63');
INSERT INTO `horario` VALUES('498', '1373', '2025-05-26', '12:45:00', '13:30:00', '53');
INSERT INTO `horario` VALUES('499', '1373', '2025-05-26', '14:15:00', '15:00:00', '53');
INSERT INTO `horario` VALUES('500', '259', '2025-05-30', '10:10:00', '10:55:00', '58');
INSERT INTO `horario` VALUES('501', '259', '2025-05-30', '10:55:00', '11:40:00', '58');
INSERT INTO `horario` VALUES('502', '272', '2025-05-27', '10:10:00', '10:55:00', '62');
INSERT INTO `horario` VALUES('504', '273', '2025-05-27', '12:00:00', '12:45:00', '62');
INSERT INTO `horario` VALUES('506', '253', '2025-05-27', '12:45:00', '13:30:00', '62');
INSERT INTO `horario` VALUES('507', '273', '2025-05-27', '10:55:00', '11:40:00', '62');
INSERT INTO `horario` VALUES('508', '825', '2025-06-03', '12:00:00', '12:45:00', '52');
INSERT INTO `horario` VALUES('509', '825', '2025-06-03', '12:45:00', '13:30:00', '52');
INSERT INTO `horario` VALUES('512', '273', '2025-05-29', '12:00:00', '12:45:00', '64');
INSERT INTO `horario` VALUES('513', '273', '2025-05-29', '12:45:00', '13:30:00', '64');
INSERT INTO `horario` VALUES('514', '259', '2025-06-02', '14:15:00', '15:00:00', '59');
INSERT INTO `horario` VALUES('515', '259', '2025-06-02', '15:00:00', '15:45:00', '59');
INSERT INTO `horario` VALUES('516', '825', '2025-06-02', '08:20:00', '09:05:00', '54');
INSERT INTO `horario` VALUES('517', '825', '2025-06-02', '09:05:00', '09:50:00', '54');
INSERT INTO `horario` VALUES('518', '273', '2025-06-02', '10:10:00', '10:55:00', '62');
INSERT INTO `horario` VALUES('519', '273', '2025-06-02', '10:55:00', '11:40:00', '62');
INSERT INTO `horario` VALUES('520', '273', '2025-06-03', '10:55:00', '11:40:00', '62');
INSERT INTO `horario` VALUES('521', '271', '2025-06-03', '10:10:00', '10:55:00', '62');
INSERT INTO `horario` VALUES('528', '273', '2025-06-13', '12:00:00', '12:45:00', '62');
INSERT INTO `horario` VALUES('529', '273', '2025-06-13', '12:45:00', '13:30:00', '62');
INSERT INTO `horario` VALUES('532', '1373', '2025-06-10', '08:20:00', '09:05:00', '53');
INSERT INTO `horario` VALUES('533', '1373', '2025-06-10', '09:05:00', '09:50:00', '53');
INSERT INTO `horario` VALUES('536', '272', '2025-06-11', '14:15:00', '15:00:00', '0');
INSERT INTO `horario` VALUES('537', '272', '2025-06-11', '15:00:00', '15:45:00', '0');
INSERT INTO `horario` VALUES('538', '825', '2025-06-10', '12:00:00', '12:45:00', '52');
INSERT INTO `horario` VALUES('539', '253', '2025-06-10', '12:45:00', '13:30:00', '62');
INSERT INTO `horario` VALUES('540', '260', '2025-06-11', '08:20:00', '09:05:00', '62');
INSERT INTO `horario` VALUES('541', '260', '2025-06-11', '09:05:00', '09:50:00', '62');
INSERT INTO `horario` VALUES('542', '260', '2025-06-11', '10:10:00', '10:55:00', '62');
INSERT INTO `horario` VALUES('543', '260', '2025-06-11', '10:55:00', '11:40:00', '62');
INSERT INTO `horario` VALUES('544', '260', '2025-06-11', '12:00:00', '12:45:00', '62');
INSERT INTO `horario` VALUES('545', '260', '2025-06-11', '12:45:00', '13:30:00', '62');
INSERT INTO `horario` VALUES('546', '253', '2025-06-12', '08:20:00', '09:05:00', '56');
INSERT INTO `horario` VALUES('547', '253', '2025-06-12', '09:05:00', '09:50:00', '56');
INSERT INTO `horario` VALUES('548', '257', '2025-06-12', '12:00:00', '12:45:00', '62');
INSERT INTO `horario` VALUES('549', '257', '2025-06-12', '12:45:00', '13:30:00', '62');
INSERT INTO `horario` VALUES('550', '241', '2025-06-12', '14:15:00', '15:00:00', '61');
INSERT INTO `horario` VALUES('551', '241', '2025-06-12', '15:00:00', '15:45:00', '61');
INSERT INTO `horario` VALUES('552', '825', '2025-06-16', '08:20:00', '09:05:00', '54');
INSERT INTO `horario` VALUES('553', '825', '2025-06-16', '09:05:00', '09:50:00', '54');
INSERT INTO `horario` VALUES('554', '273', '2025-06-16', '10:10:00', '10:55:00', '63');
INSERT INTO `horario` VALUES('555', '273', '2025-06-16', '10:55:00', '11:40:00', '63');
INSERT INTO `horario` VALUES('556', '273', '2025-06-17', '08:20:00', '09:05:00', '55');
INSERT INTO `horario` VALUES('557', '273', '2025-06-17', '09:05:00', '09:50:00', '55');
INSERT INTO `horario` VALUES('559', '265', '2025-06-17', '10:55:00', '11:40:00', '55');
INSERT INTO `horario` VALUES('560', '273', '2025-07-07', '10:10:00', '10:55:00', '63');
INSERT INTO `horario` VALUES('561', '273', '2025-07-07', '10:55:00', '11:40:00', '63');
INSERT INTO `horario` VALUES('562', '253', '2025-07-09', '10:10:00', '10:55:00', '56');
INSERT INTO `horario` VALUES('563', '253', '2025-07-09', '10:55:00', '11:40:00', '56');
INSERT INTO `horario` VALUES('568', '253', '2025-07-17', '10:10:00', '10:55:00', '56');
INSERT INTO `horario` VALUES('569', '253', '2025-07-17', '10:55:00', '11:40:00', '56');
INSERT INTO `horario` VALUES('570', '253', '2025-07-14', '08:20:00', '09:05:00', '56');
INSERT INTO `horario` VALUES('571', '253', '2025-07-14', '09:05:00', '09:50:00', '56');
INSERT INTO `horario` VALUES('572', '253', '2025-07-14', '10:10:00', '10:55:00', '56');
INSERT INTO `horario` VALUES('573', '253', '2025-07-14', '10:55:00', '11:40:00', '56');
INSERT INTO `horario` VALUES('574', '273', '2025-07-11', '10:10:00', '10:55:00', '55');
INSERT INTO `horario` VALUES('575', '273', '2025-07-11', '10:55:00', '11:40:00', '55');
INSERT INTO `horario` VALUES('580', '945', '2025-07-10', '15:00:00', '15:45:00', '60');
INSERT INTO `horario` VALUES('583', '825', '2025-07-15', '08:20:00', '09:05:00', '54');
INSERT INTO `horario` VALUES('584', '825', '2025-07-15', '09:05:00', '09:50:00', '54');
INSERT INTO `horario` VALUES('585', '825', '2025-07-15', '10:10:00', '10:55:00', '54');
INSERT INTO `horario` VALUES('586', '825', '2025-07-15', '10:55:00', '11:40:00', '54');
INSERT INTO `horario` VALUES('587', '243', '2025-07-18', '12:00:00', '12:45:00', '65');
INSERT INTO `horario` VALUES('588', '243', '2025-07-18', '12:45:00', '13:30:00', '65');
INSERT INTO `horario` VALUES('589', '1373', '2025-07-14', '12:00:00', '12:45:00', '53');
INSERT INTO `horario` VALUES('590', '1373', '2025-07-14', '12:45:00', '13:30:00', '53');
INSERT INTO `horario` VALUES('591', '825', '2025-07-17', '08:20:00', '09:05:00', '54');
INSERT INTO `horario` VALUES('592', '825', '2025-07-17', '09:05:00', '09:50:00', '54');
INSERT INTO `horario` VALUES('593', '825', '2025-07-18', '10:10:00', '10:55:00', '54');
INSERT INTO `horario` VALUES('594', '825', '2025-07-18', '10:55:00', '11:40:00', '54');
INSERT INTO `horario` VALUES('598', '945', '2025-07-17', '14:15:00', '15:00:00', '60');
INSERT INTO `horario` VALUES('599', '945', '2025-07-17', '15:00:00', '15:45:00', '60');
INSERT INTO `horario` VALUES('600', '273', '2025-07-22', '08:20:00', '09:05:00', '55');
INSERT INTO `horario` VALUES('601', '273', '2025-07-22', '09:05:00', '09:50:00', '55');
INSERT INTO `horario` VALUES('602', '273', '2025-07-23', '08:20:00', '09:05:00', '55');
INSERT INTO `horario` VALUES('603', '273', '2025-07-23', '09:05:00', '09:50:00', '55');
INSERT INTO `horario` VALUES('604', '273', '2025-07-23', '10:10:00', '10:55:00', '55');
INSERT INTO `horario` VALUES('605', '273', '2025-07-23', '10:55:00', '11:40:00', '55');
INSERT INTO `horario` VALUES('606', '273', '2025-07-24', '08:20:00', '09:05:00', '55');
INSERT INTO `horario` VALUES('607', '273', '2025-07-24', '09:05:00', '09:50:00', '55');
INSERT INTO `horario` VALUES('608', '253', '2025-07-17', '12:00:00', '12:45:00', '56');
INSERT INTO `horario` VALUES('609', '253', '2025-07-17', '12:45:00', '13:30:00', '56');
INSERT INTO `horario` VALUES('611', '266', '2025-07-21', '08:20:00', '09:05:00', '63');
INSERT INTO `horario` VALUES('612', '266', '2025-07-21', '09:05:00', '09:50:00', '63');
INSERT INTO `horario` VALUES('613', '825', '2025-07-23', '14:15:00', '15:00:00', '54');
INSERT INTO `horario` VALUES('614', '825', '2025-07-23', '15:00:00', '15:45:00', '54');
INSERT INTO `horario` VALUES('615', '273', '2025-07-24', '10:10:00', '10:55:00', '0');
INSERT INTO `horario` VALUES('616', '273', '2025-07-24', '10:55:00', '11:40:00', '0');
INSERT INTO `horario` VALUES('617', '945', '2025-07-28', '10:10:00', '10:55:00', '64');
INSERT INTO `horario` VALUES('618', '945', '2025-07-28', '10:55:00', '11:40:00', '64');
INSERT INTO `horario` VALUES('619', '945', '2025-07-28', '14:15:00', '15:00:00', '62');
INSERT INTO `horario` VALUES('620', '945', '2025-07-28', '15:00:00', '15:45:00', '62');
INSERT INTO `horario` VALUES('621', '945', '2025-07-31', '14:15:00', '15:00:00', '60');
INSERT INTO `horario` VALUES('622', '945', '2025-07-31', '15:00:00', '15:45:00', '60');
INSERT INTO `horario` VALUES('623', '945', '2025-08-01', '12:00:00', '12:45:00', '61');
INSERT INTO `horario` VALUES('624', '945', '2025-08-01', '12:45:00', '13:30:00', '61');
INSERT INTO `horario` VALUES('625', '257', '2025-07-28', '09:05:00', '09:50:00', '64');
INSERT INTO `horario` VALUES('626', '825', '2025-07-30', '10:10:00', '10:55:00', '61');
INSERT INTO `horario` VALUES('627', '257', '2025-07-30', '14:15:00', '15:00:00', '65');
INSERT INTO `horario` VALUES('628', '257', '2025-07-30', '15:00:00', '15:45:00', '65');
INSERT INTO `horario` VALUES('630', '266', '2025-07-30', '08:20:00', '09:05:00', '63');
INSERT INTO `horario` VALUES('631', '266', '2025-07-30', '09:05:00', '09:50:00', '63');
INSERT INTO `horario` VALUES('633', '266', '2025-07-31', '08:20:00', '09:05:00', '62');
INSERT INTO `horario` VALUES('634', '266', '2025-07-31', '09:05:00', '09:50:00', '62');
INSERT INTO `horario` VALUES('635', '266', '2025-07-31', '10:10:00', '10:55:00', '64');
INSERT INTO `horario` VALUES('636', '266', '2025-07-31', '10:55:00', '11:40:00', '64');
INSERT INTO `horario` VALUES('638', '248', '2025-07-31', '12:45:00', '13:30:00', '61');
INSERT INTO `horario` VALUES('639', '266', '2025-08-01', '10:10:00', '10:55:00', '65');
INSERT INTO `horario` VALUES('640', '266', '2025-08-01', '10:55:00', '11:40:00', '65');
INSERT INTO `horario` VALUES('641', '257', '2025-08-04', '08:20:00', '09:05:00', '64');
INSERT INTO `horario` VALUES('642', '257', '2025-08-04', '09:05:00', '09:50:00', '64');
INSERT INTO `horario` VALUES('643', '257', '2025-08-07', '08:20:00', '09:05:00', '64');
INSERT INTO `horario` VALUES('644', '257', '2025-08-07', '09:05:00', '09:50:00', '64');
INSERT INTO `horario` VALUES('646', '273', '2025-08-04', '14:15:00', '15:00:00', '55');
INSERT INTO `horario` VALUES('647', '273', '2025-08-04', '15:00:00', '15:45:00', '55');
INSERT INTO `horario` VALUES('649', '257', '2025-08-07', '12:00:00', '12:45:00', '62');
INSERT INTO `horario` VALUES('650', '257', '2025-08-07', '12:45:00', '13:30:00', '62');
INSERT INTO `horario` VALUES('651', '945', '2025-08-06', '12:00:00', '12:45:00', '61');
INSERT INTO `horario` VALUES('652', '945', '2025-08-06', '12:45:00', '13:30:00', '61');
INSERT INTO `horario` VALUES('653', '945', '2025-08-07', '10:55:00', '11:40:00', '61');
INSERT INTO `horario` VALUES('654', '945', '2025-08-07', '14:15:00', '15:00:00', '60');
INSERT INTO `horario` VALUES('655', '945', '2025-08-07', '15:00:00', '15:45:00', '61');
INSERT INTO `horario` VALUES('656', '825', '2025-08-06', '10:10:00', '10:55:00', '61');
INSERT INTO `horario` VALUES('657', '241', '2025-08-05', '12:00:00', '12:45:00', '65');
INSERT INTO `horario` VALUES('658', '241', '2025-08-05', '12:45:00', '13:30:00', '65');
INSERT INTO `horario` VALUES('659', '248', '2025-08-05', '14:15:00', '15:00:00', '61');
INSERT INTO `horario` VALUES('660', '248', '2025-08-05', '15:00:00', '15:45:00', '61');
INSERT INTO `horario` VALUES('661', '945', '2025-08-08', '08:20:00', '09:05:00', '59');
INSERT INTO `horario` VALUES('662', '945', '2025-08-08', '09:05:00', '09:50:00', '60');
INSERT INTO `horario` VALUES('663', '248', '2025-08-06', '14:15:00', '15:00:00', '61');
INSERT INTO `horario` VALUES('664', '248', '2025-08-06', '15:00:00', '15:45:00', '61');
INSERT INTO `horario` VALUES('665', '257', '2025-08-11', '15:00:00', '15:45:00', '62');
INSERT INTO `horario` VALUES('666', '257', '2025-08-12', '14:15:00', '15:00:00', '62');
INSERT INTO `horario` VALUES('667', '257', '2025-08-12', '15:00:00', '15:45:00', '62');
INSERT INTO `horario` VALUES('668', '257', '2025-08-11', '10:10:00', '10:55:00', '65');
INSERT INTO `horario` VALUES('669', '257', '2025-08-11', '10:55:00', '11:40:00', '65');
INSERT INTO `horario` VALUES('670', '257', '2025-08-11', '12:00:00', '12:45:00', '64');
INSERT INTO `horario` VALUES('671', '257', '2025-08-11', '12:45:00', '13:30:00', '64');
INSERT INTO `horario` VALUES('672', '257', '2025-08-14', '10:55:00', '11:40:00', '62');
INSERT INTO `horario` VALUES('673', '257', '2025-08-14', '10:10:00', '10:55:00', '62');




DROP TABLE IF EXISTS `indicadores`;
CREATE TABLE `indicadores` (
  `id` int NOT NULL AUTO_INCREMENT,
  `nombre` varchar(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `descripcion` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `indicadores` VALUES('1', 'MB', 'Muy Bueno');
INSERT INTO `indicadores` VALUES('2', 'B', 'Bueno');
INSERT INTO `indicadores` VALUES('3', 'S', 'Suficiente');
INSERT INTO `indicadores` VALUES('4', 'I', 'Insuficiente');




DROP TABLE IF EXISTS `informacion_adicional`;
CREATE TABLE `informacion_adicional` (
  `id` int NOT NULL AUTO_INCREMENT,
  `matricula_id` int DEFAULT NULL,
  `es_bicultural` tinyint(1) DEFAULT NULL,
  `etnia` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `problemas_aprendizaje` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cursos_repetidos` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `matricula_id` (`matricula_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;





DROP TABLE IF EXISTS `mantenimiento_equipo`;
CREATE TABLE `mantenimiento_equipo` (
  `id` int NOT NULL AUTO_INCREMENT,
  `equipo_id` int DEFAULT NULL,
  `fecha_ultimo_mantenimiento` date DEFAULT NULL,
  `detalles_mantenimiento` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `proxima_fecha_mantenimiento` date DEFAULT NULL,
  `observaciones` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `equipo_id` (`equipo_id`)
) ENGINE=InnoDB AUTO_INCREMENT=64 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `mantenimiento_equipo` VALUES('10', '7', '2024-10-14', 'Actualizacion de sistema.', '2024-12-30', 'TouchPad no funciona bien.');
INSERT INTO `mantenimiento_equipo` VALUES('11', '8', '2024-10-14', 'LIMPIEZA GENERAL', '2024-12-30', 'NO APLICA');
INSERT INTO `mantenimiento_equipo` VALUES('16', '13', '2024-10-14', 'No aplica', '2024-10-14', 'No aplica');
INSERT INTO `mantenimiento_equipo` VALUES('17', '14', '2024-10-14', 'No aplica', '2024-10-14', 'No aplica');
INSERT INTO `mantenimiento_equipo` VALUES('18', '15', '2024-10-14', 'No aplica', '2024-10-14', 'No aplica');
INSERT INTO `mantenimiento_equipo` VALUES('20', '17', NULL, NULL, NULL, NULL);
INSERT INTO `mantenimiento_equipo` VALUES('21', '18', NULL, NULL, NULL, NULL);
INSERT INTO `mantenimiento_equipo` VALUES('22', '19', NULL, NULL, NULL, NULL);
INSERT INTO `mantenimiento_equipo` VALUES('23', '20', NULL, NULL, NULL, NULL);
INSERT INTO `mantenimiento_equipo` VALUES('24', '21', NULL, NULL, NULL, NULL);
INSERT INTO `mantenimiento_equipo` VALUES('25', '22', NULL, NULL, NULL, NULL);
INSERT INTO `mantenimiento_equipo` VALUES('26', '23', NULL, NULL, NULL, NULL);
INSERT INTO `mantenimiento_equipo` VALUES('27', '24', NULL, NULL, NULL, NULL);
INSERT INTO `mantenimiento_equipo` VALUES('28', '25', NULL, NULL, NULL, NULL);
INSERT INTO `mantenimiento_equipo` VALUES('29', '26', NULL, NULL, NULL, NULL);
INSERT INTO `mantenimiento_equipo` VALUES('30', '27', NULL, NULL, NULL, NULL);
INSERT INTO `mantenimiento_equipo` VALUES('31', '28', NULL, NULL, NULL, NULL);
INSERT INTO `mantenimiento_equipo` VALUES('32', '29', NULL, NULL, NULL, NULL);
INSERT INTO `mantenimiento_equipo` VALUES('33', '30', NULL, NULL, NULL, NULL);
INSERT INTO `mantenimiento_equipo` VALUES('34', '31', NULL, NULL, NULL, NULL);
INSERT INTO `mantenimiento_equipo` VALUES('35', '32', NULL, NULL, NULL, NULL);
INSERT INTO `mantenimiento_equipo` VALUES('36', '33', NULL, NULL, NULL, NULL);
INSERT INTO `mantenimiento_equipo` VALUES('37', '34', NULL, NULL, NULL, NULL);
INSERT INTO `mantenimiento_equipo` VALUES('38', '35', NULL, NULL, NULL, NULL);
INSERT INTO `mantenimiento_equipo` VALUES('39', '36', NULL, NULL, NULL, NULL);
INSERT INTO `mantenimiento_equipo` VALUES('40', '37', NULL, NULL, NULL, NULL);
INSERT INTO `mantenimiento_equipo` VALUES('41', '38', NULL, NULL, NULL, NULL);
INSERT INTO `mantenimiento_equipo` VALUES('42', '39', NULL, NULL, NULL, NULL);
INSERT INTO `mantenimiento_equipo` VALUES('43', '40', NULL, NULL, NULL, NULL);
INSERT INTO `mantenimiento_equipo` VALUES('44', '41', NULL, NULL, NULL, NULL);
INSERT INTO `mantenimiento_equipo` VALUES('45', '42', NULL, NULL, NULL, NULL);
INSERT INTO `mantenimiento_equipo` VALUES('46', '43', NULL, NULL, NULL, NULL);
INSERT INTO `mantenimiento_equipo` VALUES('47', '44', NULL, NULL, NULL, NULL);
INSERT INTO `mantenimiento_equipo` VALUES('48', '45', NULL, NULL, NULL, NULL);
INSERT INTO `mantenimiento_equipo` VALUES('49', '46', NULL, NULL, NULL, NULL);
INSERT INTO `mantenimiento_equipo` VALUES('50', '47', NULL, NULL, NULL, NULL);
INSERT INTO `mantenimiento_equipo` VALUES('51', '48', NULL, NULL, NULL, NULL);
INSERT INTO `mantenimiento_equipo` VALUES('52', '49', '2024-10-17', 'No aplica.', '2024-10-17', 'No aplica.');
INSERT INTO `mantenimiento_equipo` VALUES('53', '50', '2024-10-14', 'Actualizacion de sistema.', '2024-11-07', 'TouchPad no funciona bien.');
INSERT INTO `mantenimiento_equipo` VALUES('54', '51', '2024-10-14', 'Actualizacion de sistema.', '2024-11-29', '');
INSERT INTO `mantenimiento_equipo` VALUES('55', '52', '2024-11-22', 'NO APLICA', '2024-11-22', 'NO APLICA');
INSERT INTO `mantenimiento_equipo` VALUES('56', '53', '2024-11-26', 'NO APLICA', '2024-11-26', 'NO APLICA');
INSERT INTO `mantenimiento_equipo` VALUES('57', '54', '2024-11-26', 'NO APLICA', '2024-11-26', 'NO APLICA');
INSERT INTO `mantenimiento_equipo` VALUES('60', '57', '2025-03-12', 'No posee', '2025-03-30', 'No posee');
INSERT INTO `mantenimiento_equipo` VALUES('61', '58', '2025-05-05', 'No aplica', '2025-05-05', '13 Tablet Funcionales');
INSERT INTO `mantenimiento_equipo` VALUES('62', '59', '2025-05-09', 'no aplica', '2025-05-09', 'Usado');
INSERT INTO `mantenimiento_equipo` VALUES('63', '60', '2025-05-09', 'No aplica', '2025-05-09', 'No aplica');




DROP TABLE IF EXISTS `matricula`;
CREATE TABLE `matricula` (
  `id` int NOT NULL AUTO_INCREMENT,
  `num_centro_apoderados` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `rut` varchar(12) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `nombre` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `apellido_paterno` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `apellido_materno` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `curso_id` int NOT NULL,
  `fecha_nac` date NOT NULL,
  `lugar_nac` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `dom_alumno` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fech_ing_curso` date DEFAULT NULL,
  `procedencia` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `persona_con_quien_vive` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `curso_id` (`curso_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;





DROP TABLE IF EXISTS `notas`;
CREATE TABLE `notas` (
  `id` int NOT NULL AUTO_INCREMENT,
  `usuario_id` int DEFAULT NULL,
  `asignatura_id` int DEFAULT NULL,
  `nota` float(5,2) DEFAULT NULL,
  `fecha` date NOT NULL,
  `semestre` tinyint NOT NULL,
  `numero_nota` int NOT NULL,
  PRIMARY KEY (`id`),
  KEY `usuario_id` (`usuario_id`),
  KEY `asignatura_id` (`asignatura_id`)
) ENGINE=InnoDB AUTO_INCREMENT=12295 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `notas` VALUES('1', '1696', '11', '7.00', '2025-04-28', '1', '1');
INSERT INTO `notas` VALUES('2', '1696', '8', '5.80', '2025-04-28', '1', '1');
INSERT INTO `notas` VALUES('3', '1696', '7', '4.30', '2025-04-28', '1', '1');
INSERT INTO `notas` VALUES('4', '1696', '12', '5.60', '2025-04-28', '1', '1');
INSERT INTO `notas` VALUES('5', '1696', '3', '7.00', '2025-04-28', '1', '1');
INSERT INTO `notas` VALUES('6', '1696', '4', '6.80', '2025-04-28', '1', '1');
INSERT INTO `notas` VALUES('7', '1696', '5', '7.00', '2025-04-28', '1', '1');
INSERT INTO `notas` VALUES('8', '1696', '5', '7.00', '2025-04-28', '1', '2');
INSERT INTO `notas` VALUES('9', '1713', '11', '5.00', '2025-05-19', '1', '1');
INSERT INTO `notas` VALUES('10', '1713', '11', '5.00', '2025-05-19', '1', '2');
INSERT INTO `notas` VALUES('11', '1713', '11', '6.30', '2025-05-19', '1', '3');
INSERT INTO `notas` VALUES('12', '1714', '11', '5.80', '2025-05-19', '1', '1');
INSERT INTO `notas` VALUES('13', '1714', '11', '7.00', '2025-05-19', '1', '2');
INSERT INTO `notas` VALUES('14', '1714', '11', '6.80', '2025-05-19', '1', '3');
INSERT INTO `notas` VALUES('15', '1715', '11', '4.50', '2025-05-19', '1', '1');
INSERT INTO `notas` VALUES('16', '1715', '11', '6.30', '2025-05-19', '1', '2');
INSERT INTO `notas` VALUES('17', '1716', '11', '5.00', '2025-05-19', '1', '1');
INSERT INTO `notas` VALUES('18', '1716', '11', '7.00', '2025-05-19', '1', '2');
INSERT INTO `notas` VALUES('19', '1716', '11', '7.00', '2025-05-19', '1', '3');
INSERT INTO `notas` VALUES('20', '1717', '11', '5.00', '2025-05-19', '1', '1');
INSERT INTO `notas` VALUES('21', '1717', '11', '7.00', '2025-05-19', '1', '2');
INSERT INTO `notas` VALUES('22', '1717', '11', '5.90', '2025-05-19', '1', '3');
INSERT INTO `notas` VALUES('23', '1718', '11', '4.40', '2025-05-19', '1', '1');
INSERT INTO `notas` VALUES('24', '1718', '11', '6.50', '2025-05-19', '1', '2');
INSERT INTO `notas` VALUES('25', '1718', '11', '7.00', '2025-05-19', '1', '3');
INSERT INTO `notas` VALUES('26', '1719', '11', '5.20', '2025-05-19', '1', '1');
INSERT INTO `notas` VALUES('27', '1719', '11', '7.00', '2025-05-19', '1', '2');
INSERT INTO `notas` VALUES('28', '1719', '11', '6.60', '2025-05-19', '1', '3');
INSERT INTO `notas` VALUES('29', '1720', '11', '4.40', '2025-05-19', '1', '1');
INSERT INTO `notas` VALUES('30', '1720', '11', '6.80', '2025-05-19', '1', '2');
INSERT INTO `notas` VALUES('31', '1720', '11', '5.60', '2025-05-19', '1', '3');
INSERT INTO `notas` VALUES('32', '1721', '11', '5.20', '2025-05-19', '1', '1');
INSERT INTO `notas` VALUES('33', '1721', '11', '6.80', '2025-05-19', '1', '2');
INSERT INTO `notas` VALUES('34', '1721', '11', '6.50', '2025-05-19', '1', '3');
INSERT INTO `notas` VALUES('35', '1722', '11', '4.40', '2025-05-19', '1', '1');
INSERT INTO `notas` VALUES('36', '1722', '11', '6.50', '2025-05-19', '1', '2');
INSERT INTO `notas` VALUES('37', '1722', '11', '6.50', '2025-05-19', '1', '3');
INSERT INTO `notas` VALUES('38', '1723', '11', '5.30', '2025-05-19', '1', '1');
INSERT INTO `notas` VALUES('39', '1723', '11', '7.00', '2025-05-19', '1', '2');
INSERT INTO `notas` VALUES('40', '1723', '11', '6.30', '2025-05-19', '1', '3');
INSERT INTO `notas` VALUES('41', '1724', '11', '5.00', '2025-05-19', '1', '1');
INSERT INTO `notas` VALUES('42', '1724', '11', '7.00', '2025-05-19', '1', '2');
INSERT INTO `notas` VALUES('43', '1724', '11', '5.00', '2025-05-19', '1', '3');
INSERT INTO `notas` VALUES('44', '1725', '11', '5.00', '2025-05-19', '1', '1');
INSERT INTO `notas` VALUES('45', '1725', '11', '6.80', '2025-05-19', '1', '2');
INSERT INTO `notas` VALUES('46', '1725', '11', '6.30', '2025-05-19', '1', '3');
INSERT INTO `notas` VALUES('47', '1726', '11', '4.90', '2025-05-19', '1', '1');
INSERT INTO `notas` VALUES('48', '1726', '11', '6.70', '2025-05-19', '1', '2');
INSERT INTO `notas` VALUES('49', '1726', '11', '6.50', '2025-05-19', '1', '3');
INSERT INTO `notas` VALUES('50', '1727', '11', '5.70', '2025-05-19', '1', '1');
INSERT INTO `notas` VALUES('51', '1727', '11', '7.00', '2025-05-19', '1', '2');
INSERT INTO `notas` VALUES('52', '1727', '11', '7.00', '2025-05-19', '1', '3');
INSERT INTO `notas` VALUES('53', '1728', '11', '4.90', '2025-05-19', '1', '1');
INSERT INTO `notas` VALUES('54', '1728', '11', '7.00', '2025-05-19', '1', '2');
INSERT INTO `notas` VALUES('55', '1728', '11', '6.60', '2025-05-19', '1', '3');
INSERT INTO `notas` VALUES('56', '1729', '11', '4.80', '2025-05-19', '1', '1');
INSERT INTO `notas` VALUES('57', '1729', '11', '6.60', '2025-05-19', '1', '2');
INSERT INTO `notas` VALUES('58', '1729', '11', '6.60', '2025-05-19', '1', '3');
INSERT INTO `notas` VALUES('59', '1730', '11', '5.20', '2025-05-19', '1', '1');
INSERT INTO `notas` VALUES('60', '1730', '11', '6.80', '2025-05-19', '1', '2');
INSERT INTO `notas` VALUES('61', '1730', '11', '6.80', '2025-05-19', '1', '3');
INSERT INTO `notas` VALUES('62', '1713', '6', '5.30', '2025-05-19', '1', '1');
INSERT INTO `notas` VALUES('63', '1714', '6', '6.20', '2025-05-19', '1', '1');
INSERT INTO `notas` VALUES('64', '1714', '6', '5.30', '2025-05-19', '1', '2');
INSERT INTO `notas` VALUES('65', '1715', '6', '4.00', '2025-05-19', '1', '1');
INSERT INTO `notas` VALUES('66', '1716', '6', '6.20', '2025-05-19', '1', '1');
INSERT INTO `notas` VALUES('67', '1716', '6', '5.50', '2025-05-19', '1', '2');
INSERT INTO `notas` VALUES('68', '1717', '6', '4.00', '2025-05-19', '1', '1');
INSERT INTO `notas` VALUES('69', '1717', '6', '5.20', '2025-05-19', '1', '2');
INSERT INTO `notas` VALUES('70', '1718', '6', '5.30', '2025-05-19', '1', '1');
INSERT INTO `notas` VALUES('71', '1718', '6', '4.20', '2025-05-19', '1', '2');
INSERT INTO `notas` VALUES('72', '1719', '6', '4.20', '2025-05-19', '1', '1');
INSERT INTO `notas` VALUES('73', '1720', '6', '3.70', '2025-05-19', '1', '1');
INSERT INTO `notas` VALUES('74', '1720', '6', '5.20', '2025-05-19', '1', '2');
INSERT INTO `notas` VALUES('75', '1721', '6', '4.00', '2025-05-19', '1', '1');
INSERT INTO `notas` VALUES('76', '1721', '6', '4.20', '2025-05-19', '1', '2');
INSERT INTO `notas` VALUES('77', '1722', '6', '2.50', '2025-05-19', '1', '1');
INSERT INTO `notas` VALUES('78', '1722', '6', '4.20', '2025-05-19', '1', '2');
INSERT INTO `notas` VALUES('79', '1723', '6', '2.50', '2025-05-19', '1', '1');
INSERT INTO `notas` VALUES('80', '1723', '6', '4.00', '2025-05-19', '1', '2');
INSERT INTO `notas` VALUES('81', '1724', '6', '3.80', '2025-05-19', '1', '1');
INSERT INTO `notas` VALUES('82', '1724', '6', '4.70', '2025-05-19', '1', '2');
INSERT INTO `notas` VALUES('83', '1725', '6', '4.80', '2025-05-19', '1', '1');
INSERT INTO `notas` VALUES('84', '1725', '6', '6.00', '2025-05-19', '1', '2');
INSERT INTO `notas` VALUES('85', '1726', '6', '4.20', '2025-05-19', '1', '1');
INSERT INTO `notas` VALUES('86', '1726', '6', '5.20', '2025-05-19', '1', '2');
INSERT INTO `notas` VALUES('87', '1727', '6', '7.00', '2025-05-19', '1', '1');
INSERT INTO `notas` VALUES('88', '1727', '6', '7.00', '2025-05-19', '1', '2');
INSERT INTO `notas` VALUES('89', '1728', '6', '7.00', '2025-05-19', '1', '1');
INSERT INTO `notas` VALUES('90', '1728', '6', '7.00', '2025-05-19', '1', '2');
INSERT INTO `notas` VALUES('91', '1729', '6', '5.00', '2025-05-19', '1', '1');
INSERT INTO `notas` VALUES('92', '1729', '6', '6.50', '2025-05-19', '1', '2');
INSERT INTO `notas` VALUES('93', '1730', '6', '4.00', '2025-05-19', '1', '1');
INSERT INTO `notas` VALUES('94', '1730', '6', '5.70', '2025-05-19', '1', '2');
INSERT INTO `notas` VALUES('95', '1898', '1', '7.00', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('96', '1898', '1', '6.80', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('97', '1898', '1', '7.00', '2025-05-20', '1', '4');
INSERT INTO `notas` VALUES('98', '1899', '1', '6.30', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('99', '1899', '1', '5.80', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('100', '1899', '1', '7.00', '2025-05-20', '1', '4');
INSERT INTO `notas` VALUES('101', '1900', '1', '7.00', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('102', '1900', '1', '6.80', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('103', '1900', '1', '7.00', '2025-05-20', '1', '4');
INSERT INTO `notas` VALUES('104', '1901', '1', '4.00', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('105', '1901', '1', '5.00', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('106', '1901', '1', '4.00', '2025-05-20', '1', '4');
INSERT INTO `notas` VALUES('107', '1902', '1', '5.50', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('108', '1902', '1', '7.00', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('109', '1902', '1', '7.00', '2025-05-20', '1', '4');
INSERT INTO `notas` VALUES('110', '1920', '1', '6.70', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('111', '1920', '1', '4.50', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('112', '1920', '1', '7.00', '2025-05-20', '1', '4');
INSERT INTO `notas` VALUES('113', '1919', '1', '4.90', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('114', '1919', '1', '5.30', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('115', '1919', '1', '5.00', '2025-05-20', '1', '4');
INSERT INTO `notas` VALUES('116', '1903', '1', '7.00', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('117', '1903', '1', '5.50', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('118', '1903', '1', '7.00', '2025-05-20', '1', '4');
INSERT INTO `notas` VALUES('119', '1904', '1', '4.00', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('120', '1904', '1', '4.00', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('121', '1904', '1', '5.10', '2025-05-20', '1', '4');
INSERT INTO `notas` VALUES('122', '1905', '1', '4.80', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('123', '1905', '1', '5.50', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('124', '1905', '1', '7.00', '2025-05-20', '1', '4');
INSERT INTO `notas` VALUES('125', '1906', '1', '4.80', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('126', '1906', '1', '5.00', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('127', '1906', '1', '6.00', '2025-05-20', '1', '4');
INSERT INTO `notas` VALUES('128', '1907', '1', '6.30', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('129', '1907', '1', '5.00', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('130', '1907', '1', '7.00', '2025-05-20', '1', '4');
INSERT INTO `notas` VALUES('131', '1908', '1', '6.30', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('132', '1908', '1', '6.50', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('133', '1908', '1', '7.00', '2025-05-20', '1', '4');
INSERT INTO `notas` VALUES('134', '1909', '1', '5.50', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('135', '1909', '1', '6.30', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('136', '1909', '1', '6.00', '2025-05-20', '1', '4');
INSERT INTO `notas` VALUES('137', '1910', '1', '4.80', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('138', '1910', '1', '4.00', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('139', '1910', '1', '6.00', '2025-05-20', '1', '4');
INSERT INTO `notas` VALUES('140', '1911', '1', '6.30', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('141', '1911', '1', '4.50', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('142', '1911', '1', '5.00', '2025-05-20', '1', '4');
INSERT INTO `notas` VALUES('143', '1912', '1', '6.30', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('144', '1912', '1', '4.50', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('145', '1912', '1', '7.00', '2025-05-20', '1', '4');
INSERT INTO `notas` VALUES('146', '1913', '1', '5.50', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('147', '1913', '1', '5.30', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('148', '1913', '1', '7.00', '2025-05-20', '1', '4');
INSERT INTO `notas` VALUES('149', '1914', '1', '6.30', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('150', '1914', '1', '5.50', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('151', '1914', '1', '7.00', '2025-05-20', '1', '4');
INSERT INTO `notas` VALUES('152', '1915', '1', '7.00', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('153', '1915', '1', '4.00', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('154', '1915', '1', '7.00', '2025-05-20', '1', '4');
INSERT INTO `notas` VALUES('155', '1916', '1', '5.50', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('156', '1916', '1', '6.50', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('157', '1916', '1', '7.00', '2025-05-20', '1', '4');
INSERT INTO `notas` VALUES('158', '1917', '1', '4.80', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('159', '1917', '1', '6.50', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('160', '1917', '1', '7.00', '2025-05-20', '1', '4');
INSERT INTO `notas` VALUES('161', '1921', '1', '7.00', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('162', '1921', '1', '7.00', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('163', '1921', '1', '7.00', '2025-05-20', '1', '4');
INSERT INTO `notas` VALUES('164', '1918', '1', '5.50', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('165', '1918', '1', '7.00', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('166', '1918', '1', '7.00', '2025-05-20', '1', '4');
INSERT INTO `notas` VALUES('167', '1898', '2', '6.10', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('168', '1898', '2', '6.90', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('169', '1898', '2', '7.00', '2025-05-20', '1', '3');
INSERT INTO `notas` VALUES('170', '1898', '2', '7.00', '2025-05-20', '1', '5');
INSERT INTO `notas` VALUES('171', '1899', '2', '6.50', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('172', '1899', '2', '7.00', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('173', '1899', '2', '7.00', '2025-05-20', '1', '3');
INSERT INTO `notas` VALUES('174', '1899', '2', '7.00', '2025-05-20', '1', '5');
INSERT INTO `notas` VALUES('175', '1900', '2', '5.50', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('176', '1900', '2', '7.00', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('177', '1900', '2', '6.60', '2025-05-20', '1', '3');
INSERT INTO `notas` VALUES('178', '1900', '2', '7.00', '2025-05-20', '1', '5');
INSERT INTO `notas` VALUES('179', '1901', '2', '5.60', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('180', '1901', '2', '6.20', '2025-05-20', '1', '3');
INSERT INTO `notas` VALUES('181', '1901', '2', '5.50', '2025-05-20', '1', '5');
INSERT INTO `notas` VALUES('182', '1902', '2', '6.10', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('183', '1902', '2', '5.80', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('184', '1902', '2', '7.00', '2025-05-20', '1', '3');
INSERT INTO `notas` VALUES('185', '1902', '2', '6.00', '2025-05-20', '1', '5');
INSERT INTO `notas` VALUES('186', '1920', '2', '7.00', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('187', '1920', '2', '5.80', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('188', '1920', '2', '7.00', '2025-05-20', '1', '3');
INSERT INTO `notas` VALUES('189', '1920', '2', '7.00', '2025-05-20', '1', '5');
INSERT INTO `notas` VALUES('190', '1919', '2', '6.80', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('191', '1919', '2', '4.80', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('192', '1919', '2', '5.00', '2025-05-20', '1', '5');
INSERT INTO `notas` VALUES('193', '1903', '2', '5.80', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('194', '1903', '2', '3.70', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('195', '1903', '2', '6.60', '2025-05-20', '1', '3');
INSERT INTO `notas` VALUES('196', '1903', '2', '7.00', '2025-05-20', '1', '5');
INSERT INTO `notas` VALUES('197', '1904', '2', '6.00', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('198', '1904', '2', '5.10', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('199', '1904', '2', '5.80', '2025-05-20', '1', '3');
INSERT INTO `notas` VALUES('200', '1904', '2', '6.00', '2025-05-20', '1', '5');
INSERT INTO `notas` VALUES('201', '1905', '2', '5.50', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('202', '1905', '2', '7.00', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('203', '1905', '2', '5.80', '2025-05-20', '1', '3');
INSERT INTO `notas` VALUES('204', '1905', '2', '5.00', '2025-05-20', '1', '5');
INSERT INTO `notas` VALUES('205', '1906', '2', '3.30', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('206', '1906', '2', '6.10', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('207', '1906', '2', '4.50', '2025-05-20', '1', '3');
INSERT INTO `notas` VALUES('208', '1906', '2', '4.50', '2025-05-20', '1', '5');
INSERT INTO `notas` VALUES('209', '1907', '2', '6.20', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('210', '1907', '2', '5.10', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('211', '1907', '2', '7.00', '2025-05-20', '1', '3');
INSERT INTO `notas` VALUES('212', '1907', '2', '6.80', '2025-05-20', '1', '5');
INSERT INTO `notas` VALUES('213', '1908', '2', '7.00', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('214', '1908', '2', '5.00', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('215', '1908', '2', '7.00', '2025-05-20', '1', '5');
INSERT INTO `notas` VALUES('216', '1909', '2', '6.10', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('217', '1909', '2', '7.00', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('218', '1909', '2', '7.00', '2025-05-20', '1', '3');
INSERT INTO `notas` VALUES('219', '1909', '2', '7.00', '2025-05-20', '1', '5');
INSERT INTO `notas` VALUES('220', '1910', '2', '3.20', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('221', '1910', '2', '5.80', '2025-05-20', '1', '3');
INSERT INTO `notas` VALUES('222', '1910', '2', '5.00', '2025-05-20', '1', '5');
INSERT INTO `notas` VALUES('223', '1911', '2', '4.30', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('224', '1911', '2', '4.00', '2025-05-20', '1', '5');
INSERT INTO `notas` VALUES('225', '1912', '2', '5.80', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('226', '1912', '2', '3.40', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('227', '1912', '2', '6.20', '2025-05-20', '1', '3');
INSERT INTO `notas` VALUES('228', '1912', '2', '6.00', '2025-05-20', '1', '5');
INSERT INTO `notas` VALUES('229', '1913', '2', '5.50', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('230', '1913', '2', '6.40', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('231', '1913', '2', '7.00', '2025-05-20', '1', '3');
INSERT INTO `notas` VALUES('232', '1913', '2', '6.30', '2025-05-20', '1', '5');
INSERT INTO `notas` VALUES('233', '1914', '2', '6.20', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('234', '1914', '2', '5.40', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('235', '1914', '2', '6.20', '2025-05-20', '1', '3');
INSERT INTO `notas` VALUES('236', '1914', '2', '6.00', '2025-05-20', '1', '5');
INSERT INTO `notas` VALUES('237', '1915', '2', '6.30', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('238', '1915', '2', '7.00', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('239', '1915', '2', '7.00', '2025-05-20', '1', '3');
INSERT INTO `notas` VALUES('240', '1915', '2', '7.00', '2025-05-20', '1', '5');
INSERT INTO `notas` VALUES('241', '1916', '2', '6.50', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('242', '1916', '2', '4.80', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('243', '1916', '2', '5.30', '2025-05-20', '1', '3');
INSERT INTO `notas` VALUES('244', '1916', '2', '6.00', '2025-05-20', '1', '5');
INSERT INTO `notas` VALUES('245', '1917', '2', '6.40', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('246', '1917', '2', '4.50', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('247', '1917', '2', '6.60', '2025-05-20', '1', '3');
INSERT INTO `notas` VALUES('248', '1917', '2', '5.80', '2025-05-20', '1', '5');
INSERT INTO `notas` VALUES('249', '1921', '2', '7.00', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('250', '1921', '2', '6.40', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('251', '1921', '2', '7.00', '2025-05-20', '1', '3');
INSERT INTO `notas` VALUES('252', '1921', '2', '7.00', '2025-05-20', '1', '5');
INSERT INTO `notas` VALUES('253', '1918', '2', '6.20', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('254', '1918', '2', '4.10', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('255', '1918', '2', '5.30', '2025-05-20', '1', '3');
INSERT INTO `notas` VALUES('256', '1918', '2', '6.50', '2025-05-20', '1', '5');
INSERT INTO `notas` VALUES('257', '1898', '6', '6.60', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('258', '1898', '6', '7.00', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('259', '1898', '6', '6.80', '2025-05-20', '1', '3');
INSERT INTO `notas` VALUES('261', '1899', '6', '6.10', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('262', '1899', '6', '6.80', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('263', '1899', '6', '6.80', '2025-05-20', '1', '3');
INSERT INTO `notas` VALUES('265', '1900', '6', '5.70', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('266', '1900', '6', '6.80', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('267', '1900', '6', '7.00', '2025-05-20', '1', '3');
INSERT INTO `notas` VALUES('269', '1901', '6', '4.40', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('270', '1901', '6', '5.80', '2025-05-20', '1', '3');
INSERT INTO `notas` VALUES('272', '1902', '6', '5.90', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('273', '1902', '6', '6.60', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('274', '1902', '6', '7.00', '2025-05-20', '1', '3');
INSERT INTO `notas` VALUES('276', '1920', '6', '6.60', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('277', '1920', '6', '6.60', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('278', '1920', '6', '7.00', '2025-05-20', '1', '3');
INSERT INTO `notas` VALUES('280', '1919', '6', '4.80', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('281', '1919', '6', '6.10', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('283', '1903', '6', '7.00', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('284', '1903', '6', '7.00', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('285', '1903', '6', '6.50', '2025-05-20', '1', '3');
INSERT INTO `notas` VALUES('287', '1904', '6', '4.10', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('288', '1904', '6', '4.80', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('289', '1904', '6', '5.80', '2025-05-20', '1', '3');
INSERT INTO `notas` VALUES('291', '1905', '6', '4.60', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('292', '1905', '6', '6.30', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('293', '1905', '6', '7.00', '2025-05-20', '1', '3');
INSERT INTO `notas` VALUES('295', '1906', '6', '5.50', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('296', '1906', '6', '5.00', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('297', '1906', '6', '7.00', '2025-05-20', '1', '3');
INSERT INTO `notas` VALUES('299', '1907', '6', '6.30', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('300', '1907', '6', '6.60', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('301', '1907', '6', '7.00', '2025-05-20', '1', '3');
INSERT INTO `notas` VALUES('303', '1908', '6', '7.00', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('304', '1908', '6', '7.00', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('306', '1909', '6', '4.80', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('307', '1909', '6', '6.30', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('308', '1909', '6', '7.00', '2025-05-20', '1', '3');
INSERT INTO `notas` VALUES('310', '1910', '6', '4.60', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('311', '1910', '6', '6.50', '2025-05-20', '1', '3');
INSERT INTO `notas` VALUES('313', '1911', '6', '5.70', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('315', '1912', '6', '5.90', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('316', '1912', '6', '6.30', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('317', '1912', '6', '6.00', '2025-05-20', '1', '3');
INSERT INTO `notas` VALUES('319', '1913', '6', '5.00', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('320', '1913', '6', '6.10', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('321', '1913', '6', '7.00', '2025-05-20', '1', '3');
INSERT INTO `notas` VALUES('323', '1914', '6', '5.20', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('324', '1914', '6', '5.90', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('325', '1914', '6', '6.80', '2025-05-20', '1', '3');
INSERT INTO `notas` VALUES('327', '1915', '6', '4.80', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('328', '1915', '6', '6.10', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('329', '1915', '6', '6.00', '2025-05-20', '1', '3');
INSERT INTO `notas` VALUES('331', '1916', '6', '6.10', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('332', '1916', '6', '6.60', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('333', '1916', '6', '7.00', '2025-05-20', '1', '3');
INSERT INTO `notas` VALUES('335', '1917', '6', '5.00', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('336', '1917', '6', '6.60', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('337', '1917', '6', '7.00', '2025-05-20', '1', '3');
INSERT INTO `notas` VALUES('339', '1921', '6', '7.00', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('340', '1921', '6', '7.00', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('341', '1921', '6', '6.50', '2025-05-20', '1', '3');
INSERT INTO `notas` VALUES('343', '1918', '6', '4.60', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('344', '1918', '6', '5.90', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('345', '1918', '6', '7.00', '2025-05-20', '1', '3');
INSERT INTO `notas` VALUES('347', '1901', '6', '5.70', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('348', '1919', '6', '7.00', '2025-05-20', '1', '3');
INSERT INTO `notas` VALUES('349', '1908', '6', '6.50', '2025-05-20', '1', '3');
INSERT INTO `notas` VALUES('350', '1910', '6', '5.20', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('351', '1911', '6', '6.10', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('352', '1911', '6', '6.00', '2025-05-20', '1', '3');
INSERT INTO `notas` VALUES('353', '1898', '7', '3.70', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('354', '1899', '7', '6.30', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('355', '1900', '7', '2.50', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('356', '1901', '7', '4.70', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('357', '1902', '7', '4.90', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('358', '1920', '7', '6.50', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('359', '1919', '7', '4.50', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('360', '1903', '7', '7.00', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('361', '1904', '7', '6.00', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('362', '1905', '7', '6.10', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('363', '1906', '7', '4.00', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('364', '1907', '7', '5.20', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('365', '1908', '7', '4.90', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('366', '1909', '7', '6.90', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('367', '1910', '7', '3.70', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('368', '1911', '7', '5.00', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('369', '1912', '7', '4.80', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('370', '1913', '7', '6.00', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('371', '1914', '7', '3.80', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('372', '1915', '7', '4.40', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('373', '1916', '7', '5.80', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('374', '1917', '7', '3.10', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('375', '1921', '7', '7.00', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('376', '1918', '7', '6.20', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('377', '1898', '4', '7.00', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('378', '1898', '4', '7.00', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('379', '1899', '4', '6.90', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('380', '1899', '4', '7.00', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('381', '1900', '4', '7.00', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('382', '1900', '4', '7.00', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('383', '1901', '4', '6.60', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('384', '1901', '4', '4.80', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('385', '1902', '4', '7.00', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('386', '1902', '4', '6.00', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('387', '1920', '4', '7.00', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('388', '1920', '4', '6.00', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('389', '1919', '4', '5.50', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('390', '1919', '4', '6.00', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('391', '1903', '4', '6.70', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('392', '1903', '4', '6.80', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('393', '1904', '4', '4.50', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('394', '1904', '4', '6.00', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('395', '1905', '4', '6.50', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('396', '1905', '4', '5.90', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('397', '1906', '4', '5.50', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('398', '1906', '4', '6.20', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('399', '1907', '4', '6.00', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('400', '1907', '4', '7.00', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('401', '1908', '4', '6.80', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('402', '1908', '4', '6.50', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('403', '1909', '4', '4.40', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('404', '1909', '4', '6.60', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('405', '1910', '4', '5.60', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('406', '1910', '4', '5.80', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('407', '1911', '4', '6.10', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('408', '1911', '4', '6.00', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('409', '1912', '4', '6.00', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('410', '1912', '4', '6.00', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('411', '1913', '4', '7.00', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('412', '1913', '4', '6.60', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('413', '1914', '4', '4.70', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('414', '1914', '4', '6.20', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('415', '1915', '4', '6.60', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('416', '1915', '4', '6.40', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('417', '1916', '4', '6.40', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('418', '1916', '4', '5.80', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('419', '1917', '4', '6.60', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('420', '1917', '4', '7.00', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('421', '1921', '4', '7.00', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('422', '1921', '4', '7.00', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('423', '1918', '4', '6.20', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('424', '1918', '4', '6.60', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('425', '1898', '12', '7.00', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('426', '1898', '12', '7.00', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('427', '1899', '12', '7.00', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('428', '1899', '12', '7.00', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('429', '1900', '12', '7.00', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('430', '1900', '12', '7.00', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('431', '1901', '12', '7.00', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('432', '1901', '12', '6.50', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('433', '1902', '12', '7.00', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('434', '1902', '12', '7.00', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('435', '1920', '12', '7.00', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('436', '1920', '12', '7.00', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('437', '1919', '12', '7.00', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('438', '1919', '12', '6.50', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('439', '1903', '12', '7.00', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('440', '1903', '12', '7.00', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('441', '1904', '12', '7.00', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('442', '1904', '12', '6.80', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('443', '1905', '12', '7.00', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('444', '1905', '12', '6.80', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('445', '1906', '12', '7.00', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('446', '1906', '12', '6.80', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('447', '1907', '12', '7.00', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('448', '1907', '12', '7.00', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('449', '1908', '12', '7.00', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('450', '1908', '12', '7.00', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('451', '1909', '12', '7.00', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('452', '1909', '12', '7.00', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('453', '1910', '12', '7.00', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('454', '1910', '12', '6.80', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('455', '1911', '12', '7.00', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('456', '1911', '12', '6.50', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('457', '1912', '12', '7.00', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('458', '1912', '12', '6.80', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('459', '1913', '12', '7.00', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('460', '1913', '12', '7.00', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('461', '1914', '12', '7.00', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('462', '1914', '12', '6.80', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('463', '1915', '12', '7.00', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('464', '1915', '12', '7.00', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('465', '1916', '12', '7.00', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('466', '1916', '12', '6.80', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('467', '1917', '12', '7.00', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('468', '1917', '12', '7.00', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('469', '1921', '12', '7.00', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('470', '1921', '12', '7.00', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('471', '1918', '12', '7.00', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('472', '1918', '12', '6.80', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('473', '1713', '7', '5.20', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('474', '1714', '7', '7.00', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('475', '1715', '7', '5.20', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('476', '1716', '7', '7.00', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('477', '1717', '7', '6.70', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('478', '1718', '7', '7.00', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('479', '1719', '7', '7.00', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('480', '1720', '7', '6.40', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('481', '1721', '7', '6.70', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('482', '1722', '7', '7.00', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('483', '1723', '7', '6.40', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('484', '1724', '7', '6.40', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('485', '1725', '7', '6.70', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('486', '1726', '7', '7.00', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('487', '1727', '7', '7.00', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('488', '1728', '7', '6.40', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('489', '1729', '7', '6.10', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('490', '1730', '7', '6.10', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('491', '1675', '12', '7.00', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('492', '1675', '12', '6.00', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('493', '1676', '12', '6.30', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('494', '1676', '12', '7.00', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('495', '1677', '12', '6.80', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('496', '1677', '12', '6.00', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('497', '1678', '12', '5.50', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('498', '1678', '12', '6.00', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('499', '1679', '12', '5.30', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('500', '1679', '12', '6.00', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('501', '1680', '12', '7.00', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('502', '1680', '12', '6.30', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('503', '1681', '12', '6.80', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('504', '1681', '12', '5.00', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('505', '1682', '12', '5.50', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('506', '1682', '12', '6.30', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('507', '1683', '12', '6.80', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('508', '1683', '12', '7.00', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('509', '1684', '12', '3.70', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('510', '1684', '12', '7.00', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('511', '1685', '12', '7.00', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('512', '1685', '12', '6.80', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('513', '1686', '12', '7.00', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('514', '1687', '12', '6.80', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('515', '1687', '12', '6.00', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('516', '1688', '12', '6.50', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('517', '1688', '12', '6.80', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('518', '1689', '12', '5.80', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('519', '1689', '12', '6.30', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('520', '1690', '12', '7.00', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('521', '1690', '12', '6.50', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('522', '1691', '12', '7.00', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('523', '1691', '12', '7.00', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('524', '1713', '12', '5.00', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('525', '1713', '12', '7.00', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('526', '1714', '12', '7.00', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('527', '1714', '12', '6.40', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('528', '1715', '12', '6.30', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('529', '1716', '12', '7.00', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('530', '1716', '12', '6.70', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('531', '1717', '12', '7.00', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('532', '1717', '12', '5.10', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('533', '1718', '12', '6.50', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('534', '1718', '12', '6.40', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('535', '1719', '12', '7.00', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('536', '1719', '12', '6.40', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('537', '1720', '12', '6.80', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('538', '1720', '12', '7.00', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('539', '1721', '12', '6.80', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('540', '1721', '12', '6.40', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('541', '1722', '12', '6.50', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('542', '1722', '12', '6.70', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('543', '1723', '12', '7.00', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('544', '1723', '12', '6.70', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('545', '1724', '12', '7.00', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('546', '1724', '12', '6.20', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('547', '1725', '12', '6.80', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('548', '1725', '12', '6.20', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('549', '1726', '12', '6.70', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('550', '1726', '12', '6.70', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('551', '1727', '12', '7.00', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('552', '1727', '12', '6.70', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('553', '1728', '12', '7.00', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('554', '1728', '12', '6.70', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('555', '1729', '12', '6.60', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('556', '1729', '12', '6.40', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('557', '1730', '12', '6.80', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('558', '1730', '12', '5.10', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('559', '1713', '4', '5.00', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('560', '1714', '4', '7.00', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('561', '1715', '4', '6.30', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('562', '1716', '4', '7.00', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('563', '1717', '4', '7.00', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('564', '1718', '4', '6.50', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('565', '1719', '4', '7.00', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('566', '1720', '4', '6.80', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('567', '1721', '4', '6.80', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('568', '1722', '4', '6.50', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('569', '1723', '4', '7.00', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('570', '1724', '4', '7.00', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('571', '1725', '4', '6.80', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('572', '1726', '4', '6.70', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('573', '1727', '4', '7.00', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('574', '1728', '4', '7.00', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('575', '1729', '4', '6.60', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('576', '1730', '4', '5.80', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('577', '1675', '11', '5.40', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('578', '1675', '11', '6.80', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('579', '1675', '11', '7.00', '2025-05-20', '1', '3');
INSERT INTO `notas` VALUES('580', '1676', '11', '5.00', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('581', '1676', '11', '6.00', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('582', '1676', '11', '5.30', '2025-05-20', '1', '3');
INSERT INTO `notas` VALUES('583', '1677', '11', '5.50', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('584', '1677', '11', '6.80', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('585', '1677', '11', '6.80', '2025-05-20', '1', '3');
INSERT INTO `notas` VALUES('586', '1678', '11', '4.00', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('587', '1678', '11', '6.80', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('588', '1678', '11', '6.50', '2025-05-20', '1', '3');
INSERT INTO `notas` VALUES('589', '1679', '11', '4.10', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('590', '1679', '11', '6.80', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('591', '1679', '11', '5.50', '2025-05-20', '1', '3');
INSERT INTO `notas` VALUES('592', '1680', '11', '5.20', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('593', '1680', '11', '6.80', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('594', '1680', '11', '6.80', '2025-05-20', '1', '3');
INSERT INTO `notas` VALUES('595', '1681', '11', '5.70', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('596', '1681', '11', '6.60', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('597', '1681', '11', '7.00', '2025-05-20', '1', '3');
INSERT INTO `notas` VALUES('598', '1682', '11', '3.00', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('599', '1682', '11', '6.20', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('600', '1682', '11', '4.50', '2025-05-20', '1', '3');
INSERT INTO `notas` VALUES('601', '1683', '11', '5.40', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('602', '1683', '11', '7.00', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('603', '1683', '11', '6.50', '2025-05-20', '1', '3');
INSERT INTO `notas` VALUES('604', '1684', '11', '6.00', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('605', '1684', '11', '7.00', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('606', '1684', '11', '6.50', '2025-05-20', '1', '3');
INSERT INTO `notas` VALUES('607', '1685', '11', '4.60', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('608', '1685', '11', '6.80', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('609', '1685', '11', '6.00', '2025-05-20', '1', '3');
INSERT INTO `notas` VALUES('610', '1686', '11', '3.00', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('611', '1686', '11', '5.80', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('612', '1686', '11', '6.00', '2025-05-20', '1', '3');
INSERT INTO `notas` VALUES('613', '1687', '11', '3.80', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('614', '1687', '11', '5.00', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('615', '1687', '11', '6.50', '2025-05-20', '1', '3');
INSERT INTO `notas` VALUES('616', '1688', '11', '5.40', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('617', '1688', '11', '6.00', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('618', '1688', '11', '6.80', '2025-05-20', '1', '3');
INSERT INTO `notas` VALUES('619', '1689', '11', '4.20', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('620', '1689', '11', '6.50', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('621', '1689', '11', '4.80', '2025-05-20', '1', '3');
INSERT INTO `notas` VALUES('622', '1690', '11', '7.00', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('623', '1690', '11', '7.00', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('624', '1690', '11', '6.50', '2025-05-20', '1', '3');
INSERT INTO `notas` VALUES('625', '1691', '11', '5.70', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('626', '1691', '11', '5.50', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('627', '1691', '11', '5.80', '2025-05-20', '1', '3');
INSERT INTO `notas` VALUES('630', '1676', '6', '3.40', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('631', '1676', '6', '3.50', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('632', '1677', '6', '6.10', '2025-05-20', '1', '1');
INSERT INTO `notas` VALUES('633', '1677', '6', '7.00', '2025-05-20', '1', '2');
INSERT INTO `notas` VALUES('658', '1429', '1', '6.00', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('659', '1429', '1', '6.60', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('660', '1429', '1', '7.00', '2025-05-22', '1', '3');
INSERT INTO `notas` VALUES('661', '1430', '1', '6.20', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('662', '1430', '1', '6.00', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('663', '1430', '1', '7.00', '2025-05-22', '1', '3');
INSERT INTO `notas` VALUES('664', '1431', '1', '6.80', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('665', '1431', '1', '5.80', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('666', '1431', '1', '7.00', '2025-05-22', '1', '3');
INSERT INTO `notas` VALUES('667', '1432', '1', '7.00', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('668', '1432', '1', '7.00', '2025-05-22', '1', '3');
INSERT INTO `notas` VALUES('669', '1433', '1', '6.60', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('670', '1433', '1', '7.00', '2025-05-22', '1', '3');
INSERT INTO `notas` VALUES('671', '1434', '1', '6.60', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('672', '1434', '1', '7.00', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('673', '1434', '1', '7.00', '2025-05-22', '1', '3');
INSERT INTO `notas` VALUES('674', '1435', '1', '6.00', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('675', '1435', '1', '3.00', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('676', '1436', '1', '7.00', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('677', '1436', '1', '6.40', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('678', '1454', '1', '7.00', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('679', '1454', '1', '6.60', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('680', '1454', '1', '7.00', '2025-05-22', '1', '3');
INSERT INTO `notas` VALUES('681', '1437', '1', '7.00', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('682', '1437', '1', '7.00', '2025-05-22', '1', '3');
INSERT INTO `notas` VALUES('683', '1438', '1', '7.00', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('684', '1438', '1', '5.70', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('685', '1438', '1', '6.80', '2025-05-22', '1', '3');
INSERT INTO `notas` VALUES('686', '1439', '1', '7.00', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('687', '1439', '1', '7.00', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('688', '1439', '1', '7.00', '2025-05-22', '1', '3');
INSERT INTO `notas` VALUES('689', '1440', '1', '6.00', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('690', '1441', '1', '7.00', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('691', '1441', '1', '6.00', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('692', '1441', '1', '7.00', '2025-05-22', '1', '3');
INSERT INTO `notas` VALUES('693', '1442', '1', '6.80', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('694', '1442', '1', '7.00', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('695', '1442', '1', '7.00', '2025-05-22', '1', '3');
INSERT INTO `notas` VALUES('696', '1443', '1', '6.40', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('697', '1443', '1', '6.20', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('698', '1444', '1', '6.80', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('699', '1444', '1', '6.60', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('700', '1445', '1', '7.00', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('701', '1445', '1', '6.60', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('702', '1445', '1', '6.80', '2025-05-22', '1', '3');
INSERT INTO `notas` VALUES('703', '1446', '1', '7.00', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('704', '1446', '1', '6.80', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('705', '1446', '1', '7.00', '2025-05-22', '1', '3');
INSERT INTO `notas` VALUES('706', '1447', '1', '6.40', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('707', '1447', '1', '5.30', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('708', '1447', '1', '7.00', '2025-05-22', '1', '3');
INSERT INTO `notas` VALUES('709', '1948', '8', '6.00', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('710', '1948', '8', '5.50', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('711', '1949', '8', '5.80', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('712', '1949', '8', '5.30', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('713', '1950', '8', '6.80', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('714', '1951', '8', '5.60', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('715', '1951', '8', '5.90', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('716', '1952', '8', '5.60', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('717', '1952', '8', '5.70', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('718', '1953', '8', '6.40', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('719', '1953', '8', '6.60', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('720', '1954', '8', '6.20', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('721', '1954', '8', '6.10', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('722', '1956', '8', '3.20', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('723', '1956', '8', '5.70', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('724', '1957', '8', '2.00', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('725', '1957', '8', '4.00', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('726', '1958', '8', '6.20', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('727', '1958', '8', '6.10', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('728', '1959', '8', '7.00', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('729', '1959', '8', '6.10', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('730', '1960', '8', '6.00', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('731', '1960', '8', '6.60', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('732', '1961', '8', '2.00', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('733', '1961', '8', '4.40', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('734', '1962', '8', '6.20', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('735', '1963', '8', '7.00', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('736', '1963', '8', '6.60', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('737', '1964', '8', '5.80', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('738', '1964', '8', '5.30', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('739', '1965', '8', '6.00', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('740', '1965', '8', '5.50', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('741', '1966', '8', '6.00', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('742', '1966', '8', '6.60', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('743', '1967', '8', '4.00', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('744', '1967', '8', '4.00', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('745', '1968', '8', '6.40', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('746', '1968', '8', '5.50', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('747', '1969', '8', '5.90', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('748', '1969', '8', '5.90', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('749', '1970', '8', '6.20', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('750', '1970', '8', '6.40', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('751', '1971', '8', '3.10', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('752', '1971', '8', '5.70', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('753', '1972', '8', '6.00', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('754', '1972', '8', '5.50', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('755', '1973', '8', '5.80', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('756', '1973', '8', '5.30', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('757', '1975', '8', '3.20', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('758', '1975', '8', '5.90', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('759', '1976', '8', '6.40', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('760', '1976', '8', '6.80', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('761', '1977', '8', '6.00', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('762', '1977', '8', '6.40', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('763', '1978', '8', '6.40', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('764', '1978', '8', '6.60', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('765', '1979', '8', '3.00', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('766', '1979', '8', '4.00', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('767', '1980', '8', '6.40', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('768', '1980', '8', '5.30', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('769', '1981', '8', '7.00', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('770', '1981', '8', '6.60', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('771', '1982', '8', '5.00', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('772', '1982', '8', '5.00', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('773', '1983', '8', '3.10', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('774', '1983', '8', '4.40', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('775', '1984', '8', '6.20', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('776', '1984', '8', '6.40', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('777', '1985', '8', '3.20', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('778', '1985', '8', '5.50', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('779', '1986', '8', '3.10', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('780', '1987', '8', '6.20', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('781', '1987', '8', '6.10', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('782', '1692', '8', '3.00', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('783', '1692', '8', '4.70', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('784', '1693', '8', '5.60', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('785', '1693', '8', '5.70', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('786', '1694', '8', '5.80', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('787', '1694', '8', '5.70', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('788', '1695', '8', '6.40', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('789', '1695', '8', '5.00', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('790', '1697', '8', '3.50', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('791', '1697', '8', '5.70', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('792', '1698', '8', '5.80', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('793', '1699', '8', '3.50', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('794', '1699', '8', '5.30', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('795', '1700', '8', '6.40', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('796', '1700', '8', '5.30', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('797', '1701', '8', '6.40', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('798', '1701', '8', '4.30', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('799', '1702', '8', '5.80', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('800', '1702', '8', '5.30', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('801', '1703', '8', '5.80', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('802', '1703', '8', '5.00', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('803', '1704', '8', '5.80', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('804', '1704', '8', '5.00', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('805', '1705', '8', '3.00', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('806', '1705', '8', '5.70', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('807', '1706', '8', '3.00', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('808', '1706', '8', '4.70', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('809', '1707', '8', '5.60', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('810', '1707', '8', '4.70', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('811', '1708', '8', '6.40', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('812', '1708', '8', '6.30', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('813', '1709', '8', '3.50', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('814', '1709', '8', '5.30', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('815', '1710', '8', '3.70', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('816', '1710', '8', '5.00', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('817', '1711', '8', '5.60', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('818', '1712', '8', '3.70', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('819', '1712', '8', '4.30', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('820', '1675', '8', '7.00', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('821', '1675', '8', '7.00', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('822', '1676', '8', '4.00', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('823', '1676', '8', '4.60', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('824', '1677', '8', '5.80', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('825', '1677', '8', '7.00', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('826', '1678', '8', '5.60', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('827', '1678', '8', '7.00', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('828', '1679', '8', '5.60', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('829', '1679', '8', '4.60', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('830', '1680', '8', '5.20', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('831', '1680', '8', '4.60', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('832', '1681', '8', '6.40', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('833', '1681', '8', '5.80', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('834', '1682', '8', '4.00', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('835', '1682', '8', '4.80', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('836', '1683', '8', '5.20', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('837', '1683', '8', '5.80', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('838', '1684', '8', '4.00', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('839', '1684', '8', '4.80', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('840', '1685', '8', '4.60', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('841', '1685', '8', '7.00', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('842', '1686', '8', '5.00', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('843', '1687', '8', '4.00', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('844', '1687', '8', '5.60', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('845', '1688', '8', '4.00', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('846', '1688', '8', '4.80', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('847', '1689', '8', '5.20', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('848', '1689', '8', '4.80', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('849', '1690', '8', '4.00', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('850', '1690', '8', '5.20', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('851', '1691', '8', '5.20', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('852', '1691', '8', '4.60', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('853', '1585', '8', '4.00', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('854', '1585', '8', '5.20', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('855', '1586', '8', '3.30', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('856', '1586', '8', '4.60', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('857', '1587', '8', '4.40', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('858', '1587', '8', '5.80', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('859', '1588', '8', '5.10', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('860', '1588', '8', '5.20', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('861', '1589', '8', '4.00', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('862', '1589', '8', '4.60', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('863', '1590', '8', '5.20', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('864', '1590', '8', '4.60', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('865', '1591', '8', '3.00', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('866', '1591', '8', '4.60', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('867', '1592', '8', '4.30', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('868', '1592', '8', '4.60', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('869', '1593', '8', '4.50', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('870', '1593', '8', '4.60', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('871', '1594', '8', '5.60', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('872', '1594', '8', '5.20', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('873', '1595', '8', '5.40', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('874', '1595', '8', '5.80', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('875', '1596', '8', '4.30', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('876', '1596', '8', '5.20', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('877', '1597', '8', '4.20', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('878', '1597', '8', '5.80', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('879', '1598', '8', '4.00', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('880', '1598', '8', '6.40', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('881', '1599', '8', '4.30', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('882', '1599', '8', '5.20', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('883', '1600', '8', '4.30', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('884', '1600', '8', '4.60', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('885', '1601', '8', '4.10', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('886', '1601', '8', '5.80', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('887', '1602', '8', '4.00', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('888', '1602', '8', '5.20', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('889', '1603', '8', '4.50', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('890', '1603', '8', '7.00', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('891', '1604', '8', '3.50', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('892', '1604', '8', '4.20', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('893', '1605', '8', '4.60', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('894', '1605', '8', '5.80', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('895', '1606', '8', '3.00', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('896', '1606', '8', '4.60', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('897', '1607', '8', '4.90', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('898', '1607', '8', '5.20', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('899', '1608', '8', '4.20', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('900', '1608', '8', '4.60', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('901', '1609', '8', '4.30', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('902', '1609', '8', '5.20', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('903', '1713', '8', '5.10', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('904', '1713', '8', '4.60', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('905', '1714', '8', '5.50', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('906', '1714', '8', '6.40', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('907', '1715', '8', '4.80', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('908', '1715', '8', '4.60', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('909', '1716', '8', '5.50', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('910', '1716', '8', '5.20', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('911', '1717', '8', '4.80', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('912', '1717', '8', '4.20', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('913', '1718', '8', '5.90', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('914', '1718', '8', '4.60', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('915', '1719', '8', '5.90', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('916', '1719', '8', '6.40', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('917', '1720', '8', '4.20', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('918', '1720', '8', '4.60', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('919', '1721', '8', '4.00', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('920', '1721', '8', '7.00', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('921', '1722', '8', '3.80', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('922', '1722', '8', '5.80', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('923', '1723', '8', '2.80', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('924', '1723', '8', '4.60', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('925', '1724', '8', '5.50', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('926', '1724', '8', '4.20', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('927', '1725', '8', '5.10', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('928', '1725', '8', '7.00', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('929', '1726', '8', '2.80', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('930', '1726', '8', '4.60', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('931', '1727', '8', '6.60', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('932', '1727', '8', '5.20', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('933', '1728', '8', '6.30', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('934', '1728', '8', '7.00', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('935', '1729', '8', '6.30', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('936', '1729', '8', '7.00', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('937', '1730', '8', '2.80', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('938', '1730', '8', '4.20', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('939', '1922', '8', '5.50', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('940', '1922', '8', '7.00', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('941', '1923', '8', '3.00', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('942', '1923', '8', '3.00', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('943', '1924', '8', '4.00', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('944', '1924', '8', '2.70', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('945', '1925', '8', '7.00', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('946', '1925', '8', '4.50', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('947', '1926', '8', '6.00', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('948', '1926', '8', '3.70', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('949', '1927', '8', '3.00', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('950', '1927', '8', '6.00', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('951', '1928', '8', '2.70', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('952', '1928', '8', '4.00', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('953', '1929', '8', '7.00', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('954', '1929', '8', '3.70', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('955', '1930', '8', '4.50', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('956', '1930', '8', '3.00', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('957', '1931', '8', '4.00', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('958', '1931', '8', '3.00', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('959', '1932', '8', '5.00', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('960', '1932', '8', '4.50', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('961', '1933', '8', '7.00', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('962', '1933', '8', '5.00', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('963', '1934', '8', '7.00', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('964', '1934', '8', '7.00', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('965', '1935', '8', '6.00', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('966', '1935', '8', '7.00', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('967', '1936', '8', '5.00', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('968', '1936', '8', '3.30', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('969', '1937', '8', '7.00', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('970', '1937', '8', '4.50', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('971', '1938', '8', '5.50', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('972', '1938', '8', '3.00', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('973', '1939', '8', '3.00', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('974', '1939', '8', '3.00', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('975', '1940', '8', '5.00', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('976', '1940', '8', '3.70', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('977', '1941', '8', '7.00', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('978', '1941', '8', '5.50', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('979', '1942', '8', '5.50', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('980', '1942', '8', '4.60', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('981', '1943', '8', '7.00', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('982', '1943', '8', '7.00', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('983', '1944', '8', '5.50', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('984', '1944', '8', '4.00', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('985', '1945', '8', '6.50', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('986', '1945', '8', '5.70', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('987', '1946', '8', '7.00', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('988', '1946', '8', '6.00', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('989', '1731', '8', '4.00', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('990', '1731', '8', '6.70', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('991', '1732', '8', '5.50', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('992', '1732', '8', '5.00', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('993', '1733', '8', '5.10', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('994', '1733', '8', '5.70', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('995', '1734', '8', '5.10', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('996', '1734', '8', '5.00', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('997', '1735', '8', '5.90', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('998', '1735', '8', '5.00', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('999', '1736', '8', '4.00', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('1000', '1737', '8', '5.50', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('1001', '1737', '8', '5.70', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('1002', '1738', '8', '5.90', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('1003', '1738', '8', '5.00', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('1004', '1739', '8', '5.90', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('1005', '1740', '8', '5.90', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('1006', '1740', '8', '5.70', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('1007', '1741', '8', '5.90', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('1008', '1741', '8', '5.00', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('1009', '1742', '8', '4.00', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('1010', '1742', '8', '5.00', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('1011', '1743', '8', '4.00', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('1012', '1744', '8', '5.90', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('1013', '1744', '8', '5.00', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('1014', '1745', '8', '4.00', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('1015', '1745', '8', '5.70', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('1016', '1746', '8', '4.00', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('1017', '1747', '8', '4.00', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('1018', '1748', '8', '5.50', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('1019', '1748', '8', '5.00', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('1020', '1749', '8', '4.00', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('1021', '1750', '8', '4.40', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('1022', '1750', '8', '6.70', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('1023', '1731', '11', '5.70', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('1024', '1731', '11', '6.00', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('1025', '1731', '11', '6.50', '2025-05-22', '1', '3');
INSERT INTO `notas` VALUES('1026', '1732', '11', '5.30', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('1027', '1732', '11', '7.00', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('1028', '1732', '11', '7.00', '2025-05-22', '1', '3');
INSERT INTO `notas` VALUES('1029', '1733', '11', '4.70', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('1030', '1733', '11', '6.00', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('1031', '1733', '11', '5.60', '2025-05-22', '1', '3');
INSERT INTO `notas` VALUES('1032', '1734', '11', '5.00', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('1033', '1734', '11', '7.00', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('1034', '1734', '11', '6.80', '2025-05-22', '1', '3');
INSERT INTO `notas` VALUES('1035', '1735', '11', '4.50', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('1036', '1735', '11', '7.00', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('1037', '1735', '11', '6.60', '2025-05-22', '1', '3');
INSERT INTO `notas` VALUES('1038', '1736', '11', '4.00', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('1039', '1736', '11', '6.80', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('1040', '1736', '11', '5.40', '2025-05-22', '1', '3');
INSERT INTO `notas` VALUES('1041', '1737', '11', '5.40', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('1042', '1737', '11', '7.00', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('1043', '1737', '11', '6.50', '2025-05-22', '1', '3');
INSERT INTO `notas` VALUES('1044', '1738', '11', '5.70', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('1045', '1738', '11', '7.00', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('1046', '1738', '11', '6.60', '2025-05-22', '1', '3');
INSERT INTO `notas` VALUES('1047', '1739', '11', '5.20', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('1048', '1739', '11', '5.10', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('1049', '1739', '11', '6.50', '2025-05-22', '1', '3');
INSERT INTO `notas` VALUES('1050', '1740', '11', '5.40', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('1051', '1740', '11', '7.00', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('1052', '1740', '11', '6.60', '2025-05-22', '1', '3');
INSERT INTO `notas` VALUES('1053', '1741', '11', '5.50', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('1054', '1741', '11', '7.00', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('1055', '1741', '11', '7.00', '2025-05-22', '1', '3');
INSERT INTO `notas` VALUES('1056', '1742', '11', '6.50', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('1057', '1742', '11', '6.70', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('1058', '1742', '11', '6.30', '2025-05-22', '1', '3');
INSERT INTO `notas` VALUES('1059', '1743', '11', '4.70', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('1060', '1743', '11', '6.80', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('1061', '1743', '11', '6.10', '2025-05-22', '1', '3');
INSERT INTO `notas` VALUES('1062', '1744', '11', '5.00', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('1063', '1744', '11', '6.20', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('1064', '1744', '11', '6.30', '2025-05-22', '1', '3');
INSERT INTO `notas` VALUES('1065', '1745', '11', '3.00', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('1066', '1745', '11', '6.50', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('1067', '1745', '11', '6.50', '2025-05-22', '1', '3');
INSERT INTO `notas` VALUES('1068', '1746', '11', '5.20', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('1069', '1746', '11', '6.90', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('1070', '1746', '11', '6.10', '2025-05-22', '1', '3');
INSERT INTO `notas` VALUES('1071', '1747', '11', '5.00', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('1072', '1747', '11', '6.80', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('1073', '1747', '11', '6.50', '2025-05-22', '1', '3');
INSERT INTO `notas` VALUES('1074', '1748', '11', '5.50', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('1075', '1748', '11', '7.00', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('1076', '1748', '11', '6.80', '2025-05-22', '1', '3');
INSERT INTO `notas` VALUES('1077', '1749', '11', '2.30', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('1078', '1749', '11', '5.70', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('1079', '1749', '11', '5.40', '2025-05-22', '1', '3');
INSERT INTO `notas` VALUES('1080', '1750', '11', '4.40', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('1081', '1750', '11', '6.60', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('1082', '1750', '11', '5.80', '2025-05-22', '1', '3');
INSERT INTO `notas` VALUES('1083', '1731', '4', '6.00', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('1084', '1732', '4', '7.00', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('1085', '1733', '4', '6.00', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('1086', '1734', '4', '7.00', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('1087', '1735', '4', '7.00', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('1088', '1736', '4', '6.80', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('1089', '1737', '4', '7.00', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('1090', '1738', '4', '7.00', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('1091', '1739', '4', '5.10', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('1092', '1740', '4', '7.00', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('1093', '1741', '4', '7.00', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('1094', '1742', '4', '6.70', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('1095', '1743', '4', '6.80', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('1096', '1744', '4', '6.20', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('1097', '1745', '4', '6.50', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('1098', '1746', '4', '6.90', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('1099', '1747', '4', '6.80', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('1100', '1748', '4', '7.00', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('1101', '1749', '4', '5.70', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('1102', '1750', '4', '6.60', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('1103', '1585', '7', '6.80', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('1104', '1585', '7', '3.10', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('1105', '1586', '7', '6.90', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('1106', '1586', '7', '5.60', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('1107', '1586', '7', '5.00', '2025-05-22', '1', '3');
INSERT INTO `notas` VALUES('1108', '1587', '7', '6.80', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('1109', '1587', '7', '4.00', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('1110', '1587', '7', '4.80', '2025-05-22', '1', '3');
INSERT INTO `notas` VALUES('1111', '1588', '7', '6.80', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('1112', '1588', '7', '4.50', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('1113', '1588', '7', '4.80', '2025-05-22', '1', '3');
INSERT INTO `notas` VALUES('1114', '1589', '7', '6.90', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('1115', '1589', '7', '4.80', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('1116', '1589', '7', '3.80', '2025-05-22', '1', '3');
INSERT INTO `notas` VALUES('1117', '1590', '7', '7.00', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('1118', '1590', '7', '5.10', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('1119', '1590', '7', '4.60', '2025-05-22', '1', '3');
INSERT INTO `notas` VALUES('1120', '1591', '7', '6.50', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('1121', '1591', '7', '4.00', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('1122', '1591', '7', '2.00', '2025-05-22', '1', '3');
INSERT INTO `notas` VALUES('1123', '1592', '7', '7.00', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('1124', '1592', '7', '5.90', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('1125', '1592', '7', '5.70', '2025-05-22', '1', '3');
INSERT INTO `notas` VALUES('1126', '1593', '7', '7.00', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('1127', '1593', '7', '6.90', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('1128', '1593', '7', '5.00', '2025-05-22', '1', '3');
INSERT INTO `notas` VALUES('1129', '1594', '7', '6.80', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('1130', '1594', '7', '3.50', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('1131', '1594', '7', '3.60', '2025-05-22', '1', '3');
INSERT INTO `notas` VALUES('1132', '1595', '7', '7.00', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('1133', '1595', '7', '4.80', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('1134', '1595', '7', '5.50', '2025-05-22', '1', '3');
INSERT INTO `notas` VALUES('1135', '1596', '7', '7.00', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('1136', '1596', '7', '5.90', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('1137', '1596', '7', '6.60', '2025-05-22', '1', '3');
INSERT INTO `notas` VALUES('1138', '1597', '7', '6.50', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('1139', '1597', '7', '4.20', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('1140', '1597', '7', '4.20', '2025-05-22', '1', '3');
INSERT INTO `notas` VALUES('1141', '1598', '7', '7.00', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('1142', '1598', '7', '4.00', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('1143', '1598', '7', '3.60', '2025-05-22', '1', '3');
INSERT INTO `notas` VALUES('1144', '1599', '7', '7.00', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('1145', '1599', '7', '3.10', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('1146', '1599', '7', '4.80', '2025-05-22', '1', '3');
INSERT INTO `notas` VALUES('1147', '1600', '7', '7.00', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('1148', '1600', '7', '4.00', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('1149', '1600', '7', '4.80', '2025-05-22', '1', '3');
INSERT INTO `notas` VALUES('1150', '1601', '7', '7.00', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('1151', '1601', '7', '5.60', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('1152', '1601', '7', '6.10', '2025-05-22', '1', '3');
INSERT INTO `notas` VALUES('1153', '1602', '7', '7.00', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('1154', '1602', '7', '5.10', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('1155', '1602', '7', '5.10', '2025-05-22', '1', '3');
INSERT INTO `notas` VALUES('1156', '1603', '7', '7.00', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('1157', '1603', '7', '5.60', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('1158', '1603', '7', '5.00', '2025-05-22', '1', '3');
INSERT INTO `notas` VALUES('1159', '1604', '7', '6.40', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('1160', '1604', '7', '3.10', '2025-05-22', '1', '3');
INSERT INTO `notas` VALUES('1161', '1605', '7', '7.00', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('1162', '1605', '7', '2.70', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('1163', '1605', '7', '5.00', '2025-05-22', '1', '3');
INSERT INTO `notas` VALUES('1164', '1606', '7', '5.30', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('1165', '1606', '7', '5.10', '2025-05-22', '1', '3');
INSERT INTO `notas` VALUES('1166', '1607', '7', '7.00', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('1167', '1607', '7', '6.70', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('1168', '1607', '7', '5.50', '2025-05-22', '1', '3');
INSERT INTO `notas` VALUES('1169', '1608', '7', '6.90', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('1170', '1608', '7', '4.50', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('1171', '1608', '7', '2.70', '2025-05-22', '1', '3');
INSERT INTO `notas` VALUES('1172', '1609', '7', '6.50', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('1173', '1609', '7', '4.80', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('1174', '1609', '7', '6.10', '2025-05-22', '1', '3');
INSERT INTO `notas` VALUES('1175', '1731', '12', '6.00', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('1176', '1731', '12', '5.90', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('1177', '1732', '12', '7.00', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('1178', '1732', '12', '6.70', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('1179', '1733', '12', '6.00', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('1180', '1733', '12', '5.30', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('1181', '1734', '12', '7.00', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('1182', '1734', '12', '7.00', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('1183', '1735', '12', '7.00', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('1184', '1735', '12', '6.70', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('1185', '1736', '12', '6.80', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('1186', '1736', '12', '5.90', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('1187', '1737', '12', '7.00', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('1188', '1737', '12', '4.80', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('1189', '1738', '12', '7.00', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('1190', '1738', '12', '6.70', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('1191', '1739', '12', '5.10', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('1192', '1739', '12', '6.10', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('1193', '1740', '12', '7.00', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('1194', '1740', '12', '7.00', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('1195', '1741', '12', '7.00', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('1196', '1741', '12', '7.00', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('1197', '1742', '12', '6.70', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('1198', '1742', '12', '6.30', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('1199', '1743', '12', '6.80', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('1200', '1743', '12', '6.70', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('1201', '1744', '12', '6.20', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('1202', '1744', '12', '7.00', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('1203', '1745', '12', '6.50', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('1204', '1745', '12', '6.20', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('1205', '1746', '12', '6.90', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('1206', '1746', '12', '6.00', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('1207', '1747', '12', '6.80', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('1208', '1747', '12', '6.40', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('1209', '1748', '12', '7.00', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('1210', '1748', '12', '7.00', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('1211', '1749', '12', '5.70', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('1212', '1749', '12', '5.30', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('1213', '1750', '12', '6.60', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('1214', '1750', '12', '6.20', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('1215', '1675', '2', '3.50', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('1216', '1675', '2', '3.10', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('1217', '1675', '2', '3.60', '2025-05-22', '1', '3');
INSERT INTO `notas` VALUES('1218', '1676', '2', '2.70', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('1219', '1676', '2', '2.40', '2025-05-22', '1', '3');
INSERT INTO `notas` VALUES('1220', '1677', '2', '6.20', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('1221', '1677', '2', '7.00', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('1222', '1677', '2', '7.00', '2025-05-22', '1', '3');
INSERT INTO `notas` VALUES('1223', '1678', '2', '6.00', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('1224', '1678', '2', '7.00', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('1225', '1678', '2', '6.10', '2025-05-22', '1', '3');
INSERT INTO `notas` VALUES('1226', '1679', '2', '2.70', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('1227', '1679', '2', '3.70', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('1228', '1679', '2', '5.80', '2025-05-22', '1', '3');
INSERT INTO `notas` VALUES('1229', '1680', '2', '6.00', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('1230', '1680', '2', '5.80', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('1231', '1680', '2', '5.80', '2025-05-22', '1', '3');
INSERT INTO `notas` VALUES('1232', '1681', '2', '6.90', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('1233', '1681', '2', '3.40', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('1234', '1681', '2', '6.90', '2025-05-22', '1', '3');
INSERT INTO `notas` VALUES('1235', '1682', '2', '4.70', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('1236', '1682', '2', '4.60', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('1237', '1682', '2', '4.00', '2025-05-22', '1', '3');
INSERT INTO `notas` VALUES('1238', '1683', '2', '6.50', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('1239', '1683', '2', '3.10', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('1240', '1683', '2', '6.40', '2025-05-22', '1', '3');
INSERT INTO `notas` VALUES('1241', '1684', '2', '5.40', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('1242', '1684', '2', '6.70', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('1243', '1684', '2', '6.90', '2025-05-22', '1', '3');
INSERT INTO `notas` VALUES('1244', '1685', '2', '4.30', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('1245', '1685', '2', '5.40', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('1246', '1685', '2', '5.40', '2025-05-22', '1', '3');
INSERT INTO `notas` VALUES('1247', '1687', '2', '3.90', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('1248', '1687', '2', '3.90', '2025-05-22', '1', '3');
INSERT INTO `notas` VALUES('1249', '1688', '2', '4.50', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('1250', '1688', '2', '4.00', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('1251', '1688', '2', '4.00', '2025-05-22', '1', '3');
INSERT INTO `notas` VALUES('1252', '1689', '2', '2.40', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('1253', '1689', '2', '3.70', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('1254', '1689', '2', '3.00', '2025-05-22', '1', '3');
INSERT INTO `notas` VALUES('1255', '1690', '2', '4.30', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('1256', '1690', '2', '4.90', '2025-05-22', '1', '2');
INSERT INTO `notas` VALUES('1257', '1690', '2', '6.30', '2025-05-22', '1', '3');
INSERT INTO `notas` VALUES('1258', '1691', '2', '2.10', '2025-05-22', '1', '1');
INSERT INTO `notas` VALUES('1259', '1691', '2', '3.40', '2025-05-22', '1', '3');
INSERT INTO `notas` VALUES('1260', '1713', '8', '5.90', '2025-05-23', '1', '3');
INSERT INTO `notas` VALUES('1261', '1714', '8', '5.90', '2025-05-23', '1', '3');
INSERT INTO `notas` VALUES('1262', '1716', '8', '5.50', '2025-05-23', '1', '3');
INSERT INTO `notas` VALUES('1263', '1717', '8', '4.40', '2025-05-23', '1', '3');
INSERT INTO `notas` VALUES('1264', '1719', '8', '5.90', '2025-05-23', '1', '3');
INSERT INTO `notas` VALUES('1265', '1720', '8', '4.40', '2025-05-23', '1', '3');
INSERT INTO `notas` VALUES('1266', '1721', '8', '4.80', '2025-05-23', '1', '3');
INSERT INTO `notas` VALUES('1267', '1722', '8', '4.00', '2025-05-23', '1', '3');
INSERT INTO `notas` VALUES('1268', '1724', '8', '4.80', '2025-05-23', '1', '3');
INSERT INTO `notas` VALUES('1269', '1725', '8', '5.50', '2025-05-23', '1', '3');
INSERT INTO `notas` VALUES('1270', '1726', '8', '4.80', '2025-05-23', '1', '3');
INSERT INTO `notas` VALUES('1271', '1727', '8', '6.30', '2025-05-23', '1', '3');
INSERT INTO `notas` VALUES('1272', '1728', '8', '7.00', '2025-05-23', '1', '3');
INSERT INTO `notas` VALUES('1273', '1729', '8', '6.30', '2025-05-23', '1', '3');
INSERT INTO `notas` VALUES('1274', '1730', '8', '5.50', '2025-05-23', '1', '3');
INSERT INTO `notas` VALUES('1275', '1429', '5', '6.70', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1276', '1429', '5', '7.00', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1277', '1430', '5', '6.80', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1278', '1430', '5', '6.60', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1279', '1431', '5', '6.50', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1280', '1431', '5', '7.00', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1281', '1432', '5', '6.70', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1282', '1432', '5', '7.00', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1283', '1433', '5', '6.80', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1284', '1433', '5', '7.00', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1285', '1434', '5', '7.00', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1286', '1435', '5', '7.00', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1287', '1436', '5', '6.80', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1288', '1436', '5', '7.00', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1289', '1454', '5', '7.00', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1290', '1437', '5', '6.70', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1291', '1437', '5', '7.00', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1292', '1438', '5', '7.00', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1293', '1438', '5', '7.00', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1294', '1439', '5', '6.80', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1295', '1439', '5', '7.00', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1296', '1440', '5', '6.70', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1297', '1440', '5', '6.60', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1298', '1441', '5', '6.80', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1299', '1441', '5', '7.00', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1300', '1442', '5', '6.80', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1301', '1442', '5', '7.00', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1302', '1443', '5', '6.80', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1303', '1443', '5', '7.00', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1304', '1444', '5', '6.50', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1305', '1444', '5', '6.60', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1306', '1445', '5', '6.50', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1307', '1445', '5', '7.00', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1308', '1446', '5', '6.80', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1309', '1446', '5', '7.00', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1310', '1447', '5', '7.00', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1311', '1447', '5', '7.00', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1312', '1448', '5', '7.00', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1313', '1448', '5', '6.30', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1314', '1449', '5', '6.30', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1315', '1449', '5', '6.30', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1316', '1825', '5', '6.60', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1317', '1450', '5', '6.30', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1318', '1450', '5', '6.60', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1319', '1451', '5', '6.70', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1320', '1451', '5', '6.30', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1321', '1453', '5', '6.30', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1322', '1453', '5', '7.00', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1323', '1455', '5', '7.00', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1324', '1455', '5', '7.00', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1325', '1456', '5', '7.00', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1326', '1456', '5', '6.30', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1327', '1457', '5', '7.00', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1328', '1457', '5', '7.00', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1329', '1843', '5', '6.50', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1330', '1843', '5', '6.50', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1331', '1458', '5', '7.00', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1332', '1459', '5', '6.60', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1333', '1459', '5', '7.00', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1334', '1842', '5', '6.50', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1335', '1842', '5', '6.50', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1336', '1460', '5', '6.50', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1337', '1460', '5', '7.00', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1338', '1461', '5', '7.00', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1339', '1462', '5', '6.70', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1340', '1462', '5', '6.30', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1341', '1463', '5', '7.00', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1342', '1464', '5', '6.70', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1343', '1464', '5', '6.30', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1344', '1467', '5', '6.70', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1345', '1467', '5', '7.00', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1346', '1844', '5', '6.80', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1347', '1844', '5', '7.00', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1348', '1845', '5', '7.00', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1349', '1845', '5', '7.00', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1350', '1846', '5', '6.80', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1351', '1846', '5', '6.60', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1352', '1847', '5', '7.00', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1353', '1847', '5', '7.00', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1354', '1848', '5', '6.80', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1355', '1848', '5', '6.60', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1356', '1849', '5', '7.00', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1357', '1849', '5', '7.00', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1358', '1850', '5', '6.80', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1359', '1850', '5', '7.00', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1360', '1851', '5', '6.70', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1361', '1851', '5', '6.60', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1362', '1852', '5', '6.80', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1363', '1852', '5', '7.00', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1364', '1853', '5', '6.80', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1365', '1853', '5', '7.00', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1366', '1854', '5', '6.80', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1367', '1854', '5', '6.30', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1368', '1855', '5', '6.80', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1369', '1855', '5', '6.60', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1370', '1856', '5', '6.80', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1371', '1856', '5', '7.00', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1372', '1857', '5', '6.80', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1373', '1857', '5', '7.00', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1374', '1858', '5', '6.50', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1375', '1858', '5', '6.60', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1376', '1859', '5', '6.70', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1377', '1859', '5', '7.00', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1378', '1860', '5', '6.70', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1379', '1860', '5', '7.00', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1380', '1861', '5', '7.00', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1381', '1861', '5', '7.00', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1382', '1862', '5', '6.70', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1383', '1862', '5', '7.00', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1384', '1863', '5', '7.00', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1385', '1863', '5', '6.60', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1386', '1864', '5', '6.80', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1387', '1864', '5', '7.00', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1388', '1865', '5', '7.00', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1389', '1865', '5', '6.30', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1390', '1866', '5', '6.80', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1391', '1866', '5', '7.00', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1392', '1867', '5', '7.00', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1393', '1867', '5', '7.00', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1394', '1868', '5', '7.00', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1395', '1868', '5', '6.30', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1396', '1869', '5', '6.80', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1397', '1869', '5', '7.00', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1398', '1870', '5', '7.00', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1399', '1870', '5', '7.00', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1400', '1871', '5', '7.00', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1401', '1871', '5', '7.00', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1402', '1872', '5', '6.80', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1403', '1872', '5', '7.00', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1404', '1873', '5', '6.80', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1405', '1873', '5', '7.00', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1406', '1874', '5', '6.80', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1407', '1874', '5', '7.00', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1408', '1875', '5', '7.00', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1409', '1875', '5', '6.60', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1410', '1876', '5', '6.80', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1411', '1876', '5', '7.00', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1412', '1878', '5', '6.90', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1413', '1878', '5', '7.00', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1414', '1879', '5', '7.00', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1415', '1879', '5', '6.30', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1416', '1880', '5', '6.00', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1417', '1880', '5', '7.00', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1418', '1881', '5', '6.90', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1419', '1881', '5', '7.00', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1420', '1882', '5', '6.90', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1421', '1882', '5', '7.00', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1422', '1883', '5', '6.70', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1423', '1883', '5', '6.30', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1424', '1884', '5', '6.90', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1425', '1884', '5', '6.30', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1426', '1885', '5', '6.40', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1427', '1885', '5', '6.60', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1428', '1886', '5', '7.00', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1429', '1886', '5', '7.00', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1430', '1887', '5', '7.00', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1431', '1888', '5', '6.60', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1432', '1888', '5', '6.30', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1433', '1889', '5', '6.30', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1434', '1889', '5', '6.30', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1435', '1890', '5', '6.60', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1436', '1890', '5', '6.60', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1437', '1891', '5', '6.90', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1438', '1891', '5', '6.60', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1439', '1892', '5', '7.00', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1440', '1892', '5', '7.00', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1441', '1893', '5', '6.90', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1442', '1894', '5', '6.90', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1443', '1894', '5', '7.00', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1444', '1895', '5', '6.90', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1445', '1895', '5', '6.60', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1446', '1896', '5', '6.60', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1447', '1896', '5', '7.00', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1448', '1897', '5', '7.00', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1449', '1897', '5', '7.00', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1450', '1898', '5', '7.00', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1451', '1898', '5', '7.00', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1452', '1899', '5', '7.00', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1453', '1899', '5', '7.00', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1454', '1900', '5', '6.90', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1455', '1900', '5', '6.30', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1456', '1901', '5', '7.00', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1457', '1901', '5', '6.60', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1458', '1902', '5', '6.60', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1459', '1902', '5', '6.60', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1460', '1920', '5', '7.00', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1461', '1920', '5', '7.00', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1462', '1919', '5', '7.00', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1463', '1919', '5', '7.00', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1464', '1903', '5', '6.60', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1465', '1903', '5', '6.60', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1466', '1904', '5', '6.60', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1467', '1904', '5', '7.00', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1468', '1905', '5', '6.60', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1469', '1905', '5', '7.00', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1470', '1906', '5', '6.60', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1471', '1906', '5', '6.30', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1472', '1907', '5', '7.00', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1473', '1907', '5', '7.00', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1474', '1908', '5', '6.60', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1475', '1908', '5', '7.00', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1476', '1909', '5', '6.90', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1477', '1909', '5', '7.00', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1478', '1910', '5', '6.90', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1479', '1910', '5', '7.00', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1480', '1911', '5', '6.90', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1481', '1911', '5', '6.60', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1482', '1912', '5', '6.90', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1483', '1912', '5', '6.60', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1484', '1913', '5', '6.90', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1485', '1913', '5', '6.60', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1486', '1914', '5', '6.90', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1487', '1914', '5', '6.30', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1488', '1915', '5', '7.00', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1489', '1915', '5', '7.00', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1490', '1916', '5', '6.70', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1491', '1916', '5', '7.00', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1492', '1917', '5', '7.00', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1493', '1917', '5', '7.00', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1494', '1921', '5', '7.00', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1495', '1918', '5', '6.90', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1496', '1918', '5', '7.00', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1497', '1542', '5', '7.00', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1498', '1542', '5', '7.00', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1499', '1543', '5', '6.90', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1500', '1543', '5', '6.30', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1501', '1544', '5', '6.90', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1502', '1544', '5', '7.00', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1503', '1545', '5', '7.00', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1504', '1545', '5', '7.00', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1505', '1546', '5', '6.60', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1506', '1546', '5', '7.00', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1507', '1547', '5', '6.90', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1508', '1547', '5', '7.00', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1509', '1548', '5', '6.90', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1510', '1548', '5', '7.00', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1511', '1549', '5', '6.90', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1512', '1549', '5', '6.30', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1513', '1550', '5', '6.60', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1514', '1550', '5', '6.30', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1515', '1551', '5', '6.90', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1516', '1551', '5', '6.30', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1517', '1552', '5', '6.90', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1518', '1552', '5', '7.00', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1519', '1553', '5', '6.30', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1520', '1554', '5', '6.90', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1521', '1554', '5', '6.30', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1522', '1555', '5', '7.00', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1523', '1555', '5', '7.00', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1524', '1556', '5', '7.00', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1525', '1556', '5', '7.00', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1526', '1557', '5', '6.90', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1527', '1557', '5', '6.30', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1528', '1558', '5', '7.00', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1529', '1558', '5', '7.00', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1530', '1559', '5', '6.90', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1531', '1559', '5', '7.00', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1532', '1560', '5', '7.00', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1533', '1560', '5', '6.60', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1534', '1561', '5', '6.90', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1535', '1561', '5', '7.00', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1536', '1562', '5', '6.90', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1537', '1562', '5', '7.00', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1538', '1563', '5', '6.90', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1539', '1563', '5', '7.00', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1540', '1564', '5', '6.60', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1541', '1564', '5', '7.00', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1542', '1565', '5', '6.90', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1543', '1565', '5', '6.60', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1544', '1566', '5', '6.60', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1545', '1566', '5', '6.60', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1546', '1567', '5', '6.90', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1547', '1567', '5', '7.00', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1548', '1568', '5', '6.90', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1549', '1568', '5', '6.60', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1550', '1569', '5', '6.70', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1551', '1569', '5', '7.00', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1552', '1570', '5', '7.00', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1553', '1570', '5', '7.00', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1554', '1571', '5', '6.90', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1555', '1571', '5', '7.00', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1556', '1572', '5', '6.90', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1557', '1572', '5', '7.00', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1558', '1573', '5', '6.60', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1559', '1573', '5', '7.00', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1560', '1574', '5', '6.30', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1561', '1574', '5', '7.00', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1562', '1575', '5', '7.00', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1563', '1575', '5', '7.00', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1564', '1576', '5', '6.90', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1565', '1576', '5', '7.00', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1566', '1577', '5', '6.60', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1567', '1577', '5', '7.00', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1568', '1578', '5', '6.90', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1569', '1578', '5', '6.60', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1570', '1579', '5', '6.60', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1571', '1579', '5', '7.00', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1572', '1580', '5', '6.70', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1573', '1580', '5', '6.30', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1574', '1581', '5', '6.90', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1575', '1581', '5', '7.00', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1576', '1582', '5', '7.00', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1577', '1582', '5', '7.00', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1578', '1583', '5', '6.60', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1579', '1583', '5', '7.00', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1580', '1584', '5', '6.60', '2025-05-23', '1', '1');
INSERT INTO `notas` VALUES('1581', '1584', '5', '6.60', '2025-05-23', '1', '2');
INSERT INTO `notas` VALUES('1582', '1731', '5', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1583', '1731', '5', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1584', '1732', '5', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1585', '1732', '5', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1586', '1733', '5', '6.30', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1587', '1733', '5', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1588', '1734', '5', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1589', '1734', '5', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1590', '1735', '5', '6.60', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1591', '1735', '5', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1592', '1736', '5', '6.60', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1593', '1736', '5', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1594', '1737', '5', '6.60', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1595', '1737', '5', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1596', '1738', '5', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1597', '1738', '5', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1598', '1739', '5', '6.30', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1599', '1739', '5', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1600', '1740', '5', '6.30', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1601', '1740', '5', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1602', '1741', '5', '6.60', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1603', '1741', '5', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1604', '1742', '5', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1605', '1742', '5', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1606', '1743', '5', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1607', '1743', '5', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1608', '1744', '5', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1609', '1744', '5', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1610', '1745', '5', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1611', '1745', '5', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1612', '1746', '5', '6.60', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1613', '1747', '5', '6.30', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1614', '1747', '5', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1615', '1748', '5', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1616', '1748', '5', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1617', '1749', '5', '6.30', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1618', '1749', '5', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1619', '1750', '5', '6.60', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1620', '1750', '5', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1621', '1675', '5', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1622', '1675', '5', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1623', '1676', '5', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1624', '1677', '5', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1625', '1677', '5', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1626', '1678', '5', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1627', '1678', '5', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1628', '1679', '5', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1629', '1679', '5', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1630', '1680', '5', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1631', '1680', '5', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1632', '1681', '5', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1633', '1681', '5', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1634', '1682', '5', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1635', '1682', '5', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1636', '1683', '5', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1637', '1683', '5', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1638', '1684', '5', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1639', '1684', '5', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1640', '1685', '5', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1641', '1685', '5', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1642', '1686', '5', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1643', '1687', '5', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1644', '1687', '5', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1645', '1688', '5', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1646', '1688', '5', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1647', '1689', '5', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1648', '1689', '5', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1649', '1690', '5', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1650', '1690', '5', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1651', '1691', '5', '6.50', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1652', '1948', '5', '6.70', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1653', '1948', '5', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1654', '1949', '5', '6.20', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1655', '1949', '5', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1656', '1950', '5', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1657', '1950', '5', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1658', '1951', '5', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1659', '1951', '5', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1660', '1952', '5', '6.70', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1661', '1952', '5', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1662', '1953', '5', '6.70', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1663', '1953', '5', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1664', '1954', '5', '5.90', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1665', '1954', '5', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1666', '1956', '5', '5.90', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1667', '1956', '5', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1668', '1957', '5', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1669', '1957', '5', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1670', '1958', '5', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1671', '1958', '5', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1672', '1959', '5', '6.50', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1673', '1959', '5', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1674', '1960', '5', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1675', '1960', '5', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1676', '1961', '5', '5.90', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1677', '1961', '5', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1678', '1962', '5', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1679', '1962', '5', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1680', '1963', '5', '6.20', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1681', '1963', '5', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1682', '1964', '5', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1683', '1964', '5', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1684', '1965', '5', '6.70', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1685', '1965', '5', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1686', '1966', '5', '6.70', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1687', '1966', '5', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1688', '1967', '5', '6.70', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1689', '1968', '5', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1690', '1968', '5', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1691', '1969', '5', '6.70', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1692', '1969', '5', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1693', '1970', '5', '6.20', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1694', '1970', '5', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1695', '1971', '5', '5.10', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1696', '1971', '5', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1697', '1972', '5', '6.70', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1698', '1972', '5', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1699', '1973', '5', '6.70', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1700', '1973', '5', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1701', '1975', '5', '6.20', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1702', '1975', '5', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1703', '1976', '5', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1704', '1976', '5', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1705', '1977', '5', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1706', '1977', '5', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1707', '1978', '5', '6.20', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1708', '1978', '5', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1709', '1979', '5', '6.50', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1710', '1979', '5', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1711', '1980', '5', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1712', '1980', '5', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1713', '1981', '5', '6.20', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1714', '1981', '5', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1715', '1982', '5', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1716', '1982', '5', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1717', '1983', '5', '6.70', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1718', '1983', '5', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1719', '1984', '5', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1720', '1984', '5', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1721', '1985', '5', '6.20', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1722', '1985', '5', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1723', '1986', '5', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1724', '1986', '5', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1725', '1987', '5', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1726', '1987', '5', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1727', '1922', '5', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1728', '1922', '5', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1729', '1923', '5', '6.20', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1730', '1923', '5', '6.50', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1731', '1924', '5', '6.50', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1732', '1924', '5', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1733', '1925', '5', '6.20', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1734', '1925', '5', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1735', '1926', '5', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1736', '1926', '5', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1737', '1927', '5', '6.20', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1738', '1927', '5', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1739', '1928', '5', '6.20', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1740', '1928', '5', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1741', '1929', '5', '6.50', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1742', '1929', '5', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1743', '1930', '5', '6.50', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1744', '1930', '5', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1745', '1931', '5', '6.20', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1746', '1931', '5', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1747', '1932', '5', '6.20', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1748', '1933', '5', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1749', '1933', '5', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1750', '1947', '5', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1751', '1934', '5', '6.70', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1752', '1934', '5', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1753', '1935', '5', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1754', '1935', '5', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1755', '1936', '5', '6.20', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1756', '1937', '5', '6.20', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1757', '1937', '5', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1758', '1938', '5', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1759', '1938', '5', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1760', '1939', '5', '5.70', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1761', '1939', '5', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1762', '1940', '5', '6.20', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1763', '1940', '5', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1764', '1941', '5', '6.70', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1765', '1941', '5', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1766', '1942', '5', '6.70', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1767', '1942', '5', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1768', '1943', '5', '6.50', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1769', '1943', '5', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1770', '1944', '5', '6.20', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1771', '1944', '5', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1772', '1945', '5', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1773', '1945', '5', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1774', '1946', '5', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1775', '1946', '5', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1776', '1585', '5', '6.70', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1777', '1585', '5', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1778', '1586', '5', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1779', '1586', '5', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1780', '1587', '5', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1781', '1588', '5', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1782', '1588', '5', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1783', '1589', '5', '6.70', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1784', '1590', '5', '6.70', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1785', '1591', '5', '6.50', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1786', '1592', '5', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1787', '1592', '5', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1788', '1593', '5', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1789', '1594', '5', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1790', '1594', '5', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1791', '1595', '5', '6.70', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1792', '1595', '5', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1793', '1596', '5', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1794', '1596', '5', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1795', '1597', '5', '6.70', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1796', '1597', '5', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1797', '1598', '5', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1798', '1598', '5', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1799', '1599', '5', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1800', '1599', '5', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1801', '1600', '5', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1802', '1600', '5', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1803', '1601', '5', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1804', '1601', '5', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1805', '1602', '5', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1806', '1603', '5', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1807', '1603', '5', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1808', '1604', '5', '6.50', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1809', '1605', '5', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1810', '1606', '5', '6.70', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1811', '1607', '5', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1812', '1607', '5', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1813', '1608', '5', '6.70', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1814', '1608', '5', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1815', '1609', '5', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1816', '1609', '5', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1817', '1948', '6', '3.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1818', '1948', '6', '6.80', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1819', '1949', '6', '2.60', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1820', '1949', '6', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1821', '1950', '6', '3.80', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1822', '1950', '6', '6.50', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1823', '1951', '6', '4.30', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1824', '1951', '6', '6.70', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1825', '1952', '6', '4.10', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1826', '1952', '6', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1827', '1953', '6', '4.20', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1828', '1953', '6', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1829', '1954', '6', '3.50', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1830', '1954', '6', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1831', '1956', '6', '3.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1832', '1956', '6', '6.80', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1833', '1957', '6', '3.30', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1834', '1957', '6', '2.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1835', '1958', '6', '6.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1836', '1958', '6', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1837', '1959', '6', '4.10', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1838', '1959', '6', '6.30', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1839', '1960', '6', '4.10', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1840', '1960', '6', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1841', '1961', '6', '4.30', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1842', '1961', '6', '6.70', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1843', '1962', '6', '4.10', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1844', '1962', '6', '6.50', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1845', '1963', '6', '5.90', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1846', '1963', '6', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1847', '1964', '6', '4.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1848', '1964', '6', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1849', '1965', '6', '6.50', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1850', '1965', '6', '6.70', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1851', '1966', '6', '5.70', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1852', '1966', '6', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1853', '1967', '6', '4.30', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1854', '1967', '6', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1855', '1968', '6', '3.80', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1856', '1968', '6', '6.80', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1857', '1969', '6', '4.20', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1858', '1969', '6', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1859', '1970', '6', '5.70', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1860', '1970', '6', '6.80', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1861', '1971', '6', '5.70', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1862', '1971', '6', '6.50', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1863', '1972', '6', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1864', '1972', '6', '6.80', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1865', '1973', '6', '3.80', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1866', '1973', '6', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1867', '1975', '6', '5.10', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1868', '1975', '6', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1869', '1976', '6', '5.40', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1870', '1976', '6', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1871', '1977', '6', '4.60', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1872', '1977', '6', '6.80', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1873', '1978', '6', '4.30', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1874', '1978', '6', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1875', '1979', '6', '5.10', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1876', '1979', '6', '6.30', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1877', '1980', '6', '3.20', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1878', '1980', '6', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1879', '1981', '6', '6.60', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1880', '1981', '6', '6.70', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1881', '1982', '6', '5.50', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1882', '1982', '6', '6.80', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1883', '1983', '6', '4.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1884', '1983', '6', '6.50', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1885', '1984', '6', '4.90', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1886', '1984', '6', '6.70', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1887', '1985', '6', '4.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1888', '1985', '6', '6.30', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1889', '1986', '6', '4.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1890', '1986', '6', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1891', '1987', '6', '4.70', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1892', '1987', '6', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1893', '1713', '2', '5.40', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1894', '1713', '2', '4.20', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1895', '1713', '2', '2.80', '2025-05-25', '1', '3');
INSERT INTO `notas` VALUES('1896', '1713', '2', '7.00', '2025-05-25', '1', '4');
INSERT INTO `notas` VALUES('1897', '1714', '2', '5.40', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1898', '1714', '2', '5.80', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1899', '1714', '2', '5.90', '2025-05-25', '1', '3');
INSERT INTO `notas` VALUES('1900', '1714', '2', '5.60', '2025-05-25', '1', '4');
INSERT INTO `notas` VALUES('1901', '1715', '2', '5.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1902', '1715', '2', '4.60', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1903', '1715', '2', '5.90', '2025-05-25', '1', '3');
INSERT INTO `notas` VALUES('1904', '1716', '2', '5.80', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1905', '1716', '2', '5.80', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1906', '1716', '2', '6.30', '2025-05-25', '1', '3');
INSERT INTO `notas` VALUES('1907', '1716', '2', '7.00', '2025-05-25', '1', '4');
INSERT INTO `notas` VALUES('1908', '1717', '2', '6.50', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1909', '1717', '2', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1910', '1717', '2', '5.40', '2025-05-25', '1', '3');
INSERT INTO `notas` VALUES('1911', '1717', '2', '7.00', '2025-05-25', '1', '4');
INSERT INTO `notas` VALUES('1912', '1718', '2', '6.80', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1913', '1718', '2', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1914', '1718', '2', '2.40', '2025-05-25', '1', '3');
INSERT INTO `notas` VALUES('1915', '1718', '2', '3.60', '2025-05-25', '1', '4');
INSERT INTO `notas` VALUES('1916', '1719', '2', '5.50', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1917', '1719', '2', '5.40', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1918', '1719', '2', '2.90', '2025-05-25', '1', '3');
INSERT INTO `notas` VALUES('1919', '1719', '2', '6.10', '2025-05-25', '1', '4');
INSERT INTO `notas` VALUES('1920', '1720', '2', '5.40', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1921', '1720', '2', '5.80', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1922', '1720', '2', '6.10', '2025-05-25', '1', '3');
INSERT INTO `notas` VALUES('1923', '1720', '2', '7.00', '2025-05-25', '1', '4');
INSERT INTO `notas` VALUES('1924', '1721', '2', '6.40', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1925', '1721', '2', '6.40', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1926', '1721', '2', '6.50', '2025-05-25', '1', '3');
INSERT INTO `notas` VALUES('1927', '1721', '2', '7.00', '2025-05-25', '1', '4');
INSERT INTO `notas` VALUES('1928', '1722', '2', '4.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1929', '1722', '2', '4.10', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1930', '1722', '2', '4.80', '2025-05-25', '1', '3');
INSERT INTO `notas` VALUES('1931', '1722', '2', '5.30', '2025-05-25', '1', '4');
INSERT INTO `notas` VALUES('1932', '1723', '2', '4.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1933', '1723', '2', '5.40', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1934', '1723', '2', '4.00', '2025-05-25', '1', '3');
INSERT INTO `notas` VALUES('1935', '1723', '2', '6.10', '2025-05-25', '1', '4');
INSERT INTO `notas` VALUES('1936', '1724', '2', '6.20', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1937', '1724', '2', '6.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1938', '1724', '2', '5.90', '2025-05-25', '1', '3');
INSERT INTO `notas` VALUES('1939', '1724', '2', '6.60', '2025-05-25', '1', '4');
INSERT INTO `notas` VALUES('1940', '1725', '2', '6.30', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1941', '1725', '2', '6.30', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1942', '1725', '2', '5.70', '2025-05-25', '1', '3');
INSERT INTO `notas` VALUES('1943', '1725', '2', '7.00', '2025-05-25', '1', '4');
INSERT INTO `notas` VALUES('1944', '1726', '2', '3.10', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1945', '1726', '2', '5.40', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1946', '1726', '2', '1.60', '2025-05-25', '1', '3');
INSERT INTO `notas` VALUES('1947', '1726', '2', '6.10', '2025-05-25', '1', '4');
INSERT INTO `notas` VALUES('1948', '1727', '2', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1949', '1727', '2', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1950', '1727', '2', '6.90', '2025-05-25', '1', '3');
INSERT INTO `notas` VALUES('1951', '1727', '2', '7.00', '2025-05-25', '1', '4');
INSERT INTO `notas` VALUES('1952', '1728', '2', '5.80', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1953', '1728', '2', '6.60', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1954', '1728', '2', '4.20', '2025-05-25', '1', '3');
INSERT INTO `notas` VALUES('1955', '1728', '2', '7.00', '2025-05-25', '1', '4');
INSERT INTO `notas` VALUES('1956', '1729', '2', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1957', '1729', '2', '6.30', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1958', '1729', '2', '5.90', '2025-05-25', '1', '3');
INSERT INTO `notas` VALUES('1959', '1729', '2', '7.00', '2025-05-25', '1', '4');
INSERT INTO `notas` VALUES('1960', '1730', '2', '5.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1961', '1730', '2', '4.60', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1962', '1730', '2', '6.10', '2025-05-25', '1', '3');
INSERT INTO `notas` VALUES('1963', '1730', '2', '5.30', '2025-05-25', '1', '4');
INSERT INTO `notas` VALUES('1964', '1429', '2', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1965', '1429', '2', '6.80', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1966', '1429', '2', '6.70', '2025-05-25', '1', '3');
INSERT INTO `notas` VALUES('1967', '1429', '2', '6.20', '2025-05-25', '1', '4');
INSERT INTO `notas` VALUES('1968', '1430', '2', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1969', '1430', '2', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1970', '1430', '2', '7.00', '2025-05-25', '1', '3');
INSERT INTO `notas` VALUES('1971', '1430', '2', '7.00', '2025-05-25', '1', '4');
INSERT INTO `notas` VALUES('1972', '1431', '2', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1973', '1431', '2', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1974', '1431', '2', '7.00', '2025-05-25', '1', '3');
INSERT INTO `notas` VALUES('1975', '1431', '2', '6.80', '2025-05-25', '1', '4');
INSERT INTO `notas` VALUES('1976', '1432', '2', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1977', '1432', '2', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1978', '1432', '2', '6.90', '2025-05-25', '1', '3');
INSERT INTO `notas` VALUES('1979', '1432', '2', '7.00', '2025-05-25', '1', '4');
INSERT INTO `notas` VALUES('1980', '1433', '2', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1981', '1433', '2', '6.20', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1982', '1433', '2', '7.00', '2025-05-25', '1', '3');
INSERT INTO `notas` VALUES('1983', '1433', '2', '7.00', '2025-05-25', '1', '4');
INSERT INTO `notas` VALUES('1984', '1434', '2', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1985', '1434', '2', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1986', '1434', '2', '7.00', '2025-05-25', '1', '3');
INSERT INTO `notas` VALUES('1987', '1435', '2', '5.50', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1988', '1435', '2', '5.30', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1989', '1435', '2', '5.90', '2025-05-25', '1', '3');
INSERT INTO `notas` VALUES('1990', '1435', '2', '5.70', '2025-05-25', '1', '4');
INSERT INTO `notas` VALUES('1991', '1436', '2', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1992', '1436', '2', '7.00', '2025-05-25', '1', '4');
INSERT INTO `notas` VALUES('1993', '1454', '2', '5.50', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1994', '1454', '2', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1995', '1454', '2', '7.00', '2025-05-25', '1', '3');
INSERT INTO `notas` VALUES('1996', '1454', '2', '6.50', '2025-05-25', '1', '4');
INSERT INTO `notas` VALUES('1997', '1437', '2', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('1998', '1437', '2', '6.80', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('1999', '1437', '2', '6.90', '2025-05-25', '1', '3');
INSERT INTO `notas` VALUES('2000', '1437', '2', '6.80', '2025-05-25', '1', '4');
INSERT INTO `notas` VALUES('2001', '1438', '2', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2002', '1438', '2', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2003', '1438', '2', '5.90', '2025-05-25', '1', '3');
INSERT INTO `notas` VALUES('2004', '1438', '2', '6.80', '2025-05-25', '1', '4');
INSERT INTO `notas` VALUES('2005', '1439', '2', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2006', '1439', '2', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2007', '1439', '2', '7.00', '2025-05-25', '1', '3');
INSERT INTO `notas` VALUES('2008', '1439', '2', '7.00', '2025-05-25', '1', '4');
INSERT INTO `notas` VALUES('2009', '1440', '2', '6.80', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2010', '1440', '2', '6.80', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2011', '1440', '2', '5.20', '2025-05-25', '1', '3');
INSERT INTO `notas` VALUES('2012', '1441', '2', '6.80', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2013', '1441', '2', '5.90', '2025-05-25', '1', '3');
INSERT INTO `notas` VALUES('2014', '1441', '2', '6.50', '2025-05-25', '1', '4');
INSERT INTO `notas` VALUES('2015', '1442', '2', '6.80', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2016', '1442', '2', '6.20', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2017', '1442', '2', '7.00', '2025-05-25', '1', '3');
INSERT INTO `notas` VALUES('2018', '1442', '2', '6.50', '2025-05-25', '1', '4');
INSERT INTO `notas` VALUES('2019', '1443', '2', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2020', '1443', '2', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2021', '1443', '2', '6.30', '2025-05-25', '1', '3');
INSERT INTO `notas` VALUES('2022', '1443', '2', '6.50', '2025-05-25', '1', '4');
INSERT INTO `notas` VALUES('2023', '1444', '2', '6.20', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2024', '1444', '2', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2025', '1444', '2', '6.90', '2025-05-25', '1', '3');
INSERT INTO `notas` VALUES('2026', '1444', '2', '6.80', '2025-05-25', '1', '4');
INSERT INTO `notas` VALUES('2027', '1445', '2', '6.60', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2028', '1445', '2', '6.80', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2029', '1445', '2', '7.00', '2025-05-25', '1', '3');
INSERT INTO `notas` VALUES('2030', '1445', '2', '7.00', '2025-05-25', '1', '4');
INSERT INTO `notas` VALUES('2031', '1446', '2', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2032', '1446', '2', '6.60', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2033', '1446', '2', '6.80', '2025-05-25', '1', '4');
INSERT INTO `notas` VALUES('2034', '1447', '2', '6.80', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2035', '1447', '2', '6.80', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2036', '1447', '2', '6.70', '2025-05-25', '1', '3');
INSERT INTO `notas` VALUES('2037', '1447', '2', '7.00', '2025-05-25', '1', '4');
INSERT INTO `notas` VALUES('2038', '1429', '6', '6.30', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2039', '1429', '6', '6.40', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2040', '1430', '6', '6.80', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2041', '1430', '6', '6.80', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2042', '1431', '6', '6.60', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2043', '1431', '6', '6.80', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2044', '1432', '6', '6.80', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2045', '1432', '6', '6.50', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2046', '1433', '6', '6.60', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2047', '1433', '6', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2048', '1434', '6', '6.80', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2049', '1435', '6', '6.30', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2050', '1435', '6', '5.40', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2051', '1436', '6', '6.30', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2052', '1436', '6', '5.70', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2053', '1454', '6', '6.80', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2054', '1437', '6', '6.50', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2055', '1438', '6', '6.80', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2056', '1438', '6', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2057', '1439', '6', '6.30', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2058', '1439', '6', '6.50', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2059', '1440', '6', '6.80', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2060', '1440', '6', '6.50', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2061', '1441', '6', '6.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2062', '1441', '6', '6.60', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2063', '1442', '6', '5.80', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2064', '1442', '6', '5.50', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2065', '1443', '6', '5.50', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2066', '1443', '6', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2067', '1444', '6', '6.80', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2068', '1444', '6', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2069', '1445', '6', '6.80', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2070', '1445', '6', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2071', '1446', '6', '6.80', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2072', '1446', '6', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2073', '1447', '6', '6.30', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2074', '1447', '6', '6.50', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2075', '1948', '2', '5.50', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2076', '1948', '2', '5.80', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2077', '1949', '2', '4.70', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2078', '1949', '2', '4.60', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2079', '1950', '2', '3.10', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2080', '1950', '2', '4.40', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2081', '1951', '2', '5.70', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2082', '1951', '2', '4.60', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2083', '1952', '2', '4.10', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2084', '1952', '2', '4.10', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2085', '1953', '2', '4.50', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2086', '1953', '2', '4.40', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2087', '1954', '2', '4.10', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2088', '1954', '2', '4.10', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2089', '1956', '2', '1.30', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2090', '1956', '2', '3.30', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2091', '1957', '2', '2.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2092', '1957', '2', '3.50', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2093', '1958', '2', '6.40', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2094', '1958', '2', '6.80', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2095', '1959', '2', '6.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2096', '1959', '2', '5.80', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2097', '1960', '2', '4.70', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2098', '1960', '2', '4.10', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2099', '1961', '2', '1.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2100', '1961', '2', '3.60', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2101', '1962', '2', '4.10', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2102', '1963', '2', '5.70', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2103', '1963', '2', '4.60', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2104', '1964', '2', '4.50', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2105', '1964', '2', '4.10', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2106', '1965', '2', '6.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2107', '1965', '2', '5.30', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2108', '1966', '2', '5.70', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2109', '1966', '2', '5.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2110', '1967', '2', '4.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2111', '1967', '2', '4.60', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2112', '1968', '2', '5.30', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2113', '1968', '2', '5.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2114', '1969', '2', '4.30', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2115', '1969', '2', '5.20', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2116', '1970', '2', '4.90', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2117', '1970', '2', '5.10', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2118', '1971', '2', '1.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2119', '1971', '2', '2.70', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2120', '1972', '2', '5.10', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2121', '1972', '2', '4.80', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2122', '1973', '2', '6.20', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2123', '1973', '2', '6.30', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2124', '1974', '2', '4.90', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2125', '1975', '2', '5.30', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2126', '1976', '2', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2127', '1976', '2', '6.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2128', '1977', '2', '2.80', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2129', '1977', '2', '4.10', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2130', '1978', '2', '4.70', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2131', '1978', '2', '4.80', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2132', '1979', '2', '1.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2133', '1980', '2', '6.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2134', '1980', '2', '4.80', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2135', '1981', '2', '6.70', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2136', '1981', '2', '5.80', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2137', '1982', '2', '5.20', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2138', '1982', '2', '5.50', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2139', '1983', '2', '4.50', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2140', '1984', '2', '4.30', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2141', '1985', '2', '3.90', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2142', '1987', '2', '6.50', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2143', '1987', '2', '5.60', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2144', '1429', '7', '6.10', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2145', '1429', '7', '5.10', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2146', '1430', '7', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2147', '1430', '7', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2148', '1431', '7', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2149', '1431', '7', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2150', '1432', '7', '6.10', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2151', '1432', '7', '6.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2152', '1433', '7', '6.80', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2153', '1434', '7', '6.50', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2154', '1434', '7', '6.80', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2155', '1435', '7', '4.20', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2156', '1435', '7', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2157', '1436', '7', '5.70', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2158', '1436', '7', '6.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2159', '1454', '7', '6.50', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2160', '1454', '7', '6.40', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2161', '1437', '7', '6.10', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2162', '1437', '7', '6.80', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2163', '1438', '7', '5.30', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2164', '1439', '7', '5.70', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2165', '1439', '7', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2166', '1441', '7', '6.50', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2167', '1441', '7', '6.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2168', '1442', '7', '6.10', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2169', '1442', '7', '6.80', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2170', '1443', '7', '6.50', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2171', '1443', '7', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2172', '1444', '7', '6.10', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2173', '1444', '7', '6.80', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2174', '1445', '7', '6.50', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2175', '1445', '7', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2176', '1446', '7', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2177', '1446', '7', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2178', '1447', '7', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2179', '1447', '7', '6.40', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2180', '1429', '1', '6.10', '2025-05-25', '1', '4');
INSERT INTO `notas` VALUES('2181', '1431', '1', '6.50', '2025-05-25', '1', '4');
INSERT INTO `notas` VALUES('2182', '1432', '1', '6.70', '2025-05-25', '1', '4');
INSERT INTO `notas` VALUES('2183', '1433', '1', '6.90', '2025-05-25', '1', '4');
INSERT INTO `notas` VALUES('2184', '1434', '1', '6.70', '2025-05-25', '1', '4');
INSERT INTO `notas` VALUES('2185', '1435', '1', '7.00', '2025-05-25', '1', '3');
INSERT INTO `notas` VALUES('2186', '1436', '1', '6.80', '2025-05-25', '1', '3');
INSERT INTO `notas` VALUES('2187', '1436', '1', '4.00', '2025-05-25', '1', '4');
INSERT INTO `notas` VALUES('2188', '1454', '1', '7.00', '2025-05-25', '1', '4');
INSERT INTO `notas` VALUES('2189', '1437', '1', '6.30', '2025-05-25', '1', '4');
INSERT INTO `notas` VALUES('2190', '1439', '1', '6.30', '2025-05-25', '1', '4');
INSERT INTO `notas` VALUES('2191', '1440', '1', '7.00', '2025-05-25', '1', '3');
INSERT INTO `notas` VALUES('2192', '1441', '1', '6.60', '2025-05-25', '1', '4');
INSERT INTO `notas` VALUES('2193', '1442', '1', '6.80', '2025-05-25', '1', '4');
INSERT INTO `notas` VALUES('2194', '1443', '1', '7.00', '2025-05-25', '1', '3');
INSERT INTO `notas` VALUES('2195', '1443', '1', '6.00', '2025-05-25', '1', '4');
INSERT INTO `notas` VALUES('2196', '1444', '1', '7.00', '2025-05-25', '1', '3');
INSERT INTO `notas` VALUES('2197', '1444', '1', '7.00', '2025-05-25', '1', '4');
INSERT INTO `notas` VALUES('2198', '1445', '1', '6.00', '2025-05-25', '1', '4');
INSERT INTO `notas` VALUES('2199', '1447', '1', '6.00', '2025-05-25', '1', '4');
INSERT INTO `notas` VALUES('2200', '1878', '12', '6.60', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2201', '1878', '12', '6.40', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2202', '1879', '12', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2203', '1879', '12', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2204', '1881', '12', '6.60', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2205', '1881', '12', '6.50', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2206', '1882', '12', '6.50', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2207', '1882', '12', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2208', '1883', '12', '6.40', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2209', '1883', '12', '6.60', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2210', '1884', '12', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2211', '1884', '12', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2212', '1885', '12', '6.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2213', '1885', '12', '6.40', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2214', '1886', '12', '6.40', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2215', '1886', '12', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2216', '1887', '12', '6.60', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2217', '1887', '12', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2218', '1888', '12', '6.80', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2219', '1888', '12', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2220', '1889', '12', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2221', '1889', '12', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2222', '1890', '12', '6.60', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2223', '1890', '12', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2224', '1891', '12', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2225', '1891', '12', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2226', '1892', '12', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2227', '1892', '12', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2228', '1893', '12', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2229', '1893', '12', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2230', '1894', '12', '6.20', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2231', '1894', '12', '6.60', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2232', '1895', '12', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2233', '1895', '12', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2234', '1896', '12', '6.40', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2235', '1896', '12', '6.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2236', '1897', '12', '6.60', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2237', '1897', '12', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2238', '1948', '12', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2239', '1948', '12', '6.60', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2240', '1949', '12', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2241', '1949', '12', '6.80', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2242', '1950', '12', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2243', '1950', '12', '6.60', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2244', '1951', '12', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2245', '1951', '12', '6.80', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2246', '1953', '12', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2247', '1953', '12', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2248', '1954', '12', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2249', '1954', '12', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2250', '1956', '12', '5.60', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2251', '1956', '12', '4.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2252', '1957', '12', '6.50', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2253', '1957', '12', '4.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2254', '1958', '12', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2255', '1958', '12', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2256', '1959', '12', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2257', '1959', '12', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2258', '1960', '12', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2259', '1960', '12', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2260', '1961', '12', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2261', '1961', '12', '6.60', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2262', '1962', '12', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2263', '1962', '12', '6.70', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2264', '1963', '12', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2265', '1963', '12', '6.40', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2266', '1964', '12', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2267', '1964', '12', '6.60', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2268', '1965', '12', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2269', '1965', '12', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2270', '1966', '12', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2271', '1966', '12', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2272', '1967', '12', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2273', '1967', '12', '6.40', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2274', '1968', '12', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2275', '1968', '12', '6.50', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2276', '1969', '12', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2277', '1969', '12', '6.40', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2278', '1970', '12', '6.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2279', '1970', '12', '6.50', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2280', '1971', '12', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2281', '1971', '12', '5.20', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2282', '1972', '12', '6.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2283', '1972', '12', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2284', '1973', '12', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2285', '1973', '12', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2286', '1974', '12', '6.50', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2287', '1975', '12', '6.50', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2288', '1975', '12', '6.60', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2289', '1976', '12', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2290', '1976', '12', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2291', '1977', '12', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2292', '1977', '12', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2293', '1978', '12', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2294', '1978', '12', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2295', '1979', '12', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2296', '1979', '12', '6.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2297', '1980', '12', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2298', '1980', '12', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2299', '1981', '12', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2300', '1981', '12', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2301', '1983', '12', '5.60', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2302', '1983', '12', '5.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2303', '1984', '12', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2304', '1985', '12', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2305', '1985', '12', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2306', '1986', '12', '5.10', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2307', '1987', '12', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2308', '1987', '12', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2309', '1844', '1', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2310', '1844', '1', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2311', '1844', '1', '7.00', '2025-05-25', '1', '3');
INSERT INTO `notas` VALUES('2312', '1845', '1', '5.20', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2313', '1845', '1', '4.20', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2314', '1845', '1', '5.30', '2025-05-25', '1', '3');
INSERT INTO `notas` VALUES('2315', '1846', '1', '4.60', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2316', '1846', '1', '4.10', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2317', '1846', '1', '5.60', '2025-05-25', '1', '3');
INSERT INTO `notas` VALUES('2318', '1847', '1', '5.70', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2319', '1847', '1', '3.60', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2320', '1847', '1', '5.70', '2025-05-25', '1', '3');
INSERT INTO `notas` VALUES('2321', '1848', '1', '6.30', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2322', '1848', '1', '6.40', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2323', '1848', '1', '7.00', '2025-05-25', '1', '3');
INSERT INTO `notas` VALUES('2324', '1849', '1', '6.60', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2325', '1849', '1', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2326', '1849', '1', '7.00', '2025-05-25', '1', '3');
INSERT INTO `notas` VALUES('2327', '1850', '1', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2328', '1850', '1', '6.80', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2329', '1850', '1', '7.00', '2025-05-25', '1', '3');
INSERT INTO `notas` VALUES('2330', '1851', '1', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2331', '1851', '1', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2332', '1851', '1', '7.00', '2025-05-25', '1', '3');
INSERT INTO `notas` VALUES('2333', '1852', '1', '6.40', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2334', '1852', '1', '6.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2335', '1852', '1', '6.60', '2025-05-25', '1', '3');
INSERT INTO `notas` VALUES('2336', '1853', '1', '5.10', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2337', '1853', '1', '3.60', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2338', '1853', '1', '5.40', '2025-05-25', '1', '3');
INSERT INTO `notas` VALUES('2339', '1854', '1', '5.20', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2340', '1854', '1', '4.30', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2341', '1854', '1', '5.00', '2025-05-25', '1', '3');
INSERT INTO `notas` VALUES('2342', '1855', '1', '6.10', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2343', '1855', '1', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2344', '1855', '1', '7.00', '2025-05-25', '1', '3');
INSERT INTO `notas` VALUES('2345', '1856', '1', '6.10', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2346', '1856', '1', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2347', '1856', '1', '6.60', '2025-05-25', '1', '3');
INSERT INTO `notas` VALUES('2348', '1857', '1', '5.60', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2349', '1857', '1', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2350', '1857', '1', '6.40', '2025-05-25', '1', '3');
INSERT INTO `notas` VALUES('2351', '1858', '1', '4.40', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2352', '1858', '1', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2353', '1858', '1', '7.00', '2025-05-25', '1', '3');
INSERT INTO `notas` VALUES('2354', '1859', '1', '6.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2355', '1859', '1', '6.10', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2356', '1859', '1', '6.40', '2025-05-25', '1', '3');
INSERT INTO `notas` VALUES('2357', '1860', '1', '4.20', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2358', '1860', '1', '5.30', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2359', '1860', '1', '5.70', '2025-05-25', '1', '3');
INSERT INTO `notas` VALUES('2360', '1861', '1', '5.10', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2361', '1861', '1', '6.60', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2362', '1861', '1', '6.40', '2025-05-25', '1', '3');
INSERT INTO `notas` VALUES('2363', '1862', '1', '5.90', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2364', '1862', '1', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2365', '1862', '1', '7.00', '2025-05-25', '1', '3');
INSERT INTO `notas` VALUES('2366', '1863', '1', '4.70', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2367', '1863', '1', '6.50', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2368', '1863', '1', '4.40', '2025-05-25', '1', '3');
INSERT INTO `notas` VALUES('2369', '1864', '1', '4.60', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2370', '1864', '1', '2.90', '2025-05-25', '1', '3');
INSERT INTO `notas` VALUES('2371', '1865', '1', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2372', '1865', '1', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2373', '1865', '1', '6.10', '2025-05-25', '1', '3');
INSERT INTO `notas` VALUES('2374', '1866', '1', '4.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2375', '1866', '1', '3.60', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2376', '1866', '1', '4.50', '2025-05-25', '1', '3');
INSERT INTO `notas` VALUES('2377', '1867', '1', '5.30', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2378', '1867', '1', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2379', '1867', '1', '7.00', '2025-05-25', '1', '3');
INSERT INTO `notas` VALUES('2380', '1868', '1', '5.90', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2381', '1868', '1', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2382', '1868', '1', '6.50', '2025-05-25', '1', '3');
INSERT INTO `notas` VALUES('2383', '1869', '1', '5.50', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2384', '1869', '1', '4.10', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2385', '1869', '1', '6.40', '2025-05-25', '1', '3');
INSERT INTO `notas` VALUES('2386', '1870', '1', '4.70', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2387', '1870', '1', '3.30', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2388', '1870', '1', '4.00', '2025-05-25', '1', '3');
INSERT INTO `notas` VALUES('2389', '1871', '1', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2390', '1871', '1', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2391', '1871', '1', '7.00', '2025-05-25', '1', '3');
INSERT INTO `notas` VALUES('2392', '1872', '1', '4.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2393', '1872', '1', '6.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2394', '1872', '1', '4.70', '2025-05-25', '1', '3');
INSERT INTO `notas` VALUES('2395', '1873', '1', '6.60', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2396', '1873', '1', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2397', '1873', '1', '7.00', '2025-05-25', '1', '3');
INSERT INTO `notas` VALUES('2398', '1874', '1', '5.40', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2399', '1874', '1', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2400', '1874', '1', '6.10', '2025-05-25', '1', '3');
INSERT INTO `notas` VALUES('2401', '1875', '1', '5.70', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2402', '1875', '1', '3.60', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2403', '1875', '1', '4.10', '2025-05-25', '1', '3');
INSERT INTO `notas` VALUES('2404', '1876', '1', '5.90', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2405', '1876', '1', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2406', '1876', '1', '7.00', '2025-05-25', '1', '3');
INSERT INTO `notas` VALUES('2407', '1844', '7', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2408', '1844', '7', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2409', '1845', '7', '5.20', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2410', '1845', '7', '4.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2411', '1846', '7', '6.10', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2412', '1846', '7', '5.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2413', '1847', '7', '6.60', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2414', '1847', '7', '4.10', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2415', '1848', '7', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2416', '1848', '7', '6.60', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2417', '1849', '7', '6.60', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2418', '1849', '7', '6.70', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2419', '1850', '7', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2420', '1850', '7', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2421', '1851', '7', '6.80', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2422', '1851', '7', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2423', '1852', '7', '6.60', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2424', '1852', '7', '6.60', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2425', '1853', '7', '5.90', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2426', '1853', '7', '4.50', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2427', '1854', '7', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2428', '1854', '7', '6.40', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2429', '1855', '7', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2430', '1855', '7', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2431', '1856', '7', '6.50', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2432', '1857', '7', '6.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2433', '1858', '7', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2434', '1858', '7', '6.40', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2435', '1859', '7', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2436', '1859', '7', '6.10', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2437', '1860', '7', '6.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2438', '1861', '7', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2439', '1861', '7', '6.40', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2440', '1862', '7', '6.80', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2441', '1862', '7', '6.60', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2442', '1863', '7', '4.50', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2443', '1864', '7', '4.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2444', '1865', '7', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2445', '1865', '7', '6.80', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2446', '1866', '7', '4.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2447', '1867', '7', '6.80', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2448', '1867', '7', '6.80', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2449', '1868', '7', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2450', '1868', '7', '6.60', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2451', '1869', '7', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2452', '1869', '7', '6.80', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2453', '1870', '7', '4.60', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2454', '1870', '7', '3.40', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2455', '1871', '7', '6.60', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2456', '1871', '7', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2457', '1872', '7', '5.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2458', '1872', '7', '4.10', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2459', '1873', '7', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2460', '1873', '7', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2461', '1874', '7', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2462', '1874', '7', '6.40', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2463', '1875', '7', '6.60', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2464', '1875', '7', '3.60', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2465', '1876', '7', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2466', '1876', '7', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2467', '1844', '6', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2468', '1844', '6', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2469', '1845', '6', '6.60', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2470', '1845', '6', '5.60', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2471', '1846', '6', '5.50', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2472', '1846', '6', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2473', '1847', '6', '5.70', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2474', '1847', '6', '6.50', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2475', '1848', '6', '5.90', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2476', '1848', '6', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2477', '1849', '6', '5.70', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2478', '1849', '6', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2479', '1850', '6', '6.80', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2480', '1850', '6', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2481', '1851', '6', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2482', '1851', '6', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2483', '1852', '6', '6.80', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2484', '1852', '6', '6.60', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2485', '1853', '6', '5.90', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2486', '1853', '6', '6.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2487', '1854', '6', '6.80', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2488', '1854', '6', '6.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2489', '1855', '6', '6.10', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2490', '1855', '6', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2491', '1856', '6', '5.90', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2492', '1856', '6', '6.50', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2493', '1857', '6', '6.10', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2494', '1857', '6', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2495', '1858', '6', '6.60', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2496', '1858', '6', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2497', '1859', '6', '6.60', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2498', '1859', '6', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2499', '1860', '6', '5.70', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2500', '1860', '6', '6.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2501', '1861', '6', '6.10', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2502', '1861', '6', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2503', '1862', '6', '6.40', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2504', '1862', '6', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2505', '1863', '6', '6.10', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2506', '1863', '6', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2507', '1864', '6', '5.10', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2508', '1864', '6', '5.60', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2509', '1865', '6', '6.80', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2510', '1865', '6', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2511', '1866', '6', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2512', '1867', '6', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2513', '1867', '6', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2514', '1868', '6', '6.60', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2515', '1868', '6', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2516', '1869', '6', '6.60', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2517', '1870', '6', '5.50', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2518', '1870', '6', '6.60', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2519', '1871', '6', '6.60', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2520', '1871', '6', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2521', '1872', '6', '5.70', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2522', '1872', '6', '6.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2523', '1873', '6', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2524', '1873', '6', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2525', '1874', '6', '6.10', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2526', '1874', '6', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2527', '1875', '6', '6.40', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2528', '1875', '6', '6.60', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2529', '1876', '6', '6.60', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2530', '1876', '6', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2531', '1844', '2', '6.70', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2532', '1844', '2', '6.80', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2533', '1845', '2', '4.40', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2534', '1845', '2', '5.20', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2535', '1846', '2', '2.40', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2536', '1846', '2', '4.60', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2537', '1847', '2', '3.10', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2538', '1847', '2', '4.70', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2539', '1848', '2', '4.40', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2540', '1848', '2', '6.10', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2541', '1849', '2', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2542', '1849', '2', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2543', '1850', '2', '6.80', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2544', '1850', '2', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2545', '1851', '2', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2546', '1851', '2', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2547', '1852', '2', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2548', '1852', '2', '6.80', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2549', '1853', '2', '4.20', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2550', '1854', '2', '6.70', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2551', '1854', '2', '6.20', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2552', '1855', '2', '6.10', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2553', '1855', '2', '6.40', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2554', '1856', '2', '6.20', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2555', '1856', '2', '6.40', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2556', '1857', '2', '6.80', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2557', '1857', '2', '5.60', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2558', '1858', '2', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2559', '1858', '2', '6.60', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2560', '1859', '2', '4.40', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2561', '1859', '2', '5.20', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2562', '1860', '2', '6.10', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2563', '1861', '2', '4.70', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2564', '1861', '2', '6.40', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2565', '1862', '2', '5.60', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2566', '1862', '2', '6.40', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2567', '1863', '2', '3.30', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2568', '1863', '2', '4.60', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2569', '1865', '2', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2570', '1865', '2', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2571', '1866', '2', '2.90', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2572', '1866', '2', '4.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2573', '1867', '2', '6.70', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2574', '1867', '2', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2575', '1868', '2', '6.60', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2576', '1868', '2', '6.40', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2577', '1869', '2', '6.40', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2578', '1870', '2', '3.80', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2579', '1870', '2', '4.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2580', '1871', '2', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2581', '1871', '2', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2582', '1872', '2', '3.60', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2583', '1872', '2', '4.50', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2584', '1873', '2', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2585', '1873', '2', '6.80', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2586', '1874', '2', '4.90', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2587', '1874', '2', '6.20', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2588', '1875', '2', '3.10', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2589', '1875', '2', '4.50', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2590', '1876', '2', '6.70', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2591', '1876', '2', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2592', '1844', '4', '6.80', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2593', '1844', '4', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2594', '1845', '4', '5.70', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2595', '1845', '4', '5.40', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2596', '1846', '4', '5.80', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2597', '1846', '4', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2598', '1847', '4', '5.60', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2599', '1847', '4', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2600', '1848', '4', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2601', '1848', '4', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2602', '1849', '4', '6.60', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2603', '1849', '4', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2604', '1850', '4', '6.80', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2605', '1850', '4', '6.70', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2606', '1851', '4', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2607', '1851', '4', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2608', '1852', '4', '6.60', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2609', '1852', '4', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2610', '1853', '4', '6.30', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2611', '1853', '4', '6.40', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2612', '1854', '4', '6.40', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2613', '1854', '4', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2614', '1855', '4', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2615', '1855', '4', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2616', '1856', '4', '6.40', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2617', '1856', '4', '6.60', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2618', '1857', '4', '6.60', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2619', '1857', '4', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2620', '1858', '4', '6.60', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2621', '1858', '4', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2622', '1859', '4', '6.10', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2623', '1859', '4', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2624', '1860', '4', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2625', '1861', '4', '6.60', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2626', '1861', '4', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2627', '1862', '4', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2628', '1862', '4', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2629', '1863', '4', '6.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2630', '1863', '4', '6.60', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2631', '1864', '4', '4.60', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2632', '1864', '4', '6.40', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2633', '1865', '4', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2634', '1865', '4', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2635', '1866', '4', '5.20', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2636', '1866', '4', '6.40', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2637', '1867', '4', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2638', '1867', '4', '6.60', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2639', '1868', '4', '6.60', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2640', '1868', '4', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2641', '1869', '4', '6.40', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2642', '1869', '4', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2643', '1870', '4', '4.60', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2644', '1870', '4', '6.60', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2645', '1871', '4', '6.60', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2646', '1871', '4', '5.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2647', '1872', '4', '6.10', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2648', '1872', '4', '6.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2649', '1873', '4', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2650', '1873', '4', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2651', '1874', '4', '6.50', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2652', '1874', '4', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2653', '1875', '4', '6.10', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2654', '1875', '4', '6.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2655', '1876', '4', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2656', '1876', '4', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2657', '1948', '7', '4.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2658', '1948', '7', '4.40', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2659', '1949', '7', '4.40', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2660', '1949', '7', '5.30', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2661', '1950', '7', '4.20', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2662', '1950', '7', '4.40', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2663', '1951', '7', '3.50', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2664', '1951', '7', '4.90', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2665', '1952', '7', '5.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2666', '1952', '7', '4.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2667', '1953', '7', '4.20', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2668', '1953', '7', '6.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2669', '1954', '7', '3.70', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2670', '1954', '7', '3.90', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2671', '1956', '7', '2.70', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2672', '1956', '7', '4.10', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2673', '1957', '7', '3.50', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2674', '1957', '7', '4.40', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2675', '1958', '7', '4.40', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2676', '1958', '7', '5.80', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2677', '1959', '7', '3.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2678', '1959', '7', '4.80', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2679', '1960', '7', '5.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2680', '1960', '7', '5.90', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2681', '1961', '7', '3.10', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2682', '1961', '7', '4.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2683', '1962', '7', '5.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2684', '1962', '7', '4.90', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2685', '1963', '7', '4.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2686', '1963', '7', '4.20', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2687', '1964', '7', '4.20', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2688', '1964', '7', '6.30', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2689', '1965', '7', '4.40', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2690', '1965', '7', '6.20', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2691', '1966', '7', '6.60', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2692', '1966', '7', '5.30', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2693', '1967', '7', '4.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2694', '1967', '7', '3.50', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2695', '1968', '7', '3.40', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2696', '1968', '7', '6.60', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2697', '1969', '7', '4.20', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2698', '1969', '7', '4.20', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2699', '1970', '7', '4.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2700', '1970', '7', '3.70', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2701', '1971', '7', '4.40', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2702', '1971', '7', '4.10', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2703', '1972', '7', '6.40', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2704', '1972', '7', '5.40', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2705', '1973', '7', '5.40', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2706', '1973', '7', '6.40', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2707', '1974', '7', '3.20', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2708', '1975', '7', '5.40', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2709', '1975', '7', '4.80', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2710', '1976', '7', '4.80', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2711', '1976', '7', '6.70', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2712', '1977', '7', '3.50', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2713', '1977', '7', '4.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2714', '1978', '7', '3.80', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2715', '1978', '7', '5.20', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2716', '1979', '7', '4.20', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2717', '1979', '7', '4.60', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2718', '1980', '7', '4.20', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2719', '1980', '7', '5.40', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2720', '1981', '7', '6.20', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2721', '1981', '7', '6.30', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2722', '1982', '7', '5.30', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2723', '1982', '7', '5.80', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2724', '1983', '7', '3.50', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2725', '1983', '7', '4.70', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2726', '1984', '7', '4.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2727', '1984', '7', '4.20', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2728', '1985', '7', '4.60', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2729', '1985', '7', '4.80', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2730', '1986', '7', '3.70', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2731', '1986', '7', '5.60', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2732', '1987', '7', '4.60', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2733', '1987', '7', '7.00', '2025-05-25', '1', '2');
INSERT INTO `notas` VALUES('2734', '1585', '12', '6.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2735', '1586', '12', '6.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2736', '1588', '12', '6.30', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2737', '1590', '12', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2738', '1591', '12', '5.10', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2739', '1593', '12', '6.30', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2740', '1594', '12', '6.30', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2741', '1595', '12', '6.60', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2742', '1596', '12', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2743', '1597', '12', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2744', '1598', '12', '6.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2745', '1600', '12', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2746', '1601', '12', '6.60', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2747', '1602', '12', '6.60', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2748', '1603', '12', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2749', '1605', '12', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2750', '1606', '12', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2751', '1607', '12', '6.60', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2752', '1608', '12', '6.60', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2753', '1609', '12', '7.00', '2025-05-25', '1', '1');
INSERT INTO `notas` VALUES('2754', '1564', '1', '6.30', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2755', '1564', '1', '6.70', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('2756', '1565', '1', '6.50', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2757', '1565', '1', '6.70', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('2758', '1566', '1', '6.10', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2759', '1566', '1', '6.70', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('2760', '1567', '1', '5.80', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2761', '1567', '1', '5.10', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('2762', '1568', '1', '6.80', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2763', '1568', '1', '6.70', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('2764', '1569', '1', '6.70', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2765', '1569', '1', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('2766', '1570', '1', '6.10', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2767', '1570', '1', '6.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('2768', '1571', '1', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2769', '1571', '1', '6.50', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('2770', '1572', '1', '6.80', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2771', '1572', '1', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('2772', '1573', '1', '5.50', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2773', '1573', '1', '3.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('2774', '1574', '1', '4.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2775', '1574', '1', '3.50', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('2776', '1575', '1', '6.50', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2777', '1575', '1', '6.20', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('2778', '1576', '1', '5.80', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2779', '1576', '1', '6.20', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('2780', '1577', '1', '6.10', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2781', '1577', '1', '6.20', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('2782', '1578', '1', '6.80', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2783', '1578', '1', '5.50', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('2784', '1579', '1', '6.80', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2785', '1579', '1', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('2786', '1580', '1', '2.30', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2787', '1580', '1', '3.10', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('2788', '1581', '1', '6.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2789', '1581', '1', '6.20', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('2790', '1582', '1', '6.50', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2791', '1582', '1', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('2792', '1583', '1', '6.10', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2793', '1583', '1', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('2794', '1584', '1', '5.50', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2795', '1584', '1', '5.50', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('2796', '1564', '4', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2797', '1565', '4', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2798', '1566', '4', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2799', '1567', '4', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2800', '1568', '4', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2801', '1569', '4', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2802', '1570', '4', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2803', '1571', '4', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2804', '1572', '4', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2805', '1573', '4', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2806', '1574', '4', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2807', '1575', '4', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2808', '1576', '4', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2809', '1577', '4', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2810', '1578', '4', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2811', '1579', '4', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2812', '1580', '4', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2813', '1581', '4', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2814', '1582', '4', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2815', '1583', '4', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2816', '1584', '4', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2817', '1564', '12', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2818', '1565', '12', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2819', '1566', '12', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2820', '1567', '12', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2821', '1568', '12', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2822', '1569', '12', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2823', '1570', '12', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2824', '1571', '12', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2825', '1572', '12', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2826', '1573', '12', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2827', '1574', '12', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2828', '1575', '12', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2829', '1576', '12', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2830', '1577', '12', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2831', '1578', '12', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2832', '1579', '12', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2833', '1580', '12', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2834', '1581', '12', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2835', '1582', '12', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2836', '1583', '12', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2837', '1584', '12', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2838', '1564', '2', '6.10', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2839', '1564', '2', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('2840', '1565', '2', '4.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2841', '1565', '2', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('2842', '1566', '2', '5.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2843', '1566', '2', '3.70', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('2844', '1567', '2', '4.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2845', '1567', '2', '5.80', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('2846', '1568', '2', '5.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2847', '1568', '2', '6.50', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('2848', '1569', '2', '6.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2849', '1569', '2', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('2850', '1570', '2', '4.20', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2851', '1570', '2', '3.60', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('2852', '1571', '2', '4.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2853', '1572', '2', '6.80', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2854', '1572', '2', '6.80', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('2855', '1573', '2', '3.50', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2856', '1573', '2', '4.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('2857', '1574', '2', '3.40', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2858', '1574', '2', '3.70', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('2859', '1575', '2', '4.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2860', '1575', '2', '5.40', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('2861', '1576', '2', '4.40', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2862', '1576', '2', '4.20', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('2863', '1577', '2', '4.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2864', '1577', '2', '4.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('2865', '1578', '2', '4.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2866', '1578', '2', '4.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('2867', '1579', '2', '6.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2868', '1579', '2', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('2869', '1580', '2', '4.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2870', '1580', '2', '5.60', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('2871', '1581', '2', '3.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2872', '1581', '2', '2.80', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('2873', '1582', '2', '5.30', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2874', '1582', '2', '6.10', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('2875', '1583', '2', '3.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2876', '1584', '2', '3.80', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2877', '1584', '2', '3.70', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('2878', '1564', '6', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2879', '1564', '6', '6.60', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('2880', '1565', '6', '5.50', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2881', '1565', '6', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('2882', '1566', '6', '4.60', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2883', '1567', '6', '6.70', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2884', '1567', '6', '6.20', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('2885', '1568', '6', '6.70', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2886', '1568', '6', '6.60', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('2887', '1569', '6', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2888', '1569', '6', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('2889', '1570', '6', '6.70', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2890', '1570', '6', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('2891', '1571', '6', '6.10', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2892', '1571', '6', '6.60', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('2893', '1572', '6', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2894', '1572', '6', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('2895', '1573', '6', '5.50', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2896', '1573', '6', '5.80', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('2897', '1574', '6', '4.60', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2898', '1574', '6', '5.80', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('2899', '1575', '6', '6.40', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2900', '1575', '6', '6.20', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('2901', '1576', '6', '5.80', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2902', '1576', '6', '6.60', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('2903', '1577', '6', '6.70', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2904', '1577', '6', '6.60', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('2905', '1578', '6', '6.70', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2906', '1578', '6', '6.20', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('2907', '1579', '6', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2908', '1579', '6', '6.60', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('2909', '1580', '6', '6.10', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2910', '1580', '6', '5.80', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('2911', '1581', '6', '5.20', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2912', '1581', '6', '6.60', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('2913', '1582', '6', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2914', '1582', '6', '6.20', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('2915', '1583', '6', '6.70', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2916', '1583', '6', '6.60', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('2917', '1584', '6', '6.40', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2918', '1584', '6', '5.80', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('2919', '1564', '7', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2920', '1565', '7', '5.80', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2921', '1566', '7', '5.80', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2922', '1567', '7', '5.80', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2923', '1568', '7', '5.30', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2924', '1569', '7', '6.40', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2925', '1570', '7', '5.30', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2926', '1571', '7', '5.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2927', '1572', '7', '6.40', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2928', '1573', '7', '3.60', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2929', '1574', '7', '3.70', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2930', '1575', '7', '5.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2931', '1576', '7', '5.80', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2932', '1577', '7', '6.40', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2933', '1578', '7', '5.60', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2934', '1579', '7', '6.10', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2935', '1580', '7', '3.30', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2936', '1581', '7', '5.30', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2937', '1582', '7', '5.80', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2938', '1583', '7', '4.70', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2939', '1584', '7', '5.60', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2940', '1731', '2', '6.60', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('2941', '1731', '2', '5.30', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('2942', '1732', '2', '6.30', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('2943', '1732', '2', '4.50', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('2944', '1733', '2', '4.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('2945', '1733', '2', '4.00', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('2946', '1734', '2', '5.90', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('2947', '1734', '2', '4.00', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('2948', '1735', '2', '6.90', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('2949', '1735', '2', '4.50', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('2950', '1736', '2', '5.60', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('2951', '1736', '2', '4.20', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('2952', '1737', '2', '6.30', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('2953', '1737', '2', '5.70', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('2954', '1738', '2', '6.30', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('2955', '1738', '2', '4.30', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('2956', '1739', '2', '5.70', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('2957', '1739', '2', '4.60', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('2958', '1740', '2', '6.70', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('2959', '1740', '2', '4.00', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('2960', '1741', '2', '6.90', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('2961', '1741', '2', '5.70', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('2962', '1742', '2', '7.00', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('2963', '1743', '2', '6.50', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('2964', '1743', '2', '4.00', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('2965', '1744', '2', '6.30', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('2966', '1744', '2', '4.00', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('2967', '1745', '2', '4.50', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('2968', '1745', '2', '4.00', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('2969', '1746', '2', '4.00', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('2970', '1747', '2', '5.10', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('2971', '1747', '2', '4.00', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('2972', '1748', '2', '4.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('2973', '1748', '2', '4.00', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('2974', '1749', '2', '2.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('2975', '1749', '2', '4.00', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('2976', '1750', '2', '4.50', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('2977', '1750', '2', '4.10', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('2978', '1731', '6', '4.70', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2979', '1732', '6', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2980', '1732', '6', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('2981', '1733', '6', '5.10', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2982', '1733', '6', '6.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('2983', '1734', '6', '6.40', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2984', '1734', '6', '5.50', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('2985', '1735', '6', '6.40', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2986', '1735', '6', '4.50', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('2987', '1736', '6', '4.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2988', '1736', '6', '5.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('2989', '1737', '6', '4.50', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2990', '1737', '6', '6.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('2991', '1738', '6', '6.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2992', '1738', '6', '6.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('2993', '1739', '6', '4.70', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2994', '1740', '6', '5.30', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2995', '1740', '6', '6.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('2996', '1741', '6', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2997', '1741', '6', '5.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('2998', '1742', '6', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('2999', '1742', '6', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3000', '1743', '6', '5.30', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3001', '1743', '6', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3002', '1744', '6', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3003', '1744', '6', '4.50', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3004', '1745', '6', '4.20', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3005', '1745', '6', '5.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3006', '1746', '6', '4.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3007', '1746', '6', '4.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3008', '1747', '6', '5.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3009', '1748', '6', '6.40', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3010', '1748', '6', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3011', '1749', '6', '6.10', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3012', '1749', '6', '5.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3013', '1750', '6', '5.10', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3014', '1750', '6', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3015', '1542', '12', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3016', '1542', '12', '6.60', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3017', '1543', '12', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3018', '1544', '12', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3019', '1544', '12', '6.30', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3020', '1545', '12', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3021', '1545', '12', '6.80', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3022', '1546', '12', '6.60', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3023', '1546', '12', '6.30', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3024', '1547', '12', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3025', '1547', '12', '6.60', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3026', '1548', '12', '6.60', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3027', '1548', '12', '6.60', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3028', '1549', '12', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3029', '1549', '12', '6.60', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3030', '1550', '12', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3031', '1550', '12', '6.30', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3032', '1551', '12', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3033', '1551', '12', '6.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3034', '1552', '12', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3035', '1552', '12', '6.80', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3036', '1553', '12', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3037', '1554', '12', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3038', '1554', '12', '6.30', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3039', '1555', '12', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3040', '1555', '12', '6.60', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3041', '1556', '12', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3042', '1556', '12', '6.30', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3043', '1557', '12', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3044', '1557', '12', '6.60', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3045', '1558', '12', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3046', '1558', '12', '6.60', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3047', '1559', '12', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3048', '1559', '12', '6.60', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3049', '1560', '12', '6.60', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3050', '1560', '12', '6.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3051', '1561', '12', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3052', '1561', '12', '6.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3053', '1562', '12', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3054', '1562', '12', '6.80', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3055', '1563', '12', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3056', '1563', '12', '6.80', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3057', '1922', '6', '6.80', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3058', '1923', '6', '4.20', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3059', '1923', '6', '4.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3060', '1924', '6', '6.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3061', '1924', '6', '4.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3062', '1925', '6', '5.20', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3063', '1925', '6', '6.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3064', '1926', '6', '6.50', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3065', '1926', '6', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3066', '1927', '6', '6.10', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3067', '1927', '6', '4.50', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3068', '1928', '6', '5.50', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3069', '1928', '6', '4.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3070', '1929', '6', '5.70', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3071', '1929', '6', '5.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3072', '1930', '6', '6.60', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3073', '1930', '6', '5.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3074', '1931', '6', '6.50', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3075', '1931', '6', '6.50', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3076', '1932', '6', '5.40', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3077', '1932', '6', '5.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3078', '1933', '6', '6.40', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3079', '1933', '6', '4.50', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3080', '1947', '6', '6.10', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3081', '1934', '6', '6.20', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3082', '1934', '6', '4.50', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3083', '1935', '6', '6.50', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3084', '1935', '6', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3085', '1936', '6', '6.40', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3086', '1936', '6', '6.50', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3087', '1937', '6', '5.70', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3088', '1937', '6', '5.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3089', '1938', '6', '5.20', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3090', '1938', '6', '6.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3091', '1939', '6', '5.50', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3092', '1939', '6', '5.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3093', '1940', '6', '5.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3094', '1940', '6', '4.50', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3095', '1941', '6', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3096', '1941', '6', '6.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3097', '1942', '6', '6.80', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3098', '1943', '6', '6.10', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3099', '1943', '6', '5.50', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3100', '1944', '6', '5.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3101', '1944', '6', '5.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3102', '1945', '6', '6.70', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3103', '1945', '6', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3104', '1946', '6', '6.60', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3105', '1946', '6', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3106', '1542', '3', '6.50', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3107', '1542', '3', '7.00', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3108', '1543', '3', '5.30', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3109', '1544', '3', '4.50', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3110', '1544', '3', '6.80', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3111', '1545', '3', '5.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3112', '1545', '3', '7.00', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3113', '1546', '3', '5.30', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3114', '1546', '3', '7.00', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3115', '1547', '3', '4.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3116', '1547', '3', '7.00', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3117', '1548', '3', '5.80', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3118', '1548', '3', '7.00', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3119', '1549', '3', '4.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3120', '1550', '3', '4.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3121', '1550', '3', '7.00', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3122', '1551', '3', '5.80', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3123', '1551', '3', '7.00', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3124', '1552', '3', '4.50', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3125', '1554', '3', '4.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3126', '1554', '3', '7.00', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3127', '1555', '3', '4.80', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3128', '1555', '3', '6.80', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3129', '1556', '3', '5.80', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3130', '1556', '3', '7.00', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3131', '1557', '3', '6.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3132', '1558', '3', '5.30', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3133', '1558', '3', '6.60', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3134', '1559', '3', '5.80', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3135', '1559', '3', '7.00', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3136', '1560', '3', '4.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3137', '1560', '3', '6.80', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3138', '1561', '3', '4.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3139', '1561', '3', '7.00', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3140', '1562', '3', '4.30', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3141', '1562', '3', '7.00', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3142', '1563', '3', '5.30', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3143', '1563', '3', '7.00', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3144', '1692', '6', '6.30', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3145', '1693', '6', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3146', '1694', '6', '6.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3147', '1695', '6', '6.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3148', '1696', '6', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3149', '1697', '6', '5.80', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3150', '1698', '6', '5.80', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3151', '1699', '6', '4.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3152', '1700', '6', '6.30', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3153', '1701', '6', '5.80', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3154', '1701', '6', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3155', '1702', '6', '6.30', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3156', '1703', '6', '4.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3157', '1703', '6', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3158', '1704', '6', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3159', '1704', '6', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3160', '1705', '6', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3161', '1706', '6', '4.20', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3162', '1707', '6', '5.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3163', '1708', '6', '6.10', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3164', '1708', '6', '6.50', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3165', '1709', '6', '4.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3166', '1710', '6', '4.50', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3167', '1711', '6', '4.50', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3168', '1712', '6', '6.50', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3169', '1542', '7', '6.20', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3170', '1543', '7', '6.50', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3171', '1544', '7', '6.60', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3172', '1545', '7', '6.60', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3173', '1546', '7', '6.20', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3174', '1547', '7', '6.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3175', '1548', '7', '6.20', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3176', '1549', '7', '6.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3177', '1550', '7', '5.80', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3178', '1551', '7', '6.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3179', '1552', '7', '6.60', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3180', '1553', '7', '5.80', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3181', '1554', '7', '6.60', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3182', '1555', '7', '6.60', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3183', '1556', '7', '6.60', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3184', '1557', '7', '6.60', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3185', '1558', '7', '6.60', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3186', '1559', '7', '6.60', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3187', '1560', '7', '6.20', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3188', '1561', '7', '6.20', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3189', '1562', '7', '6.60', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3190', '1563', '7', '6.20', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3191', '1692', '2', '5.40', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3192', '1693', '2', '6.80', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3193', '1694', '2', '5.90', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3194', '1695', '2', '6.10', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3195', '1696', '2', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3196', '1697', '2', '4.80', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3197', '1698', '2', '4.80', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3198', '1699', '2', '5.20', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3199', '1700', '2', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3200', '1701', '2', '5.30', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3201', '1702', '2', '6.60', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3202', '1703', '2', '6.60', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3203', '1704', '2', '6.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3204', '1705', '2', '5.90', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3205', '1706', '2', '4.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3206', '1707', '2', '6.20', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3207', '1708', '2', '4.80', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3208', '1709', '2', '4.90', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3209', '1710', '2', '4.20', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3210', '1711', '2', '4.10', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3211', '1712', '2', '4.80', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3212', '1542', '6', '6.40', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3213', '1543', '6', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3214', '1544', '6', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3215', '1545', '6', '6.90', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3216', '1546', '6', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3217', '1547', '6', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3218', '1548', '6', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3219', '1549', '6', '4.60', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3220', '1550', '6', '6.10', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3221', '1551', '6', '6.90', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3222', '1552', '6', '6.80', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3223', '1553', '6', '6.20', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3224', '1554', '6', '6.20', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3225', '1555', '6', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3226', '1556', '6', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3227', '1557', '6', '6.20', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3228', '1558', '6', '5.80', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3229', '1559', '6', '6.80', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3230', '1560', '6', '6.80', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3231', '1561', '6', '6.20', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3232', '1562', '6', '5.60', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3233', '1563', '6', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3234', '1542', '2', '4.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3235', '1542', '2', '4.50', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3236', '1543', '2', '4.80', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3237', '1543', '2', '5.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3238', '1544', '2', '6.90', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3239', '1544', '2', '6.60', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3240', '1545', '2', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3241', '1545', '2', '6.60', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3242', '1546', '2', '4.90', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3243', '1546', '2', '4.90', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3244', '1547', '2', '4.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3245', '1547', '2', '6.30', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3246', '1548', '2', '4.90', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3247', '1548', '2', '4.50', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3248', '1549', '2', '3.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3249', '1550', '2', '4.90', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3250', '1550', '2', '6.80', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3251', '1551', '2', '5.50', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3252', '1551', '2', '5.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3253', '1552', '2', '5.90', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3254', '1552', '2', '6.60', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3255', '1554', '2', '5.30', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3256', '1554', '2', '5.20', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3257', '1555', '2', '5.90', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3258', '1555', '2', '6.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3259', '1556', '2', '6.40', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3260', '1556', '2', '6.30', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3261', '1557', '2', '5.70', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3262', '1557', '2', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3263', '1558', '2', '5.50', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3264', '1558', '2', '4.30', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3265', '1559', '2', '4.40', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3266', '1559', '2', '6.30', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3267', '1560', '2', '3.80', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3268', '1560', '2', '4.80', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3269', '1561', '2', '4.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3270', '1561', '2', '5.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3271', '1562', '2', '6.60', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3272', '1562', '2', '6.60', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3273', '1563', '2', '5.50', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3274', '1563', '2', '5.20', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3275', '1585', '6', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3276', '1586', '6', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3277', '1586', '6', '4.60', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3278', '1587', '6', '5.50', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3279', '1587', '6', '6.30', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3280', '1588', '6', '6.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3281', '1588', '6', '5.90', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3282', '1589', '6', '6.50', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3283', '1589', '6', '4.00', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3284', '1590', '6', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3285', '1590', '6', '5.40', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3286', '1591', '6', '6.50', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3287', '1592', '6', '6.50', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3288', '1592', '6', '4.00', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3289', '1593', '6', '6.70', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3290', '1593', '6', '5.90', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3291', '1594', '6', '6.50', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3292', '1594', '6', '5.90', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3293', '1595', '6', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3294', '1595', '6', '6.10', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3295', '1596', '6', '5.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3296', '1596', '6', '6.80', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3297', '1597', '6', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3298', '1597', '6', '5.40', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3299', '1598', '6', '6.70', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3300', '1598', '6', '5.90', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3301', '1599', '6', '5.50', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3302', '1599', '6', '4.00', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3303', '1600', '6', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3304', '1601', '6', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3305', '1601', '6', '5.70', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3306', '1602', '6', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3307', '1602', '6', '5.70', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3308', '1603', '6', '6.50', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3309', '1603', '6', '4.80', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3310', '1604', '6', '5.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3311', '1604', '6', '4.60', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3312', '1605', '6', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3313', '1605', '6', '4.10', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3314', '1606', '6', '5.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3315', '1607', '6', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3316', '1607', '6', '6.30', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3317', '1608', '6', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3318', '1609', '6', '6.70', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3319', '1609', '6', '6.10', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3320', '1692', '11', '5.50', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3321', '1693', '11', '5.10', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3322', '1694', '11', '5.50', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3323', '1695', '11', '5.50', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3324', '1697', '11', '5.30', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3325', '1699', '11', '4.60', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3326', '1700', '11', '5.80', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3327', '1701', '11', '5.50', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3328', '1702', '11', '4.40', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3329', '1703', '11', '5.30', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3330', '1704', '11', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3331', '1705', '11', '4.80', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3332', '1706', '11', '3.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3333', '1707', '11', '6.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3334', '1708', '11', '5.50', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3335', '1709', '11', '4.40', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3336', '1710', '11', '3.50', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3337', '1711', '11', '3.60', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3338', '1692', '7', '5.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3339', '1692', '7', '6.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3340', '1693', '7', '5.30', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3341', '1693', '7', '6.80', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3342', '1694', '7', '5.70', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3343', '1694', '7', '6.70', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3344', '1695', '7', '6.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3345', '1695', '7', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3346', '1697', '7', '4.30', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3347', '1697', '7', '5.70', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3348', '1698', '7', '6.80', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3349', '1699', '7', '5.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3350', '1699', '7', '6.70', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3351', '1700', '7', '6.30', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3352', '1700', '7', '6.80', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3353', '1701', '7', '3.60', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3354', '1701', '7', '6.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3355', '1702', '7', '3.80', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3356', '1702', '7', '6.70', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3357', '1703', '7', '5.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3358', '1703', '7', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3359', '1704', '7', '5.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3360', '1704', '7', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3361', '1705', '7', '4.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3362', '1705', '7', '5.70', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3363', '1706', '7', '3.40', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3364', '1706', '7', '5.20', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3365', '1707', '7', '4.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3366', '1707', '7', '6.50', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3367', '1708', '7', '5.30', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3368', '1708', '7', '6.70', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3369', '1709', '7', '4.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3370', '1709', '7', '6.70', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3371', '1710', '7', '3.60', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3372', '1710', '7', '6.70', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3373', '1711', '7', '6.50', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3374', '1712', '7', '3.40', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3375', '1712', '7', '6.70', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3376', '1692', '4', '6.70', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3377', '1692', '4', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3378', '1693', '4', '6.70', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3379', '1693', '4', '6.50', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3380', '1694', '4', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3381', '1694', '4', '6.50', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3382', '1695', '4', '6.70', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3383', '1697', '4', '6.80', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3384', '1698', '4', '6.50', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3385', '1699', '4', '6.60', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3386', '1700', '4', '6.70', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3387', '1700', '4', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3388', '1701', '4', '5.60', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3389', '1701', '4', '6.50', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3390', '1702', '4', '6.50', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3391', '1702', '4', '6.50', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3392', '1703', '4', '6.40', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3393', '1703', '4', '6.50', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3394', '1704', '4', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3395', '1705', '4', '5.80', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3396', '1706', '4', '6.30', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3397', '1706', '4', '6.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3398', '1707', '4', '6.80', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3399', '1707', '4', '6.50', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3400', '1708', '4', '6.40', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3401', '1708', '4', '6.50', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3402', '1709', '4', '6.50', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3403', '1710', '4', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3404', '1710', '4', '6.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3405', '1711', '4', '5.80', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3406', '1712', '4', '6.30', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3407', '1692', '5', '5.40', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3408', '1692', '5', '6.50', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3409', '1693', '5', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3410', '1693', '5', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3411', '1694', '5', '6.70', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3412', '1694', '5', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3413', '1695', '5', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3414', '1695', '5', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3415', '1697', '5', '4.40', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3416', '1697', '5', '6.40', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3417', '1698', '5', '5.90', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3418', '1698', '5', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3419', '1699', '5', '5.50', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3420', '1699', '5', '6.50', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3421', '1700', '5', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3422', '1700', '5', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3423', '1701', '5', '4.20', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3424', '1701', '5', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3425', '1702', '5', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3426', '1702', '5', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3427', '1703', '5', '5.50', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3428', '1703', '5', '6.50', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3429', '1704', '5', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3430', '1704', '5', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3431', '1705', '5', '5.90', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3432', '1705', '5', '6.40', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3433', '1706', '5', '6.30', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3434', '1706', '5', '6.80', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3435', '1707', '5', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3436', '1707', '5', '6.70', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3437', '1708', '5', '6.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3438', '1708', '5', '6.60', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3439', '1709', '5', '5.40', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3440', '1709', '5', '6.50', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3441', '1710', '5', '6.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3442', '1710', '5', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3443', '1711', '5', '6.30', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3444', '1711', '5', '6.80', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3445', '1712', '5', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3446', '1712', '5', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3447', '1564', '4', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3448', '1565', '4', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3449', '1566', '4', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3450', '1567', '4', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3451', '1568', '4', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3452', '1569', '4', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3453', '1570', '4', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3454', '1571', '4', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3455', '1572', '4', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3456', '1573', '4', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3457', '1574', '4', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3458', '1575', '4', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3459', '1576', '4', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3460', '1577', '4', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3461', '1578', '4', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3462', '1579', '4', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3463', '1580', '4', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3464', '1581', '4', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3465', '1583', '4', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3466', '1584', '4', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3467', '1564', '7', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3468', '1565', '7', '6.40', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3469', '1566', '7', '6.40', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3470', '1567', '7', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3471', '1568', '7', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3472', '1569', '7', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3473', '1570', '7', '6.10', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3474', '1572', '7', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3475', '1573', '7', '5.80', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3476', '1574', '7', '5.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3477', '1575', '7', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3478', '1576', '7', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3479', '1577', '7', '6.60', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3480', '1578', '7', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3481', '1579', '7', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3482', '1580', '7', '6.10', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3483', '1581', '7', '6.70', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3484', '1583', '7', '6.40', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3485', '1584', '7', '6.40', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3486', '1564', '12', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3487', '1565', '12', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3488', '1566', '12', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3489', '1567', '12', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3490', '1568', '12', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3491', '1569', '12', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3492', '1570', '12', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3493', '1571', '12', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3494', '1572', '12', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3495', '1573', '12', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3496', '1574', '12', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3497', '1575', '12', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3498', '1576', '12', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3499', '1577', '12', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3500', '1578', '12', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3501', '1579', '12', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3502', '1580', '12', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3503', '1581', '12', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3504', '1583', '12', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3505', '1584', '12', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3506', '1429', '12', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3507', '1429', '12', '6.80', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3508', '1430', '12', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3509', '1430', '12', '6.60', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3510', '1431', '12', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3511', '1431', '12', '6.80', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3512', '1432', '12', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3513', '1432', '12', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3514', '1433', '12', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3515', '1433', '12', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3516', '1434', '12', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3517', '1434', '12', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3518', '1435', '12', '6.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3519', '1435', '12', '6.20', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3520', '1436', '12', '5.60', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3521', '1436', '12', '6.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3522', '1454', '12', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3523', '1454', '12', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3524', '1437', '12', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3525', '1437', '12', '6.40', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3526', '1438', '12', '6.60', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3527', '1438', '12', '6.40', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3528', '1439', '12', '6.20', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3529', '1439', '12', '6.30', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3530', '1440', '12', '6.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3531', '1440', '12', '6.40', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3532', '1441', '12', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3533', '1441', '12', '6.60', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3534', '1442', '12', '6.80', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3535', '1442', '12', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3536', '1443', '12', '6.40', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3537', '1443', '12', '6.80', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3538', '1444', '12', '6.60', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3539', '1444', '12', '6.40', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3540', '1445', '12', '6.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3541', '1445', '12', '6.40', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3542', '1446', '12', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3543', '1446', '12', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3544', '1447', '12', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3545', '1447', '12', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3546', '1713', '7', '3.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3547', '1714', '7', '6.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3548', '1716', '7', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3549', '1717', '7', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3550', '1718', '7', '2.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3551', '1719', '7', '6.80', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3552', '1720', '7', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3553', '1721', '7', '6.80', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3554', '1722', '7', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3555', '1723', '7', '6.80', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3556', '1724', '7', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3557', '1725', '7', '6.80', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3558', '1726', '7', '6.20', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3559', '1727', '7', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3560', '1728', '7', '6.60', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3561', '1729', '7', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3562', '1730', '7', '6.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3563', '1715', '12', '6.10', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3564', '1429', '4', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3565', '1429', '4', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3566', '1430', '4', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3567', '1430', '4', '6.80', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3568', '1431', '4', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3569', '1431', '4', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3570', '1432', '4', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3571', '1432', '4', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3572', '1433', '4', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3573', '1433', '4', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3574', '1434', '4', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3575', '1434', '4', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3576', '1435', '4', '6.20', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3577', '1435', '4', '6.40', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3578', '1436', '4', '6.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3579', '1436', '4', '6.10', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3580', '1454', '4', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3581', '1454', '4', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3582', '1437', '4', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3583', '1437', '4', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3584', '1438', '4', '6.60', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3585', '1438', '4', '6.70', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3586', '1439', '4', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3587', '1439', '4', '6.50', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3588', '1440', '4', '6.60', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3589', '1440', '4', '6.70', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3590', '1441', '4', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3591', '1441', '4', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3592', '1442', '4', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3593', '1442', '4', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3594', '1443', '4', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3595', '1443', '4', '6.40', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3596', '1444', '4', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3597', '1444', '4', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3598', '1445', '4', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3599', '1445', '4', '6.60', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3600', '1446', '4', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3601', '1446', '4', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3602', '1447', '4', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3603', '1447', '4', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3604', '1713', '3', '4.80', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3605', '1715', '3', '4.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3606', '1716', '3', '4.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3607', '1717', '3', '6.70', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3608', '1720', '3', '6.90', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3609', '1721', '3', '6.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3610', '1722', '3', '4.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3611', '1724', '3', '6.70', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3612', '1725', '3', '6.90', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3613', '1726', '3', '5.80', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3614', '1727', '3', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3615', '1728', '3', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3616', '1729', '3', '5.50', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3617', '1730', '3', '4.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3618', '1713', '5', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3619', '1714', '5', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3620', '1715', '5', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3621', '1716', '5', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3622', '1717', '5', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3623', '1718', '5', '6.80', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3624', '1719', '5', '6.80', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3625', '1720', '5', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3626', '1721', '5', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3627', '1722', '5', '6.80', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3628', '1723', '5', '6.30', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3629', '1724', '5', '6.40', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3630', '1725', '5', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3631', '1726', '5', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3632', '1727', '5', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3633', '1728', '5', '5.50', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3634', '1729', '5', '6.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3635', '1730', '5', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3636', '1825', '5', '6.30', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3637', '1458', '5', '6.60', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3638', '1461', '5', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3639', '1463', '5', '6.50', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3640', '1988', '5', '6.70', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3641', '1988', '5', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3642', '1713', '5', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3643', '1714', '5', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3644', '1715', '5', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3645', '1716', '5', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3646', '1717', '5', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3647', '1718', '5', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3648', '1719', '5', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3649', '1720', '5', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3650', '1721', '5', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3651', '1722', '5', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3652', '1723', '5', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3653', '1724', '5', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3654', '1725', '5', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3655', '1726', '5', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3656', '1727', '5', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3657', '1728', '5', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3658', '1729', '5', '6.50', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3659', '1730', '5', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3660', '1948', '3', '4.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3661', '1949', '3', '5.30', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3662', '1950', '3', '5.80', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3663', '1951', '3', '4.80', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3664', '1952', '3', '6.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3665', '1953', '3', '4.40', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3666', '1954', '3', '5.70', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3667', '1956', '3', '5.60', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3668', '1957', '3', '5.20', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3669', '1958', '3', '6.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3670', '1959', '3', '6.40', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3671', '1960', '3', '6.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3672', '1961', '3', '6.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3673', '1962', '3', '6.40', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3674', '1963', '3', '6.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3675', '1964', '3', '4.90', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3676', '1965', '3', '6.60', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3677', '1966', '3', '4.60', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3678', '1967', '3', '4.60', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3679', '1968', '3', '6.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3680', '1969', '3', '5.40', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3681', '1970', '3', '4.80', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3682', '1971', '3', '4.80', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3683', '1972', '3', '4.80', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3684', '1973', '3', '5.70', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3685', '1975', '3', '6.40', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3686', '1976', '3', '6.10', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3687', '1977', '3', '4.20', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3688', '1978', '3', '6.40', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3689', '1980', '3', '5.10', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3690', '1981', '3', '6.40', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3691', '1983', '3', '5.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3692', '1984', '3', '5.30', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3693', '1985', '3', '6.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3694', '1986', '3', '5.40', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3695', '1987', '3', '6.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3696', '1844', '12', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3697', '1844', '12', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3698', '1845', '12', '6.40', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3699', '1845', '12', '6.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3700', '1846', '12', '6.50', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3701', '1846', '12', '6.30', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3702', '1847', '12', '6.60', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3703', '1847', '12', '6.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3704', '1848', '12', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3705', '1848', '12', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3706', '1849', '12', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3707', '1849', '12', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3708', '1850', '12', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3709', '1850', '12', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3710', '1851', '12', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3711', '1851', '12', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3712', '1852', '12', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3713', '1852', '12', '6.70', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3714', '1853', '12', '6.40', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3715', '1853', '12', '6.10', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3716', '1854', '12', '6.30', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3717', '1854', '12', '6.60', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3718', '1855', '12', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3719', '1855', '12', '6.60', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3720', '1856', '12', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3721', '1856', '12', '6.50', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3722', '1857', '12', '6.40', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3723', '1857', '12', '6.80', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3724', '1858', '12', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3725', '1858', '12', '6.70', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3726', '1859', '12', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3727', '1859', '12', '6.60', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3728', '1860', '12', '6.40', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3729', '1860', '12', '6.60', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3730', '1861', '12', '6.50', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3731', '1861', '12', '6.80', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3732', '1862', '12', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3733', '1862', '12', '6.60', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3734', '1863', '12', '5.60', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3735', '1863', '12', '6.20', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3736', '1864', '12', '5.60', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3737', '1864', '12', '6.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3738', '1865', '12', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3739', '1865', '12', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3740', '1866', '12', '6.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3741', '1866', '12', '6.20', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3742', '1867', '12', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3743', '1867', '12', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3744', '1868', '12', '6.40', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3745', '1868', '12', '6.60', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3746', '1869', '12', '6.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3747', '1869', '12', '6.20', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3748', '1870', '12', '6.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3749', '1870', '12', '5.40', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3750', '1871', '12', '6.80', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3751', '1871', '12', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3752', '1872', '12', '6.40', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3753', '1872', '12', '6.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3754', '1873', '12', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3755', '1873', '12', '6.80', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3756', '1874', '12', '6.40', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3757', '1874', '12', '6.60', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3758', '1875', '12', '6.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3759', '1875', '12', '6.20', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3760', '1876', '12', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3761', '1876', '12', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3762', '1564', '2', '6.60', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3763', '1565', '2', '5.00', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3764', '1566', '2', '6.60', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3765', '1567', '2', '6.20', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3766', '1568', '2', '6.60', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3767', '1569', '2', '7.00', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3768', '1570', '2', '5.40', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3769', '1571', '2', '7.00', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3770', '1572', '2', '7.00', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3771', '1573', '2', '4.40', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3772', '1574', '2', '3.30', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3773', '1575', '2', '6.60', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3774', '1576', '2', '6.60', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3775', '1577', '2', '5.00', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3776', '1578', '2', '6.60', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3777', '1579', '2', '7.00', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3778', '1580', '2', '6.30', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3779', '1581', '2', '7.00', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3780', '1582', '2', '5.80', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3781', '1583', '2', '4.40', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3782', '1583', '2', '6.60', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3783', '1585', '2', '5.60', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3784', '1585', '2', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3785', '1585', '2', '6.20', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3786', '1586', '2', '5.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3787', '1586', '2', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3788', '1586', '2', '6.40', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3789', '1587', '2', '4.20', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3790', '1587', '2', '6.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3791', '1587', '2', '5.50', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3792', '1588', '2', '5.30', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3793', '1588', '2', '6.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3794', '1588', '2', '5.90', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3795', '1589', '2', '4.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3796', '1589', '2', '6.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3797', '1589', '2', '5.50', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3798', '1590', '2', '5.90', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3799', '1590', '2', '6.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3800', '1590', '2', '6.20', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3801', '1591', '2', '4.50', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3802', '1591', '2', '4.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3803', '1591', '2', '4.00', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3804', '1592', '2', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3805', '1592', '2', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3806', '1592', '2', '6.00', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3807', '1593', '2', '5.10', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3808', '1593', '2', '6.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3809', '1593', '2', '6.00', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3810', '1594', '2', '4.30', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3811', '1594', '2', '6.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3812', '1594', '2', '5.50', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3813', '1595', '2', '6.30', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3814', '1595', '2', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3815', '1595', '2', '7.00', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3816', '1596', '2', '5.70', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3817', '1596', '2', '6.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3818', '1596', '2', '7.00', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3819', '1597', '2', '4.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3820', '1597', '2', '6.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3821', '1597', '2', '5.50', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3822', '1598', '2', '4.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3823', '1598', '2', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3824', '1598', '2', '5.50', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3825', '1599', '2', '3.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3826', '1599', '2', '6.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3827', '1599', '2', '5.00', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3828', '1600', '2', '6.50', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3829', '1600', '2', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3830', '1600', '2', '7.00', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3831', '1601', '2', '6.60', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3832', '1601', '2', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3833', '1601', '2', '6.60', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3834', '1602', '2', '5.70', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3835', '1602', '2', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3836', '1602', '2', '6.50', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3837', '1603', '2', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3838', '1603', '2', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3839', '1603', '2', '6.60', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3840', '1604', '2', '4.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3841', '1604', '2', '6.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3842', '1604', '2', '5.50', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3843', '1605', '2', '4.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3844', '1605', '2', '6.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3845', '1605', '2', '5.50', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3846', '1606', '2', '6.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3847', '1606', '2', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3848', '1606', '2', '5.00', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3849', '1607', '2', '5.60', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3850', '1607', '2', '6.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3851', '1607', '2', '7.00', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3852', '1608', '2', '4.10', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3853', '1608', '2', '6.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3854', '1608', '2', '6.00', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3855', '1609', '2', '5.90', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3856', '1609', '2', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3857', '1609', '2', '7.00', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3858', '1542', '3', '5.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3859', '1544', '3', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3860', '1545', '3', '5.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3861', '1546', '3', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3862', '1547', '3', '6.20', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3863', '1548', '3', '6.40', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3864', '1550', '3', '5.80', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3865', '1551', '3', '4.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3866', '1553', '3', '4.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3867', '1554', '3', '4.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3868', '1555', '3', '6.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3869', '1556', '3', '5.80', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3870', '1558', '3', '4.80', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3871', '1559', '3', '5.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3872', '1560', '3', '4.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3873', '1561', '3', '5.50', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3874', '1562', '3', '5.80', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3875', '1563', '3', '5.40', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3876', '1587', '12', '5.50', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3877', '1589', '12', '5.50', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3878', '1592', '12', '6.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3879', '1599', '12', '4.40', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3880', '1713', '11', '6.30', '2025-05-26', '1', '4');
INSERT INTO `notas` VALUES('3881', '1714', '11', '7.00', '2025-05-26', '1', '4');
INSERT INTO `notas` VALUES('3882', '1716', '11', '7.00', '2025-05-26', '1', '4');
INSERT INTO `notas` VALUES('3883', '1717', '11', '6.00', '2025-05-26', '1', '4');
INSERT INTO `notas` VALUES('3884', '1718', '11', '6.00', '2025-05-26', '1', '4');
INSERT INTO `notas` VALUES('3885', '1719', '11', '6.00', '2025-05-26', '1', '4');
INSERT INTO `notas` VALUES('3886', '1720', '11', '6.60', '2025-05-26', '1', '4');
INSERT INTO `notas` VALUES('3887', '1721', '11', '6.80', '2025-05-26', '1', '4');
INSERT INTO `notas` VALUES('3888', '1722', '11', '6.50', '2025-05-26', '1', '4');
INSERT INTO `notas` VALUES('3889', '1723', '11', '6.50', '2025-05-26', '1', '4');
INSERT INTO `notas` VALUES('3890', '1724', '11', '5.40', '2025-05-26', '1', '4');
INSERT INTO `notas` VALUES('3891', '1727', '11', '7.00', '2025-05-26', '1', '4');
INSERT INTO `notas` VALUES('3892', '1728', '11', '6.50', '2025-05-26', '1', '4');
INSERT INTO `notas` VALUES('3893', '1729', '11', '6.50', '2025-05-26', '1', '4');
INSERT INTO `notas` VALUES('3894', '1730', '11', '5.80', '2025-05-26', '1', '4');
INSERT INTO `notas` VALUES('3895', '1564', '3', '6.60', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3896', '1564', '3', '6.40', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3897', '1565', '3', '5.80', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3898', '1565', '3', '6.60', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3899', '1566', '3', '6.60', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3900', '1567', '3', '5.80', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3901', '1567', '3', '5.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3902', '1568', '3', '6.60', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3903', '1568', '3', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3904', '1569', '3', '6.60', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3905', '1569', '3', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3906', '1570', '3', '6.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3907', '1570', '3', '6.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3908', '1571', '3', '6.20', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3909', '1572', '3', '6.60', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3910', '1572', '3', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3911', '1573', '3', '4.50', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3912', '1574', '3', '5.60', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3913', '1574', '3', '4.50', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3914', '1575', '3', '6.80', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3915', '1575', '3', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3916', '1576', '3', '5.60', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3917', '1576', '3', '5.80', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3918', '1577', '3', '5.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3919', '1577', '3', '5.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3920', '1578', '3', '5.60', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3921', '1578', '3', '6.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3922', '1579', '3', '6.40', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3923', '1579', '3', '6.80', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3924', '1580', '3', '5.80', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3925', '1580', '3', '6.20', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3926', '1581', '3', '5.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3927', '1581', '3', '5.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3928', '1582', '3', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3929', '1583', '3', '5.80', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3930', '1583', '3', '6.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3931', '1584', '3', '6.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3932', '1584', '3', '5.20', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3933', '1564', '1', '6.70', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3934', '1565', '1', '5.70', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3935', '1566', '1', '5.70', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3936', '1567', '1', '5.30', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3937', '1568', '1', '7.00', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3938', '1569', '1', '6.30', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3939', '1570', '1', '4.70', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3940', '1572', '1', '6.70', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3941', '1573', '1', '4.00', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3942', '1574', '1', '4.00', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3943', '1575', '1', '4.30', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3944', '1576', '1', '4.70', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3945', '1577', '1', '5.70', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3946', '1578', '1', '6.00', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3947', '1579', '1', '6.00', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3948', '1580', '1', '4.30', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3949', '1581', '1', '5.30', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3950', '1582', '1', '6.30', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3951', '1583', '1', '4.30', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3952', '1542', '1', '4.20', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3953', '1543', '1', '5.50', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3954', '1544', '1', '5.00', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3955', '1545', '1', '5.50', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3956', '1546', '1', '4.00', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3957', '1547', '1', '5.60', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3958', '1548', '1', '5.50', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3959', '1549', '1', '4.60', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3960', '1550', '1', '7.00', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3961', '1551', '1', '5.50', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3962', '1552', '1', '7.00', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3963', '1554', '1', '4.70', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3964', '1556', '1', '6.60', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3965', '1557', '1', '6.00', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3966', '1561', '1', '4.30', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3967', '1562', '1', '5.50', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3968', '1563', '1', '5.50', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('3969', '1542', '1', '6.80', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3970', '1542', '1', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3971', '1543', '1', '5.50', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3972', '1543', '1', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3973', '1544', '1', '6.90', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3974', '1544', '1', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3975', '1545', '1', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3976', '1545', '1', '6.30', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3977', '1546', '1', '6.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3978', '1546', '1', '5.50', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3979', '1547', '1', '6.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3980', '1547', '1', '6.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3981', '1548', '1', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3982', '1548', '1', '5.80', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3983', '1549', '1', '5.80', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3984', '1549', '1', '4.80', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3985', '1550', '1', '6.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3986', '1550', '1', '5.30', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3987', '1551', '1', '6.60', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3988', '1551', '1', '5.80', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3989', '1552', '1', '6.80', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3990', '1552', '1', '6.80', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3991', '1553', '1', '6.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3992', '1553', '1', '6.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3993', '1554', '1', '6.60', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3994', '1554', '1', '6.50', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3995', '1555', '1', '6.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3996', '1555', '1', '6.50', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3997', '1556', '1', '6.80', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('3998', '1556', '1', '6.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('3999', '1557', '1', '6.60', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4000', '1557', '1', '5.10', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4001', '1558', '1', '4.40', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4002', '1558', '1', '6.50', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4003', '1559', '1', '6.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4004', '1559', '1', '6.50', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4005', '1560', '1', '5.70', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4006', '1560', '1', '4.60', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4007', '1561', '1', '6.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4008', '1561', '1', '6.30', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4009', '1562', '1', '6.60', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4010', '1562', '1', '6.50', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4011', '1563', '1', '6.60', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4012', '1563', '1', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4013', '1675', '7', '4.30', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4014', '1675', '7', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4015', '1676', '7', '4.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4016', '1677', '7', '6.30', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4017', '1677', '7', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4018', '1678', '7', '5.30', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4019', '1678', '7', '6.60', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4020', '1679', '7', '4.30', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4021', '1679', '7', '6.60', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4022', '1680', '7', '6.40', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4023', '1682', '7', '5.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4024', '1682', '7', '5.70', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4025', '1683', '7', '3.80', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4026', '1683', '7', '5.90', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4027', '1684', '7', '4.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4028', '1684', '7', '6.60', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4029', '1685', '7', '5.70', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4030', '1685', '7', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4031', '1688', '7', '4.30', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4032', '1689', '7', '4.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4033', '1689', '7', '6.60', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4034', '1690', '7', '3.20', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4035', '1690', '7', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4036', '1691', '7', '3.20', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4037', '1691', '7', '6.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4038', '1675', '3', '4.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4039', '1675', '3', '4.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4040', '1676', '3', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4041', '1678', '3', '6.20', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4042', '1680', '3', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4043', '1681', '3', '6.70', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4044', '1682', '3', '5.80', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4045', '1682', '3', '6.50', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4046', '1683', '3', '6.80', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4047', '1684', '3', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4048', '1685', '3', '6.20', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4049', '1685', '3', '6.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4050', '1687', '3', '4.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4051', '1687', '3', '4.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4052', '1689', '3', '4.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4053', '1690', '3', '6.80', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4054', '1690', '3', '5.20', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4055', '1691', '3', '6.40', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4056', '1585', '1', '4.20', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4057', '1585', '1', '5.40', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4058', '1586', '1', '4.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4059', '1586', '1', '5.70', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4060', '1586', '1', '5.40', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4061', '1587', '1', '4.80', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4062', '1587', '1', '5.90', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4063', '1587', '1', '6.30', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4064', '1588', '1', '6.70', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4065', '1588', '1', '5.90', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4066', '1588', '1', '5.40', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4067', '1589', '1', '4.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4068', '1589', '1', '5.40', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4069', '1590', '1', '5.20', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4070', '1590', '1', '6.50', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4071', '1590', '1', '4.70', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4072', '1591', '1', '4.20', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4073', '1591', '1', '3.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4074', '1591', '1', '4.70', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4075', '1592', '1', '4.50', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4076', '1592', '1', '6.00', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4077', '1593', '1', '4.80', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4078', '1593', '1', '6.70', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4079', '1594', '1', '5.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4080', '1594', '1', '3.50', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4081', '1594', '1', '4.70', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4082', '1595', '1', '6.30', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4083', '1595', '1', '5.10', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4084', '1595', '1', '7.00', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4085', '1596', '1', '5.70', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4086', '1596', '1', '5.90', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4087', '1596', '1', '5.00', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4088', '1597', '1', '5.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4089', '1597', '1', '5.40', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4090', '1597', '1', '6.30', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4091', '1598', '1', '5.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4092', '1598', '1', '4.40', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4093', '1598', '1', '5.70', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4094', '1599', '1', '4.50', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4095', '1599', '1', '6.70', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4096', '1599', '1', '6.70', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4097', '1600', '1', '5.50', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4098', '1600', '1', '5.40', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4099', '1600', '1', '5.70', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4100', '1601', '1', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4101', '1601', '1', '6.40', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4102', '1601', '1', '7.00', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4103', '1602', '1', '5.70', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4104', '1602', '1', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4105', '1602', '1', '6.70', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4106', '1603', '1', '6.70', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4107', '1603', '1', '6.40', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4108', '1603', '1', '6.00', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4109', '1604', '1', '4.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4110', '1604', '1', '4.40', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4111', '1604', '1', '6.30', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4112', '1605', '1', '5.40', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4113', '1605', '1', '6.30', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4114', '1606', '1', '5.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4115', '1606', '1', '4.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4116', '1606', '1', '5.00', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4117', '1607', '1', '5.80', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4118', '1607', '1', '5.70', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4119', '1607', '1', '6.70', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4120', '1608', '1', '6.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4121', '1608', '1', '5.40', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4122', '1608', '1', '6.00', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4123', '1609', '1', '5.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4124', '1609', '1', '6.20', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4125', '1609', '1', '5.40', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4126', '1585', '4', '6.60', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4127', '1586', '4', '6.60', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4128', '1586', '4', '6.80', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4129', '1587', '4', '6.60', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4130', '1587', '4', '6.80', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4131', '1588', '4', '6.80', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4132', '1588', '4', '6.80', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4133', '1589', '4', '6.60', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4134', '1589', '4', '6.80', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4135', '1590', '4', '6.60', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4136', '1590', '4', '6.80', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4137', '1591', '4', '6.80', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4138', '1592', '4', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4139', '1592', '4', '6.80', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4140', '1593', '4', '6.20', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4141', '1593', '4', '6.80', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4142', '1594', '4', '6.80', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4143', '1594', '4', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4144', '1595', '4', '6.80', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4145', '1595', '4', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4146', '1596', '4', '6.60', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4147', '1596', '4', '6.80', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4148', '1597', '4', '6.60', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4149', '1597', '4', '6.80', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4150', '1598', '4', '6.60', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4151', '1598', '4', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4152', '1600', '4', '6.60', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4153', '1600', '4', '6.80', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4154', '1601', '4', '6.60', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4155', '1602', '4', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4156', '1602', '4', '6.80', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4157', '1603', '4', '6.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4158', '1604', '4', '6.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4159', '1605', '4', '6.80', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4160', '1605', '4', '6.80', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4161', '1607', '4', '6.80', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4162', '1608', '4', '6.80', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4163', '1608', '4', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4164', '1609', '4', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4165', '1675', '4', '6.60', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4166', '1675', '4', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4167', '1676', '4', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4168', '1676', '4', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4169', '1677', '4', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4170', '1677', '4', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4171', '1677', '4', '7.00', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4172', '1678', '4', '6.80', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4173', '1678', '4', '6.70', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4174', '1678', '4', '7.00', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4175', '1679', '4', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4176', '1679', '4', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4177', '1680', '4', '6.80', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4178', '1680', '4', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4179', '1680', '4', '7.00', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4180', '1681', '4', '6.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4181', '1681', '4', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4182', '1681', '4', '6.80', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4183', '1682', '4', '6.40', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4184', '1682', '4', '6.80', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4185', '1682', '4', '6.50', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4186', '1683', '4', '6.80', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4187', '1683', '4', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4188', '1684', '4', '6.60', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4189', '1684', '4', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4190', '1684', '4', '6.50', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4191', '1685', '4', '6.60', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4192', '1685', '4', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4193', '1685', '4', '6.00', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4194', '1687', '4', '6.40', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4195', '1687', '4', '6.20', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4196', '1687', '4', '5.00', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4197', '1688', '4', '6.50', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4198', '1688', '4', '6.80', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4199', '1688', '4', '6.80', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4200', '1689', '4', '6.50', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4201', '1689', '4', '6.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4202', '1689', '4', '6.50', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4203', '1690', '4', '6.80', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4204', '1690', '4', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4205', '1691', '4', '6.40', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4206', '1691', '4', '6.80', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4207', '1691', '4', '6.80', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4208', '1692', '9', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4209', '1692', '9', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4210', '1693', '9', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4211', '1693', '9', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4212', '1694', '9', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4213', '1694', '9', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4214', '1695', '9', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4215', '1695', '9', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4216', '1696', '9', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4217', '1696', '9', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4218', '1697', '9', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4219', '1697', '9', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4220', '1698', '9', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4221', '1698', '9', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4222', '1699', '9', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4223', '1699', '9', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4224', '1700', '9', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4225', '1700', '9', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4226', '1701', '9', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4227', '1701', '9', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4228', '1702', '9', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4229', '1702', '9', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4230', '1703', '9', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4231', '1703', '9', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4232', '1704', '9', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4233', '1704', '9', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4234', '1705', '9', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4235', '1705', '9', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4236', '1706', '9', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4237', '1706', '9', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4238', '1707', '9', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4239', '1707', '9', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4240', '1708', '9', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4241', '1708', '9', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4242', '1709', '9', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4243', '1709', '9', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4244', '1710', '9', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4245', '1710', '9', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4246', '1711', '9', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4247', '1711', '9', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4248', '1712', '9', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4249', '1712', '9', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4250', '1948', '1', '5.50', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4251', '1948', '1', '6.50', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4252', '1949', '1', '5.80', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4253', '1949', '1', '4.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4254', '1950', '1', '5.40', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4255', '1951', '1', '4.90', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4256', '1951', '1', '6.50', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4257', '1952', '1', '3.70', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4258', '1952', '1', '5.50', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4259', '1953', '1', '5.80', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4260', '1953', '1', '6.50', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4261', '1954', '1', '3.80', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4262', '1954', '1', '5.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4263', '1956', '1', '3.50', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4264', '1956', '1', '5.50', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4265', '1957', '1', '4.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4266', '1957', '1', '5.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4267', '1958', '1', '6.80', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4268', '1958', '1', '6.50', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4269', '1959', '1', '3.90', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4270', '1959', '1', '6.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4271', '1960', '1', '4.50', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4272', '1960', '1', '5.50', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4273', '1961', '1', '4.50', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4274', '1961', '1', '4.50', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4275', '1962', '1', '5.50', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4276', '1962', '1', '6.50', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4277', '1963', '1', '3.70', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4278', '1963', '1', '5.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4279', '1964', '1', '3.40', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4280', '1964', '1', '5.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4281', '1965', '1', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4282', '1965', '1', '5.50', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4283', '1966', '1', '4.50', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4284', '1966', '1', '6.50', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4285', '1967', '1', '4.60', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4286', '1968', '1', '4.40', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4287', '1968', '1', '6.50', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4288', '1969', '1', '4.20', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4289', '1969', '1', '6.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4290', '1970', '1', '3.80', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4291', '1970', '1', '4.50', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4292', '1971', '1', '3.90', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4293', '1971', '1', '4.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4294', '1972', '1', '5.30', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4295', '1972', '1', '5.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4296', '1973', '1', '5.50', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4297', '1973', '1', '6.50', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4298', '1975', '1', '6.80', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4299', '1975', '1', '5.50', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4300', '1976', '1', '5.30', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4301', '1976', '1', '6.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4302', '1977', '1', '5.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4303', '1977', '1', '6.50', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4304', '1978', '1', '5.50', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4305', '1978', '1', '5.50', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4306', '1979', '1', '3.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4307', '1979', '1', '5.50', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4308', '1980', '1', '5.30', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4309', '1981', '1', '6.50', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4310', '1983', '1', '3.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4311', '1983', '1', '6.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4312', '1984', '1', '6.50', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4313', '1984', '1', '6.50', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4314', '1985', '1', '4.50', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4315', '1986', '1', '4.20', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4316', '1986', '1', '4.50', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4317', '1987', '1', '6.30', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4318', '1987', '1', '6.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4319', '1922', '2', '6.60', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4320', '1922', '2', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4321', '1922', '2', '7.00', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4322', '1923', '2', '4.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4323', '1923', '2', '4.50', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4324', '1924', '2', '5.90', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4325', '1924', '2', '6.70', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4326', '1925', '2', '5.50', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4327', '1925', '2', '5.70', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4328', '1926', '2', '5.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4329', '1926', '2', '7.00', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4330', '1927', '2', '5.10', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4331', '1927', '2', '6.70', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4332', '1927', '2', '7.00', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4333', '1928', '2', '6.20', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4334', '1928', '2', '7.00', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4335', '1929', '2', '3.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4336', '1929', '2', '5.50', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4337', '1929', '2', '2.80', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4338', '1930', '2', '4.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4339', '1931', '2', '4.30', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4340', '1931', '2', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4341', '1931', '2', '6.70', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4342', '1932', '2', '5.40', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4343', '1932', '2', '6.80', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4344', '1932', '2', '3.80', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4345', '1933', '2', '6.20', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4346', '1933', '2', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4347', '1933', '2', '7.00', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4348', '1947', '2', '5.80', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4349', '1934', '2', '6.70', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4350', '1934', '2', '6.80', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4351', '1935', '2', '6.60', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4352', '1935', '2', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4353', '1935', '2', '7.00', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4354', '1936', '2', '6.20', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4355', '1936', '2', '6.50', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4356', '1936', '2', '7.00', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4357', '1937', '2', '5.60', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4358', '1938', '2', '4.70', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4359', '1938', '2', '6.20', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4360', '1938', '2', '5.70', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4361', '1939', '2', '2.20', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4362', '1939', '2', '2.00', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4363', '1940', '2', '3.60', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4364', '1940', '2', '6.20', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4365', '1941', '2', '6.20', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4366', '1941', '2', '6.80', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4367', '1941', '2', '7.00', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4368', '1942', '2', '5.10', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4369', '1942', '2', '7.00', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4370', '1943', '2', '4.80', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4371', '1943', '2', '6.70', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4372', '1943', '2', '5.70', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4373', '1944', '2', '4.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4374', '1944', '2', '2.80', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4375', '1945', '2', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4376', '1945', '2', '6.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4377', '1945', '2', '7.00', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4378', '1946', '2', '5.40', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4379', '1946', '2', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4380', '1946', '2', '7.00', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4381', '1922', '7', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4382', '1922', '7', '6.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4383', '1922', '7', '7.00', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4384', '1923', '7', '6.80', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4385', '1923', '7', '4.00', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4386', '1924', '7', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4387', '1924', '7', '4.40', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4388', '1925', '7', '4.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4389', '1925', '7', '2.60', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4390', '1926', '7', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4391', '1926', '7', '5.80', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4392', '1927', '7', '6.50', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4393', '1927', '7', '2.60', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4394', '1927', '7', '5.90', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4395', '1928', '7', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4396', '1928', '7', '4.40', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4397', '1929', '7', '4.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4398', '1929', '7', '3.70', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4399', '1929', '7', '3.00', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4400', '1930', '7', '6.80', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4401', '1931', '7', '6.40', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4402', '1931', '7', '3.70', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4403', '1931', '7', '5.40', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4404', '1932', '7', '6.70', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4405', '1932', '7', '3.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4406', '1932', '7', '5.40', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4407', '1933', '7', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4408', '1933', '7', '6.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4409', '1933', '7', '6.50', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4410', '1947', '7', '4.80', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4411', '1934', '7', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4412', '1934', '7', '6.60', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4413', '1935', '7', '6.70', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4414', '1935', '7', '5.70', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4415', '1935', '7', '7.00', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4416', '1936', '7', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4417', '1936', '7', '5.10', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4418', '1936', '7', '5.90', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4419', '1937', '7', '6.70', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4420', '1938', '7', '6.70', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4421', '1938', '7', '4.40', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4422', '1938', '7', '3.30', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4423', '1939', '7', '6.40', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4424', '1939', '7', '4.70', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4425', '1940', '7', '6.80', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4426', '1940', '7', '3.80', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4427', '1941', '7', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4428', '1941', '7', '6.40', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4429', '1941', '7', '6.60', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4430', '1942', '7', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4431', '1942', '7', '5.10', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4432', '1943', '7', '6.80', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4433', '1943', '7', '3.40', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4434', '1943', '7', '4.40', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4435', '1944', '7', '6.70', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4436', '1944', '7', '3.70', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4437', '1945', '7', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4438', '1945', '7', '6.40', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4439', '1945', '7', '6.80', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4440', '1946', '7', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4441', '1946', '7', '2.60', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4442', '1946', '7', '4.70', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4443', '1948', '4', '6.50', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4444', '1949', '4', '6.40', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4445', '1949', '4', '6.40', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4446', '1950', '4', '6.20', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4447', '1950', '4', '6.40', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4448', '1951', '4', '6.60', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4449', '1951', '4', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4450', '1952', '4', '6.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4451', '1952', '4', '6.50', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4452', '1953', '4', '6.40', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4453', '1953', '4', '6.40', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4454', '1954', '4', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4455', '1956', '4', '6.10', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4456', '1956', '4', '6.60', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4457', '1957', '4', '5.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4458', '1958', '4', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4459', '1958', '4', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4460', '1959', '4', '6.50', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4461', '1960', '4', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4462', '1960', '4', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4463', '1961', '4', '6.50', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4464', '1962', '4', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4465', '1963', '4', '6.60', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4466', '1963', '4', '6.70', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4467', '1964', '4', '6.20', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4468', '1965', '4', '6.40', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4469', '1966', '4', '6.20', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4470', '1966', '4', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4471', '1967', '4', '5.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4472', '1967', '4', '6.40', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4473', '1968', '4', '6.60', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4474', '1968', '4', '6.40', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4475', '1969', '4', '6.20', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4476', '1969', '4', '6.40', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4477', '1970', '4', '6.40', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4478', '1970', '4', '6.40', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4479', '1971', '4', '6.50', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4480', '1972', '4', '6.50', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4481', '1973', '4', '6.40', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4482', '1973', '4', '6.40', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4483', '1975', '4', '6.50', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4484', '1975', '4', '6.70', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4485', '1976', '4', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4486', '1977', '4', '6.70', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4487', '1977', '4', '6.80', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4488', '1978', '4', '6.60', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4489', '1978', '4', '6.80', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4490', '1979', '4', '5.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4491', '1980', '4', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4492', '1980', '4', '6.50', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4493', '1981', '4', '6.40', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4494', '1981', '4', '6.70', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4495', '1983', '4', '5.50', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4496', '1983', '4', '6.40', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4497', '1984', '4', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4498', '1984', '4', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4499', '1985', '4', '6.40', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4500', '1986', '4', '5.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4501', '1987', '4', '6.80', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4502', '1987', '4', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4503', '1844', '3', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4504', '1845', '3', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4505', '1846', '3', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4506', '1847', '3', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4507', '1848', '3', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4508', '1849', '3', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4509', '1850', '3', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4510', '1851', '3', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4511', '1852', '3', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4512', '1853', '3', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4513', '1854', '3', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4514', '1855', '3', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4515', '1856', '3', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4516', '1857', '3', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4517', '1858', '3', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4518', '1859', '3', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4519', '1860', '3', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4520', '1861', '3', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4521', '1862', '3', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4522', '1863', '3', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4523', '1864', '3', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4524', '1865', '3', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4525', '1866', '3', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4526', '1867', '3', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4527', '1868', '3', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4528', '1869', '3', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4529', '1870', '3', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4530', '1871', '3', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4531', '1872', '3', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4532', '1873', '3', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4533', '1874', '3', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4534', '1875', '3', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4535', '1876', '3', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4536', '1923', '7', '2.20', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4537', '1924', '7', '4.50', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4538', '1925', '7', '4.50', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4539', '1926', '7', '3.40', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4540', '1928', '7', '4.10', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4541', '1930', '7', '2.60', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4542', '1930', '7', '3.00', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4543', '1947', '7', '4.00', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4544', '1934', '7', '5.70', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4545', '1937', '7', '3.70', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4546', '1937', '7', '5.60', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4547', '1939', '7', '3.70', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4548', '1940', '7', '4.40', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4549', '1942', '7', '3.40', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4550', '1944', '7', '3.70', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4551', '1922', '4', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4552', '1922', '4', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4553', '1922', '4', '6.80', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4554', '1923', '4', '5.30', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4555', '1923', '4', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4556', '1923', '4', '4.90', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4557', '1924', '4', '6.40', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4558', '1924', '4', '5.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4559', '1924', '4', '4.70', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4560', '1925', '4', '6.10', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4561', '1925', '4', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4562', '1925', '4', '5.60', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4563', '1926', '4', '6.40', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4564', '1926', '4', '5.50', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4565', '1926', '4', '6.40', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4566', '1927', '4', '6.40', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4567', '1927', '4', '5.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4568', '1927', '4', '5.70', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4569', '1928', '4', '6.40', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4570', '1928', '4', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4571', '1928', '4', '5.80', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4572', '1929', '4', '6.40', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4573', '1929', '4', '5.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4574', '1929', '4', '5.10', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4575', '1930', '4', '6.40', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4576', '1930', '4', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4577', '1930', '4', '5.40', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4578', '1931', '4', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4579', '1931', '4', '5.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4580', '1931', '4', '5.60', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4581', '1932', '4', '6.70', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4582', '1932', '4', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4583', '1932', '4', '4.90', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4584', '1933', '4', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4585', '1933', '4', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4586', '1933', '4', '6.60', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4587', '1947', '4', '4.50', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4588', '1947', '4', '5.50', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4589', '1934', '4', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4590', '1934', '4', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4591', '1934', '4', '6.50', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4592', '1935', '4', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4593', '1935', '4', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4594', '1935', '4', '6.90', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4595', '1936', '4', '6.40', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4596', '1936', '4', '5.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4597', '1936', '4', '5.60', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4598', '1937', '4', '6.70', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4599', '1937', '4', '6.50', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4600', '1937', '4', '6.40', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4601', '1938', '4', '5.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4602', '1938', '4', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4603', '1938', '4', '5.40', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4604', '1939', '4', '5.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4605', '1939', '4', '4.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4606', '1939', '4', '4.60', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4607', '1940', '4', '6.80', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4608', '1940', '4', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4609', '1940', '4', '5.30', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4610', '1941', '4', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4611', '1941', '4', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4612', '1941', '4', '6.90', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4613', '1942', '4', '6.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4614', '1942', '4', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4615', '1942', '4', '5.70', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4616', '1943', '4', '6.40', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4617', '1943', '4', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4618', '1943', '4', '5.10', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4619', '1944', '4', '6.70', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4620', '1944', '4', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4621', '1944', '4', '5.20', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4622', '1945', '4', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4623', '1945', '4', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4624', '1945', '4', '6.90', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4625', '1946', '4', '6.70', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4626', '1946', '4', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4627', '1946', '4', '6.70', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4635', '1592', '3', '6.10', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4637', '1594', '3', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4638', '1595', '3', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4640', '1597', '3', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4653', '1924', '3', '6.50', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4654', '1925', '3', '6.50', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4655', '1926', '3', '6.10', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4656', '1927', '3', '5.60', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4657', '1928', '3', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4658', '1929', '3', '6.50', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4659', '1930', '3', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4660', '1931', '3', '6.10', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4661', '1932', '3', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4662', '1934', '3', '6.50', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4663', '1935', '3', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4664', '1936', '3', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4665', '1937', '3', '6.50', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4666', '1938', '3', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4667', '1939', '3', '4.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4668', '1941', '3', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4669', '1942', '3', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4670', '1943', '3', '6.50', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4671', '1944', '3', '5.80', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4672', '1945', '3', '6.50', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4673', '1946', '3', '6.10', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4674', '1922', '12', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4675', '1922', '12', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4676', '1922', '12', '6.80', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4677', '1923', '12', '6.80', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4678', '1923', '12', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4679', '1923', '12', '4.90', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4680', '1924', '12', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4681', '1924', '12', '6.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4682', '1924', '12', '4.70', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4683', '1925', '12', '4.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4684', '1925', '12', '6.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4685', '1925', '12', '6.40', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4686', '1926', '12', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4687', '1926', '12', '5.50', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4688', '1926', '12', '6.40', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4689', '1927', '12', '6.50', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4690', '1927', '12', '5.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4691', '1927', '12', '5.70', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4692', '1928', '12', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4693', '1928', '12', '6.50', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4694', '1928', '12', '5.80', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4695', '1929', '12', '4.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4696', '1929', '12', '5.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4697', '1929', '12', '5.10', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4698', '1930', '12', '6.80', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4699', '1930', '12', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4700', '1930', '12', '5.40', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4701', '1931', '12', '6.40', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4702', '1931', '12', '5.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4703', '1931', '12', '5.60', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4704', '1932', '12', '6.70', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4705', '1932', '12', '6.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4706', '1932', '12', '5.00', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4707', '1933', '12', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4708', '1933', '12', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4709', '1933', '12', '6.60', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4710', '1947', '12', '6.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4711', '1947', '12', '5.50', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4712', '1934', '12', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4713', '1934', '12', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4714', '1934', '12', '6.50', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4715', '1935', '12', '6.70', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4716', '1935', '12', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4717', '1935', '12', '6.90', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4718', '1936', '12', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4719', '1936', '12', '5.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4720', '1936', '12', '5.00', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4721', '1937', '12', '6.70', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4722', '1937', '12', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4723', '1937', '12', '6.40', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4724', '1938', '12', '6.70', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4725', '1938', '12', '4.50', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4726', '1938', '12', '5.40', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4727', '1939', '12', '6.40', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4728', '1939', '12', '4.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4729', '1939', '12', '4.60', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4730', '1940', '12', '6.80', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4731', '1940', '12', '5.50', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4732', '1940', '12', '5.30', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4733', '1941', '12', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4734', '1941', '12', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4735', '1941', '12', '6.90', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4736', '1942', '12', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4737', '1942', '12', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4738', '1942', '12', '5.70', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4739', '1943', '12', '6.80', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4740', '1943', '12', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4741', '1943', '12', '5.10', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4742', '1944', '12', '6.70', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4743', '1944', '12', '6.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4744', '1944', '12', '5.20', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4745', '1945', '12', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4746', '1945', '12', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4747', '1945', '12', '6.90', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4748', '1946', '12', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4749', '1946', '12', '5.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4750', '1946', '12', '6.70', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4751', '1692', '12', '6.30', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4752', '1694', '12', '4.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4753', '1695', '12', '6.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4754', '1697', '12', '5.60', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4755', '1698', '12', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4756', '1699', '12', '6.60', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4757', '1700', '12', '6.30', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4758', '1701', '12', '4.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4759', '1702', '12', '6.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4760', '1703', '12', '5.60', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4761', '1704', '12', '5.40', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4762', '1706', '12', '5.60', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4763', '1707', '12', '6.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4764', '1708', '12', '5.40', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4765', '1709', '12', '6.30', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4766', '1710', '12', '6.60', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4767', '1712', '12', '5.60', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4768', '1692', '3', '4.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4769', '1693', '3', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4770', '1693', '3', '5.50', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4771', '1694', '3', '4.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4772', '1694', '3', '4.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4773', '1695', '3', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4774', '1697', '3', '4.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4775', '1697', '3', '5.20', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4776', '1699', '3', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4777', '1699', '3', '5.80', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4778', '1700', '3', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4779', '1700', '3', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4780', '1701', '3', '4.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4781', '1701', '3', '4.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4782', '1702', '3', '4.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4783', '1703', '3', '6.20', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4784', '1703', '3', '5.80', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4785', '1704', '3', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4786', '1705', '3', '4.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4787', '1705', '3', '4.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4788', '1706', '3', '4.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4789', '1706', '3', '4.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4790', '1707', '3', '4.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4791', '1707', '3', '5.60', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4792', '1708', '3', '6.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4793', '1708', '3', '6.20', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4794', '1709', '3', '6.60', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4795', '1709', '3', '5.50', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4796', '1710', '3', '4.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4797', '1711', '3', '4.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4798', '1711', '3', '4.80', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4799', '1712', '3', '4.20', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4800', '1731', '7', '6.50', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4801', '1731', '7', '6.50', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4802', '1732', '7', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4803', '1732', '7', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4804', '1733', '7', '4.10', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4805', '1733', '7', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4806', '1734', '7', '6.90', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4807', '1734', '7', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4808', '1735', '7', '6.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4809', '1735', '7', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4810', '1736', '7', '4.80', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4811', '1736', '7', '6.50', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4812', '1737', '7', '6.50', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4813', '1737', '7', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4814', '1738', '7', '6.50', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4815', '1738', '7', '6.50', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4816', '1739', '7', '6.30', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4817', '1740', '7', '5.10', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4818', '1740', '7', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4819', '1741', '7', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4820', '1741', '7', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4821', '1742', '7', '6.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4822', '1742', '7', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4823', '1743', '7', '5.10', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4824', '1743', '7', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4825', '1744', '7', '5.60', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4826', '1744', '7', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4827', '1745', '7', '4.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4828', '1745', '7', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4829', '1746', '7', '5.60', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4830', '1746', '7', '6.50', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4831', '1747', '7', '4.80', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4832', '1747', '7', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4833', '1748', '7', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4834', '1748', '7', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4835', '1749', '7', '5.80', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4836', '1749', '7', '5.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4837', '1750', '7', '6.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4838', '1750', '7', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4839', '1731', '3', '4.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4840', '1732', '3', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4841', '1734', '3', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4842', '1736', '3', '4.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4843', '1737', '3', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4844', '1738', '3', '6.70', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4845', '1739', '3', '4.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4846', '1740', '3', '6.40', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4847', '1741', '3', '6.90', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4848', '1742', '3', '6.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4849', '1745', '3', '4.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4850', '1746', '3', '4.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4851', '1747', '3', '4.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4852', '1748', '3', '6.80', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4853', '1749', '3', '4.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4854', '1750', '3', '5.80', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4855', '1429', '3', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4856', '1430', '3', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4857', '1431', '3', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4858', '1432', '3', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4859', '1433', '3', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4860', '1434', '3', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4861', '1435', '3', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4862', '1436', '3', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4863', '1454', '3', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4864', '1437', '3', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4865', '1438', '3', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4866', '1439', '3', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4867', '1440', '3', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4868', '1441', '3', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4869', '1442', '3', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4870', '1443', '3', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4871', '1444', '3', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4872', '1445', '3', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4873', '1446', '3', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4874', '1447', '3', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4875', '1448', '3', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4876', '1449', '3', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4877', '1825', '3', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4878', '1450', '3', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4879', '1451', '3', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4880', '1453', '3', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4881', '1455', '3', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4882', '1456', '3', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4883', '1457', '3', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4884', '1843', '3', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4885', '1458', '3', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4886', '1459', '3', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4887', '1842', '3', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4888', '1460', '3', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4889', '1461', '3', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4890', '1462', '3', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4891', '1463', '3', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4892', '1464', '3', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4893', '1988', '3', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4894', '1467', '3', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4915', '1448', '1', '3.30', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4916', '1448', '1', '4.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4917', '1448', '1', '6.40', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4918', '1449', '1', '5.80', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4919', '1449', '1', '3.40', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4920', '1825', '1', '6.60', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4921', '1825', '1', '4.70', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4922', '1825', '1', '7.00', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4923', '1450', '1', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4924', '1450', '1', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4925', '1450', '1', '7.00', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4926', '1451', '1', '6.60', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4927', '1451', '1', '5.50', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4928', '1451', '1', '7.00', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4929', '1453', '1', '6.20', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4930', '1453', '1', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4931', '1453', '1', '7.00', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4932', '1455', '1', '6.40', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4933', '1455', '1', '6.60', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4934', '1455', '1', '6.40', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4935', '1456', '1', '6.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4936', '1456', '1', '6.80', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4937', '1456', '1', '7.00', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4938', '1457', '1', '4.40', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4939', '1457', '1', '3.60', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4940', '1457', '1', '7.00', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4941', '1843', '1', '4.00', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4942', '1458', '1', '5.80', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4943', '1458', '1', '3.50', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4944', '1458', '1', '7.00', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4945', '1459', '1', '6.60', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4946', '1459', '1', '4.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4947', '1459', '1', '7.00', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4948', '1842', '1', '4.50', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4949', '1460', '1', '4.80', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4950', '1460', '1', '3.10', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4951', '1460', '1', '5.80', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4952', '1461', '1', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4953', '1461', '1', '4.30', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4954', '1461', '1', '7.00', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4955', '1462', '1', '3.50', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4956', '1462', '1', '2.30', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4957', '1462', '1', '5.40', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4958', '1463', '1', '3.60', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4959', '1463', '1', '3.10', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4960', '1463', '1', '7.00', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4961', '1464', '1', '6.80', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4962', '1464', '1', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4963', '1464', '1', '7.00', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4964', '1988', '1', '6.80', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4965', '1988', '1', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4966', '1988', '1', '7.00', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4967', '1467', '1', '6.60', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4968', '1467', '1', '5.10', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('4969', '1467', '1', '6.40', '2025-05-26', '1', '3');
INSERT INTO `notas` VALUES('4970', '1731', '2', '6.30', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4971', '1731', '2', '7.00', '2025-05-26', '1', '5');
INSERT INTO `notas` VALUES('4972', '1732', '2', '4.00', '2025-05-26', '1', '5');
INSERT INTO `notas` VALUES('4973', '1733', '2', '6.30', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4974', '1733', '2', '6.40', '2025-05-26', '1', '4');
INSERT INTO `notas` VALUES('4975', '1734', '2', '5.50', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4976', '1734', '2', '6.40', '2025-05-26', '1', '4');
INSERT INTO `notas` VALUES('4977', '1734', '2', '6.00', '2025-05-26', '1', '5');
INSERT INTO `notas` VALUES('4978', '1735', '2', '6.30', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4979', '1735', '2', '6.10', '2025-05-26', '1', '4');
INSERT INTO `notas` VALUES('4980', '1735', '2', '5.00', '2025-05-26', '1', '5');
INSERT INTO `notas` VALUES('4981', '1736', '2', '6.30', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4982', '1736', '2', '4.00', '2025-05-26', '1', '4');
INSERT INTO `notas` VALUES('4983', '1736', '2', '5.00', '2025-05-26', '1', '5');
INSERT INTO `notas` VALUES('4984', '1737', '2', '5.50', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4985', '1737', '2', '6.10', '2025-05-26', '1', '4');
INSERT INTO `notas` VALUES('4986', '1737', '2', '6.00', '2025-05-26', '1', '5');
INSERT INTO `notas` VALUES('4987', '1738', '2', '6.30', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4988', '1738', '2', '5.00', '2025-05-26', '1', '5');
INSERT INTO `notas` VALUES('4989', '1739', '2', '6.30', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4990', '1739', '2', '4.50', '2025-05-26', '1', '4');
INSERT INTO `notas` VALUES('4991', '1739', '2', '7.00', '2025-05-26', '1', '5');
INSERT INTO `notas` VALUES('4992', '1740', '2', '6.30', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4993', '1741', '2', '6.30', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4994', '1741', '2', '6.00', '2025-05-26', '1', '5');
INSERT INTO `notas` VALUES('4995', '1743', '2', '6.30', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4996', '1743', '2', '6.10', '2025-05-26', '1', '4');
INSERT INTO `notas` VALUES('4997', '1743', '2', '5.00', '2025-05-26', '1', '5');
INSERT INTO `notas` VALUES('4998', '1744', '2', '6.30', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('4999', '1744', '2', '6.10', '2025-05-26', '1', '4');
INSERT INTO `notas` VALUES('5000', '1744', '2', '6.00', '2025-05-26', '1', '5');
INSERT INTO `notas` VALUES('5001', '1745', '2', '4.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('5002', '1745', '2', '5.60', '2025-05-26', '1', '4');
INSERT INTO `notas` VALUES('5003', '1746', '2', '4.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('5004', '1747', '2', '6.30', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('5005', '1747', '2', '7.00', '2025-05-26', '1', '4');
INSERT INTO `notas` VALUES('5006', '1747', '2', '5.00', '2025-05-26', '1', '5');
INSERT INTO `notas` VALUES('5007', '1748', '2', '6.30', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('5008', '1748', '2', '6.50', '2025-05-26', '1', '4');
INSERT INTO `notas` VALUES('5009', '1748', '2', '5.00', '2025-05-26', '1', '5');
INSERT INTO `notas` VALUES('5010', '1749', '2', '4.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('5011', '1749', '2', '5.90', '2025-05-26', '1', '4');
INSERT INTO `notas` VALUES('5012', '1750', '2', '6.30', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('5013', '1750', '2', '5.60', '2025-05-26', '1', '4');
INSERT INTO `notas` VALUES('5014', '1750', '2', '6.00', '2025-05-26', '1', '5');
INSERT INTO `notas` VALUES('5015', '1448', '2', '6.80', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('5016', '1448', '2', '6.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('5017', '1449', '2', '6.30', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('5018', '1449', '2', '5.50', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('5019', '1825', '2', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('5020', '1825', '2', '6.20', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('5021', '1450', '2', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('5022', '1450', '2', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('5023', '1451', '2', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('5024', '1451', '2', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('5025', '1453', '2', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('5026', '1453', '2', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('5027', '1455', '2', '6.50', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('5028', '1455', '2', '6.40', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('5029', '1456', '2', '6.80', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('5030', '1456', '2', '6.20', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('5031', '1457', '2', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('5032', '1457', '2', '6.40', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('5033', '1843', '2', '6.80', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('5034', '1458', '2', '6.80', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('5035', '1458', '2', '6.60', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('5036', '1459', '2', '6.80', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('5037', '1459', '2', '6.60', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('5038', '1842', '2', '3.20', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('5039', '1460', '2', '6.50', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('5040', '1460', '2', '6.40', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('5041', '1461', '2', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('5042', '1461', '2', '6.20', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('5043', '1462', '2', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('5044', '1462', '2', '5.70', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('5045', '1463', '2', '6.30', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('5046', '1463', '2', '6.80', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('5047', '1464', '2', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('5048', '1464', '2', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('5049', '1988', '2', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('5050', '1988', '2', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('5051', '1467', '2', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('5052', '1467', '2', '6.80', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('5053', '1448', '6', '4.80', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('5054', '1448', '6', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('5055', '1449', '6', '3.20', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('5056', '1449', '6', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('5057', '1825', '6', '6.50', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('5058', '1825', '6', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('5059', '1450', '6', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('5060', '1450', '6', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('5061', '1451', '6', '6.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('5062', '1451', '6', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('5063', '1453', '6', '6.80', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('5064', '1453', '6', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('5065', '1455', '6', '6.30', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('5066', '1455', '6', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('5067', '1456', '6', '6.30', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('5068', '1456', '6', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('5069', '1457', '6', '5.80', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('5070', '1457', '6', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('5071', '1843', '6', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('5072', '1843', '6', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('5073', '1458', '6', '6.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('5074', '1458', '6', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('5075', '1459', '6', '5.80', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('5076', '1459', '6', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('5077', '1842', '6', '4.50', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('5078', '1842', '6', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('5079', '1460', '6', '4.30', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('5080', '1460', '6', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('5081', '1461', '6', '6.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('5082', '1461', '6', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('5083', '1462', '6', '5.30', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('5084', '1462', '6', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('5085', '1463', '6', '4.30', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('5086', '1463', '6', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('5087', '1464', '6', '6.50', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('5088', '1464', '6', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('5089', '1988', '6', '6.80', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('5090', '1988', '6', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('5091', '1467', '6', '6.50', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('5092', '1467', '6', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('5093', '1857', '7', '6.60', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('5094', '1863', '7', '4.40', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('5095', '1866', '7', '6.10', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('5096', '1448', '4', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('5097', '1448', '4', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('5098', '1449', '4', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('5099', '1449', '4', '6.50', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('5100', '1825', '4', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('5101', '1825', '4', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('5102', '1450', '4', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('5103', '1450', '4', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('5104', '1451', '4', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('5105', '1451', '4', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('5106', '1453', '4', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('5107', '1453', '4', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('5108', '1455', '4', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('5109', '1455', '4', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('5110', '1456', '4', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('5111', '1456', '4', '6.70', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('5112', '1457', '4', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('5113', '1457', '4', '6.70', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('5114', '1843', '4', '6.70', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('5115', '1458', '4', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('5116', '1458', '4', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('5117', '1459', '4', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('5118', '1459', '4', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('5119', '1842', '4', '6.50', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('5120', '1460', '4', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('5121', '1460', '4', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('5122', '1461', '4', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('5123', '1461', '4', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('5124', '1462', '4', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('5125', '1462', '4', '6.70', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('5126', '1463', '4', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('5127', '1463', '4', '6.70', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('5128', '1464', '4', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('5129', '1464', '4', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('5130', '1988', '4', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('5131', '1988', '4', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('5132', '1467', '4', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('5133', '1467', '4', '7.00', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('5134', '1448', '12', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('5135', '1449', '12', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('5136', '1825', '12', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('5137', '1450', '12', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('5138', '1451', '12', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('5139', '1453', '12', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('5140', '1455', '12', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('5141', '1456', '12', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('5142', '1457', '12', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('5143', '1843', '12', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('5144', '1458', '12', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('5145', '1459', '12', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('5146', '1842', '12', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('5147', '1460', '12', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('5148', '1461', '12', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('5149', '1462', '12', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('5150', '1463', '12', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('5151', '1464', '12', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('5152', '1988', '12', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('5153', '1467', '12', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('5154', '1448', '7', '3.80', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('5155', '1449', '7', '5.10', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('5156', '1450', '7', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('5157', '1451', '7', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('5158', '1453', '7', '5.50', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('5159', '1456', '7', '5.50', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('5160', '1457', '7', '5.10', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('5161', '1843', '7', '5.10', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('5162', '1458', '7', '5.90', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('5163', '1459', '7', '5.50', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('5164', '1842', '7', '3.80', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('5165', '1460', '7', '4.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('5166', '1461', '7', '6.30', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('5167', '1462', '7', '5.10', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('5168', '1464', '7', '7.00', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('5169', '1988', '7', '6.30', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('5170', '1467', '7', '6.30', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('5171', '1864', '2', '3.50', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('5172', '1864', '2', '4.20', '2025-05-26', '1', '2');
INSERT INTO `notas` VALUES('5173', '1864', '1', '4.50', '2025-05-26', '1', '1');
INSERT INTO `notas` VALUES('5174', '1922', '8', '6.80', '2025-05-27', '1', '3');
INSERT INTO `notas` VALUES('5175', '1923', '8', '5.00', '2025-05-27', '1', '3');
INSERT INTO `notas` VALUES('5176', '1924', '8', '5.00', '2025-05-27', '1', '3');
INSERT INTO `notas` VALUES('5177', '1925', '8', '5.20', '2025-05-27', '1', '3');
INSERT INTO `notas` VALUES('5178', '1926', '8', '5.70', '2025-05-27', '1', '3');
INSERT INTO `notas` VALUES('5179', '1927', '8', '6.80', '2025-05-27', '1', '3');
INSERT INTO `notas` VALUES('5180', '1928', '8', '4.70', '2025-05-27', '1', '3');
INSERT INTO `notas` VALUES('5181', '1929', '8', '5.10', '2025-05-27', '1', '3');
INSERT INTO `notas` VALUES('5182', '1930', '8', '4.40', '2025-05-27', '1', '3');
INSERT INTO `notas` VALUES('5183', '1931', '8', '4.40', '2025-05-27', '1', '3');
INSERT INTO `notas` VALUES('5184', '1932', '8', '5.20', '2025-05-27', '1', '3');
INSERT INTO `notas` VALUES('5185', '1933', '8', '5.20', '2025-05-27', '1', '3');
INSERT INTO `notas` VALUES('5186', '1947', '8', '6.80', '2025-05-27', '1', '3');
INSERT INTO `notas` VALUES('5187', '1934', '8', '5.10', '2025-05-27', '1', '3');
INSERT INTO `notas` VALUES('5188', '1935', '8', '6.80', '2025-05-27', '1', '3');
INSERT INTO `notas` VALUES('5189', '1936', '8', '5.20', '2025-05-27', '1', '3');
INSERT INTO `notas` VALUES('5190', '1937', '8', '5.10', '2025-05-27', '1', '3');
INSERT INTO `notas` VALUES('5191', '1938', '8', '5.70', '2025-05-27', '1', '3');
INSERT INTO `notas` VALUES('5192', '1939', '8', '5.00', '2025-05-27', '1', '3');
INSERT INTO `notas` VALUES('5193', '1940', '8', '4.60', '2025-05-27', '1', '3');
INSERT INTO `notas` VALUES('5194', '1941', '8', '5.20', '2025-05-27', '1', '3');
INSERT INTO `notas` VALUES('5195', '1942', '8', '5.70', '2025-05-27', '1', '3');
INSERT INTO `notas` VALUES('5196', '1943', '8', '5.10', '2025-05-27', '1', '3');
INSERT INTO `notas` VALUES('5197', '1944', '8', '4.40', '2025-05-27', '1', '3');
INSERT INTO `notas` VALUES('5198', '1945', '8', '6.80', '2025-05-27', '1', '3');
INSERT INTO `notas` VALUES('5199', '1946', '8', '5.70', '2025-05-27', '1', '3');
INSERT INTO `notas` VALUES('5200', '1740', '2', '7.00', '2025-05-27', '1', '5');
INSERT INTO `notas` VALUES('5201', '1746', '2', '5.00', '2025-05-27', '1', '5');
INSERT INTO `notas` VALUES('5202', '1692', '2', '5.80', '2025-05-27', '1', '3');
INSERT INTO `notas` VALUES('5203', '1693', '2', '7.00', '2025-05-27', '1', '3');
INSERT INTO `notas` VALUES('5204', '1694', '2', '4.70', '2025-05-27', '1', '3');
INSERT INTO `notas` VALUES('5205', '1695', '2', '7.00', '2025-05-27', '1', '3');
INSERT INTO `notas` VALUES('5206', '1696', '2', '7.00', '2025-05-27', '1', '3');
INSERT INTO `notas` VALUES('5207', '1697', '2', '3.20', '2025-05-27', '1', '3');
INSERT INTO `notas` VALUES('5208', '1699', '2', '4.90', '2025-05-27', '1', '3');
INSERT INTO `notas` VALUES('5209', '1700', '2', '7.00', '2025-05-27', '1', '3');
INSERT INTO `notas` VALUES('5210', '1701', '2', '4.40', '2025-05-27', '1', '3');
INSERT INTO `notas` VALUES('5211', '1702', '2', '6.40', '2025-05-27', '1', '3');
INSERT INTO `notas` VALUES('5212', '1703', '2', '7.00', '2025-05-27', '1', '3');
INSERT INTO `notas` VALUES('5213', '1704', '2', '7.00', '2025-05-27', '1', '3');
INSERT INTO `notas` VALUES('5214', '1705', '2', '4.20', '2025-05-27', '1', '3');
INSERT INTO `notas` VALUES('5215', '1706', '2', '3.50', '2025-05-27', '1', '3');
INSERT INTO `notas` VALUES('5216', '1707', '2', '6.10', '2025-05-27', '1', '3');
INSERT INTO `notas` VALUES('5217', '1708', '2', '5.40', '2025-05-27', '1', '3');
INSERT INTO `notas` VALUES('5218', '1709', '2', '4.90', '2025-05-27', '1', '3');
INSERT INTO `notas` VALUES('5219', '1710', '2', '4.40', '2025-05-27', '1', '3');
INSERT INTO `notas` VALUES('5220', '1711', '2', '5.90', '2025-05-27', '1', '3');
INSERT INTO `notas` VALUES('5221', '1712', '2', '6.30', '2025-05-27', '1', '3');
INSERT INTO `notas` VALUES('5222', '1693', '6', '7.00', '2025-05-27', '1', '2');
INSERT INTO `notas` VALUES('5223', '1700', '6', '7.00', '2025-05-27', '1', '2');
INSERT INTO `notas` VALUES('5224', '1707', '6', '7.00', '2025-05-27', '1', '2');
INSERT INTO `notas` VALUES('5225', '1711', '6', '6.00', '2025-05-27', '1', '2');
INSERT INTO `notas` VALUES('5226', '1731', '2', '6.20', '2025-05-28', '1', '4');
INSERT INTO `notas` VALUES('5227', '1732', '2', '7.00', '2025-05-28', '1', '4');
INSERT INTO `notas` VALUES('5228', '1738', '2', '5.40', '2025-05-28', '1', '4');
INSERT INTO `notas` VALUES('5229', '1740', '2', '6.20', '2025-05-28', '1', '4');
INSERT INTO `notas` VALUES('5230', '1741', '2', '6.40', '2025-05-28', '1', '4');
INSERT INTO `notas` VALUES('5231', '1746', '2', '6.20', '2025-05-28', '1', '4');
INSERT INTO `notas` VALUES('5232', '1696', '6', '7.00', '2025-05-28', '1', '2');
INSERT INTO `notas` VALUES('5233', '1898', '1', '6.60', '2025-06-03', '1', '3');
INSERT INTO `notas` VALUES('5234', '1898', '1', '7.00', '2025-06-03', '1', '5');
INSERT INTO `notas` VALUES('5235', '1898', '1', '7.00', '2025-06-03', '1', '6');
INSERT INTO `notas` VALUES('5236', '1899', '1', '7.00', '2025-06-03', '1', '3');
INSERT INTO `notas` VALUES('5237', '1899', '1', '5.80', '2025-06-03', '1', '5');
INSERT INTO `notas` VALUES('5238', '1899', '1', '6.90', '2025-06-03', '1', '6');
INSERT INTO `notas` VALUES('5239', '1900', '1', '4.80', '2025-06-03', '1', '3');
INSERT INTO `notas` VALUES('5240', '1900', '1', '5.50', '2025-06-03', '1', '5');
INSERT INTO `notas` VALUES('5241', '1900', '1', '6.60', '2025-06-03', '1', '6');
INSERT INTO `notas` VALUES('5242', '1901', '1', '3.10', '2025-06-03', '1', '3');
INSERT INTO `notas` VALUES('5243', '1901', '1', '5.00', '2025-06-03', '1', '5');
INSERT INTO `notas` VALUES('5244', '1901', '1', '4.70', '2025-06-03', '1', '6');
INSERT INTO `notas` VALUES('5245', '1902', '1', '6.50', '2025-06-03', '1', '3');
INSERT INTO `notas` VALUES('5246', '1902', '1', '7.00', '2025-06-03', '1', '5');
INSERT INTO `notas` VALUES('5247', '1902', '1', '6.90', '2025-06-03', '1', '6');
INSERT INTO `notas` VALUES('5248', '1920', '1', '4.00', '2025-06-03', '1', '3');
INSERT INTO `notas` VALUES('5249', '1920', '1', '7.00', '2025-06-03', '1', '5');
INSERT INTO `notas` VALUES('5250', '1920', '1', '5.70', '2025-06-03', '1', '6');
INSERT INTO `notas` VALUES('5251', '1919', '1', '3.50', '2025-06-03', '1', '3');
INSERT INTO `notas` VALUES('5252', '1919', '1', '5.00', '2025-06-03', '1', '5');
INSERT INTO `notas` VALUES('5253', '1919', '1', '5.40', '2025-06-03', '1', '6');
INSERT INTO `notas` VALUES('5254', '1903', '1', '7.00', '2025-06-03', '1', '3');
INSERT INTO `notas` VALUES('5255', '1903', '1', '7.00', '2025-06-03', '1', '5');
INSERT INTO `notas` VALUES('5256', '1903', '1', '6.90', '2025-06-03', '1', '6');
INSERT INTO `notas` VALUES('5257', '1904', '1', '3.40', '2025-06-03', '1', '3');
INSERT INTO `notas` VALUES('5258', '1904', '1', '4.70', '2025-06-03', '1', '5');
INSERT INTO `notas` VALUES('5259', '1904', '1', '5.80', '2025-06-03', '1', '6');
INSERT INTO `notas` VALUES('5260', '1905', '1', '4.40', '2025-06-03', '1', '3');
INSERT INTO `notas` VALUES('5261', '1905', '1', '4.00', '2025-06-03', '1', '5');
INSERT INTO `notas` VALUES('5262', '1905', '1', '6.30', '2025-06-03', '1', '6');
INSERT INTO `notas` VALUES('5263', '1906', '1', '5.50', '2025-06-03', '1', '3');
INSERT INTO `notas` VALUES('5264', '1906', '1', '4.00', '2025-06-03', '1', '5');
INSERT INTO `notas` VALUES('5265', '1906', '1', '4.80', '2025-06-03', '1', '6');
INSERT INTO `notas` VALUES('5266', '1907', '1', '5.40', '2025-06-03', '1', '3');
INSERT INTO `notas` VALUES('5267', '1907', '1', '6.80', '2025-06-03', '1', '5');
INSERT INTO `notas` VALUES('5268', '1907', '1', '6.90', '2025-06-03', '1', '6');
INSERT INTO `notas` VALUES('5269', '1908', '1', '6.60', '2025-06-03', '1', '3');
INSERT INTO `notas` VALUES('5270', '1908', '1', '7.00', '2025-06-03', '1', '5');
INSERT INTO `notas` VALUES('5271', '1908', '1', '6.90', '2025-06-03', '1', '6');
INSERT INTO `notas` VALUES('5272', '1909', '1', '4.00', '2025-06-03', '1', '3');
INSERT INTO `notas` VALUES('5273', '1909', '1', '7.00', '2025-06-03', '1', '5');
INSERT INTO `notas` VALUES('5274', '1909', '1', '6.90', '2025-06-03', '1', '6');
INSERT INTO `notas` VALUES('5275', '1910', '1', '3.40', '2025-06-03', '1', '3');
INSERT INTO `notas` VALUES('5276', '1910', '1', '4.30', '2025-06-03', '1', '5');
INSERT INTO `notas` VALUES('5277', '1910', '1', '5.80', '2025-06-03', '1', '6');
INSERT INTO `notas` VALUES('5278', '1911', '1', '3.50', '2025-06-03', '1', '3');
INSERT INTO `notas` VALUES('5279', '1911', '1', '6.30', '2025-06-03', '1', '5');
INSERT INTO `notas` VALUES('5280', '1911', '1', '5.00', '2025-06-03', '1', '6');
INSERT INTO `notas` VALUES('5281', '1912', '1', '4.80', '2025-06-03', '1', '3');
INSERT INTO `notas` VALUES('5282', '1912', '1', '6.80', '2025-06-03', '1', '5');
INSERT INTO `notas` VALUES('5283', '1912', '1', '6.30', '2025-06-03', '1', '6');
INSERT INTO `notas` VALUES('5284', '1913', '1', '4.20', '2025-06-03', '1', '3');
INSERT INTO `notas` VALUES('5285', '1913', '1', '5.70', '2025-06-03', '1', '5');
INSERT INTO `notas` VALUES('5286', '1913', '1', '6.60', '2025-06-03', '1', '6');
INSERT INTO `notas` VALUES('5287', '1914', '1', '6.50', '2025-06-03', '1', '3');
INSERT INTO `notas` VALUES('5288', '1914', '1', '5.70', '2025-06-03', '1', '5');
INSERT INTO `notas` VALUES('5289', '1914', '1', '6.10', '2025-06-03', '1', '6');
INSERT INTO `notas` VALUES('5290', '1915', '1', '4.30', '2025-06-03', '1', '3');
INSERT INTO `notas` VALUES('5291', '1915', '1', '6.00', '2025-06-03', '1', '5');
INSERT INTO `notas` VALUES('5292', '1915', '1', '6.90', '2025-06-03', '1', '6');
INSERT INTO `notas` VALUES('5293', '1916', '1', '6.60', '2025-06-03', '1', '3');
INSERT INTO `notas` VALUES('5294', '1916', '1', '5.80', '2025-06-03', '1', '5');
INSERT INTO `notas` VALUES('5295', '1916', '1', '6.20', '2025-06-03', '1', '6');
INSERT INTO `notas` VALUES('5296', '1917', '1', '5.00', '2025-06-03', '1', '3');
INSERT INTO `notas` VALUES('5297', '1917', '1', '6.30', '2025-06-03', '1', '5');
INSERT INTO `notas` VALUES('5298', '1917', '1', '6.40', '2025-06-03', '1', '6');
INSERT INTO `notas` VALUES('5299', '1921', '1', '7.00', '2025-06-03', '1', '3');
INSERT INTO `notas` VALUES('5300', '1921', '1', '7.00', '2025-06-03', '1', '5');
INSERT INTO `notas` VALUES('5301', '1921', '1', '7.00', '2025-06-03', '1', '6');
INSERT INTO `notas` VALUES('5302', '1918', '1', '5.90', '2025-06-03', '1', '3');
INSERT INTO `notas` VALUES('5303', '1918', '1', '7.00', '2025-06-03', '1', '5');
INSERT INTO `notas` VALUES('5304', '1918', '1', '6.00', '2025-06-03', '1', '6');
INSERT INTO `notas` VALUES('5428', '1898', '2', '6.80', '2025-06-03', '1', '4');
INSERT INTO `notas` VALUES('5429', '1898', '2', '7.00', '2025-06-03', '1', '6');
INSERT INTO `notas` VALUES('5430', '1899', '2', '7.00', '2025-06-03', '1', '4');
INSERT INTO `notas` VALUES('5431', '1899', '2', '6.90', '2025-06-03', '1', '6');
INSERT INTO `notas` VALUES('5432', '1900', '2', '6.80', '2025-06-03', '1', '4');
INSERT INTO `notas` VALUES('5433', '1900', '2', '6.60', '2025-06-03', '1', '6');
INSERT INTO `notas` VALUES('5434', '1901', '2', '4.20', '2025-06-03', '1', '2');
INSERT INTO `notas` VALUES('5435', '1901', '2', '4.30', '2025-06-03', '1', '4');
INSERT INTO `notas` VALUES('5436', '1901', '2', '4.70', '2025-06-03', '1', '6');
INSERT INTO `notas` VALUES('5437', '1902', '2', '6.80', '2025-06-03', '1', '4');
INSERT INTO `notas` VALUES('5438', '1902', '2', '6.90', '2025-06-03', '1', '6');
INSERT INTO `notas` VALUES('5439', '1920', '2', '7.00', '2025-06-03', '1', '4');
INSERT INTO `notas` VALUES('5440', '1920', '2', '5.70', '2025-06-03', '1', '6');
INSERT INTO `notas` VALUES('5441', '1919', '2', '4.00', '2025-06-03', '1', '3');
INSERT INTO `notas` VALUES('5442', '1919', '2', '4.50', '2025-06-03', '1', '4');
INSERT INTO `notas` VALUES('5443', '1919', '2', '5.40', '2025-06-03', '1', '6');
INSERT INTO `notas` VALUES('5444', '1903', '2', '7.00', '2025-06-03', '1', '4');
INSERT INTO `notas` VALUES('5445', '1903', '2', '6.90', '2025-06-03', '1', '6');
INSERT INTO `notas` VALUES('5446', '1904', '2', '6.10', '2025-06-03', '1', '4');
INSERT INTO `notas` VALUES('5447', '1904', '2', '5.80', '2025-06-03', '1', '6');
INSERT INTO `notas` VALUES('5448', '1905', '2', '5.20', '2025-06-03', '1', '4');
INSERT INTO `notas` VALUES('5449', '1905', '2', '6.30', '2025-06-03', '1', '6');
INSERT INTO `notas` VALUES('5450', '1906', '2', '4.00', '2025-06-03', '1', '4');
INSERT INTO `notas` VALUES('5451', '1906', '2', '4.80', '2025-06-03', '1', '6');
INSERT INTO `notas` VALUES('5452', '1907', '2', '6.80', '2025-06-03', '1', '4');
INSERT INTO `notas` VALUES('5453', '1907', '2', '6.90', '2025-06-03', '1', '6');
INSERT INTO `notas` VALUES('5454', '1908', '2', '6.30', '2025-06-03', '1', '3');
INSERT INTO `notas` VALUES('5455', '1908', '2', '7.00', '2025-06-03', '1', '4');
INSERT INTO `notas` VALUES('5456', '1908', '2', '6.90', '2025-06-03', '1', '6');
INSERT INTO `notas` VALUES('5457', '1909', '2', '7.00', '2025-06-03', '1', '4');
INSERT INTO `notas` VALUES('5458', '1909', '2', '6.90', '2025-06-03', '1', '6');
INSERT INTO `notas` VALUES('5459', '1910', '2', '4.00', '2025-06-03', '1', '2');
INSERT INTO `notas` VALUES('5460', '1910', '2', '5.50', '2025-06-03', '1', '4');
INSERT INTO `notas` VALUES('5461', '1910', '2', '5.80', '2025-06-03', '1', '6');
INSERT INTO `notas` VALUES('5462', '1911', '2', '3.30', '2025-06-03', '1', '2');
INSERT INTO `notas` VALUES('5463', '1911', '2', '5.00', '2025-06-03', '1', '3');
INSERT INTO `notas` VALUES('5464', '1911', '2', '4.20', '2025-06-03', '1', '4');
INSERT INTO `notas` VALUES('5465', '1911', '2', '5.00', '2025-06-03', '1', '6');
INSERT INTO `notas` VALUES('5466', '1912', '2', '6.10', '2025-06-03', '1', '4');
INSERT INTO `notas` VALUES('5467', '1912', '2', '6.30', '2025-06-03', '1', '6');
INSERT INTO `notas` VALUES('5468', '1913', '2', '6.50', '2025-06-03', '1', '4');
INSERT INTO `notas` VALUES('5469', '1913', '2', '6.60', '2025-06-03', '1', '6');
INSERT INTO `notas` VALUES('5470', '1914', '2', '6.20', '2025-06-03', '1', '4');
INSERT INTO `notas` VALUES('5471', '1914', '2', '6.10', '2025-06-03', '1', '6');
INSERT INTO `notas` VALUES('5472', '1915', '2', '7.00', '2025-06-03', '1', '4');
INSERT INTO `notas` VALUES('5473', '1915', '2', '6.90', '2025-06-03', '1', '6');
INSERT INTO `notas` VALUES('5474', '1916', '2', '7.00', '2025-06-03', '1', '4');
INSERT INTO `notas` VALUES('5475', '1916', '2', '6.20', '2025-06-03', '1', '6');
INSERT INTO `notas` VALUES('5476', '1917', '2', '7.00', '2025-06-03', '1', '4');
INSERT INTO `notas` VALUES('5477', '1917', '2', '6.40', '2025-06-03', '1', '6');
INSERT INTO `notas` VALUES('5478', '1921', '2', '7.00', '2025-06-03', '1', '4');
INSERT INTO `notas` VALUES('5479', '1921', '2', '7.00', '2025-06-03', '1', '6');
INSERT INTO `notas` VALUES('5480', '1918', '2', '7.00', '2025-06-03', '1', '4');
INSERT INTO `notas` VALUES('5481', '1918', '2', '6.00', '2025-06-03', '1', '6');
INSERT INTO `notas` VALUES('5483', '1899', '6', '6.90', '2025-06-03', '1', '4');
INSERT INTO `notas` VALUES('5484', '1900', '6', '6.60', '2025-06-03', '1', '4');
INSERT INTO `notas` VALUES('5485', '1901', '6', '4.70', '2025-06-03', '1', '4');
INSERT INTO `notas` VALUES('5486', '1902', '6', '6.90', '2025-06-03', '1', '4');
INSERT INTO `notas` VALUES('5487', '1920', '6', '5.70', '2025-06-03', '1', '4');
INSERT INTO `notas` VALUES('5488', '1919', '6', '5.40', '2025-06-03', '1', '4');
INSERT INTO `notas` VALUES('5489', '1903', '6', '6.90', '2025-06-03', '1', '4');
INSERT INTO `notas` VALUES('5490', '1904', '6', '5.80', '2025-06-03', '1', '4');
INSERT INTO `notas` VALUES('5491', '1905', '6', '6.30', '2025-06-03', '1', '4');
INSERT INTO `notas` VALUES('5492', '1906', '6', '4.80', '2025-06-03', '1', '4');
INSERT INTO `notas` VALUES('5493', '1907', '6', '6.90', '2025-06-03', '1', '4');
INSERT INTO `notas` VALUES('5494', '1908', '6', '6.90', '2025-06-03', '1', '4');
INSERT INTO `notas` VALUES('5495', '1909', '6', '6.90', '2025-06-03', '1', '4');
INSERT INTO `notas` VALUES('5496', '1910', '6', '5.80', '2025-06-03', '1', '4');
INSERT INTO `notas` VALUES('5497', '1911', '6', '5.00', '2025-06-03', '1', '4');
INSERT INTO `notas` VALUES('5498', '1912', '6', '6.30', '2025-06-03', '1', '4');
INSERT INTO `notas` VALUES('5499', '1913', '6', '6.60', '2025-06-03', '1', '4');
INSERT INTO `notas` VALUES('5500', '1914', '6', '6.10', '2025-06-03', '1', '4');
INSERT INTO `notas` VALUES('5501', '1915', '6', '6.90', '2025-06-03', '1', '4');
INSERT INTO `notas` VALUES('5502', '1916', '6', '6.20', '2025-06-03', '1', '4');
INSERT INTO `notas` VALUES('5503', '1917', '6', '6.40', '2025-06-03', '1', '4');
INSERT INTO `notas` VALUES('5504', '1921', '6', '7.00', '2025-06-03', '1', '4');
INSERT INTO `notas` VALUES('5505', '1918', '6', '6.00', '2025-06-03', '1', '4');
INSERT INTO `notas` VALUES('5506', '1898', '6', '7.00', '2025-06-03', '1', '4');
INSERT INTO `notas` VALUES('5507', '1898', '12', '7.00', '2025-06-03', '1', '3');
INSERT INTO `notas` VALUES('5508', '1899', '12', '6.90', '2025-06-03', '1', '3');
INSERT INTO `notas` VALUES('5509', '1900', '12', '6.60', '2025-06-03', '1', '3');
INSERT INTO `notas` VALUES('5510', '1901', '12', '4.70', '2025-06-03', '1', '3');
INSERT INTO `notas` VALUES('5511', '1902', '12', '6.90', '2025-06-03', '1', '3');
INSERT INTO `notas` VALUES('5512', '1920', '12', '5.70', '2025-06-03', '1', '3');
INSERT INTO `notas` VALUES('5513', '1919', '12', '5.40', '2025-06-03', '1', '3');
INSERT INTO `notas` VALUES('5514', '1903', '12', '6.90', '2025-06-03', '1', '3');
INSERT INTO `notas` VALUES('5515', '1904', '12', '5.80', '2025-06-03', '1', '3');
INSERT INTO `notas` VALUES('5516', '1905', '12', '6.30', '2025-06-03', '1', '3');
INSERT INTO `notas` VALUES('5517', '1906', '12', '4.80', '2025-06-03', '1', '3');
INSERT INTO `notas` VALUES('5518', '1907', '12', '6.90', '2025-06-03', '1', '3');
INSERT INTO `notas` VALUES('5519', '1908', '12', '6.90', '2025-06-03', '1', '3');
INSERT INTO `notas` VALUES('5520', '1909', '12', '6.90', '2025-06-03', '1', '3');
INSERT INTO `notas` VALUES('5521', '1910', '12', '5.80', '2025-06-03', '1', '3');
INSERT INTO `notas` VALUES('5522', '1911', '12', '5.00', '2025-06-03', '1', '3');
INSERT INTO `notas` VALUES('5523', '1912', '12', '6.30', '2025-06-03', '1', '3');
INSERT INTO `notas` VALUES('5524', '1913', '12', '6.60', '2025-06-03', '1', '3');
INSERT INTO `notas` VALUES('5525', '1914', '12', '6.10', '2025-06-03', '1', '3');
INSERT INTO `notas` VALUES('5526', '1915', '12', '6.90', '2025-06-03', '1', '3');
INSERT INTO `notas` VALUES('5527', '1916', '12', '6.20', '2025-06-03', '1', '3');
INSERT INTO `notas` VALUES('5528', '1917', '12', '6.40', '2025-06-03', '1', '3');
INSERT INTO `notas` VALUES('5529', '1921', '12', '7.00', '2025-06-03', '1', '3');
INSERT INTO `notas` VALUES('5530', '1918', '12', '6.00', '2025-06-03', '1', '3');
INSERT INTO `notas` VALUES('5531', '1898', '4', '7.00', '2025-06-03', '1', '3');
INSERT INTO `notas` VALUES('5532', '1898', '4', '7.00', '2025-06-03', '1', '4');
INSERT INTO `notas` VALUES('5533', '1899', '4', '7.00', '2025-06-03', '1', '3');
INSERT INTO `notas` VALUES('5534', '1899', '4', '6.90', '2025-06-03', '1', '4');
INSERT INTO `notas` VALUES('5535', '1900', '4', '7.00', '2025-06-03', '1', '3');
INSERT INTO `notas` VALUES('5536', '1900', '4', '6.60', '2025-06-03', '1', '4');
INSERT INTO `notas` VALUES('5537', '1901', '4', '7.00', '2025-06-03', '1', '3');
INSERT INTO `notas` VALUES('5538', '1901', '4', '4.70', '2025-06-03', '1', '4');
INSERT INTO `notas` VALUES('5539', '1902', '4', '7.00', '2025-06-03', '1', '3');
INSERT INTO `notas` VALUES('5540', '1902', '4', '6.90', '2025-06-03', '1', '4');
INSERT INTO `notas` VALUES('5541', '1920', '4', '7.00', '2025-06-03', '1', '3');
INSERT INTO `notas` VALUES('5542', '1920', '4', '5.70', '2025-06-03', '1', '4');
INSERT INTO `notas` VALUES('5543', '1919', '4', '5.50', '2025-06-03', '1', '3');
INSERT INTO `notas` VALUES('5544', '1919', '4', '5.40', '2025-06-03', '1', '4');
INSERT INTO `notas` VALUES('5545', '1903', '4', '7.00', '2025-06-03', '1', '3');
INSERT INTO `notas` VALUES('5546', '1903', '4', '6.90', '2025-06-03', '1', '4');
INSERT INTO `notas` VALUES('5547', '1904', '4', '7.00', '2025-06-03', '1', '3');
INSERT INTO `notas` VALUES('5548', '1904', '4', '5.80', '2025-06-03', '1', '4');
INSERT INTO `notas` VALUES('5549', '1905', '4', '7.00', '2025-06-03', '1', '3');
INSERT INTO `notas` VALUES('5550', '1905', '4', '6.30', '2025-06-03', '1', '4');
INSERT INTO `notas` VALUES('5551', '1906', '4', '7.00', '2025-06-03', '1', '3');
INSERT INTO `notas` VALUES('5552', '1906', '4', '4.80', '2025-06-03', '1', '4');
INSERT INTO `notas` VALUES('5553', '1907', '4', '7.00', '2025-06-03', '1', '3');
INSERT INTO `notas` VALUES('5554', '1907', '4', '6.90', '2025-06-03', '1', '4');
INSERT INTO `notas` VALUES('5555', '1908', '4', '7.00', '2025-06-03', '1', '3');
INSERT INTO `notas` VALUES('5556', '1908', '4', '6.90', '2025-06-03', '1', '4');
INSERT INTO `notas` VALUES('5557', '1909', '4', '7.00', '2025-06-03', '1', '3');
INSERT INTO `notas` VALUES('5558', '1909', '4', '6.90', '2025-06-03', '1', '4');
INSERT INTO `notas` VALUES('5559', '1910', '4', '6.70', '2025-06-03', '1', '3');
INSERT INTO `notas` VALUES('5560', '1910', '4', '5.80', '2025-06-03', '1', '4');
INSERT INTO `notas` VALUES('5561', '1911', '4', '6.50', '2025-06-03', '1', '3');
INSERT INTO `notas` VALUES('5562', '1911', '4', '5.00', '2025-06-03', '1', '4');
INSERT INTO `notas` VALUES('5563', '1912', '4', '7.00', '2025-06-03', '1', '3');
INSERT INTO `notas` VALUES('5564', '1912', '4', '6.30', '2025-06-03', '1', '4');
INSERT INTO `notas` VALUES('5565', '1913', '4', '7.00', '2025-06-03', '1', '3');
INSERT INTO `notas` VALUES('5566', '1913', '4', '6.60', '2025-06-03', '1', '4');
INSERT INTO `notas` VALUES('5567', '1914', '4', '7.00', '2025-06-03', '1', '3');
INSERT INTO `notas` VALUES('5568', '1914', '4', '6.10', '2025-06-03', '1', '4');
INSERT INTO `notas` VALUES('5569', '1915', '4', '7.00', '2025-06-03', '1', '3');
INSERT INTO `notas` VALUES('5570', '1915', '4', '6.90', '2025-06-03', '1', '4');
INSERT INTO `notas` VALUES('5571', '1916', '4', '6.80', '2025-06-03', '1', '3');
INSERT INTO `notas` VALUES('5572', '1916', '4', '6.20', '2025-06-03', '1', '4');
INSERT INTO `notas` VALUES('5573', '1917', '4', '7.00', '2025-06-03', '1', '3');
INSERT INTO `notas` VALUES('5574', '1917', '4', '6.40', '2025-06-03', '1', '4');
INSERT INTO `notas` VALUES('5575', '1921', '4', '7.00', '2025-06-03', '1', '3');
INSERT INTO `notas` VALUES('5576', '1921', '4', '7.00', '2025-06-03', '1', '4');
INSERT INTO `notas` VALUES('5577', '1918', '4', '6.80', '2025-06-03', '1', '3');
INSERT INTO `notas` VALUES('5578', '1918', '4', '6.00', '2025-06-03', '1', '4');
INSERT INTO `notas` VALUES('5579', '1731', '11', '6.30', '2025-06-06', '1', '4');
INSERT INTO `notas` VALUES('5580', '1731', '11', '4.90', '2025-06-06', '1', '5');
INSERT INTO `notas` VALUES('5581', '1731', '11', '6.20', '2025-06-06', '1', '6');
INSERT INTO `notas` VALUES('5582', '1732', '11', '7.00', '2025-06-06', '1', '4');
INSERT INTO `notas` VALUES('5583', '1732', '11', '7.00', '2025-06-06', '1', '5');
INSERT INTO `notas` VALUES('5584', '1732', '11', '7.00', '2025-06-06', '1', '6');
INSERT INTO `notas` VALUES('5585', '1733', '11', '6.60', '2025-06-06', '1', '4');
INSERT INTO `notas` VALUES('5586', '1733', '11', '3.80', '2025-06-06', '1', '5');
INSERT INTO `notas` VALUES('5587', '1733', '11', '5.00', '2025-06-06', '1', '6');
INSERT INTO `notas` VALUES('5588', '1734', '11', '7.00', '2025-06-06', '1', '4');
INSERT INTO `notas` VALUES('5589', '1734', '11', '4.70', '2025-06-06', '1', '5');
INSERT INTO `notas` VALUES('5590', '1734', '11', '6.30', '2025-06-06', '1', '6');
INSERT INTO `notas` VALUES('5591', '1735', '11', '6.60', '2025-06-06', '1', '4');
INSERT INTO `notas` VALUES('5592', '1735', '11', '4.00', '2025-06-06', '1', '5');
INSERT INTO `notas` VALUES('5593', '1736', '11', '6.20', '2025-06-06', '1', '4');
INSERT INTO `notas` VALUES('5594', '1736', '11', '4.10', '2025-06-06', '1', '5');
INSERT INTO `notas` VALUES('5595', '1736', '11', '5.90', '2025-06-06', '1', '6');
INSERT INTO `notas` VALUES('5596', '1737', '11', '5.50', '2025-06-06', '1', '4');
INSERT INTO `notas` VALUES('5597', '1737', '11', '4.80', '2025-06-06', '1', '5');
INSERT INTO `notas` VALUES('5598', '1737', '11', '6.30', '2025-06-06', '1', '6');
INSERT INTO `notas` VALUES('5599', '1738', '11', '6.00', '2025-06-06', '1', '4');
INSERT INTO `notas` VALUES('5600', '1738', '11', '5.90', '2025-06-06', '1', '5');
INSERT INTO `notas` VALUES('5601', '1738', '11', '6.00', '2025-06-06', '1', '6');
INSERT INTO `notas` VALUES('5602', '1739', '11', '6.40', '2025-06-06', '1', '4');
INSERT INTO `notas` VALUES('5603', '1739', '11', '6.50', '2025-06-06', '1', '5');
INSERT INTO `notas` VALUES('5604', '1739', '11', '5.50', '2025-06-06', '1', '6');
INSERT INTO `notas` VALUES('5605', '1740', '11', '7.00', '2025-06-06', '1', '4');
INSERT INTO `notas` VALUES('5606', '1740', '11', '5.70', '2025-06-06', '1', '5');
INSERT INTO `notas` VALUES('5607', '1740', '11', '6.60', '2025-06-06', '1', '6');
INSERT INTO `notas` VALUES('5608', '1741', '11', '6.40', '2025-06-06', '1', '4');
INSERT INTO `notas` VALUES('5609', '1741', '11', '5.70', '2025-06-06', '1', '5');
INSERT INTO `notas` VALUES('5610', '1741', '11', '6.40', '2025-06-06', '1', '6');
INSERT INTO `notas` VALUES('5611', '1742', '11', '7.00', '2025-06-06', '1', '4');
INSERT INTO `notas` VALUES('5612', '1742', '11', '6.30', '2025-06-06', '1', '5');
INSERT INTO `notas` VALUES('5613', '1742', '11', '6.10', '2025-06-06', '1', '6');
INSERT INTO `notas` VALUES('5614', '1743', '11', '6.10', '2025-06-06', '1', '4');
INSERT INTO `notas` VALUES('5615', '1743', '11', '4.80', '2025-06-06', '1', '5');
INSERT INTO `notas` VALUES('5616', '1743', '11', '6.20', '2025-06-06', '1', '6');
INSERT INTO `notas` VALUES('5617', '1744', '11', '7.00', '2025-06-06', '1', '4');
INSERT INTO `notas` VALUES('5618', '1744', '11', '4.00', '2025-06-06', '1', '5');
INSERT INTO `notas` VALUES('5619', '1744', '11', '6.40', '2025-06-06', '1', '6');
INSERT INTO `notas` VALUES('5620', '1745', '11', '3.00', '2025-06-06', '1', '4');
INSERT INTO `notas` VALUES('5621', '1745', '11', '4.00', '2025-06-06', '1', '5');
INSERT INTO `notas` VALUES('5622', '1745', '11', '5.00', '2025-06-06', '1', '6');
INSERT INTO `notas` VALUES('5623', '1746', '11', '5.50', '2025-06-06', '1', '4');
INSERT INTO `notas` VALUES('5624', '1746', '11', '4.50', '2025-06-06', '1', '5');
INSERT INTO `notas` VALUES('5625', '1746', '11', '5.40', '2025-06-06', '1', '6');
INSERT INTO `notas` VALUES('5626', '1747', '11', '7.00', '2025-06-06', '1', '4');
INSERT INTO `notas` VALUES('5627', '1747', '11', '5.10', '2025-06-06', '1', '5');
INSERT INTO `notas` VALUES('5628', '1747', '11', '7.00', '2025-06-06', '1', '6');
INSERT INTO `notas` VALUES('5629', '1748', '11', '7.00', '2025-06-06', '1', '4');
INSERT INTO `notas` VALUES('5630', '1748', '11', '6.40', '2025-06-06', '1', '5');
INSERT INTO `notas` VALUES('5631', '1748', '11', '6.80', '2025-06-06', '1', '6');
INSERT INTO `notas` VALUES('5632', '1749', '11', '4.00', '2025-06-06', '1', '4');
INSERT INTO `notas` VALUES('5633', '1749', '11', '3.60', '2025-06-06', '1', '5');
INSERT INTO `notas` VALUES('5634', '1749', '11', '5.40', '2025-06-06', '1', '6');
INSERT INTO `notas` VALUES('5635', '1750', '11', '5.80', '2025-06-06', '1', '4');
INSERT INTO `notas` VALUES('5636', '1750', '11', '4.60', '2025-06-06', '1', '5');
INSERT INTO `notas` VALUES('5637', '1750', '11', '5.70', '2025-06-06', '1', '6');
INSERT INTO `notas` VALUES('5644', '1677', '6', '6.80', '2025-06-06', '1', '3');
INSERT INTO `notas` VALUES('5645', '1677', '6', '7.00', '2025-06-06', '1', '4');
INSERT INTO `notas` VALUES('5704', '1675', '11', '7.00', '2025-06-06', '1', '4');
INSERT INTO `notas` VALUES('5705', '1675', '11', '6.30', '2025-06-06', '1', '5');
INSERT INTO `notas` VALUES('5706', '1675', '11', '5.00', '2025-06-06', '1', '6');
INSERT INTO `notas` VALUES('5707', '1676', '11', '6.70', '2025-06-06', '1', '4');
INSERT INTO `notas` VALUES('5708', '1677', '11', '7.00', '2025-06-06', '1', '4');
INSERT INTO `notas` VALUES('5709', '1677', '11', '6.30', '2025-06-06', '1', '5');
INSERT INTO `notas` VALUES('5710', '1677', '11', '7.00', '2025-06-06', '1', '6');
INSERT INTO `notas` VALUES('5711', '1678', '11', '7.00', '2025-06-06', '1', '4');
INSERT INTO `notas` VALUES('5712', '1678', '11', '5.00', '2025-06-06', '1', '5');
INSERT INTO `notas` VALUES('5713', '1678', '11', '7.00', '2025-06-06', '1', '6');
INSERT INTO `notas` VALUES('5714', '1679', '11', '5.60', '2025-06-06', '1', '4');
INSERT INTO `notas` VALUES('5715', '1679', '11', '7.00', '2025-06-06', '1', '6');
INSERT INTO `notas` VALUES('5716', '1680', '11', '7.00', '2025-06-06', '1', '4');
INSERT INTO `notas` VALUES('5717', '1680', '11', '5.50', '2025-06-06', '1', '5');
INSERT INTO `notas` VALUES('5718', '1680', '11', '7.00', '2025-06-06', '1', '6');
INSERT INTO `notas` VALUES('5719', '1681', '11', '7.00', '2025-06-06', '1', '4');
INSERT INTO `notas` VALUES('5720', '1681', '11', '6.00', '2025-06-06', '1', '5');
INSERT INTO `notas` VALUES('5721', '1681', '11', '6.00', '2025-06-06', '1', '6');
INSERT INTO `notas` VALUES('5722', '1682', '11', '7.00', '2025-06-06', '1', '4');
INSERT INTO `notas` VALUES('5723', '1682', '11', '4.00', '2025-06-06', '1', '5');
INSERT INTO `notas` VALUES('5724', '1682', '11', '6.50', '2025-06-06', '1', '6');
INSERT INTO `notas` VALUES('5725', '1683', '11', '6.70', '2025-06-06', '1', '4');
INSERT INTO `notas` VALUES('5726', '1683', '11', '5.80', '2025-06-06', '1', '5');
INSERT INTO `notas` VALUES('5727', '1683', '11', '5.50', '2025-06-06', '1', '6');
INSERT INTO `notas` VALUES('5728', '1684', '11', '7.00', '2025-06-06', '1', '4');
INSERT INTO `notas` VALUES('5729', '1684', '11', '4.10', '2025-06-06', '1', '5');
INSERT INTO `notas` VALUES('5730', '1684', '11', '6.30', '2025-06-06', '1', '6');
INSERT INTO `notas` VALUES('5731', '1685', '11', '7.00', '2025-06-06', '1', '4');
INSERT INTO `notas` VALUES('5732', '1685', '11', '5.70', '2025-06-06', '1', '5');
INSERT INTO `notas` VALUES('5733', '1685', '11', '6.00', '2025-06-06', '1', '6');
INSERT INTO `notas` VALUES('5734', '1686', '11', '3.40', '2025-06-06', '1', '4');
INSERT INTO `notas` VALUES('5735', '1686', '11', '5.00', '2025-06-06', '1', '5');
INSERT INTO `notas` VALUES('5736', '1686', '11', '5.20', '2025-06-06', '1', '6');
INSERT INTO `notas` VALUES('5737', '1687', '11', '5.60', '2025-06-06', '1', '6');
INSERT INTO `notas` VALUES('5738', '1688', '11', '7.00', '2025-06-06', '1', '4');
INSERT INTO `notas` VALUES('5739', '1688', '11', '5.10', '2025-06-06', '1', '5');
INSERT INTO `notas` VALUES('5740', '1688', '11', '5.60', '2025-06-06', '1', '6');
INSERT INTO `notas` VALUES('5741', '1689', '11', '7.00', '2025-06-06', '1', '4');
INSERT INTO `notas` VALUES('5742', '1689', '11', '5.20', '2025-06-06', '1', '5');
INSERT INTO `notas` VALUES('5743', '1689', '11', '5.80', '2025-06-06', '1', '6');
INSERT INTO `notas` VALUES('5744', '1690', '11', '6.70', '2025-06-06', '1', '4');
INSERT INTO `notas` VALUES('5745', '1690', '11', '5.80', '2025-06-06', '1', '5');
INSERT INTO `notas` VALUES('5746', '1690', '11', '6.50', '2025-06-06', '1', '6');
INSERT INTO `notas` VALUES('5747', '1691', '11', '7.00', '2025-06-06', '1', '4');
INSERT INTO `notas` VALUES('5748', '1691', '11', '5.00', '2025-06-06', '1', '6');
INSERT INTO `notas` VALUES('5749', '1679', '11', '5.00', '2025-06-06', '1', '5');
INSERT INTO `notas` VALUES('5750', '1687', '11', '5.30', '2025-06-06', '1', '5');
INSERT INTO `notas` VALUES('5751', '1691', '11', '5.00', '2025-06-06', '1', '5');
INSERT INTO `notas` VALUES('5752', '1713', '11', '2.60', '2025-06-06', '1', '5');
INSERT INTO `notas` VALUES('5753', '1713', '11', '5.30', '2025-06-06', '1', '6');
INSERT INTO `notas` VALUES('5754', '1714', '11', '5.00', '2025-06-06', '1', '5');
INSERT INTO `notas` VALUES('5755', '1714', '11', '6.70', '2025-06-06', '1', '6');
INSERT INTO `notas` VALUES('5756', '1715', '11', '4.70', '2025-06-06', '1', '3');
INSERT INTO `notas` VALUES('5757', '1715', '11', '6.80', '2025-06-06', '1', '4');
INSERT INTO `notas` VALUES('5758', '1715', '11', '4.10', '2025-06-06', '1', '5');
INSERT INTO `notas` VALUES('5759', '1715', '11', '6.00', '2025-06-06', '1', '6');
INSERT INTO `notas` VALUES('5760', '1716', '11', '5.10', '2025-06-06', '1', '5');
INSERT INTO `notas` VALUES('5761', '1716', '11', '6.80', '2025-06-06', '1', '6');
INSERT INTO `notas` VALUES('5762', '1717', '11', '4.10', '2025-06-06', '1', '5');
INSERT INTO `notas` VALUES('5763', '1717', '11', '5.50', '2025-06-06', '1', '6');
INSERT INTO `notas` VALUES('5764', '1718', '11', '3.60', '2025-06-06', '1', '5');
INSERT INTO `notas` VALUES('5765', '1718', '11', '5.80', '2025-06-06', '1', '6');
INSERT INTO `notas` VALUES('5766', '1719', '11', '4.40', '2025-06-06', '1', '5');
INSERT INTO `notas` VALUES('5767', '1719', '11', '6.70', '2025-06-06', '1', '6');
INSERT INTO `notas` VALUES('5768', '1720', '11', '4.60', '2025-06-06', '1', '5');
INSERT INTO `notas` VALUES('5769', '1720', '11', '6.70', '2025-06-06', '1', '6');
INSERT INTO `notas` VALUES('5770', '1721', '11', '4.90', '2025-06-06', '1', '5');
INSERT INTO `notas` VALUES('5771', '1721', '11', '6.10', '2025-06-06', '1', '6');
INSERT INTO `notas` VALUES('5772', '1722', '11', '3.90', '2025-06-06', '1', '5');
INSERT INTO `notas` VALUES('5773', '1722', '11', '6.20', '2025-06-06', '1', '6');
INSERT INTO `notas` VALUES('5774', '1723', '11', '3.60', '2025-06-06', '1', '5');
INSERT INTO `notas` VALUES('5775', '1723', '11', '6.10', '2025-06-06', '1', '6');
INSERT INTO `notas` VALUES('5776', '1724', '11', '5.60', '2025-06-06', '1', '5');
INSERT INTO `notas` VALUES('5777', '1724', '11', '6.30', '2025-06-06', '1', '6');
INSERT INTO `notas` VALUES('5778', '1725', '11', '5.40', '2025-06-06', '1', '4');
INSERT INTO `notas` VALUES('5779', '1725', '11', '5.90', '2025-06-06', '1', '5');
INSERT INTO `notas` VALUES('5780', '1726', '11', '5.10', '2025-06-06', '1', '4');
INSERT INTO `notas` VALUES('5781', '1726', '11', '5.10', '2025-06-06', '1', '5');
INSERT INTO `notas` VALUES('5782', '1726', '11', '5.60', '2025-06-06', '1', '6');
INSERT INTO `notas` VALUES('5783', '1727', '11', '6.00', '2025-06-06', '1', '5');
INSERT INTO `notas` VALUES('5784', '1727', '11', '7.00', '2025-06-06', '1', '6');
INSERT INTO `notas` VALUES('5785', '1728', '11', '5.70', '2025-06-06', '1', '5');
INSERT INTO `notas` VALUES('5786', '1728', '11', '6.30', '2025-06-06', '1', '6');
INSERT INTO `notas` VALUES('5787', '1729', '11', '4.70', '2025-06-06', '1', '5');
INSERT INTO `notas` VALUES('5788', '1729', '11', '5.80', '2025-06-06', '1', '6');
INSERT INTO `notas` VALUES('5789', '1730', '11', '3.40', '2025-06-06', '1', '5');
INSERT INTO `notas` VALUES('5790', '1730', '11', '5.70', '2025-06-06', '1', '6');
INSERT INTO `notas` VALUES('5791', '1713', '12', '5.30', '2025-06-09', '1', '3');
INSERT INTO `notas` VALUES('5792', '1714', '12', '6.70', '2025-06-09', '1', '3');
INSERT INTO `notas` VALUES('5793', '1715', '12', '6.00', '2025-06-09', '1', '3');
INSERT INTO `notas` VALUES('5794', '1716', '12', '6.80', '2025-06-09', '1', '3');
INSERT INTO `notas` VALUES('5795', '1717', '12', '5.50', '2025-06-09', '1', '3');
INSERT INTO `notas` VALUES('5796', '1718', '12', '5.80', '2025-06-09', '1', '3');
INSERT INTO `notas` VALUES('5797', '1719', '12', '6.70', '2025-06-09', '1', '3');
INSERT INTO `notas` VALUES('5798', '1720', '12', '6.70', '2025-06-09', '1', '3');
INSERT INTO `notas` VALUES('5799', '1721', '12', '6.10', '2025-06-09', '1', '3');
INSERT INTO `notas` VALUES('5800', '1722', '12', '6.20', '2025-06-09', '1', '3');
INSERT INTO `notas` VALUES('5801', '1723', '12', '6.10', '2025-06-09', '1', '3');
INSERT INTO `notas` VALUES('5802', '1724', '12', '6.30', '2025-06-09', '1', '3');
INSERT INTO `notas` VALUES('5803', '1725', '12', '7.00', '2025-06-09', '1', '3');
INSERT INTO `notas` VALUES('5804', '1726', '12', '5.60', '2025-06-09', '1', '3');
INSERT INTO `notas` VALUES('5805', '1727', '12', '7.00', '2025-06-09', '1', '3');
INSERT INTO `notas` VALUES('5806', '1728', '12', '6.30', '2025-06-09', '1', '3');
INSERT INTO `notas` VALUES('5807', '1729', '12', '5.80', '2025-06-09', '1', '3');
INSERT INTO `notas` VALUES('5808', '1730', '12', '5.70', '2025-06-09', '1', '3');
INSERT INTO `notas` VALUES('5809', '1725', '11', '5.90', '2025-06-09', '1', '6');
INSERT INTO `notas` VALUES('5810', '1898', '7', '6.20', '2025-06-09', '1', '2');
INSERT INTO `notas` VALUES('5811', '1898', '7', '7.00', '2025-06-09', '1', '3');
INSERT INTO `notas` VALUES('5812', '1898', '7', '7.00', '2025-06-09', '1', '4');
INSERT INTO `notas` VALUES('5813', '1899', '7', '5.90', '2025-06-09', '1', '2');
INSERT INTO `notas` VALUES('5814', '1899', '7', '7.00', '2025-06-09', '1', '3');
INSERT INTO `notas` VALUES('5815', '1899', '7', '6.90', '2025-06-09', '1', '4');
INSERT INTO `notas` VALUES('5816', '1900', '7', '5.60', '2025-06-09', '1', '2');
INSERT INTO `notas` VALUES('5817', '1900', '7', '5.80', '2025-06-09', '1', '3');
INSERT INTO `notas` VALUES('5818', '1900', '7', '6.60', '2025-06-09', '1', '4');
INSERT INTO `notas` VALUES('5819', '1901', '7', '5.30', '2025-06-09', '1', '2');
INSERT INTO `notas` VALUES('5820', '1901', '7', '5.00', '2025-06-09', '1', '3');
INSERT INTO `notas` VALUES('5821', '1901', '7', '4.70', '2025-06-09', '1', '4');
INSERT INTO `notas` VALUES('5822', '1902', '7', '6.20', '2025-06-09', '1', '2');
INSERT INTO `notas` VALUES('5823', '1902', '7', '7.00', '2025-06-09', '1', '3');
INSERT INTO `notas` VALUES('5824', '1902', '7', '6.90', '2025-06-09', '1', '4');
INSERT INTO `notas` VALUES('5825', '1920', '7', '4.20', '2025-06-09', '1', '2');
INSERT INTO `notas` VALUES('5826', '1920', '7', '7.00', '2025-06-09', '1', '3');
INSERT INTO `notas` VALUES('5827', '1920', '7', '5.70', '2025-06-09', '1', '4');
INSERT INTO `notas` VALUES('5828', '1919', '7', '2.50', '2025-06-09', '1', '2');
INSERT INTO `notas` VALUES('5829', '1919', '7', '4.80', '2025-06-09', '1', '3');
INSERT INTO `notas` VALUES('5830', '1919', '7', '5.40', '2025-06-09', '1', '4');
INSERT INTO `notas` VALUES('5831', '1903', '7', '5.90', '2025-06-09', '1', '2');
INSERT INTO `notas` VALUES('5832', '1903', '7', '7.00', '2025-06-09', '1', '3');
INSERT INTO `notas` VALUES('5833', '1903', '7', '6.90', '2025-06-09', '1', '4');
INSERT INTO `notas` VALUES('5834', '1904', '7', '3.00', '2025-06-09', '1', '2');
INSERT INTO `notas` VALUES('5835', '1904', '7', '4.00', '2025-06-09', '1', '3');
INSERT INTO `notas` VALUES('5836', '1904', '7', '5.80', '2025-06-09', '1', '4');
INSERT INTO `notas` VALUES('5837', '1905', '7', '4.20', '2025-06-09', '1', '2');
INSERT INTO `notas` VALUES('5838', '1905', '7', '4.80', '2025-06-09', '1', '3');
INSERT INTO `notas` VALUES('5839', '1905', '7', '6.30', '2025-06-09', '1', '4');
INSERT INTO `notas` VALUES('5840', '1906', '7', '4.80', '2025-06-09', '1', '2');
INSERT INTO `notas` VALUES('5841', '1906', '7', '4.00', '2025-06-09', '1', '3');
INSERT INTO `notas` VALUES('5842', '1906', '7', '4.80', '2025-06-09', '1', '4');
INSERT INTO `notas` VALUES('5843', '1907', '7', '5.90', '2025-06-09', '1', '2');
INSERT INTO `notas` VALUES('5844', '1907', '7', '6.30', '2025-06-09', '1', '3');
INSERT INTO `notas` VALUES('5845', '1907', '7', '6.90', '2025-06-09', '1', '4');
INSERT INTO `notas` VALUES('5846', '1908', '7', '4.80', '2025-06-09', '1', '2');
INSERT INTO `notas` VALUES('5847', '1908', '7', '6.40', '2025-06-09', '1', '3');
INSERT INTO `notas` VALUES('5848', '1908', '7', '6.90', '2025-06-09', '1', '4');
INSERT INTO `notas` VALUES('5849', '1909', '7', '5.60', '2025-06-09', '1', '2');
INSERT INTO `notas` VALUES('5850', '1909', '7', '6.50', '2025-06-09', '1', '3');
INSERT INTO `notas` VALUES('5851', '1909', '7', '6.90', '2025-06-09', '1', '4');
INSERT INTO `notas` VALUES('5852', '1910', '7', '5.60', '2025-06-09', '1', '2');
INSERT INTO `notas` VALUES('5853', '1910', '7', '5.80', '2025-06-09', '1', '4');
INSERT INTO `notas` VALUES('5854', '1911', '7', '7.00', '2025-06-09', '1', '2');
INSERT INTO `notas` VALUES('5855', '1911', '7', '4.00', '2025-06-09', '1', '3');
INSERT INTO `notas` VALUES('5856', '1911', '7', '5.00', '2025-06-09', '1', '4');
INSERT INTO `notas` VALUES('5857', '1912', '7', '5.10', '2025-06-09', '1', '2');
INSERT INTO `notas` VALUES('5858', '1912', '7', '5.80', '2025-06-09', '1', '3');
INSERT INTO `notas` VALUES('5859', '1912', '7', '6.30', '2025-06-09', '1', '4');
INSERT INTO `notas` VALUES('5860', '1913', '7', '3.80', '2025-06-09', '1', '2');
INSERT INTO `notas` VALUES('5861', '1913', '7', '7.00', '2025-06-09', '1', '3');
INSERT INTO `notas` VALUES('5862', '1913', '7', '6.60', '2025-06-09', '1', '4');
INSERT INTO `notas` VALUES('5863', '1914', '7', '2.90', '2025-06-09', '1', '2');
INSERT INTO `notas` VALUES('5864', '1914', '7', '5.80', '2025-06-09', '1', '3');
INSERT INTO `notas` VALUES('5865', '1914', '7', '6.10', '2025-06-09', '1', '4');
INSERT INTO `notas` VALUES('5866', '1915', '7', '4.20', '2025-06-09', '1', '2');
INSERT INTO `notas` VALUES('5867', '1915', '7', '7.00', '2025-06-09', '1', '3');
INSERT INTO `notas` VALUES('5868', '1915', '7', '6.90', '2025-06-09', '1', '4');
INSERT INTO `notas` VALUES('5869', '1916', '7', '7.00', '2025-06-09', '1', '2');
INSERT INTO `notas` VALUES('5870', '1916', '7', '5.80', '2025-06-09', '1', '3');
INSERT INTO `notas` VALUES('5871', '1916', '7', '6.20', '2025-06-09', '1', '4');
INSERT INTO `notas` VALUES('5872', '1917', '7', '4.80', '2025-06-09', '1', '2');
INSERT INTO `notas` VALUES('5873', '1917', '7', '6.40', '2025-06-09', '1', '4');
INSERT INTO `notas` VALUES('5874', '1921', '7', '5.90', '2025-06-09', '1', '2');
INSERT INTO `notas` VALUES('5875', '1921', '7', '7.00', '2025-06-09', '1', '4');
INSERT INTO `notas` VALUES('5876', '1918', '7', '5.90', '2025-06-09', '1', '2');
INSERT INTO `notas` VALUES('5877', '1918', '7', '6.30', '2025-06-09', '1', '3');
INSERT INTO `notas` VALUES('5878', '1918', '7', '6.00', '2025-06-09', '1', '4');
INSERT INTO `notas` VALUES('5879', '1713', '7', '5.60', '2025-06-09', '1', '3');
INSERT INTO `notas` VALUES('5880', '1713', '7', '5.30', '2025-06-09', '1', '4');
INSERT INTO `notas` VALUES('5881', '1714', '7', '7.00', '2025-06-09', '1', '3');
INSERT INTO `notas` VALUES('5882', '1714', '7', '6.70', '2025-06-09', '1', '4');
INSERT INTO `notas` VALUES('5883', '1715', '7', '7.00', '2025-06-09', '1', '2');
INSERT INTO `notas` VALUES('5884', '1715', '7', '5.60', '2025-06-09', '1', '3');
INSERT INTO `notas` VALUES('5885', '1715', '7', '6.00', '2025-06-09', '1', '4');
INSERT INTO `notas` VALUES('5886', '1716', '7', '7.00', '2025-06-09', '1', '3');
INSERT INTO `notas` VALUES('5887', '1716', '7', '6.80', '2025-06-09', '1', '4');
INSERT INTO `notas` VALUES('5888', '1717', '7', '6.50', '2025-06-09', '1', '3');
INSERT INTO `notas` VALUES('5889', '1717', '7', '5.50', '2025-06-09', '1', '4');
INSERT INTO `notas` VALUES('5890', '1718', '7', '7.00', '2025-06-09', '1', '3');
INSERT INTO `notas` VALUES('5891', '1718', '7', '5.80', '2025-06-09', '1', '4');
INSERT INTO `notas` VALUES('5892', '1719', '7', '7.00', '2025-06-09', '1', '3');
INSERT INTO `notas` VALUES('5893', '1719', '7', '6.70', '2025-06-09', '1', '4');
INSERT INTO `notas` VALUES('5894', '1720', '7', '7.00', '2025-06-09', '1', '3');
INSERT INTO `notas` VALUES('5895', '1720', '7', '6.70', '2025-06-09', '1', '4');
INSERT INTO `notas` VALUES('5896', '1721', '7', '7.00', '2025-06-09', '1', '3');
INSERT INTO `notas` VALUES('5897', '1721', '7', '6.10', '2025-06-09', '1', '4');
INSERT INTO `notas` VALUES('5898', '1722', '7', '6.10', '2025-06-09', '1', '3');
INSERT INTO `notas` VALUES('5899', '1722', '7', '6.20', '2025-06-09', '1', '4');
INSERT INTO `notas` VALUES('5900', '1723', '7', '5.60', '2025-06-09', '1', '3');
INSERT INTO `notas` VALUES('5901', '1723', '7', '6.10', '2025-06-09', '1', '4');
INSERT INTO `notas` VALUES('5902', '1724', '7', '7.00', '2025-06-09', '1', '3');
INSERT INTO `notas` VALUES('5903', '1724', '7', '6.30', '2025-06-09', '1', '4');
INSERT INTO `notas` VALUES('5904', '1725', '7', '6.00', '2025-06-09', '1', '3');
INSERT INTO `notas` VALUES('5905', '1725', '7', '5.90', '2025-06-09', '1', '4');
INSERT INTO `notas` VALUES('5906', '1726', '7', '6.60', '2025-06-09', '1', '3');
INSERT INTO `notas` VALUES('5907', '1726', '7', '5.60', '2025-06-09', '1', '4');
INSERT INTO `notas` VALUES('5908', '1727', '7', '7.00', '2025-06-09', '1', '3');
INSERT INTO `notas` VALUES('5909', '1727', '7', '7.00', '2025-06-09', '1', '4');
INSERT INTO `notas` VALUES('5910', '1728', '7', '6.50', '2025-06-09', '1', '3');
INSERT INTO `notas` VALUES('5911', '1728', '7', '6.30', '2025-06-09', '1', '4');
INSERT INTO `notas` VALUES('5912', '1729', '7', '6.10', '2025-06-09', '1', '3');
INSERT INTO `notas` VALUES('5913', '1729', '7', '5.80', '2025-06-09', '1', '4');
INSERT INTO `notas` VALUES('5914', '1730', '7', '2.90', '2025-06-09', '1', '3');
INSERT INTO `notas` VALUES('5915', '1730', '7', '5.70', '2025-06-09', '1', '4');
INSERT INTO `notas` VALUES('5916', '1731', '2', '5.90', '2025-06-10', '1', '6');
INSERT INTO `notas` VALUES('5917', '1732', '2', '6.60', '2025-06-10', '1', '6');
INSERT INTO `notas` VALUES('5918', '1733', '2', '4.70', '2025-06-10', '1', '6');
INSERT INTO `notas` VALUES('5919', '1734', '2', '5.90', '2025-06-10', '1', '6');
INSERT INTO `notas` VALUES('5920', '1735', '2', '6.30', '2025-06-10', '1', '6');
INSERT INTO `notas` VALUES('5921', '1736', '2', '5.20', '2025-06-10', '1', '6');
INSERT INTO `notas` VALUES('5922', '1737', '2', '6.20', '2025-06-10', '1', '6');
INSERT INTO `notas` VALUES('5923', '1738', '2', '6.10', '2025-06-10', '1', '6');
INSERT INTO `notas` VALUES('5924', '1739', '2', '5.00', '2025-06-10', '1', '6');
INSERT INTO `notas` VALUES('5925', '1740', '2', '6.50', '2025-06-10', '1', '6');
INSERT INTO `notas` VALUES('5926', '1741', '2', '6.30', '2025-06-10', '1', '6');
INSERT INTO `notas` VALUES('5927', '1742', '2', '6.30', '2025-06-10', '1', '6');
INSERT INTO `notas` VALUES('5928', '1743', '2', '5.50', '2025-06-10', '1', '6');
INSERT INTO `notas` VALUES('5929', '1744', '2', '6.00', '2025-06-10', '1', '6');
INSERT INTO `notas` VALUES('5930', '1745', '2', '4.00', '2025-06-10', '1', '5');
INSERT INTO `notas` VALUES('5931', '1745', '2', '4.60', '2025-06-10', '1', '6');
INSERT INTO `notas` VALUES('5932', '1746', '2', '5.70', '2025-06-10', '1', '6');
INSERT INTO `notas` VALUES('5933', '1747', '2', '5.60', '2025-06-10', '1', '6');
INSERT INTO `notas` VALUES('5934', '1748', '2', '6.60', '2025-06-10', '1', '6');
INSERT INTO `notas` VALUES('5935', '1749', '2', '5.00', '2025-06-10', '1', '5');
INSERT INTO `notas` VALUES('5936', '1749', '2', '4.70', '2025-06-10', '1', '6');
INSERT INTO `notas` VALUES('5937', '1750', '2', '5.60', '2025-06-10', '1', '6');
INSERT INTO `notas` VALUES('5938', '1731', '6', '5.10', '2025-06-10', '1', '3');
INSERT INTO `notas` VALUES('5939', '1731', '6', '5.90', '2025-06-10', '1', '4');
INSERT INTO `notas` VALUES('5940', '1732', '6', '6.60', '2025-06-10', '1', '4');
INSERT INTO `notas` VALUES('5941', '1733', '6', '4.70', '2025-06-10', '1', '4');
INSERT INTO `notas` VALUES('5942', '1734', '6', '6.10', '2025-06-10', '1', '3');
INSERT INTO `notas` VALUES('5943', '1734', '6', '5.90', '2025-06-10', '1', '4');
INSERT INTO `notas` VALUES('5944', '1735', '6', '5.10', '2025-06-10', '1', '3');
INSERT INTO `notas` VALUES('5945', '1735', '6', '6.30', '2025-06-10', '1', '4');
INSERT INTO `notas` VALUES('5946', '1736', '6', '1.00', '2025-06-10', '1', '3');
INSERT INTO `notas` VALUES('5947', '1736', '6', '5.20', '2025-06-10', '1', '4');
INSERT INTO `notas` VALUES('5948', '1737', '6', '5.10', '2025-06-10', '1', '3');
INSERT INTO `notas` VALUES('5949', '1737', '6', '6.20', '2025-06-10', '1', '4');
INSERT INTO `notas` VALUES('5950', '1738', '6', '6.10', '2025-06-10', '1', '3');
INSERT INTO `notas` VALUES('5951', '1738', '6', '6.10', '2025-06-10', '1', '4');
INSERT INTO `notas` VALUES('5952', '1739', '6', '5.10', '2025-06-10', '1', '3');
INSERT INTO `notas` VALUES('5953', '1739', '6', '5.00', '2025-06-10', '1', '4');
INSERT INTO `notas` VALUES('5954', '1740', '6', '5.60', '2025-06-10', '1', '3');
INSERT INTO `notas` VALUES('5955', '1740', '6', '6.50', '2025-06-10', '1', '4');
INSERT INTO `notas` VALUES('5956', '1741', '6', '7.00', '2025-06-10', '1', '3');
INSERT INTO `notas` VALUES('5957', '1741', '6', '6.30', '2025-06-10', '1', '4');
INSERT INTO `notas` VALUES('5958', '1742', '6', '6.10', '2025-06-10', '1', '3');
INSERT INTO `notas` VALUES('5959', '1742', '6', '6.30', '2025-06-10', '1', '4');
INSERT INTO `notas` VALUES('5960', '1743', '6', '6.10', '2025-06-10', '1', '3');
INSERT INTO `notas` VALUES('5961', '1743', '6', '5.50', '2025-06-10', '1', '4');
INSERT INTO `notas` VALUES('5962', '1744', '6', '5.10', '2025-06-10', '1', '3');
INSERT INTO `notas` VALUES('5963', '1744', '6', '6.00', '2025-06-10', '1', '4');
INSERT INTO `notas` VALUES('5964', '1745', '6', '5.10', '2025-06-10', '1', '3');
INSERT INTO `notas` VALUES('5965', '1745', '6', '4.60', '2025-06-10', '1', '4');
INSERT INTO `notas` VALUES('5966', '1746', '6', '5.70', '2025-06-10', '1', '4');
INSERT INTO `notas` VALUES('5967', '1747', '6', '5.60', '2025-06-10', '1', '4');
INSERT INTO `notas` VALUES('5968', '1748', '6', '6.50', '2025-06-10', '1', '3');
INSERT INTO `notas` VALUES('5969', '1748', '6', '6.60', '2025-06-10', '1', '4');
INSERT INTO `notas` VALUES('5970', '1749', '6', '4.70', '2025-06-10', '1', '4');
INSERT INTO `notas` VALUES('5971', '1750', '6', '6.10', '2025-06-10', '1', '3');
INSERT INTO `notas` VALUES('5972', '1750', '6', '5.60', '2025-06-10', '1', '4');
INSERT INTO `notas` VALUES('5973', '1910', '7', '5.00', '2025-06-10', '1', '3');
INSERT INTO `notas` VALUES('5974', '1917', '7', '6.50', '2025-06-10', '1', '3');
INSERT INTO `notas` VALUES('5975', '1921', '7', '6.30', '2025-06-10', '1', '3');
INSERT INTO `notas` VALUES('5976', '1675', '12', '5.60', '2025-06-10', '1', '3');
INSERT INTO `notas` VALUES('5977', '1677', '12', '6.90', '2025-06-10', '1', '3');
INSERT INTO `notas` VALUES('5978', '1678', '12', '6.00', '2025-06-10', '1', '3');
INSERT INTO `notas` VALUES('5979', '1679', '12', '6.90', '2025-06-10', '1', '3');
INSERT INTO `notas` VALUES('5980', '1680', '12', '6.10', '2025-06-10', '1', '3');
INSERT INTO `notas` VALUES('5981', '1681', '12', '6.10', '2025-06-10', '1', '3');
INSERT INTO `notas` VALUES('5982', '1682', '12', '6.50', '2025-06-10', '1', '3');
INSERT INTO `notas` VALUES('5983', '1683', '12', '6.00', '2025-06-10', '1', '3');
INSERT INTO `notas` VALUES('5984', '1684', '12', '6.60', '2025-06-10', '1', '3');
INSERT INTO `notas` VALUES('5985', '1685', '12', '5.80', '2025-06-10', '1', '3');
INSERT INTO `notas` VALUES('5986', '1686', '12', '2.00', '2025-06-10', '1', '2');
INSERT INTO `notas` VALUES('5987', '1686', '12', '5.60', '2025-06-10', '1', '3');
INSERT INTO `notas` VALUES('5988', '1687', '12', '5.40', '2025-06-10', '1', '3');
INSERT INTO `notas` VALUES('5989', '1688', '12', '5.10', '2025-06-10', '1', '3');
INSERT INTO `notas` VALUES('5990', '1689', '12', '5.50', '2025-06-10', '1', '3');
INSERT INTO `notas` VALUES('5991', '1690', '12', '6.40', '2025-06-10', '1', '3');
INSERT INTO `notas` VALUES('5992', '1691', '12', '6.00', '2025-06-10', '1', '3');
INSERT INTO `notas` VALUES('5993', '1948', '6', '6.20', '2025-06-10', '1', '3');
INSERT INTO `notas` VALUES('5994', '1948', '6', '6.10', '2025-06-10', '1', '4');
INSERT INTO `notas` VALUES('5995', '1949', '6', '5.80', '2025-06-10', '1', '3');
INSERT INTO `notas` VALUES('5996', '1949', '6', '5.60', '2025-06-10', '1', '4');
INSERT INTO `notas` VALUES('5997', '1950', '6', '6.60', '2025-06-10', '1', '3');
INSERT INTO `notas` VALUES('5998', '1951', '6', '7.00', '2025-06-10', '1', '3');
INSERT INTO `notas` VALUES('5999', '1951', '6', '6.20', '2025-06-10', '1', '4');
INSERT INTO `notas` VALUES('6000', '1952', '6', '6.20', '2025-06-10', '1', '3');
INSERT INTO `notas` VALUES('6001', '1952', '6', '5.80', '2025-06-10', '1', '4');
INSERT INTO `notas` VALUES('6002', '1953', '6', '7.00', '2025-06-10', '1', '3');
INSERT INTO `notas` VALUES('6003', '1953', '6', '6.80', '2025-06-10', '1', '4');
INSERT INTO `notas` VALUES('6004', '1954', '6', '6.60', '2025-06-10', '1', '3');
INSERT INTO `notas` VALUES('6005', '1954', '6', '6.50', '2025-06-10', '1', '4');
INSERT INTO `notas` VALUES('6006', '1956', '6', '5.50', '2025-06-10', '1', '3');
INSERT INTO `notas` VALUES('6007', '1956', '6', '5.20', '2025-06-10', '1', '4');
INSERT INTO `notas` VALUES('6008', '1957', '6', '5.90', '2025-06-10', '1', '3');
INSERT INTO `notas` VALUES('6009', '1957', '6', '5.00', '2025-06-10', '1', '4');
INSERT INTO `notas` VALUES('6010', '1958', '6', '7.00', '2025-06-10', '1', '3');
INSERT INTO `notas` VALUES('6011', '1958', '6', '6.90', '2025-06-10', '1', '4');
INSERT INTO `notas` VALUES('6012', '1959', '6', '6.00', '2025-06-10', '1', '3');
INSERT INTO `notas` VALUES('6013', '1960', '6', '6.30', '2025-06-10', '1', '3');
INSERT INTO `notas` VALUES('6014', '1960', '6', '6.90', '2025-06-10', '1', '4');
INSERT INTO `notas` VALUES('6015', '1961', '6', '7.00', '2025-06-10', '1', '3');
INSERT INTO `notas` VALUES('6016', '1961', '6', '5.30', '2025-06-10', '1', '4');
INSERT INTO `notas` VALUES('6017', '1962', '6', '6.20', '2025-06-10', '1', '3');
INSERT INTO `notas` VALUES('6018', '1962', '6', '6.60', '2025-06-10', '1', '4');
INSERT INTO `notas` VALUES('6019', '1963', '6', '6.00', '2025-06-10', '1', '3');
INSERT INTO `notas` VALUES('6020', '1963', '6', '6.40', '2025-06-10', '1', '4');
INSERT INTO `notas` VALUES('6021', '1964', '6', '6.20', '2025-06-10', '1', '3');
INSERT INTO `notas` VALUES('6022', '1964', '6', '6.40', '2025-06-10', '1', '4');
INSERT INTO `notas` VALUES('6023', '1965', '6', '6.20', '2025-06-10', '1', '3');
INSERT INTO `notas` VALUES('6024', '1966', '6', '6.20', '2025-06-10', '1', '3');
INSERT INTO `notas` VALUES('6025', '1966', '6', '5.90', '2025-06-10', '1', '4');
INSERT INTO `notas` VALUES('6026', '1967', '6', '4.90', '2025-06-10', '1', '3');
INSERT INTO `notas` VALUES('6027', '1967', '6', '5.90', '2025-06-10', '1', '4');
INSERT INTO `notas` VALUES('6028', '1968', '6', '6.60', '2025-06-10', '1', '3');
INSERT INTO `notas` VALUES('6029', '1968', '6', '6.90', '2025-06-10', '1', '4');
INSERT INTO `notas` VALUES('6030', '1969', '6', '6.60', '2025-06-10', '1', '3');
INSERT INTO `notas` VALUES('6031', '1969', '6', '6.60', '2025-06-10', '1', '4');
INSERT INTO `notas` VALUES('6032', '1970', '6', '5.30', '2025-06-10', '1', '3');
INSERT INTO `notas` VALUES('6033', '1971', '6', '5.30', '2025-06-10', '1', '3');
INSERT INTO `notas` VALUES('6034', '1971', '6', '5.20', '2025-06-10', '1', '4');
INSERT INTO `notas` VALUES('6035', '1972', '6', '6.80', '2025-06-10', '1', '3');
INSERT INTO `notas` VALUES('6036', '1972', '6', '6.90', '2025-06-10', '1', '4');
INSERT INTO `notas` VALUES('6037', '1973', '6', '6.30', '2025-06-10', '1', '3');
INSERT INTO `notas` VALUES('6038', '1973', '6', '6.30', '2025-06-10', '1', '4');
INSERT INTO `notas` VALUES('6039', '1975', '6', '5.80', '2025-06-10', '1', '3');
INSERT INTO `notas` VALUES('6040', '1975', '6', '5.50', '2025-06-10', '1', '4');
INSERT INTO `notas` VALUES('6041', '1976', '6', '7.00', '2025-06-10', '1', '3');
INSERT INTO `notas` VALUES('6042', '1976', '6', '6.70', '2025-06-10', '1', '4');
INSERT INTO `notas` VALUES('6043', '1977', '6', '6.60', '2025-06-10', '1', '3');
INSERT INTO `notas` VALUES('6044', '1977', '6', '6.50', '2025-06-10', '1', '4');
INSERT INTO `notas` VALUES('6045', '1978', '6', '7.00', '2025-06-10', '1', '3');
INSERT INTO `notas` VALUES('6046', '1978', '6', '6.40', '2025-06-10', '1', '4');
INSERT INTO `notas` VALUES('6047', '1979', '6', '4.50', '2025-06-10', '1', '3');
INSERT INTO `notas` VALUES('6048', '1979', '6', '5.70', '2025-06-10', '1', '4');
INSERT INTO `notas` VALUES('6049', '1980', '6', '6.50', '2025-06-10', '1', '3');
INSERT INTO `notas` VALUES('6050', '1980', '6', '6.30', '2025-06-10', '1', '4');
INSERT INTO `notas` VALUES('6051', '1981', '6', '7.00', '2025-06-10', '1', '3');
INSERT INTO `notas` VALUES('6052', '1981', '6', '6.80', '2025-06-10', '1', '4');
INSERT INTO `notas` VALUES('6053', '1982', '6', '6.00', '2025-06-10', '1', '3');
INSERT INTO `notas` VALUES('6054', '1983', '6', '5.00', '2025-06-10', '1', '3');
INSERT INTO `notas` VALUES('6055', '1984', '6', '6.60', '2025-06-10', '1', '3');
INSERT INTO `notas` VALUES('6056', '1984', '6', '6.20', '2025-06-10', '1', '4');
INSERT INTO `notas` VALUES('6057', '1985', '6', '6.20', '2025-06-10', '1', '3');
INSERT INTO `notas` VALUES('6058', '1985', '6', '6.30', '2025-06-10', '1', '4');
INSERT INTO `notas` VALUES('6059', '1986', '6', '4.10', '2025-06-10', '1', '3');
INSERT INTO `notas` VALUES('6060', '1986', '6', '5.30', '2025-06-10', '1', '4');
INSERT INTO `notas` VALUES('6061', '1987', '6', '7.00', '2025-06-10', '1', '3');
INSERT INTO `notas` VALUES('6062', '1987', '6', '6.90', '2025-06-10', '1', '4');
INSERT INTO `notas` VALUES('6063', '1675', '6', '7.00', '2025-06-10', '1', '1');
INSERT INTO `notas` VALUES('6064', '1675', '6', '3.00', '2025-06-10', '1', '2');
INSERT INTO `notas` VALUES('6065', '1675', '6', '4.00', '2025-06-10', '1', '3');
INSERT INTO `notas` VALUES('6066', '1675', '6', '5.00', '2025-06-10', '1', '4');
INSERT INTO `notas` VALUES('6067', '1678', '6', '6.40', '2025-06-10', '1', '1');
INSERT INTO `notas` VALUES('6068', '1678', '6', '5.70', '2025-06-10', '1', '2');
INSERT INTO `notas` VALUES('6069', '1678', '6', '6.20', '2025-06-10', '1', '3');
INSERT INTO `notas` VALUES('6070', '1678', '6', '7.00', '2025-06-10', '1', '4');
INSERT INTO `notas` VALUES('6071', '1679', '6', '5.10', '2025-06-10', '1', '1');
INSERT INTO `notas` VALUES('6072', '1679', '6', '2.00', '2025-06-10', '1', '2');
INSERT INTO `notas` VALUES('6073', '1679', '6', '6.80', '2025-06-10', '1', '3');
INSERT INTO `notas` VALUES('6074', '1679', '6', '7.00', '2025-06-10', '1', '4');
INSERT INTO `notas` VALUES('6075', '1680', '6', '6.20', '2025-06-10', '1', '1');
INSERT INTO `notas` VALUES('6076', '1680', '6', '3.50', '2025-06-10', '1', '2');
INSERT INTO `notas` VALUES('6077', '1680', '6', '6.90', '2025-06-10', '1', '3');
INSERT INTO `notas` VALUES('6078', '1680', '6', '7.00', '2025-06-10', '1', '4');
INSERT INTO `notas` VALUES('6079', '1681', '6', '4.20', '2025-06-10', '1', '1');
INSERT INTO `notas` VALUES('6080', '1681', '6', '5.00', '2025-06-10', '1', '2');
INSERT INTO `notas` VALUES('6081', '1681', '6', '6.80', '2025-06-10', '1', '3');
INSERT INTO `notas` VALUES('6082', '1681', '6', '6.00', '2025-06-10', '1', '4');
INSERT INTO `notas` VALUES('6083', '1682', '6', '3.30', '2025-06-10', '1', '1');
INSERT INTO `notas` VALUES('6084', '1682', '6', '4.50', '2025-06-10', '1', '2');
INSERT INTO `notas` VALUES('6085', '1682', '6', '6.90', '2025-06-10', '1', '3');
INSERT INTO `notas` VALUES('6086', '1682', '6', '6.50', '2025-06-10', '1', '4');
INSERT INTO `notas` VALUES('6087', '1683', '6', '6.10', '2025-06-10', '1', '1');
INSERT INTO `notas` VALUES('6088', '1683', '6', '3.30', '2025-06-10', '1', '2');
INSERT INTO `notas` VALUES('6089', '1683', '6', '6.90', '2025-06-10', '1', '3');
INSERT INTO `notas` VALUES('6090', '1683', '6', '5.50', '2025-06-10', '1', '4');
INSERT INTO `notas` VALUES('6091', '1684', '6', '4.20', '2025-06-10', '1', '1');
INSERT INTO `notas` VALUES('6092', '1684', '6', '5.60', '2025-06-10', '1', '2');
INSERT INTO `notas` VALUES('6093', '1684', '6', '7.00', '2025-06-10', '1', '3');
INSERT INTO `notas` VALUES('6094', '1684', '6', '6.30', '2025-06-10', '1', '4');
INSERT INTO `notas` VALUES('6095', '1685', '6', '4.00', '2025-06-10', '1', '1');
INSERT INTO `notas` VALUES('6096', '1685', '6', '5.20', '2025-06-10', '1', '2');
INSERT INTO `notas` VALUES('6097', '1685', '6', '6.90', '2025-06-10', '1', '3');
INSERT INTO `notas` VALUES('6098', '1685', '6', '6.00', '2025-06-10', '1', '4');
INSERT INTO `notas` VALUES('6099', '1686', '6', '2.50', '2025-06-10', '1', '1');
INSERT INTO `notas` VALUES('6100', '1686', '6', '4.00', '2025-06-10', '1', '2');
INSERT INTO `notas` VALUES('6101', '1686', '6', '6.00', '2025-06-10', '1', '3');
INSERT INTO `notas` VALUES('6102', '1686', '6', '5.20', '2025-06-10', '1', '4');
INSERT INTO `notas` VALUES('6103', '1687', '6', '4.00', '2025-06-10', '1', '1');
INSERT INTO `notas` VALUES('6104', '1687', '6', '2.50', '2025-06-10', '1', '2');
INSERT INTO `notas` VALUES('6105', '1687', '6', '4.00', '2025-06-10', '1', '3');
INSERT INTO `notas` VALUES('6106', '1687', '6', '5.60', '2025-06-10', '1', '4');
INSERT INTO `notas` VALUES('6107', '1688', '6', '3.20', '2025-06-10', '1', '1');
INSERT INTO `notas` VALUES('6108', '1688', '6', '4.30', '2025-06-10', '1', '2');
INSERT INTO `notas` VALUES('6109', '1688', '6', '6.50', '2025-06-10', '1', '3');
INSERT INTO `notas` VALUES('6110', '1688', '6', '5.60', '2025-06-10', '1', '4');
INSERT INTO `notas` VALUES('6111', '1689', '6', '3.40', '2025-06-10', '1', '1');
INSERT INTO `notas` VALUES('6112', '1689', '6', '2.30', '2025-06-10', '1', '2');
INSERT INTO `notas` VALUES('6113', '1689', '6', '6.00', '2025-06-10', '1', '3');
INSERT INTO `notas` VALUES('6114', '1689', '6', '5.80', '2025-06-10', '1', '4');
INSERT INTO `notas` VALUES('6115', '1690', '6', '4.20', '2025-06-10', '1', '1');
INSERT INTO `notas` VALUES('6116', '1690', '6', '5.00', '2025-06-10', '1', '2');
INSERT INTO `notas` VALUES('6117', '1690', '6', '7.00', '2025-06-10', '1', '3');
INSERT INTO `notas` VALUES('6118', '1690', '6', '6.50', '2025-06-10', '1', '4');
INSERT INTO `notas` VALUES('6119', '1691', '6', '4.40', '2025-06-10', '1', '1');
INSERT INTO `notas` VALUES('6120', '1691', '6', '4.00', '2025-06-10', '1', '2');
INSERT INTO `notas` VALUES('6121', '1691', '6', '6.80', '2025-06-10', '1', '3');
INSERT INTO `notas` VALUES('6122', '1691', '6', '5.00', '2025-06-10', '1', '4');
INSERT INTO `notas` VALUES('6123', '1713', '4', '6.20', '2025-06-11', '1', '2');
INSERT INTO `notas` VALUES('6124', '1713', '4', '5.30', '2025-06-11', '1', '3');
INSERT INTO `notas` VALUES('6125', '1714', '4', '7.00', '2025-06-11', '1', '2');
INSERT INTO `notas` VALUES('6126', '1714', '4', '6.70', '2025-06-11', '1', '3');
INSERT INTO `notas` VALUES('6127', '1715', '4', '6.00', '2025-06-11', '1', '3');
INSERT INTO `notas` VALUES('6128', '1716', '4', '7.00', '2025-06-11', '1', '2');
INSERT INTO `notas` VALUES('6129', '1716', '4', '6.80', '2025-06-11', '1', '3');
INSERT INTO `notas` VALUES('6130', '1717', '4', '6.00', '2025-06-11', '1', '2');
INSERT INTO `notas` VALUES('6131', '1717', '4', '5.50', '2025-06-11', '1', '3');
INSERT INTO `notas` VALUES('6132', '1718', '4', '5.80', '2025-06-11', '1', '3');
INSERT INTO `notas` VALUES('6133', '1719', '4', '6.70', '2025-06-11', '1', '3');
INSERT INTO `notas` VALUES('6134', '1720', '4', '6.80', '2025-06-11', '1', '2');
INSERT INTO `notas` VALUES('6135', '1720', '4', '6.70', '2025-06-11', '1', '3');
INSERT INTO `notas` VALUES('6136', '1721', '4', '6.20', '2025-06-11', '1', '2');
INSERT INTO `notas` VALUES('6137', '1721', '4', '6.10', '2025-06-11', '1', '3');
INSERT INTO `notas` VALUES('6138', '1722', '4', '6.00', '2025-06-11', '1', '2');
INSERT INTO `notas` VALUES('6139', '1722', '4', '6.20', '2025-06-11', '1', '3');
INSERT INTO `notas` VALUES('6140', '1723', '4', '7.00', '2025-06-11', '1', '2');
INSERT INTO `notas` VALUES('6141', '1723', '4', '6.10', '2025-06-11', '1', '3');
INSERT INTO `notas` VALUES('6142', '1724', '4', '6.80', '2025-06-11', '1', '2');
INSERT INTO `notas` VALUES('6143', '1724', '4', '6.30', '2025-06-11', '1', '3');
INSERT INTO `notas` VALUES('6144', '1725', '4', '6.80', '2025-06-11', '1', '2');
INSERT INTO `notas` VALUES('6145', '1725', '4', '7.00', '2025-06-11', '1', '3');
INSERT INTO `notas` VALUES('6146', '1726', '4', '5.60', '2025-06-11', '1', '3');
INSERT INTO `notas` VALUES('6147', '1727', '4', '7.00', '2025-06-11', '1', '2');
INSERT INTO `notas` VALUES('6148', '1727', '4', '7.00', '2025-06-11', '1', '3');
INSERT INTO `notas` VALUES('6149', '1728', '4', '6.00', '2025-06-11', '1', '2');
INSERT INTO `notas` VALUES('6150', '1728', '4', '6.30', '2025-06-11', '1', '3');
INSERT INTO `notas` VALUES('6151', '1729', '4', '6.20', '2025-06-11', '1', '2');
INSERT INTO `notas` VALUES('6152', '1729', '4', '5.80', '2025-06-11', '1', '3');
INSERT INTO `notas` VALUES('6153', '1730', '4', '6.00', '2025-06-11', '1', '2');
INSERT INTO `notas` VALUES('6154', '1730', '4', '5.70', '2025-06-11', '1', '3');
INSERT INTO `notas` VALUES('6155', '1564', '5', '7.00', '2025-06-11', '1', '3');
INSERT INTO `notas` VALUES('6156', '1564', '5', '6.90', '2025-06-11', '1', '4');
INSERT INTO `notas` VALUES('6157', '1565', '5', '7.00', '2025-06-11', '1', '3');
INSERT INTO `notas` VALUES('6158', '1566', '5', '6.00', '2025-06-11', '1', '4');
INSERT INTO `notas` VALUES('6159', '1567', '5', '6.50', '2025-06-11', '1', '3');
INSERT INTO `notas` VALUES('6160', '1567', '5', '6.80', '2025-06-11', '1', '4');
INSERT INTO `notas` VALUES('6161', '1568', '5', '6.00', '2025-06-11', '1', '3');
INSERT INTO `notas` VALUES('6162', '1568', '5', '6.90', '2025-06-11', '1', '4');
INSERT INTO `notas` VALUES('6163', '1569', '5', '6.50', '2025-06-11', '1', '3');
INSERT INTO `notas` VALUES('6164', '1569', '5', '6.90', '2025-06-11', '1', '4');
INSERT INTO `notas` VALUES('6165', '1570', '5', '7.00', '2025-06-11', '1', '3');
INSERT INTO `notas` VALUES('6166', '1570', '5', '6.90', '2025-06-11', '1', '4');
INSERT INTO `notas` VALUES('6167', '1571', '5', '7.00', '2025-06-11', '1', '4');
INSERT INTO `notas` VALUES('6168', '1572', '5', '7.00', '2025-06-11', '1', '3');
INSERT INTO `notas` VALUES('6169', '1572', '5', '7.00', '2025-06-11', '1', '4');
INSERT INTO `notas` VALUES('6170', '1573', '5', '6.50', '2025-06-11', '1', '3');
INSERT INTO `notas` VALUES('6171', '1573', '5', '6.80', '2025-06-11', '1', '4');
INSERT INTO `notas` VALUES('6172', '1574', '5', '6.50', '2025-06-11', '1', '3');
INSERT INTO `notas` VALUES('6173', '1575', '5', '7.00', '2025-06-11', '1', '3');
INSERT INTO `notas` VALUES('6174', '1575', '5', '6.90', '2025-06-11', '1', '4');
INSERT INTO `notas` VALUES('6175', '1576', '5', '6.50', '2025-06-11', '1', '3');
INSERT INTO `notas` VALUES('6176', '1576', '5', '6.90', '2025-06-11', '1', '4');
INSERT INTO `notas` VALUES('6177', '1577', '5', '6.00', '2025-06-11', '1', '3');
INSERT INTO `notas` VALUES('6178', '1577', '5', '6.60', '2025-06-11', '1', '4');
INSERT INTO `notas` VALUES('6179', '1578', '5', '7.00', '2025-06-11', '1', '3');
INSERT INTO `notas` VALUES('6180', '1578', '5', '6.90', '2025-06-11', '1', '4');
INSERT INTO `notas` VALUES('6181', '1579', '5', '6.00', '2025-06-11', '1', '3');
INSERT INTO `notas` VALUES('6182', '1579', '5', '6.70', '2025-06-11', '1', '4');
INSERT INTO `notas` VALUES('6183', '1580', '5', '6.50', '2025-06-11', '1', '3');
INSERT INTO `notas` VALUES('6184', '1580', '5', '6.90', '2025-06-11', '1', '4');
INSERT INTO `notas` VALUES('6185', '1581', '5', '7.00', '2025-06-11', '1', '4');
INSERT INTO `notas` VALUES('6186', '1582', '5', '6.00', '2025-06-11', '1', '3');
INSERT INTO `notas` VALUES('6187', '1582', '5', '6.00', '2025-06-11', '1', '4');
INSERT INTO `notas` VALUES('6188', '1583', '5', '6.00', '2025-06-11', '1', '3');
INSERT INTO `notas` VALUES('6189', '1583', '5', '6.70', '2025-06-11', '1', '4');
INSERT INTO `notas` VALUES('6190', '1584', '5', '6.50', '2025-06-11', '1', '3');
INSERT INTO `notas` VALUES('6191', '1542', '5', '7.00', '2025-06-11', '1', '4');
INSERT INTO `notas` VALUES('6192', '1543', '5', '6.80', '2025-06-11', '1', '4');
INSERT INTO `notas` VALUES('6193', '1544', '5', '6.00', '2025-06-11', '1', '4');
INSERT INTO `notas` VALUES('6194', '1545', '5', '6.80', '2025-06-11', '1', '4');
INSERT INTO `notas` VALUES('6195', '1546', '5', '6.90', '2025-06-11', '1', '4');
INSERT INTO `notas` VALUES('6196', '1547', '5', '6.50', '2025-06-11', '1', '4');
INSERT INTO `notas` VALUES('6197', '1548', '5', '6.90', '2025-06-11', '1', '4');
INSERT INTO `notas` VALUES('6198', '1550', '5', '6.70', '2025-06-11', '1', '4');
INSERT INTO `notas` VALUES('6199', '1551', '5', '6.80', '2025-06-11', '1', '4');
INSERT INTO `notas` VALUES('6200', '1552', '5', '7.00', '2025-06-11', '1', '4');
INSERT INTO `notas` VALUES('6201', '1554', '5', '6.40', '2025-06-11', '1', '4');
INSERT INTO `notas` VALUES('6202', '1555', '5', '6.40', '2025-06-11', '1', '4');
INSERT INTO `notas` VALUES('6203', '1556', '5', '6.50', '2025-06-11', '1', '4');
INSERT INTO `notas` VALUES('6204', '1557', '5', '6.10', '2025-06-11', '1', '4');
INSERT INTO `notas` VALUES('6205', '1558', '5', '7.00', '2025-06-11', '1', '4');
INSERT INTO `notas` VALUES('6206', '1559', '5', '6.80', '2025-06-11', '1', '4');
INSERT INTO `notas` VALUES('6207', '1560', '5', '6.60', '2025-06-11', '1', '4');
INSERT INTO `notas` VALUES('6208', '1561', '5', '6.50', '2025-06-11', '1', '4');
INSERT INTO `notas` VALUES('6209', '1562', '5', '6.30', '2025-06-11', '1', '4');
INSERT INTO `notas` VALUES('6210', '1563', '5', '6.00', '2025-06-11', '1', '4');
INSERT INTO `notas` VALUES('6211', '1542', '5', '6.00', '2025-06-11', '1', '3');
INSERT INTO `notas` VALUES('6212', '1543', '5', '6.00', '2025-06-11', '1', '3');
INSERT INTO `notas` VALUES('6213', '1544', '5', '6.00', '2025-06-11', '1', '3');
INSERT INTO `notas` VALUES('6214', '1545', '5', '7.00', '2025-06-11', '1', '3');
INSERT INTO `notas` VALUES('6215', '1546', '5', '7.00', '2025-06-11', '1', '3');
INSERT INTO `notas` VALUES('6216', '1547', '5', '6.50', '2025-06-11', '1', '3');
INSERT INTO `notas` VALUES('6217', '1548', '5', '6.00', '2025-06-11', '1', '3');
INSERT INTO `notas` VALUES('6218', '1549', '5', '6.50', '2025-06-11', '1', '3');
INSERT INTO `notas` VALUES('6219', '1550', '5', '6.80', '2025-06-11', '1', '3');
INSERT INTO `notas` VALUES('6220', '1551', '5', '6.00', '2025-06-11', '1', '3');
INSERT INTO `notas` VALUES('6221', '1552', '5', '6.00', '2025-06-11', '1', '3');
INSERT INTO `notas` VALUES('6222', '1554', '5', '7.00', '2025-06-11', '1', '3');
INSERT INTO `notas` VALUES('6223', '1555', '5', '7.00', '2025-06-11', '1', '3');
INSERT INTO `notas` VALUES('6224', '1556', '5', '7.00', '2025-06-11', '1', '3');
INSERT INTO `notas` VALUES('6225', '1557', '5', '6.00', '2025-06-11', '1', '3');
INSERT INTO `notas` VALUES('6226', '1558', '5', '6.00', '2025-06-11', '1', '3');
INSERT INTO `notas` VALUES('6227', '1559', '5', '6.30', '2025-06-11', '1', '3');
INSERT INTO `notas` VALUES('6228', '1560', '5', '7.00', '2025-06-11', '1', '3');
INSERT INTO `notas` VALUES('6229', '1561', '5', '6.00', '2025-06-11', '1', '3');
INSERT INTO `notas` VALUES('6230', '1562', '5', '6.50', '2025-06-11', '1', '3');
INSERT INTO `notas` VALUES('6231', '1563', '5', '6.00', '2025-06-11', '1', '3');
INSERT INTO `notas` VALUES('6232', '1735', '11', '6.30', '2025-06-11', '1', '6');
INSERT INTO `notas` VALUES('6233', '1731', '12', '6.20', '2025-06-11', '1', '3');
INSERT INTO `notas` VALUES('6234', '1732', '12', '7.00', '2025-06-11', '1', '3');
INSERT INTO `notas` VALUES('6235', '1733', '12', '5.00', '2025-06-11', '1', '3');
INSERT INTO `notas` VALUES('6236', '1734', '12', '6.60', '2025-06-11', '1', '3');
INSERT INTO `notas` VALUES('6237', '1735', '12', '6.30', '2025-06-11', '1', '3');
INSERT INTO `notas` VALUES('6238', '1736', '12', '6.30', '2025-06-11', '1', '3');
INSERT INTO `notas` VALUES('6239', '1737', '12', '6.60', '2025-06-11', '1', '3');
INSERT INTO `notas` VALUES('6240', '1738', '12', '6.50', '2025-06-11', '1', '3');
INSERT INTO `notas` VALUES('6241', '1739', '12', '5.50', '2025-06-11', '1', '3');
INSERT INTO `notas` VALUES('6242', '1740', '12', '7.00', '2025-06-11', '1', '3');
INSERT INTO `notas` VALUES('6243', '1741', '12', '6.40', '2025-06-11', '1', '3');
INSERT INTO `notas` VALUES('6244', '1742', '12', '6.50', '2025-06-11', '1', '3');
INSERT INTO `notas` VALUES('6245', '1743', '12', '6.50', '2025-06-11', '1', '3');
INSERT INTO `notas` VALUES('6246', '1744', '12', '6.60', '2025-06-11', '1', '3');
INSERT INTO `notas` VALUES('6247', '1745', '12', '5.50', '2025-06-11', '1', '3');
INSERT INTO `notas` VALUES('6248', '1746', '12', '5.50', '2025-06-11', '1', '3');
INSERT INTO `notas` VALUES('6249', '1747', '12', '5.50', '2025-06-11', '1', '3');
INSERT INTO `notas` VALUES('6250', '1748', '12', '7.00', '2025-06-11', '1', '3');
INSERT INTO `notas` VALUES('6251', '1749', '12', '6.00', '2025-06-11', '1', '3');
INSERT INTO `notas` VALUES('6252', '1750', '12', '6.00', '2025-06-11', '1', '3');
INSERT INTO `notas` VALUES('6253', '1731', '4', '6.20', '2025-06-11', '1', '3');
INSERT INTO `notas` VALUES('6254', '1732', '4', '7.00', '2025-06-11', '1', '2');
INSERT INTO `notas` VALUES('6255', '1732', '4', '7.00', '2025-06-11', '1', '3');
INSERT INTO `notas` VALUES('6256', '1733', '4', '6.50', '2025-06-11', '1', '2');
INSERT INTO `notas` VALUES('6257', '1733', '4', '5.00', '2025-06-11', '1', '3');
INSERT INTO `notas` VALUES('6258', '1734', '4', '6.80', '2025-06-11', '1', '2');
INSERT INTO `notas` VALUES('6259', '1734', '4', '6.30', '2025-06-11', '1', '3');
INSERT INTO `notas` VALUES('6260', '1735', '4', '6.00', '2025-06-11', '1', '2');
INSERT INTO `notas` VALUES('6261', '1735', '4', '6.30', '2025-06-11', '1', '3');
INSERT INTO `notas` VALUES('6262', '1736', '4', '6.00', '2025-06-11', '1', '2');
INSERT INTO `notas` VALUES('6263', '1736', '4', '6.20', '2025-06-11', '1', '3');
INSERT INTO `notas` VALUES('6264', '1737', '4', '6.40', '2025-06-11', '1', '2');
INSERT INTO `notas` VALUES('6265', '1737', '4', '6.30', '2025-06-11', '1', '3');
INSERT INTO `notas` VALUES('6266', '1738', '4', '7.00', '2025-06-11', '1', '2');
INSERT INTO `notas` VALUES('6267', '1738', '4', '6.00', '2025-06-11', '1', '3');
INSERT INTO `notas` VALUES('6268', '1739', '4', '6.40', '2025-06-11', '1', '2');
INSERT INTO `notas` VALUES('6269', '1739', '4', '5.50', '2025-06-11', '1', '3');
INSERT INTO `notas` VALUES('6270', '1740', '4', '7.00', '2025-06-11', '1', '2');
INSERT INTO `notas` VALUES('6271', '1740', '4', '6.60', '2025-06-11', '1', '3');
INSERT INTO `notas` VALUES('6272', '1741', '4', '6.50', '2025-06-11', '1', '2');
INSERT INTO `notas` VALUES('6273', '1741', '4', '6.40', '2025-06-11', '1', '3');
INSERT INTO `notas` VALUES('6274', '1742', '4', '6.80', '2025-06-11', '1', '2');
INSERT INTO `notas` VALUES('6275', '1742', '4', '6.10', '2025-06-11', '1', '3');
INSERT INTO `notas` VALUES('6276', '1743', '4', '7.00', '2025-06-11', '1', '2');
INSERT INTO `notas` VALUES('6277', '1743', '4', '6.20', '2025-06-11', '1', '3');
INSERT INTO `notas` VALUES('6278', '1744', '4', '6.40', '2025-06-11', '1', '2');
INSERT INTO `notas` VALUES('6279', '1744', '4', '6.40', '2025-06-11', '1', '3');
INSERT INTO `notas` VALUES('6280', '1745', '4', '5.00', '2025-06-11', '1', '3');
INSERT INTO `notas` VALUES('6281', '1746', '4', '6.50', '2025-06-11', '1', '2');
INSERT INTO `notas` VALUES('6282', '1746', '4', '5.40', '2025-06-11', '1', '3');
INSERT INTO `notas` VALUES('6283', '1747', '4', '7.00', '2025-06-11', '1', '2');
INSERT INTO `notas` VALUES('6284', '1747', '4', '7.00', '2025-06-11', '1', '3');
INSERT INTO `notas` VALUES('6285', '1748', '4', '7.00', '2025-06-11', '1', '2');
INSERT INTO `notas` VALUES('6286', '1748', '4', '6.80', '2025-06-11', '1', '3');
INSERT INTO `notas` VALUES('6287', '1749', '4', '6.00', '2025-06-11', '1', '2');
INSERT INTO `notas` VALUES('6288', '1749', '4', '5.40', '2025-06-11', '1', '3');
INSERT INTO `notas` VALUES('6289', '1750', '4', '6.00', '2025-06-11', '1', '2');
INSERT INTO `notas` VALUES('6290', '1750', '4', '5.70', '2025-06-11', '1', '3');
INSERT INTO `notas` VALUES('6291', '1715', '4', '6.00', '2025-06-12', '1', '2');
INSERT INTO `notas` VALUES('6292', '1718', '4', '6.00', '2025-06-12', '1', '2');
INSERT INTO `notas` VALUES('6293', '1719', '4', '6.00', '2025-06-12', '1', '2');
INSERT INTO `notas` VALUES('6294', '1726', '4', '6.00', '2025-06-12', '1', '2');
INSERT INTO `notas` VALUES('6295', '1713', '6', '5.40', '2025-06-12', '1', '2');
INSERT INTO `notas` VALUES('6296', '1713', '6', '7.00', '2025-06-12', '1', '3');
INSERT INTO `notas` VALUES('6297', '1713', '6', '5.30', '2025-06-12', '1', '4');
INSERT INTO `notas` VALUES('6298', '1714', '6', '7.00', '2025-06-12', '1', '3');
INSERT INTO `notas` VALUES('6299', '1714', '6', '6.70', '2025-06-12', '1', '4');
INSERT INTO `notas` VALUES('6300', '1715', '6', '5.70', '2025-06-12', '1', '2');
INSERT INTO `notas` VALUES('6301', '1715', '6', '6.00', '2025-06-12', '1', '3');
INSERT INTO `notas` VALUES('6302', '1715', '6', '6.00', '2025-06-12', '1', '4');
INSERT INTO `notas` VALUES('6303', '1716', '6', '7.00', '2025-06-12', '1', '3');
INSERT INTO `notas` VALUES('6304', '1716', '6', '6.80', '2025-06-12', '1', '4');
INSERT INTO `notas` VALUES('6305', '1717', '6', '7.00', '2025-06-12', '1', '3');
INSERT INTO `notas` VALUES('6306', '1717', '6', '5.50', '2025-06-12', '1', '4');
INSERT INTO `notas` VALUES('6307', '1718', '6', '7.00', '2025-06-12', '1', '3');
INSERT INTO `notas` VALUES('6308', '1718', '6', '5.80', '2025-06-12', '1', '4');
INSERT INTO `notas` VALUES('6309', '1719', '6', '5.10', '2025-06-12', '1', '2');
INSERT INTO `notas` VALUES('6310', '1719', '6', '6.70', '2025-06-12', '1', '4');
INSERT INTO `notas` VALUES('6311', '1720', '6', '7.00', '2025-06-12', '1', '3');
INSERT INTO `notas` VALUES('6312', '1720', '6', '6.70', '2025-06-12', '1', '4');
INSERT INTO `notas` VALUES('6313', '1721', '6', '7.00', '2025-06-12', '1', '3');
INSERT INTO `notas` VALUES('6314', '1721', '6', '6.10', '2025-06-12', '1', '4');
INSERT INTO `notas` VALUES('6315', '1722', '6', '6.20', '2025-06-12', '1', '3');
INSERT INTO `notas` VALUES('6316', '1722', '6', '6.20', '2025-06-12', '1', '4');
INSERT INTO `notas` VALUES('6317', '1723', '6', '7.00', '2025-06-12', '1', '3');
INSERT INTO `notas` VALUES('6318', '1723', '6', '6.10', '2025-06-12', '1', '4');
INSERT INTO `notas` VALUES('6319', '1724', '6', '7.00', '2025-06-12', '1', '3');
INSERT INTO `notas` VALUES('6320', '1724', '6', '6.30', '2025-06-12', '1', '4');
INSERT INTO `notas` VALUES('6321', '1725', '6', '7.00', '2025-06-12', '1', '3');
INSERT INTO `notas` VALUES('6322', '1725', '6', '5.90', '2025-06-12', '1', '4');
INSERT INTO `notas` VALUES('6323', '1726', '6', '6.00', '2025-06-12', '1', '3');
INSERT INTO `notas` VALUES('6324', '1726', '6', '5.60', '2025-06-12', '1', '4');
INSERT INTO `notas` VALUES('6325', '1727', '6', '7.00', '2025-06-12', '1', '3');
INSERT INTO `notas` VALUES('6326', '1727', '6', '7.00', '2025-06-12', '1', '4');
INSERT INTO `notas` VALUES('6327', '1728', '6', '7.00', '2025-06-12', '1', '3');
INSERT INTO `notas` VALUES('6328', '1728', '6', '6.30', '2025-06-12', '1', '4');
INSERT INTO `notas` VALUES('6329', '1729', '6', '6.50', '2025-06-12', '1', '3');
INSERT INTO `notas` VALUES('6330', '1729', '6', '5.80', '2025-06-12', '1', '4');
INSERT INTO `notas` VALUES('6331', '1730', '6', '6.30', '2025-06-12', '1', '3');
INSERT INTO `notas` VALUES('6332', '1730', '6', '5.70', '2025-06-12', '1', '4');
INSERT INTO `notas` VALUES('6333', '1676', '11', '4.20', '2025-06-12', '1', '5');
INSERT INTO `notas` VALUES('6334', '1676', '11', '5.90', '2025-06-12', '1', '6');
INSERT INTO `notas` VALUES('6335', '1676', '6', '5.50', '2025-06-12', '1', '3');
INSERT INTO `notas` VALUES('6336', '1676', '6', '5.90', '2025-06-12', '1', '4');
INSERT INTO `notas` VALUES('6337', '1844', '5', '7.00', '2025-06-12', '1', '4');
INSERT INTO `notas` VALUES('6338', '1845', '5', '6.60', '2025-06-12', '1', '4');
INSERT INTO `notas` VALUES('6339', '1846', '5', '6.00', '2025-06-12', '1', '4');
INSERT INTO `notas` VALUES('6340', '1847', '5', '6.30', '2025-06-12', '1', '4');
INSERT INTO `notas` VALUES('6341', '1848', '5', '6.70', '2025-06-12', '1', '4');
INSERT INTO `notas` VALUES('6342', '1849', '5', '6.50', '2025-06-12', '1', '4');
INSERT INTO `notas` VALUES('6343', '1850', '5', '6.10', '2025-06-12', '1', '4');
INSERT INTO `notas` VALUES('6344', '1851', '5', '6.30', '2025-06-12', '1', '4');
INSERT INTO `notas` VALUES('6345', '1852', '5', '6.70', '2025-06-12', '1', '4');
INSERT INTO `notas` VALUES('6346', '1853', '5', '7.00', '2025-06-12', '1', '4');
INSERT INTO `notas` VALUES('6347', '1854', '5', '6.00', '2025-06-12', '1', '4');
INSERT INTO `notas` VALUES('6348', '1855', '5', '6.80', '2025-06-12', '1', '4');
INSERT INTO `notas` VALUES('6349', '1856', '5', '6.80', '2025-06-12', '1', '4');
INSERT INTO `notas` VALUES('6350', '1857', '5', '6.50', '2025-06-12', '1', '4');
INSERT INTO `notas` VALUES('6351', '1858', '5', '6.30', '2025-06-12', '1', '4');
INSERT INTO `notas` VALUES('6352', '1877', '5', '7.00', '2025-06-12', '1', '3');
INSERT INTO `notas` VALUES('6353', '1859', '5', '6.60', '2025-06-12', '1', '4');
INSERT INTO `notas` VALUES('6354', '1861', '5', '6.70', '2025-06-12', '1', '4');
INSERT INTO `notas` VALUES('6355', '1862', '5', '6.80', '2025-06-12', '1', '4');
INSERT INTO `notas` VALUES('6356', '1863', '5', '7.00', '2025-06-12', '1', '4');
INSERT INTO `notas` VALUES('6357', '1877', '5', '6.80', '2025-06-12', '1', '4');
INSERT INTO `notas` VALUES('6358', '1864', '5', '6.00', '2025-06-12', '1', '4');
INSERT INTO `notas` VALUES('6359', '1865', '5', '6.40', '2025-06-12', '1', '4');
INSERT INTO `notas` VALUES('6360', '1866', '5', '6.00', '2025-06-12', '1', '4');
INSERT INTO `notas` VALUES('6361', '1867', '5', '7.00', '2025-06-12', '1', '4');
INSERT INTO `notas` VALUES('6362', '1868', '5', '6.80', '2025-06-12', '1', '4');
INSERT INTO `notas` VALUES('6363', '1869', '5', '6.90', '2025-06-12', '1', '4');
INSERT INTO `notas` VALUES('6364', '1871', '5', '6.30', '2025-06-12', '1', '4');
INSERT INTO `notas` VALUES('6365', '1872', '5', '6.10', '2025-06-12', '1', '4');
INSERT INTO `notas` VALUES('6366', '1873', '5', '6.60', '2025-06-12', '1', '4');
INSERT INTO `notas` VALUES('6367', '1874', '5', '6.70', '2025-06-12', '1', '4');
INSERT INTO `notas` VALUES('6368', '1876', '5', '7.00', '2025-06-12', '1', '4');
INSERT INTO `notas` VALUES('6369', '1950', '6', '5.90', '2025-06-13', '1', '4');
INSERT INTO `notas` VALUES('6370', '1959', '6', '5.80', '2025-06-13', '1', '4');
INSERT INTO `notas` VALUES('6371', '1965', '6', '5.60', '2025-06-13', '1', '4');
INSERT INTO `notas` VALUES('6372', '1970', '6', '5.50', '2025-06-13', '1', '4');
INSERT INTO `notas` VALUES('6373', '1982', '6', '6.10', '2025-06-13', '1', '4');
INSERT INTO `notas` VALUES('6374', '1983', '6', '4.80', '2025-06-13', '1', '4');
INSERT INTO `notas` VALUES('6375', '1676', '12', '5.90', '2025-06-13', '1', '3');
INSERT INTO `notas` VALUES('6376', '1675', '3', '4.00', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6377', '1675', '3', '4.80', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6378', '1676', '3', '6.00', '2025-06-16', '1', '2');
INSERT INTO `notas` VALUES('6379', '1676', '3', '5.50', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6380', '1676', '3', '5.80', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6381', '1677', '3', '7.00', '2025-06-16', '1', '1');
INSERT INTO `notas` VALUES('6382', '1677', '3', '7.00', '2025-06-16', '1', '2');
INSERT INTO `notas` VALUES('6383', '1677', '3', '7.00', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6384', '1677', '3', '5.70', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6385', '1678', '3', '7.00', '2025-06-16', '1', '1');
INSERT INTO `notas` VALUES('6386', '1678', '3', '6.00', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6387', '1678', '3', '5.40', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6388', '1679', '3', '7.00', '2025-06-16', '1', '1');
INSERT INTO `notas` VALUES('6389', '1679', '3', '7.00', '2025-06-16', '1', '2');
INSERT INTO `notas` VALUES('6390', '1679', '3', '5.00', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6391', '1679', '3', '5.10', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6392', '1680', '3', '6.80', '2025-06-16', '1', '2');
INSERT INTO `notas` VALUES('6393', '1680', '3', '6.00', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6394', '1680', '3', '5.60', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6395', '1681', '3', '6.00', '2025-06-16', '1', '2');
INSERT INTO `notas` VALUES('6396', '1681', '3', '7.00', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6397', '1681', '3', '5.00', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6398', '1682', '3', '6.00', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6399', '1682', '3', '5.80', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6400', '1683', '3', '6.80', '2025-06-16', '1', '2');
INSERT INTO `notas` VALUES('6401', '1683', '3', '5.00', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6402', '1683', '3', '4.70', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6403', '1684', '3', '7.00', '2025-06-16', '1', '2');
INSERT INTO `notas` VALUES('6404', '1684', '3', '6.50', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6405', '1684', '3', '5.90', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6406', '1685', '3', '4.80', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6407', '1685', '3', '4.90', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6408', '1686', '3', '5.00', '2025-06-16', '1', '1');
INSERT INTO `notas` VALUES('6409', '1686', '3', '5.00', '2025-06-16', '1', '2');
INSERT INTO `notas` VALUES('6410', '1686', '3', '4.00', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6411', '1686', '3', '4.70', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6412', '1687', '3', '4.50', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6413', '1687', '3', '4.00', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6414', '1688', '3', '6.00', '2025-06-16', '1', '1');
INSERT INTO `notas` VALUES('6415', '1688', '3', '6.00', '2025-06-16', '1', '2');
INSERT INTO `notas` VALUES('6416', '1688', '3', '5.50', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6417', '1688', '3', '5.50', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6418', '1689', '3', '5.00', '2025-06-16', '1', '2');
INSERT INTO `notas` VALUES('6419', '1689', '3', '5.50', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6420', '1689', '3', '4.60', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6421', '1690', '3', '7.00', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6422', '1690', '3', '6.50', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6423', '1691', '3', '6.00', '2025-06-16', '1', '2');
INSERT INTO `notas` VALUES('6424', '1691', '3', '4.50', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6425', '1691', '3', '4.70', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6426', '1878', '5', '6.10', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6427', '1884', '5', '6.80', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6428', '1886', '5', '6.80', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6429', '1888', '5', '6.60', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6430', '1889', '5', '6.90', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6431', '1890', '5', '6.90', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6432', '1891', '5', '6.00', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6433', '1894', '5', '6.20', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6434', '1895', '5', '6.40', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6435', '1878', '5', '7.00', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6436', '1879', '5', '6.30', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6437', '1880', '5', '7.00', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6438', '1881', '5', '7.00', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6439', '1882', '5', '7.00', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6440', '1883', '5', '6.30', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6441', '1884', '5', '6.30', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6442', '1885', '5', '6.00', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6443', '1886', '5', '7.00', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6444', '1887', '5', '7.00', '2025-06-16', '1', '1');
INSERT INTO `notas` VALUES('6445', '1887', '5', '7.00', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6446', '1888', '5', '7.00', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6447', '1889', '5', '6.50', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6448', '1890', '5', '6.00', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6449', '1891', '5', '7.00', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6450', '1892', '5', '7.00', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6451', '1894', '5', '7.00', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6452', '1895', '5', '6.00', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6453', '1896', '5', '7.00', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6454', '1897', '5', '7.00', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6455', '1879', '5', '7.00', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6456', '1880', '5', '6.00', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6457', '1881', '5', '6.50', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6458', '1882', '5', '7.00', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6459', '1883', '5', '6.50', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6460', '1885', '5', '7.00', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6461', '1887', '5', '7.00', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6462', '1892', '5', '6.50', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6463', '1896', '5', '6.00', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6464', '1897', '5', '7.00', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6465', '1448', '5', '6.00', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6466', '1448', '5', '6.50', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6467', '1449', '5', '6.00', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6468', '1449', '5', '6.50', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6469', '1825', '5', '6.00', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6470', '1825', '5', '6.50', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6471', '1450', '5', '7.00', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6472', '1450', '5', '7.00', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6473', '1451', '5', '7.00', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6474', '1451', '5', '7.00', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6475', '1453', '5', '7.00', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6476', '1453', '5', '7.00', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6477', '1455', '5', '7.00', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6478', '1455', '5', '7.00', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6479', '1456', '5', '6.00', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6480', '1456', '5', '6.50', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6481', '1457', '5', '7.00', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6482', '1457', '5', '7.00', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6483', '1843', '5', '6.00', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6484', '1843', '5', '7.00', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6485', '1458', '5', '6.00', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6486', '1458', '5', '6.50', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6487', '1459', '5', '6.00', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6488', '1459', '5', '7.00', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6489', '1842', '5', '6.00', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6490', '1842', '5', '7.00', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6491', '1460', '5', '6.00', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6492', '1460', '5', '7.00', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6493', '1461', '5', '7.00', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6494', '1461', '5', '7.00', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6495', '1462', '5', '6.00', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6496', '1462', '5', '7.00', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6497', '1463', '5', '7.00', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6498', '1463', '5', '7.00', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6499', '1464', '5', '6.50', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6500', '1464', '5', '7.00', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6501', '1988', '5', '7.00', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6502', '1988', '5', '7.00', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6503', '1467', '5', '7.00', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6504', '1467', '5', '7.00', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6505', '1948', '3', '5.00', '2025-06-16', '1', '2');
INSERT INTO `notas` VALUES('6506', '1948', '3', '6.00', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6507', '1948', '3', '6.00', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6508', '1949', '3', '5.80', '2025-06-16', '1', '2');
INSERT INTO `notas` VALUES('6509', '1949', '3', '5.80', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6510', '1949', '3', '5.20', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6511', '1950', '3', '6.00', '2025-06-16', '1', '2');
INSERT INTO `notas` VALUES('6512', '1950', '3', '5.50', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6513', '1950', '3', '5.80', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6514', '1951', '3', '5.50', '2025-06-16', '1', '2');
INSERT INTO `notas` VALUES('6515', '1951', '3', '6.00', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6516', '1951', '3', '5.80', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6517', '1952', '3', '6.00', '2025-06-16', '1', '2');
INSERT INTO `notas` VALUES('6518', '1952', '3', '5.50', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6519', '1952', '3', '5.60', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6520', '1953', '3', '7.00', '2025-06-16', '1', '2');
INSERT INTO `notas` VALUES('6521', '1953', '3', '7.00', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6522', '1953', '3', '6.80', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6523', '1954', '3', '6.00', '2025-06-16', '1', '2');
INSERT INTO `notas` VALUES('6524', '1954', '3', '5.80', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6525', '1954', '3', '5.50', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6526', '1956', '3', '4.00', '2025-06-16', '1', '2');
INSERT INTO `notas` VALUES('6527', '1956', '3', '4.00', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6528', '1956', '3', '4.40', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6529', '1957', '3', '4.00', '2025-06-16', '1', '2');
INSERT INTO `notas` VALUES('6530', '1957', '3', '4.00', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6531', '1957', '3', '4.00', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6532', '1958', '3', '7.00', '2025-06-16', '1', '2');
INSERT INTO `notas` VALUES('6533', '1958', '3', '7.00', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6534', '1958', '3', '6.90', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6535', '1959', '3', '4.30', '2025-06-16', '1', '2');
INSERT INTO `notas` VALUES('6536', '1959', '3', '5.80', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6537', '1959', '3', '5.20', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6538', '1960', '3', '5.00', '2025-06-16', '1', '2');
INSERT INTO `notas` VALUES('6539', '1960', '3', '7.00', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6540', '1960', '3', '6.70', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6541', '1961', '3', '6.00', '2025-06-16', '1', '2');
INSERT INTO `notas` VALUES('6542', '1961', '3', '6.20', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6543', '1961', '3', '5.50', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6544', '1962', '3', '7.00', '2025-06-16', '1', '2');
INSERT INTO `notas` VALUES('6545', '1962', '3', '7.00', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6546', '1962', '3', '6.50', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6547', '1963', '3', '6.50', '2025-06-16', '1', '2');
INSERT INTO `notas` VALUES('6548', '1963', '3', '7.00', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6549', '1963', '3', '5.20', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6550', '1964', '3', '4.30', '2025-06-16', '1', '2');
INSERT INTO `notas` VALUES('6551', '1964', '3', '6.00', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6552', '1964', '3', '5.90', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6553', '1965', '3', '4.00', '2025-06-16', '1', '2');
INSERT INTO `notas` VALUES('6554', '1965', '3', '6.00', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6555', '1965', '3', '5.60', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6556', '1966', '3', '5.80', '2025-06-16', '1', '2');
INSERT INTO `notas` VALUES('6557', '1966', '3', '6.00', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6558', '1966', '3', '5.70', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6559', '1967', '3', '5.00', '2025-06-16', '1', '2');
INSERT INTO `notas` VALUES('6560', '1967', '3', '6.00', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6561', '1967', '3', '5.60', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6562', '1968', '3', '4.30', '2025-06-16', '1', '2');
INSERT INTO `notas` VALUES('6563', '1968', '3', '6.00', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6564', '1968', '3', '5.60', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6565', '1969', '3', '5.00', '2025-06-16', '1', '2');
INSERT INTO `notas` VALUES('6566', '1969', '3', '5.80', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6567', '1969', '3', '4.80', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6568', '1970', '3', '5.60', '2025-06-16', '1', '2');
INSERT INTO `notas` VALUES('6569', '1970', '3', '6.00', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6570', '1970', '3', '6.00', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6571', '1971', '3', '5.50', '2025-06-16', '1', '2');
INSERT INTO `notas` VALUES('6572', '1971', '3', '5.50', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6573', '1971', '3', '4.60', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6574', '1972', '3', '4.30', '2025-06-16', '1', '2');
INSERT INTO `notas` VALUES('6575', '1972', '3', '6.50', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6576', '1972', '3', '6.40', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6577', '1973', '3', '6.00', '2025-06-16', '1', '2');
INSERT INTO `notas` VALUES('6578', '1973', '3', '6.00', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6579', '1973', '3', '5.60', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6580', '1975', '3', '5.00', '2025-06-16', '1', '2');
INSERT INTO `notas` VALUES('6581', '1975', '3', '6.20', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6582', '1975', '3', '4.80', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6583', '1976', '3', '5.20', '2025-06-16', '1', '2');
INSERT INTO `notas` VALUES('6584', '1976', '3', '7.00', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6585', '1976', '3', '6.70', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6586', '1977', '3', '5.60', '2025-06-16', '1', '2');
INSERT INTO `notas` VALUES('6587', '1977', '3', '6.20', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6588', '1977', '3', '6.70', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6589', '1978', '3', '7.00', '2025-06-16', '1', '2');
INSERT INTO `notas` VALUES('6590', '1978', '3', '7.00', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6591', '1978', '3', '7.00', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6592', '1979', '3', '4.00', '2025-06-16', '1', '1');
INSERT INTO `notas` VALUES('6593', '1979', '3', '4.00', '2025-06-16', '1', '2');
INSERT INTO `notas` VALUES('6594', '1979', '3', '4.00', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6595', '1979', '3', '4.70', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6596', '1980', '3', '7.00', '2025-06-16', '1', '2');
INSERT INTO `notas` VALUES('6597', '1980', '3', '7.00', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6598', '1980', '3', '6.60', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6599', '1981', '3', '5.00', '2025-06-16', '1', '2');
INSERT INTO `notas` VALUES('6600', '1981', '3', '6.80', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6601', '1981', '3', '5.80', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6602', '1982', '3', '6.00', '2025-06-16', '1', '1');
INSERT INTO `notas` VALUES('6603', '1982', '3', '6.00', '2025-06-16', '1', '2');
INSERT INTO `notas` VALUES('6604', '1982', '3', '6.00', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6605', '1982', '3', '6.00', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6606', '1983', '3', '5.00', '2025-06-16', '1', '2');
INSERT INTO `notas` VALUES('6607', '1983', '3', '4.00', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6608', '1983', '3', '5.00', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6609', '1984', '3', '4.50', '2025-06-16', '1', '2');
INSERT INTO `notas` VALUES('6610', '1984', '3', '6.00', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6611', '1984', '3', '6.50', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6612', '1985', '3', '6.00', '2025-06-16', '1', '2');
INSERT INTO `notas` VALUES('6613', '1985', '3', '6.20', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6614', '1985', '3', '6.00', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6615', '1986', '3', '5.00', '2025-06-16', '1', '2');
INSERT INTO `notas` VALUES('6616', '1986', '3', '5.00', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6617', '1986', '3', '4.90', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6618', '1987', '3', '7.00', '2025-06-16', '1', '2');
INSERT INTO `notas` VALUES('6619', '1987', '3', '7.00', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6620', '1987', '3', '7.00', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6621', '1542', '3', '6.10', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6622', '1543', '3', '6.00', '2025-06-16', '1', '2');
INSERT INTO `notas` VALUES('6623', '1543', '3', '7.00', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6624', '1543', '3', '6.60', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6625', '1544', '3', '6.40', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6626', '1545', '3', '6.60', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6627', '1546', '3', '6.40', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6628', '1547', '3', '6.40', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6629', '1548', '3', '6.10', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6630', '1549', '3', '6.00', '2025-06-16', '1', '2');
INSERT INTO `notas` VALUES('6631', '1549', '3', '7.00', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6632', '1549', '3', '5.20', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6633', '1550', '3', '4.80', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6634', '1551', '3', '5.40', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6635', '1552', '3', '6.00', '2025-06-16', '1', '2');
INSERT INTO `notas` VALUES('6636', '1552', '3', '7.00', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6637', '1552', '3', '6.10', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6638', '1553', '3', '4.00', '2025-06-16', '1', '2');
INSERT INTO `notas` VALUES('6639', '1553', '3', '4.00', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6640', '1553', '3', '4.00', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6641', '1554', '3', '5.80', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6642', '1555', '3', '6.00', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6643', '1556', '3', '6.10', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6644', '1557', '3', '6.00', '2025-06-16', '1', '2');
INSERT INTO `notas` VALUES('6645', '1557', '3', '7.00', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6646', '1557', '3', '4.40', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6647', '1558', '3', '5.90', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6648', '1559', '3', '6.10', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6649', '1560', '3', '5.80', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6650', '1561', '3', '5.90', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6651', '1562', '3', '6.10', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6652', '1563', '3', '5.90', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6653', '1898', '5', '7.00', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6654', '1899', '5', '7.00', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6655', '1900', '5', '7.00', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6656', '1901', '5', '7.00', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6657', '1902', '5', '7.00', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6658', '1920', '5', '7.00', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6659', '1919', '5', '7.00', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6660', '1903', '5', '7.00', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6661', '1904', '5', '7.00', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6662', '1905', '5', '7.00', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6663', '1906', '5', '7.00', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6664', '1907', '5', '7.00', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6665', '1908', '5', '7.00', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6666', '1909', '5', '7.00', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6667', '1910', '5', '7.00', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6668', '1911', '5', '7.00', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6669', '1912', '5', '7.00', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6670', '1913', '5', '7.00', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6671', '1914', '5', '7.00', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6672', '1915', '5', '7.00', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6673', '1916', '5', '7.00', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6674', '1917', '5', '7.00', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6675', '1921', '5', '6.50', '2025-06-16', '1', '1');
INSERT INTO `notas` VALUES('6676', '1921', '5', '7.00', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6677', '1918', '5', '7.00', '2025-06-16', '1', '3');
INSERT INTO `notas` VALUES('6678', '1898', '5', '7.00', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6679', '1899', '5', '7.00', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6680', '1900', '5', '7.00', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6681', '1901', '5', '7.00', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6682', '1902', '5', '7.00', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6683', '1920', '5', '7.00', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6684', '1919', '5', '7.00', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6685', '1903', '5', '7.00', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6686', '1904', '5', '6.50', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6687', '1905', '5', '6.50', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6688', '1906', '5', '6.50', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6689', '1907', '5', '7.00', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6690', '1908', '5', '7.00', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6691', '1909', '5', '7.00', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6692', '1910', '5', '7.00', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6693', '1911', '5', '7.00', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6694', '1912', '5', '7.00', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6695', '1913', '5', '7.00', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6696', '1914', '5', '6.50', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6697', '1915', '5', '7.00', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6698', '1916', '5', '7.00', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6699', '1917', '5', '7.00', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6700', '1921', '5', '7.00', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6701', '1918', '5', '7.00', '2025-06-16', '1', '4');
INSERT INTO `notas` VALUES('6702', '1844', '5', '7.00', '2025-06-17', '1', '3');
INSERT INTO `notas` VALUES('6703', '1845', '5', '7.00', '2025-06-17', '1', '3');
INSERT INTO `notas` VALUES('6704', '1847', '5', '7.00', '2025-06-17', '1', '3');
INSERT INTO `notas` VALUES('6705', '1849', '5', '7.00', '2025-06-17', '1', '3');
INSERT INTO `notas` VALUES('6706', '1851', '5', '7.00', '2025-06-17', '1', '3');
INSERT INTO `notas` VALUES('6707', '1852', '5', '7.00', '2025-06-17', '1', '3');
INSERT INTO `notas` VALUES('6708', '1854', '5', '7.00', '2025-06-17', '1', '3');
INSERT INTO `notas` VALUES('6709', '1861', '5', '7.00', '2025-06-17', '1', '3');
INSERT INTO `notas` VALUES('6710', '1862', '5', '7.00', '2025-06-17', '1', '3');
INSERT INTO `notas` VALUES('6711', '1863', '5', '7.00', '2025-06-17', '1', '3');
INSERT INTO `notas` VALUES('6712', '1865', '5', '7.00', '2025-06-17', '1', '3');
INSERT INTO `notas` VALUES('6713', '1867', '5', '7.00', '2025-06-17', '1', '3');
INSERT INTO `notas` VALUES('6714', '1868', '5', '7.00', '2025-06-17', '1', '3');
INSERT INTO `notas` VALUES('6715', '1871', '5', '7.00', '2025-06-17', '1', '3');
INSERT INTO `notas` VALUES('6716', '1876', '5', '7.00', '2025-06-17', '1', '3');
INSERT INTO `notas` VALUES('6717', '1846', '5', '6.50', '2025-06-17', '1', '3');
INSERT INTO `notas` VALUES('6718', '1848', '5', '6.50', '2025-06-17', '1', '3');
INSERT INTO `notas` VALUES('6719', '1850', '5', '6.50', '2025-06-17', '1', '3');
INSERT INTO `notas` VALUES('6720', '1853', '5', '6.50', '2025-06-17', '1', '3');
INSERT INTO `notas` VALUES('6721', '1855', '5', '7.00', '2025-06-17', '1', '3');
INSERT INTO `notas` VALUES('6722', '1856', '5', '7.00', '2025-06-17', '1', '3');
INSERT INTO `notas` VALUES('6723', '1857', '5', '6.50', '2025-06-17', '1', '3');
INSERT INTO `notas` VALUES('6724', '1858', '5', '6.50', '2025-06-17', '1', '3');
INSERT INTO `notas` VALUES('6725', '1859', '5', '6.50', '2025-06-17', '1', '3');
INSERT INTO `notas` VALUES('6726', '1860', '5', '6.50', '2025-06-17', '1', '3');
INSERT INTO `notas` VALUES('6727', '1864', '5', '7.00', '2025-06-17', '1', '3');
INSERT INTO `notas` VALUES('6728', '1866', '5', '7.00', '2025-06-17', '1', '3');
INSERT INTO `notas` VALUES('6729', '1869', '5', '6.50', '2025-06-17', '1', '3');
INSERT INTO `notas` VALUES('6730', '1870', '5', '7.00', '2025-06-17', '1', '3');
INSERT INTO `notas` VALUES('6731', '1870', '5', '6.00', '2025-06-17', '1', '4');
INSERT INTO `notas` VALUES('6732', '1872', '5', '7.00', '2025-06-17', '1', '3');
INSERT INTO `notas` VALUES('6733', '1873', '5', '7.00', '2025-06-17', '1', '3');
INSERT INTO `notas` VALUES('6734', '1874', '5', '7.00', '2025-06-17', '1', '3');
INSERT INTO `notas` VALUES('6735', '1875', '5', '6.50', '2025-06-17', '1', '3');
INSERT INTO `notas` VALUES('6736', '1875', '5', '6.00', '2025-06-17', '1', '4');
INSERT INTO `notas` VALUES('6737', '1860', '5', '6.00', '2025-06-17', '1', '4');
INSERT INTO `notas` VALUES('6738', '1713', '3', '6.20', '2025-06-17', '1', '2');
INSERT INTO `notas` VALUES('6739', '1713', '3', '5.50', '2025-06-17', '1', '3');
INSERT INTO `notas` VALUES('6740', '1713', '3', '4.60', '2025-06-17', '1', '4');
INSERT INTO `notas` VALUES('6741', '1714', '3', '6.00', '2025-06-17', '1', '1');
INSERT INTO `notas` VALUES('6742', '1714', '3', '4.00', '2025-06-17', '1', '2');
INSERT INTO `notas` VALUES('6743', '1714', '3', '6.80', '2025-06-17', '1', '3');
INSERT INTO `notas` VALUES('6744', '1714', '3', '6.40', '2025-06-17', '1', '4');
INSERT INTO `notas` VALUES('6745', '1715', '3', '7.00', '2025-06-17', '1', '2');
INSERT INTO `notas` VALUES('6746', '1715', '3', '5.50', '2025-06-17', '1', '3');
INSERT INTO `notas` VALUES('6747', '1715', '3', '5.40', '2025-06-17', '1', '4');
INSERT INTO `notas` VALUES('6748', '1716', '3', '7.00', '2025-06-17', '1', '2');
INSERT INTO `notas` VALUES('6749', '1716', '3', '6.80', '2025-06-17', '1', '3');
INSERT INTO `notas` VALUES('6750', '1716', '3', '6.20', '2025-06-17', '1', '4');
INSERT INTO `notas` VALUES('6751', '1717', '3', '4.00', '2025-06-17', '1', '2');
INSERT INTO `notas` VALUES('6752', '1717', '3', '6.80', '2025-06-17', '1', '3');
INSERT INTO `notas` VALUES('6753', '1717', '3', '4.70', '2025-06-17', '1', '4');
INSERT INTO `notas` VALUES('6754', '1718', '3', '4.00', '2025-06-17', '1', '1');
INSERT INTO `notas` VALUES('6755', '1718', '3', '4.00', '2025-06-17', '1', '2');
INSERT INTO `notas` VALUES('6756', '1718', '3', '6.60', '2025-06-17', '1', '3');
INSERT INTO `notas` VALUES('6757', '1718', '3', '4.80', '2025-06-17', '1', '4');
INSERT INTO `notas` VALUES('6758', '1719', '3', '6.00', '2025-06-17', '1', '1');
INSERT INTO `notas` VALUES('6759', '1719', '3', '7.00', '2025-06-17', '1', '2');
INSERT INTO `notas` VALUES('6760', '1719', '3', '6.80', '2025-06-17', '1', '3');
INSERT INTO `notas` VALUES('6761', '1719', '3', '5.70', '2025-06-17', '1', '4');
INSERT INTO `notas` VALUES('6762', '1720', '3', '7.00', '2025-06-17', '1', '2');
INSERT INTO `notas` VALUES('6763', '1720', '3', '6.20', '2025-06-17', '1', '3');
INSERT INTO `notas` VALUES('6764', '1720', '3', '5.70', '2025-06-17', '1', '4');
INSERT INTO `notas` VALUES('6765', '1721', '3', '6.60', '2025-06-17', '1', '2');
INSERT INTO `notas` VALUES('6766', '1721', '3', '7.00', '2025-06-17', '1', '3');
INSERT INTO `notas` VALUES('6767', '1721', '3', '6.20', '2025-06-17', '1', '4');
INSERT INTO `notas` VALUES('6768', '1722', '3', '7.00', '2025-06-17', '1', '2');
INSERT INTO `notas` VALUES('6769', '1722', '3', '6.50', '2025-06-17', '1', '3');
INSERT INTO `notas` VALUES('6770', '1722', '3', '5.20', '2025-06-17', '1', '4');
INSERT INTO `notas` VALUES('6771', '1723', '3', '6.00', '2025-06-17', '1', '1');
INSERT INTO `notas` VALUES('6772', '1723', '3', '7.00', '2025-06-17', '1', '2');
INSERT INTO `notas` VALUES('6773', '1723', '3', '5.00', '2025-06-17', '1', '3');
INSERT INTO `notas` VALUES('6774', '1723', '3', '5.00', '2025-06-17', '1', '4');
INSERT INTO `notas` VALUES('6775', '1724', '3', '7.00', '2025-06-17', '1', '2');
INSERT INTO `notas` VALUES('6776', '1724', '3', '7.00', '2025-06-17', '1', '3');
INSERT INTO `notas` VALUES('6777', '1724', '3', '6.20', '2025-06-17', '1', '4');
INSERT INTO `notas` VALUES('6778', '1725', '3', '7.00', '2025-06-17', '1', '2');
INSERT INTO `notas` VALUES('6779', '1725', '3', '6.40', '2025-06-17', '1', '3');
INSERT INTO `notas` VALUES('6780', '1725', '3', '6.10', '2025-06-17', '1', '4');
INSERT INTO `notas` VALUES('6781', '1726', '3', '7.00', '2025-06-17', '1', '2');
INSERT INTO `notas` VALUES('6782', '1726', '3', '6.40', '2025-06-17', '1', '3');
INSERT INTO `notas` VALUES('6783', '1726', '3', '5.80', '2025-06-17', '1', '4');
INSERT INTO `notas` VALUES('6784', '1727', '3', '7.00', '2025-06-17', '1', '2');
INSERT INTO `notas` VALUES('6785', '1727', '3', '7.00', '2025-06-17', '1', '3');
INSERT INTO `notas` VALUES('6786', '1727', '3', '6.80', '2025-06-17', '1', '4');
INSERT INTO `notas` VALUES('6787', '1728', '3', '7.00', '2025-06-17', '1', '2');
INSERT INTO `notas` VALUES('6788', '1728', '3', '7.00', '2025-06-17', '1', '3');
INSERT INTO `notas` VALUES('6789', '1728', '3', '6.80', '2025-06-17', '1', '4');
INSERT INTO `notas` VALUES('6790', '1729', '3', '6.60', '2025-06-17', '1', '2');
INSERT INTO `notas` VALUES('6791', '1729', '3', '7.00', '2025-06-17', '1', '3');
INSERT INTO `notas` VALUES('6792', '1729', '3', '6.00', '2025-06-17', '1', '4');
INSERT INTO `notas` VALUES('6793', '1730', '3', '4.00', '2025-06-17', '1', '2');
INSERT INTO `notas` VALUES('6794', '1730', '3', '7.00', '2025-06-17', '1', '3');
INSERT INTO `notas` VALUES('6795', '1730', '3', '5.20', '2025-06-17', '1', '4');
INSERT INTO `notas` VALUES('6796', '1429', '5', '7.00', '2025-06-19', '1', '3');
INSERT INTO `notas` VALUES('6797', '1429', '5', '7.00', '2025-06-19', '1', '4');
INSERT INTO `notas` VALUES('6798', '1430', '5', '7.00', '2025-06-19', '1', '3');
INSERT INTO `notas` VALUES('6799', '1430', '5', '7.00', '2025-06-19', '1', '4');
INSERT INTO `notas` VALUES('6800', '1431', '5', '7.00', '2025-06-19', '1', '3');
INSERT INTO `notas` VALUES('6801', '1431', '5', '7.00', '2025-06-19', '1', '4');
INSERT INTO `notas` VALUES('6802', '1432', '5', '7.00', '2025-06-19', '1', '3');
INSERT INTO `notas` VALUES('6803', '1432', '5', '7.00', '2025-06-19', '1', '4');
INSERT INTO `notas` VALUES('6804', '1433', '5', '7.00', '2025-06-19', '1', '3');
INSERT INTO `notas` VALUES('6805', '1433', '5', '7.00', '2025-06-19', '1', '4');
INSERT INTO `notas` VALUES('6806', '1434', '5', '7.00', '2025-06-19', '1', '1');
INSERT INTO `notas` VALUES('6807', '1434', '5', '7.00', '2025-06-19', '1', '3');
INSERT INTO `notas` VALUES('6808', '1434', '5', '7.00', '2025-06-19', '1', '4');
INSERT INTO `notas` VALUES('6809', '1435', '5', '7.00', '2025-06-19', '1', '1');
INSERT INTO `notas` VALUES('6810', '1435', '5', '7.00', '2025-06-19', '1', '3');
INSERT INTO `notas` VALUES('6811', '1435', '5', '7.00', '2025-06-19', '1', '4');
INSERT INTO `notas` VALUES('6812', '1436', '5', '7.00', '2025-06-19', '1', '3');
INSERT INTO `notas` VALUES('6813', '1436', '5', '7.00', '2025-06-19', '1', '4');
INSERT INTO `notas` VALUES('6814', '1454', '5', '7.00', '2025-06-19', '1', '1');
INSERT INTO `notas` VALUES('6815', '1454', '5', '7.00', '2025-06-19', '1', '3');
INSERT INTO `notas` VALUES('6816', '1454', '5', '7.00', '2025-06-19', '1', '4');
INSERT INTO `notas` VALUES('6817', '1437', '5', '7.00', '2025-06-19', '1', '3');
INSERT INTO `notas` VALUES('6818', '1437', '5', '7.00', '2025-06-19', '1', '4');
INSERT INTO `notas` VALUES('6819', '1438', '5', '7.00', '2025-06-19', '1', '3');
INSERT INTO `notas` VALUES('6820', '1438', '5', '7.00', '2025-06-19', '1', '4');
INSERT INTO `notas` VALUES('6821', '1439', '5', '7.00', '2025-06-19', '1', '3');
INSERT INTO `notas` VALUES('6822', '1439', '5', '7.00', '2025-06-19', '1', '4');
INSERT INTO `notas` VALUES('6823', '1440', '5', '7.00', '2025-06-19', '1', '3');
INSERT INTO `notas` VALUES('6824', '1440', '5', '7.00', '2025-06-19', '1', '4');
INSERT INTO `notas` VALUES('6825', '1441', '5', '7.00', '2025-06-19', '1', '3');
INSERT INTO `notas` VALUES('6826', '1441', '5', '7.00', '2025-06-19', '1', '4');
INSERT INTO `notas` VALUES('6827', '1442', '5', '7.00', '2025-06-19', '1', '3');
INSERT INTO `notas` VALUES('6828', '1442', '5', '7.00', '2025-06-19', '1', '4');
INSERT INTO `notas` VALUES('6829', '1443', '5', '7.00', '2025-06-19', '1', '3');
INSERT INTO `notas` VALUES('6830', '1443', '5', '7.00', '2025-06-19', '1', '4');
INSERT INTO `notas` VALUES('6831', '1444', '5', '7.00', '2025-06-19', '1', '3');
INSERT INTO `notas` VALUES('6832', '1444', '5', '7.00', '2025-06-19', '1', '4');
INSERT INTO `notas` VALUES('6833', '1445', '5', '7.00', '2025-06-19', '1', '3');
INSERT INTO `notas` VALUES('6834', '1445', '5', '7.00', '2025-06-19', '1', '4');
INSERT INTO `notas` VALUES('6835', '1446', '5', '7.00', '2025-06-19', '1', '3');
INSERT INTO `notas` VALUES('6836', '1446', '5', '7.00', '2025-06-19', '1', '4');
INSERT INTO `notas` VALUES('6837', '1447', '5', '7.00', '2025-06-19', '1', '3');
INSERT INTO `notas` VALUES('6838', '1447', '5', '7.00', '2025-06-19', '1', '4');
INSERT INTO `notas` VALUES('6839', '1750', '5', '5.70', '2025-07-08', '1', '3');
INSERT INTO `notas` VALUES('6840', '1750', '5', '5.60', '2025-07-08', '1', '4');
INSERT INTO `notas` VALUES('6841', '1750', '7', '2.20', '2025-07-08', '1', '3');
INSERT INTO `notas` VALUES('6842', '1750', '7', '5.60', '2025-07-08', '1', '4');
INSERT INTO `notas` VALUES('6843', '1750', '8', '3.40', '2025-07-08', '1', '3');
INSERT INTO `notas` VALUES('6844', '1750', '8', '5.40', '2025-07-08', '1', '4');
INSERT INTO `notas` VALUES('6845', '1750', '3', '4.80', '2025-07-08', '1', '2');
INSERT INTO `notas` VALUES('6846', '1750', '3', '5.00', '2025-07-08', '1', '3');
INSERT INTO `notas` VALUES('6847', '1750', '3', '5.10', '2025-07-08', '1', '4');
INSERT INTO `notas` VALUES('6848', '1542', '1', '7.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('6849', '1542', '1', '5.80', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('6850', '1542', '1', '6.80', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('6851', '1543', '1', '5.80', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('6852', '1543', '1', '5.80', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('6853', '1543', '1', '6.90', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('6854', '1544', '1', '5.80', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('6855', '1544', '1', '6.50', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('6856', '1544', '1', '6.90', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('6857', '1545', '1', '7.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('6858', '1545', '1', '6.80', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('6859', '1545', '1', '6.90', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('6860', '1546', '1', '7.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('6861', '1546', '1', '6.50', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('6862', '1546', '1', '6.80', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('6863', '1547', '1', '5.80', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('6864', '1547', '1', '6.50', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('6865', '1547', '1', '6.60', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('6866', '1548', '1', '6.20', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('6867', '1548', '1', '6.50', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('6868', '1548', '1', '6.90', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('6869', '1549', '1', '6.50', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('6870', '1549', '1', '5.00', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('6871', '1549', '1', '5.60', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('6872', '1550', '1', '6.20', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('6873', '1550', '1', '5.00', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('6874', '1550', '1', '5.60', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('6875', '1551', '1', '5.80', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('6876', '1551', '1', '5.00', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('6877', '1551', '1', '6.20', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('6878', '1552', '1', '6.80', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('6879', '1552', '1', '6.50', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('6880', '1552', '1', '6.80', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('6881', '1553', '1', '5.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('6882', '1553', '1', '5.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('6883', '1553', '1', '5.50', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('6884', '1553', '1', '5.60', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('6885', '1554', '1', '6.20', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('6886', '1554', '1', '6.80', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('6887', '1554', '1', '6.70', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('6888', '1555', '1', '4.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('6889', '1555', '1', '6.50', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('6890', '1555', '1', '6.80', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('6891', '1555', '1', '6.70', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('6892', '1556', '1', '6.80', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('6893', '1556', '1', '6.80', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('6894', '1556', '1', '6.90', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('6895', '1557', '1', '5.50', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('6896', '1557', '1', '5.00', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('6897', '1557', '1', '6.70', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('6898', '1558', '1', '6.30', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('6899', '1558', '1', '6.60', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('6900', '1558', '1', '6.50', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('6901', '1558', '1', '6.30', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('6902', '1559', '1', '7.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('6903', '1559', '1', '6.60', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('6904', '1559', '1', '6.50', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('6905', '1559', '1', '6.90', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('6906', '1560', '1', '6.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('6907', '1560', '1', '6.60', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('6908', '1560', '1', '5.00', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('6909', '1560', '1', '6.10', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('6910', '1561', '1', '5.50', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('6911', '1561', '1', '5.80', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('6912', '1561', '1', '6.30', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('6913', '1562', '1', '6.60', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('6914', '1562', '1', '6.80', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('6915', '1562', '1', '6.90', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('6916', '1563', '1', '5.50', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('6917', '1563', '1', '6.50', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('6918', '1563', '1', '6.90', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('6919', '1542', '2', '7.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('6920', '1542', '2', '5.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('6921', '1542', '2', '5.80', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('6922', '1542', '2', '6.80', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('6923', '1543', '2', '5.50', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('6924', '1543', '2', '5.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('6925', '1543', '2', '5.80', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('6926', '1543', '2', '6.90', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('6927', '1544', '2', '6.50', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('6928', '1544', '2', '7.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('6929', '1544', '2', '7.00', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('6930', '1544', '2', '6.90', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('6931', '1545', '2', '7.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('6932', '1545', '2', '6.80', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('6933', '1545', '2', '7.00', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('6934', '1545', '2', '6.90', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('6935', '1546', '2', '6.50', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('6936', '1546', '2', '5.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('6937', '1546', '2', '7.00', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('6938', '1546', '2', '6.80', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('6939', '1547', '2', '7.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('6940', '1547', '2', '6.80', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('6941', '1547', '2', '7.00', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('6942', '1547', '2', '6.60', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('6943', '1548', '2', '7.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('6944', '1548', '2', '5.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('6945', '1548', '2', '5.80', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('6946', '1548', '2', '6.90', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('6947', '1549', '2', '4.50', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('6948', '1549', '2', '7.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('6949', '1549', '2', '5.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('6950', '1549', '2', '5.00', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('6951', '1549', '2', '5.60', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('6952', '1550', '2', '6.70', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('6953', '1550', '2', '6.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('6954', '1550', '2', '6.50', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('6955', '1550', '2', '5.60', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('6956', '1551', '2', '6.50', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('6957', '1551', '2', '4.50', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('6958', '1551', '2', '5.00', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('6959', '1551', '2', '6.20', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('6960', '1552', '2', '7.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('6961', '1552', '2', '6.80', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('6962', '1552', '2', '7.00', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('6963', '1552', '2', '6.80', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('6964', '1553', '2', '6.00', '2025-07-09', '1', '1');
INSERT INTO `notas` VALUES('6965', '1553', '2', '6.20', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('6966', '1553', '2', '5.50', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('6967', '1553', '2', '5.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('6968', '1553', '2', '7.00', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('6969', '1553', '2', '5.60', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('6970', '1554', '2', '7.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('6971', '1554', '2', '6.50', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('6972', '1554', '2', '6.80', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('6973', '1554', '2', '6.70', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('6974', '1555', '2', '6.70', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('6975', '1555', '2', '6.50', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('6976', '1555', '2', '6.80', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('6977', '1555', '2', '6.70', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('6978', '1556', '2', '5.50', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('6979', '1556', '2', '6.50', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('6980', '1556', '2', '7.00', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('6981', '1556', '2', '6.90', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('6982', '1557', '2', '7.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('6983', '1557', '2', '6.80', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('6984', '1557', '2', '7.00', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('6985', '1557', '2', '6.70', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('6986', '1558', '2', '7.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('6987', '1558', '2', '6.50', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('6988', '1558', '2', '6.80', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('6989', '1558', '2', '6.30', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('6990', '1559', '2', '7.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('6991', '1559', '2', '6.50', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('6992', '1559', '2', '7.00', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('6993', '1559', '2', '6.90', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('6994', '1560', '2', '6.50', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('6995', '1560', '2', '4.50', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('6996', '1560', '2', '5.00', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('6997', '1560', '2', '6.10', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('6998', '1561', '2', '7.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('6999', '1561', '2', '6.50', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7000', '1561', '2', '6.80', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('7001', '1561', '2', '6.30', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('7002', '1562', '2', '6.50', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7003', '1562', '2', '6.50', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7004', '1562', '2', '7.00', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('7005', '1562', '2', '6.90', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('7006', '1563', '2', '7.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7007', '1563', '2', '6.50', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7008', '1563', '2', '6.00', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('7009', '1563', '2', '6.90', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('7010', '1713', '5', '7.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7011', '1713', '5', '7.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7012', '1714', '5', '7.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7013', '1714', '5', '7.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7014', '1715', '5', '7.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7015', '1715', '5', '7.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7016', '1716', '5', '7.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7017', '1716', '5', '7.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7018', '1717', '5', '7.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7019', '1717', '5', '7.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7020', '1718', '5', '7.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7021', '1718', '5', '6.30', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7022', '1719', '5', '7.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7023', '1719', '5', '6.40', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7024', '1720', '5', '7.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7025', '1720', '5', '7.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7026', '1721', '5', '7.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7027', '1721', '5', '7.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7028', '1722', '5', '7.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7029', '1722', '5', '6.90', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7030', '1723', '5', '7.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7031', '1723', '5', '6.90', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7032', '1724', '5', '7.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7033', '1724', '5', '7.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7034', '1725', '5', '7.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7035', '1725', '5', '7.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7036', '1726', '5', '7.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7037', '1726', '5', '7.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7038', '1727', '5', '7.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7039', '1727', '5', '7.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7040', '1728', '5', '7.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7041', '1728', '5', '6.80', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7042', '1729', '5', '7.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7043', '1729', '5', '7.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7044', '1730', '5', '7.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7045', '1730', '5', '7.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7046', '1713', '8', '5.20', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7047', '1714', '8', '6.60', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7048', '1715', '8', '6.30', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7049', '1715', '8', '5.50', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7050', '1716', '8', '6.80', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7051', '1717', '8', '5.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7052', '1718', '8', '4.60', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7053', '1718', '8', '6.10', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7054', '1719', '8', '6.10', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7055', '1720', '8', '6.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7056', '1721', '8', '5.80', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7057', '1722', '8', '5.20', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7058', '1723', '8', '6.30', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7059', '1723', '8', '5.30', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7060', '1724', '8', '6.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7061', '1725', '8', '6.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7062', '1726', '8', '5.10', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7063', '1727', '8', '7.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7064', '1728', '8', '6.60', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7065', '1729', '8', '6.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7066', '1730', '8', '5.40', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7067', '1713', '2', '2.70', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('7068', '1713', '2', '5.80', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('7069', '1714', '2', '6.00', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('7070', '1714', '2', '6.70', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('7071', '1715', '2', '4.50', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7072', '1715', '2', '2.00', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('7073', '1715', '2', '5.20', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('7074', '1716', '2', '6.20', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('7075', '1716', '2', '6.30', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('7076', '1717', '2', '5.70', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('7077', '1717', '2', '6.10', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('7078', '1718', '2', '4.00', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('7079', '1718', '2', '5.60', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('7080', '1719', '2', '5.00', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('7081', '1719', '2', '5.30', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('7082', '1720', '2', '7.00', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('7083', '1720', '2', '7.00', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('7084', '1721', '2', '6.60', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('7085', '1721', '2', '6.30', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('7086', '1722', '2', '4.50', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('7087', '1722', '2', '5.60', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('7088', '1723', '2', '4.90', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('7089', '1723', '2', '5.80', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('7090', '1724', '2', '6.00', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('7091', '1724', '2', '6.20', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('7092', '1725', '2', '5.40', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('7093', '1725', '2', '6.00', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('7094', '1726', '2', '1.30', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('7095', '1726', '2', '4.70', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('7096', '1727', '2', '7.00', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('7097', '1727', '2', '6.90', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('7098', '1728', '2', '7.00', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('7099', '1728', '2', '7.00', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('7100', '1729', '2', '5.40', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('7101', '1729', '2', '5.80', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('7102', '1730', '2', '4.50', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('7103', '1730', '2', '6.00', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('7104', '1564', '1', '7.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7105', '1564', '1', '5.20', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('7106', '1564', '1', '6.80', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('7107', '1565', '1', '6.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7108', '1565', '1', '6.40', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('7109', '1565', '1', '6.30', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('7110', '1566', '1', '6.50', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7111', '1566', '1', '5.20', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('7112', '1566', '1', '5.40', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('7113', '1567', '1', '6.50', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7114', '1567', '1', '6.00', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('7115', '1567', '1', '6.60', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('7116', '1568', '1', '7.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7117', '1568', '1', '6.60', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('7118', '1568', '1', '7.00', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('7119', '1569', '1', '6.70', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7120', '1569', '1', '6.90', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('7121', '1569', '1', '7.00', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('7122', '1570', '1', '6.50', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7123', '1570', '1', '4.80', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('7124', '1570', '1', '6.50', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('7125', '1571', '1', '6.70', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7126', '1571', '1', '5.40', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7127', '1571', '1', '6.90', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('7128', '1571', '1', '7.00', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('7129', '1572', '1', '6.70', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7130', '1572', '1', '6.30', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('7131', '1572', '1', '7.00', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('7132', '1573', '1', '4.60', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7133', '1573', '1', '4.50', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('7134', '1573', '1', '6.50', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('7135', '1574', '1', '3.20', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7136', '1574', '1', '4.00', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('7137', '1574', '1', '6.00', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('7138', '1575', '1', '7.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7139', '1575', '1', '6.70', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('7140', '1575', '1', '7.00', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('7141', '1576', '1', '5.70', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7142', '1576', '1', '5.00', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('7143', '1576', '1', '6.30', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('7144', '1577', '1', '5.40', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7145', '1577', '1', '5.50', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('7146', '1577', '1', '6.20', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('7147', '1578', '1', '5.40', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7148', '1578', '1', '6.00', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('7149', '1578', '1', '6.80', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('7150', '1579', '1', '6.20', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7151', '1579', '1', '5.90', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('7152', '1579', '1', '6.80', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('7153', '1580', '1', '3.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7154', '1580', '1', '4.20', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('7155', '1580', '1', '6.50', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('7156', '1581', '1', '6.50', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7157', '1581', '1', '5.00', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('7158', '1581', '1', '7.00', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('7159', '1582', '1', '6.20', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7160', '1582', '1', '6.70', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('7161', '1582', '1', '6.00', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('7162', '1583', '1', '5.70', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7163', '1583', '1', '5.90', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('7164', '1583', '1', '6.50', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('7165', '1584', '1', '4.70', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7166', '1584', '1', '6.50', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7167', '1584', '1', '4.60', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('7168', '1584', '1', '6.10', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('7169', '1564', '2', '6.50', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7170', '1564', '2', '5.60', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('7171', '1564', '2', '6.80', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('7172', '1565', '2', '4.70', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7173', '1565', '2', '6.70', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('7174', '1565', '2', '6.30', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('7175', '1566', '2', '5.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7176', '1566', '2', '5.20', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('7177', '1566', '2', '5.40', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('7178', '1567', '2', '5.60', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7179', '1567', '2', '4.50', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('7180', '1567', '2', '6.60', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('7181', '1568', '2', '7.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7182', '1568', '2', '6.30', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('7183', '1568', '2', '7.00', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('7184', '1569', '2', '7.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7185', '1569', '2', '6.10', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('7186', '1569', '2', '7.00', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('7187', '1570', '2', '4.50', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7188', '1570', '2', '4.40', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('7189', '1570', '2', '6.50', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('7190', '1571', '2', '6.10', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7191', '1571', '2', '6.30', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7192', '1571', '2', '6.60', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('7193', '1571', '2', '7.00', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('7194', '1572', '2', '7.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7195', '1572', '2', '7.00', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('7196', '1572', '2', '7.00', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('7197', '1573', '2', '5.30', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7198', '1573', '2', '4.60', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('7199', '1573', '2', '6.50', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('7200', '1574', '2', '5.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7201', '1574', '2', '4.50', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('7202', '1574', '2', '6.00', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('7203', '1575', '2', '5.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7204', '1575', '2', '6.00', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('7205', '1575', '2', '7.00', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('7206', '1576', '2', '7.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7207', '1576', '2', '4.20', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('7208', '1576', '2', '6.30', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('7209', '1577', '2', '5.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7210', '1577', '2', '6.00', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('7211', '1577', '2', '6.20', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('7212', '1578', '2', '5.60', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7213', '1578', '2', '5.20', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('7214', '1578', '2', '6.80', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('7215', '1579', '2', '6.30', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7216', '1579', '2', '7.00', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('7217', '1579', '2', '6.80', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('7218', '1580', '2', '7.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7219', '1580', '2', '5.50', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('7220', '1580', '2', '6.50', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('7221', '1581', '2', '4.50', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7222', '1581', '2', '5.50', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('7223', '1581', '2', '7.00', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('7224', '1582', '2', '7.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7225', '1582', '2', '7.00', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('7226', '1582', '2', '6.00', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('7227', '1583', '2', '5.40', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7228', '1583', '2', '5.00', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('7229', '1583', '2', '6.50', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('7230', '1584', '2', '5.40', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7231', '1584', '2', '5.20', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7232', '1584', '2', '6.00', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('7233', '1584', '2', '6.10', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('7234', '1564', '6', '6.60', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7235', '1564', '6', '6.80', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7236', '1565', '6', '5.50', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7237', '1565', '6', '6.30', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7238', '1566', '6', '6.60', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7239', '1566', '6', '6.50', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7240', '1566', '6', '5.40', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7241', '1567', '6', '5.70', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7242', '1567', '6', '6.60', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7243', '1568', '6', '6.60', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7244', '1568', '6', '7.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7245', '1569', '6', '7.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7246', '1569', '6', '7.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7247', '1570', '6', '6.30', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7248', '1570', '6', '6.50', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7249', '1571', '6', '6.10', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7250', '1571', '6', '7.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7251', '1572', '6', '6.80', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7252', '1572', '6', '7.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7253', '1573', '6', '6.10', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7254', '1573', '6', '6.50', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7255', '1574', '6', '6.10', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7256', '1574', '6', '6.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7257', '1575', '6', '6.60', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7258', '1575', '6', '7.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7259', '1576', '6', '6.10', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7260', '1576', '6', '6.30', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7261', '1577', '6', '6.10', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7262', '1577', '6', '6.20', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7263', '1578', '6', '6.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7264', '1578', '6', '6.80', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7265', '1579', '6', '6.60', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7266', '1579', '6', '6.80', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7267', '1580', '6', '5.50', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7268', '1580', '6', '6.50', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7269', '1581', '6', '6.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7270', '1581', '6', '7.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7271', '1582', '6', '6.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7272', '1582', '6', '6.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7273', '1583', '6', '6.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7274', '1583', '6', '6.50', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7275', '1584', '6', '6.50', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7276', '1584', '6', '6.10', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7277', '1872', '2', '4.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7278', '1872', '2', '4.20', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7279', '1872', '2', '4.10', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('7280', '1872', '2', '5.30', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('7281', '1872', '1', '5.40', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7282', '1872', '1', '3.60', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('7283', '1872', '1', '5.30', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('7284', '1872', '6', '3.60', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7285', '1872', '6', '5.30', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7286', '1872', '7', '5.70', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7287', '1872', '7', '5.30', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7288', '1731', '4', '5.50', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7289', '1745', '4', '6.20', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7290', '1872', '3', '7.00', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7291', '1872', '3', '4.50', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7292', '1872', '3', '6.20', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7293', '1872', '4', '6.40', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7294', '1872', '4', '7.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7295', '1872', '12', '7.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7296', '1542', '6', '5.80', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7297', '1542', '6', '6.80', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7298', '1542', '6', '6.80', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7299', '1543', '6', '6.00', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7300', '1543', '6', '6.30', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7301', '1543', '6', '6.90', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7302', '1544', '6', '6.20', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7303', '1544', '6', '6.60', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7304', '1544', '6', '6.90', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7305', '1545', '6', '6.70', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7306', '1545', '6', '7.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7307', '1545', '6', '6.90', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7308', '1546', '6', '5.80', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7309', '1546', '6', '6.30', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7310', '1546', '6', '6.80', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7311', '1547', '6', '5.80', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7312', '1547', '6', '5.90', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7313', '1547', '6', '6.60', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7314', '1548', '6', '6.00', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7315', '1548', '6', '6.50', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7316', '1548', '6', '6.90', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7317', '1549', '6', '5.20', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7318', '1549', '6', '5.90', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7319', '1549', '6', '5.60', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7320', '1550', '6', '5.20', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7321', '1550', '6', '5.90', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7322', '1550', '6', '5.60', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7323', '1551', '6', '5.80', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7324', '1551', '6', '6.10', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7325', '1551', '6', '6.20', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7326', '1552', '6', '6.70', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7327', '1552', '6', '6.90', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7328', '1552', '6', '6.80', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7329', '1553', '6', '5.20', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7330', '1553', '6', '5.90', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7331', '1553', '6', '5.60', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7332', '1554', '6', '6.70', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7333', '1554', '6', '6.30', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7334', '1554', '6', '6.70', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7335', '1555', '6', '6.70', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7336', '1555', '6', '6.30', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7337', '1555', '6', '6.70', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7338', '1556', '6', '6.70', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7339', '1556', '6', '6.50', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7340', '1556', '6', '6.90', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7341', '1557', '6', '6.20', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7342', '1557', '6', '6.80', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7343', '1557', '6', '6.70', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7344', '1558', '6', '6.20', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7345', '1558', '6', '6.50', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7346', '1558', '6', '6.30', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7347', '1559', '6', '6.60', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7348', '1559', '6', '6.50', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7349', '1559', '6', '6.90', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7350', '1560', '6', '5.20', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7351', '1560', '6', '6.50', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7352', '1560', '6', '6.10', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7353', '1561', '6', '5.80', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7354', '1561', '6', '6.50', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7355', '1561', '6', '6.30', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7356', '1562', '6', '6.70', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7357', '1562', '6', '6.50', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7358', '1562', '6', '6.90', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7359', '1563', '6', '6.20', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7360', '1563', '6', '6.80', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7361', '1563', '6', '6.90', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7362', '1542', '7', '6.70', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7363', '1542', '7', '6.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7364', '1542', '7', '6.80', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7365', '1543', '7', '6.30', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7366', '1543', '7', '6.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7367', '1543', '7', '6.90', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7368', '1544', '7', '6.70', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7369', '1544', '7', '6.30', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7370', '1544', '7', '6.90', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7371', '1545', '7', '6.70', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7372', '1545', '7', '6.50', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7373', '1545', '7', '6.90', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7374', '1546', '7', '6.60', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7375', '1546', '7', '6.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7376', '1546', '7', '6.80', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7377', '1547', '7', '6.20', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7378', '1547', '7', '5.80', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7379', '1547', '7', '6.60', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7380', '1548', '7', '6.00', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7381', '1548', '7', '6.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7382', '1548', '7', '6.90', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7383', '1549', '7', '6.00', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7384', '1549', '7', '5.80', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7385', '1549', '7', '5.60', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7386', '1550', '7', '4.00', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7387', '1550', '7', '5.80', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7388', '1550', '7', '5.60', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7389', '1551', '7', '6.70', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7390', '1551', '7', '5.80', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7391', '1551', '7', '6.20', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7392', '1552', '7', '6.50', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7393', '1552', '7', '6.60', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7394', '1552', '7', '6.80', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7395', '1553', '7', '5.00', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7396', '1553', '7', '5.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7397', '1553', '7', '5.60', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7398', '1554', '7', '6.50', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7399', '1554', '7', '6.30', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7400', '1554', '7', '6.70', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7401', '1555', '7', '6.70', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7402', '1555', '7', '6.60', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7403', '1555', '7', '6.70', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7404', '1556', '7', '6.30', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7405', '1556', '7', '6.60', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7406', '1556', '7', '6.90', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7407', '1557', '7', '6.30', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7408', '1557', '7', '6.60', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7409', '1557', '7', '6.70', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7410', '1558', '7', '6.60', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7411', '1558', '7', '6.50', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7412', '1558', '7', '6.30', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7413', '1559', '7', '6.20', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7414', '1559', '7', '6.50', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7415', '1559', '7', '6.90', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7416', '1560', '7', '4.00', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7417', '1560', '7', '5.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7418', '1560', '7', '6.10', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7419', '1561', '7', '6.70', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7420', '1561', '7', '5.80', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7421', '1561', '7', '6.30', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7422', '1562', '7', '6.00', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7423', '1562', '7', '6.50', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7424', '1562', '7', '6.90', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7425', '1563', '7', '6.70', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7426', '1563', '7', '6.50', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7427', '1563', '7', '6.90', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7428', '1553', '5', '6.00', '2025-07-09', '1', '1');
INSERT INTO `notas` VALUES('7429', '1553', '5', '6.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7430', '1553', '5', '6.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7431', '1542', '4', '6.80', '2025-07-09', '1', '1');
INSERT INTO `notas` VALUES('7432', '1542', '4', '6.50', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7433', '1542', '4', '6.80', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7434', '1543', '4', '6.80', '2025-07-09', '1', '1');
INSERT INTO `notas` VALUES('7435', '1543', '4', '6.50', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7436', '1543', '4', '6.90', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7437', '1544', '4', '7.00', '2025-07-09', '1', '1');
INSERT INTO `notas` VALUES('7438', '1544', '4', '6.50', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7439', '1544', '4', '6.90', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7440', '1545', '4', '7.00', '2025-07-09', '1', '1');
INSERT INTO `notas` VALUES('7441', '1545', '4', '7.00', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7442', '1545', '4', '6.90', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7443', '1546', '4', '6.80', '2025-07-09', '1', '1');
INSERT INTO `notas` VALUES('7444', '1546', '4', '6.50', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7445', '1546', '4', '6.80', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7446', '1547', '4', '6.60', '2025-07-09', '1', '1');
INSERT INTO `notas` VALUES('7447', '1547', '4', '6.00', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7448', '1547', '4', '6.60', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7449', '1548', '4', '6.80', '2025-07-09', '1', '1');
INSERT INTO `notas` VALUES('7450', '1548', '4', '6.50', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7451', '1548', '4', '6.90', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7452', '1549', '4', '6.50', '2025-07-09', '1', '1');
INSERT INTO `notas` VALUES('7453', '1549', '4', '7.00', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7454', '1549', '4', '5.60', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7455', '1550', '4', '6.50', '2025-07-09', '1', '1');
INSERT INTO `notas` VALUES('7456', '1550', '4', '6.00', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7457', '1550', '4', '5.60', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7458', '1551', '4', '7.00', '2025-07-09', '1', '1');
INSERT INTO `notas` VALUES('7459', '1551', '4', '6.50', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7460', '1551', '4', '6.20', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7461', '1552', '4', '6.80', '2025-07-09', '1', '1');
INSERT INTO `notas` VALUES('7462', '1552', '4', '6.50', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7463', '1552', '4', '6.80', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7464', '1553', '4', '6.40', '2025-07-09', '1', '1');
INSERT INTO `notas` VALUES('7465', '1553', '4', '6.00', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7466', '1553', '4', '5.60', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7467', '1554', '4', '7.00', '2025-07-09', '1', '1');
INSERT INTO `notas` VALUES('7468', '1554', '4', '6.50', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7469', '1554', '4', '6.70', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7470', '1555', '4', '6.80', '2025-07-09', '1', '1');
INSERT INTO `notas` VALUES('7471', '1555', '4', '6.50', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7472', '1555', '4', '6.70', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7473', '1556', '4', '6.80', '2025-07-09', '1', '1');
INSERT INTO `notas` VALUES('7474', '1556', '4', '7.00', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7475', '1556', '4', '6.90', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7476', '1557', '4', '6.60', '2025-07-09', '1', '1');
INSERT INTO `notas` VALUES('7477', '1557', '4', '6.00', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7478', '1557', '4', '6.70', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7479', '1558', '4', '6.60', '2025-07-09', '1', '1');
INSERT INTO `notas` VALUES('7480', '1558', '4', '6.50', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7481', '1558', '4', '6.30', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7482', '1559', '4', '6.60', '2025-07-09', '1', '1');
INSERT INTO `notas` VALUES('7483', '1559', '4', '6.50', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7484', '1559', '4', '6.90', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7485', '1560', '4', '6.40', '2025-07-09', '1', '1');
INSERT INTO `notas` VALUES('7486', '1560', '4', '6.00', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7487', '1560', '4', '6.10', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7488', '1561', '4', '6.60', '2025-07-09', '1', '1');
INSERT INTO `notas` VALUES('7489', '1561', '4', '6.50', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7490', '1561', '4', '6.30', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7491', '1562', '4', '6.80', '2025-07-09', '1', '1');
INSERT INTO `notas` VALUES('7492', '1562', '4', '7.00', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7493', '1562', '4', '6.90', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7494', '1563', '4', '7.00', '2025-07-09', '1', '1');
INSERT INTO `notas` VALUES('7495', '1563', '4', '7.00', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7496', '1563', '4', '6.90', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7499', '1844', '4', '7.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7500', '1844', '4', '7.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7501', '1845', '4', '5.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7502', '1845', '4', '6.50', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7503', '1846', '4', '6.40', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7504', '1846', '4', '7.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7505', '1847', '4', '5.30', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7506', '1847', '4', '6.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7507', '1848', '4', '7.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7508', '1848', '4', '7.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7509', '1849', '4', '6.60', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7510', '1849', '4', '7.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7511', '1850', '4', '6.70', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7512', '1850', '4', '6.60', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7513', '1851', '4', '7.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7514', '1851', '4', '7.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7515', '1852', '4', '6.60', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7516', '1852', '4', '7.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7517', '1853', '4', '6.30', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7518', '1853', '4', '6.60', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7519', '1854', '4', '6.40', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7520', '1854', '4', '7.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7521', '1855', '4', '7.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7522', '1855', '4', '7.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7523', '1856', '4', '7.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7524', '1856', '4', '7.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7525', '1857', '4', '7.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7526', '1857', '4', '7.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7527', '1858', '4', '7.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7528', '1858', '4', '7.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7529', '1859', '4', '7.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7530', '1859', '4', '7.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7531', '1860', '4', '6.40', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7532', '1860', '4', '6.10', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7533', '1860', '4', '6.40', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7534', '1861', '4', '6.40', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7535', '1861', '4', '7.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7536', '1862', '4', '7.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7537', '1862', '4', '7.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7538', '1863', '4', '6.10', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7539', '1863', '4', '6.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7540', '1877', '4', '6.00', '2025-07-09', '1', '1');
INSERT INTO `notas` VALUES('7541', '1877', '4', '6.00', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7542', '1877', '4', '6.20', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7543', '1877', '4', '7.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7544', '1864', '4', '6.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7545', '1864', '4', '5.40', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7546', '1865', '4', '7.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7547', '1865', '4', '7.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7548', '1866', '4', '5.40', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7549', '1866', '4', '6.50', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7550', '1867', '4', '7.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7551', '1867', '4', '7.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7552', '1868', '4', '7.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7553', '1868', '4', '7.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7554', '1869', '4', '7.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7555', '1869', '4', '7.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7556', '1870', '4', '5.60', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7557', '1870', '4', '5.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7558', '1871', '4', '7.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7559', '1871', '4', '7.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7560', '1873', '4', '7.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7561', '1873', '4', '7.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7562', '1874', '4', '7.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7563', '1874', '4', '7.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7564', '1875', '4', '6.60', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7565', '1875', '4', '7.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7566', '1876', '4', '7.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7567', '1876', '4', '7.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7568', '1878', '1', '5.50', '2025-07-09', '1', '1');
INSERT INTO `notas` VALUES('7569', '1878', '1', '5.90', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7570', '1878', '1', '6.40', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7571', '1878', '1', '6.50', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7572', '1878', '1', '3.20', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('7573', '1878', '1', '6.20', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('7574', '1879', '1', '5.50', '2025-07-09', '1', '1');
INSERT INTO `notas` VALUES('7575', '1879', '1', '4.00', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7576', '1879', '1', '7.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7577', '1879', '1', '5.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7578', '1879', '1', '4.60', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('7579', '1879', '1', '6.00', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('7580', '1880', '1', '6.00', '2025-07-09', '1', '1');
INSERT INTO `notas` VALUES('7581', '1880', '1', '5.00', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7582', '1880', '1', '4.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7583', '1880', '1', '5.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7584', '1880', '1', '5.00', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('7585', '1880', '1', '5.50', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('7586', '1881', '1', '5.50', '2025-07-09', '1', '1');
INSERT INTO `notas` VALUES('7587', '1881', '1', '6.60', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7588', '1881', '1', '7.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7589', '1881', '1', '6.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7590', '1881', '1', '3.00', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('7591', '1881', '1', '4.50', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('7592', '1882', '1', '5.50', '2025-07-09', '1', '1');
INSERT INTO `notas` VALUES('7593', '1882', '1', '6.50', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7594', '1882', '1', '5.90', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7595', '1882', '1', '6.50', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7596', '1882', '1', '5.80', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('7597', '1882', '1', '6.50', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('7598', '1883', '1', '4.00', '2025-07-09', '1', '1');
INSERT INTO `notas` VALUES('7599', '1883', '1', '4.50', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7600', '1883', '1', '6.40', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7601', '1883', '1', '6.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7602', '1883', '1', '5.80', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('7603', '1883', '1', '6.00', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('7604', '1884', '1', '4.80', '2025-07-09', '1', '1');
INSERT INTO `notas` VALUES('7605', '1884', '1', '6.10', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7606', '1884', '1', '6.40', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7607', '1884', '1', '6.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7608', '1884', '1', '5.80', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('7609', '1884', '1', '6.00', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('7610', '1885', '1', '5.00', '2025-07-09', '1', '1');
INSERT INTO `notas` VALUES('7611', '1885', '1', '4.00', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7612', '1885', '1', '3.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7613', '1885', '1', '5.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7614', '1885', '1', '3.00', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('7615', '1885', '1', '3.00', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('7616', '1886', '1', '6.30', '2025-07-09', '1', '1');
INSERT INTO `notas` VALUES('7617', '1886', '1', '5.20', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7618', '1886', '1', '7.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7619', '1886', '1', '7.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7620', '1886', '1', '5.20', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('7621', '1886', '1', '7.00', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('7622', '1887', '1', '4.00', '2025-07-09', '1', '1');
INSERT INTO `notas` VALUES('7623', '1887', '1', '4.50', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7624', '1887', '1', '7.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7625', '1887', '1', '6.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7626', '1887', '1', '5.20', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('7627', '1887', '1', '7.00', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('7628', '1888', '1', '6.30', '2025-07-09', '1', '1');
INSERT INTO `notas` VALUES('7629', '1888', '1', '6.50', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7630', '1888', '1', '7.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7631', '1888', '1', '7.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7632', '1888', '1', '7.00', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('7633', '1888', '1', '7.00', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('7634', '1889', '1', '5.50', '2025-07-09', '1', '1');
INSERT INTO `notas` VALUES('7635', '1889', '1', '6.10', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7636', '1889', '1', '3.20', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7637', '1889', '1', '5.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7638', '1889', '1', '5.20', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('7639', '1889', '1', '6.00', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('7640', '1890', '1', '6.30', '2025-07-09', '1', '1');
INSERT INTO `notas` VALUES('7641', '1890', '1', '5.20', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7642', '1890', '1', '7.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7643', '1890', '1', '6.50', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7644', '1890', '1', '6.40', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('7645', '1890', '1', '7.00', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('7646', '1891', '1', '3.50', '2025-07-09', '1', '1');
INSERT INTO `notas` VALUES('7647', '1891', '1', '6.10', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7648', '1891', '1', '6.40', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7649', '1891', '1', '6.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7650', '1891', '1', '5.20', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('7651', '1891', '1', '7.00', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('7652', '1892', '1', '3.50', '2025-07-09', '1', '1');
INSERT INTO `notas` VALUES('7653', '1892', '1', '5.40', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7654', '1892', '1', '5.90', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7655', '1892', '1', '6.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7656', '1892', '1', '5.80', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('7657', '1892', '1', '7.00', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('7658', '1894', '1', '4.00', '2025-07-09', '1', '1');
INSERT INTO `notas` VALUES('7659', '1894', '1', '5.00', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7660', '1894', '1', '4.80', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7661', '1894', '1', '5.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7662', '1894', '1', '5.80', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('7663', '1894', '1', '5.50', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('7664', '1895', '1', '5.50', '2025-07-09', '1', '1');
INSERT INTO `notas` VALUES('7665', '1895', '1', '5.40', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7666', '1895', '1', '7.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7667', '1895', '1', '6.80', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7668', '1895', '1', '5.20', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('7669', '1895', '1', '7.00', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('7670', '1896', '1', '4.80', '2025-07-09', '1', '1');
INSERT INTO `notas` VALUES('7671', '1896', '1', '4.50', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7672', '1896', '1', '5.90', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7673', '1896', '1', '5.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7674', '1896', '1', '5.80', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('7675', '1896', '1', '3.50', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('7676', '1897', '1', '5.00', '2025-07-09', '1', '1');
INSERT INTO `notas` VALUES('7677', '1897', '1', '5.00', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7678', '1897', '1', '5.90', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7679', '1897', '1', '6.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7680', '1897', '1', '5.80', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('7681', '1897', '1', '7.00', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('7682', '1844', '6', '7.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7683', '1844', '6', '7.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7684', '1845', '6', '5.10', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7685', '1845', '6', '4.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7686', '1846', '6', '4.60', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7687', '1846', '6', '5.10', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7688', '1847', '6', '3.90', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7689', '1847', '6', '4.50', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7690', '1848', '6', '5.60', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7691', '1848', '6', '6.70', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7692', '1849', '6', '5.60', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7693', '1849', '6', '7.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7694', '1850', '6', '6.30', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7695', '1850', '6', '6.40', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7696', '1851', '6', '6.50', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7697', '1851', '6', '6.70', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7698', '1852', '6', '6.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7699', '1852', '6', '6.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7700', '1853', '6', '4.70', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7701', '1853', '6', '4.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7702', '1854', '6', '5.80', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7703', '1854', '6', '5.20', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7704', '1855', '6', '6.10', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7705', '1855', '6', '7.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7706', '1856', '6', '6.10', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7707', '1856', '6', '7.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7708', '1857', '6', '5.60', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7709', '1857', '6', '6.60', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7710', '1858', '6', '6.10', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7711', '1858', '6', '6.40', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7712', '1859', '6', '6.10', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7713', '1859', '6', '6.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7714', '1860', '6', '5.10', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7715', '1860', '6', '4.20', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7716', '1861', '6', '5.30', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7717', '1861', '6', '6.10', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7718', '1862', '6', '5.30', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7719', '1862', '6', '7.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7720', '1863', '6', '3.40', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7721', '1863', '6', '5.70', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7722', '1877', '6', '5.00', '2025-07-09', '1', '1');
INSERT INTO `notas` VALUES('7723', '1877', '6', '5.10', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7724', '1877', '6', '5.10', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7725', '1877', '6', '5.40', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7726', '1864', '6', '3.60', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7727', '1864', '6', '4.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7728', '1865', '6', '6.50', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7729', '1865', '6', '6.40', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7730', '1866', '6', '4.50', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7731', '1866', '6', '4.20', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7732', '1866', '6', '4.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7733', '1867', '6', '6.50', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7734', '1867', '6', '7.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7735', '1868', '6', '5.60', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7736', '1868', '6', '7.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7737', '1869', '6', '6.20', '2025-07-09', '1', '1');
INSERT INTO `notas` VALUES('7738', '1869', '6', '6.30', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7739', '1869', '6', '6.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7740', '1870', '6', '4.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7741', '1870', '6', '5.10', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7742', '1871', '6', '6.80', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7743', '1871', '6', '7.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7744', '1873', '6', '6.30', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7745', '1873', '6', '7.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7746', '1874', '6', '5.80', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7747', '1874', '6', '6.40', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7748', '1875', '6', '5.40', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7749', '1875', '6', '4.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7750', '1876', '6', '6.70', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7751', '1876', '6', '7.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7752', '1687', '11', '5.30', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7753', '1878', '2', '5.00', '2025-07-09', '1', '1');
INSERT INTO `notas` VALUES('7754', '1878', '2', '7.00', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7755', '1878', '2', '6.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7756', '1878', '2', '7.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7757', '1878', '2', '6.50', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('7758', '1878', '2', '6.00', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('7759', '1879', '2', '2.60', '2025-07-09', '1', '1');
INSERT INTO `notas` VALUES('7760', '1879', '2', '4.30', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7761', '1879', '2', '4.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7762', '1879', '2', '6.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7763', '1879', '2', '5.50', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('7764', '1879', '2', '6.20', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('7765', '1880', '2', '5.50', '2025-07-09', '1', '1');
INSERT INTO `notas` VALUES('7766', '1880', '2', '6.30', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7767', '1880', '2', '5.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7768', '1880', '2', '4.50', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7769', '1880', '2', '5.50', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('7770', '1880', '2', '6.00', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('7771', '1881', '2', '5.00', '2025-07-09', '1', '1');
INSERT INTO `notas` VALUES('7772', '1881', '2', '6.40', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7773', '1881', '2', '6.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7774', '1881', '2', '5.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7775', '1881', '2', '5.00', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('7776', '1881', '2', '5.50', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('7777', '1882', '2', '5.60', '2025-07-09', '1', '1');
INSERT INTO `notas` VALUES('7778', '1882', '2', '6.40', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7779', '1882', '2', '6.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7780', '1882', '2', '6.50', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7781', '1882', '2', '6.00', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('7782', '1882', '2', '6.50', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('7783', '1883', '2', '5.90', '2025-07-09', '1', '1');
INSERT INTO `notas` VALUES('7784', '1883', '2', '7.00', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7785', '1883', '2', '7.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7786', '1883', '2', '6.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7787', '1883', '2', '6.00', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('7788', '1883', '2', '7.00', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('7789', '1884', '2', '4.90', '2025-07-09', '1', '1');
INSERT INTO `notas` VALUES('7790', '1884', '2', '6.80', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7791', '1884', '2', '6.50', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7792', '1884', '2', '6.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7793', '1884', '2', '6.50', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('7794', '1884', '2', '7.00', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('7795', '1885', '2', '4.90', '2025-07-09', '1', '1');
INSERT INTO `notas` VALUES('7796', '1885', '2', '3.40', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7797', '1885', '2', '5.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7798', '1885', '2', '4.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7799', '1885', '2', '4.00', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('7800', '1885', '2', '4.50', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('7801', '1886', '2', '5.20', '2025-07-09', '1', '1');
INSERT INTO `notas` VALUES('7802', '1886', '2', '6.60', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7803', '1886', '2', '7.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7804', '1886', '2', '7.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7805', '1886', '2', '7.00', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('7806', '1886', '2', '7.00', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('7807', '1887', '2', '4.60', '2025-07-09', '1', '1');
INSERT INTO `notas` VALUES('7808', '1887', '2', '3.80', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7809', '1887', '2', '7.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7810', '1887', '2', '6.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7811', '1887', '2', '5.50', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('7812', '1887', '2', '6.00', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('7813', '1888', '2', '5.10', '2025-07-09', '1', '1');
INSERT INTO `notas` VALUES('7814', '1888', '2', '6.80', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7815', '1888', '2', '7.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7816', '1888', '2', '7.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7817', '1888', '2', '7.00', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('7818', '1888', '2', '7.00', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('7819', '1889', '2', '4.00', '2025-07-09', '1', '1');
INSERT INTO `notas` VALUES('7820', '1889', '2', '4.50', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7821', '1889', '2', '5.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7822', '1889', '2', '5.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7823', '1889', '2', '5.50', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('7824', '1889', '2', '6.00', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('7825', '1890', '2', '4.10', '2025-07-09', '1', '1');
INSERT INTO `notas` VALUES('7826', '1890', '2', '6.50', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7827', '1890', '2', '7.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7828', '1890', '2', '7.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7829', '1890', '2', '7.00', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('7830', '1890', '2', '7.00', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('7831', '1891', '2', '4.30', '2025-07-09', '1', '1');
INSERT INTO `notas` VALUES('7832', '1891', '2', '5.80', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7833', '1891', '2', '6.80', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7834', '1891', '2', '6.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7835', '1891', '2', '7.00', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('7836', '1891', '2', '7.00', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('7837', '1892', '2', '4.40', '2025-07-09', '1', '1');
INSERT INTO `notas` VALUES('7838', '1892', '2', '6.80', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7839', '1892', '2', '7.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7840', '1892', '2', '7.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7841', '1892', '2', '7.00', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('7842', '1892', '2', '7.00', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('7843', '1894', '2', '3.00', '2025-07-09', '1', '1');
INSERT INTO `notas` VALUES('7844', '1894', '2', '5.00', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7845', '1894', '2', '5.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7846', '1894', '2', '5.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7847', '1894', '2', '5.00', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('7848', '1894', '2', '5.50', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('7849', '1895', '2', '5.00', '2025-07-09', '1', '1');
INSERT INTO `notas` VALUES('7850', '1895', '2', '5.80', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7851', '1895', '2', '7.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7852', '1895', '2', '6.80', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7853', '1895', '2', '7.00', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('7854', '1895', '2', '7.00', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('7855', '1896', '2', '4.70', '2025-07-09', '1', '1');
INSERT INTO `notas` VALUES('7856', '1896', '2', '7.00', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7857', '1896', '2', '6.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7858', '1896', '2', '6.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7859', '1896', '2', '5.00', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('7860', '1896', '2', '5.00', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('7861', '1897', '2', '4.10', '2025-07-09', '1', '1');
INSERT INTO `notas` VALUES('7862', '1897', '2', '5.80', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7863', '1897', '2', '6.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7864', '1897', '2', '6.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7865', '1897', '2', '7.00', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('7866', '1897', '2', '7.00', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('7867', '1585', '1', '6.30', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7868', '1585', '1', '4.30', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7869', '1585', '1', '5.80', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('7870', '1585', '1', '5.00', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('7871', '1586', '1', '4.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7872', '1586', '1', '6.00', '2025-07-09', '1', '5');
INSERT INTO `notas` VALUES('7873', '1586', '1', '5.00', '2025-07-09', '1', '6');
INSERT INTO `notas` VALUES('7874', '1675', '8', '7.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7875', '1675', '8', '6.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7876', '1676', '8', '4.40', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7877', '1676', '8', '5.20', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7878', '1677', '8', '6.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7879', '1677', '8', '6.70', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7880', '1678', '8', '6.30', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7881', '1678', '8', '5.90', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7882', '1679', '8', '5.10', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7883', '1679', '8', '5.70', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7884', '1680', '8', '6.30', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7885', '1680', '8', '6.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7886', '1681', '8', '5.50', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7887', '1681', '8', '6.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7888', '1682', '8', '4.40', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7889', '1682', '8', '5.90', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7890', '1683', '8', '5.10', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7891', '1683', '8', '6.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7892', '1684', '8', '5.50', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7893', '1684', '8', '6.30', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7894', '1685', '8', '6.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7895', '1685', '8', '5.60', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7896', '1686', '8', '5.10', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7897', '1686', '8', '5.10', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7898', '1686', '8', '5.20', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7899', '1687', '8', '5.60', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7900', '1687', '8', '5.50', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7901', '1688', '8', '3.20', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7902', '1688', '8', '5.90', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7903', '1689', '8', '5.10', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7904', '1689', '8', '5.40', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7905', '1690', '8', '4.40', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7906', '1690', '8', '6.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7907', '1691', '8', '4.80', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7908', '1691', '8', '5.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7909', '1844', '7', '7.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7910', '1844', '7', '7.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7911', '1845', '7', '4.40', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7912', '1845', '7', '4.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7913', '1846', '7', '3.80', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7914', '1846', '7', '5.10', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7915', '1847', '7', '5.70', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7916', '1847', '7', '4.50', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7917', '1848', '7', '6.30', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7918', '1848', '7', '6.70', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7919', '1849', '7', '5.90', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7920', '1849', '7', '7.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7921', '1850', '7', '5.90', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7922', '1850', '7', '6.40', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7923', '1851', '7', '6.30', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7924', '1851', '7', '6.70', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7925', '1852', '7', '4.60', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7926', '1852', '7', '6.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7927', '1853', '7', '6.60', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7928', '1853', '7', '4.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7929', '1854', '7', '6.60', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7930', '1854', '7', '5.20', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7931', '1855', '7', '6.10', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7932', '1855', '7', '7.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7933', '1856', '7', '6.30', '2025-07-09', '1', '1');
INSERT INTO `notas` VALUES('7934', '1856', '7', '5.90', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7935', '1856', '7', '7.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7936', '1857', '7', '5.20', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7937', '1857', '7', '6.60', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7938', '1858', '7', '6.30', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7939', '1858', '7', '6.40', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7940', '1859', '7', '6.30', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7941', '1859', '7', '6.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7942', '1860', '7', '5.40', '2025-07-09', '1', '1');
INSERT INTO `notas` VALUES('7943', '1860', '7', '6.80', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7944', '1860', '7', '4.20', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7945', '1861', '7', '6.30', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7946', '1861', '7', '6.10', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7947', '1862', '7', '5.50', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7948', '1862', '7', '7.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7949', '1863', '7', '3.70', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7950', '1863', '7', '5.70', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7951', '1877', '7', '4.90', '2025-07-09', '1', '1');
INSERT INTO `notas` VALUES('7952', '1877', '7', '5.00', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7953', '1877', '7', '5.20', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7954', '1877', '7', '5.40', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7955', '1864', '7', '3.60', '2025-07-09', '1', '1');
INSERT INTO `notas` VALUES('7956', '1864', '7', '4.40', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7957', '1864', '7', '4.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7958', '1865', '7', '6.60', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7959', '1865', '7', '6.40', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7960', '1866', '7', '4.60', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7961', '1866', '7', '4.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7962', '1867', '7', '6.60', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7963', '1867', '7', '7.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7964', '1868', '7', '6.10', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7965', '1868', '7', '7.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7966', '1869', '7', '6.80', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7967', '1869', '7', '6.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7968', '1870', '7', '3.70', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7969', '1870', '7', '5.10', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7970', '1871', '7', '5.90', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7971', '1871', '7', '7.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7972', '1873', '7', '6.80', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7973', '1873', '7', '7.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7974', '1874', '7', '6.80', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7975', '1874', '7', '6.40', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7976', '1875', '7', '4.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7977', '1875', '7', '4.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7978', '1876', '7', '7.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7979', '1876', '7', '7.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7980', '1878', '6', '3.90', '2025-07-09', '1', '1');
INSERT INTO `notas` VALUES('7981', '1878', '6', '6.80', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7982', '1878', '6', '6.50', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7983', '1878', '6', '6.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7984', '1879', '6', '4.40', '2025-07-09', '1', '1');
INSERT INTO `notas` VALUES('7985', '1879', '6', '4.90', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7986', '1879', '6', '5.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7987', '1879', '6', '6.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7988', '1880', '6', '5.50', '2025-07-09', '1', '1');
INSERT INTO `notas` VALUES('7989', '1880', '6', '6.00', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7990', '1880', '6', '4.50', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7991', '1880', '6', '6.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7992', '1881', '6', '3.90', '2025-07-09', '1', '1');
INSERT INTO `notas` VALUES('7993', '1881', '6', '4.70', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7994', '1881', '6', '3.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7995', '1881', '6', '5.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('7996', '1882', '6', '4.40', '2025-07-09', '1', '1');
INSERT INTO `notas` VALUES('7997', '1882', '6', '5.50', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('7998', '1882', '6', '6.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('7999', '1882', '6', '6.50', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('8000', '1883', '6', '3.40', '2025-07-09', '1', '1');
INSERT INTO `notas` VALUES('8001', '1883', '6', '4.10', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('8002', '1883', '6', '5.50', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('8003', '1883', '6', '6.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('8004', '1884', '6', '2.80', '2025-07-09', '1', '1');
INSERT INTO `notas` VALUES('8005', '1884', '6', '6.50', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('8006', '1884', '6', '5.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('8007', '1884', '6', '6.50', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('8008', '1885', '6', '3.80', '2025-07-09', '1', '1');
INSERT INTO `notas` VALUES('8009', '1885', '6', '4.20', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('8010', '1885', '6', '3.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('8011', '1885', '6', '5.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('8012', '1886', '6', '5.20', '2025-07-09', '1', '1');
INSERT INTO `notas` VALUES('8013', '1886', '6', '7.00', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('8014', '1886', '6', '7.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('8015', '1886', '6', '7.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('8016', '1887', '6', '5.20', '2025-07-09', '1', '1');
INSERT INTO `notas` VALUES('8017', '1887', '6', '5.00', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('8018', '1887', '6', '6.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('8019', '1887', '6', '6.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('8020', '1888', '6', '5.50', '2025-07-09', '1', '1');
INSERT INTO `notas` VALUES('8021', '1888', '6', '6.80', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('8022', '1888', '6', '7.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('8023', '1888', '6', '7.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('8024', '1889', '6', '3.20', '2025-07-09', '1', '1');
INSERT INTO `notas` VALUES('8025', '1889', '6', '2.20', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('8026', '1889', '6', '5.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('8027', '1889', '6', '5.50', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('8028', '1890', '6', '4.80', '2025-07-09', '1', '1');
INSERT INTO `notas` VALUES('8029', '1890', '6', '5.80', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('8030', '1890', '6', '7.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('8031', '1890', '6', '7.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('8032', '1891', '6', '3.20', '2025-07-09', '1', '1');
INSERT INTO `notas` VALUES('8033', '1891', '6', '6.10', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('8034', '1891', '6', '7.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('8035', '1891', '6', '7.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('8036', '1892', '6', '4.60', '2025-07-09', '1', '1');
INSERT INTO `notas` VALUES('8037', '1892', '6', '6.00', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('8038', '1892', '6', '6.50', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('8039', '1892', '6', '7.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('8040', '1894', '6', '4.10', '2025-07-09', '1', '1');
INSERT INTO `notas` VALUES('8041', '1894', '6', '4.30', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('8042', '1894', '6', '5.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('8043', '1894', '6', '5.50', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('8044', '1895', '6', '4.60', '2025-07-09', '1', '1');
INSERT INTO `notas` VALUES('8045', '1895', '6', '7.00', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('8046', '1895', '6', '7.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('8047', '1895', '6', '7.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('8048', '1896', '6', '5.90', '2025-07-09', '1', '1');
INSERT INTO `notas` VALUES('8049', '1896', '6', '6.50', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('8050', '1896', '6', '3.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('8051', '1896', '6', '5.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('8052', '1897', '6', '4.40', '2025-07-09', '1', '1');
INSERT INTO `notas` VALUES('8053', '1897', '6', '5.20', '2025-07-09', '1', '2');
INSERT INTO `notas` VALUES('8054', '1897', '6', '7.00', '2025-07-09', '1', '3');
INSERT INTO `notas` VALUES('8055', '1897', '6', '7.00', '2025-07-09', '1', '4');
INSERT INTO `notas` VALUES('8056', '1719', '6', '7.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8057', '1878', '12', '6.50', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8058', '1879', '12', '6.60', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8059', '1880', '12', '6.00', '2025-07-10', '1', '1');
INSERT INTO `notas` VALUES('8060', '1880', '12', '6.00', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8061', '1880', '12', '5.60', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8062', '1881', '12', '6.40', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8063', '1882', '12', '6.70', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8064', '1883', '12', '6.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8065', '1884', '12', '6.30', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8066', '1885', '12', '5.70', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8067', '1886', '12', '7.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8068', '1887', '12', '6.40', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8069', '1888', '12', '6.60', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8070', '1889', '12', '6.60', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8071', '1890', '12', '6.30', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8072', '1891', '12', '6.60', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8073', '1892', '12', '6.70', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8074', '1894', '12', '6.10', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8075', '1895', '12', '6.60', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8076', '1896', '12', '5.40', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8077', '1897', '12', '6.40', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8078', '1878', '3', '7.00', '2025-07-10', '1', '1');
INSERT INTO `notas` VALUES('8079', '1878', '3', '7.00', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8080', '1878', '3', '6.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8081', '1878', '3', '5.40', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8082', '1879', '3', '7.00', '2025-07-10', '1', '1');
INSERT INTO `notas` VALUES('8083', '1879', '3', '7.00', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8084', '1879', '3', '7.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8085', '1879', '3', '6.00', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8086', '1880', '3', '7.00', '2025-07-10', '1', '1');
INSERT INTO `notas` VALUES('8087', '1880', '3', '7.00', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8088', '1880', '3', '6.50', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8089', '1880', '3', '6.10', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8090', '1881', '3', '7.00', '2025-07-10', '1', '1');
INSERT INTO `notas` VALUES('8091', '1881', '3', '7.00', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8092', '1881', '3', '4.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8093', '1881', '3', '4.70', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8094', '1882', '3', '7.00', '2025-07-10', '1', '1');
INSERT INTO `notas` VALUES('8095', '1882', '3', '7.00', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8096', '1882', '3', '4.50', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8097', '1882', '3', '5.30', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8098', '1883', '3', '7.00', '2025-07-10', '1', '1');
INSERT INTO `notas` VALUES('8099', '1883', '3', '7.00', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8100', '1883', '3', '4.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8101', '1883', '3', '5.20', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8102', '1884', '3', '7.00', '2025-07-10', '1', '1');
INSERT INTO `notas` VALUES('8103', '1884', '3', '7.00', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8104', '1884', '3', '4.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8105', '1884', '3', '5.80', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8106', '1885', '3', '7.00', '2025-07-10', '1', '1');
INSERT INTO `notas` VALUES('8107', '1885', '3', '7.00', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8108', '1885', '3', '6.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8109', '1885', '3', '4.70', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8110', '1886', '3', '7.00', '2025-07-10', '1', '1');
INSERT INTO `notas` VALUES('8111', '1886', '3', '7.00', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8112', '1886', '3', '4.50', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8113', '1886', '3', '5.70', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8114', '1887', '3', '7.00', '2025-07-10', '1', '1');
INSERT INTO `notas` VALUES('8115', '1887', '3', '7.00', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8116', '1887', '3', '4.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8117', '1887', '3', '6.10', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8118', '1888', '3', '7.00', '2025-07-10', '1', '1');
INSERT INTO `notas` VALUES('8119', '1888', '3', '7.00', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8120', '1888', '3', '5.50', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8121', '1888', '3', '6.70', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8122', '1889', '3', '7.00', '2025-07-10', '1', '1');
INSERT INTO `notas` VALUES('8123', '1889', '3', '7.00', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8124', '1889', '3', '4.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8125', '1889', '3', '4.90', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8126', '1890', '3', '7.00', '2025-07-10', '1', '1');
INSERT INTO `notas` VALUES('8127', '1890', '3', '7.00', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8128', '1890', '3', '4.50', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8129', '1890', '3', '5.00', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8130', '1891', '3', '7.00', '2025-07-10', '1', '1');
INSERT INTO `notas` VALUES('8131', '1891', '3', '7.00', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8132', '1891', '3', '7.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8133', '1891', '3', '6.00', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8134', '1892', '3', '7.00', '2025-07-10', '1', '1');
INSERT INTO `notas` VALUES('8135', '1892', '3', '7.00', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8136', '1892', '3', '4.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8137', '1892', '3', '6.00', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8138', '1894', '3', '7.00', '2025-07-10', '1', '1');
INSERT INTO `notas` VALUES('8139', '1894', '3', '7.00', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8140', '1894', '3', '4.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8141', '1894', '3', '4.70', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8142', '1895', '3', '7.00', '2025-07-10', '1', '1');
INSERT INTO `notas` VALUES('8143', '1895', '3', '7.00', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8144', '1895', '3', '4.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8145', '1895', '3', '5.70', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8146', '1896', '3', '7.00', '2025-07-10', '1', '1');
INSERT INTO `notas` VALUES('8147', '1896', '3', '7.00', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8148', '1896', '3', '6.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8149', '1896', '3', '5.00', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8150', '1897', '3', '7.00', '2025-07-10', '1', '1');
INSERT INTO `notas` VALUES('8151', '1897', '3', '7.00', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8152', '1897', '3', '7.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8153', '1897', '3', '7.00', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8154', '1564', '7', '7.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8155', '1564', '7', '6.60', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8156', '1565', '7', '6.70', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8157', '1565', '7', '6.30', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8158', '1566', '7', '5.50', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8159', '1566', '7', '5.40', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8160', '1567', '7', '6.10', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8161', '1567', '7', '6.60', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8162', '1568', '7', '6.40', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8163', '1568', '7', '7.00', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8164', '1569', '7', '6.10', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8165', '1569', '7', '7.00', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8166', '1570', '7', '6.40', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8167', '1570', '7', '6.50', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8168', '1571', '7', '7.00', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8169', '1571', '7', '6.40', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8170', '1571', '7', '7.00', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8171', '1572', '7', '7.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8172', '1572', '7', '7.00', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8173', '1573', '7', '6.70', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8174', '1573', '7', '6.50', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8175', '1574', '7', '6.70', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8176', '1574', '7', '6.00', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8177', '1575', '7', '6.40', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8178', '1575', '7', '7.00', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8179', '1576', '7', '5.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8180', '1576', '7', '6.30', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8181', '1577', '7', '6.10', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8182', '1577', '7', '6.20', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8183', '1578', '7', '6.10', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8184', '1578', '7', '6.80', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8185', '1579', '7', '6.70', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8186', '1579', '7', '6.80', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8187', '1580', '7', '5.80', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8188', '1580', '7', '6.50', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8189', '1581', '7', '5.50', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8190', '1581', '7', '7.00', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8191', '1582', '7', '6.50', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8192', '1582', '7', '5.50', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8193', '1582', '7', '6.00', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8194', '1583', '7', '6.40', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8195', '1583', '7', '6.50', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8196', '1584', '7', '5.80', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8197', '1584', '7', '6.10', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8198', '1564', '12', '6.80', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8199', '1565', '12', '6.30', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8200', '1566', '12', '5.40', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8201', '1567', '12', '6.60', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8202', '1568', '12', '7.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8203', '1569', '12', '7.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8204', '1570', '12', '6.50', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8205', '1571', '12', '7.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8206', '1572', '12', '7.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8207', '1573', '12', '6.50', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8208', '1574', '12', '6.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8209', '1575', '12', '7.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8210', '1576', '12', '6.30', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8211', '1577', '12', '6.20', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8212', '1578', '12', '6.80', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8213', '1579', '12', '6.80', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8214', '1580', '12', '6.50', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8215', '1581', '12', '7.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8216', '1582', '12', '7.00', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8217', '1582', '12', '6.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8218', '1583', '12', '6.50', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8219', '1584', '12', '6.10', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8220', '1564', '4', '6.80', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8221', '1565', '4', '6.30', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8222', '1566', '4', '5.40', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8223', '1567', '4', '6.60', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8224', '1568', '4', '7.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8225', '1569', '4', '7.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8226', '1570', '4', '6.50', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8227', '1571', '4', '7.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8228', '1572', '4', '7.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8229', '1573', '4', '6.50', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8230', '1574', '4', '6.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8231', '1575', '4', '7.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8232', '1576', '4', '6.30', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8233', '1577', '4', '6.20', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8234', '1578', '4', '6.80', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8235', '1579', '4', '6.80', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8236', '1580', '4', '6.50', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8237', '1581', '4', '7.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8238', '1582', '4', '7.00', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8239', '1582', '4', '6.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8240', '1583', '4', '6.50', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8241', '1584', '4', '6.10', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8242', '1564', '3', '7.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8243', '1564', '3', '6.80', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8244', '1565', '3', '6.80', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8245', '1565', '3', '6.10', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8246', '1566', '3', '6.00', '2025-07-10', '1', '1');
INSERT INTO `notas` VALUES('8247', '1566', '3', '7.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8248', '1566', '3', '6.10', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8249', '1567', '3', '7.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8250', '1567', '3', '6.30', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8251', '1568', '3', '7.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8252', '1568', '3', '6.70', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8253', '1569', '3', '7.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8254', '1569', '3', '6.90', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8255', '1570', '3', '7.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8256', '1570', '3', '6.50', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8257', '1571', '3', '6.80', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8258', '1571', '3', '7.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8259', '1571', '3', '6.70', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8260', '1572', '3', '7.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8261', '1572', '3', '6.40', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8262', '1573', '3', '5.00', '2025-07-10', '1', '1');
INSERT INTO `notas` VALUES('8263', '1573', '3', '6.80', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8264', '1573', '3', '6.00', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8265', '1574', '3', '5.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8266', '1574', '3', '5.50', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8267', '1575', '3', '7.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8268', '1575', '3', '7.00', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8269', '1576', '3', '7.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8270', '1576', '3', '6.30', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8271', '1577', '3', '6.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8272', '1577', '3', '6.00', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8273', '1578', '3', '7.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8274', '1578', '3', '6.80', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8275', '1579', '3', '7.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8276', '1579', '3', '6.40', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8277', '1580', '3', '6.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8278', '1580', '3', '6.00', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8279', '1581', '3', '6.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8280', '1581', '3', '5.50', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8281', '1582', '3', '7.00', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8282', '1582', '3', '7.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8283', '1582', '3', '7.00', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8284', '1583', '3', '7.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8285', '1583', '3', '6.20', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8286', '1584', '3', '5.50', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8287', '1584', '3', '5.60', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8288', '1675', '2', '5.90', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8289', '1675', '2', '1.50', '2025-07-10', '1', '5');
INSERT INTO `notas` VALUES('8290', '1675', '2', '5.00', '2025-07-10', '1', '6');
INSERT INTO `notas` VALUES('8291', '1676', '2', '5.90', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8292', '1676', '2', '5.90', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8293', '1676', '2', '5.90', '2025-07-10', '1', '5');
INSERT INTO `notas` VALUES('8294', '1676', '2', '4.90', '2025-07-10', '1', '6');
INSERT INTO `notas` VALUES('8295', '1677', '2', '7.00', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8296', '1677', '2', '7.00', '2025-07-10', '1', '5');
INSERT INTO `notas` VALUES('8297', '1677', '2', '5.90', '2025-07-10', '1', '6');
INSERT INTO `notas` VALUES('8298', '1678', '2', '5.00', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8299', '1678', '2', '6.00', '2025-07-10', '1', '5');
INSERT INTO `notas` VALUES('8300', '1678', '2', '5.20', '2025-07-10', '1', '6');
INSERT INTO `notas` VALUES('8301', '1679', '2', '2.00', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8302', '1679', '2', '1.40', '2025-07-10', '1', '5');
INSERT INTO `notas` VALUES('8303', '1679', '2', '4.40', '2025-07-10', '1', '6');
INSERT INTO `notas` VALUES('8304', '1680', '2', '5.30', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8305', '1680', '2', '7.00', '2025-07-10', '1', '5');
INSERT INTO `notas` VALUES('8306', '1680', '2', '6.40', '2025-07-10', '1', '6');
INSERT INTO `notas` VALUES('8307', '1681', '2', '5.40', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8308', '1681', '2', '5.10', '2025-07-10', '1', '5');
INSERT INTO `notas` VALUES('8309', '1681', '2', '5.10', '2025-07-10', '1', '6');
INSERT INTO `notas` VALUES('8310', '1682', '2', '2.10', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8311', '1682', '2', '3.80', '2025-07-10', '1', '5');
INSERT INTO `notas` VALUES('8312', '1682', '2', '5.10', '2025-07-10', '1', '6');
INSERT INTO `notas` VALUES('8313', '1683', '2', '5.40', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8314', '1683', '2', '7.00', '2025-07-10', '1', '5');
INSERT INTO `notas` VALUES('8315', '1683', '2', '5.70', '2025-07-10', '1', '6');
INSERT INTO `notas` VALUES('8316', '1684', '2', '3.20', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8317', '1684', '2', '5.00', '2025-07-10', '1', '5');
INSERT INTO `notas` VALUES('8318', '1684', '2', '5.70', '2025-07-10', '1', '6');
INSERT INTO `notas` VALUES('8319', '1685', '2', '2.50', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8320', '1685', '2', '3.60', '2025-07-10', '1', '5');
INSERT INTO `notas` VALUES('8321', '1685', '2', '4.50', '2025-07-10', '1', '6');
INSERT INTO `notas` VALUES('8322', '1686', '2', '4.00', '2025-07-10', '1', '1');
INSERT INTO `notas` VALUES('8323', '1686', '2', '4.00', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8324', '1686', '2', '4.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8325', '1686', '2', '4.00', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8326', '1686', '2', '4.00', '2025-07-10', '1', '5');
INSERT INTO `notas` VALUES('8327', '1686', '2', '5.10', '2025-07-10', '1', '6');
INSERT INTO `notas` VALUES('8328', '1687', '2', '6.20', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8329', '1687', '2', '2.00', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8330', '1687', '2', '1.70', '2025-07-10', '1', '5');
INSERT INTO `notas` VALUES('8331', '1687', '2', '5.10', '2025-07-10', '1', '6');
INSERT INTO `notas` VALUES('8332', '1688', '2', '2.10', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8333', '1688', '2', '2.30', '2025-07-10', '1', '5');
INSERT INTO `notas` VALUES('8334', '1688', '2', '4.40', '2025-07-10', '1', '6');
INSERT INTO `notas` VALUES('8335', '1689', '2', '2.40', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8336', '1689', '2', '1.70', '2025-07-10', '1', '5');
INSERT INTO `notas` VALUES('8337', '1689', '2', '4.00', '2025-07-10', '1', '6');
INSERT INTO `notas` VALUES('8338', '1690', '2', '2.90', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8339', '1690', '2', '4.00', '2025-07-10', '1', '5');
INSERT INTO `notas` VALUES('8340', '1690', '2', '5.60', '2025-07-10', '1', '6');
INSERT INTO `notas` VALUES('8341', '1691', '2', '5.00', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8342', '1691', '2', '5.00', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8343', '1691', '2', '5.00', '2025-07-10', '1', '5');
INSERT INTO `notas` VALUES('8344', '1691', '2', '5.80', '2025-07-10', '1', '6');
INSERT INTO `notas` VALUES('8345', '1565', '5', '7.00', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8346', '1566', '5', '7.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8347', '1571', '5', '7.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8348', '1574', '5', '7.00', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8349', '1581', '5', '6.50', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8350', '1584', '5', '6.00', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8351', '1675', '7', '6.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8352', '1675', '7', '5.50', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8353', '1676', '7', '4.30', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8354', '1676', '7', '4.20', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8355', '1676', '7', '4.50', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8356', '1677', '7', '7.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8357', '1677', '7', '6.80', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8358', '1678', '7', '7.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8359', '1678', '7', '6.40', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8360', '1679', '7', '7.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8361', '1679', '7', '6.40', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8362', '1680', '7', '5.30', '2025-07-10', '1', '1');
INSERT INTO `notas` VALUES('8363', '1680', '7', '5.80', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8364', '1680', '7', '6.00', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8365', '1681', '7', '5.10', '2025-07-10', '1', '1');
INSERT INTO `notas` VALUES('8366', '1681', '7', '5.00', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8367', '1681', '7', '5.50', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8368', '1681', '7', '6.00', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8369', '1682', '7', '5.80', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8370', '1682', '7', '5.50', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8371', '1683', '7', '5.80', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8372', '1683', '7', '5.50', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8373', '1684', '7', '6.10', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8374', '1684', '7', '6.20', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8375', '1685', '7', '6.40', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8376', '1685', '7', '6.20', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8377', '1686', '7', '5.00', '2025-07-10', '1', '1');
INSERT INTO `notas` VALUES('8378', '1686', '7', '5.40', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8379', '1686', '7', '5.10', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8380', '1686', '7', '6.00', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8381', '1687', '7', '4.40', '2025-07-10', '1', '1');
INSERT INTO `notas` VALUES('8382', '1687', '7', '5.20', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8383', '1687', '7', '4.80', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8384', '1687', '7', '5.00', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8385', '1688', '7', '6.20', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8386', '1688', '7', '5.60', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8387', '1688', '7', '5.50', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8388', '1689', '7', '5.70', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8389', '1689', '7', '5.90', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8390', '1690', '7', '6.20', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8391', '1690', '7', '6.20', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8392', '1691', '7', '5.50', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8393', '1691', '7', '5.00', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8394', '1675', '4', '7.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8395', '1675', '4', '6.00', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8396', '1676', '4', '7.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8397', '1676', '4', '6.40', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8398', '1677', '4', '7.00', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8399', '1678', '4', '6.70', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8400', '1679', '4', '7.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8401', '1679', '4', '6.70', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8402', '1680', '4', '6.50', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8403', '1681', '4', '6.20', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8404', '1682', '4', '6.30', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8405', '1683', '4', '6.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8406', '1683', '4', '6.00', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8407', '1684', '4', '6.30', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8408', '1685', '4', '6.70', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8409', '1686', '4', '6.00', '2025-07-10', '1', '1');
INSERT INTO `notas` VALUES('8410', '1686', '4', '6.00', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8411', '1686', '4', '6.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8412', '1686', '4', '6.00', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8413', '1687', '4', '5.20', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8414', '1688', '4', '6.00', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8415', '1689', '4', '6.00', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8416', '1690', '4', '7.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8417', '1690', '4', '6.70', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8418', '1691', '4', '6.50', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8419', '1675', '5', '7.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8420', '1675', '5', '6.80', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8421', '1676', '5', '7.00', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8422', '1676', '5', '2.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8423', '1676', '5', '5.40', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8424', '1677', '5', '6.10', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8425', '1677', '5', '7.00', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8426', '1678', '5', '7.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8427', '1678', '5', '7.00', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8428', '1679', '5', '7.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8429', '1679', '5', '7.00', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8430', '1680', '5', '6.70', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8431', '1680', '5', '7.00', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8432', '1681', '5', '6.70', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8433', '1681', '5', '6.80', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8434', '1682', '5', '6.10', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8435', '1682', '5', '6.30', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8436', '1683', '5', '6.10', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8437', '1683', '5', '6.30', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8438', '1684', '5', '5.80', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8439', '1684', '5', '6.20', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8440', '1685', '5', '7.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8441', '1685', '5', '6.20', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8442', '1686', '5', '7.00', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8443', '1686', '5', '6.40', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8444', '1686', '5', '5.60', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8445', '1687', '5', '5.50', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8446', '1687', '5', '5.10', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8447', '1688', '5', '6.10', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8448', '1688', '5', '6.20', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8449', '1689', '5', '6.70', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8450', '1689', '5', '5.80', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8451', '1690', '5', '6.70', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8452', '1690', '5', '6.50', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8453', '1691', '5', '7.00', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8454', '1691', '5', '5.20', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8455', '1691', '5', '4.90', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8456', '1878', '7', '4.00', '2025-07-10', '1', '1');
INSERT INTO `notas` VALUES('8457', '1878', '7', '7.00', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8458', '1878', '7', '7.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8459', '1878', '7', '7.00', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8460', '1879', '7', '5.60', '2025-07-10', '1', '1');
INSERT INTO `notas` VALUES('8461', '1879', '7', '5.30', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8462', '1879', '7', '7.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8463', '1879', '7', '7.00', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8464', '1880', '7', '5.50', '2025-07-10', '1', '1');
INSERT INTO `notas` VALUES('8465', '1880', '7', '4.80', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8466', '1880', '7', '7.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8467', '1880', '7', '6.00', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8468', '1881', '7', '4.10', '2025-07-10', '1', '1');
INSERT INTO `notas` VALUES('8469', '1881', '7', '6.00', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8470', '1881', '7', '7.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8471', '1881', '7', '5.00', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8472', '1882', '7', '5.80', '2025-07-10', '1', '1');
INSERT INTO `notas` VALUES('8473', '1882', '7', '6.00', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8474', '1882', '7', '7.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8475', '1882', '7', '6.00', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8476', '1883', '7', '4.00', '2025-07-10', '1', '1');
INSERT INTO `notas` VALUES('8477', '1883', '7', '4.30', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8478', '1883', '7', '7.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8479', '1883', '7', '6.50', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8480', '1884', '7', '5.80', '2025-07-10', '1', '1');
INSERT INTO `notas` VALUES('8481', '1884', '7', '4.00', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8482', '1884', '7', '7.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8483', '1884', '7', '6.00', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8484', '1885', '7', '4.10', '2025-07-10', '1', '1');
INSERT INTO `notas` VALUES('8485', '1885', '7', '5.30', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8486', '1885', '7', '5.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8487', '1885', '7', '4.50', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8488', '1886', '7', '6.40', '2025-07-10', '1', '1');
INSERT INTO `notas` VALUES('8489', '1886', '7', '6.30', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8490', '1886', '7', '7.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8491', '1886', '7', '7.00', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8492', '1887', '7', '5.90', '2025-07-10', '1', '1');
INSERT INTO `notas` VALUES('8493', '1887', '7', '5.60', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8494', '1887', '7', '7.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8495', '1887', '7', '6.00', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8496', '1888', '7', '6.20', '2025-07-10', '1', '1');
INSERT INTO `notas` VALUES('8497', '1888', '7', '7.00', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8498', '1888', '7', '7.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8499', '1888', '7', '7.00', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8500', '1889', '7', '4.60', '2025-07-10', '1', '1');
INSERT INTO `notas` VALUES('8501', '1889', '7', '4.40', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8502', '1889', '7', '5.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8503', '1889', '7', '7.00', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8504', '1890', '7', '5.00', '2025-07-10', '1', '1');
INSERT INTO `notas` VALUES('8505', '1890', '7', '6.30', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8506', '1890', '7', '7.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8507', '1890', '7', '7.00', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8508', '1891', '7', '4.00', '2025-07-10', '1', '1');
INSERT INTO `notas` VALUES('8509', '1891', '7', '6.70', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8510', '1891', '7', '7.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8511', '1891', '7', '7.00', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8512', '1892', '7', '5.20', '2025-07-10', '1', '1');
INSERT INTO `notas` VALUES('8513', '1892', '7', '5.00', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8514', '1892', '7', '7.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8515', '1892', '7', '7.00', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8516', '1894', '7', '3.70', '2025-07-10', '1', '1');
INSERT INTO `notas` VALUES('8517', '1894', '7', '5.60', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8518', '1894', '7', '5.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8519', '1894', '7', '6.00', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8520', '1895', '7', '5.20', '2025-07-10', '1', '1');
INSERT INTO `notas` VALUES('8521', '1895', '7', '5.60', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8522', '1895', '7', '7.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8523', '1895', '7', '7.00', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8524', '1896', '7', '4.00', '2025-07-10', '1', '1');
INSERT INTO `notas` VALUES('8525', '1896', '7', '3.50', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8526', '1896', '7', '4.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8527', '1896', '7', '4.00', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8528', '1897', '7', '4.70', '2025-07-10', '1', '1');
INSERT INTO `notas` VALUES('8529', '1897', '7', '5.60', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8530', '1897', '7', '7.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8531', '1897', '7', '7.00', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8532', '1878', '4', '7.00', '2025-07-10', '1', '1');
INSERT INTO `notas` VALUES('8533', '1878', '4', '6.90', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8534', '1878', '4', '6.80', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8535', '1879', '4', '7.00', '2025-07-10', '1', '1');
INSERT INTO `notas` VALUES('8536', '1879', '4', '5.00', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8537', '1879', '4', '6.50', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8538', '1880', '4', '7.00', '2025-07-10', '1', '1');
INSERT INTO `notas` VALUES('8539', '1880', '4', '5.50', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8540', '1880', '4', '6.50', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8541', '1881', '4', '7.00', '2025-07-10', '1', '1');
INSERT INTO `notas` VALUES('8542', '1881', '4', '5.00', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8543', '1881', '4', '4.50', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8544', '1882', '4', '7.00', '2025-07-10', '1', '1');
INSERT INTO `notas` VALUES('8545', '1882', '4', '6.50', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8546', '1882', '4', '6.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8547', '1883', '4', '7.00', '2025-07-10', '1', '1');
INSERT INTO `notas` VALUES('8548', '1883', '4', '6.50', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8549', '1883', '4', '6.50', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8550', '1884', '4', '7.00', '2025-07-10', '1', '1');
INSERT INTO `notas` VALUES('8551', '1884', '4', '6.50', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8552', '1884', '4', '6.50', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8553', '1885', '4', '7.00', '2025-07-10', '1', '1');
INSERT INTO `notas` VALUES('8554', '1885', '4', '4.00', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8555', '1885', '4', '5.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8556', '1886', '4', '7.00', '2025-07-10', '1', '1');
INSERT INTO `notas` VALUES('8557', '1886', '4', '7.00', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8558', '1886', '4', '7.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8559', '1887', '4', '7.00', '2025-07-10', '1', '1');
INSERT INTO `notas` VALUES('8560', '1887', '4', '5.00', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8561', '1887', '4', '7.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8562', '1888', '4', '7.00', '2025-07-10', '1', '1');
INSERT INTO `notas` VALUES('8563', '1888', '4', '7.00', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8564', '1888', '4', '7.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8565', '1889', '4', '7.00', '2025-07-10', '1', '1');
INSERT INTO `notas` VALUES('8566', '1889', '4', '5.60', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8567', '1889', '4', '7.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8568', '1890', '4', '7.00', '2025-07-10', '1', '1');
INSERT INTO `notas` VALUES('8569', '1890', '4', '7.00', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8570', '1890', '4', '7.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8571', '1891', '4', '7.00', '2025-07-10', '1', '1');
INSERT INTO `notas` VALUES('8572', '1891', '4', '6.50', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8573', '1891', '4', '7.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8574', '1892', '4', '7.00', '2025-07-10', '1', '1');
INSERT INTO `notas` VALUES('8575', '1892', '4', '6.00', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8576', '1892', '4', '7.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8577', '1894', '4', '7.00', '2025-07-10', '1', '1');
INSERT INTO `notas` VALUES('8578', '1894', '4', '5.00', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8579', '1894', '4', '6.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8580', '1895', '4', '7.00', '2025-07-10', '1', '1');
INSERT INTO `notas` VALUES('8581', '1895', '4', '6.80', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8582', '1895', '4', '7.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8583', '1896', '4', '7.00', '2025-07-10', '1', '1');
INSERT INTO `notas` VALUES('8584', '1896', '4', '4.00', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8585', '1896', '4', '5.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8586', '1897', '4', '7.00', '2025-07-10', '1', '1');
INSERT INTO `notas` VALUES('8587', '1897', '4', '6.50', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8588', '1897', '4', '7.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8589', '1542', '12', '6.80', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8590', '1543', '12', '6.30', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8591', '1543', '12', '6.90', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8592', '1544', '12', '6.90', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8593', '1545', '12', '6.90', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8594', '1546', '12', '6.80', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8595', '1547', '12', '6.60', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8596', '1548', '12', '6.90', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8597', '1549', '12', '5.60', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8598', '1550', '12', '5.60', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8599', '1551', '12', '6.20', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8600', '1552', '12', '6.80', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8601', '1553', '12', '5.00', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8602', '1553', '12', '5.60', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8603', '1554', '12', '6.70', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8604', '1555', '12', '6.70', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8605', '1556', '12', '6.90', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8606', '1557', '12', '6.70', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8607', '1558', '12', '6.30', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8608', '1559', '12', '6.90', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8609', '1560', '12', '6.10', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8610', '1561', '12', '6.30', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8611', '1562', '12', '6.90', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8612', '1563', '12', '6.90', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8613', '1585', '4', '6.30', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8614', '1585', '4', '5.10', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8615', '1586', '4', '6.60', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8616', '1587', '4', '6.70', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8617', '1588', '4', '6.40', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8618', '1589', '4', '5.70', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8619', '1590', '4', '5.60', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8620', '1591', '4', '6.80', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8621', '1591', '4', '5.10', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8622', '1592', '4', '6.20', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8623', '1593', '4', '6.20', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8624', '1594', '4', '6.20', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8625', '1595', '4', '6.20', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8626', '1692', '12', '7.00', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8627', '1692', '12', '6.80', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8628', '1693', '12', '6.00', '2025-07-10', '1', '1');
INSERT INTO `notas` VALUES('8629', '1693', '12', '7.00', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8630', '1693', '12', '6.60', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8631', '1694', '12', '7.00', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8632', '1694', '12', '6.50', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8633', '1695', '12', '7.00', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8634', '1695', '12', '7.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8635', '1697', '12', '6.50', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8636', '1697', '12', '6.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8637', '1698', '12', '6.70', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8638', '1698', '12', '6.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8639', '1699', '12', '7.00', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8640', '1699', '12', '6.80', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8641', '1700', '12', '7.00', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8642', '1700', '12', '6.90', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8643', '1701', '12', '6.00', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8644', '1701', '12', '5.80', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8645', '1702', '12', '7.00', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8646', '1702', '12', '6.60', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8647', '1703', '12', '7.00', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8648', '1703', '12', '6.60', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8649', '1704', '12', '6.70', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8650', '1704', '12', '5.90', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8651', '1705', '12', '6.00', '2025-07-10', '1', '1');
INSERT INTO `notas` VALUES('8652', '1705', '12', '7.00', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8653', '1705', '12', '5.50', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8654', '1706', '12', '7.00', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8655', '1706', '12', '6.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8656', '1707', '12', '7.00', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8657', '1707', '12', '6.40', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8658', '1708', '12', '7.00', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8659', '1708', '12', '6.50', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8660', '1709', '12', '7.00', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8661', '1709', '12', '6.70', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8662', '1710', '12', '6.00', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8663', '1710', '12', '5.90', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8664', '1711', '12', '6.60', '2025-07-10', '1', '1');
INSERT INTO `notas` VALUES('8665', '1711', '12', '7.00', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8666', '1711', '12', '6.30', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8667', '1712', '12', '6.00', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8668', '1712', '12', '6.40', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8669', '1585', '12', '6.50', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8670', '1585', '12', '6.20', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8671', '1586', '12', '6.50', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8672', '1586', '12', '6.60', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8673', '1587', '12', '4.60', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8674', '1587', '12', '6.20', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8675', '1588', '12', '7.00', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8676', '1588', '12', '6.50', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8677', '1589', '12', '6.00', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8678', '1589', '12', '5.90', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8679', '1590', '12', '6.50', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8680', '1590', '12', '6.60', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8681', '1591', '12', '5.40', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8682', '1591', '12', '5.80', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8683', '1592', '12', '6.00', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8684', '1592', '12', '6.40', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8685', '1593', '12', '6.70', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8686', '1593', '12', '6.70', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8687', '1594', '12', '5.10', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8688', '1594', '12', '6.40', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8689', '1595', '12', '7.00', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8690', '1595', '12', '6.50', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8691', '1596', '12', '7.00', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8692', '1596', '12', '6.60', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8693', '1597', '12', '5.70', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8694', '1597', '12', '6.70', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8695', '1598', '12', '6.00', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8696', '1598', '12', '6.10', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8697', '1599', '12', '5.40', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8698', '1599', '12', '6.50', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8699', '1600', '12', '5.70', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8700', '1600', '12', '6.30', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8701', '1601', '12', '6.70', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8702', '1601', '12', '5.90', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8703', '1602', '12', '6.00', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8704', '1603', '12', '6.70', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8705', '1603', '12', '6.30', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8706', '1604', '12', '6.00', '2025-07-10', '1', '1');
INSERT INTO `notas` VALUES('8707', '1604', '12', '5.40', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8708', '1604', '12', '6.30', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8709', '1605', '12', '6.70', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8710', '1605', '12', '6.50', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8711', '1606', '12', '6.70', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8712', '1606', '12', '6.30', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8713', '1607', '12', '6.50', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8714', '1607', '12', '6.10', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8715', '1608', '12', '6.50', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8716', '1608', '12', '5.60', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8717', '1609', '12', '6.00', '2025-07-10', '1', '2');
INSERT INTO `notas` VALUES('8718', '1609', '12', '6.30', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8719', '1948', '7', '7.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8720', '1948', '7', '6.50', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8721', '1949', '7', '7.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8722', '1949', '7', '6.00', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8723', '1950', '7', '7.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8724', '1950', '7', '5.60', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8725', '1951', '7', '7.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8726', '1951', '7', '6.50', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8727', '1952', '7', '7.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8728', '1952', '7', '5.70', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8729', '1953', '7', '7.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8730', '1953', '7', '6.90', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8731', '1954', '7', '6.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8732', '1954', '7', '6.20', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8733', '1956', '7', '6.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8734', '1956', '7', '5.60', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8735', '1957', '7', '6.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8736', '1957', '7', '5.00', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8737', '1958', '7', '7.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8738', '1958', '7', '7.00', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8739', '1959', '7', '6.60', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8740', '1959', '7', '6.20', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8741', '1960', '7', '7.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8742', '1960', '7', '7.00', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8743', '1961', '7', '4.50', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8744', '1961', '7', '6.00', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8745', '1962', '7', '7.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8746', '1962', '7', '6.80', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8747', '1963', '7', '5.50', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8748', '1963', '7', '6.20', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8749', '1964', '7', '6.60', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8750', '1964', '7', '6.50', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8751', '1965', '7', '6.60', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8752', '1965', '7', '6.40', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8753', '1966', '7', '7.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8754', '1966', '7', '6.40', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8755', '1967', '7', '6.60', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8756', '1967', '7', '6.20', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8757', '1968', '7', '7.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8758', '1968', '7', '6.90', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8759', '1969', '7', '7.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8760', '1969', '7', '6.50', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8761', '1970', '7', '5.10', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8762', '1970', '7', '6.50', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8763', '1971', '7', '6.60', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8764', '1971', '7', '5.50', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8765', '1972', '7', '6.60', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8766', '1972', '7', '6.80', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8767', '1973', '7', '6.60', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8768', '1973', '7', '6.80', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8769', '1975', '7', '6.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8770', '1975', '7', '6.00', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8771', '1976', '7', '7.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8772', '1976', '7', '6.90', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8773', '1977', '7', '6.60', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8774', '1977', '7', '6.80', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8775', '1978', '7', '7.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8776', '1978', '7', '6.60', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8777', '1979', '7', '6.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8778', '1979', '7', '5.90', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8779', '1980', '7', '6.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8780', '1980', '7', '6.70', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8781', '1981', '7', '6.60', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8782', '1981', '7', '6.80', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8783', '1982', '7', '7.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8784', '1982', '7', '6.00', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8785', '1983', '7', '6.60', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8786', '1983', '7', '6.30', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8787', '1984', '7', '5.50', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8788', '1984', '7', '6.30', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8789', '1985', '7', '7.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8790', '1985', '7', '6.40', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8791', '1986', '7', '7.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8792', '1986', '7', '5.00', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8793', '1987', '7', '7.00', '2025-07-10', '1', '3');
INSERT INTO `notas` VALUES('8794', '1987', '7', '7.00', '2025-07-10', '1', '4');
INSERT INTO `notas` VALUES('8795', '1585', '5', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('8796', '1585', '5', '6.70', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('8797', '1586', '5', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('8798', '1586', '5', '6.30', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('8799', '1587', '5', '7.00', '2025-07-11', '1', '2');
INSERT INTO `notas` VALUES('8800', '1587', '5', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('8801', '1587', '5', '6.80', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('8802', '1588', '5', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('8803', '1588', '5', '6.70', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('8804', '1589', '5', '7.00', '2025-07-11', '1', '2');
INSERT INTO `notas` VALUES('8805', '1589', '5', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('8806', '1589', '5', '6.80', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('8807', '1590', '5', '7.00', '2025-07-11', '1', '2');
INSERT INTO `notas` VALUES('8808', '1590', '5', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('8809', '1590', '5', '6.80', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('8810', '1591', '5', '2.00', '2025-07-11', '1', '2');
INSERT INTO `notas` VALUES('8811', '1591', '5', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('8812', '1591', '5', '5.70', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('8813', '1592', '5', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('8814', '1592', '5', '6.10', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('8815', '1593', '5', '7.00', '2025-07-11', '1', '2');
INSERT INTO `notas` VALUES('8816', '1593', '5', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('8817', '1593', '5', '6.90', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('8818', '1594', '5', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('8819', '1594', '5', '6.80', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('8820', '1595', '5', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('8821', '1595', '5', '6.20', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('8822', '1596', '5', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('8823', '1596', '5', '6.90', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('8824', '1597', '5', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('8825', '1597', '5', '6.70', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('8826', '1598', '5', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('8827', '1598', '5', '6.30', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('8828', '1599', '5', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('8829', '1599', '5', '4.70', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('8830', '1600', '5', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('8831', '1600', '5', '7.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('8832', '1601', '5', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('8833', '1601', '5', '6.90', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('8834', '1602', '5', '7.00', '2025-07-11', '1', '2');
INSERT INTO `notas` VALUES('8835', '1602', '5', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('8836', '1603', '5', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('8837', '1603', '5', '6.90', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('8838', '1604', '5', '7.00', '2025-07-11', '1', '2');
INSERT INTO `notas` VALUES('8839', '1604', '5', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('8840', '1604', '5', '5.90', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('8841', '1605', '5', '7.00', '2025-07-11', '1', '2');
INSERT INTO `notas` VALUES('8842', '1605', '5', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('8843', '1605', '5', '6.20', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('8844', '1606', '5', '2.00', '2025-07-11', '1', '2');
INSERT INTO `notas` VALUES('8845', '1606', '5', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('8846', '1606', '5', '5.70', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('8847', '1607', '5', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('8848', '1607', '5', '7.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('8849', '1608', '5', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('8850', '1608', '5', '6.60', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('8851', '1609', '5', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('8852', '1609', '5', '6.90', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('8853', '1731', '5', '6.70', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('8854', '1731', '5', '6.30', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('8855', '1732', '5', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('8856', '1732', '5', '6.60', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('8857', '1733', '5', '6.10', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('8858', '1733', '5', '6.30', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('8859', '1734', '5', '5.80', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('8860', '1734', '5', '6.70', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('8861', '1735', '5', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('8862', '1735', '5', '6.60', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('8863', '1736', '5', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('8864', '1736', '5', '6.30', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('8865', '1737', '5', '6.80', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('8866', '1737', '5', '6.30', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('8867', '1738', '5', '6.80', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('8868', '1738', '5', '6.90', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('8869', '1739', '5', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('8870', '1739', '5', '6.30', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('8871', '1740', '5', '6.40', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('8872', '1740', '5', '6.70', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('8873', '1741', '5', '6.80', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('8874', '1741', '5', '6.70', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('8875', '1742', '5', '6.30', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('8876', '1742', '5', '7.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('8877', '1743', '5', '6.80', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('8878', '1743', '5', '6.30', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('8879', '1744', '5', '6.80', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('8880', '1744', '5', '7.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('8881', '1745', '5', '6.30', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('8882', '1745', '5', '6.30', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('8883', '1746', '5', '2.00', '2025-07-11', '1', '2');
INSERT INTO `notas` VALUES('8884', '1746', '5', '6.60', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('8885', '1746', '5', '5.60', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('8886', '1747', '5', '6.80', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('8887', '1747', '5', '7.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('8888', '1748', '5', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('8889', '1748', '5', '7.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('8890', '1749', '5', '4.80', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('8891', '1749', '5', '7.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('8892', '1596', '4', '6.30', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('8893', '1597', '4', '6.30', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('8894', '1598', '4', '6.10', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('8895', '1599', '4', '6.80', '2025-07-11', '1', '1');
INSERT INTO `notas` VALUES('8896', '1599', '4', '6.00', '2025-07-11', '1', '2');
INSERT INTO `notas` VALUES('8897', '1599', '4', '5.50', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('8898', '1600', '4', '5.80', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('8899', '1601', '4', '6.50', '2025-07-11', '1', '2');
INSERT INTO `notas` VALUES('8900', '1601', '4', '6.20', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('8901', '1602', '4', '6.40', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('8902', '1603', '4', '6.60', '2025-07-11', '1', '2');
INSERT INTO `notas` VALUES('8903', '1603', '4', '6.40', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('8904', '1604', '4', '6.20', '2025-07-11', '1', '2');
INSERT INTO `notas` VALUES('8905', '1604', '4', '5.60', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('8906', '1605', '4', '6.10', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('8907', '1606', '4', '6.20', '2025-07-11', '1', '1');
INSERT INTO `notas` VALUES('8908', '1606', '4', '6.30', '2025-07-11', '1', '2');
INSERT INTO `notas` VALUES('8909', '1606', '4', '5.60', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('8910', '1607', '4', '6.30', '2025-07-11', '1', '2');
INSERT INTO `notas` VALUES('8911', '1607', '4', '5.90', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('8912', '1608', '4', '5.70', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('8913', '1609', '4', '6.80', '2025-07-11', '1', '2');
INSERT INTO `notas` VALUES('8914', '1609', '4', '6.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('8915', '1948', '5', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('8916', '1948', '5', '6.80', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('8917', '1949', '5', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('8918', '1949', '5', '6.70', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('8919', '1950', '5', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('8920', '1950', '5', '6.30', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('8921', '1951', '5', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('8922', '1951', '5', '6.90', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('8923', '1952', '5', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('8924', '1952', '5', '6.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('8925', '1953', '5', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('8926', '1953', '5', '6.90', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('8927', '1954', '5', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('8928', '1954', '5', '6.40', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('8929', '1956', '5', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('8930', '1956', '5', '5.60', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('8931', '1957', '5', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('8932', '1957', '5', '5.70', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('8933', '1958', '5', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('8934', '1958', '5', '7.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('8935', '1959', '5', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('8936', '1959', '5', '6.40', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('8937', '1960', '5', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('8938', '1960', '5', '7.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('8939', '1961', '5', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('8940', '1961', '5', '6.20', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('8941', '1962', '5', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('8942', '1962', '5', '6.90', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('8943', '1963', '5', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('8944', '1963', '5', '6.60', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('8945', '1964', '5', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('8946', '1964', '5', '6.90', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('8947', '1965', '5', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('8948', '1965', '5', '6.80', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('8949', '1966', '5', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('8950', '1966', '5', '6.90', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('8951', '1967', '5', '6.80', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('8952', '1967', '5', '6.40', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('8953', '1968', '5', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('8954', '1968', '5', '6.90', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('8955', '1969', '5', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('8956', '1969', '5', '6.90', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('8957', '1970', '5', '6.80', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('8958', '1970', '5', '6.40', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('8959', '1971', '5', '4.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('8960', '1971', '5', '5.70', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('8961', '1972', '5', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('8962', '1972', '5', '7.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('8963', '1973', '5', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('8964', '1973', '5', '6.90', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('8965', '1975', '5', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('8966', '1975', '5', '6.90', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('8967', '1976', '5', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('8968', '1976', '5', '7.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('8969', '1977', '5', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('8970', '1977', '5', '6.90', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('8971', '1978', '5', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('8972', '1978', '5', '6.90', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('8973', '1979', '5', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('8974', '1979', '5', '6.60', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('8975', '1980', '5', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('8976', '1980', '5', '7.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('8977', '1981', '5', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('8978', '1981', '5', '6.80', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('8979', '1982', '5', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('8980', '1982', '5', '6.40', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('8981', '1983', '5', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('8982', '1983', '5', '5.80', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('8983', '1984', '5', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('8984', '1984', '5', '6.40', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('8985', '1985', '5', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('8986', '1985', '5', '6.40', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('8987', '1986', '5', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('8988', '1986', '5', '6.90', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('8989', '1987', '5', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('8990', '1987', '5', '7.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('8991', '1948', '4', '5.50', '2025-07-11', '1', '2');
INSERT INTO `notas` VALUES('8992', '1948', '4', '5.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('8993', '1949', '4', '5.70', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('8994', '1950', '4', '6.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('8995', '1951', '4', '6.20', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('8996', '1952', '4', '6.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('8997', '1953', '4', '6.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('8998', '1954', '4', '5.50', '2025-07-11', '1', '2');
INSERT INTO `notas` VALUES('8999', '1954', '4', '5.50', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9000', '1956', '4', '5.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9001', '1957', '4', '5.00', '2025-07-11', '1', '2');
INSERT INTO `notas` VALUES('9002', '1957', '4', '4.80', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9003', '1958', '4', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9004', '1959', '4', '5.80', '2025-07-11', '1', '2');
INSERT INTO `notas` VALUES('9005', '1959', '4', '5.50', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9006', '1960', '4', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9007', '1961', '4', '5.20', '2025-07-11', '1', '2');
INSERT INTO `notas` VALUES('9008', '1961', '4', '5.50', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9009', '1962', '4', '7.00', '2025-07-11', '1', '2');
INSERT INTO `notas` VALUES('9010', '1962', '4', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9011', '1963', '4', '5.80', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9012', '1964', '4', '5.50', '2025-07-11', '1', '2');
INSERT INTO `notas` VALUES('9013', '1964', '4', '5.80', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9014', '1965', '4', '5.50', '2025-07-11', '1', '2');
INSERT INTO `notas` VALUES('9015', '1965', '4', '5.80', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9016', '1966', '4', '5.80', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9017', '1967', '4', '5.90', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9018', '1968', '4', '6.20', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9019', '1969', '4', '5.80', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9020', '1970', '4', '6.50', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9021', '1971', '4', '7.00', '2025-07-11', '1', '2');
INSERT INTO `notas` VALUES('9022', '1971', '4', '6.50', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9023', '1972', '4', '6.00', '2025-07-11', '1', '2');
INSERT INTO `notas` VALUES('9024', '1972', '4', '5.80', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9025', '1973', '4', '6.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9026', '1975', '4', '6.50', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9027', '1976', '4', '6.50', '2025-07-11', '1', '2');
INSERT INTO `notas` VALUES('9028', '1976', '4', '6.50', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9029', '1977', '4', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9030', '1978', '4', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9031', '1979', '4', '4.50', '2025-07-11', '1', '2');
INSERT INTO `notas` VALUES('9032', '1979', '4', '5.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9033', '1980', '4', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9034', '1981', '4', '6.50', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9035', '1982', '4', '6.00', '2025-07-11', '1', '1');
INSERT INTO `notas` VALUES('9036', '1982', '4', '6.50', '2025-07-11', '1', '2');
INSERT INTO `notas` VALUES('9037', '1982', '4', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9038', '1983', '4', '5.50', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9039', '1984', '4', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9040', '1985', '4', '5.00', '2025-07-11', '1', '2');
INSERT INTO `notas` VALUES('9041', '1985', '4', '5.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9042', '1986', '4', '5.50', '2025-07-11', '1', '2');
INSERT INTO `notas` VALUES('9043', '1986', '4', '5.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9044', '1987', '4', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9045', '1948', '12', '6.40', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9046', '1949', '12', '6.50', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9047', '1950', '12', '6.60', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9048', '1951', '12', '6.40', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9049', '1952', '12', '4.00', '2025-07-11', '1', '1');
INSERT INTO `notas` VALUES('9050', '1952', '12', '4.00', '2025-07-11', '1', '2');
INSERT INTO `notas` VALUES('9051', '1952', '12', '4.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9052', '1953', '12', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9053', '1954', '12', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9054', '1956', '12', '4.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9055', '1957', '12', '5.20', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9056', '1958', '12', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9057', '1959', '12', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9058', '1960', '12', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9059', '1961', '12', '6.20', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9060', '1962', '12', '6.40', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9061', '1963', '12', '6.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9062', '1964', '12', '6.60', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9063', '1965', '12', '6.40', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9064', '1966', '12', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9065', '1967', '12', '5.60', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9066', '1968', '12', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9067', '1969', '12', '6.60', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9068', '1970', '12', '6.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9069', '1971', '12', '5.20', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9070', '1972', '12', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9071', '1973', '12', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9072', '1975', '12', '6.70', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9073', '1976', '12', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9074', '1977', '12', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9075', '1978', '12', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9076', '1979', '12', '4.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9077', '1980', '12', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9078', '1981', '12', '6.80', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9079', '1982', '12', '5.20', '2025-07-11', '1', '1');
INSERT INTO `notas` VALUES('9080', '1982', '12', '6.00', '2025-07-11', '1', '2');
INSERT INTO `notas` VALUES('9081', '1982', '12', '6.10', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9082', '1983', '12', '4.10', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9083', '1984', '12', '6.60', '2025-07-11', '1', '2');
INSERT INTO `notas` VALUES('9084', '1984', '12', '6.40', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9085', '1985', '12', '6.60', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9086', '1986', '12', '4.50', '2025-07-11', '1', '1');
INSERT INTO `notas` VALUES('9087', '1986', '12', '4.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9088', '1987', '12', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9089', '1585', '2', '6.80', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9090', '1585', '2', '6.10', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('9091', '1585', '2', '6.10', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('9092', '1586', '2', '5.70', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9093', '1586', '2', '6.30', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('9094', '1586', '2', '7.00', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('9095', '1587', '2', '6.70', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9096', '1587', '2', '6.50', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('9097', '1587', '2', '7.00', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('9098', '1588', '2', '6.20', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9099', '1588', '2', '6.50', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('9100', '1588', '2', '6.60', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('9101', '1589', '2', '5.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9102', '1589', '2', '6.10', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('9103', '1589', '2', '5.20', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('9104', '1590', '2', '5.80', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9105', '1590', '2', '5.70', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('9106', '1590', '2', '6.80', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('9107', '1591', '2', '2.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9108', '1591', '2', '5.50', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('9109', '1591', '2', '4.00', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('9110', '1592', '2', '6.30', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9111', '1592', '2', '6.80', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('9112', '1592', '2', '7.00', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('9113', '1593', '2', '7.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9114', '1593', '2', '6.80', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('9115', '1593', '2', '6.00', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('9116', '1594', '2', '5.70', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9117', '1594', '2', '6.20', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('9118', '1594', '2', '6.60', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('9119', '1595', '2', '7.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9120', '1595', '2', '6.70', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('9121', '1595', '2', '7.00', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('9122', '1596', '2', '6.50', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9123', '1596', '2', '6.50', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('9124', '1596', '2', '6.70', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('9125', '1597', '2', '5.70', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9126', '1597', '2', '6.50', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('9127', '1597', '2', '7.00', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('9128', '1598', '2', '5.50', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9129', '1598', '2', '6.50', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('9130', '1598', '2', '7.00', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('9131', '1599', '2', '5.40', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9132', '1599', '2', '6.50', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('9133', '1599', '2', '4.80', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('9134', '1600', '2', '7.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9135', '1600', '2', '6.80', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('9136', '1600', '2', '7.00', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('9137', '1601', '2', '5.50', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9138', '1601', '2', '6.10', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('9139', '1601', '2', '6.00', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('9140', '1602', '2', '7.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9141', '1603', '2', '7.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9142', '1603', '2', '6.20', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('9143', '1603', '2', '7.00', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('9144', '1604', '2', '7.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9145', '1604', '2', '6.50', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('9146', '1604', '2', '4.00', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('9147', '1605', '2', '6.80', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9148', '1605', '2', '6.60', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('9149', '1605', '2', '6.60', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('9150', '1606', '2', '5.80', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9151', '1606', '2', '5.00', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('9152', '1606', '2', '6.40', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('9153', '1607', '2', '7.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9154', '1607', '2', '6.60', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('9155', '1607', '2', '7.00', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('9156', '1608', '2', '6.70', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9157', '1608', '2', '6.50', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('9158', '1608', '2', '6.00', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('9159', '1609', '2', '7.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9160', '1609', '2', '6.60', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('9161', '1609', '2', '7.00', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('9162', '1948', '1', '5.80', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9163', '1948', '1', '6.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9164', '1948', '1', '6.20', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('9165', '1948', '1', '5.50', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('9166', '1949', '1', '3.10', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9167', '1949', '1', '4.80', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9168', '1949', '1', '6.00', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('9169', '1949', '1', '5.00', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('9170', '1950', '1', '5.00', '2025-07-11', '1', '2');
INSERT INTO `notas` VALUES('9171', '1950', '1', '5.20', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9172', '1950', '1', '5.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9173', '1950', '1', '6.00', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('9174', '1950', '1', '5.50', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('9175', '1951', '1', '6.40', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9176', '1951', '1', '5.70', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9177', '1951', '1', '4.80', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('9178', '1951', '1', '6.30', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('9179', '1952', '1', '5.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9180', '1952', '1', '5.10', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9181', '1952', '1', '6.20', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('9182', '1952', '1', '5.10', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('9183', '1953', '1', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9184', '1953', '1', '6.20', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9185', '1953', '1', '4.80', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('9186', '1953', '1', '6.40', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('9187', '1954', '1', '4.80', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9188', '1954', '1', '4.60', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9189', '1954', '1', '6.00', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('9190', '1954', '1', '4.50', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('9191', '1956', '1', '5.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9192', '1956', '1', '5.70', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9193', '1956', '1', '4.80', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('9194', '1956', '1', '4.00', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('9195', '1957', '1', '5.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9196', '1957', '1', '5.20', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9197', '1957', '1', '4.20', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('9198', '1957', '1', '4.50', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('9199', '1958', '1', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9200', '1958', '1', '7.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9201', '1958', '1', '7.00', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('9202', '1958', '1', '7.00', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('9203', '1959', '1', '5.60', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9204', '1959', '1', '5.10', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9205', '1959', '1', '4.50', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('9206', '1959', '1', '5.50', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('9207', '1960', '1', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9208', '1960', '1', '5.20', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9209', '1960', '1', '5.40', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('9210', '1960', '1', '6.60', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('9211', '1961', '1', '4.60', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9212', '1961', '1', '5.10', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9213', '1961', '1', '4.80', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('9214', '1961', '1', '4.00', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('9215', '1962', '1', '6.20', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9216', '1962', '1', '6.40', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9217', '1962', '1', '7.00', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('9218', '1962', '1', '6.50', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('9219', '1963', '1', '3.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9220', '1963', '1', '5.10', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9221', '1963', '1', '5.70', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('9222', '1963', '1', '5.50', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('9223', '1964', '1', '4.20', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9224', '1964', '1', '5.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9225', '1964', '1', '5.20', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('9226', '1964', '1', '6.00', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('9227', '1965', '1', '6.60', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9228', '1429', '4', '6.60', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9229', '1965', '1', '5.90', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9230', '1429', '4', '6.70', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9231', '1965', '1', '5.40', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('9232', '1965', '1', '5.80', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('9233', '1430', '4', '6.50', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9234', '1430', '4', '6.20', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9235', '1966', '1', '5.20', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9236', '1966', '1', '5.70', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9237', '1966', '1', '4.50', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('9238', '1431', '4', '6.70', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9239', '1966', '1', '5.50', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('9240', '1431', '4', '6.80', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9241', '1967', '1', '5.40', '2025-07-11', '1', '2');
INSERT INTO `notas` VALUES('9242', '1967', '1', '6.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9243', '1967', '1', '5.40', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9244', '1967', '1', '4.30', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('9245', '1967', '1', '5.90', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('9246', '1432', '4', '6.60', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9247', '1432', '4', '6.60', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9248', '1433', '4', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9249', '1968', '1', '6.80', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9250', '1433', '4', '7.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9251', '1968', '1', '6.20', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9252', '1968', '1', '4.80', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('9253', '1434', '4', '6.60', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9254', '1968', '1', '5.50', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('9255', '1434', '4', '6.70', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9256', '1969', '1', '6.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9257', '1435', '4', '5.40', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9258', '1969', '1', '5.70', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9259', '1969', '1', '4.80', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('9260', '1435', '4', '6.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9261', '1969', '1', '5.00', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('9262', '1970', '1', '6.60', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9263', '1436', '4', '6.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9264', '1970', '1', '5.80', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9265', '1436', '4', '6.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9266', '1970', '1', '5.70', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('9267', '1970', '1', '6.00', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('9268', '1454', '4', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9269', '1454', '4', '7.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9270', '1971', '1', '4.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9271', '1971', '1', '5.20', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9272', '1971', '1', '6.40', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('9273', '1971', '1', '4.20', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('9274', '1972', '1', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9275', '1972', '1', '6.50', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9276', '1437', '4', '6.60', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9277', '1972', '1', '6.10', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('9278', '1437', '4', '6.60', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9279', '1972', '1', '6.60', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('9280', '1438', '4', '6.70', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9281', '1973', '1', '4.60', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9282', '1438', '4', '6.70', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9283', '1973', '1', '5.70', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9284', '1973', '1', '6.00', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('9285', '1439', '4', '6.10', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9286', '1439', '4', '6.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9287', '1973', '1', '5.00', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('9288', '1440', '4', '6.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9289', '1975', '1', '6.20', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9290', '1440', '4', '6.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9291', '1975', '1', '6.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9292', '1975', '1', '5.90', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('9293', '1975', '1', '5.80', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('9294', '1441', '4', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9295', '1441', '4', '7.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9296', '1976', '1', '6.60', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9297', '1442', '4', '6.70', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9298', '1976', '1', '6.80', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9299', '1976', '1', '7.00', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('9300', '1976', '1', '6.80', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('9301', '1442', '4', '6.60', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9302', '1977', '1', '5.40', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9303', '1977', '1', '6.20', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9304', '1443', '4', '6.50', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9305', '1977', '1', '7.00', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('9306', '1443', '4', '6.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9307', '1977', '1', '6.60', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('9308', '1444', '4', '6.60', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9309', '1978', '1', '6.60', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9310', '1444', '4', '6.40', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9311', '1978', '1', '6.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9312', '1978', '1', '7.00', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('9313', '1978', '1', '6.50', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('9314', '1445', '4', '6.20', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9315', '1445', '4', '6.10', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9316', '1979', '1', '2.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9317', '1979', '1', '4.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9318', '1446', '4', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9319', '1979', '1', '4.00', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('9320', '1979', '1', '4.50', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('9321', '1446', '4', '7.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9322', '1980', '1', '6.00', '2025-07-11', '1', '2');
INSERT INTO `notas` VALUES('9323', '1980', '1', '5.60', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9324', '1980', '1', '6.20', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9325', '1447', '4', '6.60', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9326', '1980', '1', '6.10', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('9327', '1447', '4', '7.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9328', '1980', '1', '6.50', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('9329', '1981', '1', '5.70', '2025-07-11', '1', '2');
INSERT INTO `notas` VALUES('9330', '1981', '1', '6.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9331', '1981', '1', '6.20', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9332', '1981', '1', '5.00', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('9333', '1981', '1', '6.20', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('9334', '1982', '1', '6.20', '2025-07-11', '1', '1');
INSERT INTO `notas` VALUES('9335', '1982', '1', '5.20', '2025-07-11', '1', '2');
INSERT INTO `notas` VALUES('9336', '1982', '1', '6.80', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9337', '1982', '1', '6.50', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9338', '1982', '1', '6.00', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('9339', '1982', '1', '5.50', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('9340', '1983', '1', '5.60', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9341', '1983', '1', '4.60', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9342', '1983', '1', '4.80', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('9343', '1983', '1', '4.40', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('9344', '1984', '1', '6.60', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9345', '1984', '1', '6.90', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9346', '1984', '1', '6.70', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('9347', '1984', '1', '7.00', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('9348', '1985', '1', '5.70', '2025-07-11', '1', '2');
INSERT INTO `notas` VALUES('9349', '1985', '1', '6.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9350', '1985', '1', '4.80', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9351', '1985', '1', '4.70', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('9352', '1985', '1', '5.00', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('9353', '1986', '1', '4.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9354', '1986', '1', '4.50', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9355', '1986', '1', '4.50', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('9356', '1986', '1', '4.80', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('9357', '1987', '1', '6.60', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9358', '1987', '1', '7.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9359', '1987', '1', '7.00', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('9360', '1987', '1', '7.00', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('9361', '1429', '12', '6.60', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9362', '1430', '12', '6.50', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9363', '1431', '12', '6.70', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9364', '1432', '12', '6.60', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9365', '1433', '12', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9366', '1434', '12', '6.60', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9367', '1435', '12', '5.40', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9368', '1436', '12', '6.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9369', '1454', '12', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9370', '1437', '12', '6.60', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9371', '1438', '12', '6.70', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9372', '1439', '12', '6.10', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9373', '1440', '12', '6.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9374', '1441', '12', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9375', '1442', '12', '6.70', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9376', '1443', '12', '6.50', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9377', '1444', '12', '6.60', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9378', '1445', '12', '6.20', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9379', '1446', '12', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9380', '1447', '12', '6.60', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9381', '1692', '5', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9382', '1692', '5', '7.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9383', '1693', '5', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9384', '1693', '5', '7.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9385', '1694', '5', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9386', '1694', '5', '7.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9387', '1695', '5', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9388', '1695', '5', '7.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9389', '1696', '5', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9390', '1696', '5', '7.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9391', '1697', '5', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9392', '1697', '5', '6.60', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9393', '1698', '5', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9394', '1698', '5', '6.40', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9395', '1699', '5', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9396', '1699', '5', '7.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9397', '1700', '5', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9398', '1700', '5', '7.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9399', '1701', '5', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9400', '1701', '5', '6.90', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9401', '1702', '5', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9402', '1702', '5', '7.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9403', '1703', '5', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9404', '1703', '5', '7.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9405', '1704', '5', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9406', '1704', '5', '7.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9407', '1705', '5', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9408', '1705', '5', '6.80', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9409', '1706', '5', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9410', '1706', '5', '6.90', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9411', '1707', '5', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9412', '1707', '5', '7.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9413', '1708', '5', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9414', '1708', '5', '6.80', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9415', '1709', '5', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9416', '1709', '5', '7.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9417', '1710', '5', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9418', '1710', '5', '7.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9419', '1711', '5', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9420', '1711', '5', '7.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9421', '1712', '5', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9422', '1712', '5', '7.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9423', '1922', '5', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9424', '1922', '5', '6.70', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9425', '1923', '5', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9426', '1923', '5', '5.20', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9427', '1924', '5', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9428', '1924', '5', '6.70', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9429', '1925', '5', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9430', '1925', '5', '6.30', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9431', '1926', '5', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9432', '1926', '5', '6.30', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9433', '1927', '5', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9434', '1927', '5', '6.50', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9435', '1928', '5', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9436', '1928', '5', '5.50', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9437', '1929', '5', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9438', '1929', '5', '6.30', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9439', '1930', '5', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9440', '1930', '5', '6.50', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9441', '1931', '5', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9442', '1931', '5', '5.20', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9443', '1932', '5', '2.00', '2025-07-11', '1', '2');
INSERT INTO `notas` VALUES('9444', '1932', '5', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9445', '1932', '5', '6.30', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9446', '1933', '5', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9447', '1933', '5', '6.50', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9448', '1947', '5', '6.80', '2025-07-11', '1', '1');
INSERT INTO `notas` VALUES('9449', '1947', '5', '6.80', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9450', '1947', '5', '6.50', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9451', '1934', '5', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9452', '1934', '5', '6.30', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9453', '1935', '5', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9454', '1935', '5', '7.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9455', '1936', '5', '7.00', '2025-07-11', '1', '2');
INSERT INTO `notas` VALUES('9456', '1936', '5', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9457', '1936', '5', '6.30', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9458', '1937', '5', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9459', '1937', '5', '6.60', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9460', '1938', '5', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9461', '1938', '5', '6.60', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9462', '1939', '5', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9463', '1939', '5', '6.10', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9464', '1940', '5', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9465', '1940', '5', '6.80', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9466', '1941', '5', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9467', '1941', '5', '6.80', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9468', '1942', '5', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9469', '1942', '5', '6.30', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9470', '1943', '5', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9471', '1943', '5', '5.20', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9472', '1944', '5', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9473', '1944', '5', '6.60', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9474', '1945', '5', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9475', '1945', '5', '6.90', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9476', '1946', '5', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9477', '1946', '5', '7.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9478', '1844', '1', '5.90', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9479', '1844', '1', '6.60', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('9480', '1844', '1', '7.00', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('9481', '1845', '1', '7.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9482', '1845', '1', '3.60', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('9483', '1845', '1', '4.00', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('9484', '1846', '1', '5.70', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9485', '1846', '1', '3.40', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('9486', '1846', '1', '5.10', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('9487', '1847', '1', '4.60', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9488', '1847', '1', '3.20', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('9489', '1847', '1', '4.50', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('9490', '1848', '1', '6.30', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9491', '1848', '1', '6.50', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('9492', '1848', '1', '6.70', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('9493', '1849', '1', '5.70', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9494', '1849', '1', '7.00', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('9495', '1849', '1', '7.00', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('9496', '1850', '1', '6.10', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9497', '1850', '1', '7.00', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('9498', '1850', '1', '6.40', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('9499', '1851', '1', '5.90', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9500', '1851', '1', '7.00', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('9501', '1851', '1', '6.70', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('9502', '1852', '1', '6.20', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9503', '1852', '1', '5.20', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('9504', '1852', '1', '6.00', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('9505', '1853', '1', '5.70', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9506', '1853', '1', '3.20', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('9507', '1853', '1', '4.00', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('9508', '1854', '1', '6.60', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9509', '1854', '1', '4.00', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('9510', '1854', '1', '5.20', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('9511', '1855', '1', '5.70', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9512', '1855', '1', '7.00', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('9513', '1855', '1', '7.00', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('9514', '1856', '1', '6.10', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9515', '1856', '1', '7.00', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('9516', '1856', '1', '7.00', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('9517', '1857', '1', '5.20', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9518', '1857', '1', '6.00', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('9519', '1857', '1', '6.60', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('9520', '1858', '1', '4.80', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9521', '1858', '1', '7.00', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('9522', '1858', '1', '6.40', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('9523', '1859', '1', '5.70', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9524', '1859', '1', '6.00', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('9525', '1859', '1', '6.00', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('9526', '1860', '1', '7.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9527', '1860', '1', '4.00', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('9528', '1860', '1', '4.20', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('9529', '1861', '1', '4.10', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9530', '1861', '1', '4.50', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('9531', '1861', '1', '6.10', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('9532', '1862', '1', '5.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9533', '1862', '1', '6.20', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('9534', '1862', '1', '7.00', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('9535', '1863', '1', '3.30', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9536', '1863', '1', '4.50', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('9537', '1863', '1', '5.70', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('9538', '1877', '1', '4.30', '2025-07-11', '1', '1');
INSERT INTO `notas` VALUES('9539', '1877', '1', '5.20', '2025-07-11', '1', '2');
INSERT INTO `notas` VALUES('9540', '1877', '1', '5.10', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9541', '1877', '1', '5.90', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9542', '1877', '1', '4.70', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('9543', '1877', '1', '5.40', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('9544', '1864', '1', '3.60', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9545', '1864', '1', '3.10', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('9546', '1864', '1', '4.00', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('9547', '1865', '1', '6.10', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9548', '1865', '1', '7.00', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('9549', '1865', '1', '6.40', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('9550', '1866', '1', '5.90', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9551', '1866', '1', '3.40', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('9552', '1866', '1', '4.00', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('9553', '1867', '1', '6.60', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9554', '1867', '1', '7.00', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('9555', '1867', '1', '7.00', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('9556', '1868', '1', '3.90', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9557', '1868', '1', '4.60', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('9558', '1868', '1', '7.00', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('9559', '1869', '1', '4.60', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9560', '1869', '1', '6.60', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('9561', '1869', '1', '6.00', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('9562', '1870', '1', '5.20', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9563', '1870', '1', '3.00', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('9564', '1870', '1', '5.10', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('9565', '1871', '1', '7.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9566', '1871', '1', '7.00', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('9567', '1871', '1', '7.00', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('9568', '1873', '1', '4.60', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9569', '1873', '1', '6.40', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('9570', '1873', '1', '7.00', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('9571', '1874', '1', '6.30', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9572', '1874', '1', '6.40', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('9573', '1874', '1', '6.40', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('9574', '1875', '1', '4.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9575', '1875', '1', '3.00', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('9576', '1875', '1', '4.00', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('9577', '1876', '1', '6.60', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9578', '1876', '1', '7.00', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('9579', '1876', '1', '7.00', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('9580', '1692', '7', '5.80', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9581', '1692', '7', '5.50', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9582', '1693', '7', '6.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9583', '1693', '7', '6.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9584', '1694', '7', '6.50', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9585', '1694', '7', '5.80', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9586', '1695', '7', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9587', '1695', '7', '6.80', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9588', '1697', '7', '5.80', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9589', '1697', '7', '5.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9590', '1698', '7', '4.00', '2025-07-11', '1', '1');
INSERT INTO `notas` VALUES('9591', '1698', '7', '5.50', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9592', '1698', '7', '6.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9593', '1699', '7', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9594', '1699', '7', '6.50', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9595', '1700', '7', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9596', '1700', '7', '6.80', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9597', '1701', '7', '5.80', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9598', '1701', '7', '5.20', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9599', '1702', '7', '6.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9600', '1702', '7', '5.80', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9601', '1703', '7', '6.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9602', '1703', '7', '6.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9603', '1704', '7', '6.50', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9604', '1704', '7', '7.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9605', '1705', '7', '5.20', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9606', '1705', '7', '5.80', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9607', '1706', '7', '6.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9608', '1706', '7', '5.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9609', '1707', '7', '6.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9610', '1707', '7', '6.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9611', '1708', '7', '5.80', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9612', '1708', '7', '6.40', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9613', '1709', '7', '6.50', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9614', '1709', '7', '6.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9615', '1710', '7', '6.20', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9616', '1710', '7', '6.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9617', '1711', '7', '4.20', '2025-07-11', '1', '1');
INSERT INTO `notas` VALUES('9618', '1711', '7', '6.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9619', '1711', '7', '4.80', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9620', '1712', '7', '6.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9621', '1712', '7', '6.10', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9742', '1692', '4', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9743', '1693', '4', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9744', '1731', '7', '6.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9745', '1731', '7', '5.90', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9746', '1732', '7', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9747', '1732', '7', '6.70', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9748', '1733', '7', '5.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9749', '1733', '7', '4.80', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9750', '1734', '7', '5.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9751', '1734', '7', '6.70', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9752', '1735', '7', '3.80', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9753', '1735', '7', '6.50', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9754', '1736', '7', '3.40', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9755', '1736', '7', '5.30', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9756', '1737', '7', '4.10', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9757', '1737', '7', '6.40', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9758', '1738', '7', '4.50', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9759', '1738', '7', '6.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9760', '1739', '7', '5.00', '2025-07-11', '1', '2');
INSERT INTO `notas` VALUES('9761', '1739', '7', '4.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9762', '1739', '7', '4.70', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9763', '1740', '7', '6.20', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9764', '1740', '7', '6.70', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9765', '1741', '7', '4.10', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9766', '1741', '7', '6.60', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9767', '1742', '7', '6.50', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9768', '1742', '7', '6.50', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9769', '1743', '7', '2.90', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9770', '1743', '7', '6.20', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9771', '1744', '7', '4.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9772', '1744', '7', '5.80', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9773', '1745', '7', '4.30', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9774', '1745', '7', '4.30', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9775', '1746', '7', '2.40', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9776', '1746', '7', '5.60', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9777', '1747', '7', '5.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9778', '1747', '7', '5.20', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9779', '1748', '7', '5.50', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9780', '1748', '7', '6.90', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9781', '1749', '7', '3.30', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9782', '1749', '7', '4.30', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9783', '1731', '8', '6.40', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9784', '1731', '8', '5.90', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9785', '1732', '8', '5.10', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9786', '1732', '8', '7.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9787', '1733', '8', '5.70', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9788', '1733', '8', '5.20', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9789', '1734', '8', '5.70', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9790', '1734', '8', '5.80', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9791', '1735', '8', '6.40', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9792', '1735', '8', '6.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9793', '1736', '8', '4.50', '2025-07-11', '1', '2');
INSERT INTO `notas` VALUES('9794', '1736', '8', '3.20', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9795', '1736', '8', '5.20', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9796', '1737', '8', '5.70', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9797', '1737', '8', '5.70', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9798', '1738', '8', '6.40', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9799', '1738', '8', '6.10', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9800', '1739', '8', '5.00', '2025-07-11', '1', '2');
INSERT INTO `notas` VALUES('9801', '1739', '8', '5.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9802', '1739', '8', '5.40', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9803', '1740', '8', '4.50', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9804', '1740', '8', '6.40', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9805', '1741', '8', '6.40', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9806', '1741', '8', '6.60', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9807', '1742', '8', '4.50', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9808', '1742', '8', '5.90', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9809', '1743', '8', '4.50', '2025-07-11', '1', '2');
INSERT INTO `notas` VALUES('9810', '1743', '8', '4.50', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9811', '1743', '8', '5.70', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9812', '1744', '8', '4.50', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9813', '1744', '8', '6.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9814', '1745', '8', '3.40', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9815', '1745', '8', '5.10', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9816', '1746', '8', '4.50', '2025-07-11', '1', '2');
INSERT INTO `notas` VALUES('9817', '1746', '8', '3.20', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9818', '1746', '8', '5.60', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9819', '1747', '8', '4.50', '2025-07-11', '1', '2');
INSERT INTO `notas` VALUES('9820', '1747', '8', '5.10', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9821', '1747', '8', '7.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9822', '1748', '8', '5.60', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9823', '1748', '8', '6.50', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9824', '1749', '8', '4.50', '2025-07-11', '1', '2');
INSERT INTO `notas` VALUES('9825', '1749', '8', '2.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9826', '1749', '8', '4.20', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9827', '1448', '1', '4.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9828', '1448', '1', '6.70', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('9829', '1448', '1', '6.30', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('9830', '1449', '1', '4.00', '2025-07-11', '1', '2');
INSERT INTO `notas` VALUES('9831', '1449', '1', '4.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9832', '1449', '1', '5.70', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('9833', '1449', '1', '5.80', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('9834', '1825', '1', '6.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9835', '1825', '1', '6.70', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('9836', '1825', '1', '6.90', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('9837', '1450', '1', '7.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9838', '1450', '1', '7.00', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('9839', '1450', '1', '7.00', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('9840', '1451', '1', '7.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9841', '1451', '1', '7.00', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('9842', '1451', '1', '6.70', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('9843', '1453', '1', '6.90', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9844', '1453', '1', '7.00', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('9845', '1453', '1', '6.90', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('9846', '1455', '1', '7.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9847', '1455', '1', '7.00', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('9848', '1455', '1', '7.00', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('9849', '1456', '1', '7.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9850', '1456', '1', '7.00', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('9851', '1456', '1', '6.80', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('9852', '1457', '1', '7.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9853', '1457', '1', '7.00', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('9854', '1457', '1', '6.90', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('9855', '1843', '1', '5.80', '2025-07-11', '1', '1');
INSERT INTO `notas` VALUES('9856', '1843', '1', '5.70', '2025-07-11', '1', '2');
INSERT INTO `notas` VALUES('9857', '1843', '1', '4.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9858', '1843', '1', '6.50', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('9859', '1843', '1', '6.30', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('9860', '1458', '1', '5.40', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9861', '1458', '1', '7.00', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('9862', '1458', '1', '6.90', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('9863', '1459', '1', '4.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9864', '1459', '1', '7.00', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('9865', '1459', '1', '6.70', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('9866', '1842', '1', '5.80', '2025-07-11', '1', '1');
INSERT INTO `notas` VALUES('9867', '1842', '1', '5.10', '2025-07-11', '1', '2');
INSERT INTO `notas` VALUES('9868', '1842', '1', '4.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9869', '1842', '1', '7.00', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('9870', '1842', '1', '6.00', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('9871', '1460', '1', '5.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9872', '1460', '1', '6.70', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('9873', '1460', '1', '6.70', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('9874', '1461', '1', '6.90', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9875', '1461', '1', '7.00', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('9876', '1461', '1', '6.90', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('9877', '1462', '1', '4.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9878', '1462', '1', '6.00', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('9879', '1462', '1', '6.00', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('9880', '1463', '1', '4.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9881', '1463', '1', '5.40', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('9882', '1463', '1', '6.20', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('9883', '1464', '1', '7.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9884', '1464', '1', '7.00', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('9885', '1464', '1', '6.90', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('9886', '1465', '1', '7.00', '2025-07-11', '1', '1');
INSERT INTO `notas` VALUES('9887', '1465', '1', '6.40', '2025-07-11', '1', '2');
INSERT INTO `notas` VALUES('9888', '1465', '1', '6.40', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9889', '1465', '1', '6.90', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9890', '1465', '1', '6.70', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('9891', '1465', '1', '6.80', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('9892', '1988', '1', '7.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9893', '1988', '1', '7.00', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('9894', '1988', '1', '7.00', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('9895', '1467', '1', '7.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9896', '1467', '1', '6.70', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('9897', '1467', '1', '6.80', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('9898', '1898', '3', '6.80', '2025-07-11', '1', '1');
INSERT INTO `notas` VALUES('9899', '1898', '3', '7.00', '2025-07-11', '1', '2');
INSERT INTO `notas` VALUES('9900', '1898', '3', '6.50', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9901', '1898', '3', '6.80', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9902', '1899', '3', '7.00', '2025-07-11', '1', '1');
INSERT INTO `notas` VALUES('9903', '1899', '3', '7.00', '2025-07-11', '1', '2');
INSERT INTO `notas` VALUES('9904', '1899', '3', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9905', '1899', '3', '7.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9906', '1900', '3', '6.00', '2025-07-11', '1', '1');
INSERT INTO `notas` VALUES('9907', '1900', '3', '7.00', '2025-07-11', '1', '2');
INSERT INTO `notas` VALUES('9908', '1900', '3', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9909', '1900', '3', '7.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9910', '1901', '3', '5.40', '2025-07-11', '1', '1');
INSERT INTO `notas` VALUES('9911', '1901', '3', '5.00', '2025-07-11', '1', '2');
INSERT INTO `notas` VALUES('9912', '1901', '3', '5.80', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9913', '1901', '3', '6.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9914', '1902', '3', '6.00', '2025-07-11', '1', '1');
INSERT INTO `notas` VALUES('9915', '1902', '3', '7.00', '2025-07-11', '1', '2');
INSERT INTO `notas` VALUES('9916', '1902', '3', '6.80', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9917', '1902', '3', '7.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9918', '1920', '3', '5.00', '2025-07-11', '1', '1');
INSERT INTO `notas` VALUES('9919', '1920', '3', '5.00', '2025-07-11', '1', '2');
INSERT INTO `notas` VALUES('9920', '1920', '3', '6.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9921', '1920', '3', '6.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9922', '1919', '3', '5.30', '2025-07-11', '1', '1');
INSERT INTO `notas` VALUES('9923', '1919', '3', '6.20', '2025-07-11', '1', '2');
INSERT INTO `notas` VALUES('9924', '1919', '3', '6.20', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9925', '1919', '3', '5.80', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9926', '1903', '3', '6.20', '2025-07-11', '1', '1');
INSERT INTO `notas` VALUES('9927', '1903', '3', '6.00', '2025-07-11', '1', '2');
INSERT INTO `notas` VALUES('9928', '1903', '3', '6.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9929', '1903', '3', '6.40', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9930', '1904', '3', '5.00', '2025-07-11', '1', '1');
INSERT INTO `notas` VALUES('9931', '1904', '3', '4.00', '2025-07-11', '1', '2');
INSERT INTO `notas` VALUES('9932', '1904', '3', '4.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9933', '1904', '3', '4.50', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9934', '1905', '3', '5.00', '2025-07-11', '1', '1');
INSERT INTO `notas` VALUES('9935', '1905', '3', '5.80', '2025-07-11', '1', '2');
INSERT INTO `notas` VALUES('9936', '1905', '3', '6.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9937', '1905', '3', '6.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9938', '1906', '3', '5.00', '2025-07-11', '1', '1');
INSERT INTO `notas` VALUES('9939', '1906', '3', '4.00', '2025-07-11', '1', '2');
INSERT INTO `notas` VALUES('9940', '1906', '3', '5.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9941', '1906', '3', '5.80', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9942', '1907', '3', '6.50', '2025-07-11', '1', '1');
INSERT INTO `notas` VALUES('9943', '1907', '3', '4.00', '2025-07-11', '1', '2');
INSERT INTO `notas` VALUES('9944', '1907', '3', '6.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9945', '1907', '3', '6.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9946', '1908', '3', '6.20', '2025-07-11', '1', '1');
INSERT INTO `notas` VALUES('9947', '1908', '3', '4.10', '2025-07-11', '1', '2');
INSERT INTO `notas` VALUES('9948', '1908', '3', '5.50', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9949', '1908', '3', '5.80', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9950', '1909', '3', '6.00', '2025-07-11', '1', '1');
INSERT INTO `notas` VALUES('9951', '1909', '3', '4.30', '2025-07-11', '1', '2');
INSERT INTO `notas` VALUES('9952', '1909', '3', '6.50', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9953', '1909', '3', '6.50', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9954', '1910', '3', '5.50', '2025-07-11', '1', '1');
INSERT INTO `notas` VALUES('9955', '1910', '3', '4.00', '2025-07-11', '1', '2');
INSERT INTO `notas` VALUES('9956', '1910', '3', '6.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9957', '1910', '3', '5.80', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9958', '1911', '3', '4.00', '2025-07-11', '1', '1');
INSERT INTO `notas` VALUES('9959', '1911', '3', '4.00', '2025-07-11', '1', '2');
INSERT INTO `notas` VALUES('9960', '1911', '3', '4.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9961', '1911', '3', '4.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9962', '1912', '3', '6.20', '2025-07-11', '1', '1');
INSERT INTO `notas` VALUES('9963', '1912', '3', '6.00', '2025-07-11', '1', '2');
INSERT INTO `notas` VALUES('9964', '1912', '3', '6.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9965', '1912', '3', '6.20', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9966', '1913', '3', '6.80', '2025-07-11', '1', '1');
INSERT INTO `notas` VALUES('9967', '1913', '3', '4.60', '2025-07-11', '1', '2');
INSERT INTO `notas` VALUES('9968', '1913', '3', '6.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9969', '1913', '3', '6.80', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9970', '1914', '3', '6.80', '2025-07-11', '1', '1');
INSERT INTO `notas` VALUES('9971', '1914', '3', '6.00', '2025-07-11', '1', '2');
INSERT INTO `notas` VALUES('9972', '1914', '3', '6.50', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9973', '1914', '3', '6.40', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9974', '1915', '3', '7.00', '2025-07-11', '1', '1');
INSERT INTO `notas` VALUES('9975', '1915', '3', '6.80', '2025-07-11', '1', '2');
INSERT INTO `notas` VALUES('9976', '1915', '3', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9977', '1915', '3', '7.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9978', '1916', '3', '6.50', '2025-07-11', '1', '1');
INSERT INTO `notas` VALUES('9979', '1916', '3', '4.80', '2025-07-11', '1', '2');
INSERT INTO `notas` VALUES('9980', '1916', '3', '6.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9981', '1916', '3', '6.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9982', '1917', '3', '6.80', '2025-07-11', '1', '1');
INSERT INTO `notas` VALUES('9983', '1917', '3', '4.80', '2025-07-11', '1', '2');
INSERT INTO `notas` VALUES('9984', '1917', '3', '5.80', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9985', '1917', '3', '6.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9986', '1921', '3', '5.70', '2025-07-11', '1', '1');
INSERT INTO `notas` VALUES('9987', '1921', '3', '5.70', '2025-07-11', '1', '2');
INSERT INTO `notas` VALUES('9988', '1921', '3', '6.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9989', '1921', '3', '6.20', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9990', '1918', '3', '6.50', '2025-07-11', '1', '1');
INSERT INTO `notas` VALUES('9991', '1918', '3', '5.00', '2025-07-11', '1', '2');
INSERT INTO `notas` VALUES('9992', '1918', '3', '5.80', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9993', '1918', '3', '6.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9994', '1692', '8', '4.70', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9995', '1692', '8', '6.10', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9996', '1693', '8', '5.10', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9997', '1693', '8', '6.20', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('9998', '1694', '8', '5.90', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('9999', '1694', '8', '6.50', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('10000', '1695', '8', '5.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('10001', '1695', '8', '6.90', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('10002', '1697', '8', '4.80', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('10003', '1697', '8', '5.60', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('10004', '1698', '8', '5.40', '2025-07-11', '1', '2');
INSERT INTO `notas` VALUES('10005', '1698', '8', '5.40', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('10006', '1698', '8', '5.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('10007', '1699', '8', '5.50', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('10008', '1699', '8', '6.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('10009', '1700', '8', '5.90', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('10010', '1700', '8', '6.60', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('10011', '1701', '8', '4.80', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('10012', '1701', '8', '5.70', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('10013', '1702', '8', '4.80', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('10014', '1702', '8', '6.20', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('10015', '1703', '8', '4.80', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('10016', '1703', '8', '6.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('10017', '1704', '8', '5.60', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('10018', '1704', '8', '6.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('10019', '1705', '8', '4.80', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('10020', '1705', '8', '6.10', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('10021', '1706', '8', '4.80', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('10022', '1706', '8', '5.40', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('10023', '1707', '8', '3.20', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('10024', '1707', '8', '5.80', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('10025', '1708', '8', '6.30', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('10026', '1708', '8', '6.60', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('10027', '1709', '8', '5.50', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('10028', '1709', '8', '6.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('10029', '1710', '8', '2.80', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('10030', '1710', '8', '5.60', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('10031', '1711', '8', '5.40', '2025-07-11', '1', '2');
INSERT INTO `notas` VALUES('10032', '1711', '8', '5.10', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('10033', '1711', '8', '5.50', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('10034', '1712', '8', '4.60', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('10035', '1712', '8', '5.80', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('10036', '1585', '8', '6.70', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('10037', '1585', '8', '5.20', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('10038', '1586', '8', '6.70', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('10039', '1586', '8', '5.40', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('10040', '1587', '8', '4.60', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('10041', '1587', '8', '5.60', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('10042', '1588', '8', '4.10', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('10043', '1588', '8', '5.80', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('10044', '1589', '8', '4.10', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('10045', '1589', '8', '5.10', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('10046', '1590', '8', '5.70', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('10047', '1590', '8', '5.70', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('10048', '1591', '8', '4.10', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('10049', '1591', '8', '5.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('10050', '1592', '8', '4.10', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('10051', '1592', '8', '5.70', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('10052', '1593', '8', '4.60', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('10053', '1593', '8', '5.70', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('10054', '1594', '8', '4.10', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('10055', '1594', '8', '5.80', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('10056', '1595', '8', '6.70', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('10057', '1595', '8', '6.60', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('10058', '1596', '8', '5.70', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('10059', '1596', '8', '5.90', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('10060', '1597', '8', '4.10', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('10061', '1597', '8', '5.30', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('10062', '1598', '8', '4.10', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('10063', '1598', '8', '5.90', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('10064', '1599', '8', '4.60', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('10065', '1599', '8', '5.30', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('10066', '1600', '8', '4.60', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('10067', '1600', '8', '5.60', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('10068', '1601', '8', '6.70', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('10069', '1601', '8', '5.50', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('10070', '1602', '8', '4.10', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('10071', '1602', '8', '5.60', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('10072', '1603', '8', '4.60', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('10073', '1603', '8', '6.40', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('10074', '1604', '8', '4.10', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('10075', '1604', '8', '5.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('10076', '1605', '8', '4.60', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('10077', '1605', '8', '5.30', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('10078', '1606', '8', '4.10', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('10079', '1606', '8', '5.20', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('10080', '1607', '8', '6.70', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('10081', '1607', '8', '6.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('10082', '1608', '8', '5.70', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('10083', '1608', '8', '5.90', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('10084', '1609', '8', '5.70', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('10085', '1609', '8', '6.40', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('10086', '1692', '11', '5.10', '2025-07-11', '1', '2');
INSERT INTO `notas` VALUES('10087', '1692', '11', '5.20', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('10088', '1692', '11', '5.90', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('10089', '1692', '11', '7.00', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('10090', '1692', '11', '6.00', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('10091', '1693', '11', '7.00', '2025-07-11', '1', '2');
INSERT INTO `notas` VALUES('10092', '1693', '11', '6.40', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('10093', '1693', '11', '6.30', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('10094', '1693', '11', '6.00', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('10095', '1693', '11', '6.20', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('10096', '1694', '11', '5.90', '2025-07-11', '1', '2');
INSERT INTO `notas` VALUES('10097', '1694', '11', '6.20', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('10098', '1694', '11', '5.40', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('10099', '1694', '11', '6.00', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('10100', '1694', '11', '6.00', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('10101', '1695', '11', '7.00', '2025-07-11', '1', '2');
INSERT INTO `notas` VALUES('10102', '1695', '11', '6.70', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('10103', '1695', '11', '5.90', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('10104', '1695', '11', '7.00', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('10105', '1695', '11', '7.00', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('10106', '1697', '11', '5.00', '2025-07-11', '1', '2');
INSERT INTO `notas` VALUES('10107', '1697', '11', '5.20', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('10108', '1697', '11', '5.10', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('10109', '1697', '11', '5.50', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('10110', '1697', '11', '5.00', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('10111', '1698', '11', '7.00', '2025-07-11', '1', '1');
INSERT INTO `notas` VALUES('10112', '1698', '11', '6.50', '2025-07-11', '1', '2');
INSERT INTO `notas` VALUES('10113', '1698', '11', '4.50', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('10114', '1698', '11', '4.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('10115', '1698', '11', '4.80', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('10116', '1698', '11', '5.00', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('10117', '1699', '11', '7.00', '2025-07-11', '1', '2');
INSERT INTO `notas` VALUES('10118', '1699', '11', '6.70', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('10119', '1699', '11', '5.80', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('10120', '1699', '11', '7.00', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('10121', '1699', '11', '6.50', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('10122', '1700', '11', '7.00', '2025-07-11', '1', '2');
INSERT INTO `notas` VALUES('10123', '1700', '11', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('10124', '1700', '11', '6.30', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('10125', '1700', '11', '6.60', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('10126', '1700', '11', '6.80', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('10127', '1948', '2', '4.70', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('10128', '1948', '2', '5.70', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('10129', '1948', '2', '7.00', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('10130', '1948', '2', '6.30', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('10131', '1949', '2', '5.70', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('10132', '1949', '2', '5.20', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('10133', '1949', '2', '7.00', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('10134', '1949', '2', '6.80', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('10135', '1950', '2', '3.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('10136', '1950', '2', '5.70', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('10137', '1950', '2', '6.30', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('10138', '1950', '2', '5.70', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('10139', '1951', '2', '5.70', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('10140', '1951', '2', '5.50', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('10141', '1951', '2', '6.60', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('10142', '1951', '2', '6.90', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('10143', '1952', '2', '5.30', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('10144', '1952', '2', '6.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('10145', '1952', '2', '7.00', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('10146', '1952', '2', '6.60', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('10147', '1953', '2', '6.70', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('10148', '1953', '2', '6.70', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('10149', '1953', '2', '5.10', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('10150', '1953', '2', '6.90', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('10151', '1954', '2', '3.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('10152', '1954', '2', '3.30', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('10153', '1954', '2', '4.00', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('10154', '1954', '2', '6.00', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('10155', '1956', '2', '2.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('10156', '1956', '2', '2.30', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('10157', '1956', '2', '4.80', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('10158', '1956', '2', '5.20', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('10159', '1957', '2', '3.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('10160', '1957', '2', '4.30', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('10161', '1957', '2', '3.30', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('10162', '1957', '2', '5.00', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('10163', '1701', '11', '6.40', '2025-07-11', '1', '2');
INSERT INTO `notas` VALUES('10164', '1701', '11', '5.20', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('10165', '1701', '11', '4.50', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('10166', '1701', '11', '5.00', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('10167', '1701', '11', '5.40', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('10168', '1702', '11', '5.00', '2025-07-11', '1', '2');
INSERT INTO `notas` VALUES('10169', '1702', '11', '5.80', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('10170', '1702', '11', '5.80', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('10171', '1702', '11', '5.70', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('10172', '1702', '11', '6.00', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('10173', '1703', '11', '6.70', '2025-07-11', '1', '2');
INSERT INTO `notas` VALUES('10174', '1703', '11', '6.50', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('10175', '1703', '11', '5.80', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('10176', '1703', '11', '6.00', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('10177', '1703', '11', '5.90', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('10178', '1704', '11', '7.00', '2025-07-11', '1', '2');
INSERT INTO `notas` VALUES('10179', '1704', '11', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('10180', '1704', '11', '5.80', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('10181', '1704', '11', '7.00', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('10182', '1704', '11', '7.00', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('10183', '1705', '11', '5.00', '2025-07-11', '1', '2');
INSERT INTO `notas` VALUES('10184', '1705', '11', '4.70', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('10185', '1705', '11', '5.10', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('10186', '1705', '11', '5.00', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('10187', '1705', '11', '5.50', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('10188', '1706', '11', '4.00', '2025-07-11', '1', '2');
INSERT INTO `notas` VALUES('10189', '1706', '11', '4.70', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('10190', '1706', '11', '5.80', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('10191', '1706', '11', '5.00', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('10192', '1706', '11', '4.80', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('10193', '1707', '11', '5.80', '2025-07-11', '1', '2');
INSERT INTO `notas` VALUES('10194', '1707', '11', '6.20', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('10195', '1707', '11', '5.40', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('10196', '1707', '11', '5.00', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('10197', '1707', '11', '5.70', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('10198', '1708', '11', '7.00', '2025-07-11', '1', '2');
INSERT INTO `notas` VALUES('10199', '1708', '11', '6.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('10200', '1708', '11', '5.70', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('10201', '1708', '11', '6.00', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('10202', '1708', '11', '6.00', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('10203', '1709', '11', '6.40', '2025-07-11', '1', '2');
INSERT INTO `notas` VALUES('10204', '1709', '11', '6.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('10205', '1709', '11', '5.80', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('10206', '1709', '11', '7.00', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('10207', '1709', '11', '6.30', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('10208', '1710', '11', '6.40', '2025-07-11', '1', '2');
INSERT INTO `notas` VALUES('10209', '1710', '11', '5.80', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('10210', '1710', '11', '5.20', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('10211', '1710', '11', '6.00', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('10212', '1710', '11', '6.50', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('10213', '1711', '11', '5.00', '2025-07-11', '1', '2');
INSERT INTO `notas` VALUES('10214', '1711', '11', '4.70', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('10215', '1711', '11', '4.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('10216', '1711', '11', '5.00', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('10217', '1711', '11', '5.00', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('10218', '1712', '11', '5.00', '2025-07-11', '1', '1');
INSERT INTO `notas` VALUES('10219', '1712', '11', '6.40', '2025-07-11', '1', '2');
INSERT INTO `notas` VALUES('10220', '1712', '11', '5.20', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('10221', '1712', '11', '6.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('10222', '1712', '11', '5.90', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('10223', '1712', '11', '6.40', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('10224', '1958', '2', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('10225', '1958', '2', '7.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('10226', '1958', '2', '7.00', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('10227', '1958', '2', '7.00', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('10228', '1959', '2', '6.70', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('10229', '1959', '2', '6.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('10230', '1959', '2', '7.00', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('10231', '1959', '2', '5.30', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('10232', '1960', '2', '5.30', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('10233', '1960', '2', '5.70', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('10234', '1960', '2', '7.00', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('10235', '1960', '2', '6.80', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('10236', '1961', '2', '3.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('10237', '1961', '2', '2.70', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('10238', '1961', '2', '4.00', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('10239', '1961', '2', '5.30', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('10240', '1962', '2', '6.30', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('10241', '1962', '2', '6.40', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('10242', '1962', '2', '6.40', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('10243', '1963', '2', '3.70', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('10244', '1963', '2', '5.50', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('10245', '1963', '2', '6.30', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('10246', '1963', '2', '5.00', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('10247', '1964', '2', '6.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('10248', '1964', '2', '4.40', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('10249', '1964', '2', '4.00', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('10250', '1964', '2', '6.30', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('10251', '1965', '2', '2.70', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('10252', '1965', '2', '6.60', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('10253', '1965', '2', '7.00', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('10254', '1965', '2', '6.80', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('10255', '1966', '2', '3.70', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('10256', '1966', '2', '4.60', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('10257', '1966', '2', '6.60', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('10258', '1966', '2', '6.00', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('10259', '1967', '2', '5.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('10260', '1967', '2', '3.10', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('10261', '1967', '2', '6.50', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('10262', '1967', '2', '4.60', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('10263', '1968', '2', '2.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('10264', '1968', '2', '5.80', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('10265', '1968', '2', '5.90', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('10266', '1968', '2', '4.80', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('10267', '1969', '2', '2.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('10268', '1969', '2', '4.40', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('10269', '1969', '2', '6.50', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('10270', '1969', '2', '4.50', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('10271', '1970', '2', '5.30', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('10272', '1970', '2', '6.60', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('10273', '1970', '2', '7.00', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('10274', '1970', '2', '5.60', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('10275', '1971', '2', '2.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('10276', '1971', '2', '2.30', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('10277', '1971', '2', '6.10', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('10278', '1971', '2', '5.00', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('10279', '1972', '2', '4.70', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('10280', '1972', '2', '5.70', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('10281', '1972', '2', '7.00', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('10282', '1972', '2', '5.90', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('10283', '1973', '2', '3.70', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('10284', '1973', '2', '6.70', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('10285', '1973', '2', '7.00', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('10286', '1973', '2', '5.90', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('10287', '1975', '2', '5.30', '2025-07-11', '1', '1');
INSERT INTO `notas` VALUES('10288', '1975', '2', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('10289', '1975', '2', '5.10', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('10290', '1975', '2', '5.50', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('10291', '1975', '2', '5.30', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('10292', '1976', '2', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('10293', '1976', '2', '7.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('10294', '1976', '2', '7.00', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('10295', '1976', '2', '6.80', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('10296', '1977', '2', '4.30', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('10297', '1977', '2', '4.60', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('10298', '1977', '2', '5.50', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('10299', '1977', '2', '6.30', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('10300', '1978', '2', '5.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('10301', '1978', '2', '7.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('10302', '1978', '2', '7.00', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('10303', '1978', '2', '6.50', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('10304', '1979', '2', '5.90', '2025-07-11', '1', '2');
INSERT INTO `notas` VALUES('10305', '1979', '2', '2.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('10306', '1979', '2', '2.30', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('10307', '1979', '2', '5.90', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('10308', '1979', '2', '4.10', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('10309', '1980', '2', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('10310', '1980', '2', '6.10', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('10311', '1980', '2', '7.00', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('10312', '1980', '2', '6.60', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('10313', '1981', '2', '5.70', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('10314', '1981', '2', '6.10', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('10315', '1981', '2', '7.00', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('10316', '1981', '2', '6.70', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('10317', '1982', '2', '5.90', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('10318', '1982', '2', '4.80', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('10319', '1982', '2', '5.90', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('10320', '1982', '2', '6.20', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('10321', '1983', '2', '4.80', '2025-07-11', '1', '2');
INSERT INTO `notas` VALUES('10322', '1983', '2', '2.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('10323', '1983', '2', '3.80', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('10324', '1983', '2', '5.50', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('10325', '1983', '2', '4.90', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('10326', '1984', '2', '4.10', '2025-07-11', '1', '2');
INSERT INTO `notas` VALUES('10327', '1984', '2', '6.70', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('10328', '1984', '2', '4.80', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('10329', '1984', '2', '7.00', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('10330', '1984', '2', '6.20', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('10331', '1985', '2', '5.90', '2025-07-11', '1', '1');
INSERT INTO `notas` VALUES('10332', '1985', '2', '4.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('10333', '1985', '2', '5.10', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('10334', '1985', '2', '5.90', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('10335', '1985', '2', '5.30', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('10336', '1986', '2', '4.40', '2025-07-11', '1', '1');
INSERT INTO `notas` VALUES('10337', '1986', '2', '3.20', '2025-07-11', '1', '2');
INSERT INTO `notas` VALUES('10338', '1986', '2', '4.40', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('10339', '1986', '2', '2.30', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('10340', '1986', '2', '3.30', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('10341', '1986', '2', '5.10', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('10342', '1987', '2', '7.00', '2025-07-11', '1', '3');
INSERT INTO `notas` VALUES('10343', '1987', '2', '7.00', '2025-07-11', '1', '4');
INSERT INTO `notas` VALUES('10344', '1987', '2', '7.00', '2025-07-11', '1', '5');
INSERT INTO `notas` VALUES('10345', '1987', '2', '7.00', '2025-07-11', '1', '6');
INSERT INTO `notas` VALUES('10346', '1429', '1', '6.00', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10347', '1429', '1', '5.70', '2025-07-13', '1', '6');
INSERT INTO `notas` VALUES('10348', '1430', '1', '6.60', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10349', '1430', '1', '7.00', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10350', '1430', '1', '6.70', '2025-07-13', '1', '6');
INSERT INTO `notas` VALUES('10351', '1431', '1', '7.00', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10352', '1431', '1', '6.60', '2025-07-13', '1', '6');
INSERT INTO `notas` VALUES('10353', '1432', '1', '6.80', '2025-07-13', '1', '2');
INSERT INTO `notas` VALUES('10354', '1432', '1', '6.90', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10355', '1432', '1', '6.50', '2025-07-13', '1', '6');
INSERT INTO `notas` VALUES('10356', '1433', '1', '7.00', '2025-07-13', '1', '2');
INSERT INTO `notas` VALUES('10357', '1433', '1', '5.00', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10358', '1433', '1', '7.00', '2025-07-13', '1', '6');
INSERT INTO `notas` VALUES('10359', '1434', '1', '7.00', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10360', '1434', '1', '6.50', '2025-07-13', '1', '6');
INSERT INTO `notas` VALUES('10361', '1435', '1', '4.00', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10362', '1435', '1', '7.00', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10363', '1435', '1', '5.30', '2025-07-13', '1', '6');
INSERT INTO `notas` VALUES('10364', '1436', '1', '5.00', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10365', '1436', '1', '5.40', '2025-07-13', '1', '6');
INSERT INTO `notas` VALUES('10366', '1454', '1', '6.70', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10367', '1454', '1', '6.90', '2025-07-13', '1', '6');
INSERT INTO `notas` VALUES('10368', '1437', '1', '6.60', '2025-07-13', '1', '2');
INSERT INTO `notas` VALUES('10369', '1437', '1', '6.00', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10370', '1437', '1', '6.50', '2025-07-13', '1', '6');
INSERT INTO `notas` VALUES('10371', '1438', '1', '6.00', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10372', '1438', '1', '4.00', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10373', '1438', '1', '6.40', '2025-07-13', '1', '6');
INSERT INTO `notas` VALUES('10374', '1439', '1', '4.00', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10375', '1439', '1', '6.70', '2025-07-13', '1', '6');
INSERT INTO `notas` VALUES('10376', '1440', '1', '6.60', '2025-07-13', '1', '2');
INSERT INTO `notas` VALUES('10377', '1440', '1', '6.00', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10378', '1440', '1', '7.00', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10379', '1440', '1', '6.30', '2025-07-13', '1', '6');
INSERT INTO `notas` VALUES('10380', '1441', '1', '6.00', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10381', '1441', '1', '6.50', '2025-07-13', '1', '6');
INSERT INTO `notas` VALUES('10382', '1442', '1', '7.00', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10383', '1442', '1', '6.60', '2025-07-13', '1', '6');
INSERT INTO `notas` VALUES('10384', '1443', '1', '6.00', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10385', '1443', '1', '6.80', '2025-07-13', '1', '6');
INSERT INTO `notas` VALUES('10386', '1444', '1', '5.00', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10387', '1444', '1', '6.60', '2025-07-13', '1', '6');
INSERT INTO `notas` VALUES('10388', '1445', '1', '5.00', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10389', '1445', '1', '6.50', '2025-07-13', '1', '6');
INSERT INTO `notas` VALUES('10390', '1446', '1', '7.00', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10391', '1446', '1', '6.00', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10392', '1446', '1', '7.00', '2025-07-13', '1', '6');
INSERT INTO `notas` VALUES('10393', '1447', '1', '6.00', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10394', '1447', '1', '6.50', '2025-07-13', '1', '6');
INSERT INTO `notas` VALUES('10395', '1429', '2', '6.50', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10396', '1429', '2', '5.70', '2025-07-13', '1', '6');
INSERT INTO `notas` VALUES('10397', '1430', '2', '7.00', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10398', '1430', '2', '6.70', '2025-07-13', '1', '6');
INSERT INTO `notas` VALUES('10399', '1431', '2', '7.00', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10400', '1431', '2', '6.60', '2025-07-13', '1', '6');
INSERT INTO `notas` VALUES('10401', '1432', '2', '6.80', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10402', '1432', '2', '6.50', '2025-07-13', '1', '6');
INSERT INTO `notas` VALUES('10403', '1433', '2', '6.80', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10404', '1433', '2', '7.00', '2025-07-13', '1', '6');
INSERT INTO `notas` VALUES('10405', '1434', '2', '6.90', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10406', '1434', '2', '7.00', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10407', '1434', '2', '6.50', '2025-07-13', '1', '6');
INSERT INTO `notas` VALUES('10408', '1435', '2', '5.60', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10409', '1435', '2', '5.30', '2025-07-13', '1', '6');
INSERT INTO `notas` VALUES('10410', '1436', '2', '6.50', '2025-07-13', '1', '2');
INSERT INTO `notas` VALUES('10411', '1436', '2', '7.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10412', '1436', '2', '7.00', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10413', '1436', '2', '5.40', '2025-07-13', '1', '6');
INSERT INTO `notas` VALUES('10414', '1454', '2', '7.00', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10415', '1454', '2', '6.90', '2025-07-13', '1', '6');
INSERT INTO `notas` VALUES('10416', '1437', '2', '7.00', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10417', '1437', '2', '6.50', '2025-07-13', '1', '6');
INSERT INTO `notas` VALUES('10418', '1438', '2', '7.00', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10419', '1438', '2', '6.40', '2025-07-13', '1', '6');
INSERT INTO `notas` VALUES('10420', '1439', '2', '6.90', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10421', '1439', '2', '6.70', '2025-07-13', '1', '6');
INSERT INTO `notas` VALUES('10422', '1440', '2', '6.30', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10423', '1440', '2', '6.20', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10424', '1440', '2', '6.30', '2025-07-13', '1', '6');
INSERT INTO `notas` VALUES('10425', '1441', '2', '6.40', '2025-07-13', '1', '1');
INSERT INTO `notas` VALUES('10426', '1441', '2', '6.80', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10427', '1441', '2', '6.50', '2025-07-13', '1', '6');
INSERT INTO `notas` VALUES('10428', '1442', '2', '7.00', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10429', '1442', '2', '6.60', '2025-07-13', '1', '6');
INSERT INTO `notas` VALUES('10430', '1443', '2', '7.00', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10431', '1443', '2', '6.80', '2025-07-13', '1', '6');
INSERT INTO `notas` VALUES('10432', '1444', '2', '7.00', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10433', '1444', '2', '6.60', '2025-07-13', '1', '6');
INSERT INTO `notas` VALUES('10434', '1445', '2', '6.10', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10435', '1445', '2', '6.50', '2025-07-13', '1', '6');
INSERT INTO `notas` VALUES('10436', '1446', '2', '6.80', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10437', '1446', '2', '7.00', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10438', '1446', '2', '7.00', '2025-07-13', '1', '6');
INSERT INTO `notas` VALUES('10439', '1447', '2', '7.00', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10440', '1447', '2', '6.50', '2025-07-13', '1', '6');
INSERT INTO `notas` VALUES('10441', '1429', '6', '6.50', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10442', '1429', '6', '6.40', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10443', '1429', '6', '5.70', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10444', '1430', '6', '7.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10445', '1430', '6', '6.80', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10446', '1430', '6', '6.70', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10447', '1431', '6', '6.80', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10448', '1431', '6', '6.70', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10449', '1431', '6', '6.60', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10450', '1432', '6', '6.50', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10451', '1432', '6', '6.60', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10452', '1432', '6', '6.50', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10453', '1433', '6', '7.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10454', '1433', '6', '6.90', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10455', '1433', '6', '7.00', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10456', '1434', '6', '6.80', '2025-07-13', '1', '2');
INSERT INTO `notas` VALUES('10457', '1434', '6', '7.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10458', '1434', '6', '6.90', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10459', '1434', '6', '6.50', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10460', '1435', '6', '5.20', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10461', '1435', '6', '5.60', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10462', '1435', '6', '5.30', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10463', '1436', '6', '6.20', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10464', '1436', '6', '6.10', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10465', '1436', '6', '5.40', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10466', '1454', '6', '6.80', '2025-07-13', '1', '2');
INSERT INTO `notas` VALUES('10467', '1454', '6', '7.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10468', '1454', '6', '6.90', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10469', '1454', '6', '6.90', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10470', '1437', '6', '6.30', '2025-07-13', '1', '1');
INSERT INTO `notas` VALUES('10471', '1437', '6', '6.50', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10472', '1437', '6', '6.40', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10473', '1437', '6', '6.50', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10474', '1438', '6', '6.80', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10475', '1438', '6', '6.90', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10476', '1438', '6', '6.40', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10477', '1439', '6', '6.50', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10478', '1439', '6', '6.40', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10479', '1439', '6', '6.70', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10480', '1440', '6', '6.30', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10481', '1440', '6', '6.50', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10482', '1440', '6', '6.30', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10483', '1441', '6', '5.90', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10484', '1441', '6', '6.20', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10485', '1441', '6', '6.50', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10486', '1442', '6', '7.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10487', '1442', '6', '6.10', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10488', '1442', '6', '6.60', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10489', '1443', '6', '7.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10490', '1443', '6', '6.50', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10491', '1443', '6', '6.80', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10492', '1444', '6', '7.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10493', '1444', '6', '6.90', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10494', '1444', '6', '6.60', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10495', '1445', '6', '6.80', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10496', '1445', '6', '6.80', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10497', '1445', '6', '6.50', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10498', '1446', '6', '7.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10499', '1446', '6', '6.90', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10500', '1446', '6', '7.00', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10501', '1447', '6', '6.40', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10502', '1447', '6', '6.40', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10503', '1447', '6', '6.50', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10504', '1429', '7', '6.50', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10505', '1429', '7', '5.90', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10506', '1429', '7', '5.70', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10507', '1430', '7', '6.80', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10508', '1430', '7', '6.90', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10509', '1430', '7', '6.70', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10510', '1431', '7', '6.80', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10511', '1431', '7', '6.90', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10512', '1431', '7', '6.60', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10513', '1432', '7', '6.80', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10514', '1432', '7', '6.30', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10515', '1432', '7', '6.50', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10516', '1433', '7', '7.00', '2025-07-13', '1', '1');
INSERT INTO `notas` VALUES('10517', '1433', '7', '6.60', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10518', '1433', '7', '6.80', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10519', '1433', '7', '7.00', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10520', '1434', '7', '6.50', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10521', '1434', '7', '6.60', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10522', '1434', '7', '6.50', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10523', '1435', '7', '5.80', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10524', '1435', '7', '5.70', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10525', '1435', '7', '5.30', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10526', '1436', '7', '5.60', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10527', '1436', '7', '5.80', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10528', '1436', '7', '5.40', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10529', '1454', '7', '6.80', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10530', '1454', '7', '6.50', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10531', '1454', '7', '6.90', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10532', '1437', '7', '6.30', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10533', '1437', '7', '6.40', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10534', '1437', '7', '6.50', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10535', '1438', '7', '6.00', '2025-07-13', '1', '2');
INSERT INTO `notas` VALUES('10536', '1438', '7', '6.50', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10537', '1438', '7', '6.00', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10538', '1438', '7', '6.40', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10539', '1439', '7', '6.50', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10540', '1439', '7', '6.40', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10541', '1439', '7', '6.70', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10542', '1440', '7', '6.00', '2025-07-13', '1', '1');
INSERT INTO `notas` VALUES('10543', '1440', '7', '6.00', '2025-07-13', '1', '2');
INSERT INTO `notas` VALUES('10544', '1440', '7', '5.80', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10545', '1440', '7', '6.00', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10546', '1440', '7', '6.30', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10547', '1441', '7', '6.30', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10548', '1441', '7', '6.30', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10549', '1441', '7', '6.50', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10550', '1442', '7', '6.20', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10551', '1442', '7', '6.30', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10552', '1442', '7', '6.60', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10553', '1443', '7', '6.80', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10554', '1443', '7', '6.80', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10555', '1443', '7', '6.80', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10556', '1444', '7', '6.60', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10557', '1444', '7', '6.50', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10558', '1444', '7', '6.60', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10559', '1445', '7', '6.30', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10560', '1445', '7', '6.60', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10561', '1445', '7', '6.50', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10562', '1446', '7', '7.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10563', '1446', '7', '7.00', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10564', '1446', '7', '7.00', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10565', '1447', '7', '6.30', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10566', '1447', '7', '6.50', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10567', '1447', '7', '6.50', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10568', '1448', '2', '6.60', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10569', '1448', '2', '6.50', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10570', '1448', '2', '6.60', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10571', '1448', '2', '6.30', '2025-07-13', '1', '6');
INSERT INTO `notas` VALUES('10572', '1449', '2', '5.10', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10573', '1449', '2', '6.20', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10574', '1449', '2', '6.30', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10575', '1449', '2', '5.80', '2025-07-13', '1', '6');
INSERT INTO `notas` VALUES('10576', '1825', '2', '6.60', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10577', '1825', '2', '6.60', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10578', '1825', '2', '6.70', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10579', '1825', '2', '6.90', '2025-07-13', '1', '6');
INSERT INTO `notas` VALUES('10580', '1450', '2', '7.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10581', '1450', '2', '7.00', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10582', '1450', '2', '7.00', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10583', '1450', '2', '7.00', '2025-07-13', '1', '6');
INSERT INTO `notas` VALUES('10584', '1451', '2', '7.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10585', '1451', '2', '7.00', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10586', '1451', '2', '6.60', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10587', '1451', '2', '6.70', '2025-07-13', '1', '6');
INSERT INTO `notas` VALUES('10588', '1453', '2', '7.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10589', '1453', '2', '7.00', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10590', '1453', '2', '6.60', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10591', '1453', '2', '6.90', '2025-07-13', '1', '6');
INSERT INTO `notas` VALUES('10592', '1455', '2', '7.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10593', '1455', '2', '7.00', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10594', '1455', '2', '6.80', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10595', '1455', '2', '7.00', '2025-07-13', '1', '6');
INSERT INTO `notas` VALUES('10596', '1456', '2', '6.60', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10597', '1456', '2', '7.00', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10598', '1456', '2', '6.30', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10599', '1456', '2', '6.80', '2025-07-13', '1', '6');
INSERT INTO `notas` VALUES('10600', '1457', '2', '7.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10601', '1457', '2', '6.70', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10602', '1457', '2', '6.60', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10603', '1457', '2', '6.90', '2025-07-13', '1', '6');
INSERT INTO `notas` VALUES('10604', '1843', '2', '5.90', '2025-07-13', '1', '1');
INSERT INTO `notas` VALUES('10605', '1843', '2', '5.10', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10606', '1843', '2', '5.10', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10607', '1843', '2', '6.60', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10608', '1843', '2', '6.30', '2025-07-13', '1', '6');
INSERT INTO `notas` VALUES('10609', '1458', '2', '7.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10610', '1458', '2', '6.80', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10611', '1458', '2', '7.00', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10612', '1458', '2', '6.90', '2025-07-13', '1', '6');
INSERT INTO `notas` VALUES('10613', '1459', '2', '4.80', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10614', '1459', '2', '6.50', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10615', '1459', '2', '7.00', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10616', '1459', '2', '6.70', '2025-07-13', '1', '6');
INSERT INTO `notas` VALUES('10617', '1842', '2', '5.30', '2025-07-13', '1', '1');
INSERT INTO `notas` VALUES('10618', '1842', '2', '4.30', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10619', '1842', '2', '4.50', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10620', '1842', '2', '3.30', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10621', '1842', '2', '6.00', '2025-07-13', '1', '6');
INSERT INTO `notas` VALUES('10622', '1460', '2', '4.80', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10623', '1460', '2', '5.70', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10624', '1460', '2', '5.10', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10625', '1460', '2', '6.70', '2025-07-13', '1', '6');
INSERT INTO `notas` VALUES('10626', '1461', '2', '7.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10627', '1461', '2', '6.80', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10628', '1461', '2', '7.00', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10629', '1461', '2', '6.90', '2025-07-13', '1', '6');
INSERT INTO `notas` VALUES('10630', '1462', '2', '6.10', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10631', '1462', '2', '5.70', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10632', '1462', '2', '5.90', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10633', '1462', '2', '6.00', '2025-07-13', '1', '6');
INSERT INTO `notas` VALUES('10634', '1463', '2', '6.60', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10635', '1463', '2', '6.60', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10636', '1463', '2', '6.60', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10637', '1463', '2', '6.20', '2025-07-13', '1', '6');
INSERT INTO `notas` VALUES('10638', '1464', '2', '7.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10639', '1464', '2', '7.00', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10640', '1464', '2', '7.00', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10641', '1464', '2', '6.90', '2025-07-13', '1', '6');
INSERT INTO `notas` VALUES('10642', '1465', '2', '6.00', '2025-07-13', '1', '1');
INSERT INTO `notas` VALUES('10643', '1465', '2', '6.50', '2025-07-13', '1', '2');
INSERT INTO `notas` VALUES('10644', '1465', '2', '6.50', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10645', '1465', '2', '6.70', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10646', '1465', '2', '6.60', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10647', '1465', '2', '6.80', '2025-07-13', '1', '6');
INSERT INTO `notas` VALUES('10648', '1988', '2', '7.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10649', '1988', '2', '7.00', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10650', '1988', '2', '7.00', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10651', '1988', '2', '7.00', '2025-07-13', '1', '6');
INSERT INTO `notas` VALUES('10652', '1467', '2', '6.20', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10653', '1467', '2', '6.70', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10654', '1467', '2', '6.60', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10655', '1467', '2', '6.80', '2025-07-13', '1', '6');
INSERT INTO `notas` VALUES('10656', '1465', '5', '7.00', '2025-07-13', '1', '1');
INSERT INTO `notas` VALUES('10657', '1465', '5', '6.50', '2025-07-13', '1', '2');
INSERT INTO `notas` VALUES('10658', '1465', '5', '6.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10659', '1465', '5', '7.00', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10660', '1448', '6', '7.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10661', '1448', '6', '6.30', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10662', '1449', '6', '6.10', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10663', '1449', '6', '5.80', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10664', '1825', '6', '6.50', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10665', '1825', '6', '6.90', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10666', '1450', '6', '7.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10667', '1450', '6', '7.00', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10668', '1451', '6', '7.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10669', '1451', '6', '6.70', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10670', '1453', '6', '7.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10671', '1453', '6', '6.90', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10672', '1455', '6', '6.80', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10673', '1455', '6', '7.00', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10674', '1456', '6', '6.40', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10675', '1456', '6', '6.80', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10676', '1457', '6', '7.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10677', '1457', '6', '6.90', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10678', '1843', '6', '6.10', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10679', '1843', '6', '6.30', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10680', '1458', '6', '7.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10681', '1458', '6', '6.90', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10682', '1459', '6', '7.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10683', '1459', '6', '6.70', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10684', '1842', '6', '7.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10685', '1842', '6', '6.00', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10686', '1460', '6', '6.10', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10687', '1460', '6', '6.70', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10688', '1461', '6', '6.80', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10689', '1461', '6', '6.90', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10690', '1462', '6', '5.80', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10691', '1462', '6', '6.00', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10692', '1463', '6', '5.10', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10693', '1463', '6', '6.20', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10694', '1464', '6', '7.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10695', '1464', '6', '6.90', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10696', '1465', '6', '6.40', '2025-07-13', '1', '1');
INSERT INTO `notas` VALUES('10697', '1465', '6', '7.00', '2025-07-13', '1', '2');
INSERT INTO `notas` VALUES('10698', '1465', '6', '6.40', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10699', '1465', '6', '6.80', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10700', '1988', '6', '7.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10701', '1988', '6', '7.00', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10702', '1467', '6', '6.80', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10703', '1467', '6', '6.80', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10704', '1448', '7', '7.00', '2025-07-13', '1', '2');
INSERT INTO `notas` VALUES('10705', '1448', '7', '7.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10706', '1448', '7', '6.30', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10707', '1449', '7', '7.00', '2025-07-13', '1', '2');
INSERT INTO `notas` VALUES('10708', '1449', '7', '7.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10709', '1449', '7', '5.80', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10710', '1825', '7', '5.10', '2025-07-13', '1', '1');
INSERT INTO `notas` VALUES('10711', '1825', '7', '7.00', '2025-07-13', '1', '2');
INSERT INTO `notas` VALUES('10712', '1825', '7', '7.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10713', '1825', '7', '6.90', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10714', '1450', '7', '7.00', '2025-07-13', '1', '2');
INSERT INTO `notas` VALUES('10715', '1450', '7', '7.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10716', '1450', '7', '7.00', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10717', '1451', '7', '7.00', '2025-07-13', '1', '2');
INSERT INTO `notas` VALUES('10718', '1451', '7', '7.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10719', '1451', '7', '7.00', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10720', '1453', '7', '7.00', '2025-07-13', '1', '2');
INSERT INTO `notas` VALUES('10721', '1453', '7', '7.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10722', '1453', '7', '6.90', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10723', '1455', '7', '6.30', '2025-07-13', '1', '1');
INSERT INTO `notas` VALUES('10724', '1455', '7', '7.00', '2025-07-13', '1', '2');
INSERT INTO `notas` VALUES('10725', '1455', '7', '6.80', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10726', '1455', '7', '7.00', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10727', '1456', '7', '7.00', '2025-07-13', '1', '2');
INSERT INTO `notas` VALUES('10728', '1456', '7', '7.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10729', '1456', '7', '6.80', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10730', '1457', '7', '7.00', '2025-07-13', '1', '2');
INSERT INTO `notas` VALUES('10731', '1457', '7', '7.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10732', '1457', '7', '6.90', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10733', '1843', '7', '7.00', '2025-07-13', '1', '2');
INSERT INTO `notas` VALUES('10734', '1843', '7', '6.30', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10735', '1843', '7', '6.30', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10736', '1458', '7', '7.00', '2025-07-13', '1', '2');
INSERT INTO `notas` VALUES('10737', '1458', '7', '6.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10738', '1458', '7', '6.90', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10739', '1459', '7', '7.00', '2025-07-13', '1', '2');
INSERT INTO `notas` VALUES('10740', '1459', '7', '6.40', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10741', '1459', '7', '6.70', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10742', '1842', '7', '7.00', '2025-07-13', '1', '2');
INSERT INTO `notas` VALUES('10743', '1842', '7', '6.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10744', '1842', '7', '6.00', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10745', '1460', '7', '7.00', '2025-07-13', '1', '2');
INSERT INTO `notas` VALUES('10746', '1460', '7', '6.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10747', '1460', '7', '6.70', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10748', '1461', '7', '7.00', '2025-07-13', '1', '2');
INSERT INTO `notas` VALUES('10749', '1461', '7', '7.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10750', '1461', '7', '6.90', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10751', '1462', '7', '7.00', '2025-07-13', '1', '2');
INSERT INTO `notas` VALUES('10752', '1462', '7', '6.60', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10753', '1462', '7', '6.00', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10754', '1463', '7', '7.00', '2025-07-13', '1', '1');
INSERT INTO `notas` VALUES('10755', '1463', '7', '7.00', '2025-07-13', '1', '2');
INSERT INTO `notas` VALUES('10756', '1463', '7', '7.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10757', '1463', '7', '6.20', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10758', '1464', '7', '7.00', '2025-07-13', '1', '2');
INSERT INTO `notas` VALUES('10759', '1464', '7', '6.60', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10760', '1464', '7', '6.90', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10761', '1465', '7', '6.10', '2025-07-13', '1', '1');
INSERT INTO `notas` VALUES('10762', '1465', '7', '7.00', '2025-07-13', '1', '2');
INSERT INTO `notas` VALUES('10763', '1465', '7', '6.60', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10764', '1465', '7', '6.80', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10765', '1988', '7', '7.00', '2025-07-13', '1', '2');
INSERT INTO `notas` VALUES('10766', '1988', '7', '7.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10767', '1988', '7', '7.00', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10768', '1467', '7', '7.00', '2025-07-13', '1', '2');
INSERT INTO `notas` VALUES('10769', '1467', '7', '7.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10770', '1467', '7', '6.80', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10771', '1948', '8', '5.90', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10772', '1948', '8', '6.00', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10773', '1949', '8', '5.90', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10774', '1949', '8', '5.60', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10775', '1950', '8', '5.80', '2025-07-13', '1', '1');
INSERT INTO `notas` VALUES('10776', '1950', '8', '5.20', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10777', '1950', '8', '5.80', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10778', '1951', '8', '5.50', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10779', '1951', '8', '6.00', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10780', '1952', '8', '5.20', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10781', '1952', '8', '5.30', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10782', '1953', '8', '7.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10783', '1953', '8', '6.70', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10784', '1954', '8', '7.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10785', '1954', '8', '6.00', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10786', '1956', '8', '5.50', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10787', '1956', '8', '5.00', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10788', '1957', '8', '5.20', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10789', '1957', '8', '4.80', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10790', '1958', '8', '7.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10791', '1958', '8', '7.00', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10792', '1959', '8', '5.50', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10793', '1959', '8', '5.80', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10794', '1960', '8', '5.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10795', '1960', '8', '6.70', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10796', '1961', '8', '6.10', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10797', '1961', '8', '5.00', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10798', '1962', '8', '6.20', '2025-07-13', '1', '2');
INSERT INTO `notas` VALUES('10799', '1962', '8', '6.40', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10800', '1962', '8', '6.70', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10801', '1963', '8', '6.60', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10802', '1963', '8', '6.70', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10803', '1964', '8', '5.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10804', '1964', '8', '5.80', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10805', '1965', '8', '5.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10806', '1965', '8', '5.50', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10807', '1966', '8', '5.90', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10808', '1966', '8', '6.00', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10809', '1967', '8', '4.30', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10810', '1967', '8', '4.90', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10811', '1968', '8', '7.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10812', '1968', '8', '6.10', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10813', '1969', '8', '5.90', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10814', '1969', '8', '5.80', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10815', '1970', '8', '6.20', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10816', '1970', '8', '5.90', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10817', '1971', '8', '4.60', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10818', '1971', '8', '5.00', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10819', '1972', '8', '5.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10820', '1972', '8', '6.00', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10821', '1973', '8', '7.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10822', '1973', '8', '6.30', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10823', '1975', '8', '6.10', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10824', '1975', '8', '5.50', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10825', '1976', '8', '7.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10826', '1976', '8', '6.90', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10827', '1977', '8', '6.40', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10828', '1977', '8', '6.80', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10829', '1978', '8', '6.10', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10830', '1978', '8', '6.50', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10831', '1979', '8', '5.20', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10832', '1979', '8', '5.00', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10833', '1980', '8', '7.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10834', '1980', '8', '5.90', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10835', '1981', '8', '5.90', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10836', '1981', '8', '6.20', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10837', '1982', '8', '5.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10838', '1982', '8', '6.00', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10839', '1983', '8', '5.50', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10840', '1983', '8', '5.00', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10841', '1984', '8', '6.10', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10842', '1984', '8', '6.00', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10843', '1985', '8', '6.10', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10844', '1985', '8', '5.60', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10845', '1986', '8', '5.10', '2025-07-13', '1', '2');
INSERT INTO `notas` VALUES('10846', '1986', '8', '4.10', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10847', '1986', '8', '5.00', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10848', '1987', '8', '7.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10849', '1987', '8', '7.00', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10850', '1448', '12', '7.00', '2025-07-13', '1', '2');
INSERT INTO `notas` VALUES('10851', '1448', '12', '6.30', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10852', '1449', '12', '7.00', '2025-07-13', '1', '2');
INSERT INTO `notas` VALUES('10853', '1449', '12', '5.80', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10854', '1825', '12', '7.00', '2025-07-13', '1', '2');
INSERT INTO `notas` VALUES('10855', '1825', '12', '6.90', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10856', '1450', '12', '7.00', '2025-07-13', '1', '2');
INSERT INTO `notas` VALUES('10857', '1450', '12', '7.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10858', '1451', '12', '7.00', '2025-07-13', '1', '2');
INSERT INTO `notas` VALUES('10859', '1451', '12', '6.70', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10860', '1453', '12', '7.00', '2025-07-13', '1', '2');
INSERT INTO `notas` VALUES('10861', '1453', '12', '6.90', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10862', '1455', '12', '7.00', '2025-07-13', '1', '2');
INSERT INTO `notas` VALUES('10863', '1455', '12', '7.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10864', '1456', '12', '7.00', '2025-07-13', '1', '2');
INSERT INTO `notas` VALUES('10865', '1456', '12', '6.80', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10866', '1457', '12', '7.00', '2025-07-13', '1', '2');
INSERT INTO `notas` VALUES('10867', '1457', '12', '6.90', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10868', '1843', '12', '7.00', '2025-07-13', '1', '2');
INSERT INTO `notas` VALUES('10869', '1843', '12', '6.30', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10870', '1458', '12', '7.00', '2025-07-13', '1', '2');
INSERT INTO `notas` VALUES('10871', '1458', '12', '6.90', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10872', '1459', '12', '7.00', '2025-07-13', '1', '2');
INSERT INTO `notas` VALUES('10873', '1459', '12', '6.70', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10874', '1842', '12', '7.00', '2025-07-13', '1', '2');
INSERT INTO `notas` VALUES('10875', '1842', '12', '6.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10876', '1460', '12', '7.00', '2025-07-13', '1', '2');
INSERT INTO `notas` VALUES('10877', '1460', '12', '6.70', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10878', '1461', '12', '7.00', '2025-07-13', '1', '2');
INSERT INTO `notas` VALUES('10879', '1461', '12', '6.90', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10880', '1462', '12', '7.00', '2025-07-13', '1', '2');
INSERT INTO `notas` VALUES('10881', '1462', '12', '6.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10882', '1463', '12', '7.00', '2025-07-13', '1', '2');
INSERT INTO `notas` VALUES('10883', '1463', '12', '6.20', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10884', '1464', '12', '7.00', '2025-07-13', '1', '2');
INSERT INTO `notas` VALUES('10885', '1464', '12', '6.90', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10886', '1465', '12', '6.00', '2025-07-13', '1', '1');
INSERT INTO `notas` VALUES('10887', '1465', '12', '7.00', '2025-07-13', '1', '2');
INSERT INTO `notas` VALUES('10888', '1465', '12', '6.80', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10889', '1988', '12', '7.00', '2025-07-13', '1', '2');
INSERT INTO `notas` VALUES('10890', '1988', '12', '7.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10891', '1467', '12', '7.00', '2025-07-13', '1', '2');
INSERT INTO `notas` VALUES('10892', '1467', '12', '6.80', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10893', '1448', '4', '6.30', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10894', '1449', '4', '5.80', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10895', '1825', '4', '6.90', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10896', '1450', '4', '7.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10897', '1451', '4', '6.70', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10898', '1453', '4', '6.90', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10899', '1455', '4', '7.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10900', '1456', '4', '6.80', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10901', '1457', '4', '6.90', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10902', '1843', '4', '6.50', '2025-07-13', '1', '1');
INSERT INTO `notas` VALUES('10903', '1843', '4', '6.30', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10904', '1458', '4', '6.90', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10905', '1459', '4', '6.70', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10906', '1842', '4', '6.50', '2025-07-13', '1', '1');
INSERT INTO `notas` VALUES('10907', '1842', '4', '6.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10908', '1460', '4', '6.70', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10909', '1461', '4', '6.90', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10910', '1462', '4', '6.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10911', '1463', '4', '6.20', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10912', '1464', '4', '6.90', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10913', '1465', '4', '6.30', '2025-07-13', '1', '1');
INSERT INTO `notas` VALUES('10914', '1465', '4', '7.00', '2025-07-13', '1', '2');
INSERT INTO `notas` VALUES('10915', '1465', '4', '6.80', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10916', '1988', '4', '7.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10917', '1467', '4', '6.80', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10918', '1844', '2', '6.60', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10919', '1844', '2', '6.60', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10920', '1844', '2', '7.00', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10921', '1844', '2', '7.00', '2025-07-13', '1', '6');
INSERT INTO `notas` VALUES('10922', '1845', '2', '4.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10923', '1845', '2', '3.40', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10924', '1845', '2', '4.20', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10925', '1845', '2', '4.00', '2025-07-13', '1', '6');
INSERT INTO `notas` VALUES('10926', '1846', '2', '4.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10927', '1846', '2', '3.60', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10928', '1846', '2', '3.10', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10929', '1846', '2', '5.10', '2025-07-13', '1', '6');
INSERT INTO `notas` VALUES('10930', '1847', '2', '4.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10931', '1847', '2', '4.20', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10932', '1847', '2', '4.90', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10933', '1847', '2', '4.40', '2025-07-13', '1', '6');
INSERT INTO `notas` VALUES('10934', '1848', '2', '6.60', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10935', '1848', '2', '6.60', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10936', '1848', '2', '6.20', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10937', '1848', '2', '6.70', '2025-07-13', '1', '6');
INSERT INTO `notas` VALUES('10938', '1849', '2', '7.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10939', '1849', '2', '7.00', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10940', '1849', '2', '7.00', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10941', '1849', '2', '7.00', '2025-07-13', '1', '6');
INSERT INTO `notas` VALUES('10942', '1850', '2', '6.80', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10943', '1850', '2', '7.00', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10944', '1850', '2', '7.00', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10945', '1850', '2', '6.40', '2025-07-13', '1', '6');
INSERT INTO `notas` VALUES('10946', '1851', '2', '6.80', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10947', '1851', '2', '6.60', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10948', '1851', '2', '6.90', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10949', '1851', '2', '6.70', '2025-07-13', '1', '6');
INSERT INTO `notas` VALUES('10950', '1852', '2', '6.60', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10951', '1852', '2', '6.50', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10952', '1852', '2', '7.00', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10953', '1852', '2', '6.00', '2025-07-13', '1', '6');
INSERT INTO `notas` VALUES('10954', '1853', '2', '3.50', '2025-07-13', '1', '1');
INSERT INTO `notas` VALUES('10955', '1853', '2', '4.50', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10956', '1853', '2', '4.00', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10957', '1853', '2', '5.10', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10958', '1853', '2', '4.00', '2025-07-13', '1', '6');
INSERT INTO `notas` VALUES('10959', '1854', '2', '6.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10960', '1854', '2', '5.40', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10961', '1854', '2', '5.60', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10962', '1854', '2', '5.20', '2025-07-13', '1', '6');
INSERT INTO `notas` VALUES('10963', '1855', '2', '6.60', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10964', '1855', '2', '6.50', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10965', '1855', '2', '6.60', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10966', '1855', '2', '7.00', '2025-07-13', '1', '6');
INSERT INTO `notas` VALUES('10967', '1856', '2', '6.50', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10968', '1856', '2', '6.00', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10969', '1856', '2', '7.00', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10970', '1856', '2', '7.00', '2025-07-13', '1', '6');
INSERT INTO `notas` VALUES('10971', '1857', '2', '6.20', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10972', '1857', '2', '6.10', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10973', '1857', '2', '6.60', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10974', '1857', '2', '6.60', '2025-07-13', '1', '6');
INSERT INTO `notas` VALUES('10975', '1858', '2', '6.80', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10976', '1858', '2', '6.60', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10977', '1858', '2', '6.60', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10978', '1858', '2', '6.40', '2025-07-13', '1', '6');
INSERT INTO `notas` VALUES('10979', '1859', '2', '6.10', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10980', '1859', '2', '6.00', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10981', '1859', '2', '6.80', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10982', '1859', '2', '6.00', '2025-07-13', '1', '6');
INSERT INTO `notas` VALUES('10983', '1860', '2', '3.60', '2025-07-13', '1', '1');
INSERT INTO `notas` VALUES('10984', '1860', '2', '6.40', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10985', '1860', '2', '6.40', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10986', '1860', '2', '7.00', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10987', '1860', '2', '4.20', '2025-07-13', '1', '6');
INSERT INTO `notas` VALUES('10988', '1861', '2', '6.20', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10989', '1861', '2', '6.60', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10990', '1861', '2', '7.00', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10991', '1861', '2', '6.10', '2025-07-13', '1', '6');
INSERT INTO `notas` VALUES('10992', '1862', '2', '7.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10993', '1862', '2', '6.40', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10994', '1862', '2', '7.00', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10995', '1862', '2', '7.00', '2025-07-13', '1', '6');
INSERT INTO `notas` VALUES('10996', '1863', '2', '4.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('10997', '1863', '2', '4.10', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('10998', '1863', '2', '3.30', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('10999', '1863', '2', '5.70', '2025-07-13', '1', '6');
INSERT INTO `notas` VALUES('11000', '1877', '2', '5.00', '2025-07-13', '1', '1');
INSERT INTO `notas` VALUES('11001', '1877', '2', '5.10', '2025-07-13', '1', '2');
INSERT INTO `notas` VALUES('11002', '1877', '2', '5.40', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('11003', '1877', '2', '6.20', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('11004', '1877', '2', '5.30', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('11005', '1877', '2', '5.40', '2025-07-13', '1', '6');
INSERT INTO `notas` VALUES('11006', '1864', '2', '3.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('11007', '1864', '2', '4.40', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('11008', '1864', '2', '6.70', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('11009', '1864', '2', '4.00', '2025-07-13', '1', '6');
INSERT INTO `notas` VALUES('11010', '1865', '2', '6.60', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('11011', '1865', '2', '6.60', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('11012', '1865', '2', '7.00', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('11013', '1865', '2', '6.40', '2025-07-13', '1', '6');
INSERT INTO `notas` VALUES('11014', '1866', '2', '3.60', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('11015', '1866', '2', '4.00', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('11016', '1866', '2', '2.50', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('11017', '1866', '2', '4.00', '2025-07-13', '1', '6');
INSERT INTO `notas` VALUES('11018', '1867', '2', '7.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('11019', '1867', '2', '7.00', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('11020', '1867', '2', '7.00', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('11021', '1867', '2', '7.00', '2025-07-13', '1', '6');
INSERT INTO `notas` VALUES('11022', '1868', '2', '6.60', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('11023', '1868', '2', '6.40', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('11024', '1868', '2', '6.60', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('11025', '1868', '2', '7.00', '2025-07-13', '1', '6');
INSERT INTO `notas` VALUES('11026', '1869', '2', '6.00', '2025-07-13', '1', '1');
INSERT INTO `notas` VALUES('11027', '1869', '2', '6.60', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('11028', '1869', '2', '6.40', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('11029', '1869', '2', '6.60', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('11030', '1869', '2', '6.00', '2025-07-13', '1', '6');
INSERT INTO `notas` VALUES('11031', '1870', '2', '4.50', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('11032', '1870', '2', '3.40', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('11033', '1870', '2', '2.60', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('11034', '1870', '2', '5.10', '2025-07-13', '1', '6');
INSERT INTO `notas` VALUES('11035', '1871', '2', '7.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('11036', '1871', '2', '7.00', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('11037', '1871', '2', '7.00', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('11038', '1871', '2', '7.00', '2025-07-13', '1', '6');
INSERT INTO `notas` VALUES('11039', '1873', '2', '7.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('11040', '1873', '2', '6.60', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('11041', '1873', '2', '7.00', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('11042', '1873', '2', '7.00', '2025-07-13', '1', '6');
INSERT INTO `notas` VALUES('11043', '1874', '2', '6.60', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('11044', '1874', '2', '6.60', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('11045', '1874', '2', '7.00', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('11046', '1874', '2', '6.40', '2025-07-13', '1', '6');
INSERT INTO `notas` VALUES('11047', '1875', '2', '3.60', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('11048', '1875', '2', '4.20', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('11049', '1875', '2', '2.60', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('11050', '1875', '2', '4.00', '2025-07-13', '1', '6');
INSERT INTO `notas` VALUES('11051', '1876', '2', '7.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('11052', '1876', '2', '6.60', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('11053', '1876', '2', '7.00', '2025-07-13', '1', '5');
INSERT INTO `notas` VALUES('11054', '1876', '2', '7.00', '2025-07-13', '1', '6');
INSERT INTO `notas` VALUES('11055', '1844', '3', '7.00', '2025-07-13', '1', '2');
INSERT INTO `notas` VALUES('11056', '1844', '3', '7.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('11057', '1844', '3', '6.90', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('11058', '1845', '3', '7.00', '2025-07-13', '1', '2');
INSERT INTO `notas` VALUES('11059', '1845', '3', '4.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('11060', '1845', '3', '4.50', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('11061', '1846', '3', '7.00', '2025-07-13', '1', '2');
INSERT INTO `notas` VALUES('11062', '1846', '3', '4.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('11063', '1846', '3', '5.00', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('11064', '1847', '3', '7.00', '2025-07-13', '1', '2');
INSERT INTO `notas` VALUES('11065', '1847', '3', '4.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('11066', '1847', '3', '5.80', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('11067', '1848', '3', '7.00', '2025-07-13', '1', '2');
INSERT INTO `notas` VALUES('11068', '1848', '3', '7.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('11069', '1848', '3', '6.80', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('11070', '1849', '3', '7.00', '2025-07-13', '1', '2');
INSERT INTO `notas` VALUES('11071', '1849', '3', '7.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('11072', '1849', '3', '6.80', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('11073', '1850', '3', '7.00', '2025-07-13', '1', '2');
INSERT INTO `notas` VALUES('11074', '1850', '3', '6.80', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('11075', '1850', '3', '5.60', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('11076', '1851', '3', '7.00', '2025-07-13', '1', '2');
INSERT INTO `notas` VALUES('11077', '1851', '3', '5.80', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('11078', '1851', '3', '5.90', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('11079', '1852', '3', '7.00', '2025-07-13', '1', '2');
INSERT INTO `notas` VALUES('11080', '1852', '3', '4.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('11081', '1852', '3', '5.60', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('11082', '1853', '3', '7.00', '2025-07-13', '1', '2');
INSERT INTO `notas` VALUES('11083', '1853', '3', '4.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('11084', '1853', '3', '5.80', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('11085', '1854', '3', '7.00', '2025-07-13', '1', '2');
INSERT INTO `notas` VALUES('11086', '1854', '3', '4.50', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('11087', '1854', '3', '7.00', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('11088', '1855', '3', '7.00', '2025-07-13', '1', '2');
INSERT INTO `notas` VALUES('11089', '1855', '3', '5.70', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('11090', '1855', '3', '6.80', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('11091', '1856', '3', '7.00', '2025-07-13', '1', '2');
INSERT INTO `notas` VALUES('11092', '1856', '3', '5.50', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('11093', '1856', '3', '6.40', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('11094', '1857', '3', '7.00', '2025-07-13', '1', '2');
INSERT INTO `notas` VALUES('11095', '1857', '3', '4.50', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('11096', '1857', '3', '6.40', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('11097', '1858', '3', '7.00', '2025-07-13', '1', '2');
INSERT INTO `notas` VALUES('11098', '1858', '3', '6.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('11099', '1858', '3', '6.50', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('11100', '1859', '3', '7.00', '2025-07-13', '1', '2');
INSERT INTO `notas` VALUES('11101', '1859', '3', '4.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('11102', '1859', '3', '5.90', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('11103', '1860', '3', '7.00', '2025-07-13', '1', '2');
INSERT INTO `notas` VALUES('11104', '1860', '3', '6.90', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('11105', '1860', '3', '5.40', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('11106', '1861', '3', '7.00', '2025-07-13', '1', '2');
INSERT INTO `notas` VALUES('11107', '1861', '3', '4.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('11108', '1861', '3', '5.80', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('11109', '1862', '3', '7.00', '2025-07-13', '1', '2');
INSERT INTO `notas` VALUES('11110', '1862', '3', '6.40', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('11111', '1862', '3', '6.60', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('11112', '1863', '3', '7.00', '2025-07-13', '1', '2');
INSERT INTO `notas` VALUES('11113', '1863', '3', '4.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('11114', '1863', '3', '6.60', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('11115', '1877', '3', '5.40', '2025-07-13', '1', '1');
INSERT INTO `notas` VALUES('11116', '1877', '3', '5.30', '2025-07-13', '1', '2');
INSERT INTO `notas` VALUES('11117', '1877', '3', '5.20', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('11118', '1877', '3', '6.10', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('11119', '1864', '3', '7.00', '2025-07-13', '1', '2');
INSERT INTO `notas` VALUES('11120', '1864', '3', '6.50', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('11121', '1864', '3', '6.20', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('11122', '1865', '3', '7.00', '2025-07-13', '1', '2');
INSERT INTO `notas` VALUES('11123', '1865', '3', '6.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('11124', '1865', '3', '5.70', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('11125', '1866', '3', '7.00', '2025-07-13', '1', '2');
INSERT INTO `notas` VALUES('11126', '1866', '3', '4.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('11127', '1866', '3', '5.50', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('11128', '1867', '3', '7.00', '2025-07-13', '1', '2');
INSERT INTO `notas` VALUES('11129', '1867', '3', '5.70', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('11130', '1867', '3', '6.60', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('11131', '1868', '3', '7.00', '2025-07-13', '1', '2');
INSERT INTO `notas` VALUES('11132', '1868', '3', '7.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('11133', '1868', '3', '6.50', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('11134', '1869', '3', '7.00', '2025-07-13', '1', '2');
INSERT INTO `notas` VALUES('11135', '1869', '3', '5.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('11136', '1869', '3', '6.10', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('11137', '1870', '3', '7.00', '2025-07-13', '1', '2');
INSERT INTO `notas` VALUES('11138', '1870', '3', '4.50', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('11139', '1870', '3', '6.20', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('11140', '1871', '3', '7.00', '2025-07-13', '1', '2');
INSERT INTO `notas` VALUES('11141', '1871', '3', '7.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('11142', '1871', '3', '6.30', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('11143', '1873', '3', '7.00', '2025-07-13', '1', '2');
INSERT INTO `notas` VALUES('11144', '1873', '3', '6.70', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('11145', '1873', '3', '6.30', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('11146', '1874', '3', '7.00', '2025-07-13', '1', '2');
INSERT INTO `notas` VALUES('11147', '1874', '3', '4.30', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('11148', '1874', '3', '6.50', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('11149', '1875', '3', '7.00', '2025-07-13', '1', '2');
INSERT INTO `notas` VALUES('11150', '1875', '3', '4.50', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('11151', '1875', '3', '5.60', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('11152', '1876', '3', '7.00', '2025-07-13', '1', '2');
INSERT INTO `notas` VALUES('11153', '1876', '3', '7.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('11154', '1876', '3', '6.60', '2025-07-13', '1', '4');
INSERT INTO `notas` VALUES('11155', '1844', '12', '7.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('11156', '1845', '12', '6.50', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('11157', '1846', '12', '7.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('11158', '1847', '12', '6.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('11159', '1848', '12', '7.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('11160', '1849', '12', '7.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('11161', '1850', '12', '6.60', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('11162', '1851', '12', '7.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('11163', '1852', '12', '7.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('11164', '1853', '12', '7.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('11165', '1854', '12', '7.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('11166', '1855', '12', '7.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('11167', '1856', '12', '7.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('11168', '1857', '12', '7.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('11169', '1858', '12', '7.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('11170', '1859', '12', '6.40', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('11171', '1860', '12', '6.40', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('11172', '1861', '12', '7.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('11173', '1862', '12', '7.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('11174', '1863', '12', '6.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('11175', '1877', '12', '6.00', '2025-07-13', '1', '1');
INSERT INTO `notas` VALUES('11176', '1877', '12', '6.10', '2025-07-13', '1', '2');
INSERT INTO `notas` VALUES('11177', '1877', '12', '7.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('11178', '1864', '12', '5.40', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('11179', '1865', '12', '7.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('11180', '1866', '12', '6.50', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('11181', '1867', '12', '7.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('11182', '1868', '12', '7.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('11183', '1869', '12', '7.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('11184', '1870', '12', '5.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('11185', '1871', '12', '7.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('11186', '1873', '12', '7.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('11187', '1874', '12', '7.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('11188', '1875', '12', '7.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('11189', '1876', '12', '7.00', '2025-07-13', '1', '3');
INSERT INTO `notas` VALUES('11190', '1922', '7', '6.80', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11191', '1923', '7', '4.90', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11192', '1924', '7', '4.70', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11193', '1925', '7', '5.60', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11194', '1926', '7', '6.40', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11195', '1927', '7', '5.70', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11196', '1928', '7', '5.80', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11197', '1929', '7', '5.10', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11198', '1930', '7', '5.40', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11199', '1931', '7', '5.60', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11200', '1932', '7', '5.00', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11201', '1933', '7', '6.60', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11202', '1947', '7', '4.80', '2025-07-14', '1', '1');
INSERT INTO `notas` VALUES('11203', '1947', '7', '5.50', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11204', '1934', '7', '6.50', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11205', '1935', '7', '6.90', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11206', '1936', '7', '5.60', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11207', '1937', '7', '6.40', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11208', '1938', '7', '5.40', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11209', '1939', '7', '4.60', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11210', '1940', '7', '5.30', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11211', '1941', '7', '6.90', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11212', '1942', '7', '5.70', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11213', '1943', '7', '5.10', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11214', '1944', '7', '5.20', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11215', '1945', '7', '6.90', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11216', '1946', '7', '6.70', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11217', '1947', '4', '6.00', '2025-07-14', '1', '1');
INSERT INTO `notas` VALUES('11218', '1947', '12', '6.00', '2025-07-14', '1', '1');
INSERT INTO `notas` VALUES('11219', '1585', '6', '5.60', '2025-07-14', '1', '1');
INSERT INTO `notas` VALUES('11220', '1585', '6', '5.30', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11221', '1585', '6', '5.60', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11222', '1586', '6', '6.00', '2025-07-14', '1', '1');
INSERT INTO `notas` VALUES('11223', '1586', '6', '6.10', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11224', '1587', '6', '4.00', '2025-07-14', '1', '1');
INSERT INTO `notas` VALUES('11225', '1587', '6', '6.00', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11226', '1588', '6', '7.00', '2025-07-14', '1', '1');
INSERT INTO `notas` VALUES('11227', '1588', '6', '6.20', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11228', '1589', '6', '5.00', '2025-07-14', '1', '1');
INSERT INTO `notas` VALUES('11229', '1589', '6', '4.70', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11230', '1590', '6', '4.50', '2025-07-14', '1', '1');
INSERT INTO `notas` VALUES('11231', '1590', '6', '6.20', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11232', '1591', '6', '4.80', '2025-07-14', '1', '1');
INSERT INTO `notas` VALUES('11233', '1591', '6', '5.40', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11234', '1591', '6', '5.00', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11235', '1592', '6', '6.50', '2025-07-14', '1', '1');
INSERT INTO `notas` VALUES('11236', '1592', '6', '5.90', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11237', '1593', '6', '5.50', '2025-07-14', '1', '1');
INSERT INTO `notas` VALUES('11238', '1593', '6', '6.20', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11239', '1594', '6', '5.50', '2025-07-14', '1', '1');
INSERT INTO `notas` VALUES('11240', '1594', '6', '6.30', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11241', '1595', '6', '6.10', '2025-07-14', '1', '1');
INSERT INTO `notas` VALUES('11242', '1595', '6', '6.40', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11243', '1596', '6', '4.50', '2025-07-14', '1', '1');
INSERT INTO `notas` VALUES('11244', '1596', '6', '6.20', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11245', '1597', '6', '5.50', '2025-07-14', '1', '1');
INSERT INTO `notas` VALUES('11246', '1597', '6', '5.90', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11247', '1598', '6', '5.50', '2025-07-14', '1', '1');
INSERT INTO `notas` VALUES('11248', '1598', '6', '5.90', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11249', '1599', '6', '6.50', '2025-07-14', '1', '1');
INSERT INTO `notas` VALUES('11250', '1599', '6', '5.00', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11251', '1600', '6', '6.50', '2025-07-14', '1', '1');
INSERT INTO `notas` VALUES('11252', '1600', '6', '6.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11253', '1600', '6', '6.20', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11254', '1601', '6', '4.50', '2025-07-14', '1', '1');
INSERT INTO `notas` VALUES('11255', '1601', '6', '6.10', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11256', '1602', '6', '6.30', '2025-07-14', '1', '1');
INSERT INTO `notas` VALUES('11257', '1602', '6', '6.70', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11258', '1603', '6', '6.20', '2025-07-14', '1', '1');
INSERT INTO `notas` VALUES('11259', '1603', '6', '6.00', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11260', '1604', '6', '4.80', '2025-07-14', '1', '1');
INSERT INTO `notas` VALUES('11261', '1604', '6', '4.70', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11262', '1605', '6', '5.80', '2025-07-14', '1', '1');
INSERT INTO `notas` VALUES('11263', '1605', '6', '6.30', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11264', '1606', '6', '5.50', '2025-07-14', '1', '1');
INSERT INTO `notas` VALUES('11265', '1606', '6', '4.90', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11266', '1606', '6', '4.40', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11267', '1607', '6', '7.00', '2025-07-14', '1', '1');
INSERT INTO `notas` VALUES('11268', '1607', '6', '5.60', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11269', '1608', '6', '6.20', '2025-07-14', '1', '1');
INSERT INTO `notas` VALUES('11270', '1608', '6', '4.40', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11271', '1608', '6', '5.80', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11272', '1609', '6', '6.30', '2025-07-14', '1', '1');
INSERT INTO `notas` VALUES('11273', '1609', '6', '6.50', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11274', '1922', '2', '7.00', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11275', '1922', '2', '7.00', '2025-07-14', '1', '5');
INSERT INTO `notas` VALUES('11276', '1922', '2', '6.80', '2025-07-14', '1', '6');
INSERT INTO `notas` VALUES('11277', '1923', '2', '6.70', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11278', '1923', '2', '6.00', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11279', '1923', '2', '4.50', '2025-07-14', '1', '5');
INSERT INTO `notas` VALUES('11280', '1923', '2', '4.90', '2025-07-14', '1', '6');
INSERT INTO `notas` VALUES('11281', '1924', '2', '2.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11282', '1924', '2', '5.60', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11283', '1924', '2', '2.00', '2025-07-14', '1', '5');
INSERT INTO `notas` VALUES('11284', '1924', '2', '4.70', '2025-07-14', '1', '6');
INSERT INTO `notas` VALUES('11285', '1925', '2', '6.30', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11286', '1925', '2', '4.10', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11287', '1925', '2', '3.00', '2025-07-14', '1', '5');
INSERT INTO `notas` VALUES('11288', '1925', '2', '5.60', '2025-07-14', '1', '6');
INSERT INTO `notas` VALUES('11289', '1926', '2', '7.00', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11290', '1926', '2', '5.70', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11291', '1926', '2', '4.30', '2025-07-14', '1', '5');
INSERT INTO `notas` VALUES('11292', '1926', '2', '6.40', '2025-07-14', '1', '6');
INSERT INTO `notas` VALUES('11293', '1927', '2', '2.00', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11294', '1927', '2', '5.90', '2025-07-14', '1', '5');
INSERT INTO `notas` VALUES('11295', '1927', '2', '5.70', '2025-07-14', '1', '6');
INSERT INTO `notas` VALUES('11296', '1928', '2', '7.00', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11297', '1928', '2', '5.50', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11298', '1928', '2', '7.00', '2025-07-14', '1', '5');
INSERT INTO `notas` VALUES('11299', '1928', '2', '5.80', '2025-07-14', '1', '6');
INSERT INTO `notas` VALUES('11300', '1929', '2', '4.10', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11301', '1929', '2', '4.30', '2025-07-14', '1', '5');
INSERT INTO `notas` VALUES('11302', '1929', '2', '5.10', '2025-07-14', '1', '6');
INSERT INTO `notas` VALUES('11303', '1930', '2', '5.70', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11304', '1930', '2', '3.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11305', '1930', '2', '3.10', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11306', '1930', '2', '2.30', '2025-07-14', '1', '5');
INSERT INTO `notas` VALUES('11307', '1930', '2', '5.90', '2025-07-14', '1', '6');
INSERT INTO `notas` VALUES('11308', '1931', '2', '4.10', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11309', '1931', '2', '3.00', '2025-07-14', '1', '5');
INSERT INTO `notas` VALUES('11310', '1931', '2', '5.60', '2025-07-14', '1', '6');
INSERT INTO `notas` VALUES('11311', '1932', '2', '3.30', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11312', '1932', '2', '2.30', '2025-07-14', '1', '5');
INSERT INTO `notas` VALUES('11313', '1932', '2', '4.90', '2025-07-14', '1', '6');
INSERT INTO `notas` VALUES('11314', '1933', '2', '6.20', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11315', '1933', '2', '6.50', '2025-07-14', '1', '5');
INSERT INTO `notas` VALUES('11316', '1933', '2', '6.60', '2025-07-14', '1', '6');
INSERT INTO `notas` VALUES('11317', '1947', '2', '4.70', '2025-07-14', '1', '1');
INSERT INTO `notas` VALUES('11318', '1947', '2', '6.30', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11319', '1947', '2', '4.00', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11320', '1947', '2', '2.00', '2025-07-14', '1', '5');
INSERT INTO `notas` VALUES('11321', '1947', '2', '5.50', '2025-07-14', '1', '6');
INSERT INTO `notas` VALUES('11322', '1934', '2', '7.00', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11323', '1934', '2', '7.00', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11324', '1934', '2', '7.00', '2025-07-14', '1', '5');
INSERT INTO `notas` VALUES('11325', '1934', '2', '6.50', '2025-07-14', '1', '6');
INSERT INTO `notas` VALUES('11326', '1935', '2', '6.60', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11327', '1935', '2', '7.00', '2025-07-14', '1', '5');
INSERT INTO `notas` VALUES('11328', '1935', '2', '6.90', '2025-07-14', '1', '6');
INSERT INTO `notas` VALUES('11329', '1936', '2', '5.40', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11330', '1936', '2', '6.50', '2025-07-14', '1', '5');
INSERT INTO `notas` VALUES('11331', '1936', '2', '5.60', '2025-07-14', '1', '6');
INSERT INTO `notas` VALUES('11332', '1937', '2', '7.00', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11333', '1937', '2', '5.80', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11334', '1937', '2', '6.20', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11335', '1937', '2', '7.00', '2025-07-14', '1', '5');
INSERT INTO `notas` VALUES('11336', '1937', '2', '6.40', '2025-07-14', '1', '6');
INSERT INTO `notas` VALUES('11337', '1938', '2', '3.60', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11338', '1938', '2', '2.00', '2025-07-14', '1', '5');
INSERT INTO `notas` VALUES('11339', '1938', '2', '5.40', '2025-07-14', '1', '6');
INSERT INTO `notas` VALUES('11340', '1939', '2', '5.80', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11341', '1939', '2', '2.00', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11342', '1939', '2', '2.00', '2025-07-14', '1', '5');
INSERT INTO `notas` VALUES('11343', '1939', '2', '4.60', '2025-07-14', '1', '6');
INSERT INTO `notas` VALUES('11344', '1940', '2', '7.00', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11345', '1940', '2', '2.30', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11346', '1940', '2', '2.00', '2025-07-14', '1', '5');
INSERT INTO `notas` VALUES('11347', '1940', '2', '5.30', '2025-07-14', '1', '6');
INSERT INTO `notas` VALUES('11348', '1941', '2', '6.00', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11349', '1941', '2', '5.40', '2025-07-14', '1', '5');
INSERT INTO `notas` VALUES('11350', '1941', '2', '6.90', '2025-07-14', '1', '6');
INSERT INTO `notas` VALUES('11351', '1942', '2', '7.00', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11352', '1942', '2', '3.60', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11353', '1942', '2', '5.40', '2025-07-14', '1', '5');
INSERT INTO `notas` VALUES('11354', '1942', '2', '5.70', '2025-07-14', '1', '6');
INSERT INTO `notas` VALUES('11355', '1943', '2', '4.30', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11356', '1943', '2', '6.50', '2025-07-14', '1', '5');
INSERT INTO `notas` VALUES('11357', '1943', '2', '5.10', '2025-07-14', '1', '6');
INSERT INTO `notas` VALUES('11358', '1944', '2', '4.30', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11359', '1944', '2', '5.70', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11360', '1944', '2', '2.00', '2025-07-14', '1', '5');
INSERT INTO `notas` VALUES('11361', '1944', '2', '5.20', '2025-07-14', '1', '6');
INSERT INTO `notas` VALUES('11362', '1945', '2', '4.70', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11363', '1945', '2', '6.50', '2025-07-14', '1', '5');
INSERT INTO `notas` VALUES('11364', '1945', '2', '6.90', '2025-07-14', '1', '6');
INSERT INTO `notas` VALUES('11365', '1946', '2', '4.70', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11366', '1946', '2', '7.00', '2025-07-14', '1', '5');
INSERT INTO `notas` VALUES('11367', '1946', '2', '6.70', '2025-07-14', '1', '6');
INSERT INTO `notas` VALUES('11368', '1922', '8', '6.90', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11369', '1923', '8', '5.00', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11370', '1924', '8', '4.50', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11371', '1925', '8', '5.90', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11372', '1926', '8', '6.20', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11373', '1927', '8', '5.30', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11374', '1928', '8', '4.60', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11375', '1929', '8', '5.30', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11376', '1930', '8', '5.50', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11377', '1931', '8', '5.10', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11378', '1932', '8', '5.40', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11379', '1933', '8', '6.50', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11380', '1947', '8', '6.40', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11381', '1947', '8', '5.90', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11382', '1934', '8', '6.90', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11383', '1935', '8', '6.70', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11384', '1936', '8', '5.60', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11385', '1937', '8', '6.00', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11386', '1938', '8', '5.40', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11387', '1939', '8', '5.00', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11388', '1940', '8', '5.50', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11389', '1941', '8', '6.10', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11390', '1942', '8', '5.60', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11391', '1943', '8', '5.90', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11392', '1944', '8', '5.20', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11393', '1945', '8', '6.40', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11394', '1946', '8', '6.00', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11395', '1692', '6', '6.00', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11396', '1692', '6', '7.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11397', '1692', '6', '6.30', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11398', '1693', '6', '7.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11399', '1693', '6', '6.10', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11400', '1694', '6', '6.50', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11401', '1694', '6', '7.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11402', '1694', '6', '6.40', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11403', '1695', '6', '7.00', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11404', '1695', '6', '7.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11405', '1695', '6', '6.60', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11406', '1696', '6', '7.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11407', '1697', '6', '5.80', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11408', '1697', '6', '7.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11409', '1697', '6', '4.70', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11410', '1698', '6', '6.10', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11411', '1698', '6', '7.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11412', '1698', '6', '4.40', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11413', '1699', '6', '7.00', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11414', '1699', '6', '7.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11415', '1699', '6', '6.40', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11416', '1700', '6', '7.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11417', '1700', '6', '6.70', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11418', '1701', '6', '7.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11419', '1701', '6', '5.80', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11420', '1702', '6', '6.50', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11421', '1702', '6', '7.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11422', '1702', '6', '6.10', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11423', '1703', '6', '7.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11424', '1703', '6', '6.40', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11425', '1704', '6', '7.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11426', '1704', '6', '6.40', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11427', '1705', '6', '5.50', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11428', '1705', '6', '7.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11429', '1705', '6', '4.70', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11430', '1706', '6', '5.00', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11431', '1706', '6', '7.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11432', '1706', '6', '4.40', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11433', '1707', '6', '7.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11434', '1707', '6', '4.90', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11435', '1708', '6', '7.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11436', '1708', '6', '4.80', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11437', '1709', '6', '7.00', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11438', '1709', '6', '7.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11439', '1709', '6', '5.40', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11440', '1710', '6', '6.00', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11441', '1710', '6', '7.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11442', '1710', '6', '5.10', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11443', '1711', '6', '7.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11444', '1711', '6', '4.60', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11445', '1712', '6', '6.60', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11446', '1712', '6', '7.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11447', '1712', '6', '5.90', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11448', '1692', '3', '6.00', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11449', '1692', '3', '7.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11450', '1692', '3', '5.60', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11451', '1693', '3', '7.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11452', '1693', '3', '5.70', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11453', '1694', '3', '7.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11454', '1694', '3', '5.40', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11455', '1695', '3', '7.00', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11456', '1695', '3', '7.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11457', '1695', '3', '7.00', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11458', '1697', '3', '7.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11459', '1697', '3', '5.30', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11460', '1698', '3', '4.00', '2025-07-14', '1', '1');
INSERT INTO `notas` VALUES('11461', '1698', '3', '4.00', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11462', '1698', '3', '4.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11463', '1698', '3', '5.30', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11464', '1699', '3', '7.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11465', '1699', '3', '6.30', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11466', '1700', '3', '7.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11467', '1700', '3', '6.50', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11468', '1701', '3', '7.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11469', '1701', '3', '5.10', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11470', '1702', '3', '5.00', '2025-07-14', '1', '1');
INSERT INTO `notas` VALUES('11471', '1702', '3', '7.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11472', '1702', '3', '5.10', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11473', '1703', '3', '7.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11474', '1703', '3', '5.70', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11475', '1704', '3', '7.00', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11476', '1704', '3', '7.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11477', '1704', '3', '5.70', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11478', '1705', '3', '7.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11479', '1705', '3', '5.50', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11480', '1706', '3', '7.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11481', '1706', '3', '5.10', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11482', '1707', '3', '7.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11483', '1707', '3', '5.60', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11484', '1708', '3', '7.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11485', '1708', '3', '6.50', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11486', '1709', '3', '7.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11487', '1709', '3', '6.20', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11488', '1710', '3', '5.00', '2025-07-14', '1', '1');
INSERT INTO `notas` VALUES('11489', '1710', '3', '7.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11490', '1710', '3', '5.10', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11491', '1711', '3', '7.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11492', '1711', '3', '5.10', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11493', '1712', '3', '6.00', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11494', '1712', '3', '7.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11495', '1712', '3', '6.30', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11496', '1922', '6', '7.00', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11497', '1922', '6', '6.80', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11498', '1922', '6', '6.80', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11499', '1923', '6', '4.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11500', '1923', '6', '4.80', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11501', '1924', '6', '5.20', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11502', '1924', '6', '5.70', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11503', '1925', '6', '4.10', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11504', '1925', '6', '6.00', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11505', '1926', '6', '6.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11506', '1926', '6', '6.40', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11507', '1927', '6', '3.80', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11508', '1927', '6', '6.50', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11509', '1928', '6', '4.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11510', '1928', '6', '5.00', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11511', '1929', '6', '5.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11512', '1929', '6', '5.90', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11513', '1930', '6', '5.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11514', '1930', '6', '5.80', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11515', '1931', '6', '4.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11516', '1931', '6', '5.30', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11517', '1932', '6', '5.20', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11518', '1932', '6', '6.10', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11519', '1933', '6', '6.80', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11520', '1933', '6', '5.90', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11521', '1947', '6', '6.00', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11522', '1947', '6', '6.10', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11523', '1947', '6', '6.30', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11524', '1934', '6', '6.10', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11525', '1934', '6', '5.80', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11526', '1935', '6', '6.80', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11527', '1935', '6', '6.70', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11528', '1936', '6', '5.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11529', '1936', '6', '6.00', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11530', '1937', '6', '6.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11531', '1937', '6', '6.10', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11532', '1938', '6', '4.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11533', '1938', '6', '5.70', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11534', '1939', '6', '3.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11535', '1939', '6', '5.70', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11536', '1940', '6', '4.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11537', '1940', '6', '6.40', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11538', '1941', '6', '6.60', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11539', '1941', '6', '6.60', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11540', '1942', '6', '7.00', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11541', '1942', '6', '6.60', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11542', '1942', '6', '6.10', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11543', '1943', '6', '6.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11544', '1943', '6', '6.50', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11545', '1944', '6', '4.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11546', '1944', '6', '6.00', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11547', '1945', '6', '6.10', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11548', '1945', '6', '6.50', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11549', '1946', '6', '6.30', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11550', '1946', '6', '6.40', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11551', '1922', '3', '7.00', '2025-07-14', '1', '1');
INSERT INTO `notas` VALUES('11552', '1922', '3', '7.00', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11553', '1922', '3', '7.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11554', '1922', '3', '7.00', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11555', '1923', '3', '4.00', '2025-07-14', '1', '1');
INSERT INTO `notas` VALUES('11556', '1923', '3', '4.00', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11557', '1923', '3', '4.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11558', '1923', '3', '4.00', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11559', '1924', '3', '4.00', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11560', '1924', '3', '4.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11561', '1924', '3', '4.00', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11562', '1925', '3', '4.00', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11563', '1925', '3', '5.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11564', '1925', '3', '4.00', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11565', '1926', '3', '6.80', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11566', '1926', '3', '6.50', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11567', '1926', '3', '6.00', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11568', '1927', '3', '6.20', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11569', '1927', '3', '5.50', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11570', '1927', '3', '5.00', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11571', '1928', '3', '5.00', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11572', '1928', '3', '5.50', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11573', '1928', '3', '5.00', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11574', '1929', '3', '5.00', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11575', '1929', '3', '5.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11576', '1929', '3', '5.80', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11577', '1930', '3', '5.00', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11578', '1930', '3', '6.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11579', '1930', '3', '6.00', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11580', '1931', '3', '5.80', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11581', '1931', '3', '6.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11582', '1931', '3', '6.00', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11583', '1932', '3', '4.00', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11584', '1932', '3', '5.50', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11585', '1932', '3', '4.50', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11586', '1933', '3', '6.50', '2025-07-14', '1', '1');
INSERT INTO `notas` VALUES('11587', '1933', '3', '6.60', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11588', '1933', '3', '6.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11589', '1933', '3', '6.00', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11590', '1947', '3', '6.00', '2025-07-14', '1', '1');
INSERT INTO `notas` VALUES('11591', '1947', '3', '5.80', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11592', '1947', '3', '6.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11593', '1947', '3', '6.50', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11594', '1934', '3', '4.00', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11595', '1934', '3', '5.80', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11596', '1934', '3', '5.40', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11597', '1935', '3', '6.80', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11598', '1935', '3', '6.80', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11599', '1935', '3', '6.50', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11600', '1936', '3', '5.20', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11601', '1936', '3', '5.50', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11602', '1936', '3', '5.00', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11603', '1937', '3', '6.00', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11604', '1937', '3', '6.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11605', '1937', '3', '6.50', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11606', '1938', '3', '6.00', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11607', '1938', '3', '5.80', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11608', '1938', '3', '5.50', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11609', '1939', '3', '4.00', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11610', '1939', '3', '4.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11611', '1939', '3', '4.00', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11612', '1940', '3', '6.00', '2025-07-14', '1', '1');
INSERT INTO `notas` VALUES('11613', '1940', '3', '5.00', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11614', '1940', '3', '6.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11615', '1940', '3', '5.80', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11616', '1941', '3', '6.00', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11617', '1941', '3', '7.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11618', '1941', '3', '6.80', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11619', '1942', '3', '5.00', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11620', '1942', '3', '5.50', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11621', '1942', '3', '5.80', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11622', '1943', '3', '6.50', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11623', '1943', '3', '6.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11624', '1943', '3', '5.50', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11625', '1944', '3', '5.00', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11626', '1944', '3', '5.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11627', '1944', '3', '5.80', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11628', '1945', '3', '5.00', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11629', '1945', '3', '7.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11630', '1945', '3', '6.80', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11631', '1946', '3', '5.80', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11632', '1946', '3', '6.20', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11633', '1946', '3', '6.50', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11634', '1429', '3', '7.00', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11635', '1429', '3', '7.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11636', '1429', '3', '7.00', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11637', '1430', '3', '6.80', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11638', '1430', '3', '7.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11639', '1430', '3', '7.00', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11640', '1431', '3', '7.00', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11641', '1431', '3', '7.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11642', '1431', '3', '7.00', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11643', '1432', '3', '7.00', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11644', '1432', '3', '7.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11645', '1432', '3', '7.00', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11646', '1433', '3', '7.00', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11647', '1433', '3', '7.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11648', '1433', '3', '7.00', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11649', '1434', '3', '6.80', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11650', '1434', '3', '7.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11651', '1434', '3', '7.00', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11652', '1435', '3', '7.00', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11653', '1435', '3', '7.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11654', '1435', '3', '7.00', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11655', '1436', '3', '6.80', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11656', '1436', '3', '7.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11657', '1436', '3', '7.00', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11658', '1454', '3', '6.80', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11659', '1454', '3', '7.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11660', '1454', '3', '7.00', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11661', '1437', '3', '7.00', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11662', '1437', '3', '7.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11663', '1437', '3', '7.00', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11664', '1438', '3', '6.80', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11665', '1438', '3', '7.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11666', '1438', '3', '7.00', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11667', '1439', '3', '7.00', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11668', '1439', '3', '7.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11669', '1439', '3', '7.00', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11670', '1440', '3', '6.80', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11671', '1440', '3', '7.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11672', '1440', '3', '7.00', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11673', '1441', '3', '7.00', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11674', '1441', '3', '7.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11675', '1441', '3', '7.00', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11676', '1442', '3', '6.00', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11677', '1442', '3', '7.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11678', '1442', '3', '7.00', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11679', '1443', '3', '7.00', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11680', '1443', '3', '7.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11681', '1443', '3', '7.00', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11682', '1444', '3', '7.00', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11683', '1444', '3', '7.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11684', '1444', '3', '7.00', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11685', '1445', '3', '6.80', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11686', '1445', '3', '7.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11687', '1445', '3', '7.00', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11688', '1446', '3', '7.00', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11689', '1446', '3', '7.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11690', '1446', '3', '7.00', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11691', '1447', '3', '6.80', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11692', '1447', '3', '7.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11693', '1447', '3', '7.00', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11694', '1448', '3', '7.00', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11695', '1448', '3', '6.80', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11696', '1448', '3', '7.00', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11697', '1449', '3', '7.00', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11698', '1449', '3', '7.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11699', '1449', '3', '7.00', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11700', '1825', '3', '7.00', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11701', '1825', '3', '7.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11702', '1825', '3', '7.00', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11703', '1450', '3', '7.00', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11704', '1450', '3', '7.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11705', '1450', '3', '7.00', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11706', '1451', '3', '7.00', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11707', '1451', '3', '7.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11708', '1451', '3', '7.00', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11709', '1453', '3', '7.00', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11710', '1453', '3', '7.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11711', '1453', '3', '7.00', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11712', '1455', '3', '7.00', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11713', '1455', '3', '7.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11714', '1455', '3', '7.00', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11715', '1456', '3', '7.00', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11716', '1456', '3', '7.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11717', '1456', '3', '7.00', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11718', '1457', '3', '7.00', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11719', '1457', '3', '6.80', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11720', '1457', '3', '7.00', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11721', '1843', '3', '7.00', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11722', '1843', '3', '7.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11723', '1843', '3', '7.00', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11724', '1458', '3', '7.00', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11725', '1458', '3', '7.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11726', '1458', '3', '7.00', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11727', '1459', '3', '7.00', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11728', '1459', '3', '6.80', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11729', '1459', '3', '7.00', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11730', '1842', '3', '7.00', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11731', '1842', '3', '7.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11732', '1842', '3', '7.00', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11733', '1460', '3', '7.00', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11734', '1460', '3', '6.80', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11735', '1460', '3', '7.00', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11736', '1461', '3', '7.00', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11737', '1461', '3', '7.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11738', '1461', '3', '7.00', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11739', '1462', '3', '7.00', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11740', '1462', '3', '7.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11741', '1462', '3', '7.00', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11742', '1463', '3', '7.00', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11743', '1463', '3', '7.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11744', '1463', '3', '7.00', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11745', '1464', '3', '7.00', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11746', '1464', '3', '7.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11747', '1464', '3', '7.00', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11748', '1465', '3', '7.00', '2025-07-14', '1', '1');
INSERT INTO `notas` VALUES('11749', '1465', '3', '7.00', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11750', '1465', '3', '7.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11751', '1465', '3', '7.00', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11752', '1988', '3', '7.00', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11753', '1988', '3', '7.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11754', '1988', '3', '7.00', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11755', '1467', '3', '7.00', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11756', '1467', '3', '7.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11757', '1467', '3', '7.00', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11758', '1692', '2', '5.50', '2025-07-14', '1', '1');
INSERT INTO `notas` VALUES('11759', '1692', '2', '6.30', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11760', '1692', '2', '4.00', '2025-07-14', '1', '5');
INSERT INTO `notas` VALUES('11761', '1692', '2', '6.10', '2025-07-14', '1', '6');
INSERT INTO `notas` VALUES('11762', '1692', '2', '6.30', '2025-07-14', '1', '7');
INSERT INTO `notas` VALUES('11763', '1693', '2', '6.80', '2025-07-14', '1', '1');
INSERT INTO `notas` VALUES('11764', '1693', '2', '6.40', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11765', '1693', '2', '7.00', '2025-07-14', '1', '5');
INSERT INTO `notas` VALUES('11766', '1693', '2', '7.00', '2025-07-14', '1', '6');
INSERT INTO `notas` VALUES('11767', '1693', '2', '6.10', '2025-07-14', '1', '7');
INSERT INTO `notas` VALUES('11768', '1694', '2', '6.00', '2025-07-14', '1', '1');
INSERT INTO `notas` VALUES('11769', '1694', '2', '6.00', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11770', '1694', '2', '7.00', '2025-07-14', '1', '5');
INSERT INTO `notas` VALUES('11771', '1694', '2', '6.00', '2025-07-14', '1', '6');
INSERT INTO `notas` VALUES('11772', '1694', '2', '6.40', '2025-07-14', '1', '7');
INSERT INTO `notas` VALUES('11773', '1695', '2', '6.30', '2025-07-14', '1', '1');
INSERT INTO `notas` VALUES('11774', '1695', '2', '5.20', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11775', '1695', '2', '6.00', '2025-07-14', '1', '5');
INSERT INTO `notas` VALUES('11776', '1695', '2', '7.00', '2025-07-14', '1', '6');
INSERT INTO `notas` VALUES('11777', '1695', '2', '6.60', '2025-07-14', '1', '7');
INSERT INTO `notas` VALUES('11778', '1696', '2', '7.00', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11779', '1697', '2', '4.40', '2025-07-14', '1', '1');
INSERT INTO `notas` VALUES('11780', '1697', '2', '5.20', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11781', '1697', '2', '6.00', '2025-07-14', '1', '5');
INSERT INTO `notas` VALUES('11782', '1697', '2', '2.70', '2025-07-14', '1', '6');
INSERT INTO `notas` VALUES('11783', '1697', '2', '4.70', '2025-07-14', '1', '7');
INSERT INTO `notas` VALUES('11784', '1698', '2', '5.50', '2025-07-14', '1', '1');
INSERT INTO `notas` VALUES('11785', '1698', '2', '6.10', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11786', '1698', '2', '5.00', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11787', '1698', '2', '5.00', '2025-07-14', '1', '5');
INSERT INTO `notas` VALUES('11788', '1698', '2', '5.90', '2025-07-14', '1', '6');
INSERT INTO `notas` VALUES('11789', '1698', '2', '4.40', '2025-07-14', '1', '7');
INSERT INTO `notas` VALUES('11790', '1699', '2', '5.60', '2025-07-14', '1', '1');
INSERT INTO `notas` VALUES('11791', '1699', '2', '5.70', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11792', '1699', '2', '5.00', '2025-07-14', '1', '5');
INSERT INTO `notas` VALUES('11793', '1699', '2', '6.80', '2025-07-14', '1', '6');
INSERT INTO `notas` VALUES('11794', '1699', '2', '6.40', '2025-07-14', '1', '7');
INSERT INTO `notas` VALUES('11795', '1700', '2', '7.00', '2025-07-14', '1', '1');
INSERT INTO `notas` VALUES('11796', '1700', '2', '7.00', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11797', '1700', '2', '7.00', '2025-07-14', '1', '5');
INSERT INTO `notas` VALUES('11798', '1700', '2', '7.00', '2025-07-14', '1', '6');
INSERT INTO `notas` VALUES('11799', '1700', '2', '7.00', '2025-07-14', '1', '7');
INSERT INTO `notas` VALUES('11800', '1701', '2', '5.40', '2025-07-14', '1', '1');
INSERT INTO `notas` VALUES('11801', '1701', '2', '6.40', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11802', '1701', '2', '5.00', '2025-07-14', '1', '5');
INSERT INTO `notas` VALUES('11803', '1701', '2', '5.60', '2025-07-14', '1', '6');
INSERT INTO `notas` VALUES('11804', '1701', '2', '5.80', '2025-07-14', '1', '7');
INSERT INTO `notas` VALUES('11805', '1702', '2', '6.10', '2025-07-14', '1', '1');
INSERT INTO `notas` VALUES('11806', '1702', '2', '6.40', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11807', '1702', '2', '7.00', '2025-07-14', '1', '5');
INSERT INTO `notas` VALUES('11808', '1702', '2', '4.10', '2025-07-14', '1', '6');
INSERT INTO `notas` VALUES('11809', '1702', '2', '6.10', '2025-07-14', '1', '7');
INSERT INTO `notas` VALUES('11810', '1703', '2', '6.70', '2025-07-14', '1', '1');
INSERT INTO `notas` VALUES('11811', '1703', '2', '6.80', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11812', '1703', '2', '6.00', '2025-07-14', '1', '5');
INSERT INTO `notas` VALUES('11813', '1703', '2', '7.00', '2025-07-14', '1', '6');
INSERT INTO `notas` VALUES('11814', '1703', '2', '6.40', '2025-07-14', '1', '7');
INSERT INTO `notas` VALUES('11815', '1704', '2', '6.20', '2025-07-14', '1', '1');
INSERT INTO `notas` VALUES('11816', '1704', '2', '5.90', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11817', '1704', '2', '5.00', '2025-07-14', '1', '5');
INSERT INTO `notas` VALUES('11818', '1704', '2', '6.60', '2025-07-14', '1', '6');
INSERT INTO `notas` VALUES('11819', '1704', '2', '6.40', '2025-07-14', '1', '7');
INSERT INTO `notas` VALUES('11820', '1705', '2', '5.50', '2025-07-14', '1', '1');
INSERT INTO `notas` VALUES('11821', '1705', '2', '6.40', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11822', '1705', '2', '7.00', '2025-07-14', '1', '5');
INSERT INTO `notas` VALUES('11823', '1705', '2', '4.50', '2025-07-14', '1', '6');
INSERT INTO `notas` VALUES('11824', '1705', '2', '4.70', '2025-07-14', '1', '7');
INSERT INTO `notas` VALUES('11825', '1706', '2', '4.00', '2025-07-14', '1', '1');
INSERT INTO `notas` VALUES('11826', '1706', '2', '6.00', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11827', '1706', '2', '4.00', '2025-07-14', '1', '5');
INSERT INTO `notas` VALUES('11828', '1706', '2', '3.70', '2025-07-14', '1', '6');
INSERT INTO `notas` VALUES('11829', '1706', '2', '4.40', '2025-07-14', '1', '7');
INSERT INTO `notas` VALUES('11830', '1707', '2', '6.00', '2025-07-14', '1', '1');
INSERT INTO `notas` VALUES('11831', '1707', '2', '7.00', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11832', '1707', '2', '5.00', '2025-07-14', '1', '5');
INSERT INTO `notas` VALUES('11833', '1707', '2', '6.60', '2025-07-14', '1', '6');
INSERT INTO `notas` VALUES('11834', '1707', '2', '4.90', '2025-07-14', '1', '7');
INSERT INTO `notas` VALUES('11835', '1708', '2', '4.60', '2025-07-14', '1', '1');
INSERT INTO `notas` VALUES('11836', '1708', '2', '5.00', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11837', '1708', '2', '4.00', '2025-07-14', '1', '5');
INSERT INTO `notas` VALUES('11838', '1708', '2', '4.00', '2025-07-14', '1', '6');
INSERT INTO `notas` VALUES('11839', '1708', '2', '4.80', '2025-07-14', '1', '7');
INSERT INTO `notas` VALUES('11840', '1709', '2', '5.10', '2025-07-14', '1', '1');
INSERT INTO `notas` VALUES('11841', '1709', '2', '5.70', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11842', '1709', '2', '4.00', '2025-07-14', '1', '5');
INSERT INTO `notas` VALUES('11843', '1709', '2', '5.10', '2025-07-14', '1', '6');
INSERT INTO `notas` VALUES('11844', '1709', '2', '5.40', '2025-07-14', '1', '7');
INSERT INTO `notas` VALUES('11845', '1710', '2', '4.50', '2025-07-14', '1', '1');
INSERT INTO `notas` VALUES('11846', '1710', '2', '6.00', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11847', '1710', '2', '4.00', '2025-07-14', '1', '5');
INSERT INTO `notas` VALUES('11848', '1710', '2', '4.00', '2025-07-14', '1', '6');
INSERT INTO `notas` VALUES('11849', '1710', '2', '5.10', '2025-07-14', '1', '7');
INSERT INTO `notas` VALUES('11850', '1711', '2', '4.20', '2025-07-14', '1', '1');
INSERT INTO `notas` VALUES('11851', '1711', '2', '4.00', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11852', '1711', '2', '4.00', '2025-07-14', '1', '5');
INSERT INTO `notas` VALUES('11853', '1711', '2', '6.10', '2025-07-14', '1', '6');
INSERT INTO `notas` VALUES('11854', '1711', '2', '4.60', '2025-07-14', '1', '7');
INSERT INTO `notas` VALUES('11855', '1712', '2', '6.00', '2025-07-14', '1', '1');
INSERT INTO `notas` VALUES('11856', '1712', '2', '6.40', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11857', '1712', '2', '6.00', '2025-07-14', '1', '5');
INSERT INTO `notas` VALUES('11858', '1712', '2', '6.10', '2025-07-14', '1', '6');
INSERT INTO `notas` VALUES('11859', '1712', '2', '5.90', '2025-07-14', '1', '7');
INSERT INTO `notas` VALUES('11860', '1922', '1', '7.00', '2025-07-14', '1', '1');
INSERT INTO `notas` VALUES('11861', '1922', '1', '7.00', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11862', '1922', '1', '6.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11863', '1922', '1', '7.00', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11864', '1922', '1', '6.70', '2025-07-14', '1', '5');
INSERT INTO `notas` VALUES('11865', '1922', '1', '6.20', '2025-07-14', '1', '6');
INSERT INTO `notas` VALUES('11866', '1923', '1', '3.60', '2025-07-14', '1', '1');
INSERT INTO `notas` VALUES('11867', '1923', '1', '5.40', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11868', '1923', '1', '5.70', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11869', '1923', '1', '4.00', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11870', '1923', '1', '4.50', '2025-07-14', '1', '5');
INSERT INTO `notas` VALUES('11871', '1923', '1', '4.80', '2025-07-14', '1', '6');
INSERT INTO `notas` VALUES('11872', '1924', '1', '4.10', '2025-07-14', '1', '1');
INSERT INTO `notas` VALUES('11873', '1924', '1', '4.80', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11874', '1924', '1', '6.50', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11875', '1924', '1', '5.30', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11876', '1924', '1', '4.80', '2025-07-14', '1', '5');
INSERT INTO `notas` VALUES('11877', '1924', '1', '5.00', '2025-07-14', '1', '6');
INSERT INTO `notas` VALUES('11878', '1925', '1', '5.50', '2025-07-14', '1', '1');
INSERT INTO `notas` VALUES('11879', '1925', '1', '5.70', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11880', '1925', '1', '2.60', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11881', '1925', '1', '6.10', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11882', '1925', '1', '5.00', '2025-07-14', '1', '5');
INSERT INTO `notas` VALUES('11883', '1925', '1', '5.20', '2025-07-14', '1', '6');
INSERT INTO `notas` VALUES('11884', '1926', '1', '6.00', '2025-07-14', '1', '1');
INSERT INTO `notas` VALUES('11885', '1926', '1', '6.70', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11886', '1926', '1', '6.10', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11887', '1926', '1', '6.00', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11888', '1926', '1', '6.20', '2025-07-14', '1', '5');
INSERT INTO `notas` VALUES('11889', '1926', '1', '5.80', '2025-07-14', '1', '6');
INSERT INTO `notas` VALUES('11890', '1927', '1', '5.50', '2025-07-14', '1', '1');
INSERT INTO `notas` VALUES('11891', '1927', '1', '3.80', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11892', '1927', '1', '6.50', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11893', '1927', '1', '5.80', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11894', '1927', '1', '6.50', '2025-07-14', '1', '5');
INSERT INTO `notas` VALUES('11895', '1927', '1', '6.00', '2025-07-14', '1', '6');
INSERT INTO `notas` VALUES('11896', '1928', '1', '4.20', '2025-07-14', '1', '1');
INSERT INTO `notas` VALUES('11897', '1928', '1', '5.00', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11898', '1928', '1', '5.50', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11899', '1928', '1', '5.40', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11900', '1928', '1', '5.80', '2025-07-14', '1', '5');
INSERT INTO `notas` VALUES('11901', '1928', '1', '5.00', '2025-07-14', '1', '6');
INSERT INTO `notas` VALUES('11902', '1929', '1', '3.70', '2025-07-14', '1', '1');
INSERT INTO `notas` VALUES('11903', '1929', '1', '5.40', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11904', '1929', '1', '3.10', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11905', '1929', '1', '5.10', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11906', '1929', '1', '5.00', '2025-07-14', '1', '5');
INSERT INTO `notas` VALUES('11907', '1929', '1', '5.80', '2025-07-14', '1', '6');
INSERT INTO `notas` VALUES('11908', '1930', '1', '5.00', '2025-07-14', '1', '1');
INSERT INTO `notas` VALUES('11909', '1930', '1', '5.70', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11910', '1930', '1', '6.50', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11911', '1930', '1', '6.10', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11912', '1930', '1', '6.50', '2025-07-14', '1', '5');
INSERT INTO `notas` VALUES('11913', '1930', '1', '6.00', '2025-07-14', '1', '6');
INSERT INTO `notas` VALUES('11914', '1931', '1', '4.50', '2025-07-14', '1', '1');
INSERT INTO `notas` VALUES('11915', '1931', '1', '5.70', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11916', '1931', '1', '5.20', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11917', '1931', '1', '5.50', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11918', '1931', '1', '7.00', '2025-07-14', '1', '5');
INSERT INTO `notas` VALUES('11919', '1931', '1', '6.00', '2025-07-14', '1', '6');
INSERT INTO `notas` VALUES('11920', '1932', '1', '3.60', '2025-07-14', '1', '1');
INSERT INTO `notas` VALUES('11921', '1932', '1', '4.70', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11922', '1932', '1', '3.10', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11923', '1932', '1', '4.80', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11924', '1932', '1', '5.80', '2025-07-14', '1', '5');
INSERT INTO `notas` VALUES('11925', '1932', '1', '5.30', '2025-07-14', '1', '6');
INSERT INTO `notas` VALUES('11926', '1933', '1', '7.00', '2025-07-14', '1', '1');
INSERT INTO `notas` VALUES('11927', '1933', '1', '7.00', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11928', '1933', '1', '7.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11929', '1933', '1', '7.00', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11930', '1933', '1', '7.00', '2025-07-14', '1', '5');
INSERT INTO `notas` VALUES('11931', '1933', '1', '7.00', '2025-07-14', '1', '6');
INSERT INTO `notas` VALUES('11932', '1947', '1', '4.70', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11933', '1947', '1', '5.70', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11934', '1947', '1', '5.60', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11935', '1947', '1', '5.50', '2025-07-14', '1', '5');
INSERT INTO `notas` VALUES('11936', '1947', '1', '6.00', '2025-07-14', '1', '6');
INSERT INTO `notas` VALUES('11937', '1934', '1', '6.00', '2025-07-14', '1', '1');
INSERT INTO `notas` VALUES('11938', '1934', '1', '6.70', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11939', '1934', '1', '7.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11940', '1934', '1', '6.10', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11941', '1934', '1', '6.00', '2025-07-14', '1', '5');
INSERT INTO `notas` VALUES('11942', '1934', '1', '5.50', '2025-07-14', '1', '6');
INSERT INTO `notas` VALUES('11943', '1935', '1', '6.00', '2025-07-14', '1', '1');
INSERT INTO `notas` VALUES('11944', '1935', '1', '7.00', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11945', '1935', '1', '7.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11946', '1935', '1', '6.70', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11947', '1935', '1', '7.00', '2025-07-14', '1', '5');
INSERT INTO `notas` VALUES('11948', '1935', '1', '6.00', '2025-07-14', '1', '6');
INSERT INTO `notas` VALUES('11949', '1936', '1', '4.50', '2025-07-14', '1', '1');
INSERT INTO `notas` VALUES('11950', '1936', '1', '6.70', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11951', '1936', '1', '2.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11952', '1936', '1', '4.80', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11953', '1936', '1', '6.00', '2025-07-14', '1', '5');
INSERT INTO `notas` VALUES('11954', '1936', '1', '5.00', '2025-07-14', '1', '6');
INSERT INTO `notas` VALUES('11955', '1937', '1', '4.50', '2025-07-14', '1', '1');
INSERT INTO `notas` VALUES('11956', '1937', '1', '4.70', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11957', '1937', '1', '5.70', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11958', '1937', '1', '5.20', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11959', '1937', '1', '6.10', '2025-07-14', '1', '5');
INSERT INTO `notas` VALUES('11960', '1937', '1', '6.00', '2025-07-14', '1', '6');
INSERT INTO `notas` VALUES('11961', '1938', '1', '4.00', '2025-07-14', '1', '1');
INSERT INTO `notas` VALUES('11962', '1938', '1', '5.70', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11963', '1938', '1', '3.60', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11964', '1938', '1', '5.00', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11965', '1938', '1', '5.80', '2025-07-14', '1', '5');
INSERT INTO `notas` VALUES('11966', '1938', '1', '5.50', '2025-07-14', '1', '6');
INSERT INTO `notas` VALUES('11967', '1939', '1', '4.00', '2025-07-14', '1', '1');
INSERT INTO `notas` VALUES('11968', '1939', '1', '5.50', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11969', '1939', '1', '2.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11970', '1939', '1', '4.00', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11971', '1939', '1', '4.50', '2025-07-14', '1', '5');
INSERT INTO `notas` VALUES('11972', '1939', '1', '4.00', '2025-07-14', '1', '6');
INSERT INTO `notas` VALUES('11973', '1940', '1', '3.80', '2025-07-14', '1', '1');
INSERT INTO `notas` VALUES('11974', '1940', '1', '6.00', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11975', '1940', '1', '3.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11976', '1940', '1', '4.80', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11977', '1940', '1', '5.80', '2025-07-14', '1', '5');
INSERT INTO `notas` VALUES('11978', '1940', '1', '5.40', '2025-07-14', '1', '6');
INSERT INTO `notas` VALUES('11979', '1941', '1', '6.30', '2025-07-14', '1', '1');
INSERT INTO `notas` VALUES('11980', '1941', '1', '6.00', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11981', '1941', '1', '7.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11982', '1941', '1', '6.80', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11983', '1941', '1', '6.50', '2025-07-14', '1', '5');
INSERT INTO `notas` VALUES('11984', '1941', '1', '7.00', '2025-07-14', '1', '6');
INSERT INTO `notas` VALUES('11985', '1942', '1', '3.80', '2025-07-14', '1', '1');
INSERT INTO `notas` VALUES('11986', '1942', '1', '5.80', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11987', '1942', '1', '2.40', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11988', '1942', '1', '4.70', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11989', '1942', '1', '4.80', '2025-07-14', '1', '5');
INSERT INTO `notas` VALUES('11990', '1942', '1', '5.00', '2025-07-14', '1', '6');
INSERT INTO `notas` VALUES('11991', '1943', '1', '5.20', '2025-07-14', '1', '1');
INSERT INTO `notas` VALUES('11992', '1943', '1', '6.00', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11993', '1943', '1', '6.50', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('11994', '1943', '1', '5.00', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('11995', '1943', '1', '5.10', '2025-07-14', '1', '5');
INSERT INTO `notas` VALUES('11996', '1943', '1', '5.80', '2025-07-14', '1', '6');
INSERT INTO `notas` VALUES('11997', '1944', '1', '3.40', '2025-07-14', '1', '1');
INSERT INTO `notas` VALUES('11998', '1944', '1', '6.30', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('11999', '1944', '1', '5.20', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('12000', '1944', '1', '5.00', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('12001', '1944', '1', '4.80', '2025-07-14', '1', '5');
INSERT INTO `notas` VALUES('12002', '1944', '1', '6.00', '2025-07-14', '1', '6');
INSERT INTO `notas` VALUES('12003', '1945', '1', '7.00', '2025-07-14', '1', '1');
INSERT INTO `notas` VALUES('12004', '1945', '1', '6.00', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('12005', '1945', '1', '6.90', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('12006', '1945', '1', '6.80', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('12007', '1945', '1', '7.00', '2025-07-14', '1', '5');
INSERT INTO `notas` VALUES('12008', '1945', '1', '7.00', '2025-07-14', '1', '6');
INSERT INTO `notas` VALUES('12009', '1946', '1', '6.00', '2025-07-14', '1', '1');
INSERT INTO `notas` VALUES('12010', '1946', '1', '5.40', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('12011', '1946', '1', '7.00', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('12012', '1946', '1', '6.10', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('12013', '1946', '1', '6.00', '2025-07-14', '1', '5');
INSERT INTO `notas` VALUES('12014', '1946', '1', '6.00', '2025-07-14', '1', '6');
INSERT INTO `notas` VALUES('12015', '1732', '2', '7.00', '2025-07-14', '1', '1');
INSERT INTO `notas` VALUES('12016', '1733', '2', '3.00', '2025-07-14', '1', '5');
INSERT INTO `notas` VALUES('12017', '1742', '2', '7.00', '2025-07-14', '1', '1');
INSERT INTO `notas` VALUES('12018', '1742', '2', '5.50', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('12019', '1742', '2', '6.00', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('12020', '1742', '2', '6.50', '2025-07-14', '1', '5');
INSERT INTO `notas` VALUES('12021', '1746', '2', '5.00', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('12022', '1731', '6', '4.50', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('12023', '1732', '6', '6.10', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('12024', '1733', '6', '5.10', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('12025', '1739', '6', '5.00', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('12026', '1746', '6', '4.80', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('12027', '1747', '6', '4.00', '2025-07-14', '1', '2');
INSERT INTO `notas` VALUES('12028', '1747', '6', '4.20', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('12029', '1749', '6', '4.20', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('12030', '1585', '7', '2.40', '2025-07-14', '1', '3');
INSERT INTO `notas` VALUES('12031', '1585', '7', '5.50', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('12032', '1586', '7', '6.10', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('12033', '1587', '7', '6.20', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('12034', '1588', '7', '6.60', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('12035', '1589', '7', '5.50', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('12036', '1590', '7', '6.10', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('12037', '1591', '7', '4.70', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('12038', '1592', '7', '5.70', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('12039', '1593', '7', '6.60', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('12040', '1594', '7', '5.90', '2025-07-14', '1', '4');
INSERT INTO `notas` VALUES('12041', '1595', '7', '5.90', '2025-07-14',