<?php
session_start();
include '../includes/db.php';
include '../includes/auth.php';
checkAuth();

// Solo usuarios autorizados deben ver esto (ajusta según tu sistema de roles)
if ($_SESSION['rol'] != 1) { // por ejemplo, rol 1 = administrador
    header("Location: ../index.php");
    exit();
}

$conn->set_charset("utf8");
$result = $conn->query("SELECT * FROM registro_actividad ORDER BY fecha DESC");
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Historial de Actividades</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            padding: 20px;
        }
        h2 {
            text-align: center;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 25px;
        }
        th, td {
            padding: 10px;
            border: 1px solid #ccc;
            font-size: 14px;
        }
        th {
            background-color: #f4f4f4;
        }
        .volver {
            display: inline-block;
            margin-top: 20px;
            padding: 8px 16px;
            background-color: #333;
            color: #fff;
            text-decoration: none;
            border-radius: 5px;
        }
        .volver:hover {
            background-color: #555;
        }
    </style>
</head>
<body>

<h2>Historial de Actividad de Usuarios</h2>

<table>
    <thead>
        <tr>
            <th>Usuario</th>
            <th>Acción</th>
            <th>Fecha y Hora</th>
            <th>IP</th>
        </tr>
    </thead>
    <tbody>
        <?php while($row = $result->fetch_assoc()): ?>
            <tr>
                <td><?php echo htmlspecialchars($row['usuario']); ?></td>
                <td><?php echo htmlspecialchars($row['accion']); ?></td>
                <td><?php echo $row['fecha']; ?></td>
                <td><?php echo $row['ip_usuario']; ?></td>
            </tr>
        <?php endwhile; ?>
    </tbody>
</table>

<a class="volver" href="../index.php">← Volver al Inicio</a>

</body>
</html>

