<?php
header('Content-Type: text/html; charset=utf-8');

include '../includes/db.php';
include '../includes/auth.php';
checkAuth();

$conn->set_charset("utf8mb4");

$message = '';
$message_type = '';

// Procesar la creación o modificación de asignaturas
if ($_SERVER['REQUEST_METHOD'] == 'POST' && (isset($_POST['crear']) || isset($_POST['modificar']))) {
    $nombre = trim($_POST['nombre']); // Eliminar espacios en blanco del inicio y fin

    if (empty($nombre)) {
        $message = "Error: El nombre de la asignatura no puede estar vacío o contener solo espacios.";
        $message_type = 'error';
    } else {
        if (isset($_POST['crear'])) {
            // Inserción de una nueva asignatura
            $stmt = $conn->prepare("INSERT INTO asignatura (nombre) VALUES (?)");
            $stmt->bind_param("s", $nombre);
            if ($stmt->execute()) {
                $message = "Asignatura agregada correctamente.";
                $message_type = 'exito';
            } else {
                $message = "Error al agregar la asignatura.";
                $message_type = 'error';
            }
        } else if (isset($_POST['modificar'])) {
            // Modificación de una asignatura existente
            $id = intval($_POST['asignatura_id']);
            $stmt = $conn->prepare("UPDATE asignatura SET nombre = ? WHERE id = ?");
            $stmt->bind_param("si", $nombre, $id);
            if ($stmt->execute()) {
                $message = "Asignatura modificada correctamente.";
                $message_type = 'exito';
            } else {
                $message = "Error al modificar la asignatura.";
                $message_type = 'error';
            }
        }
        $stmt->close();
    }
    header("Location: add_subject.php?message=" . urlencode($message) . "&type=" . urlencode($message_type));
    exit();
}

// Procesar la eliminación de asignaturas
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['eliminar'])) {
    $asignatura_id = intval($_POST['asignatura_id']);
    $stmt = $conn->prepare("DELETE FROM asignatura WHERE id = ?");
    $stmt->bind_param("i", $asignatura_id);
    if ($stmt->execute()) {
        $message = "Asignatura eliminada correctamente.";
        $message_type = 'exito';
    } else {
        $message = "Error al eliminar la asignatura.";
        $message_type = 'error';
    }
    $stmt->close();
    header("Location: add_subject.php?message=" . urlencode($message) . "&type=" . urlencode($message_type));
    exit();
}

// Obtener todas las asignaturas
$asignaturas = $conn->query("SELECT * FROM asignatura");
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Agregar/Editar Asignaturas</title>
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Roboto:400,700&display=swap"> <!-- Fuente moderna -->
    <link rel="stylesheet" href="../css/asignatura.css">
    <style>
        
    </style>
</head>
<body>
    <header>
        <img src="../images/INSIGNIA SF.png" alt="Escuela Porongo Insignia">
        <h1>Agregar/Editar Asignaturas</h1>
    
    <nav>
        <ul>
            <li><a href="../index.php">Inicio</a></li>
        </ul>
    </nav>
        </header>
    <main>
        <?php if (isset($_GET['message']) && isset($_GET['type'])): ?>
            <div class="mensaje <?php echo htmlspecialchars($_GET['type'], ENT_QUOTES, 'UTF-8'); ?> show">
                <?php echo htmlspecialchars($_GET['message'], ENT_QUOTES, 'UTF-8'); ?>
            </div>
        <?php endif; ?>
        <form method="POST" action="add_subject.php" onsubmit="return validarFormulario()">
            <input type="hidden" name="asignatura_id" id="asignatura_id">
            <label for="nombre">Nombre de la Asignatura:</label>
            <input type="text" id="nombre" name="nombre" required>
            <button type="submit" name="crear" id="crear">Agregar Asignatura</button>
            <button type="submit" name="modificar" id="modificar" style="display:none;">Modificar Asignatura</button>
        </form>

        <h2>Asignaturas Existentes</h2>
        <table>
            <tr>
                <th>Nombre</th>
                <th>Acciones</th>
            </tr>
            <?php while ($row = $asignaturas->fetch_assoc()): ?>
                <tr>
                    <td><?php echo htmlspecialchars($row['nombre'], ENT_QUOTES, 'UTF-8'); ?></td>
                    <td class="actions">
                        <button class="btn btn-edit" onclick="editarAsignatura('<?php echo htmlspecialchars($row['id'], ENT_QUOTES, 'UTF-8'); ?>', '<?php echo htmlspecialchars($row['nombre'], ENT_QUOTES, 'UTF-8'); ?>')">Editar</button>
                        <button class="btn btn-delete" onclick="eliminarAsignatura('<?php echo htmlspecialchars($row['id'], ENT_QUOTES, 'UTF-8'); ?>')">Eliminar</button>
                    </td>
                </tr>
            <?php endwhile; ?>
        </table>
    </main>
    <script>
        function editarAsignatura(id, nombre) {
            document.getElementById('asignatura_id').value = id;
            document.getElementById('nombre').value = nombre;
            document.getElementById('crear').style.display = 'none';
            document.getElementById('modificar').style.display = 'block';
        }

        function eliminarAsignatura(id) {
            if (confirm('¿Estás seguro de que deseas eliminar esta asignatura?')) {
                var form = document.createElement('form');
                form.method = 'POST';
                form.action = 'add_subject.php';

                var input = document.createElement('input');
                input.type = 'hidden';
                input.name = 'asignatura_id';
                input.value = id;

                var deleteInput = document.createElement('input');
                deleteInput.type = 'hidden';
                deleteInput.name = 'eliminar';
                deleteInput.value = '1';

                form.appendChild(input);
                form.appendChild(deleteInput);

                document.body.appendChild(form);
                form.submit();
            }
        }

        // Validación de formulario para evitar solo espacios en blanco
        function validarFormulario() {
            var nombre = document.getElementById('nombre').value.trim();
            if (nombre === '') {
                alert('El campo de nombre no puede estar vacío o contener solo espacios.');
                return false;
            }
            return true;
        }

        // Mostrar el mensaje flotante y desaparecerlo después de 2 segundos
        window.onload = function() {
            const message = document.querySelector('.mensaje');
            if (message) {
                setTimeout(() => {
                    message.classList.remove('show');
                    setTimeout(() => {
                        message.remove();
                    }, 500); // Espera a que se termine la transición
                }, 2000);
            }
        };
    </script>
</body>
</html>

