<?php
header('Content-Type: text/html; charset=utf-8');

include '../includes/db.php';
include '../includes/auth.php';
checkAuth();

// Obtener cursos
$cursos = $conn->query("SELECT id, nombre FROM curso ORDER BY nombre ASC");

// Variables
$alumnos = [];
$nombre = $apellido_paterno = $apellido_materno = $rut = $curso = $numero_matricula = "";
$anio = date("Y");
$meses = [
    1 => 'enero', 2 => 'febrero', 3 => 'marzo', 4 => 'abril',
    5 => 'mayo', 6 => 'junio', 7 => 'julio', 8 => 'agosto',
    9 => 'septiembre', 10 => 'octubre', 11 => 'noviembre', 12 => 'diciembre'
];
$mes_actual = $meses[(int)date("m")];

// Obtener alumnos según curso
if (isset($_GET['curso_id'])) {
    $curso_id = filter_input(INPUT_GET, 'curso_id', FILTER_VALIDATE_INT);
    if ($curso_id) {
        $alumnos_query = $conn->prepare("
            SELECT id, CONCAT(apellido_paterno, ' ', apellido_materno, ' ', nombre) AS nombre_completo, rut 
            FROM usuario 
            WHERE curso_id = ? 
            AND rol_id = (SELECT id FROM roles WHERE nombre = 'estudiante') 
            ORDER BY apellido_paterno, apellido_materno, nombre
        ");
        $alumnos_query->bind_param("i", $curso_id);
        $alumnos_query->execute();
        $alumnos = $alumnos_query->get_result();
        $alumnos_query->close();
    }
}

// Obtener datos del alumno seleccionado
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['alumno_id'])) {
    $alumno_id = filter_input(INPUT_POST, 'alumno_id', FILTER_VALIDATE_INT);
    $numero_matricula = filter_input(INPUT_POST, 'numero_matricula', FILTER_SANITIZE_SPECIAL_CHARS);

    $stmt = $conn->prepare("
        SELECT nombre, apellido_paterno, apellido_materno, rut, 
               (SELECT nombre FROM curso WHERE id = curso_id) AS curso 
        FROM usuario 
        WHERE id = ?
    ");
    $stmt->bind_param("i", $alumno_id);
    $stmt->execute();
    $stmt->bind_result($nombre, $apellido_paterno, $apellido_materno, $rut, $curso);
    $stmt->fetch();
    $stmt->close();
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Certificado de Alumno Regular</title>
    <link rel="stylesheet" href="../css/certificado.css">
</head>
<body>

    <!-- Insignias -->
    <img src="../images/INSIGNIA SF.png" alt="Insignia Escuela" class="insignia">
    <img src="../images/SLEP.jpeg" alt="Logo SLEP" class="insignia right-insignia">

    <!-- Encabezado -->
    <div class="header-text" style="line-height: 0.5;">
        <p>REPUBLICA DE CHILE</p>
        <p>PROVINCIA DE CAUQUENES</p>
        <p>SERVICIO LOCAL DE EDUCACIÓN PÚBLICA MAULE COSTA</p>
        <p>ESCUELA “PORONGO” F – 654 CAUQUENES</p>
        <p>EBG/emp /24.-</p>
    </div>
     <div class="no-print" style="text-align: center; margin-bottom: 20px;">
    <button onclick="window.location.href='../index.php'">Volver al Inicio</button>
</div>

    <h1 class="no-print">Generar Certificado de Alumno Regular</h1>

    <!-- Formulario de selección de curso -->
    <form method="GET" action="">
        <label for="curso_id">Seleccionar Curso:</label>
        <select id="curso_id" name="curso_id" onchange="this.form.submit()" required>
            <option value="">Seleccione un curso</option>
            <?php while ($curso_row = $cursos->fetch_assoc()): ?>
                <option value="<?= htmlspecialchars($curso_row['id']) ?>"
                    <?= (isset($_GET['curso_id']) && $_GET['curso_id'] == $curso_row['id']) ? 'selected' : '' ?>>
                    <?= htmlspecialchars($curso_row['nombre']) ?>
                </option>
            <?php endwhile; ?>
        </select>
    </form>

    <!-- Formulario de selección de alumno -->
    <?php if (!empty($alumnos)): ?>
        <form method="POST" action="">
            <label for="alumno_id">Seleccionar Alumno:</label>
            <select id="alumno_id" name="alumno_id" required>
                <option value="">Seleccione un alumno</option>
                <?php while ($alumno = $alumnos->fetch_assoc()): ?>
                    <option value="<?= htmlspecialchars($alumno['id']) ?>">
                        <?= htmlspecialchars($alumno['nombre_completo']) ?>
                    </option>
                <?php endwhile; ?>
            </select>

            <label for="numero_matricula">Número de Matrícula:</label>
            <input type="text" name="numero_matricula" id="numero_matricula">

            <button type="submit">Generar Certificado</button>
        </form>
    <?php endif; ?>

    <!-- Certificado generado -->
    <?php if (!empty($nombre)): ?>
        <div class="content">
            <p style="text-align: center; font-weight: bold; font-size: 18px;">CERTIFICADO DE ALUMNO REGULAR</p>
            <p>
                La Directora de la <b>Escuela Porongo F – 654</b> (RBD 3549-1) de Cauquenes, quien suscribe, certifica que:
            </p>
            <p>
                Don(a): <b><?= strtoupper(htmlspecialchars("$nombre $apellido_paterno $apellido_materno")) ?></b>, 
                R.U.N.: <b><?= htmlspecialchars($rut) ?></b>, se encuentra matriculado(a) en este Establecimiento Educacional 
                y asiste regularmente a clases en el curso: <b><?= htmlspecialchars($curso) ?></b>, 
                con el Nº <b><?= htmlspecialchars($numero_matricula) ?></b> del Registro Escolar, Año <b><?= $anio ?></b>.
            </p>
            <p>Se extiende el presente Certificado a petición del interesado(a), para los fines que estime conveniente.</p>
        </div>

    <div class="footer" style="text-align: center; margin-top: 60px;">
    <div>
        <img src="../images/TIMBRE.jpg" alt="Timbre"
             style="height: 85px; margin-bottom: -10px; margin-left: 60px;" class="only-print">
             
        <p style="margin-bottom: 0;">______________________________</p>
        <p><b>ELBA BARRUETO GARRO</b></p>
        <p><b>DIRECTOR(A)</b></p>
        <p><b>ESCUELA PORONGO</b></p>
    </div>
</div>

        <div class="footer" style="text-align: left;">
            <p>Cauquenes, <?= date("d") . " de " . $mes_actual .  " del " . $anio ?>.</p>
        </div>

        <div class="right-align no-print">
            <button onclick="window.print()">Imprimir Certificado</button>
            <button onclick="window.location.href='../index.php'">Volver</button>
        </div>
    <?php endif; ?>

    <!-- Información de contacto -->
    <div class="footer" style="margin-top: 20px; text-align: center;">
        <p>Km 4, camino a Chanco - Cauquenes</p>
        <p>e-mail: porongo@slepmc.cl</p>
        <p>Teléfono: +56442857313</p>
    </div>

</body>
</html>
