<?php
header('Content-Type: text/html; charset=utf-8');

include '../includes/db.php';
include '../includes/auth.php';
checkAuth();

$conn->set_charset("utf8");

$alumno_id = isset($_GET['alumno_id']) ? intval($_GET['alumno_id']) : null;
$curso_id = isset($_GET['curso_id']) ? intval($_GET['curso_id']) : null;
$semestre = isset($_GET['semestre']) ? $_GET['semestre'] : 'all';

if (!$alumno_id || !$curso_id) {
    die('No se proporcionó un ID de alumno o curso');
}

// Obtener información completa del alumno
$stmt = $conn->prepare("SELECT usuario.rut, 
                               CONCAT(usuario.nombre, ' ', usuario.apellido_paterno, ' ', usuario.apellido_materno) AS nombre_completo, 
                               curso.nombre as curso
                        FROM usuario 
                        JOIN curso ON usuario.curso_id = curso.id
                        WHERE usuario.id = ? 
                        AND usuario.rol_id = (SELECT id FROM roles WHERE nombre = 'estudiante')");
$stmt->bind_param('i', $alumno_id);
$stmt->execute();
$alumno = $stmt->get_result()->fetch_assoc();
$stmt->close();

if (!$alumno) {
    die('Alumno no encontrado');
}

// Obtener el nombre completo del profesor jefe
$stmt = $conn->prepare("SELECT CONCAT(usuario.nombre, ' ', usuario.apellido_paterno, ' ', usuario.apellido_materno) AS nombre_completo 
                        FROM usuario 
                        JOIN curso ON curso.profesor_jefe_id = usuario.id 
                        WHERE curso.id = ?");
$stmt->bind_param('i', $curso_id);
$stmt->execute();
$profesor_jefe = $stmt->get_result()->fetch_assoc();
$stmt->close();

if (!$profesor_jefe) {
    die('Profesor jefe no encontrado');
}

// Obtener las notas del alumno, incluyendo las asignaturas con indicadores
$where_clause = $semestre === 'all' ? '' : "AND (notas.semestre = ? OR notas_indicadores.semestre = ?)";

$sql = "
    SELECT * FROM (
        SELECT asignatura.nombre AS asignatura, 
               notas.nota, 
               NULL AS indicador, 
               notas.numero_nota, 
               notas.semestre 
        FROM notas 
        JOIN asignatura ON notas.asignatura_id = asignatura.id 
        WHERE notas.usuario_id = ? AND notas.semestre = ?

        UNION

        SELECT asignatura.nombre AS asignatura, 
               NULL AS nota, 
               indicadores.nombre AS indicador, 
               notas_indicadores.numero_nota, 
               notas_indicadores.semestre 
        FROM notas_indicadores 
        JOIN asignatura ON notas_indicadores.asignatura_id = asignatura.id 
        JOIN indicadores ON notas_indicadores.indicador_id = indicadores.id 
        WHERE notas_indicadores.usuario_id = ? AND notas_indicadores.semestre = ?
    ) AS combined_results
    ORDER BY asignatura, numero_nota";

// Preparar la consulta
if ($semestre === 'all') {
    $stmt = $conn->prepare($sql);
    $stmt->bind_param('ii', $alumno_id, $alumno_id);
} else {
    $stmt = $conn->prepare($sql);
    $stmt->bind_param('iiii', $alumno_id, $semestre, $alumno_id, $semestre);
}
$stmt->execute();
$notas = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
$stmt->close();

// Organizar las notas por asignatura y semestre
$notas_por_asignatura = [];
foreach ($notas as $nota) {
    $notas_por_asignatura[$nota['asignatura']][$nota['semestre']][$nota['numero_nota']] = $nota['nota'] ?? $nota['indicador'];
}

// Calcular promedios
function calcular_promedio($notas) {
    if (empty($notas)) {
        return 0; // Devuelve 0 si no hay notas
    }
    return number_format(array_sum($notas) / count($notas), 1);
}
// Función para calcular el promedio de indicadores y devolver el indicador correspondiente
function promedio_indicadores($indicadores) {
    $puntajes = [];
    foreach ($indicadores as $indicador) {
        switch ($indicador) {
            case 'MB':
                $puntajes[] = 7.0;
                break;
            case 'B':
                $puntajes[] = 5.5; // Promedio para 'B' entre 5.0 y 5.9
                break;
            case 'S':
                $puntajes[] = 4.5; // Promedio para 'S' entre 4.0 y 4.9
                break;
            case 'I':
                $puntajes[] = 2.5; // Promedio para 'I' entre 1.0 y 3.9
                break;
        }
    }

    // Calcular el promedio numérico de los puntajes
    $promedio = calcular_promedio($puntajes);

    // Devolver el indicador correspondiente basado en el promedio
    if ($promedio >= 6.0) {
        return 'MB';
    } elseif ($promedio >= 5.0) {
        return 'B';
    } elseif ($promedio >= 4.0) {
        return 'S';
    } else {
        return 'I';
    }
}

// Meses y días en español
$meses = [
    'January' => 'Enero',
    'February' => 'Febrero',
    'March' => 'Marzo',
    'April' => 'Abril',
    'May' => 'Mayo',
    'June' => 'Junio',
    'July' => 'Julio',
    'August' => 'Agosto',
    'September' => 'Septiembre',
    'October' => 'Octubre',
    'November' => 'Noviembre',
    'December' => 'Diciembre',
];

$dias = [
    'Monday' => 'Lunes',
    'Tuesday' => 'Martes',
    'Wednesday' => 'Miércoles',
    'Thursday' => 'Jueves',
    'Friday' => 'Viernes',
    'Saturday' => 'Sábado',
    'Sunday' => 'Domingo',
];

// Obtener la fecha actual con el formato deseado
$dia_semana = $dias[date('l')]; // Día de la semana en español
$dia_numero = date('d'); // Número del día
$mes_actual = $meses[date('F')]; // Mes en español
$anio_actual = date('Y'); // Año actual

$fecha_actual = "$dia_semana, $dia_numero de $mes_actual de $anio_actual"; // Formato final de la fecha

// Inicializar variables para asistencia
$dias_totales = 0;
$dias_asistidos = 0;
$dias_no_asistidos = 0;

// Procesar asistencia si se envían datos
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $dias_totales = intval($_POST['dias_totales']);
    $dias_asistidos = intval($_POST['dias_asistidos']);
    $dias_no_asistidos = $dias_totales - $dias_asistidos; // Cálculo automático
}

$porcentaje_asistencia = $dias_totales > 0 ? number_format(($dias_asistidos / $dias_totales) * 100, 2) : 0;
setlocale(LC_TIME, 'es_ES.UTF-8');
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Informe de Notas</title>
    <link href="https://fonts.googleapis.com/css?family=Roboto:400,700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="../css/certificado_notas.css">
    <style>
        /* Mostrar el encabezado solo en pantalla, ocultarlo al imprimir */
.header-doble-logo {
    display: block; /* Mostrar en pantalla */
}

/* Estilos para la impresión */
@media print {
    /* Ocultar los logos y el título al imprimir */
    .header-doble-logo {
        display: none; /* Ocultar el encabezado durante la impresión */
    }

    /* Asegurar que el salto de página ocurra antes de cada estudiante */
    .alumno-informe {
        page-break-before: always; /* Salto de página antes de cada estudiante */
    }

    /* Ajuste de márgenes para asegurar que no se sobrepongan elementos */
    .container {
        margin-top: 0; /* No es necesario espacio extra, ya que no hay encabezado */
    }

    /* Eliminar bordes del botón de impresión */
    .right-align button {
        display: none;
    }

    /* Asegurar que los contenidos se ajusten bien dentro de la página */
    body {
        width: 100%; /* Asegura que el cuerpo ocupe todo el ancho */
        overflow-x: hidden; /* Evita que el contenido se desborde horizontalmente */
    }
    .no-imprimir {
        display: none !important;
    }
    .mensaje-flotante {
        display: none !important;
    }
}
    </style>
</head>
<body>
    <div class="mensaje-flotante" id="mensajeNota">
    <span class="cerrar" onclick="this.parentElement.style.display='none';">&times;</span>
    <strong>Nota importante:</strong><br>
    Para que el informe quede en una hoja, debe cambiar la escala de impresión a un <strong>75%</strong><br>
    De lo contrario el informe ocupará 2 hojas.
</div>
    <header class="header-doble-logo">
    
        <img src="../images/INSIGNIA%20SF.png" alt="Logo Izquierdo">
    

    <h1>Informe de Notas</h1>
        <nav>
            <ul>
                <li><a href="../index.php">Inicio</a></li>
                <li><a href="select_report.php">Volver</a></li>
            </ul>
        </nav>

</header>
    <div class="container">
        
            <!-- Logos y título dentro del informe de cada alumno -->
        <div class="header-doble-logo" style="display:flex; align-items:center; justify-content:space-between; margin-bottom: 15px;">
            <div class="logo-izquierdo">
                <img src="../images/INSIGNIA%20SF.png" alt="Logo Izquierdo" style="height: 60px;">
            </div>
            <div class="titulo-centro" style="text-align:center; flex-grow:1;">
                <h1 style="margin:0;">Informe de Notas</h1>
            </div>
            <div class="logo-derecho">
                <img src="../images/SLEP.jpeg" alt="Logo Derecho" style="height: 60px;">
            </div>
        </div>
        <div class="header-impresion">
    <div class="info-alumno">
        <strong>RUT:</strong> <?php echo htmlspecialchars($alumno['rut'], ENT_QUOTES, 'UTF-8'); ?><br>
        <strong>Alumno:</strong> <?php echo htmlspecialchars($alumno['nombre_completo'], ENT_QUOTES, 'UTF-8'); ?><br>
        <strong>Curso:</strong> <?php echo htmlspecialchars($alumno['curso'], ENT_QUOTES, 'UTF-8'); ?><br>
        <strong>Profesor Jefe:</strong> <?php echo htmlspecialchars($profesor_jefe['nombre_completo'], ENT_QUOTES, 'UTF-8'); ?>
    </div>

    <div class="info-semestre">
        <strong>Notas Parciales:</strong> <?php echo ($semestre == 2) ? 'Segundo Semestre' : 'Primer Semestre'; ?><br>
    
    <div class="ocultar-fecha">
    <strong>Fecha:</strong> <?php echo ucfirst(strftime('%A, %e de %B de %Y')); ?><br>  
</div>
        </div>
</div>
        <table>
            <thead>
                <tr>
                    <th>Asignaturas</th>
                    <?php for ($i = 1; $i <= 10; $i++): ?>
                        <th>N<?php echo $i; ?></th>
                    <?php endfor; ?>
                    <th>Promedio Parcial</th>
                </tr>
            </thead>
            <tbody>
                <?php
                // Orden deseado de las asignaturas
$orden_asignaturas = [
    'Lengua y Literatura',
    'Lenguaje y Comunicación',
    'Inglés',
    'Matemática',
    'Ciencias Naturales',
    'Historia, Geografía y Ciencias Sociales',
    'Tecnología',
    'Artes Visuales',
    'Música',
    'Educación Física y Salud',
    'Orientación',
    'Religión'  
];

// Reordenar las asignaturas en base al orden personalizado
$notas_ordenadas = [];
foreach ($orden_asignaturas as $asig_nombre) {
    if (isset($notas_por_asignatura[$asig_nombre])) {
        $notas_ordenadas[$asig_nombre] = $notas_por_asignatura[$asig_nombre];
    }
}

                // Inicializar un array para promedios finales
                $promedios_finales = [];
                foreach ($notas_ordenadas as $asignatura => $semestres): ?>
                    <tr>
                        <td><?php echo htmlspecialchars($asignatura, ENT_QUOTES, 'UTF-8'); ?></td>
                        <?php 
                        $notas_semestre1 = isset($semestres[1]) ? $semestres[1] : [];
                        $notas_semestre2 = isset($semestres[2]) ? $semestres[2] : [];
                        
                        $promedio_final = '';
                        if ($semestre == 1) {
                            $promedio_final = calcular_promedio($notas_semestre1);
                        } elseif ($semestre == 2) {
                            $promedio_final = calcular_promedio($notas_semestre2);
                        } else { // Si se pide todos los semestres
                            $promedio_final = calcular_promedio(array_merge($notas_semestre1, $notas_semestre2));
                        }

                    
                        // Inicializar variables para indicadores parciales
                        $indicador_parcial1 = '';
                        $indicador_parcial2 = '';
                        
                        // Excluir "Religión" y "Orientación" del promedio total
                        if ($asignatura !== 'Religión' && $asignatura !== 'Orientación') {
                            if ($promedio_final !== '') {
                                $promedios_finales[] = $promedio_final;
                            }
                        }
                        // Solo calcular indicadores para "Religión" y "Orientación"
                    if ($asignatura === 'Religión') {
                        $indicador_parcial1 = promedio_indicadores($notas_semestre1);
                        $indicador_parcial2 = promedio_indicadores($notas_semestre2);
                    } elseif ($asignatura === 'Orientación') {
                        $indicador_parcial1 = promedio_indicadores($notas_semestre1);
                        $indicador_parcial2 = promedio_indicadores($notas_semestre2);
                    }
                        


                        for ($i = 1; $i <= 10; $i++): ?>
                        <td>
                            <?php 
                            // Mostrar la nota o el indicador correspondiente
                            if ($asignatura === 'Religión' || $asignatura === 'Orientación') {
                                if (isset($notas_semestre1[$i])) {
                                    echo htmlspecialchars($notas_semestre1[$i], ENT_QUOTES, 'UTF-8');
                                } elseif (isset($notas_semestre2[$i])) {
                                    echo htmlspecialchars($notas_semestre2[$i], ENT_QUOTES, 'UTF-8');
                                } else {
                                    echo '—';
                                }
                            } else {
                                // Mostrar la nota numérica para otras asignaturas
                                if (isset($notas_semestre1[$i])) {
                                    echo htmlspecialchars($notas_semestre1[$i], ENT_QUOTES, 'UTF-8');
                                } elseif (isset($notas_semestre2[$i])) {
                                    echo htmlspecialchars($notas_semestre2[$i], ENT_QUOTES, 'UTF-8');
                                } else {
                                    echo '—';
                                }
                            }
                                ?>
                            </td>
                        <?php endfor; ?>
                        <td><?php 
// Mostrar el promedio o indicador para "Religión" y "Orientación"
if ($asignatura === 'Religión') {
    if (!empty($notas_semestre1)) {
        echo $indicador_parcial1; // Mostrar el indicador para el primer semestre
    } else {
        echo ''; // Si no hay notas en el primer semestre, mostrar un guion
    }
    
    // Comprobar si hay notas en el segundo semestre
    if (!empty($notas_semestre2)) {
        echo '' . $indicador_parcial2; // Mostrar el indicador para el segundo semestre
    } else {
        echo ' '; // Si no hay notas en el segundo semestre, mostrar un guion
    }
    
} elseif ($asignatura === 'Orientación') {
    if (!empty($notas_semestre1)) {
        echo $indicador_parcial1; // Mostrar el indicador para el primer semestre
    } else {
        echo ''; // Si no hay notas en el primer semestre, mostrar un guion
    }
    
    // Comprobar si hay notas en el segundo semestre
    if (!empty($notas_semestre2)) {
        echo ' ' . $indicador_parcial2; // Mostrar el indicador para el segundo semestre
    } else {
        echo ' '; // Si no hay notas en el segundo semestre, mostrar un guion
    }
    
} else {
    // Para otras asignaturas, calcular y mostrar el promedio
    echo htmlspecialchars(calcular_promedio(array_filter(array_merge($notas_semestre1, $notas_semestre2))), ENT_QUOTES, 'UTF-8'); 
}
?></td>
                       
                    </tr>
                <?php endforeach; ?>
            </tbody>
            <tfoot>
                <tr>
                    <td><strong>Promedio Total</strong></td>
                    <td colspan="10"></td>
                    <td><strong><?php echo calcular_promedio($promedios_finales); ?></strong></td>
                </tr>
            </tfoot>
        </table>

        <!-- Sección de entrada de asistencia -->
        <div class="asistencia-info">
            <h3>Registro de Asistencia</h3>
            <form method="POST" action="">
                <label for="dias_totales">Días Totales:</label>
                <input type="number" name="dias_totales" id="dias_totales" value="<?php echo $dias_totales; ?>" required>
                
                <label for="dias_asistidos">Días Asistidos:</label>
                <input type="number" name="dias_asistidos" id="dias_asistidos" value="<?php echo $dias_asistidos; ?>" required>
                
                <button type="submit">Calcular Asistencia</button>
            </form>
        </div>

        <!-- Resultados de asistencia -->
        <div class="asistencia-results">
            <h3>Resultados de Asistencia</h3>
            <p>Días Totales: <?php echo $dias_totales; ?></p>
            <p>Días Asistidos: <?php echo $dias_asistidos; ?></p>
            <p>Días No Asistidos: <?php echo $dias_no_asistidos; ?></p>
            <p>Porcentaje de Asistencia: <?php echo $porcentaje_asistencia; ?>%</p>
        </div>

        <div class="observation-section">
            <label for="observaciones">Observaciones:</label>
            <textarea id="observaciones" name="observaciones" placeholder="Escribe aquí cualquier observación..."></textarea>
        </div>

        <div class="signature-section">
            <strong>Cauquenes, <?php echo $fecha_actual; ?></strong> <!-- Fecha actual -->
        </div>

        <div class="signatures">
            <div class="signature">
                <strong>_________________________</strong><br>
                <strong>Firma del Profesor Jefe</strong>
            </div>
            <div class="utp-signature">
                <strong>Visto Bueno UTP</strong> <!-- Aquí no hay línea, ya que es para timbre -->
            </div>
        </div>

        <div class="right-align">
            <button onclick="window.print()">Imprimir Informe</button>
        </div>
    </div>
</body>
</html>
