<?php
header('Content-Type: text/html; charset=utf-8'); // Establecer la codificación de caracteres a UTF-8

include '../includes/db.php'; // Incluir la conexión a la base de datos
include '../includes/auth.php'; // Incluir funciones de autenticación
checkAuth(); // Verificar si el usuario está autenticado, redirigiendo si no lo está

// Obtener la lista de cursos en los que hay estudiantes activos
$stmt = $conn->prepare("SELECT DISTINCT curso.id, curso.nombre 
                        FROM usuario 
                        JOIN curso ON usuario.curso_id = curso.id 
                        WHERE usuario.rol_id = (SELECT id FROM roles WHERE nombre = 'estudiante')
                        AND usuario.activo = 1
                        AND curso.activo = 1
                        ORDER BY curso.nombre ASC"); // Ordenar por el nombre del curso en orden ascendente
$stmt->execute(); // Ejecutar la consulta
$cursos = $stmt->get_result(); // Obtener los resultados

// Obtener la lista de años en los que hay notas
$stmt_years = $conn->prepare("SELECT DISTINCT YEAR(fecha) AS anio FROM notas ORDER BY anio DESC");
$stmt_years->execute();
$years = $stmt_years->get_result(); // Obtener los resultados de los años

// Obtener la lista de alumnos si un curso ha sido seleccionado
$alumnos = [];
if (isset($_GET['curso_id'])) { // Verificar si se ha seleccionado un curso
    $curso_id = filter_input(INPUT_GET, 'curso_id', FILTER_VALIDATE_INT); // Validar el ID del curso
    if ($curso_id) { // Si el ID del curso es válido
        // Ajustar la consulta para ordenar por apellido paterno, luego materno y al final nombre
        $stmt = $conn->prepare("SELECT id, CONCAT(apellido_paterno, ' ', apellido_materno, ' ', nombre) AS nombre_completo 
                                FROM usuario 
                                WHERE curso_id = ? 
                                AND rol_id = (SELECT id FROM roles WHERE nombre = 'estudiante') 
                                AND activo = 1
                                ORDER BY apellido_paterno, apellido_materno, nombre"); // Agregar ordenamiento
        $stmt->bind_param("i", $curso_id); // Vincular el parámetro del curso
        $stmt->execute(); // Ejecutar la consulta
        $alumnos = $stmt->get_result(); // Obtener los resultados
    }
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Generar Informes</title>
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Roboto:400,700&display=swap"> <!-- Fuente moderna -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
    <link rel="stylesheet" href="../css/select_report.css">
</head>
<body>
    <header>
        <img src="../images/INSIGNIA%20SF.png" alt="Logo de la Empresa">
        <h1>Generar Informe de Notas</h1>
        <nav>
            <ul>
                <li><a href="../index.php">Inicio</a></li>
            </ul>
        </nav>
    </header>

    <div class="container">
        <!-- Sección para seleccionar el curso -->
        <form method="GET" action="select_report.php">
            <label for="curso_id">Seleccionar Curso:</label>
            <select id="curso_id" name="curso_id" onchange="this.form.submit()">
                <option value="">Seleccione un curso</option>
                <?php while ($curso = $cursos->fetch_assoc()): ?>
                    <option value="<?php echo htmlspecialchars($curso['id'], ENT_QUOTES, 'UTF-8'); ?>" <?php if (isset($_GET['curso_id']) && $_GET['curso_id'] == $curso['id']) echo 'selected'; ?>>
                        <?php echo htmlspecialchars($curso['nombre'], ENT_QUOTES, 'UTF-8'); ?>
                    </option>
                <?php endwhile; ?>
            </select>
        </form>

        <!-- Sección para generar los informes de manera individual -->
        <?php if ($alumnos && $alumnos->num_rows > 0): ?>
            <form method="GET" action="reports.php">
                <input type="hidden" name="curso_id" value="<?php echo htmlspecialchars($_GET['curso_id'], ENT_QUOTES, 'UTF-8'); ?>">

                <label for="alumno">Seleccionar Alumno:</label>
                <select id="alumno" name="alumno_id" required>
                    <option value="">Seleccione un alumno</option>
                    <?php while ($alumno = $alumnos->fetch_assoc()): ?>
                        <option value="<?php echo htmlspecialchars($alumno['id'], ENT_QUOTES, 'UTF-8'); ?>"><?php echo htmlspecialchars($alumno['nombre_completo'], ENT_QUOTES, 'UTF-8'); ?></option>
                    <?php endwhile; ?>
                </select>

                <label for="semestre">Seleccionar Semestre:</label>
                <select id="semestre" name="semestre" required>
                    <option value="1">Primer Semestre</option>
                    <option value="2">Segundo Semestre</option>
                </select>

                <!-- Seleccionar Año -->
                <label for="anio">Seleccionar Año:</label>
                <select id="anio" name="anio" required>
                    <option value="">Seleccione un año</option>
                    <?php 
                    // Volver a ejecutar la consulta de años para asegurarse de que esté disponible
                    $stmt_years->execute();
                    $years = $stmt_years->get_result();
                    while ($year = $years->fetch_assoc()): ?>
                        <option value="<?php echo htmlspecialchars($year['anio'], ENT_QUOTES, 'UTF-8'); ?>"><?php echo htmlspecialchars($year['anio'], ENT_QUOTES, 'UTF-8'); ?></option>
                    <?php endwhile; ?>
                </select>

                <button type="submit">Generar Informe Individual</button>
            </form>
        <?php endif; ?>

        <!-- Sección para generar los informes de todos los alumnos -->
        <?php if ($alumnos && $alumnos->num_rows > 0): ?>
            <form method="GET" action="reports_all.php">
                <input type="hidden" name="curso_id" value="<?php echo htmlspecialchars($_GET['curso_id'], ENT_QUOTES, 'UTF-8'); ?>">

                <label for="semestre">Seleccionar Semestre:</label>
                <select id="semestre" name="semestre" required>
                    <option value="1">Primer Semestre</option>
                    <option value="2">Segundo Semestre</option>
                </select>

                <!-- Seleccionar Año -->
                <label for="anio">Seleccionar Año:</label>
                <select id="anio" name="anio" required>
                    <option value="">Seleccione un año</option>
                    <?php 
                    // Volver a ejecutar la consulta de años para asegurarse de que esté disponible
                    $stmt_years->execute();
                    $years = $stmt_years->get_result();
                    while ($year = $years->fetch_assoc()): ?>
                        <option value="<?php echo htmlspecialchars($year['anio'], ENT_QUOTES, 'UTF-8'); ?>"><?php echo htmlspecialchars($year['anio'], ENT_QUOTES, 'UTF-8'); ?></option>
                    <?php endwhile; ?>
                </select>

                <button type="submit">Generar Todos los Informes</button>
            </form>
        <?php endif; ?>
        
    </div>
</body>
</html>
