<?php
header('Content-Type: text/html; charset=utf-8'); // Establecer la codificación de caracteres a UTF-8

include '../includes/db.php'; // Incluir la conexión a la base de datos
include '../includes/auth.php'; // Incluir autenticación
checkAuth(); // Verificar autenticación

// Obtener la lista de cursos
$cursos = $conn->query("SELECT id, nombre FROM curso ORDER BY nombre ASC");

// Variables
$alumnos = [];
$nombre = $apellido_paterno = $apellido_materno = $rut = $curso = $porcentaje_asistencia = $nuevo_colegio = $nombre_apoderado = $rut_apoderado = $tipo_establecimiento = $titulo_apoderado = "";
$anio = date("Y"); // Año actual generado automáticamente
$meses = [
    1 => 'enero',
    2 => 'febrero',
    3 => 'marzo',
    4 => 'abril',
    5 => 'mayo',
    6 => 'junio',
    7 => 'julio',
    8 => 'agosto',
    9 => 'septiembre',
    10 => 'octubre',
    11 => 'noviembre',
    12 => 'diciembre'
];
$mes_actual = $meses[(int)date("m")]; // Obtener el mes actual en español

// Seleccionar curso y obtener lista de alumnos
if (isset($_GET['curso_id'])) {
    $curso_id = filter_input(INPUT_GET, 'curso_id', FILTER_VALIDATE_INT);
    if ($curso_id) {
        // Ajustar la consulta para ordenar por apellido paterno, luego materno y al final nombre
        $alumnos_query = $conn->prepare("SELECT id, CONCAT(apellido_paterno, ' ', apellido_materno, ' ', nombre) AS nombre_completo, rut 
                                          FROM usuario 
                                          WHERE curso_id = ? 
                                          AND rol_id = (SELECT id FROM roles WHERE nombre = 'estudiante') 
                                          ORDER BY apellido_paterno, apellido_materno, nombre"); // Agregar ordenamiento
        $alumnos_query->bind_param("i", $curso_id);
        $alumnos_query->execute();
        $alumnos = $alumnos_query->get_result();
        $alumnos_query->close();
    }
}

// Seleccionar alumno y generar certificado
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['alumno_id'])) {
    $alumno_id = filter_input(INPUT_POST, 'alumno_id', FILTER_VALIDATE_INT);
    $porcentaje_asistencia = filter_input(INPUT_POST, 'porcentaje_asistencia', FILTER_SANITIZE_SPECIAL_CHARS);
    $nuevo_colegio = filter_input(INPUT_POST, 'nuevo_colegio', FILTER_SANITIZE_SPECIAL_CHARS);
    $nombre_apoderado = filter_input(INPUT_POST, 'nombre_apoderado', FILTER_SANITIZE_SPECIAL_CHARS);
    $rut_apoderado = filter_input(INPUT_POST, 'rut_apoderado', FILTER_SANITIZE_SPECIAL_CHARS);
    $fecha_certificado = filter_input(INPUT_POST, 'fecha_certificado', FILTER_SANITIZE_SPECIAL_CHARS); // Fecha ingresada
    $titulo_apoderado = filter_input(INPUT_POST, 'titulo_apoderado', FILTER_SANITIZE_SPECIAL_CHARS); // Título del apoderado
    $tipo_establecimiento = filter_input(INPUT_POST, 'tipo_establecimiento', FILTER_SANITIZE_SPECIAL_CHARS); // Tipo de establecimiento

    // Obtener los datos del alumno
    $stmt = $conn->prepare("SELECT nombre, apellido_paterno, apellido_materno, rut, (SELECT nombre FROM curso WHERE id = curso_id) AS curso FROM usuario WHERE id = ?");
    $stmt->bind_param("i", $alumno_id);
    $stmt->execute();
    $stmt->bind_result($nombre, $apellido_paterno, $apellido_materno, $rut, $curso);
    $stmt->fetch();
    $stmt->close();
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="../css/certificado_traslado.css">
    <title>Certificado de Traslado</title>
    <style>
    </style>
</head>
<body>
    <!-- Insignia de la escuela -->
    <img src="../images/INSIGNIA SF.png" alt="Escuela Porongo Insignia" class="insignia">
    <img src="../images/SLEP.jpeg" alt="Escuela Porongo Insignia" class="insignia right-insignia">

    <!-- Texto centrado -->
    <div class="header-text" style="line-height: 0.5;">
    <p>REPUBLICA DE CHILE</p>
    <p>PROVINCIA DE CAUQUENES</p>
    <p>SERVICIO LOCAL DE EDUCACIÓN PÚBLICA MAULE COSTA</p>
    <p>ESCUELA “PORONGO” F – 654 CAUQUENES</p>
    <p>EBG/emp /24.-</p>
    </div>
    <div class="no-print" style="text-align: center; margin-bottom: 20px;">
    <button onclick="window.location.href='../index.php'">Volver al Inicio</button>
</div>
    <h1 class="no-print">Generar Certificado de Traslado</h1>

    <!-- Seleccionar curso -->
    <form method="GET" action="">
        <label for="curso_id">Seleccionar Curso:</label>
        <select id="curso_id" name="curso_id" onchange="this.form.submit()" required>
            <option value="">Seleccione un curso</option>
            <?php while ($curso_row = $cursos->fetch_assoc()): ?>
                <option value="<?php echo htmlspecialchars($curso_row['id'], ENT_QUOTES, 'UTF-8'); ?>" <?php if (isset($_GET['curso_id']) && $_GET['curso_id'] == $curso_row['id']) echo 'selected'; ?>>
                    <?php echo htmlspecialchars($curso_row['nombre'], ENT_QUOTES, 'UTF-8'); ?>
                </option>
            <?php endwhile; ?>
        </select>
    </form>

    <!-- Seleccionar alumno solo si se ha seleccionado un curso -->
    <?php if (!empty($alumnos)): ?>
    <form method="POST" action="">
        <label for="alumno_id">Seleccionar Alumno:</label>
        <select id="alumno_id" name="alumno_id" required>
            <option value="">Seleccione un alumno</option>
            <?php while ($alumno = $alumnos->fetch_assoc()): ?>
                <option value="<?php echo htmlspecialchars($alumno['id'], ENT_QUOTES, 'UTF-8'); ?>">
                    <?php echo htmlspecialchars($alumno['nombre_completo'], ENT_QUOTES, 'UTF-8'); ?>
                </option>
            <?php endwhile; ?>
        </select>

        <label for="titulo_apoderado">Título del Apoderado:</label>
        <select id="titulo_apoderado" name="titulo_apoderado" required>
            <option value="">Seleccione</option>
            <option value="Sra.">Sra.</option>
            <option value="Srta.">Srta.</option>
            <option value="Sr.">Sr.</option>
        </select>

        <label for="nombre_apoderado">Nombre del Apoderado:</label>
        <input type="text" name="nombre_apoderado" id="nombre_apoderado" required>

        <label for="rut_apoderado">RUT del Apoderado:</label>
        <input type="text" name="rut_apoderado" id="rut_apoderado" required>

        <label for="porcentaje_asistencia">Porcentaje de Asistencia:</label>
        <input type="number" name="porcentaje_asistencia" id="porcentaje_asistencia" min="0" max="100" required>

        <label for="nuevo_colegio">Nuevo Colegio:</label>
        <input type="text" name="nuevo_colegio" id="nuevo_colegio" required>

        <label for="tipo_establecimiento">Tipo de Establecimiento:</label>
        <select id="tipo_establecimiento" name="tipo_establecimiento" required>
            <option value="">Seleccione</option>
            <option value="Escuela">Escuela</option>
            <option value="Colegio">Colegio</option>
            <option value="Liceo">Liceo</option>
        </select>

        <label for="fecha_certificado">Fecha del Certificado:</label>
        <input type="date" name="fecha_certificado" id="fecha_certificado" required>

        <button type="submit">Generar Certificado</button>
    </form>
    <?php endif; ?>

    <!-- Certificado generado si se selecciona un alumno -->
    <?php if (!empty($nombre)): ?>
        <div class="content">
            <p style="text-align: center; font-weight: bold; font-size: 18px;">
                CERTIFICADO DE TRASLADO
            </p>
            <p style="line-height: 1.5;">
                La Directora de la Escuela Porongo F-654 quién suscribe, certifica que <b><?php echo htmlspecialchars(strtoupper($nombre . " " . $apellido_paterno . " " . $apellido_materno), ENT_QUOTES, 'UTF-8'); ?></b>, 
                R.U.N.: <b><?php echo htmlspecialchars($rut, ENT_QUOTES, 'UTF-8'); ?></b>, actualmente se encuentra matriculado(a) en este establecimiento educacional en <b><?php echo htmlspecialchars($curso, ENT_QUOTES, 'UTF-8'); ?></b>, 
                para el registro <b><?php echo $anio; ?></b>, y con fecha <b><?php echo date("d", strtotime($fecha_certificado)) . " de " . $mes_actual; ?></b>, su apoderado(a), <b><?php echo htmlspecialchars($titulo_apoderado . ' ' . $nombre_apoderado, ENT_QUOTES, 'UTF-8'); ?></b>, 
                R.U.N.: <b><?php echo htmlspecialchars($rut_apoderado, ENT_QUOTES, 'UTF-8'); ?></b>, ha solicitado la cancelación de matrícula, aduciendo como motivo el cambio de escuela a <b><?php echo htmlspecialchars($tipo_establecimiento . " " . $nuevo_colegio, ENT_QUOTES, 'UTF-8'); ?></b> de esta ciudad.
                <br>La asistencia en lo que va corrido del año, es del <b><?php echo htmlspecialchars($porcentaje_asistencia, ENT_QUOTES, 'UTF-8'); ?>%</b>.
            </p>

        </div>

        <div class="footer" style="text-align: center; margin-top: 60px;">
    <div>
        <img src="../images/TIMBRE.jpg" alt="Timbre"
             style="height: 85px; margin-bottom: -10px; margin-left: 60px;" class="only-print">
             
        <p style="margin-bottom: 0;">______________________________</p>
        <p><b>ELBA BARRUETO GARRO</b></p>
        <p><b>DIRECTOR(A)</b></p>
        <p><b>ESCUELA PORONGO</b></p>
    </div>
</div>

        <div class="footer" style="text-align: left;">
        <p>Cauquenes, <?php echo date("d", strtotime($fecha_certificado)) . " de " . $mes_actual . " de " . $anio; ?>.</p>
        </div>

        <div class="right-align no-print">
            <button onclick="window.print()">Imprimir Certificado</button>
            <button onclick="window.location.href='../index.php'">Volver</button>
        </div>
    <?php endif; ?>

    <!-- Información de contacto al final -->
    <div class="footer" style="margin-top: 20px; text-align: center;">
        <p>Km 4, camino a Chanco - Cauquenes</p>
        <p>e-mail: porongo@slepmc.cl</p>
        <p>Teléfono: +56442857313</p>
    </div>

</body>
</html>
