<?php
header('Content-Type: text/html; charset=utf-8');
include '../includes/db.php';
include '../includes/auth.php';
checkAuth();

if (!isAdmin()) { header("Location: ../index.php"); exit(); }
$conn->set_charset("utf8mb4");

$message = '';
$message_type = '';

function guardarCurso($conn, $nombre, $profesor_jefe_id, $id = null) {
    global $message, $message_type;

    if ($id) {
        // Si el $id está presente, se realiza una actualización
        $stmt = $conn->prepare("UPDATE curso SET nombre = ?, profesor_jefe_id = ? WHERE id = ?");
        $stmt->bind_param("sii", $nombre, $profesor_jefe_id, $id);
    } else {
        // Si el $id no está presente, se realiza una inserción
        $stmt = $conn->prepare("INSERT INTO curso (nombre, profesor_jefe_id) VALUES (?, ?)");
        $stmt->bind_param("si", $nombre, $profesor_jefe_id);
    }

    if ($stmt->execute()) {
        $message = $id ? 'Curso modificado' : 'Curso agregado';
        $message_type = 'success';
    } else {
        $message = 'Error al guardar el curso';
        $message_type = 'error';
    }

    $stmt->close();
}



function eliminarCurso($conn, $curso_id) {
    global $message, $message_type;
    // Eliminar solo el curso, sin eliminar las notas ni los estudiantes
    $stmt = $conn->prepare("DELETE FROM curso WHERE id = ?");
    $stmt->bind_param("i", $curso_id);
    $message = $stmt->execute() ? 'Curso eliminado' : 'Error al eliminar curso';
    $message_type = $stmt->affected_rows ? 'success' : 'error';
    $stmt->close();
}

function cambiarEstadoCurso($conn, $curso_id, $estado) {
    global $message, $message_type;
    $stmt = $conn->prepare("UPDATE curso SET activo = ? WHERE id = ?");
    $stmt->bind_param("ii", $estado, $curso_id);
    $message = $stmt->execute() ? 'Estado del curso actualizado' : 'Error al cambiar el estado del curso';
    $message_type = $stmt->execute() ? 'success' : 'error';
    $stmt->close();
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    if (isset($_POST['eliminar'])) {
        $curso_id = intval($_POST['curso_id'] ?? '');
        if ($curso_id) eliminarCurso($conn, $curso_id);
    } elseif (isset($_POST['estado'])) {
        $curso_id = intval($_POST['curso_id'] ?? '');
        $estado = intval($_POST['estado']);
        if ($curso_id) cambiarEstadoCurso($conn, $curso_id, $estado);
    } else {
        $nombre = trim($_POST['nombre'] ?? '');
        $profesor_jefe_id = intval($_POST['profesor_jefe_id'] ?? 0);
        if ($nombre && $profesor_jefe_id) {
            isset($_POST['crear']) ? guardarCurso($conn, $nombre, $profesor_jefe_id) : guardarCurso($conn, $nombre, $profesor_jefe_id, $_POST['curso_id']);
        } else {
            $message = 'Error: El nombre del curso y el profesor jefe no pueden estar vacíos.';
            $message_type = 'error';
        }
    }
}

$profesores = $conn->query("SELECT id, nombre, apellido_paterno, apellido_materno FROM usuario WHERE rol_id = 2");
$cursos = $conn->query("SELECT curso.id, curso.nombre, curso.profesor_jefe_id, usuario.nombre AS profesor_nombre, usuario.apellido_paterno AS profesor_apellido_paterno, usuario.apellido_materno AS profesor_apellido_materno, curso.activo FROM curso JOIN usuario ON curso.profesor_jefe_id = usuario.id ORDER BY curso.nombre ASC");
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Agregar/Editar Curso</title>
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Roboto:400,700&display=swap">
    <link rel="stylesheet" href="../css/agregar_curso.css">
    <style>
       
    </style>
    <script>
        function validarFormulario() { if (document.getElementById('nombre').value.trim() === '') { alert('El nombre del curso no puede estar vacío o contener solo espacios.'); return false; } return true; }
        function editarCurso(id, nombre, profesor_jefe_id) { document.getElementById('curso_id').value = id; document.getElementById('nombre').value = nombre; document.getElementById('profesor_jefe_id').value = profesor_jefe_id; document.getElementById('crear').style.display = 'none'; document.getElementById('modificar').style.display = 'block'; }
        window.onload = function() { const message = document.getElementById('message'); if (message) { message.classList.add('show'); setTimeout(() => { message.classList.remove('show'); }, 2000); } };
    </script>
</head>
<body>
<header><img src="../images/INSIGNIA SF.png" alt="Escuela Porongo Insignia"><h1>Agregar/Editar Curso</h1>
<nav><ul><li><a href="../index.php">Inicio</a></li></ul></nav></header>
<main>
    <?php if ($message): ?><div id="message" class="message <?php echo $message_type; ?>"><?php echo htmlspecialchars($message, ENT_QUOTES, 'UTF-8'); ?></div><?php endif; ?>
    <form method="POST" action="add_course.php" onsubmit="return validarFormulario()">
        <input type="hidden" name="curso_id" id="curso_id">
        <label for="nombre">Nombre del Curso:</label><input type="text" id="nombre" name="nombre" required>
        <label for="profesor_jefe_id">Profesor Jefe:</label>
        <select id="profesor_jefe_id" name="profesor_jefe_id" required>
            <?php while ($profesor = $profesores->fetch_assoc()): ?>
                <option value="<?php echo htmlspecialchars($profesor['id'], ENT_QUOTES, 'UTF-8'); ?>">
                    <?php echo htmlspecialchars($profesor['nombre'] . ' ' . $profesor['apellido_paterno'] . ' ' . $profesor['apellido_materno'], ENT_QUOTES, 'UTF-8'); ?>
                </option>
            <?php endwhile; ?>
        </select>
        <button type="submit" name="crear" id="crear">Crear Curso</button>
        <button type="submit" name="modificar" id="modificar" style="display:none;">Modificar Curso</button>
    </form>
    <h2>Cursos Existentes</h2>
    <table>
        <thead><tr><th>Nombre del Curso</th><th>Profesor Jefe</th><th>Acciones</th></tr></thead>
        <tbody>
            <?php while ($curso = $cursos->fetch_assoc()): ?>
                <tr>
                    <td><?php echo htmlspecialchars($curso['nombre'], ENT_QUOTES, 'UTF-8'); ?></td>
                    <td><?php echo htmlspecialchars($curso['profesor_nombre'] . ' ' . $curso['profesor_apellido_paterno'] . ' ' . $curso['profesor_apellido_materno'], ENT_QUOTES, 'UTF-8'); ?></td>
                    <td class="actions">
                        <button class="btn btn-edit" onclick="editarCurso('<?php echo htmlspecialchars($curso['id'], ENT_QUOTES, 'UTF-8'); ?>', '<?php echo htmlspecialchars($curso['nombre'], ENT_QUOTES, 'UTF-8'); ?>', '<?php echo htmlspecialchars($curso['profesor_jefe_id'], ENT_QUOTES, 'UTF-8'); ?>')">Editar</button>
                        
                        <form method="POST" action="add_course.php" style="display:inline;">
                            <input type="hidden" name="curso_id" value="<?php echo htmlspecialchars($curso['id'], ENT_QUOTES, 'UTF-8'); ?>">
                            <button type="submit" name="estado" value="<?php echo $curso['activo'] ? 0 : 1; ?>" class="btn <?php echo $curso['activo'] ? 'btn-delete' : 'btn-edit'; ?>">
                                <?php echo $curso['activo'] ? 'Desactivar' : 'Activar'; ?>
                            </button>
                        </form>
                        
                        <form method="POST" action="add_course.php" style="display:inline;" onsubmit="return confirm('¿Estás seguro de que deseas eliminar este curso? Se eliminarán también los estudiantes asociados y sus notas.');">
                            <input type="hidden" name="curso_id" value="<?php echo htmlspecialchars($curso['id'], ENT_QUOTES, 'UTF-8'); ?>">
                            <button type="submit" name="eliminar" class="btn btn-delete">Eliminar</button>
                        </form>
                    </td>
                </tr>
            <?php endwhile; ?>
        </tbody>
    </table>
</main>
</body>
</html>
