<?php
header('Content-Type: text/html; charset=utf-8');

include '../includes/db.php';
include '../includes/auth.php';
checkAuth();

if (!isAdmin()) {
    header("Location: ../index.php");
    exit();
}

// Establecer la codificación de caracteres para la conexión de la base de datos
$conn->set_charset("utf8mb4");

// Obtener el ID del rol 'estudiante'
$rol_estudiante_id = null;
$rol_stmt = $conn->prepare("SELECT id FROM roles WHERE nombre = 'estudiante'");
$rol_stmt->execute();
$rol_stmt->bind_result($rol_estudiante_id);
$rol_stmt->fetch();
$rol_stmt->close();

// Obtener la lista de cursos ordenados del menor al mayor
$cursos = $conn->query("SELECT id, nombre FROM curso WHERE activo = 1 ORDER BY nombre ASC;");

// Obtener la lista de alumnos si un curso ha sido seleccionado
$alumnos = [];
if (isset($_GET['curso_id'])) {
    $curso_id = intval($_GET['curso_id']);
    $stmt = $conn->prepare("SELECT id, CONCAT(nombre, ' ', apellido_paterno, ' ', apellido_materno) AS nombre_completo, rut FROM usuario WHERE curso_id = ? AND rol_id = ? ORDER BY apellido_paterno");
    $stmt->bind_param("ii", $curso_id, $rol_estudiante_id);
    $stmt->execute();
    $alumnos = $stmt->get_result();
    $stmt->close();
}

$message = '';
$message_type = '';

// Procesar la promoción de alumnos
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['promover_alumno'])) {
    $alumno_id = intval($_POST['alumno_id']);
    $curso_nuevo_id = intval($_POST['curso_nuevo_id']);
    
    if ($curso_nuevo_id != $_POST['curso_actual_id']) {
        // Actualizar el curso del alumno
        $stmt = $conn->prepare("UPDATE usuario SET curso_id = ? WHERE id = ? AND rol_id = ?");
        $stmt->bind_param("iii", $curso_nuevo_id, $alumno_id, $rol_estudiante_id);
        if ($stmt->execute()) {
            $message = 'El alumno ha sido promovido correctamente al nuevo curso.';
            $message_type = 'success';
        } else {
            $message = 'Error al promover el alumno. Por favor, inténtelo de nuevo.';
            $message_type = 'error';
        }
        $stmt->close();
    } else {
        $message = 'El nuevo curso debe ser diferente al curso actual.';
        $message_type = 'error';
    }
}

// Cargar los cursos nuevamente para el formulario de promoción
$cursos_promover = $conn->query("SELECT * FROM curso ORDER BY nombre");

if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_GET['action']) && $_GET['action'] == 'egresar') {
    $alumno_id = intval($_POST['alumno_id']);
    $rol_egresado_id = 10;

    $stmt = $conn->prepare("UPDATE usuario SET rol_id = ? WHERE id = ?");
    $stmt->bind_param("ii", $rol_egresado_id, $alumno_id);
    if ($stmt->execute()) {
        $message = 'El alumno ha sido marcado como egresado correctamente.';
        $message_type = 'success';
    } else {
        $message = 'Error al marcar como egresado. Por favor, inténtelo de nuevo.';
        $message_type = 'error';
    }
    $stmt->close();
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Ver Cursos y Promover Alumnos</title>
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Roboto:400,700&display=swap">
    <link rel="stylesheet" href="../css/ver_cursos.css">
    <style>
       
    </style>
</head>
<body>
    <header>
        <img src="../images/INSIGNIA SF.png" alt="Escuela Porongo Insignia">
        <h1>Ver Cursos y Promover Alumnos</h1>
    
    
    <nav>
        <ul>
            <li><a href="../index.php">Inicio</a></li>
        </ul>
    </nav>
    </header>
    <main>
        <?php if ($message): ?>
            <div class="message <?php echo $message_type; ?>">
                <?php echo htmlspecialchars($message, ENT_QUOTES, 'UTF-8'); ?>
            </div>
        <?php endif; ?>

        <h2>Seleccionar Curso</h2>
        <form method="GET" action="view_courses.php">
            <label for="curso_id">Curso:</label>
            <select id="curso_id" name="curso_id" onchange="this.form.submit()">
                <option value="">Seleccione un curso</option>
                <?php while ($curso = $cursos->fetch_assoc()): ?>
                    <option value="<?php echo htmlspecialchars($curso['id'], ENT_QUOTES, 'UTF-8'); ?>" <?php if (isset($_GET['curso_id']) && intval($_GET['curso_id']) == $curso['id']) echo 'selected'; ?>>
                        <?php echo htmlspecialchars($curso['nombre'], ENT_QUOTES, 'UTF-8'); ?>
                    </option>
                <?php endwhile; ?>
            </select>
        </form>
        
        <?php if ($alumnos && $alumnos->num_rows > 0): ?>
            <h2>Alumnos en el Curso</h2>
        <p><strong>Cantidad de alumnos:</strong> <?php echo $alumnos->num_rows; ?></p>

            <table>
                <thead>
                    <tr>
                        <th>Nombre</th>
                        <th>RUT</th>
                        <th>Acciones</th>
                    </tr>
                </thead>
                <tbody>
                    <?php while ($alumno = $alumnos->fetch_assoc()): ?>
                        <tr>
                            <td><?php echo htmlspecialchars($alumno['nombre_completo'], ENT_QUOTES, 'UTF-8'); ?></td>
                            <td><?php echo htmlspecialchars($alumno['rut'], ENT_QUOTES, 'UTF-8'); ?></td>
                            <td class="actions">
    <button class="btn btn-promote" onclick="promoverAlumno('<?php echo htmlspecialchars($alumno['id'], ENT_QUOTES, 'UTF-8'); ?>', '<?php echo htmlspecialchars($alumno['nombre_completo'], ENT_QUOTES, 'UTF-8'); ?>', '<?php echo htmlspecialchars($_GET['curso_id'], ENT_QUOTES, 'UTF-8'); ?>')">Promover</button>
    <button class="btn btn-egresar" onclick="egresarAlumno('<?php echo htmlspecialchars($alumno['id'], ENT_QUOTES, 'UTF-8'); ?>', '<?php echo htmlspecialchars($alumno['nombre_completo'], ENT_QUOTES, 'UTF-8'); ?>')">Egresar</button>
</td>

                        </tr>
                    <?php endwhile; ?>
                </tbody>
            </table>
        <?php endif; ?>
        
        <form id="form-promover" method="POST" action="view_courses.php">
            <input type="hidden" name="alumno_id" id="alumno_id">
            <input type="hidden" name="curso_actual_id" id="curso_actual_id">

            <h2>Promover Alumno</h2>
            <label for="nombre_alumno">Nombre del Alumno:</label>
            <input type="text" id="nombre_alumno" name="nombre_alumno" readonly>

            <label for="curso_nuevo_id">Nuevo Curso:</label>
            <select id="curso_nuevo_id" name="curso_nuevo_id" required>
                <option value="">Seleccione un curso</option>
                <?php while ($curso = $cursos_promover->fetch_assoc()): ?>
                    <option value="<?php echo htmlspecialchars($curso['id'], ENT_QUOTES, 'UTF-8'); ?>">
                        <?php echo htmlspecialchars($curso['nombre'], ENT_QUOTES, 'UTF-8'); ?>
                    </option>
                <?php endwhile; ?>
            </select>
            
            <button type="submit" name="promover_alumno">Promover Alumno</button>
        </form>
    </main>

    <script>
        function promoverAlumno(id, nombre_completo, curso_actual_id) {
            document.getElementById('alumno_id').value = id;
            document.getElementById('nombre_alumno').value = nombre_completo;
            document.getElementById('curso_actual_id').value = curso_actual_id;

            document.getElementById('form-promover').style.display = 'block';
        }
        function egresarAlumno(id, nombre_completo) {
    if (confirm(`¿Está seguro que desea egresar a ${nombre_completo}?`)) {
        document.getElementById('alumno_id').value = id;
        document.getElementById('form-promover').action = 'view_courses.php?action=egresar';
        document.getElementById('form-promover').submit();
    }
}

    </script>
</body>
</html>
