<?php
session_start();  // Iniciar la sesión

include '../includes/db.php';
include '../includes/auth.php';
checkAuth();

$usuario_id = $_SESSION['usuario_id'];
$conn->set_charset("utf8");

$message = ''; // Variable para almacenar el mensaje
$search_query = ""; // Variable para almacenar la consulta de búsqueda

// Paginación
$limite = 20; // Número de registros por página
$pagina = isset($_GET['pagina']) ? (int)$_GET['pagina'] : 1;
$offset = ($pagina - 1) * $limite;

// Verificar si se ha enviado una solicitud de eliminación
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['eliminar_equipo'])) {
    $equipo_id = intval($_POST['equipo_id']); // Asegurarse de que el ID es un número entero

    $conn->begin_transaction();

    try {
        // Eliminar de la tabla `detalles_equipo`
        $stmt_detalles = $conn->prepare("DELETE FROM detalles_equipo WHERE equipo_id = ?");
        $stmt_detalles->bind_param("i", $equipo_id);
        $stmt_detalles->execute();
        $stmt_detalles->close();

        // Eliminar de la tabla `mantenimiento_equipo`
        $stmt_mantenimiento = $conn->prepare("DELETE FROM mantenimiento_equipo WHERE equipo_id = ?");
        $stmt_mantenimiento->bind_param("i", $equipo_id);
        $stmt_mantenimiento->execute();
        $stmt_mantenimiento->close();

        // Eliminar de la tabla `software_instalado`
        $stmt_software = $conn->prepare("DELETE FROM software_instalado WHERE equipo_id = ?");
        $stmt_software->bind_param("i", $equipo_id);
        $stmt_software->execute();
        $stmt_software->close();

        // Eliminar de la tabla `equipo`
        $stmt_equipo = $conn->prepare("DELETE FROM equipo WHERE id = ?");
        $stmt_equipo->bind_param("i", $equipo_id);

        if ($stmt_equipo->execute()) {
            $conn->commit(); // Confirmar la transacción
            $_SESSION['mensaje'] = "Equipo eliminado exitosamente.";
            $_SESSION['mensaje_tipo'] = "exito";
        } else {
            $conn->rollback(); // Revertir la transacción si algo falla
            $_SESSION['mensaje'] = "Error al eliminar el equipo: " . $stmt_equipo->error;
            $_SESSION['mensaje_tipo'] = "error";
        }
        $stmt_equipo->close();
    } catch (Exception $e) {
        $conn->rollback();
        $_SESSION['mensaje'] = "Error al eliminar el equipo: " . $e->getMessage();
        $_SESSION['mensaje_tipo'] = "error";
    }

    // Redirigir a crud_equipos.php para mostrar el mensaje
    header("Location: crud_equipos.php");
    exit();
}

// Mostrar el mensaje si está en la sesión
if (isset($_SESSION['mensaje'])) {
    $message = $_SESSION['mensaje'];
    $message_type = $_SESSION['mensaje_tipo'];
    unset($_SESSION['mensaje']);
    unset($_SESSION['mensaje_tipo']);
}

// Verificar si se ha enviado una solicitud de búsqueda
$search_param = "";
if ($_SERVER['REQUEST_METHOD'] == 'GET' && isset($_GET['search'])) {
    $search = filter_input(INPUT_GET, 'search', FILTER_SANITIZE_SPECIAL_CHARS);
    $search_param = "%$search%"; // Preparar el parámetro de búsqueda
}

// Obtener equipos de la base de datos con filtro de búsqueda si está definido
if ($search_param) {
    $stmt = $conn->prepare("SELECT e.id, e.nombre_equipo, d.marca, d.modelo, e.ubicacion, es.nombre_estado 
                            FROM equipo e
                            JOIN detalles_equipo d ON e.id = d.equipo_id 
                            JOIN estado_equipo es ON e.estado_equipo_id = es.id
                            WHERE e.nombre_equipo LIKE ? OR d.marca LIKE ? OR d.modelo LIKE ? OR e.ubicacion LIKE ? OR es.nombre_estado LIKE ?
                            ORDER BY e.nombre_equipo ASC
                            LIMIT ?, ?");
    $stmt->bind_param("sssssii", $search_param, $search_param, $search_param, $search_param, $search_param, $offset, $limite);
} else {
    $stmt = $conn->prepare("SELECT e.id, e.nombre_equipo, d.marca, d.modelo, e.ubicacion, es.nombre_estado 
                            FROM equipo e
                            JOIN detalles_equipo d ON e.id = d.equipo_id
                            JOIN estado_equipo es ON e.estado_equipo_id = es.id
                            ORDER BY e.nombre_equipo ASC
                            LIMIT ?, ?");
    $stmt->bind_param("ii", $offset, $limite);
    $stmt->execute();
    $equipos = $stmt->get_result();
}

// Obtener el número total de equipos para la paginación
$total_equipos = $conn->query("SELECT COUNT(*) as total FROM equipo")->fetch_assoc()['total'];
$total_paginas = ceil($total_equipos / $limite);
$stmt->close();
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Gestionar Equipos</title>
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Roboto:400,700&display=swap">
    <link rel="stylesheet" href="../css/equipos_crud.css">
    
    <style>
       
    </style>
    <script>
        function showMessage(message, type) {
            const messageBox = document.getElementById('messageBox');
            messageBox.textContent = message;
            messageBox.className = type === 'exito' ? 'message success' : 'message error';
            messageBox.style.display = 'block';
            setTimeout(() => {
                messageBox.style.display = 'none';
            }, 3000);
        }

        <?php if ($message): ?>
        window.onload = function() {
            showMessage('<?php echo htmlspecialchars($message, ENT_QUOTES, 'UTF-8'); ?>', '<?php echo htmlspecialchars($message_type, ENT_QUOTES, 'UTF-8'); ?>');
        }
        <?php endif; ?>
    </script>
</head>
<body>
    <header>
        <img src="../images/INSIGNIA SF.png" alt="Escuela Porongo Insignia">
        <h1>Gestionar Equipos</h1>
    
    <nav>
        <ul>
            <li><a href="../index.php">Inicio</a></li>
            <li><a href="equipos.php">Agregar Equipo</a></li>
        </ul>
    </nav>
        </header>
    <main>
        <div class="search-container">
            <form method="GET" action="crud_equipos.php">
                <input type="text" name="search" placeholder="Buscar por nombre, marca, modelo, ubicación o estado">
                <button type="submit">Buscar</button>
            </form>
        </div>
        <div class="form-container">
           <table>
    <thead>
        <tr>
            <!-- Eliminar el encabezado de ID -->
            <th>Nombre</th>
            <th>Marca</th>
            <th>Modelo</th>
            <th>Ubicación</th>
            <th>Estado</th>
            <th>Acciones</th>
        </tr>
    </thead>
    <tbody>
        <?php while ($equipo = $equipos->fetch_assoc()): ?>
            <tr>
                <!-- Eliminar la columna de ID -->
                <td><?php echo htmlspecialchars($equipo['nombre_equipo'], ENT_QUOTES, 'UTF-8'); ?></td>
                <td><?php echo htmlspecialchars($equipo['marca'], ENT_QUOTES, 'UTF-8'); ?></td>
                <td><?php echo htmlspecialchars($equipo['modelo'], ENT_QUOTES, 'UTF-8'); ?></td>
                <td><?php echo htmlspecialchars($equipo['ubicacion'], ENT_QUOTES, 'UTF-8'); ?></td>
                <td><?php echo htmlspecialchars($equipo['nombre_estado'], ENT_QUOTES, 'UTF-8'); ?></td>
                <td class="actions">
                    <a href="ver_equipo.php?id=<?php echo htmlspecialchars($equipo['id'], ENT_QUOTES, 'UTF-8'); ?>">Ver</a>
                    <a href="editar_equipo.php?id=<?php echo htmlspecialchars($equipo['id'], ENT_QUOTES, 'UTF-8'); ?>">Editar</a>
                    <form method="POST" action="crud_equipos.php" style="display:inline;">
                        <!-- ID como un campo oculto -->
                        <input type="hidden" name="equipo_id" value="<?php echo htmlspecialchars($equipo['id'], ENT_QUOTES, 'UTF-8'); ?>">
                        <button type="submit" name="eliminar_equipo" class="delete" onclick="return confirm('¿Está seguro de que desea eliminar este equipo?');">Eliminar</button>
                    </form>
                </td>
            </tr>
        <?php endwhile; ?>
    </tbody>
</table>

        </div>

        <!-- Paginación -->
        <div class="pagination">
            <?php for ($i = 1; $i <= $total_paginas; $i++): ?>
                <a href="?pagina=<?php echo $i; ?>" class="<?php echo ($i == $pagina) ? 'active' : ''; ?>"><?php echo $i; ?></a>
            <?php endfor; ?>
        </div>
    </main>
    <div id="messageBox" class="message"></div>
</body>
</html>
