<?php
require 'vendor/autoload.php';

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

// Crear un nuevo objeto de Spreadsheet
$spreadsheet = new Spreadsheet();
$sheet = $spreadsheet->getActiveSheet();

// Definir las cabeceras
$headers = [
    'nombre_equipo',
    'ubicacion',
    'estado_equipo_id',
    'marca',
    'modelo',
    'numero_serie',
    'procesador',
    'memoria_ram',
    'almacenamiento',
    'tarjeta_grafica',
    'sistema_operativo',
    'version_so',
    'programas_instalados',
    'observaciones',
    'fecha_ultimo_mantenimiento',
    'detalles_mantenimiento',
    'proxima_fecha_mantenimiento'
];

// Escribir las cabeceras en la primera fila
$sheet->fromArray($headers, NULL, 'A1');

// Configurar la respuesta para descarga
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment;filename="plantilla_equipos.xlsx"');
header('Cache-Control: max-age=0');

// Escribir el archivo
$writer = new Xlsx($spreadsheet);
$writer->save('php://output');
exit;
?>
