<?php
include '../includes/db.php';
include '../includes/auth.php';
checkAuth();

$id = intval($_GET['id']);
$message = ''; // Variable para almacenar el mensaje
$message_type = ''; // Variable para el tipo de mensaje (success o error)

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $nombre_equipo = $_POST['nombre_equipo'];
    $ubicacion = $_POST['ubicacion'];
    $marca = $_POST['marca'];
    $modelo = $_POST['modelo'];
    $numero_serie = $_POST['numero_serie'];
    $procesador = $_POST['procesador'];
    $memoria_ram = $_POST['memoria_ram'];
    $almacenamiento = $_POST['almacenamiento'];
    $tarjeta_grafica = $_POST['tarjeta_grafica'];
    $sistema_operativo = $_POST['sistema_operativo'];
    $version_so = $_POST['version_so'];
    $programas_instalados = $_POST['programas_instalados'];
    $estado_equipo_id = intval($_POST['estado_equipo_id']);
    $observaciones = $_POST['observaciones'];
    $fecha_ultimo_mantenimiento = $_POST['fecha_ultimo_mantenimiento'];
    $detalles_mantenimiento = $_POST['detalles_mantenimiento'];
    $proxima_fecha_mantenimiento = $_POST['proxima_fecha_mantenimiento'];

    $ruta_imagen_final = null;
    if (isset($_FILES['imagen']) && $_FILES['imagen']['error'] === UPLOAD_ERR_OK) {
        $imagen = $_FILES['imagen'];
        $nombre_imagen = $imagen['name'];
        $ruta_temporal = $imagen['tmp_name'];
        $directorio_destino = '../uploads/equipos/'; 

        $nombre_imagen_unico = uniqid('', true) . "." . pathinfo($nombre_imagen, PATHINFO_EXTENSION);
        if (move_uploaded_file($ruta_temporal, $directorio_destino . $nombre_imagen_unico)) {
            $ruta_imagen_final = $directorio_destino . $nombre_imagen_unico;

            // Eliminar la imagen anterior
            $stmt = $conn->prepare("SELECT imagen FROM detalles_equipo WHERE equipo_id = ?");
            $stmt->bind_param("i", $id);
            $stmt->execute();
            $result = $stmt->get_result();
            $detalles = $result->fetch_assoc();
            $stmt->close();

            if ($detalles && !empty($detalles['imagen']) && file_exists($detalles['imagen'])) {
                unlink($detalles['imagen']);
            }
        }
    } else {
        // Mantener la imagen existente si no se ha cargado una nueva
        $stmt = $conn->prepare("SELECT imagen FROM detalles_equipo WHERE equipo_id = ?");
        $stmt->bind_param("i", $id);
        $stmt->execute();
        $result = $stmt->get_result();
        $detalles = $result->fetch_assoc();
        $stmt->close();

        $ruta_imagen_final = $detalles['imagen'];
    }

    $conn->begin_transaction();

    try {
        // Actualizar la tabla equipo
        $sql = "UPDATE equipo SET nombre_equipo = ?, ubicacion = ?, estado_equipo_id = ? WHERE id = ?";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("ssii", $nombre_equipo, $ubicacion, $estado_equipo_id, $id);
        $stmt->execute();

        // Actualizar la tabla detalles_equipo
        $sql = "UPDATE detalles_equipo SET marca = ?, modelo = ?, numero_serie = ?, procesador = ?, memoria_ram = ?, almacenamiento = ?, tarjeta_grafica = ?, sistema_operativo = ?, version_so = ?, imagen = ? WHERE equipo_id = ?";
        $stmt->prepare($sql);
        $stmt->bind_param("ssssssssssi", $marca, $modelo, $numero_serie, $procesador, $memoria_ram, $almacenamiento, $tarjeta_grafica, $sistema_operativo, $version_so, $ruta_imagen_final, $id);
        $stmt->execute();

        // Consulta SQL con 5 marcadores de posición, de acuerdo a la estructura de la tabla
        $sql = "UPDATE mantenimiento_equipo 
                SET fecha_ultimo_mantenimiento = ?, 
                    detalles_mantenimiento = ?, 
                    proxima_fecha_mantenimiento = ?, 
                    observaciones = ? 
                WHERE equipo_id = ?";

        // Preparar la declaración SQL
        $stmt = $conn->prepare($sql);

        // Vincular los parámetros
        // ssssi: Los primeros 4 parámetros son cadenas (s) o fechas, el último es un entero (i)
        $stmt->bind_param(
            "ssssi", 
            $fecha_ultimo_mantenimiento,     // Fecha (string), puede ser NULL
            $detalles_mantenimiento,         // Detalles (string), puede ser NULL
            $proxima_fecha_mantenimiento,    // Fecha (string), puede ser NULL
            $observaciones,                  // Observaciones (string), puede ser NULL
            $id                              // ID del equipo (entero)
        );

        // Ejecutar la consulta
        $stmt->execute();

        // Consulta SQL para actualizar los programas instalados
        $sql = "UPDATE software_instalado SET programas_instalados = ? WHERE equipo_id = ?";

        // Preparar la declaración SQL
        $stmt = $conn->prepare($sql);

        // Vincular los parámetros: programas_instalados (string) y equipo_id (integer)
        $stmt->bind_param("si", $programas_instalados, $id); // "si" = string, integer

        // Ejecutar la consulta
        $stmt->execute();

        $conn->commit();
        $message = "Equipo actualizado exitosamente.";
        $message_type = "success";
    } catch (Exception $e) {
        $conn->rollback();
        $message = "Error al actualizar el equipo: " . $e->getMessage();
        $message_type = "error";
    }
}

// Obtener los datos básicos del equipo
$stmt = $conn->prepare("SELECT * FROM equipo WHERE id = ?");
$stmt->bind_param("i", $id);
$stmt->execute();
$result = $stmt->get_result();
$equipo = $result->fetch_assoc();
$stmt->close();

if (!$equipo) {
    header("Location: equipos.php?message=" . urlencode("Equipo no encontrado.") . "&message_type=error");
    exit;
}

// Obtener los detalles del equipo
$stmt = $conn->prepare("SELECT * FROM detalles_equipo WHERE equipo_id = ?");
$stmt->bind_param("i", $id);
$stmt->execute();
$result = $stmt->get_result();
$detalles = $result->fetch_assoc();
$stmt->close();

// Obtener el mantenimiento del equipo
$stmt = $conn->prepare("SELECT * FROM mantenimiento_equipo WHERE equipo_id = ?");
$stmt->bind_param("i", $id);
$stmt->execute();
$result = $stmt->get_result();
$mantenimiento = $result->fetch_assoc();
$stmt->close();

// Obtener el software instalado en el equipo
$stmt = $conn->prepare("SELECT * FROM software_instalado WHERE equipo_id = ?");
$stmt->bind_param("i", $id);
$stmt->execute();
$result = $stmt->get_result();
$software = $result->fetch_assoc();
$stmt->close();

// Obtener los posibles estados del equipo
$stmt = $conn->prepare("SELECT * FROM estado_equipo");
$stmt->execute();
$estados = $stmt->get_result();
$stmt->close();
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Editar Equipo</title>
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Roboto:400,700&display=swap">
    <link rel="stylesheet" href="../css/editar_equipo.css">
    <style>
        
    </style>
    <script>
        function showNotification(message, type) {
            const notification = document.getElementById('notification');
            notification.textContent = message;
            notification.className = 'notification ' + type;
            notification.style.display = 'block';
            setTimeout(() => {
                notification.style.display = 'none';
            }, 4000);
        }

        function validateForm(event) {
            const requiredFields = [
                'nombre_equipo', 'ubicacion', 'marca', 'modelo', 'sistema_operativo', 'estado_equipo_id'
            ];

            let valid = true;

            requiredFields.forEach(fieldId => {
                const field = document.getElementById(fieldId);
                if (!field.value.trim()) {
                    field.classList.add('error');
                    valid = false;
                } else {
                    field.classList.remove('error');
                }
            });

            if (!valid) {
                event.preventDefault(); // Detener el envío del formulario si hay campos vacíos
                showNotification('Por favor completa todos los campos obligatorios.', 'error');
            }
        }

        document.addEventListener("DOMContentLoaded", function() {
            const form = document.querySelector('form');
            form.addEventListener('submit', validateForm);
        });

        <?php if ($message): ?>
        window.onload = function() {
            showNotification('<?php echo htmlspecialchars($message, ENT_QUOTES, 'UTF-8'); ?>', '<?php echo htmlspecialchars($message_type, ENT_QUOTES, 'UTF-8'); ?>');
        }
        <?php endif; ?>
    </script>
</head>
<body>
    <header>
        <img src="../images/INSIGNIA SF.png" alt="Escuela Porongo Insignia">
        <h1>Editar Equipo del Laboratorio</h1>
    
    <nav>
        <ul>
            <li><a href="../index.php">Inicio</a></li>
            <li><a href="crud_equipos.php">Volver</a></li>
        </ul>
    </nav>
        </header>
    <main>
        <div class="form-container">
            <div class="form-header">
                <h2>Formulario de Edición</h2>
            </div>
            <form action="editar_equipo.php?id=<?php echo htmlspecialchars($id, ENT_QUOTES, 'UTF-8'); ?>" method="POST" enctype="multipart/form-data">
                <div class="form-grid">
                    <div>
                        <label for="nombre_equipo">Nombre del Equipo:</label>
                        <input type="text" id="nombre_equipo" name="nombre_equipo" value="<?php echo htmlspecialchars($equipo['nombre_equipo'] ?? '', ENT_QUOTES, 'UTF-8'); ?>" required>
                    </div>
                    <div>
                        <label for="ubicacion">Ubicación:</label>
                        <input type="text" id="ubicacion" name="ubicacion" value="<?php echo htmlspecialchars($equipo['ubicacion'] ?? '', ENT_QUOTES, 'UTF-8'); ?>" required>
                    </div>
                    <div>
                        <label for="marca">Marca:</label>
                        <input type="text" id="marca" name="marca" value="<?php echo htmlspecialchars($detalles['marca'] ?? '', ENT_QUOTES, 'UTF-8'); ?>" required>
                    </div>
                    <div>
                        <label for="modelo">Modelo:</label>
                        <input type="text" id="modelo" name="modelo" value="<?php echo htmlspecialchars($detalles['modelo'] ?? '', ENT_QUOTES, 'UTF-8'); ?>" required>
                    </div>
                    <div>
                        <label for="numero_serie">Número de Serie:</label>
                        <input type="text" id="numero_serie" name="numero_serie" value="<?php echo htmlspecialchars($detalles['numero_serie'] ?? '', ENT_QUOTES, 'UTF-8'); ?>">
                    </div>
                    <div>
                        <label for="procesador">Procesador:</label>
                        <input type="text" id="procesador" name="procesador" value="<?php echo htmlspecialchars($detalles['procesador'] ?? '', ENT_QUOTES, 'UTF-8'); ?>">
                    </div>
                    <div>
                        <label for="memoria_ram">Memoria RAM:</label>
                        <input type="text" id="memoria_ram" name="memoria_ram" value="<?php echo htmlspecialchars($detalles['memoria_ram'] ?? '', ENT_QUOTES, 'UTF-8'); ?>">
                    </div>
                    <div>
                        <label for="almacenamiento">Almacenamiento:</label>
                        <input type="text" id="almacenamiento" name="almacenamiento" value="<?php echo htmlspecialchars($detalles['almacenamiento'] ?? '', ENT_QUOTES, 'UTF-8'); ?>">
                    </div>
                    <div>
                        <label for="tarjeta_grafica">Tarjeta Gráfica:</label>
                        <input type="text" id="tarjeta_grafica" name="tarjeta_grafica" value="<?php echo htmlspecialchars($detalles['tarjeta_grafica'] ?? '', ENT_QUOTES, 'UTF-8'); ?>">
                    </div>
                    <div>
                        <label for="sistema_operativo">Sistema Operativo:</label>
                        <input type="text" id="sistema_operativo" name="sistema_operativo" value="<?php echo htmlspecialchars($detalles['sistema_operativo'] ?? '', ENT_QUOTES, 'UTF-8'); ?>" required>
                    </div>
                    <div>
                        <label for="version_so">Versión del SO:</label>
                        <input type="text" id="version_so" name="version_so" value="<?php echo htmlspecialchars($detalles['version_so'] ?? '', ENT_QUOTES, 'UTF-8'); ?>">
                    </div>
                    <div class="full-width">
                        <label for="programas_instalados">Programas Instalados:</label>
                        <textarea id="programas_instalados" name="programas_instalados" rows="4"><?php echo htmlspecialchars($software['programas_instalados'] ?? '', ENT_QUOTES, 'UTF-8'); ?></textarea>
                    </div>
                    <div>
                        <label for="estado_equipo_id">Estado del Equipo:</label>
                        <select id="estado_equipo_id" name="estado_equipo_id" required>
                            <?php while ($estado = $estados->fetch_assoc()): ?>
                                <option value="<?php echo htmlspecialchars($estado['id'], ENT_QUOTES, 'UTF-8'); ?>" <?php if ($equipo['estado_equipo_id'] == $estado['id']) echo 'selected'; ?>>
                                    <?php echo htmlspecialchars($estado['nombre_estado'], ENT_QUOTES, 'UTF-8'); ?>
                                </option>
                            <?php endwhile; ?>
                        </select>
                    </div>
                    <div class="full-width">
                        <label for="observaciones">Observaciones:</label>
                        <textarea id="observaciones" name="observaciones" rows="4"><?php echo htmlspecialchars($mantenimiento['observaciones'] ?? '', ENT_QUOTES, 'UTF-8'); ?></textarea>
                    </div>
                    <div>
                        <label for="fecha_ultimo_mantenimiento">Fecha de Último Mantenimiento:</label>
                        <input type="date" id="fecha_ultimo_mantenimiento" name="fecha_ultimo_mantenimiento" value="<?php echo htmlspecialchars($mantenimiento['fecha_ultimo_mantenimiento'] ?? '', ENT_QUOTES, 'UTF-8'); ?>">
                    </div>
                    <div>
                        <label for="detalles_mantenimiento">Detalles del Mantenimiento:</label>
                        <textarea id="detalles_mantenimiento" name="detalles_mantenimiento" rows="4"><?php echo htmlspecialchars($mantenimiento['detalles_mantenimiento'] ?? '', ENT_QUOTES, 'UTF-8'); ?></textarea>
                    </div>
                    <div>
                                                <input type="date" id="proxima_fecha_mantenimiento" name="proxima_fecha_mantenimiento" value="<?php echo htmlspecialchars($mantenimiento['proxima_fecha_mantenimiento'] ?? '', ENT_QUOTES, 'UTF-8'); ?>">
                    </div>
                    <div class="full-width">
                        <label for="imagen">Imagen del Equipo:</label>
                        <input type="file" id="imagen" name="imagen">
                        <?php if (!empty($detalles['imagen'])): ?>
                            <img src="<?php echo htmlspecialchars($detalles['imagen'] ?? '', ENT_QUOTES, 'UTF-8'); ?>" alt="Imagen del Equipo">
                        <?php endif; ?>
                    </div>
                </div>
                <button type="submit">Guardar Cambios</button>
            </form>
        </div>
    </main>
    <div id="notification" class="notification"></div>
</body>
</html>
