<?php
session_start();  // Iniciar la sesión

include '../includes/db.php'; // Incluir la conexión a la base de datos
include '../includes/auth.php'; // Incluir autenticación
checkAuth(); // Verificar autenticación

// Obtener el ID del usuario que ha iniciado sesión
$usuario_id = $_SESSION['usuario_id'];

$message = ''; // Variable para almacenar el mensaje
$message_type = ''; // Variable para el tipo de mensaje (success o error)

// Consulta para obtener los estados del equipo
$stmt_estados = $conn->prepare("SELECT id, nombre_estado FROM estado_equipo");
$stmt_estados->execute();
$result_estados = $stmt_estados->get_result();
$estados = [];
while ($row = $result_estados->fetch_assoc()) {
    $estados[] = $row; // Almacenar cada estado en el array
}

// Inicializar las variables de los statements a null
$stmt_equipo = null;
$stmt_detalles = null;
$stmt_mantenimiento = null;
$stmt_software = null;

// Procesar el formulario
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Recoger los datos del formulario
    $nombre_equipo = trim($_POST['nombre_equipo']);
    $ubicacion = trim($_POST['ubicacion']);
    $estado_equipo_id = isset($_POST['estado_equipo_id']) ? trim($_POST['estado_equipo_id']) : null;
    $marca = trim($_POST['marca']);
    $modelo = trim($_POST['modelo']);
    $numero_serie = trim($_POST['numero_serie']);
    $procesador = trim($_POST['procesador']);
    $memoria_ram = trim($_POST['memoria_ram']);
    $almacenamiento = trim($_POST['almacenamiento']);
    $tarjeta_grafica = trim($_POST['tarjeta_grafica']);
    $sistema_operativo = trim($_POST['sistema_operativo']);
    $version_so = trim($_POST['version_so']);
    $programas_instalados = trim($_POST['programas_instalados']);
    $fecha_ultimo_mantenimiento = trim($_POST['fecha_ultimo_mantenimiento']);
    $detalles_mantenimiento = trim($_POST['detalles_mantenimiento']);
    $proxima_fecha_mantenimiento = trim($_POST['proxima_fecha_mantenimiento']);
    $observaciones = trim($_POST['observaciones']);

    // Manejo de la imagen
    $ruta_imagen_final = null;
    if (isset($_FILES['imagen_equipo']) && $_FILES['imagen_equipo']['error'] === UPLOAD_ERR_OK) {
        $imagen_equipo = $_FILES['imagen_equipo'];
        $nombre_imagen = $imagen_equipo['name'];
        $ruta_temporal = $imagen_equipo['tmp_name'];
        $directorio_destino = '../uploads/equipos/'; // Asegúrate de que esta carpeta exista y tenga permisos de escritura

        // Generar un nombre único para la imagen para evitar colisiones
        $nombre_imagen_unico = uniqid('', true) . "." . pathinfo($nombre_imagen, PATHINFO_EXTENSION);

        // Mover la imagen al directorio de destino
        if (move_uploaded_file($ruta_temporal, $directorio_destino . $nombre_imagen_unico)) {
            $ruta_imagen_final = $directorio_destino . $nombre_imagen_unico;
        }
    }

    // Iniciar una transacción para asegurar que todas las inserciones se realicen correctamente
    $conn->begin_transaction();

    try {
        // Insertar los datos en la tabla equipo
        $sql_equipo = "INSERT INTO equipo (nombre_equipo, ubicacion, estado_equipo_id) VALUES (?, ?, ?)";
        $stmt_equipo = $conn->prepare($sql_equipo);
        $stmt_equipo->bind_param("ssi", $nombre_equipo, $ubicacion, $estado_equipo_id);

        if ($stmt_equipo->execute()) {
            $equipo_id = $stmt_equipo->insert_id; // Obtener el ID del equipo insertado

            // Insertar los detalles del equipo en la tabla detalles_equipo
            $sql_detalles = "INSERT INTO detalles_equipo (equipo_id, marca, modelo, numero_serie, procesador, memoria_ram, almacenamiento, tarjeta_grafica, sistema_operativo, version_so, imagen) 
                             VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
            $stmt_detalles = $conn->prepare($sql_detalles);
            $stmt_detalles->bind_param("issssssssss", $equipo_id, $marca, $modelo, $numero_serie, $procesador, $memoria_ram, $almacenamiento, $tarjeta_grafica, $sistema_operativo, $version_so, $ruta_imagen_final);

            if ($stmt_detalles->execute()) {
                // Insertar los datos del mantenimiento en la tabla mantenimiento_equipo
                $sql_mantenimiento = "INSERT INTO mantenimiento_equipo (equipo_id, fecha_ultimo_mantenimiento, detalles_mantenimiento, proxima_fecha_mantenimiento, observaciones) 
                                      VALUES (?, ?, ?, ?, ?)";
                $stmt_mantenimiento = $conn->prepare($sql_mantenimiento);
                $stmt_mantenimiento->bind_param("issss", $equipo_id, $fecha_ultimo_mantenimiento, $detalles_mantenimiento, $proxima_fecha_mantenimiento, $observaciones);

                if ($stmt_mantenimiento->execute()) {
                    // Insertar los programas instalados en la tabla software_instalado
                    $sql_software = "INSERT INTO software_instalado (equipo_id, programas_instalados) VALUES (?, ?)";
                    $stmt_software = $conn->prepare($sql_software);
                    $stmt_software->bind_param("is", $equipo_id, $programas_instalados);

                    if ($stmt_software->execute()) {
                        // Confirmar la transacción
                        $conn->commit();
                        $message = "Equipo guardado exitosamente.";
                        $message_type = 'success';
                    } else {
                        throw new Exception("Error al guardar los programas instalados: " . $stmt_software->error);
                    }
                } else {
                    throw new Exception("Error al guardar el mantenimiento: " . $stmt_mantenimiento->error);
                }
            } else {
                throw new Exception("Error al guardar los detalles del equipo: " . $stmt_detalles->error);
            }
        } else {
            throw new Exception("Error al guardar el equipo: " . $stmt_equipo->error);
        }
    } catch (Exception $e) {
        // En caso de error, revertir la transacción
        $conn->rollback();
        $message = $e->getMessage();
        $message_type = 'error';
    }

    // Cerrar las consultas si fueron exitosas
    if ($stmt_equipo) $stmt_equipo->close();
    if ($stmt_detalles) $stmt_detalles->close();
    if ($stmt_mantenimiento) $stmt_mantenimiento->close();
    if ($stmt_software) $stmt_software->close();
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Registro de Equipos</title>
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Roboto:400,700&display=swap">
    <link rel="stylesheet" href="../css/equipos.css">
    <style>
       
    </style>
    <script>
        function showNotification(message, type) {
            const notification = document.getElementById('notification');
            notification.textContent = message;
            notification.className = 'notification ' + type;
            notification.style.display = 'block';
            setTimeout(() => {
                notification.style.display = 'none';
            }, 4000);
        }

        <?php if ($message): ?>
        window.onload = function() {
            showNotification('<?php echo htmlspecialchars($message, ENT_QUOTES, 'UTF-8'); ?>', '<?php echo htmlspecialchars($message_type, ENT_QUOTES, 'UTF-8'); ?>');
        }
        <?php endif; ?>
    </script>
</head>
<body>
    <header>
        <img src="../images/INSIGNIA SF.png" alt="Escuela Porongo Insignia">
        <h1>Registro de Equipos del Laboratorio</h1>
    
    <nav>
        <ul>
            <li><a href="../index.php">Inicio</a></li>
        </ul>
    </nav>
        </header>
    <main>
        <div class="form-container">
            <div class="form-header">
                <h2>Formulario de Registro</h2>
            </div>
            <form action="" method="POST" enctype="multipart/form-data">
                <div class="form-grid">
                    <div>
                        <label for="nombre_equipo">Nombre del Equipo:</label>
                        <input type="text" id="nombre_equipo" name="nombre_equipo" required>
                    </div>
                    <div>
                        <label for="ubicacion">Ubicación:</label>
                        <input type="text" id="ubicacion" name="ubicacion" required>
                    </div>
                    <div>
                        <label for="marca">Marca:</label>
                        <input type="text" id="marca" name="marca" required>
                    </div>
                    <div>
                        <label for="modelo">Modelo:</label>
                        <input type="text" id="modelo" name="modelo" required>
                    </div>
                    <div>
                        <label for="numero_serie">Número de Serie:</label>
                        <input type="text" id="numero_serie" name="numero_serie">
                    </div>
                    <div>
                        <label for="procesador">Procesador:</label>
                        <input type="text" id="procesador" name="procesador">
                    </div>
                    <div>
                        <label for="memoria_ram">Memoria RAM:</label>
                        <input type="text" id="memoria_ram" name="memoria_ram">
                    </div>
                    <div>
                        <label for="almacenamiento">Almacenamiento:</label>
                        <input type="text" id="almacenamiento" name="almacenamiento">
                    </div>
                    <div>
                        <label for="tarjeta_grafica">Tarjeta Gráfica:</label>
                        <input type="text" id="tarjeta_grafica" name="tarjeta_grafica">
                    </div>
                    <div>
                        <label for="sistema_operativo">Sistema Operativo:</label>
                        <input type="text" id="sistema_operativo" name="sistema_operativo" required>
                    </div>
                    <div>
                        <label for="version_so">Versión del SO:</label>
                        <input type="text" id="version_so" name="version_so">
                    </div>
                    <div class="full-width">
                        <label for="programas_instalados">Programas Instalados:</label>
                        <textarea id="programas_instalados" name="programas_instalados" rows="4"></textarea>
                    </div>
                    <div>
                        <label for="estado_equipo">Estado del Equipo:</label>
                        <select id="estado_equipo" name="estado_equipo_id" required>
                            <?php foreach ($estados as $estado): ?>
                                <option value="<?php echo $estado['id']; ?>"><?php echo $estado['nombre_estado']; ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="full-width">
                        <label for="observaciones">Observaciones:</label>
                        <textarea id="observaciones" name="observaciones" rows="4"></textarea>
                    </div>
                    <div>
                        <label for="fecha_ultimo_mantenimiento">Fecha de Último Mantenimiento:</label>
                        <input type="date" id="fecha_ultimo_mantenimiento" name="fecha_ultimo_mantenimiento">
                    </div>
                    <div>
                        <label for="detalles_mantenimiento">Detalles del Mantenimiento:</label>
                        <textarea id="detalles_mantenimiento" name="detalles_mantenimiento" rows="4"></textarea>
                    </div>
                    <div>
                        <label for="proxima_fecha_mantenimiento">Próxima Fecha de Mantenimiento:</label>
                        <input type="date" id="proxima_fecha_mantenimiento" name="proxima_fecha_mantenimiento">
                    </div>
                    <div class="full-width">
                        <label for="imagen_equipo">Imagen del Equipo:</label>
                        <input type="file" id="imagen_equipo" name="imagen_equipo" accept="image/*">
                    </div>
                </div>
                <button type="submit">Guardar Equipo</button>
            </form>
        </div>
    </main>
    <div id="notification" class="notification"></div>
</body>
</html>