<?php
include '../includes/db.php';
include '../includes/auth.php';
checkAuth();

$id = intval($_POST['id']);

if (isset($_FILES['imagen']) && $_FILES['imagen']['error'] == 0) {
    $allowed_types = ['jpg', 'jpeg', 'png', 'gif'];
    $file_name = $_FILES['imagen']['name'];
    $file_size = $_FILES['imagen']['size'];
    $file_tmp = $_FILES['imagen']['tmp_name'];
    $file_ext = strtolower(pathinfo($file_name, PATHINFO_EXTENSION));

    if (in_array($file_ext, $allowed_types)) {
        $new_file_name = uniqid() . '.' . $file_ext;
        $upload_path = '../uploads/equipos/' . $new_file_name;

        if (move_uploaded_file($file_tmp, $upload_path)) {
            // Guardar el nombre del archivo en la base de datos
            $stmt = $conn->prepare("UPDATE equipos SET imagen = ? WHERE id = ?");
            $stmt->bind_param("si", $new_file_name, $id);
            $stmt->execute();
            $stmt->close();

            header("Location: equipo_detalles.php?id=$id&message=" . urlencode("Imagen subida exitosamente.") . "&message_type=success");
        } else {
            header("Location: equipo_detalles.php?id=$id&message=" . urlencode("Error al subir la imagen.") . "&message_type=error");
        }
    } else {
        header("Location: equipo_detalles.php?id=$id&message=" . urlencode("Tipo de archivo no permitido.") . "&message_type=error");
    }
} else {
    header("Location: equipo_detalles.php?id=$id&message=" . urlencode("No se ha seleccionado ningún archivo o ha ocurrido un error.") . "&message_type=error");
}
