<?php
include '../includes/db.php';
include '../includes/auth.php';
checkAuth();

// Obtener el ID del equipo a visualizar
$id = intval($_GET['id']);

// Verificar si se ha obtenido un ID válido
if ($id <= 0) {
    die("ID de equipo inválido.");
}

// Obtener los datos básicos del equipo
$stmt = $conn->prepare("SELECT * FROM equipo WHERE id = ?");
$stmt->bind_param("i", $id);
$stmt->execute();
$result = $stmt->get_result();
$equipo = $result->fetch_assoc();
$stmt->close();

// Verificar si se encontró el equipo
if (!$equipo) {
    die("Equipo no encontrado.");
}

// Obtener los detalles del equipo
$stmt = $conn->prepare("SELECT * FROM detalles_equipo WHERE equipo_id = ?");
$stmt->bind_param("i", $id);
$stmt->execute();
$result = $stmt->get_result();
$detalles = $result->fetch_assoc();
$stmt->close();

// Verificar si se encontraron los detalles
if (!$detalles) {
    die("Detalles del equipo no encontrados.");
}

// Obtener el mantenimiento del equipo
$stmt = $conn->prepare("SELECT * FROM mantenimiento_equipo WHERE equipo_id = ?");
$stmt->bind_param("i", $id);
$stmt->execute();
$result = $stmt->get_result();
$mantenimiento = $result->fetch_assoc();
$stmt->close();

// Obtener el software instalado en el equipo
$stmt = $conn->prepare("SELECT * FROM software_instalado WHERE equipo_id = ?");
$stmt->bind_param("i", $id);
$stmt->execute();
$result = $stmt->get_result();
$software = $result->fetch_assoc();
$stmt->close();

// Obtener el estado del equipo desde la tabla estado_equipo
$stmt = $conn->prepare("SELECT nombre_estado FROM estado_equipo WHERE id = ?");
$stmt->bind_param("i", $equipo['estado_equipo_id']);
$stmt->execute();
$result = $stmt->get_result();
$estado_equipo = $result->fetch_assoc();
$stmt->close();
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Detalles del Equipo</title>
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Roboto:400,700&display=swap">
    <link rel="stylesheet" href="../css/ver_equipo.css">
    <style>
       
    </style>
</head>
<body>
    <header>
        <img src="../images/INSIGNIA SF.png" alt="Escuela Porongo Insignia">
        <h1>Detalles del Equipo</h1>
    
    <nav>
        <ul>
            <li><a href="../index.php">Inicio</a></li>
            <li><a href="crud_equipos.php">Volver a la lista de equipos</a></li>
        </ul>
    </nav>
        </header>
    <main>
        <div class="form-container">
            <div class="form-header">
                <h2><?php echo htmlspecialchars($equipo['nombre_equipo'], ENT_QUOTES, 'UTF-8'); ?></h2>
            </div>

            <div class="contenido">
                <div class="imagen">
                    <?php if (!empty($detalles['imagen'])): ?>
                        <img src="<?php echo htmlspecialchars($detalles['imagen'], ENT_QUOTES, 'UTF-8'); ?>" alt="Imagen del Equipo">
                    <?php else: ?>
                        <p class="no-imagen">No hay imagen disponible.</p>
                    <?php endif; ?>
                </div>
                <div class="tabla">
                    <table class="especificaciones">
                        <thead>
                            <tr>
                                <th colspan="2">Especificaciones Técnicas</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td>Ubicación</td>
                                <td><?php echo htmlspecialchars($equipo['ubicacion'] ?? '', ENT_QUOTES, 'UTF-8'); ?></td>
                            </tr>
                            <tr>
                                <td>Marca</td>
                                <td><?php echo htmlspecialchars($detalles['marca'] ?? '', ENT_QUOTES, 'UTF-8'); ?></td>
                            </tr>
                            <tr>
                                <td>Modelo</td>
                                <td><?php echo htmlspecialchars($detalles['modelo'] ?? '', ENT_QUOTES, 'UTF-8'); ?></td>
                            </tr>
                            <tr>
                                <td>Número de Serie</td>
                                <td><?php echo htmlspecialchars($detalles['numero_serie'] ?? '', ENT_QUOTES, 'UTF-8'); ?></td>
                            </tr>
                            <tr>
                                <td>Procesador</td>
                                <td><?php echo htmlspecialchars($detalles['procesador'] ?? '', ENT_QUOTES, 'UTF-8'); ?></td>
                            </tr>
                            <tr>
                                <td>Memoria RAM</td>
                                <td><?php echo htmlspecialchars($detalles['memoria_ram'] ?? '', ENT_QUOTES, 'UTF-8'); ?></td>
                            </tr>
                            <tr>
                                <td>Almacenamiento</td>
                                <td><?php echo htmlspecialchars($detalles['almacenamiento'] ?? '', ENT_QUOTES, 'UTF-8'); ?></td>
                            </tr>
                            <tr>
                                <td>Tarjeta Gráfica</td>
                                <td><?php echo htmlspecialchars($detalles['tarjeta_grafica'] ?? '', ENT_QUOTES, 'UTF-8'); ?></td>
                            </tr>
                            <tr>
                                <td>Sistema Operativo</td>
                                <td><?php echo htmlspecialchars($detalles['sistema_operativo'] ?? '', ENT_QUOTES, 'UTF-8'); ?></td>
                            </tr>
                            <tr>
                                <td>Versión del SO</td>
                                <td><?php echo htmlspecialchars($detalles['version_so'] ?? '', ENT_QUOTES, 'UTF-8'); ?></td>
                            </tr>
                            <tr>
                                <td>Estado del Equipo</td>
                                <td><?php echo htmlspecialchars($estado_equipo['nombre_estado'] ?? 'Desconocido', ENT_QUOTES, 'UTF-8'); ?></td>
                            </tr>
                            <tr>
                                <td>Fecha de Último Mantenimiento</td>
                                <td><?php echo htmlspecialchars($mantenimiento['fecha_ultimo_mantenimiento'] ?? 'No registrado', ENT_QUOTES, 'UTF-8'); ?></td>
                            </tr>
                            <tr>
                                <td>Detalles del Mantenimiento</td>
                                <td><?php echo nl2br(htmlspecialchars($mantenimiento['detalles_mantenimiento'] ?? 'No registrado', ENT_QUOTES, 'UTF-8')); ?></td>
                            </tr>
                            <tr>
                                <td>Próxima Fecha de Mantenimiento</td>
                                <td><?php echo htmlspecialchars($mantenimiento['proxima_fecha_mantenimiento'] ?? 'No programado', ENT_QUOTES, 'UTF-8'); ?></td>
                            </tr>
                            <tr>
                                <td>Programas Instalados</td>
                                <td><?php echo nl2br(htmlspecialchars($software['programas_instalados'] ?? 'No registrados', ENT_QUOTES, 'UTF-8')); ?></td>
                            </tr>
                            <tr>
                                <td>Observaciones</td>
                                <td><?php echo nl2br(htmlspecialchars($mantenimiento['observaciones'] ?? 'Ninguna', ENT_QUOTES, 'UTF-8')); ?></td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </main>
</body>
</html>

                                
