<?php
session_start();
include '../includes/db.php'; // Incluir la conexión a la base de datos
include '../includes/auth.php'; // Incluir autenticación
checkAuth(); // Verificar autenticación
require '../vendor/autoload.php'; // Asegúrate de incluir el autoloader de Composer
use PhpOffice\PhpSpreadsheet\IOFactory;

$message = '';
$message_type = '';

// Procesar el formulario
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_FILES['excel_equipo'])) {
    if ($_FILES['excel_equipo']['error'] === UPLOAD_ERR_OK) {
        $file = $_FILES['excel_equipo']['tmp_name'];
        $spreadsheet = IOFactory::load($file);
        $sheetData = $spreadsheet->getActiveSheet()->toArray(null, true, true, true);

        // Iniciar una transacción para asegurar que todas las inserciones se realicen correctamente
        $conn->begin_transaction();

        try {
            foreach ($sheetData as $row) {
                // Asegúrate de que tu Excel tenga el formato correcto
                list($nombre_equipo, $ubicacion, $estado_equipo_id, $marca, $modelo, $numero_serie, $procesador, $memoria_ram, $almacenamiento, $tarjeta_grafica, $sistema_operativo, $version_so, $programas_instalados, $observaciones, $fecha_ultimo_mantenimiento, $detalles_mantenimiento, $proxima_fecha_mantenimiento) = $row;

                // Validación básica: omitir filas vacías
                if (empty($nombre_equipo)) continue;

                // Insertar datos en la tabla equipo
                $sql_equipo = "INSERT INTO equipo (nombre_equipo, ubicacion, estado_equipo_id) VALUES (?, ?, ?)";
                $stmt_equipo = $conn->prepare($sql_equipo);
                $stmt_equipo->bind_param("ssi", $nombre_equipo, $ubicacion, $estado_equipo_id);
                $stmt_equipo->execute();
                $equipo_id = $stmt_equipo->insert_id; // Obtener el ID del equipo insertado

                // Insertar los detalles del equipo en la tabla detalles_equipo
                $sql_detalles = "INSERT INTO detalles_equipo (equipo_id, marca, modelo, numero_serie, procesador, memoria_ram, almacenamiento, tarjeta_grafica, sistema_operativo, version_so) 
                                 VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
                $stmt_detalles = $conn->prepare($sql_detalles);
                $stmt_detalles->bind_param("isssssssss", $equipo_id, $marca, $modelo, $numero_serie, $procesador, $memoria_ram, $almacenamiento, $tarjeta_grafica, $sistema_operativo, $version_so);
                $stmt_detalles->execute();

                // Insertar los datos del mantenimiento en la tabla mantenimiento_equipo
                $sql_mantenimiento = "INSERT INTO mantenimiento_equipo (equipo_id, fecha_ultimo_mantenimiento, detalles_mantenimiento, proxima_fecha_mantenimiento, observaciones) 
                                      VALUES (?, ?, ?, ?, ?)";
                $stmt_mantenimiento = $conn->prepare($sql_mantenimiento);
                $stmt_mantenimiento->bind_param("issss", $equipo_id, $fecha_ultimo_mantenimiento, $detalles_mantenimiento, $proxima_fecha_mantenimiento, $observaciones);
                $stmt_mantenimiento->execute();
            }

            // Confirmar la transacción
            $conn->commit();
            $message = "Equipos cargados exitosamente.";
            $message_type = 'success';
        } catch (Exception $e) {
            // Revertir la transacción en caso de error
            $conn->rollback();
            $message = "Error: " . $e->getMessage();
            $message_type = 'error';
        }
    } else {
        $message = "Error al subir el archivo.";
        $message_type = 'error';
    }
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Cargar Equipos desde Excel</title>
</head>
<body>
    <h1>Cargar Equipos desde Excel</h1>
    <?php if ($message): ?>
        <div class="<?php echo htmlspecialchars($message_type); ?>">
            <?php echo htmlspecialchars($message); ?>
        </div>
    <?php endif; ?>

    <form action="" method="POST" enctype="multipart/form-data">
        <label for="excel_equipo">Seleccionar archivo Excel:</label>
        <input type="file" id="excel_equipo" name="excel_equipo" accept=".xlsx, .xls" required>
        <button type="submit">Cargar Equipos</button>
    </form>
</body>
</html>

<?php
$conn->close();
?>
