<?php
require __DIR__ . '/../vendor/autoload.php';
 // Incluye la biblioteca PhpSpreadsheet
use PhpOffice\PhpSpreadsheet\IOFactory;
use PhpOffice\PhpSpreadsheet\Spreadsheet;

include '../includes/db.php';
include '../includes/auth.php'; // `session_start()` ya está incluido aquí

checkAuth();
if ($_SESSION['rol'] != 'profesor' && !isAdmin()) {
    header("Location: ../index.php");
    exit();
}

$conn->set_charset("utf8mb4");

$cursos = []; // Almacena los cursos disponibles
$sql = "SELECT id, nombre FROM curso";
$result = $conn->query($sql);
while ($curso = $result->fetch_assoc()) {
    $cursos[] = $curso; // Agrega cada curso al array
}

// Descargar plantilla Excel
if (isset($_GET['download_template'])) {
    $spreadsheet = new Spreadsheet();
    $sheet = $spreadsheet->getActiveSheet();

    // Agregar encabezados
    $headers = ['Nombre', 'Apellido Paterno', 'Apellido Materno', 'RUT', 'Contraseña'];
    foreach ($headers as $index => $header) {
        $sheet->setCellValueByColumnAndRow($index + 1, 1, $header); // Colocar encabezados en la primera fila
    }

    // Configurar el archivo para descarga
    $filename = "plantilla_estudiantes.xlsx";
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("Content-Disposition: attachment;filename=\"$filename\"");
    header('Cache-Control: max-age=0');

    $writer = IOFactory::createWriter($spreadsheet, 'Xlsx');
    $writer->save('php://output');
    exit();
}

// Procesar la carga del archivo Excel
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['importar']) && isset($_FILES['file'])) {
    $curso_id = intval($_POST['curso_id']); // Recoge el ID del curso desde el formulario
    $file = $_FILES['file']['tmp_name'];
    $file_type = $_FILES['file']['type']; // Obtener el tipo MIME del archivo cargado
    $allowed_types = ['application/vnd.openxmlformats-officedocument.spreadsheetml.sheet', 'application/vnd.ms-excel']; // Tipos MIME permitidos

    // Verificar si el archivo es de tipo Excel
    if (!in_array($file_type, $allowed_types)) {
        $_SESSION['message'] = "Error: Solo se permiten archivos Excel (.xls, .xlsx)";
        $_SESSION['message_type'] = 'error';
        header("Location: " . $_SERVER['PHP_SELF']);
        exit();
    }

    try {
        $spreadsheet = IOFactory::load($file);
        $sheet = $spreadsheet->getActiveSheet();
        $rows = $sheet->toArray();

        // Verificar la estructura del archivo Excel
        $expected_headers = ['Nombre', 'Apellido Paterno', 'Apellido Materno', 'RUT', 'Contraseña'];
        $file_headers = array_map('trim', $rows[0]); // Obtener los encabezados de la primera fila

        // Comprobar si los encabezados del archivo coinciden con los esperados
        if ($file_headers !== $expected_headers) {
            $_SESSION['message'] = "Error: El formato del archivo no coincide con el formato esperado. Las columnas deben ser: " . implode(', ', $expected_headers);
            $_SESSION['message_type'] = 'error';
            header("Location: " . $_SERVER['PHP_SELF']);
            exit();
        }

        array_shift($rows); // Saltar la primera fila si contiene encabezados

        // Preparar la inserción de los datos
        $stmtInsert = $conn->prepare("
    INSERT INTO usuario (rut, nombre, apellido_paterno, apellido_materno, contraseña, rol_id, curso_id)
    VALUES (?, ?, ?, ?, ?, ?, ?)
    ON DUPLICATE KEY UPDATE
        nombre = VALUES(nombre),
        apellido_paterno = VALUES(apellido_paterno),
        apellido_materno = VALUES(apellido_materno),
        contraseña = VALUES(contraseña),
        rol_id = VALUES(rol_id),
        curso_id = VALUES(curso_id)
");

        if (!$stmtInsert) {
            throw new Exception("Error preparando la consulta: " . $conn->error);
        }

        $rol_id = 3; // Asignar el rol_id para estudiantes
        foreach ($rows as $row) {
    $nombre = $conn->real_escape_string(trim($row[0]));
    $apellido_paterno = $conn->real_escape_string(trim($row[1]));
    $apellido_materno = $conn->real_escape_string(trim($row[2]));
    $rut = $conn->real_escape_string(trim($row[3]));
    $contrasena = password_hash(trim($row[4]), PASSWORD_BCRYPT);

    $stmtInsert->bind_param("ssssiii", $rut, $nombre, $apellido_paterno, $apellido_materno, $contrasena, $rol_id, $curso_id);
    if (!$stmtInsert->execute()) {
        throw new Exception("Error al insertar o actualizar datos: " . $conn->error);
    }
}


        $stmtInsert->close();
        $_SESSION['message'] = "Estudiantes importados exitosamente al curso seleccionado.";
        $_SESSION['message_type'] = 'success'; // Tipo de mensaje exitoso
    } catch (Exception $e) {
        $_SESSION['message'] = "Error: " . $e->getMessage();
        $_SESSION['message_type'] = 'error'; // Tipo de mensaje de error
    }

    $conn->close();
    header("Location: " . $_SERVER['PHP_SELF']);
    exit();
}

?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Importar Estudiantes</title>
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Roboto:400,700&display=swap"> <!-- Fuente moderna -->
    <link rel="stylesheet" href="../css/importar_excel.css">
    <style>
        
    </style>
    <script>
        // Mostrar el mensaje flotante y desaparecerlo después de 2 segundos
        window.onload = function() {
            const message = document.querySelector('.mensaje');
            if (message) {
                message.classList.add('show');
                setTimeout(() => {
                    message.classList.remove('show');
                }, 2000); // 2 segundos
            }
        };
    </script>
</head>
<body>
    <header>
        <img src="../images/INSIGNIA SF.png" alt="Escuela Porongo Insignia">
        <h1 style="font-size: 20px; margin: 5px 0;">Importar Estudiantes</h1>
    
    <nav>
        <ul>
            <li><a href="../index.php">Inicio</a></li>
            <li><a href="?download_template=true">Descargar Plantilla Excel</a></li> <!-- Botón para descargar la plantilla -->
        </ul>
    </nav>
        </header>
    <main>
        <?php if (isset($_SESSION['message'])): ?>
            <div class="mensaje <?php echo isset($_SESSION['message_type']) && $_SESSION['message_type'] == 'error' ? 'error' : 'success'; ?> show">
                <?php echo $_SESSION['message']; unset($_SESSION['message']); unset($_SESSION['message_type']); ?>
            </div>
        <?php endif; ?>
        <form method="POST" action="" enctype="multipart/form-data">
            <label for="curso_id">Curso:</label>
            <select id="curso_id" name="curso_id" required>
                <?php foreach ($cursos as $curso): ?>
                    <option value="<?php echo $curso['id']; ?>"><?php echo htmlspecialchars($curso['nombre']); ?></option>
                <?php endforeach; ?>
            </select>
            <label for="file">Subir archivo Excel:</label>
            <input type="file" id="file" name="file" accept=".xls, .xlsx" required>
            <button type="submit" name="importar">Importar Estudiantes</button>
        </form>
    </main>
</body>
</html>

