<?php
include '../includes/db.php'; // Incluir archivo de conexión a la base de datos
include '../includes/auth.php'; // Incluir archivo de autenticación
checkAuth(); // Verificar si el usuario está autenticado

// Establecer la codificación de caracteres para la conexión de la base de datos
$conn->set_charset("utf8");

// Obtener los datos de las horas agendadas
$result = $conn->query("SELECT horario.*, curso.nombre AS curso_nombre, CONCAT(usuario.nombre, ' ', usuario.apellido_paterno, ' ', usuario.apellido_materno) AS usuario_nombre 
                        FROM horario 
                        JOIN curso ON horario.curso_id = curso.id 
                        JOIN usuario ON horario.usuario_id = usuario.id");

// Iniciar la salida del archivo Excel
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment; filename="horarios_agendados.xlsx"');
header('Cache-Control: max-age=0');

// Crear una tabla en formato Excel
echo "<table border='1'>";
echo "<tr><th>ID</th><th>Fecha</th><th>Hora Inicio</th><th>Hora Fin</th><th>Curso</th><th>Usuario</th></tr>";

while ($row = $result->fetch_assoc()) {
    echo "<tr>";
    echo "<td>" . htmlspecialchars($row['id']) . "</td>";
    echo "<td>" . htmlspecialchars($row['fecha']) . "</td>";
    echo "<td>" . htmlspecialchars($row['hora_inicio']) . "</td>";
    echo "<td>" . htmlspecialchars($row['hora_fin']) . "</td>";
    echo "<td>" . htmlspecialchars($row['curso_nombre']) . "</td>";
    echo "<td>" . htmlspecialchars($row['usuario_nombre']) . "</td>";
    echo "</tr>";
}
echo "</table>";

$conn->close();
exit();
