<?php
header('Content-Type: text/html; charset=utf-8');
include '../includes/db.php'; // Incluir archivo de conexión a la base de datos
include '../includes/auth.php'; // Incluir archivo de autenticación
checkAuth(); // Verificar si el usuario está autenticado
$conn->set_charset("utf8");
// Obtener usuarios (solo los que tienen el rol de profesor si es admin)
$usuarios = [];
if (isAdmin()) {
    $result = $conn->query("SELECT id, nombre, apellido_paterno, apellido_materno FROM usuario WHERE rol_id IN (1, 2)");
    if ($result) {
        while ($row = $result->fetch_assoc()) {
            $usuarios[] = $row;
        }
    } else {
        die("Error al obtener los usuarios: " . $conn->error);
    }
} else {
    // Los usuarios no admin no pueden seleccionar otros usuarios
    // Puedes dejar el array vacío o asignar al usuario logueado como único
    $usuarios[] = [
        'id' => $_SESSION['usuario_id'],
        
    ];
}
$bloques = [
    "mañana" => [
        ["08:20:00", "09:05:00"],
        ["09:05:00", "09:50:00"],
        ["10:10:00", "10:55:00"],
        ["10:55:00", "11:40:00"],
        ["12:00:00", "12:45:00"],
        ["12:45:00", "13:30:00"]
    ],
    "tarde" => [
        ["14:15:00", "15:00:00"],
        ["15:00:00", "15:45:00"]
    ]
];

$message = '';
$message_type = '';

// Lógica para descargar horas agendadas en Excel
if (isset($_GET['download']) && isAdmin()) {
    $result = $conn->query("SELECT horario.*, curso.nombre AS curso_nombre, CONCAT(usuario.nombre, ' ', usuario.apellido_paterno, ' ', usuario.apellido_materno) AS usuario_nombre 
                            FROM horario 
                            JOIN curso ON horario.curso_id = curso.id 
                            JOIN usuario ON horario.usuario_id = usuario.id");

    // Crear archivo Excel
    header('Content-Type: application/vnd.ms-excel');
    header('Content-Disposition: attachment; filename="horas_agendadas.xls"');

    echo "<table>";
    echo "<tr>
            <th>ID</th>
            <th>Fecha</th>
            <th>Hora Inicio</th>
            <th>Hora Fin</th>
            <th>Curso</th>
            <th>Usuario</th>
          </tr>";

    while ($row = $result->fetch_assoc()) {
        echo "<tr>
                <td>" . htmlspecialchars($row['id']) . "</td>
                <td>" . htmlspecialchars($row['fecha']) . "</td>
                <td>" . htmlspecialchars($row['hora_inicio']) . "</td>
                <td>" . htmlspecialchars($row['hora_fin']) . "</td>
                <td>" . htmlspecialchars($row['curso_nombre']) . "</td>
                <td>" . htmlspecialchars($row['usuario_nombre']) . "</td>
              </tr>";
    }

    echo "</table>";
    exit();
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    if (isset($_POST['eliminar']) && isAdmin()) {
        $horario_id = $_POST['horario_id'];
        $stmt = $conn->prepare("DELETE FROM horario WHERE id = ?");
        $stmt->bind_param("i", $horario_id);
        if ($stmt->execute()) {
            $message = "Hora eliminada correctamente.";
            $message_type = 'exito';
        } else {
            $message = "Error al eliminar la hora.";
            $message_type = 'error';
        }
        $stmt->close();
    } else {
        $fecha = $_POST['fecha'];
        list($hora_inicio, $hora_fin) = explode(',', $_POST['bloque']);
        $usuario_id = $_POST['usuario_id'];  // Asegúrate de usar el usuario seleccionado o el propio usuario.
        $curso_id = $_POST['curso_id'];

        // Verificar si ya existe una hora agendada para ese bloque
        $stmt = $conn->prepare("SELECT COUNT(*) FROM horario WHERE fecha = ? AND hora_inicio = ? AND hora_fin = ?");
        $stmt->bind_param("sss", $fecha, $hora_inicio, $hora_fin);
        $stmt->execute();
        $stmt->bind_result($count);
        $stmt->fetch();
        $stmt->close();

        if ($count == 0) {
            $stmt = $conn->prepare("INSERT INTO horario (usuario_id, fecha, hora_inicio, hora_fin, curso_id) VALUES (?, ?, ?, ?, ?)");
            $stmt->bind_param("isssi", $usuario_id, $fecha, $hora_inicio, $hora_fin, $curso_id);
            if ($stmt->execute()) {
                $message = "Hora agendada correctamente.";
                $message_type = 'exito';
            } else {
                $message = "Error al agendar la hora.";
                $message_type = 'error';
            }
            $stmt->close();
        } else {
            $message = "Este bloque ya está ocupado. Por favor, selecciona otro.";
            $message_type = 'error';
        }
    }
    header("Location: schedule.php?message=" . urlencode($message) . "&type=" . urlencode($message_type));
    exit();
}
// Obtener eventos de la tabla 'horario'
$result = $conn->query("
    SELECT horario.*, 
           COALESCE(curso.nombre, 'Reunión') AS curso_nombre, 
           CONCAT(usuario.nombre, ' ', usuario.apellido_paterno, ' ', usuario.apellido_materno) AS usuario_nombre 
    FROM horario 
    LEFT JOIN curso ON horario.curso_id = curso.id 
    JOIN usuario ON horario.usuario_id = usuario.id
");

$eventos = [];
while ($row = $result->fetch_assoc()) {
    $eventos[] = [
        'id' => $row['id'],
        'title' => $row['usuario_nombre'] . ' (' . $row['curso_nombre'] . ')',
        'start' => $row['fecha'] . 'T' . $row['hora_inicio'],
        'end' => $row['fecha'] . 'T' . $row['hora_fin'],
        'extendedProps' => [
            'curso_nombre' => $row['curso_nombre'],
            'usuario_nombre' => $row['usuario_nombre'],
            'fecha' => $row['fecha'],
            'hora_inicio' => $row['hora_inicio'],
            'hora_fin' => $row['hora_fin'],
        ],
    ];
}
$result->free();

// Obtener cursos
$cursos = $conn->query("SELECT id, nombre FROM curso WHERE activo = 1 ORDER BY nombre ASC;");


if ($cursos === FALSE) {
    die("Error al obtener los cursos: " . $conn->error);
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Agendar Horas</title>
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Roboto:400,700&display=swap">
    <link href='https://cdn.jsdelivr.net/npm/fullcalendar@5.11.0/main.min.css' rel='stylesheet' />
    <link rel="stylesheet" href="../css/horario.css">
    <script src='https://cdn.jsdelivr.net/npm/fullcalendar@5.11.0/main.min.js'></script>
    <script src='https://cdn.jsdelivr.net/npm/fullcalendar@5.11.0/locales/es.js'></script>
    <style>
    
</style>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            var calendarEl = document.getElementById('calendar');
            var tooltip = document.createElement('div');
            tooltip.className = 'tooltip';
            document.body.appendChild(tooltip);

            var calendar = new FullCalendar.Calendar(calendarEl, {
                initialView: 'timeGridWeek',
                locale: 'es',
                slotDuration: '00:45:00',
                slotMinTime: '08:20:00',
                slotMaxTime: '15:45:00',
                hiddenDays: [0, 6],
                allDaySlot: false,
                slotLabelFormat: {
                    hour: '2-digit',
                    minute: '2-digit',
                    omitZeroMinute: false,
                    meridiem: false
                },
                eventTimeFormat: {
                    hour: '2-digit',
                    minute: '2-digit',
                    omitZeroMinute: false,
                    meridiem: false
                },
                events: <?php echo json_encode($eventos); ?>,
                dateClick: function(info) {
                    var fecha = info.dateStr.split("T")[0];
                    var bloques = getAvailableBlocks(fecha);
                    var options = bloques.map(function(bloque) {
                        return '<option value="' + bloque[0] + ',' + bloque[1] + '">' + bloque[0] + ' - ' + bloque[1] + '</option>';
                    }).join('');
                    document.getElementById('fecha').value = fecha;
                    document.getElementById('bloque').innerHTML = options;
                    document.getElementById('form-agenda').style.display = 'block';
                },
                eventClick: function(info) {
                    <?php if (isAdmin()): ?>
                    if (confirm("¿Desea eliminar este evento?")) {
                        document.getElementById('horario_id').value = info.event.id;
                        document.getElementById('form-eliminar').submit();
                    }
                    <?php endif; ?>
                },
                eventMouseEnter: function(info) {
                    var event = info.event;
                    tooltip.innerHTML = `
                        <strong>Docente:</strong> ${event.extendedProps.usuario_nombre}<br>
                        <strong>Curso:</strong> ${event.extendedProps.curso_nombre}<br>
                        <strong>Fecha:</strong> ${event.extendedProps.fecha}<br>
                        <strong>Hora Inicio:</strong> ${event.extendedProps.hora_inicio}<br>
                        <strong>Hora Fin:</strong> ${event.extendedProps.hora_fin}
                    `;
                    tooltip.style.display = 'block';
                    tooltip.style.left = info.jsEvent.pageX + 'px';
                    tooltip.style.top = info.jsEvent.pageY + 'px';
                },
                eventMouseLeave: function(info) {
                    tooltip.style.display = 'none';
                },
                contentHeight: 'auto',
                aspectRatio: 1.5,
                headerToolbar: {
                    left: 'prev,next today',
                    center: 'title',
                    right: 'timeGridWeek,timeGridDay'
                }
            });
            calendar.render();

            // Mostrar el mensaje flotante y desaparecerlo después de 2 segundos
            const params = new URLSearchParams(window.location.search);
            const message = params.get('message');
            const type = params.get('type');
            if (message && type) {
                const messageDiv = document.createElement('div');
                messageDiv.className = 'mensaje ' + type + ' show';
                messageDiv.textContent = message;
                document.body.appendChild(messageDiv);
                setTimeout(() => {
                    messageDiv.classList.remove('show');
                    setTimeout(() => {
                        document.body.removeChild(messageDiv);
                    }, 500); // Espera a que se termine la transición
                }, 2000);
            }
        });

        function getAvailableBlocks(date) {
            var bloques = <?php echo json_encode($bloques); ?>;
            var bloques_ocupados = [];

            var xhr = new XMLHttpRequest();
            xhr.open('GET', 'get_occupied_blocks.php?date=' + date, false);
            xhr.onreadystatechange = function () {
                if (xhr.readyState == 4 && xhr.status == 200) {
                    bloques_ocupados = JSON.parse(xhr.responseText);
                }
            };
            xhr.send();

            var bloques_disponibles = [];
            var bloques_todo = bloques["mañana"].concat(bloques["tarde"]);

            for (var i = 0; i < bloques_todo.length; i++) {
                var bloque = bloques_todo[i];
                var ocupado = false;
                for (var j = 0; j < bloques_ocupados.length; j++) {
                    if (bloque[0] == bloques_ocupados[j].hora_inicio && bloque[1] == bloques_ocupados[j].hora_fin) {
                        ocupado = true;
                        break;
                    }
                }
                if (!ocupado) {
                    bloques_disponibles.push(bloque);
                }
            }

            return bloques_disponibles;
        }
        // Mostrar el mensaje flotante y desaparecerlo después de 2 segundos
const params = new URLSearchParams(window.location.search);
const message = params.get('message');
const type = params.get('type');
if (message && type) {
    const messageDiv = document.createElement('div');
    messageDiv.className = 'mensaje ' + type + ' show';
    messageDiv.textContent = decodeURIComponent(message);
    document.body.appendChild(messageDiv);
    setTimeout(() => {
        messageDiv.classList.remove('show');
        setTimeout(() => {
            document.body.removeChild(messageDiv);
        }, 500);
    }, 2500);
}
 function mostrarFormulario() {
        document.getElementById('form-agenda').style.display = 'block';
    }
    function cerrarFormulario() {
        document.getElementById('form-agenda').style.display = 'none';
    }    
    </script> 
</head>
<body>  
<div id="form-agenda">
    <h3 style="margin-top: 0; text-align: center;">Agendar Hora</h3>
    <button onclick="cerrarFormulario()" style="float:right;background:#f44336;margin-bottom:10px;">X</button>
    <form method="POST" action="">
        <input type="hidden" name="fecha" id="fecha">
        <label for="bloque">Bloque:</label>
        <select name="bloque" id="bloque"></select>

        <?php if (isAdmin()): ?>
        <label for="usuario_id">Docente:</label>
        <select name="usuario_id" required>
            <option value="" selected disabled>Seleccione un Docente</option>
            <?php foreach ($usuarios as $usuario): ?>
                <option value="<?= $usuario['id'] ?>">
                    <?= $usuario['nombre'] . ' ' . $usuario['apellido_paterno'] . ' ' . $usuario['apellido_materno'] ?>
                </option>
            <?php endforeach; ?>
        </select>
        <?php else: ?>
            <input type="hidden" name="usuario_id" value="<?= $_SESSION['usuario_id'] ?>">
        <?php endif; ?>

        <label for="curso_id">Curso:</label>
<select id="curso_id" name="curso_id" required style="...">
    <option value="" disabled selected>Seleccione un curso</option>
    <?php 
    // Reiniciar el puntero del resultado para recorrerlo de nuevo
    $cursos->data_seek(0);
    while ($curso = $cursos->fetch_assoc()): ?>
        <option value="<?php echo $curso['id']; ?>"><?php echo htmlspecialchars($curso['nombre'], ENT_QUOTES, 'UTF-8'); ?></option>
    <?php endwhile; ?>
    <?php if (isAdmin()): ?>
        <option value="0">Reunión</option>
    <?php endif; ?>
</select>


        <button type="submit">Agendar</button>
    </form>
</div>
<form id="form-eliminar" method="POST" style="display:none;">
    <input type="hidden" name="eliminar" value="1">
    <input type="hidden" name="horario_id" id="horario_id">
</form>

    <header>
        <img src="../images/INSIGNIA SF.png" alt="Escuela Porongo Insignia">
        <h1>Agendar Horas</h1>
    
    <nav>
        <ul>
            <li><a href="../index.php">Inicio</a></li>
            <?php if (isAdmin()): ?>
                <li><a href="schedule.php?download=1">Descargar Horas Agendadas</a></li>
            <?php endif; ?>
        </ul>
    </nav>
        </header>
<main>
    <div id='calendar'></div>
    
    <form id="form-agenda" method="POST" action="/horario/schedule.php" style="display:none; background-color: #f9f9f9; border-radius: 10px; padding: 20px; box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);">
        <h2 style="color: #3f51b5;">Agendar Hora</h2>
        <input type="hidden" id="fecha" name="fecha" required>
        
        <label for="bloque">Bloque:</label>
        <select id="bloque" name="bloque" required style="padding: 10px; border-radius: 5px; border: 1px solid #ccc; margin-bottom: 15px;">
            <option value="" disabled selected>Seleccione un bloque</option>
        </select>

        <label for="curso_id">Curso:</label>
        <select id="curso_id" name="curso_id" required style="padding: 10px; border-radius: 5px; border: 1px solid #ccc; margin-bottom: 20px;">
            <option value="" disabled selected>Seleccione un curso</option>
            <?php while ($curso = $cursos->fetch_assoc()): ?>
                <option value="<?php echo $curso['id']; ?>"><?php echo htmlspecialchars($curso['nombre'], ENT_QUOTES, 'UTF-8'); ?></option>
            <?php endwhile; ?>
        </select>
        
        <?php if (isAdmin()): ?>
        <label for="usuario_id">Profesor:</label>
        <select id="usuario_id" name="usuario_id" required style="padding: 10px; border-radius: 5px; border: 1px solid #ccc; margin-bottom: 20px;">
            <option value="" disabled selected>Seleccione un profesor</option>
            <?php foreach ($usuarios as $usuario): ?>
                <option value="<?php echo $usuario['id']; ?>"><?php echo htmlspecialchars($usuario['nombre'] . ' ' . $usuario['apellido_paterno'] . ' ' . $usuario['apellido_materno'], ENT_QUOTES, 'UTF-8'); ?></option>
            <?php endforeach; ?>
        </select>
    <?php else: ?>
        <!-- Los usuarios no admin no pueden seleccionar otros usuarios -->
        <input type="hidden" name="usuario_id" value="<?php echo $_SESSION['usuario_id']; ?>">
    <?php endif; ?>
        
        <button type="submit" style="padding: 10px; background-color: #3f51b5; color: white; border: none; border-radius: 5px; cursor: pointer; transition: background-color 0.3s;">
            Confirmar Agendamiento
        </button>
    </form>
    <form id="form-eliminar" method="POST" action="horario/schedule.php" style="display:none;">
        <input type="hidden" id="horario_id" name="horario_id">
        <input type="hidden" name="eliminar" value="1">
    </form>
</main>
</body>
</html>

