<?php
// [PHP idéntico al tuyo para seguridad, autenticación y permisos]
// NO modificamos esta parte para mantener toda la lógica igual
header('Content-Type: text/html; charset=utf-8');
include 'includes/db.php';
include 'includes/auth.php';
checkAuth();
$limiteInactividad = 30 * 60;
if (isset($_SESSION['ultimoAcceso'])) {
    $inactividad = time() - $_SESSION['ultimoAcceso'];
    if ($inactividad > $limiteInactividad) {
        session_unset();
        session_destroy();
        header("Location: login.php");
        exit();
    }
}
$_SESSION['ultimoAcceso'] = time();
$permisos_usuario = [];
$rol_id = $_SESSION['rol'] ?? null;
$usuario_id = $_SESSION['usuario_id'] ?? null;

if ($rol_id || $usuario_id) {
    $query_rol = "SELECT p.nombre, p.url FROM permisos p JOIN roles_permisos rp ON p.id = rp.permiso_id WHERE rp.rol_id = ?";
    $stmt_rol = $conn->prepare($query_rol);
    $stmt_rol->bind_param('i', $rol_id);
    $stmt_rol->execute();
    $result_rol = $stmt_rol->get_result();
    while ($row = $result_rol->fetch_assoc()) {
        $permisos_usuario[$row['url']] = $row['nombre'];
    }
    $stmt_rol->close();

    $query_usuario = "SELECT p.nombre, p.url FROM permisos p JOIN usuario_permisos up ON p.id = up.permiso_id WHERE up.usuario_id = ?";
    $stmt_usuario = $conn->prepare($query_usuario);
    $stmt_usuario->bind_param('i', $usuario_id);
    $stmt_usuario->execute();
    $result_usuario = $stmt_usuario->get_result();
    while ($row = $result_usuario->fetch_assoc()) {
        $permisos_usuario[$row['url']] = $row['nombre'];
    }
    $stmt_usuario->close();
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Dashboard - Escuela Porongo</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        @keyframes fadeInUp {
    from {
        opacity: 0;
        transform: translateY(20px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

@keyframes slideInLeft {
    from {
        opacity: 0;
        transform: translateX(-100px);
    }
    to {
        opacity: 1;
        transform: translateX(0);
    }
}

.sidebar {
    animation: slideInLeft 0.5s ease-out;
}

.topbar {
    animation: fadeInUp 0.8s ease;
}

.card {
    animation: fadeInUp 0.6s ease-in-out;
    animation-fill-mode: both;
}

/* Opcional: animación escalonada para tarjetas */
.dashboard-content .card:nth-child(1) { animation-delay: 0.1s; }
.dashboard-content .card:nth-child(2) { animation-delay: 0.2s; }
.dashboard-content .card:nth-child(3) { animation-delay: 0.3s; }
.dashboard-content .card:nth-child(4) { animation-delay: 0.4s; }
.dashboard-content .card:nth-child(5) { animation-delay: 0.5s; }
.dashboard-content .card:nth-child(6) { animation-delay: 0.6s; }
.dashboard-content .card:nth-child(7) { animation-delay: 0.7s; }
.dashboard-content .card:nth-child(8) { animation-delay: 0.8s; }
.dashboard-content .card:nth-child(9) { animation-delay: 0.9s; }
.dashboard-content .card:nth-child(10) { animation-delay: 0.9s; }
.dashboard-content .card:nth-child(11) { animation-delay: 0.9s; }
.dashboard-content .card:nth-child(12) { animation-delay: 0.9s; }
.dashboard-content .card:nth-child(13) { animation-delay: 0.9s; }
.dashboard-content .card:nth-child(14) { animation-delay: 0.9s; }
.dashboard-content .card:nth-child(15) { animation-delay: 0.9s; }
.dashboard-content .card:nth-child(16) { animation-delay: 0.9s; }
.dashboard-content .card:nth-child(17) { animation-delay: 0.9s; }
.dashboard-content .card:nth-child(18) { animation-delay: 0.9s; }
.dashboard-content .card:nth-child(19) { animation-delay: 0.9s; }
.dashboard-content .card:nth-child(20) { animation-delay: 0.9s; } 
.dashboard-content .card:nth-child(21) { animation-delay: 0.9s; }        
/* Añade más si tienes más de 4 tarjetas */

.sidebar details summary {
    transition: all 0.3s ease;
}

.sidebar details[open] summary {
    background: #3f5d75;
    transform: scale(1.05);
}

.sidebar a {
    transition: transform 0.2s ease, background-color 0.3s ease;
}

        * { box-sizing: border-box; margin: 0; padding: 0; }
        body {
            font-family: 'Roboto', sans-serif;
            display: flex;
            min-height: 100vh;
            background: url('images/COLEGIO.jpg') no-repeat center center fixed;
            background-size: cover;
            position: relative;
            z-index: 1;
        }

/* Superposición oscura */
        body::before {
            content: "";
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.4); /* Ajusta la opacidad aquí (0.4 es tenue) */
            z-index: -1;
        }

        .sidebar {
            width: 250px;
            background: #2c3e50;
            color: white;
            padding: 30px 20px;
            position: fixed;
            height: 100%;
            overflow-y: auto;
        }
        .sidebar h2 {
            text-align: center;
            margin-bottom: 30px;
            font-size: 24px;
        }
        .sidebar details {
            margin-bottom: 10px;
        }
        .sidebar summary {
            font-weight: bold;
            cursor: pointer;
            padding: 10px;
            background: #34495e;
            border-radius: 6px;
            transition: background 0.3s;
        }
        .sidebar summary:hover {
            background: #3f5d75;
        }
        .sidebar a {
            display: block;
            color: white;
            text-decoration: none;
            padding: 8px 12px;
            margin: 5px 0 5px 10px;
            border-radius: 6px;
            transition: background 0.3s;
            font-size: 14px;
        }
        .sidebar a:hover {
            background: #3a5168;
            transform: translateX(5px);
        }
        .sidebar .icon {
            margin-right: 10px;
        }
        .main {
            margin-left: 250px;
            padding: 30px;
            width: 100%;
        }
        .topbar {
        display: flex;
        justify-content: space-between;
        align-items: center;
        background-color: #1e293b; /* azul oscuro */
        color: #ffffff;
        padding: 1rem 2rem;
        border-radius: 0.5rem;
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
        margin-bottom: 1rem;
    }

    .user-info {
        font-size: 1rem;
        line-height: 1.4;
    }

    .user-info strong {
        font-weight: bold;
    }

    .topbar a {
        background-color: #ef4444; /* rojo */
        color: white;
        padding: 0.5rem 1rem;
        text-decoration: none;
        border-radius: 0.375rem;
        transition: background-color 0.3s ease;
        font-weight: bold;
    }

    .topbar a:hover {
        background-color: #dc2626; /* rojo más oscuro */
    }
        .dashboard-content {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(180px, 1fr));
            gap: 20px;
        }
        .card {
            background: white;
            padding: 20px;
            border-radius: 12px;
            box-shadow: 0 4px 12px rgba(0,0,0,0.1);
            text-align: center;
            transition: transform 0.3s;
        }
        .card:hover {
            transform: translateY(-5px);
        }
        .card .icon {
            font-size: 32px;
            color: #2980b9;
            display: flex;
            align-items: center;
            justify-content: center;
            line-height: 1;
            height: 40px;
            margin-bottom: 10px;
            overflow: hidden;
            background: transparent;
            text-decoration: none;
        }

        .card .text {
            font-size: 16px;
            font-weight: bold;
            color: #333;
        }
        .card .icon::before, .card .icon::after {
            content: '';
            display: none;
        }
        a, .card .icon, .card .text {
            text-decoration: none !important;
            border: none !important;
            outline: none !important;
            box-shadow: none !important;
        }
        .logo-titulo {
            display: flex;
            flex-direction: column;
            align-items: center;
            gap: 8px;
            margin-bottom: 30px;
        }

        .logo-titulo .logo {
            width: 80px;     /* tamaño mediano para distinguirla bien */
            height: auto;
            border-radius: 8px;
            box-shadow: 0 0 5px rgba(0,0,0,0.2);
        }
/* BOTÓN PARA MOSTRAR EL MENÚ EN MÓVILES */
        .toggle-sidebar {
            display: none;
            position: fixed;
            top: 15px;
            left: 15px;
            z-index: 1001;
            background: #2c3e50;
            color: white;
            padding: 10px 15px;
            border-radius: 6px;
            cursor: pointer;
            font-size: 18px;
        }

@media (max-width: 768px) {
    .sidebar {
        position: absolute;
        width: 200px;
        left: -200px;
        transition: left 0.3s;
    }

    .sidebar.open {
        left: 0;
    }

    .main {
        margin-left: 0;
        width: 100%;
    }

    .topbar {
        margin-left: 0;
    }
}
        .card.show {
    opacity: 1 !important;
    transform: translateY(0) !important;
    transition: opacity 0.6s ease, transform 0.6s ease;
}
    </style>
</head>
<body>
<div class="toggle-sidebar" onclick="document.querySelector('.sidebar').classList.toggle('active')">
    ☰ Menú
</div>
<div class="sidebar">
    <div class="logo-titulo">
    <img src="images/INSIGNIA%20SF.png" alt="Insignia Escuela Porongo" class="logo">
    <h2>Escuela Porongo</h2>
</div>

    <?php
    $iconos_permisos = [
        'Administrar Usuarios' => '&#128100;',
        'Gestionar Roles' => '&#128736;',
        'Generar Informes de Notas' => '&#128200;',
        'Agendar Horas' => '&#9200;',
        'Generar Certificado Alumno Regular' => '&#127891;',
        'Generar Certificado Traslado' => '&#127979;',
        'Ver Cursos y Alumnos' => '&#128218;',
        'Agregar Asignaturas' => '&#43;',
        'Agregar Curso' => '&#128196;',
        'Agregar Alumnos' => '&#43;&#128104;&#8205;&#127891;',
        'Agregar Notas' => '&#128221;',
        'Gestionar Notas' => '&#128200;',
        'Formulario de Matrícula' => '&#128221;',
        'Gestionar Matrículas' => '&#128203;',
        'Ingresar Equipos' => '&#128187;',
        'Gestionar Equipos' => '&#9881;',
        'Respaldo y Recuperación' => '&#128190;',
        'Prestamos' => '&#128230;',
        'Permisos' => '&#128273;',
        'Ver Notas' => '&#128221;',
        'Kit Digital' => '&#128736;'
    ];

    $secciones = [
        'Usuarios' => ['Administrar Usuarios', 'Gestionar Roles', 'Permisos'],
        'Notas y Certificados' => ['Generar Informes de Notas', 'Ver Notas', 'Agregar Notas', 'Gestionar Notas'],
        'Certificados' => ['Generar Certificado Alumno Regular', 'Generar Certificado Traslado'],
        'Cursos y Alumnos' => ['Ver Cursos y Alumnos', 'Agregar Curso', 'Agregar Asignaturas', 'Agregar Alumnos'],
        'Matrículas' => ['Formulario de Matrícula', 'Gestionar Matrículas'],
        'Equipos' => ['Ingresar Equipos', 'Gestionar Equipos', 'Prestamos'],
        'Agendamiento' => ['Agendar Horas'],
        'Sistema' => ['Respaldo y Recuperación']
    ];

    foreach ($secciones as $titulo => $opciones) {
        echo "<details><summary>$titulo</summary>";
        foreach ($permisos_usuario as $url => $nombre) {
            if (in_array($nombre, $opciones)) {
                $icono = $iconos_permisos[$nombre] ?? '&#128197;';
                echo "<a href='" . htmlspecialchars($url) . "'><span class='icon'>{$icono}</span>{$nombre}</a>";
            }
        }
        echo "</details>";
    }
    ?>
    <a href="logout.php"><span class="icon">&#128274;</span> Cerrar Sesión</a>
</div>

<div class="main">
    <div class="topbar">
    <div class="user-info">
        Bienvenido/a <br>
        <strong><?php echo htmlspecialchars("{$_SESSION['nombre']} {$_SESSION['apellido_paterno']} {$_SESSION['apellido_materno']}"); ?></strong> <br>
        Rol: <strong><?php echo htmlspecialchars($_SESSION['rol_nombre']); ?></strong>
    </div>
    <a href="logout.php">Cerrar Sesión</a>
</div>

    <div class="dashboard-content">
        <?php
        foreach ($permisos_usuario as $url => $nombre) {
            $icono = $iconos_permisos[$nombre] ?? '&#128197;';
            echo "
            <a class='card' href='" . htmlspecialchars($url) . "'>
                <div class='icon'>{$icono}</div>
                <div class='text'>" . htmlspecialchars($nombre) . "</div>
            </a>";
        }
        ?>
    </div>
</div>
<script>
document.addEventListener("DOMContentLoaded", () => {
    const cards = document.querySelectorAll('.card');

    const observer = new IntersectionObserver(entries => {
        entries.forEach(entry => {
            if (entry.isIntersecting) {
                entry.target.classList.add('show');
            }
        });
    }, {
        threshold: 0.1
    });

    cards.forEach(card => {
        card.style.opacity = '0'; // Ocultar inicialmente
        observer.observe(card);
    });
});
</script>

</body>
</html>

