<?php
header('Content-Type: text/html; charset=utf-8');

session_start();

include '../includes/db.php';
include '../includes/auth.php';
checkAuth();

//if (!isAdmin()) {
    //header("Location: ../index.php");
   // exit();
//}

if (!isset($_SESSION['usuario_id'])) {
    header("Location: ../index.php");
    exit();
}

error_reporting(E_ALL);
ini_set('display_errors', 1);

// Carpeta donde están las imágenes institucionales
$carpeta_imagenes = '../kit/img/';
$imagenes = glob($carpeta_imagenes . '*.{jpg,jpeg,png,gif,webp}', GLOB_BRACE);
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Kit Digital</title>
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Roboto:400,700&display=swap">
    <link rel="stylesheet" href="../css/admin.css">
    <style>
        .gallery {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(200px, 1fr));
            gap: 20px;
            padding: 20px;
        }

        .image-card {
            border: 1px solid #ccc;
            padding: 10px;
            text-align: center;
            background: #f9f9f9;
            border-radius: 8px;
        }

        .image-card img {
            max-width: 100%;
            height: auto;
            margin-bottom: 10px;
        }

        .download-btn {
            background-color: #007BFF;
            color: white;
            padding: 6px 12px;
            border: none;
            border-radius: 5px;
            text-decoration: none;
            font-weight: bold;
        }

        .download-btn:hover {
            background-color: #0056b3;
        }

        header img {
            height: 60px;
        }

        h1 {
            margin-bottom: 0;
        }
    </style>
</head>
<body>

<header>
    <img src="../images/INSIGNIA%20SF.png" alt="Logo de la Empresa">
    <h1>Kit Digital</h1>
    <nav>
        <ul>
            <li><a href="../index.php">Inicio</a></li>
        </ul>
    </nav>
</header>

<main>
    <h2 style="text-align:center;">Imágenes Institucionales para Descargar</h2>

    <?php if (count($imagenes) > 0): ?>
        <div class="gallery">
            <?php foreach ($imagenes as $img_path): 
                $img_nombre = basename($img_path);
                $url = htmlspecialchars($img_path);
            ?>
                <div class="image-card">
                    <img src="<?php echo $url; ?>" alt="<?php echo $img_nombre; ?>">
                    <br>
                    <a class="download-btn" href="<?php echo $url; ?>" download="<?php echo $img_nombre; ?>">Descargar</a>
                </div>
            <?php endforeach; ?>
        </div>
    <?php else: ?>
        <p style="text-align:center;">No se encontraron imágenes en la carpeta del kit digital.</p>
    <?php endif; ?>
</main>

</body>
</html>
