<?php
header('Content-Type: text/html; charset=utf-8'); // Establece la codificación de caracteres a UTF-8

include 'includes/db.php'; // Incluir la conexión a la base de datos
include 'includes/auth.php'; // Incluir funciones de autenticación

// Verificar que la sesión no se haya iniciado previamente
if (session_status() !== PHP_SESSION_ACTIVE) {
    session_start(); // Iniciar la sesión si no está ya activa
}

// Inicializa los contadores de intentos fallidos si no están establecidos
if (!isset($_SESSION['intentos_fallidos'])) {
    $_SESSION['intentos_fallidos'] = 0; // Inicializa los intentos fallidos a 0
    $_SESSION['ultimo_intento'] = time(); // Guarda el tiempo del último intento
}

$max_intentos = 3; // Número máximo de intentos permitidos antes de bloquear
$bloqueo_segundos = 30; // Tiempo de bloqueo en segundos después de alcanzar el máximo de intentos

// Verifica si el usuario ha excedido el número de intentos permitidos y si el bloqueo aún es válido
if ($_SESSION['intentos_fallidos'] >= $max_intentos && (time() - $_SESSION['ultimo_intento'] <= $bloqueo_segundos)) {
    $bloqueado = true; // El usuario está bloqueado
    $tiempo_restante = $bloqueo_segundos - (time() - $_SESSION['ultimo_intento']); // Calcula el tiempo restante de bloqueo
} else {
    $bloqueado = false; // El usuario no está bloqueado
}

// Establece la codificación de la base de datos a UTF-8
$conn->set_charset("utf8");

// Procesa el formulario de inicio de sesión si no está bloqueado
if ($_SERVER['REQUEST_METHOD'] == 'POST' && !$bloqueado) {
    // Verifica que los campos 'rut' y 'contrasena' estén presentes en el formulario
    if (isset($_POST['rut']) && isset($_POST['contrasena'])) {
        $rut = $conn->real_escape_string($_POST['rut']); // Sanitiza el valor del RUT
        $contrasena = $_POST['contrasena']; // Obtiene la contraseña del formulario

        // Prepara la consulta para buscar al usuario por su RUT y obtener su rol
// Prepara la consulta para buscar al usuario por su RUT y obtener su rol y apellidos
$stmt = $conn->prepare("SELECT u.*, r.nombre AS rol_nombre FROM usuario u 
                        JOIN roles r ON u.rol_id = r.id WHERE u.rut = ?");
$stmt->bind_param("s", $rut); // Vincula el RUT a la consulta
$stmt->execute(); // Ejecuta la consulta
$result = $stmt->get_result(); // Obtiene el resultado de la consulta

// Verifica si se encontró un usuario con el RUT ingresado
if ($result->num_rows == 1) {
    $user = $result->fetch_assoc(); // Obtiene los datos del usuario

    // Verifica si la contraseña es correcta
    if (password_verify($contrasena, $user['contraseña'])) {
        // Almacena la información del usuario en la sesión
        $_SESSION['usuario_id'] = $user['id'];
        $_SESSION['nombre'] = $user['nombre'];
        $_SESSION['apellido_paterno'] = $user['apellido_paterno']; // Guardar apellido paterno en la sesión
        $_SESSION['apellido_materno'] = $user['apellido_materno']; // Guardar apellido materno en la sesión
        $_SESSION['rol'] = $user['rol_id']; // El ID del rol está ahora en rol_id
        $_SESSION['rol_nombre'] = $user['rol_nombre']; // El nombre del rol
        $_SESSION['usuario'] = $user['nombre'] . ' ' . $user['apellido_paterno'] . ' ' . $user['apellido_materno'];
        $_SESSION['intentos_fallidos'] = 0; // Resetea el contador de intentos fallidos
        header("Location: index.php"); // Redirige al usuario a la página principal
        exit(); // Termina la ejecución del script
    } else {
        // Incrementa el contador de intentos fallidos si la contraseña es incorrecta
        $_SESSION['intentos_fallidos']++;
        $_SESSION['ultimo_intento'] = time(); // Actualiza el tiempo del último intento
        $error = "Contraseña incorrecta"; // Mensaje de error
    }
} else {
    // Incrementa el contador de intentos fallidos si no se encuentra el usuario
    $_SESSION['intentos_fallidos']++;
    $_SESSION['ultimo_intento'] = time(); // Actualiza el tiempo del último intento
    $error = "Usuario no encontrado"; // Mensaje de error
}



        $stmt->close(); // Cierra la consulta preparada
    } else {
        $error = "Por favor, complete todos los campos."; // Mensaje si algún campo está vacío
    }
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Inicio de Sesión - Escuela Porongo</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Poppins', sans-serif;
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
            background: url('images/COLEGIO.jpg') no-repeat center center fixed;
            background-size: cover;
            color: #fff;
        }

        .login-container {
            background: rgba(255, 255, 255, 0.9); /* Fondo con transparencia */
            border-radius: 20px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.2);
            padding: 40px;
            width: 100%;
            max-width: 420px;
            text-align: center;
            color: #333;
            backdrop-filter: blur(10px); /* Aplica desenfoque al fondo */
        }

        .login-container .insignia {
            width: 250px;
            height: auto;
            margin: 0 auto 20px; /* Centrado y margen inferior */
        }

        .login-container h1 {
            font-size: 28px;
            font-weight: 600;
            margin-bottom: 20px;
        }

        .login-container input {
            width: 100%;
            padding: 12px 15px;
            margin: 10px 0;
            border: 1px solid #ddd;
            border-radius: 5px;
            font-size: 16px;
            transition: 0.3s;
        }

        .login-container input:focus {
            border-color: #007BFF;
            outline: none;
            box-shadow: 0 0 5px rgba(0, 123, 255, 0.5);
        }

        .login-container button {
            width: 100%;
            padding: 12px 15px;
            background: #007BFF;
            color: #fff;
            border: none;
            border-radius: 5px;
            font-size: 16px;
            font-weight: bold;
            cursor: pointer;
            transition: 0.3s;
        }

        .login-container button:hover {
            background: #0056b3;
            box-shadow: 0 5px 15px rgba(0, 91, 179, 0.4);
        }

        .icon {
            margin-bottom: 15px;
            color: #007BFF;
            font-size: 50px;
        }

        .password-wrapper {
            position: relative;
        }

        .password-wrapper .toggle-password {
            position: absolute;
            right: 15px;
            top: 50%;
            transform: translateY(-50%);
            cursor: pointer;
            color: #007BFF;
            font-size: 18px;
        }

        .error {
            color: #FF4C4C;
            margin-bottom: 15px;
            font-size: 14px;
        }
        
    </style>
    <script>
        function togglePassword() {
            const passwordField = document.getElementById('password');
            const toggleIcon = document.getElementById('toggleIcon');
            if (passwordField.type === 'password') {
                passwordField.type = 'text';
                toggleIcon.classList.remove('fa-eye');
                toggleIcon.classList.add('fa-eye-slash');
            } else {
                passwordField.type = 'password';
                toggleIcon.classList.remove('fa-eye-slash');
                toggleIcon.classList.add('fa-eye');
            }
        }
    </script>
</head>
<body>
    <div class="login-container">
        <img src="images/INSIGNIA%20SF.png" alt="Insignia del Colegio" class="insignia">
        <h2>Escuela Porongo</h2>
        <h1>Iniciar Sesión</h1>
        <?php if (isset($error)): ?>
            <div class="error"><?php echo htmlspecialchars($error, ENT_QUOTES, 'UTF-8'); ?></div>
        <?php endif; ?>
        <?php if ($bloqueado): ?>
            <div class="error">Demasiados intentos fallidos. Por favor, espera <?= $tiempo_restante; ?> segundos.</div>
        <?php else: ?>
            <form method="POST" action="login.php">
                <input type="text" name="rut" placeholder="RUT (Ej: 12345678-9)" required>
                <div class="password-wrapper">
                    <input type="password" name="contrasena" placeholder="Contraseña" id="password" required>
                    <span class="toggle-password" onclick="togglePassword()">
                        <i id="toggleIcon" class="fas fa-eye"></i>
                    </span>
                </div>
                <button type="submit">Ingresar</button>
            </form>
        <?php endif; ?>
    </div>
</body>
</html>
