<?php
include 'includes/db.php'; // Incluir archivo de conexión a la base de datos
include 'includes/auth.php'; // Incluir archivo de autenticación
checkAuth(); // Verificar si el usuario está autenticado

// Establecer la codificación de caracteres para la conexión de la base de datos
$conn->set_charset("utf8");

$message = ''; // Variable para almacenar el mensaje
$matricula_id = isset($_GET['id']) ? intval($_GET['id']) : null; // Obtener el ID de la matrícula a editar

if (!$matricula_id) {
    die("Error: No se proporcionó un ID válido para la matrícula.");
}

// Obtener los datos de la matrícula desde la base de datos
$stmt = $conn->prepare("SELECT * FROM matricula WHERE id = ?");
$stmt->bind_param("i", $matricula_id);
$stmt->execute();
$matricula = $stmt->get_result()->fetch_assoc();

if (!$matricula) {
    die("Error: Matrícula no encontrada.");
}

// Obtener los datos adicionales
$info_adicional = $conn->query("SELECT * FROM informacion_adicional WHERE matricula_id = $matricula_id")->fetch_assoc();
$prevision_salud = $conn->query("SELECT * FROM previsiones_salud WHERE matricula_id = $matricula_id")->fetch_assoc();
$alergias = $conn->query("SELECT * FROM alergias_alimentarias WHERE matricula_id = $matricula_id")->fetch_all(MYSQLI_ASSOC);

// Lógica para actualizar la matrícula
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Obtener los datos del formulario
    $nombres = $_POST['nombres'];
    $apellido_paterno = $_POST['apellido_paterno'];
    $apellido_materno = $_POST['apellido_materno'];
    $fecha_nac = $_POST['fecha_nac'];
    $lugar_nac = $_POST['lugar_nac'];
    $dom_alumno = $_POST['dom_alumno'];
    $curso_id = $_POST['curso_id'];
    $rut = $_POST['rut'];
    $procedencia = $_POST['procedencia'];
    $vive_con = isset($_POST['vive_con']) ? implode(', ', $_POST['vive_con']) : null;
    $prevision_salud = $_POST['prevision_salud'];
    $es_bicultural = isset($_POST['es_bicultural']) ? 1 : 0;
    $etnia = $_POST['etnia'];
    $problemas_aprendizaje = $_POST['problemas_aprendizaje'];
    $cursos_repetidos = $_POST['cursos_repetidos'];

    // Actualizar la matrícula
    $stmt = $conn->prepare("UPDATE matricula SET nombre = ?, apellido_paterno = ?, apellido_materno = ?, fecha_nac = ?, lugar_nac = ?, dom_alumno = ?, curso_id = ?, rut = ?, procedencia = ?, persona_con_quien_vive = ? WHERE id = ?");
    $stmt->bind_param("ssssssisssi", $nombres, $apellido_paterno, $apellido_materno, $fecha_nac, $lugar_nac, $dom_alumno, $curso_id, $rut, $procedencia, $vive_con, $matricula_id);

    if ($stmt->execute()) {
        // Actualizar previsión de salud
        $stmt = $conn->prepare("UPDATE previsiones_salud SET tipo_prevision_id = ? WHERE matricula_id = ?");
        $stmt->bind_param("si", $prevision_salud, $matricula_id);
        $stmt->execute();

        // Actualizar información adicional
        $stmt = $conn->prepare("UPDATE informacion_adicional SET es_bicultural = ?, etnia = ?, problemas_aprendizaje = ?, cursos_repetidos = ? WHERE matricula_id = ?");
        $stmt->bind_param("isssi", $es_bicultural, $etnia, $problemas_aprendizaje, $cursos_repetidos, $matricula_id);
        $stmt->execute();

        // Eliminar alergias actuales
        $stmt = $conn->prepare("DELETE FROM alergias_alimentarias WHERE matricula_id = ?");
        $stmt->bind_param("i", $matricula_id);
        $stmt->execute();

        // Insertar nuevamente las alergias
        if (!empty($_POST['alergico_alimentario'])) {
            foreach ($_POST['alergico_alimentario'] as $alergia) {
                $stmt = $conn->prepare("INSERT INTO alergias_alimentarias (matricula_id, alergia) VALUES (?, ?)");
                $stmt->bind_param("is", $matricula_id, $alergia);
                $stmt->execute();
            }
        }

        $message = "Matrícula actualizada exitosamente.";
    } else {
        $message = "Error al actualizar la matrícula: " . $conn->error;
    }
}

// Obtener los cursos para el dropdown
$cursos_result = $conn->query("SELECT id, nombre FROM curso");

// Consultas para obtener los datos de la madre, padre y otra persona de la tabla `familiares`
$madre = $conn->query("SELECT * FROM familiares WHERE matricula_id = $matricula_id AND parentesco = 'Madre'")->fetch_assoc();
$padre = $conn->query("SELECT * FROM familiares WHERE matricula_id = $matricula_id AND parentesco = 'Padre'")->fetch_assoc();
$otro = $conn->query("SELECT * FROM familiares WHERE matricula_id = $matricula_id AND parentesco = 'Otro'")->fetch_assoc();

$conn->close(); // Cerrar la conexión
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Editar Matrícula</title>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <style>
        /* Estilos básicos */
        body {
            font-family: 'Roboto', sans-serif;
            background-color: #f0f2f5;
            margin: 0;
            padding: 0;
            display: flex;
            flex-direction: column;
            align-items: center;
        }

        header {
            width: 100%;
            background-color: #3f51b5;
            color: white;
            padding: 20px 0;
            text-align: center;
        }
        header img {
            width: 120px;
            height: auto;
            margin-bottom: 10px;
        }
        nav ul {
            list-style-type: none;
            padding: 0;
            margin: 10px 0;
            text-align: center;
        }

        nav ul li {
            display: inline;
            margin: 0 10px;
        }

        nav ul li a {
            color: white;
            text-decoration: none;
            padding: 10px 20px;
            background-color: #333;
            border-radius: 20px;
            transition: background-color 0.3s ease;
        }

        nav ul li a:hover {
            background-color: #555;
        }

        .form-container {
            width: 90%;
            max-width: 800px;
            margin: 20px auto;
            padding: 30px;
            border-radius: 10px;
            background-color: #fff;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
        }

        .mensaje {
            padding: 15px;
            margin-bottom: 20px;
            border-radius: 5px;
            font-size: 16px;
            text-align: center;
        }

        .mensaje.exito {
            background-color: #4CAF50;
            color: white;
        }

        .mensaje.error {
            background-color: #f44336;
            color: white;
        }

        label {
            margin-bottom: 5px;
            font-weight: bold;
            color: #333;
            display: block;
        }

        input, select, textarea {
            width: 100%;
            padding: 10px;
            font-size: 14px;
            margin-bottom: 20px;
            border-radius: 5px;
            border: 1px solid #ccc;
        }

        button {
            padding: 15px;
            background-color: #3f51b5;
            color: white;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            font-size: 16px;
            width: 100%;
        }

        button:hover {
            background-color: #388E3C;
        }

        h3 {
            color: #4CAF50;
            margin-bottom: 15px;
            font-size: 18px;
            font-weight: bold;
        }
    </style>
    <script>
    function toggleCulturaFields(checkbox) {
        const etniaField = document.getElementById('etnia');
        if (checkbox.checked) {
            etniaField.disabled = false; // Habilitar el campo si es bicultural
        } else {
            etniaField.disabled = true;  // Deshabilitar si no es bicultural
            etniaField.value = '';       // Limpiar el valor del campo
        }
    }

    // Ejecutar al cargar la página para asegurar que el estado inicial es correcto
    document.addEventListener('DOMContentLoaded', function() {
        const checkbox = document.getElementById('es_bicultural');
        toggleCulturaFields(checkbox);
    });
</script>
    <script>
    function toggleSection(sectionId, checkbox, familia) {
        const section = document.getElementById(sectionId);
        if (checkbox.checked) {
            section.style.display = 'block';  // Mostrar la sección si se selecciona
        } else {
            section.style.display = 'none';  // Ocultar la sección si se deselecciona
        }
    }
</script>
</head>
<body>
    <header>
        <img src="images/INSIGNIA SF.png" alt="Escuela Porongo Insignia">
        <h1>Editar Matrícula</h1>
    </header>
    <nav>
        <ul>
            <li><a href="index.php">Inicio</a></li>
            <li><a href="crud_matriculas.php">Volver</a></li>
        </ul>
    </nav>

    <div class="form-container">
        <?php if ($message): ?>
            <div class="mensaje <?php echo strpos($message, 'Error') === false ? 'exito' : 'error'; ?>">
                <?php echo $message; ?>
            </div>
        <?php endif; ?>

        <form action="editar_matricula.php?id=<?php echo $matricula_id; ?>" method="POST">
            <!-- Información del Estudiante -->
            <label for="rut">RUN (ejemplo: 12345678-9):</label>
            <input type="text" id="rut" name="rut" value="<?php echo htmlspecialchars($matricula['rut'] ?? ''); ?>" required>

            <label for="nombres">Nombres:</label>
            <input type="text" id="nombres" name="nombres" value="<?php echo htmlspecialchars($matricula['nombre'] ?? ''); ?>" required>

            <label for="apellido_paterno">Apellido Paterno:</label>
            <input type="text" id="apellido_paterno" name="apellido_paterno" value="<?php echo htmlspecialchars($matricula['apellido_paterno'] ?? ''); ?>" required>

            <label for="apellido_materno">Apellido Materno:</label>
            <input type="text" id="apellido_materno" name="apellido_materno" value="<?php echo htmlspecialchars($matricula['apellido_materno'] ?? ''); ?>" required>

            <label for="fecha_nac">Fecha de Nacimiento:</label>
            <input type="date" id="fecha_nac" name="fecha_nac" value="<?php echo htmlspecialchars($matricula['fecha_nac'] ?? ''); ?>" required>

            <label for="lugar_nac">Lugar de Nacimiento:</label>
            <input type="text" id="lugar_nac" name="lugar_nac" value="<?php echo htmlspecialchars($matricula['lugar_nac'] ?? ''); ?>" required>

            <label for="dom_alumno">Domicilio del Alumno:</label>
            <input type="text" id="dom_alumno" name="dom_alumno" value="<?php echo htmlspecialchars($matricula['dom_alumno'] ?? ''); ?>" required>

            <label for="curso_id">Curso:</label>
            <select id="curso_id" name="curso_id" required>
                <?php while ($curso = $cursos_result->fetch_assoc()): ?>
                    <option value="<?php echo htmlspecialchars($curso['id']); ?>" <?php echo ($curso['id'] == $matricula['curso_id']) ? 'selected' : ''; ?>>
                        <?php echo htmlspecialchars($curso['nombre']); ?>
                    </option>
                <?php endwhile; ?>
            </select>

            <label for="procedencia">Curso de Procedencia:</label>
            <input type="text" id="procedencia" name="procedencia" value="<?php echo htmlspecialchars($matricula['procedencia'] ?? ''); ?>" required>

            <h3>Persona con quien vive el Alumno</h3>
            <div>
                <input type="checkbox" id="vive_mama" name="vive_con[]" value="Madre" <?php echo (strpos($matricula['persona_con_quien_vive'], 'Madre') !== false) ? 'checked' : ''; ?> onclick="toggleSection('section_mama', this, 'mama')">
                <label for="vive_mama">Vive con la Madre</label>

                <input type="checkbox" id="vive_papa" name="vive_con[]" value="Padre" <?php echo (strpos($matricula['persona_con_quien_vive'], 'Padre') !== false) ? 'checked' : ''; ?> onclick="toggleSection('section_papa', this, 'papa')">
                <label for="vive_papa">Vive con el Padre</label>

                <input type="checkbox" id="vive_otro" name="vive_con[]" value="Otro" <?php echo (strpos($matricula['persona_con_quien_vive'], 'Otro') !== false) ? 'checked' : ''; ?> onclick="toggleSection('section_otro', this, 'otro')">
                <label for="vive_otro">Vive con Otro</label>
            </div>

            <!-- Sección para los datos de la madre -->
            <div id="section_mama" style="<?php echo (strpos($matricula['persona_con_quien_vive'], 'Madre') !== false) ? '' : 'display:none;'; ?>">
                <h3>Información de la Madre</h3>
                <label for="nombre_mama">Nombre de la Madre:</label>
                <input type="text" id="nombre_mama" name="nombre_mama" value="<?php echo htmlspecialchars($madre['nombre'] ?? ''); ?>">

                <label for="apellido_paterno_mama">Apellido Paterno de la Madre:</label>
                <input type="text" id="apellido_paterno_mama" name="apellido_paterno_mama" value="<?php echo htmlspecialchars($madre['apellido_paterno'] ?? ''); ?>">

                <label for="apellido_materno_mama">Apellido Materno de la Madre:</label>
                <input type="text" id="apellido_materno_mama" name="apellido_materno_mama" value="<?php echo htmlspecialchars($madre['apellido_materno'] ?? ''); ?>">

                <label for="rut_mama">RUN de la Madre:</label>
                <input type="text" id="rut_mama" name="rut_mama" value="<?php echo htmlspecialchars($madre['rut'] ?? ''); ?>">

                <label for="dom_mama">Domicilio de la Madre:</label>
                <input type="text" id="dom_mama" name="dom_mama" value="<?php echo htmlspecialchars($madre['domicilio'] ?? ''); ?>">
            </div>

            <!-- Sección para los datos del padre -->
            <div id="section_papa" style="<?php echo (strpos($matricula['persona_con_quien_vive'], 'Padre') !== false) ? '' : 'display:none;'; ?>">
                <h3>Información del Padre</h3>
                <label for="nombre_papa">Nombre del Padre:</label>
                <input type="text" id="nombre_papa" name="nombre_papa" value="<?php echo htmlspecialchars($padre['nombre'] ?? ''); ?>">

                <label for="apellido_paterno_papa">Apellido Paterno del Padre:</label>
                <input type="text" id="apellido_paterno_papa" name="apellido_paterno_papa" value="<?php echo htmlspecialchars($padre['apellido_paterno'] ?? ''); ?>">

                <label for="apellido_materno_papa">Apellido Materno del Padre:</label>
                <input type="text" id="apellido_materno_papa" name="apellido_materno_papa" value="<?php echo htmlspecialchars($padre['apellido_materno'] ?? ''); ?>">

                <label for="rut_papa">RUN del Padre:</label>
                <input type="text" id="rut_papa" name="rut_papa" value="<?php echo htmlspecialchars($padre['rut'] ?? ''); ?>">

                <label for="dom_papa">Domicilio del Padre:</label>
                <input type="text" id="dom_papa" name="dom_papa" value="<?php echo htmlspecialchars($padre['domicilio'] ?? ''); ?>">
            </div>

            <!-- Sección para los datos de otra persona -->
            <div id="section_otro" style="<?php echo (strpos($matricula['persona_con_quien_vive'], 'Otro') !== false) ? '' : 'display:none;'; ?>">
                <h3>Información de Otra Persona</h3>
                <label for="nombre_otro">Nombre de la Persona:</label>
                <input type="text" id="nombre_otro" name="nombre_otro" value="<?php echo htmlspecialchars($otro['nombre'] ?? ''); ?>">

                <label for="apellido_paterno_otro">Apellido Paterno de la Persona:</label>
                <input type="text" id="apellido_paterno_otro" name="apellido_paterno_otro" value="<?php echo htmlspecialchars($otro['apellido_paterno'] ?? ''); ?>">

                <label for="apellido_materno_otro">Apellido Materno de la Persona:</label>
                <input type="text" id="apellido_materno_otro" name="apellido_materno_otro" value="<?php echo htmlspecialchars($otro['apellido_materno'] ?? ''); ?>">

                <label for="rut_otro">RUN de la Persona:</label>
                <input type="text" id="rut_otro" name="rut_otro" value="<?php echo htmlspecialchars($otro['rut'] ?? ''); ?>">

                <label for="dom_otro">Domicilio de la Persona:</label>
                <input type="text" id="dom_otro" name="dom_otro" value="<?php echo htmlspecialchars($otro['domicilio'] ?? ''); ?>">
            </div>

            <!-- Información de Salud -->
            <h3>Información de Salud</h3>
            <label for="prevision_salud">Previsión de Salud:</label>
            <select id="prevision_salud" name="prevision_salud" required>
                <option value="1" <?php echo ($prevision_salud['tipo_prevision_id'] == 1) ? 'selected' : ''; ?>>FONASA</option>
                <option value="2" <?php echo ($prevision_salud['tipo_prevision_id'] == 2) ? 'selected' : ''; ?>>ISAPRE</option>
            </select>

            <h3>Alergias Alimentarias</h3>
            <div id="alergias-container">
                <?php foreach ($alergias as $alergia): ?>
                    <div>
                        <input type="text" name="alergico_alimentario[]" value="<?php echo htmlspecialchars($alergia['alergia'] ?? ''); ?>" placeholder="Ingrese una alergia alimentaria">
                        <!-- Botón de eliminar -->
                        <button type="button" style="padding: 5px 10px; background-color: #f44336; color: white; border: none; border-radius: 3px; font-size: 12px; cursor: pointer;" onclick="this.parentNode.remove()">Eliminar</button>
                    </div>
                <?php endforeach; ?>
                <div>
                    <input type="text" name="alergico_alimentario[]" placeholder="Ingrese una alergia alimentaria">
                </div>
            </div>
            <!-- Botón para añadir otra alergia -->
                    <button type="button" onclick="addAlergia()" style="padding: 5px 10px; background-color: #4CAF50; color: white; border: none; border-radius: 3px; font-size: 12px; cursor: pointer;">Añadir otra alergia</button>

            <!-- Información adicional -->
            <label for="es_bicultural">¿Es el alumno bicultural?</label>
            <input type="checkbox" id="es_bicultural" name="es_bicultural" <?php echo ($info_adicional['es_bicultural']) ? 'checked' : ''; ?> onchange="toggleCulturaFields(this)">

            <label for="etnia">Cultura:</label>
            <select id="etnia" name="etnia">
                <option value="">Seleccione una opción</option>
                <option value="Aymara" <?php echo ($info_adicional['etnia'] ?? '' == 'Aymara') ? 'selected' : ''; ?>>Aymara</option>
                <option value="Atacameño o Likan Antai" <?php echo ($info_adicional['etnia'] ?? '' == 'Atacameño o Likan Antai') ? 'selected' : ''; ?>>Atacameño o Likan Antai</option>
                <option value="Quechua" <?php echo ($info_adicional['etnia'] ?? '' == 'Quechua') ? 'selected' : ''; ?>>Quechua</option>
                <option value="Collas" <?php echo ($info_adicional['etnia'] ?? '' == 'Collas') ? 'selected' : ''; ?>>Collas</option>
                <option value="Changos" <?php echo ($info_adicional['etnia'] ?? '' == 'Changos') ? 'selected' : ''; ?>>Changos</option>
                <option value="Diaguitas" <?php echo ($info_adicional['etnia'] ?? '' == 'Diaguitas') ? 'selected' : ''; ?>>Diaguitas</option>
                <option value="Rapanui" <?php echo ($info_adicional['etnia'] ?? '' == 'Rapanui') ? 'selected' : ''; ?>>Rapanui</option>
                <option value="Mapuche" <?php echo ($info_adicional['etnia'] ?? '' == 'Mapuche') ? 'selected' : ''; ?>>Mapuche</option>
                <option value="Kawésqar" <?php echo ($info_adicional['etnia'] ?? '' == 'Kawésqar') ? 'selected' : ''; ?>>Kawésqar</option>
                <option value="Selk’nam" <?php echo ($info_adicional['etnia'] ?? '' == 'Selk’nam') ? 'selected' : ''; ?>>Selk’nam</option>
                <option value="Yaganes" <?php echo ($info_adicional['etnia'] ?? '' == 'Yaganes') ? 'selected' : ''; ?>>Yaganes</option>
            </select>

            <label for="problemas_aprendizaje">Problemas de Aprendizaje:</label>
            <textarea id="problemas_aprendizaje" name="problemas_aprendizaje"><?php echo htmlspecialchars($info_adicional['problemas_aprendizaje'] ?? ''); ?></textarea>

            <label for="cursos_repetidos">Cursos Repetidos:</label>
            <textarea id="cursos_repetidos" name="cursos_repetidos"><?php echo htmlspecialchars($info_adicional['cursos_repetidos'] ?? ''); ?></textarea>

            <button type="submit">Actualizar Matrícula</button>
        </form>
    </div>

    <script>
        function validateForm(event) {
            const requiredFields = [
                'rut', 'nombres', 'apellido_paterno', 'apellido_materno', 'fecha_nac', 'lugar_nac',
                'dom_alumno', 'curso_id', 'procedencia'
            ];

            let valid = true;
            requiredFields.forEach((fieldId) => {
                const field = document.getElementById(fieldId);
                if (!field.value.trim()) {
                    field.style.border = "2px solid red"; // Destacar los campos vacíos
                    valid = false;
                } else {
                    field.style.border = ""; // Restaurar el estilo si el campo está lleno
                }
            });

            if (!valid) {
                event.preventDefault(); // Detener el envío del formulario
                alert("Por favor, completa todos los campos obligatorios.");
            }
        }

        function toggleCulturaFields(checkbox) {
            const etniaField = document.getElementById('etnia');
            if (checkbox.checked) {
                etniaField.disabled = false; // Habilitar el campo si es bicultural
            } else {
                etniaField.disabled = true;  // Deshabilitar si no es bicultural
                etniaField.value = '';       // Limpiar el valor del campo
            }
        }

        // Ejecutar al cargar la página para asegurar que el estado inicial es correcto
        document.addEventListener('DOMContentLoaded', function() {
            const checkbox = document.getElementById('es_bicultural');
            toggleCulturaFields(checkbox);
        });

        function addAlergia() {
            const container = document.getElementById('alergias-container');
            const input = document.createElement('input');
            input.type = 'text';
            input.name = 'alergico_alimentario[]';
            input.placeholder = 'Ingrese una alergia alimentaria';
            container.appendChild(input);
        }
    </script>
</body>
</html>
