<?php
header('Content-Type: text/html; charset=utf-8'); // Establecer la codificación de caracteres

include '../includes/db.php';
include '../includes/auth.php';
checkAuth();

// Establecer la codificación de caracteres para la conexión de la base de datos
$conn->set_charset("utf8");

$message = ''; // Variable para almacenar el mensaje

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Obtener los datos del formulario
    $num_centro_apoderados = isset($_POST['num_centro_apoderados']) ? $conn->real_escape_string($_POST['num_centro_apoderados']) : null;
    $rut = isset($_POST['rut']) ? $conn->real_escape_string($_POST['rut']) : null;
    $nombres = isset($_POST['nombres']) ? $conn->real_escape_string($_POST['nombres']) : null;
    $apellido_paterno = isset($_POST['apellido_paterno']) ? $conn->real_escape_string($_POST['apellido_paterno']) : null;
    $apellido_materno = isset($_POST['apellido_materno']) ? $conn->real_escape_string($_POST['apellido_materno']) : null;
    $fecha_nac = isset($_POST['fecha_nac']) ? $_POST['fecha_nac'] : null;
    $lugar_nac = isset($_POST['lugar_nac']) ? $conn->real_escape_string($_POST['lugar_nac']) : null;
    $dom_alumno = isset($_POST['dom_alumno']) ? $conn->real_escape_string($_POST['dom_alumno']) : null;
    $curso_id = isset($_POST['curso_id']) ? intval($_POST['curso_id']) : null;
    $fech_ing_curso = isset($_POST['fech_ing_curso']) ? $_POST['fech_ing_curso'] : null;
    $procedencia = isset($_POST['procedencia']) ? $conn->real_escape_string($_POST['procedencia']) : null;

    // Consolidar las selecciones de personas con quienes vive el alumno
    $persona_con_quien_vive = isset($_POST['vive_con']) ? implode(', ', $_POST['vive_con']) : null;

    // Información de salud
    $prevision_salud = isset($_POST['prevision_salud']) ? intval($_POST['prevision_salud']) : null;
    $alergias = isset($_POST['alergico_alimentario']) ? $_POST['alergico_alimentario'] : [];

    // Información adicional
    $es_bicultural = isset($_POST['es_bicultural']) ? 1 : 0;
    $etnia = isset($_POST['etnia']) ? $conn->real_escape_string($_POST['etnia']) : null;
    $problemas_aprendizaje = isset($_POST['problemas_aprendizaje']) ? $conn->real_escape_string($_POST['problemas_aprendizaje']) : null;
    $cursos_repetidos = isset($_POST['cursos_repetidos']) ? $conn->real_escape_string($_POST['cursos_repetidos']) : null;

    // Información de apoderados
    $nombre_apoderado1 = isset($_POST['nombre_apoderado1']) ? $conn->real_escape_string($_POST['nombre_apoderado1']) : null;
    $rut_apoderado1 = isset($_POST['rut_apoderado1']) ? $conn->real_escape_string($_POST['rut_apoderado1']) : null;
    $telefono_apoderado1 = isset($_POST['telefono_apoderado1']) ? $conn->real_escape_string($_POST['telefono_apoderado1']) : null;
    $celular_apoderado1 = isset($_POST['celular_apoderado1']) ? $conn->real_escape_string($_POST['celular_apoderado1']) : null;
    $parentesco_apoderado1 = isset($_POST['parentesco_apoderado1']) ? $conn->real_escape_string($_POST['parentesco_apoderado1']) : null;

    $nombre_apoderado2 = isset($_POST['nombre_apoderado2']) ? $conn->real_escape_string($_POST['nombre_apoderado2']) : null;
    $rut_apoderado2 = isset($_POST['rut_apoderado2']) ? $conn->real_escape_string($_POST['rut_apoderado2']) : null;
    $telefono_apoderado2 = isset($_POST['telefono_apoderado2']) ? $conn->real_escape_string($_POST['telefono_apoderado2']) : null;
    $celular_apoderado2 = isset($_POST['celular_apoderado2']) ? $conn->real_escape_string($_POST['celular_apoderado2']) : null;
    $parentesco_apoderado2 = isset($_POST['parentesco_apoderado2']) ? $conn->real_escape_string($_POST['parentesco_apoderado2']) : null;

    // Iniciar la transacción
    $conn->begin_transaction();

    try {
        // Insertar datos en la tabla de matriculas
        $stmt = $conn->prepare("INSERT INTO matricula (num_centro_apoderados, rut, nombre, apellido_paterno, apellido_materno, curso_id, fecha_nac, lugar_nac, dom_alumno, fech_ing_curso, procedencia, persona_con_quien_vive) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        $stmt->bind_param("issssissssss", $num_centro_apoderados, $rut, $nombres, $apellido_paterno, $apellido_materno, $curso_id, $fecha_nac, $lugar_nac, $dom_alumno, $fech_ing_curso, $procedencia, $persona_con_quien_vive);
        $stmt->execute();
        $matricula_id = $conn->insert_id; // Obtener el ID de la matrícula recién insertada

        // Insertar datos en la tabla de previsiones de salud
        $stmt = $conn->prepare("INSERT INTO previsiones_salud (matricula_id, tipo_prevision_id) VALUES (?, ?)");
        $stmt->bind_param("ii", $matricula_id, $prevision_salud);
        $stmt->execute();

        // Insertar las alergias alimentarias si las hay
        if (!empty($alergias)) {
            foreach ($alergias as $alergia) {
                $stmt = $conn->prepare("INSERT INTO alergias_alimentarias (matricula_id, alergia) VALUES (?, ?)");
                $stmt->bind_param("is", $matricula_id, $alergia);
                $stmt->execute();
            }
        }

        // Insertar datos en la tabla de información adicional
        $stmt = $conn->prepare("INSERT INTO informacion_adicional (matricula_id, es_bicultural, etnia, problemas_aprendizaje, cursos_repetidos) VALUES (?, ?, ?, ?, ?)");
        $stmt->bind_param("iisss", $matricula_id, $es_bicultural, $etnia, $problemas_aprendizaje, $cursos_repetidos);
        $stmt->execute();

        // Información de familiares
        $vive_mama = isset($_POST['vive_con']) && in_array('Madre', $_POST['vive_con']);
        $vive_papa = isset($_POST['vive_con']) && in_array('Padre', $_POST['vive_con']);
        $vive_otro = isset($_POST['vive_con']) && in_array('Otro', $_POST['vive_con']);

        // Insertar datos de la madre si aplica
        if ($vive_mama) {
            $nombre_mama = isset($_POST['nombre_mama']) ? $conn->real_escape_string($_POST['nombre_mama']) : null;
            $apellido_paterno_mama = isset($_POST['apellido_paterno_mama']) ? $conn->real_escape_string($_POST['apellido_paterno_mama']) : null;
            $apellido_materno_mama = isset($_POST['apellido_materno_mama']) ? $conn->real_escape_string($_POST['apellido_materno_mama']) : null;
            $rut_mama = isset($_POST['rut_mama']) ? $conn->real_escape_string($_POST['rut_mama']) : null;
            $dom_mama = isset($_POST['dom_mama']) ? $conn->real_escape_string($_POST['dom_mama']) : null;
            $escolaridad_mama = isset($_POST['escolaridad_mama']) ? $conn->real_escape_string($_POST['escolaridad_mama']) : null;
            $trabaja_mama = isset($_POST['trabaja_mama']) ? intval($_POST['trabaja_mama']) : null;
            $tipo_trabajo_mama = isset($_POST['tipo_trabajo_mama']) ? $conn->real_escape_string($_POST['tipo_trabajo_mama']) : null;
            $dentro_fuera_hogar_mama = isset($_POST['dentro_fuera_hogar_mama']) ? $conn->real_escape_string($_POST['dentro_fuera_hogar_mama']) : null;

            // Consulta SQL ajustada para que las columnas coincidan con los valores
                        $stmt = $conn->prepare("INSERT INTO familiares (matricula_id, rut, nombre, apellido_paterno, apellido_materno, domicilio, escolaridad, trabaja, tipo_trabajo, dentro_fuera_hogar, parentesco) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, 'Madre')");
            $stmt->bind_param("issssssiss", $matricula_id, $rut_mama, $nombre_mama, $apellido_paterno_mama, $apellido_materno_mama, $dom_mama, $escolaridad_mama, $trabaja_mama, $tipo_trabajo_mama, $dentro_fuera_hogar_mama);
            $stmt->execute();
        }

        // Insertar datos del padre si aplica
        if ($vive_papa) {
            $nombre_papa = isset($_POST['nombre_papa']) ? $conn->real_escape_string($_POST['nombre_papa']) : null;
            $apellido_paterno_papa = isset($_POST['apellido_paterno_papa']) ? $conn->real_escape_string($_POST['apellido_paterno_papa']) : null;
            $apellido_materno_papa = isset($_POST['apellido_materno_papa']) ? $conn->real_escape_string($_POST['apellido_materno_papa']) : null;
            $rut_papa = isset($_POST['rut_papa']) ? $conn->real_escape_string($_POST['rut_papa']) : null;
            $dom_papa = isset($_POST['dom_papa']) ? $conn->real_escape_string($_POST['dom_papa']) : null;
            $escolaridad_papa = isset($_POST['escolaridad_papa']) ? $conn->real_escape_string($_POST['escolaridad_papa']) : null;
            $trabaja_papa = isset($_POST['trabaja_papa']) ? intval($_POST['trabaja_papa']) : null;
            $tipo_trabajo_papa = isset($_POST['tipo_trabajo_papa']) ? $conn->real_escape_string($_POST['tipo_trabajo_papa']) : null;
            $dentro_fuera_hogar_papa = isset($_POST['dentro_fuera_hogar_papa']) ? $conn->real_escape_string($_POST['dentro_fuera_hogar_papa']) : null;

            $stmt = $conn->prepare("INSERT INTO familiares (matricula_id, rut, nombre, apellido_paterno, apellido_materno, domicilio, escolaridad, trabaja, tipo_trabajo, dentro_fuera_hogar, parentesco) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, 'Padre')");
            $stmt->bind_param("issssssiss", $matricula_id, $rut_papa, $nombre_papa, $apellido_paterno_papa, $apellido_materno_papa, $dom_papa, $escolaridad_papa, $trabaja_papa, $tipo_trabajo_papa, $dentro_fuera_hogar_papa);
            $stmt->execute();
        }

        // Insertar datos de otra persona si aplica
        if ($vive_otro) {
            $nombre_otro = isset($_POST['nombre_otro']) ? $conn->real_escape_string($_POST['nombre_otro']) : null;
            $apellido_paterno_otro = isset($_POST['apellido_paterno_otro']) ? $conn->real_escape_string($_POST['apellido_paterno_otro']) : null;
            $apellido_materno_otro = isset($_POST['apellido_materno_otro']) ? $conn->real_escape_string($_POST['apellido_materno_otro']) : null;
            $rut_otro = isset($_POST['rut_otro']) ? $conn->real_escape_string($_POST['rut_otro']) : null;
            $dom_otro = isset($_POST['dom_otro']) ? $conn->real_escape_string($_POST['dom_otro']) : null;
            $escolaridad_otro = isset($_POST['escolaridad_otro']) ? $conn->real_escape_string($_POST['escolaridad_otro']) : null;
            $trabaja_otro = isset($_POST['trabaja_otro']) ? intval($_POST['trabaja_otro']) : null;
            $tipo_trabajo_otro = isset($_POST['tipo_trabajo_otro']) ? $conn->real_escape_string($_POST['tipo_trabajo_otro']) : null;
            $dentro_fuera_hogar_otro = isset($_POST['dentro_fuera_hogar_otro']) ? $conn->real_escape_string($_POST['dentro_fuera_hogar_otro']) : null;
            $parentesco_otro = isset($_POST['parentesco_otro']) ? $conn->real_escape_string($_POST['parentesco_otro']) : null;

            $stmt = $conn->prepare("INSERT INTO familiares (matricula_id, rut, nombre, apellido_paterno, apellido_materno, domicilio, escolaridad, trabaja, tipo_trabajo, dentro_fuera_hogar, parentesco) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            $stmt->bind_param("issssssssss", $matricula_id, $rut_otro, $nombre_otro, $apellido_paterno_otro, $apellido_materno_otro, $dom_otro, $escolaridad_otro, $trabaja_otro, $tipo_trabajo_otro, $dentro_fuera_hogar_otro, $parentesco_otro);
            $stmt->execute();
        }

        // Insertar los datos del apoderado 1
        if ($nombre_apoderado1 && $rut_apoderado1 && $telefono_apoderado1 && $parentesco_apoderado1) {
            $stmt = $conn->prepare("INSERT INTO apoderados (matricula_id, rut, nombre, telefono, celular, parentesco) VALUES (?, ?, ?, ?, ?, ?)");
            $stmt->bind_param("isssss", $matricula_id, $rut_apoderado1, $nombre_apoderado1, $telefono_apoderado1, $celular_apoderado1, $parentesco_apoderado1);
            $stmt->execute();
        }

        // Insertar los datos del apoderado 2, si están presentes
        if ($nombre_apoderado2 && $rut_apoderado2 && $telefono_apoderado2 && $parentesco_apoderado2) {
            $stmt = $conn->prepare("INSERT INTO apoderados (matricula_id, rut, nombre, telefono, celular, parentesco) VALUES (?, ?, ?, ?, ?, ?)");
            $stmt->bind_param("isssss", $matricula_id, $rut_apoderado2, $nombre_apoderado2, $telefono_apoderado2, $celular_apoderado2, $parentesco_apoderado2);
            $stmt->execute();
        }

        // Confirmar la transacción
        $conn->commit();
        $message = "Matrícula registrada exitosamente.";
    } catch (Exception $e) {
        // En caso de error, revertir la transacción
        $conn->rollback();
        $message = "Error al registrar la matrícula: " . $e->getMessage();
    }
}

// Obtener los cursos y previsiones desde la base de datos
$cursos_result = $conn->query("SELECT id, nombre FROM curso");
$previsiones_result = $conn->query("SELECT id, nombre FROM tipo_prevision ORDER BY nombre");
if (!$cursos_result || !$previsiones_result) {
    die("Error al obtener los cursos o previsiones: " . htmlspecialchars($conn->error, ENT_QUOTES, 'UTF-8'));
}

$conn->close(); // Cerrar la conexión solo al final
?>


<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Formulario de Matrícula</title>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="../css/matricula.css">
    <style>
       
    </style>
    <script>
        // Función para actualizar el campo parentesco basado en la selección
        function toggleParentesco(familia, checkbox) {
            const parentescoField = document.getElementById(`parentesco_${familia}`);
            if (checkbox.checked && familia === 'mama') {
                parentescoField.value = 'Madre';
                parentescoField.readOnly = true;  // Deshabilitar edición
            } else if (checkbox.checked && familia === 'papa') {
                parentescoField.value = 'Padre';
                parentescoField.readOnly = true;  // Deshabilitar edición
            } else if (checkbox.checked && familia === 'otro') {
                parentescoField.value = '';  // Permitir que lo escriba el usuario
                parentescoField.readOnly = false;  // Habilitar edición
            } else {
                parentescoField.value = '';  // Limpiar el campo si se deselecciona
                parentescoField.readOnly = true;  // Bloquear el campo si se deselecciona
            }
        }

        // Función para mostrar/ocultar secciones y actualizar el parentesco
        function toggleSection(sectionId, checkbox, familia) {
            const section = document.getElementById(sectionId);
            if (checkbox.checked) {
                section.classList.remove('hidden');  // Mostrar la sección
                toggleParentesco(familia, checkbox); // Actualizar el campo parentesco
            } else {
                section.classList.add('hidden');  // Ocultar la sección
                toggleParentesco(familia, checkbox); // Limpiar el campo parentesco
            }
        }
        
        function toggleCulturaFields(checkbox) {
            const etniaField = document.getElementById('etnia');
            if (checkbox.checked) {
                etniaField.disabled = false; // Habilitar el campo si es bicultural
            } else {
                etniaField.disabled = true;  // Deshabilitar si no es bicultural
                etniaField.value = '';       // Limpiar el valor del campo
            }
        }
        
        function toggleTrabajoFields(familia, trabaja) {
            const tipoTrabajoField = document.getElementById(`tipo_trabajo_${familia}`);
            const dentroFueraHogarField = document.getElementById(`dentro_fuera_hogar_${familia}`);

            if (trabaja) {
                tipoTrabajoField.disabled = false;  // Habilitar el campo de tipo de trabajo
                dentroFueraHogarField.disabled = false;  // Habilitar el campo de dentro/fuera del hogar
            } else {
                tipoTrabajoField.disabled = true;  // Deshabilitar el campo de tipo de trabajo
                dentroFueraHogarField.disabled = true;  // Deshabilitar el campo de dentro/fuera del hogar
                tipoTrabajoField.value = '';  // Limpiar el valor del campo
                dentroFueraHogarField.value = '';  // Limpiar el valor del campo
            }
        }

        function addAlergia() {
            // Obtener el contenedor donde se agregarán los nuevos campos de alergia
            const alergiasContainer = document.getElementById('alergias-container');

            // Crear un nuevo div para la alergia (incluyendo el campo de entrada y el botón de eliminar)
            const newAlergiaDiv = document.createElement('div');
            newAlergiaDiv.classList.add('alergia-entry'); // Añadimos una clase para estilos o manipulación futura

            // Crear un nuevo campo de entrada
            const newAlergiaInput = document.createElement('input');
            newAlergiaInput.setAttribute('type', 'text');
            newAlergiaInput.setAttribute('name', 'alergico_alimentario[]');
            newAlergiaInput.setAttribute('placeholder', 'Ingrese una alergia alimentaria');
            newAlergiaInput.style.marginRight = '10px'; // Espacio para el botón de eliminar

            // Crear el botón de eliminar
            const removeButton = document.createElement('button');
            removeButton.setAttribute('type', 'button');
            removeButton.innerText = 'Eliminar';
            removeButton.style.marginTop = '10px';
            removeButton.style.backgroundColor = 'red'; // Color de fondo rojo
            removeButton.style.color = 'white'; // Texto blanco
            removeButton.style.border = 'none'; // Sin borde
            removeButton.style.padding = '5px 10px'; // Padding
            removeButton.style.cursor = 'pointer'; // Cambiar el cursor al pasar el mouse
            removeButton.style.borderRadius = '5px'; // Bordes redondeados
            removeButton.onclick = function() {
                // Eliminar el div completo cuando se hace clic en "Eliminar"
                alergiasContainer.removeChild(newAlergiaDiv);
            };

            // Añadir el campo de entrada y el botón de eliminar al div
            newAlergiaDiv.appendChild(newAlergiaInput);
            newAlergiaDiv.appendChild(removeButton);

            // Agregar el nuevo div al contenedor de alergias
            alergiasContainer.appendChild(newAlergiaDiv);
        }
    </script>
</head>
<body>
    <header>
        <img src="../images/INSIGNIA SF.png" alt="Escuela Porongo Insignia">
        <h1>Formulario de Matrícula</h1>

    
    <nav>
        <ul>
            <li><a href="../index.php">Inicio</a></li>
        </ul>
    </nav>
        </header>
    <div class="form-container">
        <?php if ($message): ?>
            <div class="mensaje <?php echo strpos($message, 'Error') === false ? 'exito' : 'error'; ?>">
                <?php echo $message; ?>
            </div>
        <?php endif; ?>

        <form action="formulario_matricula.php" method="POST">
            <!-- Información del Estudiante -->
            <label for="num_centro_apoderados">Número de Matrícula:</label>
            <input type="text" id="num_centro_apoderados" name="num_centro_apoderados">

            <label for="rut">RUN (ejemplo: 12345678-9):</label>
            <input type="text" id="rut" name="rut" placeholder="Ejemplo: 12345678-9" required>

            <label for="nombres">Nombres:</label>
            <input type="text" id="nombres" name="nombres" required>

            <label for="apellido_paterno">Apellido Paterno:</label>
            <input type="text" id="apellido_paterno" name="apellido_paterno" required>

            <label for="apellido_materno">Apellido Materno:</label>
            <input type="text" id="apellido_materno" name="apellido_materno" required>

            <label for="fecha_nac">Fecha de Nacimiento:</label>
            <input type="date" id="fecha_nac" name="fecha_nac" required>

            <label for="lugar_nac">Lugar de Nacimiento:</label>
            <input type="text" id="lugar_nac" name="lugar_nac" required>

            <label for="dom_alumno">Domicilio del Alumno:</label>
            <input type="text" id="dom_alumno" name="dom_alumno" required>

            <label for="curso_id">Curso:</label>
            <select id="curso_id" name="curso_id" required>
                <?php while ($curso = $cursos_result->fetch_assoc()): ?>
                    <option value="<?php echo htmlspecialchars($curso['id'], ENT_QUOTES, 'UTF-8'); ?>">
                        <?php echo htmlspecialchars($curso['nombre'], ENT_QUOTES, 'UTF-8'); ?>
                    </option>
                <?php endwhile; ?>
            </select>

            <label for="fech_ing_curso">Fecha de Ingreso al Curso:</label>
            <input type="date" id="fech_ing_curso" name="fech_ing_curso" required>

            <label for="procedencia">Procedencia (Colegio o Jardín Infantil):</label>
            <input type="text" id="procedencia" name="procedencia" required>

            <!-- Información de Salud -->
            <h3>Información de Salud</h3>

            <label for="prevision_salud">Previsión de Salud:</label>
            <select id="prevision_salud" name="prevision_salud" required>
                <?php while ($prevision = $previsiones_result->fetch_assoc()): ?>
                    <option value="<?php echo htmlspecialchars($prevision['id'], ENT_QUOTES, 'UTF-8'); ?>">
                        <?php echo htmlspecialchars($prevision['nombre'], ENT_QUOTES, 'UTF-8'); ?>
                    </option>
                <?php endwhile; ?>
            </select>

            <h3>Alergias Alimentarias</h3>
            <div id="alergias-container">
                <label for="alergico_alimentario">Alergias Alimentarias (si tiene alguna):</label>
                <input type="text" name="alergico_alimentario[]" placeholder="Ingrese una alergia alimentaria">
            </div>

            <!-- Colocamos el botón en su propio div y agregamos margen -->
            <div style="margin-top: 20px;">
                <button type="button" onclick="addAlergia()">Añadir otra alergia</button>
            </div>


            <!-- Información de Familiares -->
            <h3>Persona con quien vive el Alumno</h3>
            <div class="checkbox-container">
                <input type="checkbox" id="vive_mama" name="vive_con[]" value="Madre" onclick="toggleSection('section_mama', this, 'mama')">
                <label for="vive_mama">Vive con la Madre</label>

                <input type="checkbox" id="vive_papa" name="vive_con[]" value="Padre" onclick="toggleSection('section_papa', this, 'papa')">
                <label for="vive_papa">Vive con el Padre</label>

                <input type="checkbox" id="vive_otro" name="vive_con[]" value="Otro" onclick="toggleSection('section_otro', this, 'otro')">
                <label for="vive_otro">Vive con Otro</label>
            </div>

            <!-- Sección para la información de la madre -->
            <div id="section_mama" class="hidden">
                <h3>Información de la Madre</h3>

                <label for="nombre_mama">Nombre de la Madre:</label>
                <input type="text" id="nombre_mama" name="nombre_mama">

                <label for="apellido_paterno_mama">Apellido Paterno de la Madre:</label>
                <input type="text" id="apellido_paterno_mama" name="apellido_paterno_mama">

                <label for="apellido_materno_mama">Apellido Materno de la Madre:</label>
                <input type="text" id="apellido_materno_mama" name="apellido_materno_mama">

                <label for="rut_mama">RUN de la Madre:</label>
                <input type="text" id="rut_mama" name="rut_mama">

                <label for="dom_mama">Domicilio de la Madre:</label>
                <input type="text" id="dom_mama" name="dom_mama">

                <label for="escolaridad_mama">Escolaridad de la Madre:</label>
                <select id="escolaridad_mama" name="escolaridad_mama">
                    <option value="">Seleccione una opción</option>
                    <option value="basica_completa">Enseñanza Básica Completa</option>
                    <option value="basica_incompleta">Enseñanza Básica Incompleta</option>
                    <option value="media_completa">Enseñanza Media Completa</option>
                    <option value="media_incompleta">Enseñanza Media Incompleta</option>
                    <option value="tecnica_completa">Estudios Técnicos Completos</option>
                    <option value="tecnica_incompleta">Estudios Técnicos Incompletos</option>
                    <option value="superior_completa">Estudios Superiores Completos</option>
                    <option value="superior_incompleta">Estudios Superiores Incompletos</option>
                </select>

                <label for="trabaja_mama">¿Trabaja la Madre?</label>
                <div class="checkbox-container">
                    <label><input type="radio" id="trabaja_mama_si" name="trabaja_mama" value="1" onclick="toggleTrabajoFields('mama', true)"> Sí</label>
                    <label><input type="radio" id="trabaja_mama_no" name="trabaja_mama" value="0" onclick="toggleTrabajoFields('mama', false)"> No</label>
                </div>

                <label for="tipo_trabajo_mama">Tipo de Trabajo de la Madre:</label>
                <select id="tipo_trabajo_mama" name="tipo_trabajo_mama" disabled>
                    <option value="">Seleccione una opción</option>
                    <option value="independiente">Independiente</option>
                    <option value="dependiente">Dependiente</option>
                </select>

                <label for="dentro_fuera_hogar_mama">¿Dentro o Fuera del Hogar?</label>
                <select id="dentro_fuera_hogar_mama" name="dentro_fuera_hogar_mama" disabled>
                    <option value="">Seleccione una opción</option>
                    <option value="dentro">Dentro del Hogar</option>
                    <option value="fuera">Fuera del Hogar</option>
                </select>

                <!-- Campo de parentesco automáticamente lleno -->
                <label for="parentesco_mama">Parentesco:</label>
                <input type="text" id="parentesco_mama" name="parentesco_mama" readonly>
            </div>

            <!-- Sección para el padre con la misma funcionalidad -->
            <div id="section_papa" class="hidden">
                <h3>Información del Padre</h3>
                <label for="nombre_papa">Nombre del Padre:</label>
                <input type="text" id="nombre_papa" name="nombre_papa">

                <label for="apellido_paterno_papa">Apellido Paterno del Padre:</label>
                <input type="text" id="apellido_paterno_papa" name="apellido_paterno_papa">

                <label for="apellido_materno_papa">Apellido Materno del Padre:</label>
                <input type="text" id="apellido_materno_papa" name="apellido_materno_papa">

                <label for="rut_papa">RUN del Padre:</label>
                <input type="text" id="rut_papa" name="rut_papa">

                <label for="dom_papa">Domicilio del Padre:</label>
                <input type="text" id="dom_papa" name="dom_papa">

                <label for="escolaridad_papa">Escolaridad del Padre:</label>
                <select id="escolaridad_papa" name="escolaridad_papa">
                    <option value="">Seleccione una opción</option>
                    <option value="basica_completa">Enseñanza Básica Completa</option>
                    <option value="basica_incompleta">Enseñanza Básica Incompleta</option>
                    <option value="media_completa">Enseñanza Media Completa</option>
                    <option value="media_incompleta">Enseñanza Media Incompleta</option>
                    <option value="tecnica_completa">Estudios Técnicos Completos</option>
                    <option value="tecnica_incompleta">Estudios Técnicos Incompletos</option>
                    <option value="superior_completa">Estudios Superiores Completos</option>
                    <option value="superior_incompleta">Estudios Superiores Incompletos</option>
                </select>

                <label for="trabaja_papa">¿Trabaja el Padre?</label>
                <div class="checkbox-container">
                    <label><input type="radio" id="trabaja_papa_si" name="trabaja_papa" value="1" onclick="toggleTrabajoFields('papa', true)"> Sí</label>
                    <label><input type="radio" id="trabaja_papa_no" name="trabaja_papa" value="0" onclick="toggleTrabajoFields('papa', false)"> No</label>
                </div>

                <label for="tipo_trabajo_papa">Tipo de Trabajo del Padre:</label>
                <select id="tipo_trabajo_papa" name="tipo_trabajo_papa" disabled>
                    <option value="">Seleccione una opción</option>
                    <option value="independiente">Independiente</option>
                    <option value="dependiente">Dependiente</option>
                </select>

                <label for="dentro_fuera_hogar_papa">¿Dentro o Fuera del Hogar?</label>
                <select id="dentro_fuera_hogar_papa" name="dentro_fuera_hogar_papa" disabled>
                    <option value="">Seleccione una opción</option>
                    <option value="dentro">Dentro del Hogar</option>
                    <option value="fuera">Fuera del Hogar</option>
                </select>

                <!-- Campo de parentesco automáticamente lleno -->
                <label for="parentesco_papa">Parentesco:</label>
                <input type="text" id="parentesco_papa" name="parentesco_papa" readonly>
            </div>

            <!-- Sección para la información de otra persona -->
            <div id="section_otro" class="hidden">
                <h3>Información de Otra Persona</h3>

                <label for="nombre_otro">Nombre de la Persona:</label>
                <input type="text" id="nombre_otro" name="nombre_otro">

                <label for="apellido_paterno_otro">Apellido Paterno de la Persona:</label>
                <input type="text" id="apellido_paterno_otro" name="apellido_paterno_otro">

                <label for="apellido_materno_otro">Apellido Materno de la Persona:</label>
                <input type="text" id="apellido_materno_otro" name="apellido_materno_otro">

                <label for="rut_otro">RUN de la Persona:</label>
                <input type="text" id="rut_otro" name="rut_otro">

                <label for="dom_otro">Domicilio de la Persona:</label>
                <input type="text" id="dom_otro" name="dom_otro">

                <!-- Campo de parentesco editable -->
                <label for="parentesco_otro">Parentesco:</label>
                <input type="text" id="parentesco_otro" name="parentesco_otro">
            </div>

            <!-- Información de Apoderados -->
            <h3>Información de Apoderados</h3>

            <label for="nombre_apoderado1">Nombre del Apoderado 1:</label>
            <input type="text" id="nombre_apoderado1" name="nombre_apoderado1" required>

            <label for="rut_apoderado1">RUN del Apoderado 1:</label>
            <input type="text" id="rut_apoderado1" name="rut_apoderado1" required>

            <label for="telefono_apoderado1">Teléfono del Apoderado 1:</label>
            <input type="text" id="telefono_apoderado1" name="telefono_apoderado1" required>

            <label for="celular_apoderado1">Celular del Apoderado 1:</label>
            <input type="text" id="celular_apoderado1" name="celular_apoderado1">

            <label for="parentesco_apoderado1">Parentesco del Apoderado 1:</label>
            <input type="text" id="parentesco_apoderado1" name="parentesco_apoderado1" required>

            <br>

            <label for="nombre_apoderado2">Nombre del Apoderado 2:</label>
            <input type="text" id="nombre_apoderado2" name="nombre_apoderado2">

            <label for="rut_apoderado2">RUN del Apoderado 2:</label>
            <input type="text" id="rut_apoderado2" name="rut_apoderado2">

            <label for="telefono_apoderado2">Teléfono del Apoderado 2:</label>
            <input type="text" id="telefono_apoderado2" name="telefono_apoderado2">

            <label for="celular_apoderado2">Celular del Apoderado 2:</label>
            <input type="text" id="celular_apoderado2" name="celular_apoderado2">

            <label for="parentesco_apoderado2">Parentesco del Apoderado 2:</label>
            <input type="text" id="parentesco_apoderado2" name="parentesco_apoderado2">

            <!-- Información Adicional -->
            <h3>Información Adicional</h3>

            <label for="es_bicultural">¿Es el alumno bicultural?</label>
            <input type="checkbox" id="es_bicultural" name="es_bicultural" onclick="toggleCulturaFields(this)">

            <label for="etnia">Cultura:</label>
            <select id="etnia" name="etnia" disabled>
                <option value="">Seleccione una opción</option>
                <option value="Aymara">Aymara</option>
                <option value="Atacameño o Likan Antai">Atacameño o Likan Antai</option>
                <option value="Quechua">Quechua</option>
                <option value="Collas">Collas</option>
                <option value="Changos">Changos</option>
                <option value="Diaguitas">Diaguitas</option>
                <option value="Rapanui">Rapanui</option>
                <option value="Mapuche">Mapuche</option>
                <option value="Kawésqar">Kawésqar</option>
                <option value="Selk’nam">Selk’nam</option>
                <option value="Yaganes">Yaganes</option>
            </select>

            <label for="problemas_aprendizaje">Problemas de Aprendizaje u Otros:</label>
            <textarea id="problemas_aprendizaje" name="problemas_aprendizaje"></textarea>

            <label for="cursos_repetidos">Cursos Repetidos:</label>
            <textarea id="cursos_repetidos" name="cursos_repetidos"></textarea>

            <button type="submit">Guardar Matrícula</button>
        </form>
    </div>
</body>
</html>
