<?php
header('Content-Type: text/html; charset=utf-8');

include 'includes/db.php';
include 'includes/auth.php';
checkAuth();

$conn->set_charset("utf8");

$matricula_id = $_GET['id']; // Suponiendo que recibes el ID de la matrícula por GET

// Consulta para obtener datos de la tabla `matricula`
$sql_matricula = "SELECT * FROM matricula WHERE id = ?";
$stmt = $conn->prepare($sql_matricula);
$stmt->bind_param("i", $matricula_id);
$stmt->execute();
$result_matricula = $stmt->get_result();
$matricula = $result_matricula->fetch_assoc();

// Consulta para obtener datos de la tabla `previsiones_salud`
$sql_prevision = "SELECT tipo_prevision.nombre AS tipo_prevision 
                  FROM previsiones_salud 
                  JOIN tipo_prevision ON previsiones_salud.tipo_prevision_id = tipo_prevision.id
                  WHERE matricula_id = ?";
$stmt = $conn->prepare($sql_prevision);
$stmt->bind_param("i", $matricula_id);
$stmt->execute();
$result_prevision = $stmt->get_result();
$prevision = $result_prevision->fetch_assoc();

// Consulta para obtener datos de la tabla `alergias_alimentarias`
$sql_alergias = "SELECT alergia FROM alergias_alimentarias WHERE matricula_id = ?";
$stmt = $conn->prepare($sql_alergias);
$stmt->bind_param("i", $matricula_id);
$stmt->execute();
$result_alergias = $stmt->get_result();
$alergias = [];
while ($row = $result_alergias->fetch_assoc()) {
    $alergias[] = $row['alergia'];
}

// Consulta para obtener datos de la tabla `informacion_adicional`
$sql_informacion_adicional = "SELECT * FROM informacion_adicional WHERE matricula_id = ?";
$stmt = $conn->prepare($sql_informacion_adicional);
$stmt->bind_param("i", $matricula_id);
$stmt->execute();
$result_informacion_adicional = $stmt->get_result();
$informacion_adicional = $result_informacion_adicional->fetch_assoc();

// Consulta para obtener datos de la tabla `apoderados`
$sql_apoderados = "SELECT * FROM apoderados WHERE matricula_id = ?";
$stmt = $conn->prepare($sql_apoderados);
$stmt->bind_param("i", $matricula_id);
$stmt->execute();
$result_apoderados = $stmt->get_result();
$apoderados = [];
while ($row = $result_apoderados->fetch_assoc()) {
    $apoderados[] = $row;
}

// Consulta para obtener datos de la tabla `familiares`
$sql_familiares = "SELECT * FROM familiares WHERE matricula_id = ?";
$stmt = $conn->prepare($sql_familiares);
$stmt->bind_param("i", $matricula_id);
$stmt->execute();
$result_familiares = $stmt->get_result();
$familiares = [];
while ($row = $result_familiares->fetch_assoc()) {
    $familiares[] = $row;
}

// Consulta para obtener el nombre del curso
$sql_curso = "SELECT nombre FROM curso WHERE id = ?";
$stmt = $conn->prepare($sql_curso);
$stmt->bind_param("i", $matricula['curso_id']);
$stmt->execute();
$result_curso = $stmt->get_result();
$curso = $result_curso->fetch_assoc();
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Ficha de Matrícula</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        .container {
            width: 210mm;
            height: 297mm;
            margin: auto;
            padding: 20px;
            border: 1px solid #000;
        }

        header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 10px 0;
            border-bottom: 2px solid #000;
        }

        header img {
            width: 100px;
        }

        header .info {
            text-align: right;
            font-size: 12px;
        }

        .title {
            text-align: center;
            margin: 20px 0;
            font-weight: bold;
            font-size: 18px;
        }

        .section-title {
            font-weight: bold;
            font-size: 14px;
            margin: 15px 0 5px;
        }

        .form-table {
            width: 100%;
            border-collapse: collapse;
            font-size: 12px;
            margin-bottom: 15px;
        }

        .form-table th, .form-table td {
            border: 1px solid #000;
            padding: 5px;
            text-align: left;
        }

        .form-table th {
            background-color: #f2f2f2;
        }

        .form-table td {
            font-weight: normal;
        }

        .signature-section {
            text-align: center;
            margin-top: 30px;
        }

        .button-section {
            text-align: center;
            margin-top: 20px;
        }

        .button-section button {
            padding: 10px 20px;
            margin: 5px;
            font-size: 14px;
            cursor: pointer;
            border: none;
            background-color: #007bff;
            color: white;
            border-radius: 5px;
        }

        .button-section button:hover {
            background-color: #0056b3;
        }
        input[type="text"] {
            width: 100%; /* Hacer el cuadro de texto del 100% de ancho */
            padding: 5px;
            box-sizing: border-box; /* Incluir padding en el tamaño total */
        }

        @media print {
            .container {
                width: 100%;
                height: 100%;
                padding: 0;
                border: none;
            }
            header, .form-table {
                page-break-inside: avoid;
            }
            .button-section {
                display: none;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <header>
            <img src="images/INSIGNIA SF.png" alt="Insignia">
            <div class="info">
                <p><strong>Escuela Porongo Cauquenes</strong></p>
                <p>Año: <?php echo date("Y"); ?></p>
                <p>Número Registro Matricula: 
                    <input type="text" name="num_centro_apoderados" style="width: 50px; border: none; border-bottom: 1px solid #000; text-align: right;">
                </p>
            </div>
        </header>

        <div class="title">Ficha de Matrícula 2025</div>

        <!-- Sección de datos personales -->
        <div class="section-title">Datos del Estudiante</div>
        <table class="form-table">
            <tr>
                <th>RUN</th>
                <td><?php echo htmlspecialchars($matricula['rut'] ?? '', ENT_QUOTES, 'UTF-8'); ?></td>
                <th>Fecha de Nacimiento</th>
                <td><?php echo htmlspecialchars($matricula['fecha_nac'] ?? '', ENT_QUOTES, 'UTF-8'); ?></td>
            </tr>
            <tr>
                <th>Nombre Completo</th>
                <td colspan="3"><?php echo htmlspecialchars($matricula['nombre'] . ' ' . $matricula['apellido_paterno'] . ' ' . $matricula['apellido_materno'], ENT_QUOTES, 'UTF-8'); ?></td>
            </tr>
            <tr>
                <th>Domicilio</th>
                <td colspan="3"><?php echo htmlspecialchars($matricula['dom_alumno'] ?? '', ENT_QUOTES, 'UTF-8'); ?></td>
            </tr>
            <tr>
                <th>Curso</th>
                <td><?php echo htmlspecialchars($curso['nombre'] ?? '', ENT_QUOTES, 'UTF-8'); ?></td>
                <th>Procedencia</th>
                <td><?php echo htmlspecialchars($matricula['procedencia'] ?? '', ENT_QUOTES, 'UTF-8'); ?></td>
            </tr>
            <tr>
                <th>Previsión de Salud</th>
                <td><?php echo htmlspecialchars($prevision['tipo_prevision'] ?? '', ENT_QUOTES, 'UTF-8'); ?></td>
                <th>Alergias Alimentarias</th>
                <td><?php echo htmlspecialchars(implode(", ", $alergias), ENT_QUOTES, 'UTF-8'); ?></td>
            </tr>
        </table>

        <!-- Sección de datos adicionales -->
        <div class="section-title">Información Adicional</div>
        <table class="form-table">
            <tr>
                <th>Es Bicultural</th>
                <td><?php echo htmlspecialchars($informacion_adicional['es_bicultural'] ? 'Sí' : 'No', ENT_QUOTES, 'UTF-8'); ?></td>
                <th>Etnia</th>
                <td><?php echo htmlspecialchars($informacion_adicional['etnia'] ?? '', ENT_QUOTES, 'UTF-8'); ?></td>
            </tr>
            <tr>
                <th>Problemas de Aprendizaje</th>
                <td colspan="3"><?php echo htmlspecialchars($informacion_adicional['problemas_aprendizaje'] ?? '', ENT_QUOTES, 'UTF-8'); ?></td>
            </tr>
            <tr>
                <th>Cursos Repetidos</th>
                <td colspan="3"><?php echo htmlspecialchars($informacion_adicional['cursos_repetidos'] ?? '', ENT_QUOTES, 'UTF-8'); ?></td>
            </tr>
        </table>

        <!-- Sección de apoderados -->
        <div class="section-title">Información de Apoderados</div>
        <?php foreach ($apoderados as $apoderado): ?>
        <table class="form-table">
            <tr>
                <th>Nombre del Apoderado</th>
                <td><?php echo htmlspecialchars($apoderado['nombre'] ?? '', ENT_QUOTES, 'UTF-8'); ?></td>
                <th>RUN del Apoderado</th>
                <td><?php echo htmlspecialchars($apoderado['rut'] ?? '', ENT_QUOTES, 'UTF-8'); ?></td>
            </tr>
            <tr>
                <th>Teléfono</th>
                <td><?php echo htmlspecialchars($apoderado['telefono'] ?? '', ENT_QUOTES, 'UTF-8'); ?></td>
                <th>Celular</th>
                <td><?php echo htmlspecialchars($apoderado['celular'] ?? '', ENT_QUOTES, 'UTF-8'); ?></td>
            </tr>
            <tr>
                <th>Parentesco</th>
                <td colspan="3"><?php echo htmlspecialchars($apoderado['parentesco'] ?? '', ENT_QUOTES, 'UTF-8'); ?></td>
            </tr>
        </table>
        <?php endforeach; ?>

        <!-- Sección de familiares -->
        <div class="section-title">Información de Familiares</div>
        <?php foreach ($familiares as $familiar): ?>
        <table class="form-table">
            <tr>
                <th>RUT</th>
                <td><?php echo htmlspecialchars($familiar['rut'] ?? '', ENT_QUOTES, 'UTF-8'); ?></td>
                <th>Nombre Completo</th>
                <td><?php echo htmlspecialchars($familiar['nombre'] . ' ' . $familiar['apellido_paterno'] . ' ' . $familiar['apellido_materno'], ENT_QUOTES, 'UTF-8'); ?></td>
            </tr>
            <tr>
                <th>Domicilio</th>
                <td><?php echo htmlspecialchars($familiar['domicilio'] ?? '', ENT_QUOTES, 'UTF-8'); ?></td>
                <th>Escolaridad</th>
                <td><?php echo htmlspecialchars($familiar['escolaridad'] ?? '', ENT_QUOTES, 'UTF-8'); ?></td>
            </tr>
            <tr>
                <th>Trabaja</th>
                <td><?php echo isset($familiar['trabaja']) ? ($familiar['trabaja'] ? 'Sí' : 'No') : 'No especificado'; ?></td>
                <th>Tipo de Trabajo</th>
                <td><?php echo isset($familiar['tipo_trabajo']) ? htmlspecialchars($familiar['tipo_trabajo'], ENT_QUOTES, 'UTF-8') : 'No especificado'; ?></td>
            </tr>
            <tr>
                <th>Dentro/Fuera del Hogar</th>
                <td><?php echo isset($familiar['dentro_fuera_hogar']) ? htmlspecialchars($familiar['dentro_fuera_hogar'], ENT_QUOTES, 'UTF-8') : 'No especificado'; ?></td>
                <th>Parentesco</th>
                <td><?php echo isset($familiar['parentesco']) ? htmlspecialchars($familiar['parentesco'], ENT_QUOTES, 'UTF-8') : 'No especificado'; ?></td>
            </tr>
        </table>
        <?php endforeach; ?>

        <div class="signature-section">
            <p>_____________________________</p>
            <p>Firma del Apoderado</p>
        </div>
        
        <!-- Nueva sección para identificar la persona que retira al alumno -->
        <div class="section-title">Identificación de la Persona que Retira al Alumno(a)</div>
        <table class="form-table">
            <tr>
                <th style="width: 20%;">Nombre Completo</th>
                <td><input type="text" name="nombre_retiro" style="width: 100%;"></td>
            </tr>
            <tr>
                <th style="width: 20%;">Parentesco</th>
                <td><input type="text" name="parentesco_retiro" style="width: 100%;"></td>
            </tr>
            <tr>
                <th style="width: 20%;">Causal de Retiro</th>
                <td><input type="text" name="causal_retiro" style="width: 100%;"></td>
            </tr>
            <tr>
                <th style="width: 20%;">Nuevo Colegio y/o Jardín Infantil</th>
                <td><input type="text" name="nuevo_colegio" style="width: 100%;"></td>
            </tr>
            
        </table>
        <table>
        <tr>
                <th>Declaro recibir carpeta con certificados de estudios de años anteriores y de nacimiento</th>
                <td><input type="checkbox" name="recibo_certificados"> Marcar para confirmar</td>
            </tr>
        </table>
        <div class="signature-section">
            <p>_____________________________</p>
            <p>Firma del Apoderado</p>
        </div>

        <!-- Botones de imprimir y volver -->
        <div class="button-section">
            <button onclick="window.print()">Imprimir</button>
            <button onclick="window.history.back()">Volver</button>
        </div>
    </div>
</body>
</html>
