<?php
session_start();
include '../includes/db.php';
include '../includes/auth.php';
function registrarAccion($usuario, $accion, $curso_id = null, $curso_nombre = null) {
    global $conn;
    $stmt = $conn->prepare("INSERT INTO registro_actividad (usuario, accion, curso_id, curso_nombre, fecha) VALUES (?, ?, ?, ?, NOW())");
    $stmt->bind_param("ssis", $usuario, $accion, $curso_id, $curso_nombre);
    $stmt->execute();
    $stmt->close();
}
checkAuth();
$limiteInactividad = 40 * 60;
if (isset($_SESSION['ultimoAcceso'])) {
    $inactividad = time() - $_SESSION['ultimoAcceso'];
    if ($inactividad > $limiteInactividad) {
        session_unset();
        session_destroy();
        header("Location: login.php");
        exit();
    }
}
$_SESSION['ultimoAcceso'] = time();
$permisos_usuario = [];
$rol_id = $_SESSION['rol'] ?? null;
$usuario_id = $_SESSION['usuario_id'] ?? null;
$conn->set_charset("utf8");

$message = '';
$message_type = '';
$curso_id = isset($_GET['curso_id']) ? $_GET['curso_id'] : null;
$curso_id_html = $curso_id !== null ? htmlspecialchars($curso_id, ENT_QUOTES, 'UTF-8') : '';

// Obtener el ID del rol 'estudiante'
$rol_query = $conn->prepare("SELECT id FROM roles WHERE nombre = 'estudiante'");
$rol_query->execute();
$rol_query->bind_result($rol_estudiante_id);
$rol_query->fetch();
$rol_query->close();

// Inicializar variables para asignatura y semestre seleccionados
$asignatura_seleccionada = '';
$semestre_seleccionado = '';

if ($_SERVER['REQUEST_METHOD'] == 'POST' && (isset($_POST['guardar_multiples_notas']) || isset($_POST['mostrar_notas']))) {
    $curso_id = $_POST['curso_id'];
    $asignatura_id = $_POST['asignatura_id'];
    $semestre = $_POST['semestre'];

    $asignatura_seleccionada = $asignatura_id;
    $semestre_seleccionado = $semestre;

    if (isset($_POST['guardar_multiples_notas'])) {
    foreach ($_POST['notas'] as $usuario_id => $notas) {
        for ($i = 1; $i <= 10; $i++) {
            $nota_input = trim($notas["nota_$i"]);
            if (!empty($nota_input)) {
                $nota_input = str_replace(',', '.', $nota_input);
                if (!preg_match('/^[0-6](\.[0-9])?$|^7(\.0)?$/', $nota_input)) {
                    $message = "Error: Formato de nota inválido detectado (Nota $nota_input). Usa formatos como 6.5 o 7.0. No debe exceder 7.0.";
                    $message_type = 'error';
                    break 2;
                }
                $nota = floatval($nota_input);
                $stmt = $conn->prepare("SELECT id FROM notas WHERE usuario_id = ? AND asignatura_id = ? AND semestre = ? AND numero_nota = ?");
                $stmt->bind_param("iiii", $usuario_id, $asignatura_id, $semestre, $i);
                $stmt->execute();
                $stmt->store_result();
                if ($stmt->num_rows > 0) {
                    $stmt->bind_result($nota_id);
                    $stmt->fetch();
                    $stmt->close();
                    $update_stmt = $conn->prepare("UPDATE notas SET nota = ? WHERE id = ?");
                    $update_stmt->bind_param("di", $nota, $nota_id);
                    $update_stmt->execute();
                    $update_stmt->close();
                } else {
                    $stmt->close();
                    $stmt = $conn->prepare("INSERT INTO notas (usuario_id, asignatura_id, nota, fecha, semestre, numero_nota) VALUES (?, ?, ?, NOW(), ?, ?)");
                    $stmt->bind_param("iidii", $usuario_id, $asignatura_id, $nota, $semestre, $i);
                    $stmt->execute();
                    $stmt->close();
                }
            }
        }
    }
    if ($message === '') {
    $message = 'Notas guardadas correctamente.';
    $message_type = 'exito';

    // Aseguramos que $curso_id esté entero
    $curso_id = intval($curso_id); // Ya fue asignado arriba, solo asegúrate que sea entero
    // Obtener nombre del curso
    $nombre_curso = 'Curso desconocido';
    if (!empty($curso_id)) {
        $stmt_curso = $conn->prepare("SELECT nombre FROM curso WHERE id = ?");
        $stmt_curso->bind_param("i", $curso_id);
        $stmt_curso->execute();
        $stmt_curso->bind_result($nombre_curso_obtenido);
        if ($stmt_curso->fetch()) {
            $nombre_curso = $nombre_curso_obtenido;
        }
        $stmt_curso->close();
    }

    // Obtener nombre de asignatura
    $nombre_asignatura = 'Asignatura desconocida';
    if (!empty($asignatura_id)) {
        $stmt_asig = $conn->prepare("SELECT nombre FROM asignatura WHERE id = ?");
        $stmt_asig->bind_param("i", $asignatura_id);
        $stmt_asig->execute();
        $stmt_asig->bind_result($nombre_asignatura_obtenido);
        if ($stmt_asig->fetch()) {
            $nombre_asignatura = $nombre_asignatura_obtenido;
        }
        $stmt_asig->close();
    }

    // Obtener nombre usuario desde sesión
    $usuario_log = $_SESSION['usuario'] ?? 'Usuario no identificado';
    // Armar mensaje con nombres en vez de IDs
    $accion = "Guardó o modificó notas en el curso \"$nombre_curso\", asignatura \"$nombre_asignatura\", semestre $semestre";

    registrarAccion($usuario_log, $accion, $curso_id, $nombre_curso);
}

}
    $stmt = $conn->prepare("
        SELECT n.usuario_id, n.numero_nota, n.nota 
        FROM notas n
        JOIN usuario u ON n.usuario_id = u.id
        WHERE u.curso_id = ? AND n.asignatura_id = ? AND n.semestre = ?
    ");
    $stmt->bind_param("iii", $curso_id, $asignatura_id, $semestre);
    $stmt->execute();
    $result = $stmt->get_result();
    $notas_existentes = [];
    while ($row = $result->fetch_assoc()) {
        $notas_existentes[$row['usuario_id']][$row['numero_nota']] = $row['nota'];
    }
    $stmt->close();
} else {
    $notas_existentes = [];
}

$cursos = $conn->query("SELECT id, nombre FROM curso WHERE activo = 1 ORDER BY nombre ASC;");
$asignaturas = $conn->query("SELECT id, nombre FROM asignatura ORDER BY nombre ASC");

$estudiantes = [];
if ($curso_id !== null) {
    $stmt = $conn->prepare("SELECT id, CONCAT(apellido_paterno, ' ', apellido_materno, ' ', nombre) AS nombre_completo 
                            FROM usuario 
                            WHERE rol_id = ? AND curso_id = ? AND activo = 1
                            ORDER BY apellido_paterno, apellido_materno, nombre ASC");
    $stmt->bind_param("ii", $rol_estudiante_id, $curso_id);
    $stmt->execute();
    $estudiantes = $stmt->get_result();
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Agregar Notas</title>
    <link rel="stylesheet" href="../css/agregar_notas.css">
    <script>
    function validarFormulario() {
        const inputs = document.querySelectorAll('input[type="number"]');
        for (const input of inputs) {
            const valor = input.value.trim().replace(',', '.');
            if (valor === '') continue;
            if (!/^[0-6](\.[0-9])?$|^7(\.0)?$/.test(valor)) {
                alert(`Nota inválida: ${valor}. Usa formatos como 6.5 o 7.0, y no mayores a 7.0.`);
                input.focus();
                return false;
            }
        }
        return true;
    }
        // Tiempo de inactividad antes de advertir (en milisegundos)
    const tiempoAdvertencia = 35 * 60 * 1000; // 35 minutos
    const tiempoCierreSesion = 5 * 60 * 1000; // 5 minutos después de la advertencia

    let advertenciaMostrada = false;

    setTimeout(() => {
        if (!advertenciaMostrada) {
            advertenciaMostrada = true;
            const confirmacion = confirm("Has estado inactivo por un tiempo. Tu sesión se cerrará en 5 minutos si no interactúas.");
            if (!confirmacion) {
                // Si no responde o cierra el cuadro, se espera y se redirige
                setTimeout(() => {
                    window.location.href = "login.php";
                }, tiempoCierreSesion);
            }
        }
    }, tiempoAdvertencia);
    </script>
</head>
<body>
<div class="mensaje-flotante" id="mensajeNota">
    <span class="cerrar" onclick="this.parentElement.style.display='none';">&times;</span>
    <strong>Nota importante:</strong><br>
    Las notas deben ingresarse con punto decimal. Ejemplo: <strong>7.0</strong><br>
    No se permite ingresar notas como 70 o mayores a 7.0<br>
    Tiempo de inactividad 40 minutos, luego se cierra y no guardará nada.
</div>

<header>
    <img src="../images/INSIGNIA SF.png" alt="Escuela Porongo Insignia">
    <h1>Agregar Notas</h1>
    <nav>
        <ul>
            <li><a href="../index.php">Inicio</a></li>
            <li><a href="add_indicadores.php">Agregar Indicadores</a></li>
            <li><a href="gestion_notas.php">Ver Notas</a></li>
        </ul>
    </nav>
</header>

<main>
<?php if (!empty($message)): ?>
    <div class="mensaje <?php echo $message_type; ?> show">
        <?php echo $message; ?>
    </div>
<?php endif; ?>

<div class="filter-container">
    <form method="GET" action="add_grade.php">
        <label for="curso_id">Seleccionar Curso:</label>
        <select id="curso_id" name="curso_id" onchange="this.form.submit()">
            <option value="">Seleccione un curso</option>
            <?php while ($curso_row = $cursos->fetch_assoc()): ?>
                <option value="<?php echo $curso_row['id']; ?>" <?php if ($curso_id == $curso_row['id']) echo 'selected'; ?>>
                    <?php echo htmlspecialchars($curso_row['nombre'], ENT_QUOTES, 'UTF-8'); ?>
                </option>
            <?php endwhile; ?>
        </select>
    </form>
</div>

<?php if ($estudiantes && $estudiantes->num_rows > 0): ?>
<form method="POST" action="add_grade.php" onsubmit="return validarFormulario();">
   <input type="hidden" name="curso_id" value="<?php echo htmlspecialchars($curso_id, ENT_QUOTES, 'UTF-8'); ?>">
    <label for="asignatura_id">Seleccionar Asignatura:</label>
    <select id="asignatura_id" name="asignatura_id" required>
        <option value="">Seleccione una asignatura</option>
        <?php
        $asignaturas2 = $conn->query("SELECT id, nombre FROM asignatura ORDER BY nombre ASC");
        $nombre_curso = '';
        if ($curso_id) {
            $stmt = $conn->prepare("SELECT nombre FROM curso WHERE id = ?");
            $stmt->bind_param("i", $curso_id);
            $stmt->execute();
            $stmt->bind_result($nombre_curso);
            $stmt->fetch();
            $stmt->close();
        }
        $nombre_curso = strtolower($nombre_curso);
        $mostrar_lengua = in_array($nombre_curso, ['7° año a', '7° año b', '8° año a', '8° año b']);
        while ($asignatura = $asignaturas2->fetch_assoc()):
            $nombre_asignatura = strtolower(trim($asignatura['nombre']));
            if ($nombre_asignatura === 'orientación' || $nombre_asignatura === 'religión') continue;
            if ($mostrar_lengua) {
                if ($nombre_asignatura === 'lenguaje y comunicación') continue;
            } else {
                if ($nombre_asignatura === 'lengua y literatura') continue;
            }
        ?>
        <option value="<?php echo $asignatura['id']; ?>" <?php if ($asignatura_seleccionada == $asignatura['id']) echo 'selected'; ?>>
            <?php echo htmlspecialchars($asignatura['nombre'], ENT_QUOTES, 'UTF-8'); ?>
        </option>
        <?php endwhile; ?>
    </select>

    <label for="semestre">Seleccionar Semestre:</label>
    <select id="semestre" name="semestre" required>
        <option value="1" <?php if ($semestre_seleccionado == '1') echo 'selected'; ?>>Primer Semestre</option>
        <option value="2" <?php if ($semestre_seleccionado == '2') echo 'selected'; ?>>Segundo Semestre</option>
    </select>

    <button type="submit" name="mostrar_notas">Mostrar Notas Ingresadas</button>
    <button type="submit" name="guardar_multiples_notas">Guardar Notas</button>

    <table>
        <thead>
            <tr>
                <th>Estudiantes</th>
                <?php for ($i = 1; $i <= 10; $i++): ?>
                    <th>Nota <?php echo $i; ?></th>
                <?php endfor; ?>
                <th>Promedio</th>
            </tr>
        </thead>
        <tbody>
        <?php while ($estudiante = $estudiantes->fetch_assoc()): ?>
            <tr>
                <td><?php echo htmlspecialchars($estudiante['nombre_completo'], ENT_QUOTES, 'UTF-8'); ?></td>
                <?php
                $sumaNotas = 0;
                $cantidadNotas = 0;
                for ($i = 1; $i <= 10; $i++):
                    $notaValor = isset($notas_existentes[$estudiante['id']][$i]) ? $notas_existentes[$estudiante['id']][$i] : '';
                    if ($notaValor !== '') {
                        $sumaNotas += floatval($notaValor);
                        $cantidadNotas++;
                    }
                ?>
                    <td>
                        <input type="number" step="0.1" min="1.0" max="7.0" style="width: 65px; text-align: center;"
                            name="notas[<?php echo $estudiante['id']; ?>][nota_<?php echo $i; ?>]"
                            value="<?php echo htmlspecialchars(str_replace(',', '.', $notaValor), ENT_QUOTES, 'UTF-8'); ?>">
                    </td>
                <?php endfor; ?>
                <td><strong><?php echo $cantidadNotas > 0 ? number_format($sumaNotas / $cantidadNotas, 1, '.', '') : '-'; ?></strong></td>
            </tr>
        <?php endwhile; ?>
        </tbody>
    </table>
</form>
<?php else: ?>
    <p>No hay estudiantes asignados a este curso.</p>
<?php endif; ?>
</main>
</body>
</html>
