<?php
session_start();
include '../includes/db.php';
include '../includes/auth.php';
checkAuth();
$limiteInactividad = 30 * 60;
if (isset($_SESSION['ultimoAcceso'])) {
    $inactividad = time() - $_SESSION['ultimoAcceso'];
    if ($inactividad > $limiteInactividad) {
        session_unset();
        session_destroy();
        header("Location: login.php");
        exit();
    }
}
$_SESSION['ultimoAcceso'] = time();
$permisos_usuario = [];
$rol_id = $_SESSION['rol'] ?? null;
$usuario_id = $_SESSION['usuario_id'] ?? null;
$conn->set_charset("utf8");

$message = '';
$message_type = '';

$curso_id = $_GET['curso_id'] ?? null;
$asignatura_id = $_GET['asignatura_id'] ?? null;
$semestre = $_GET['semestre'] ?? null;

// Obtener rol estudiante
$rol_query = $conn->prepare("SELECT id FROM roles WHERE nombre = 'estudiante'");
$rol_query->execute();
$rol_query->bind_result($rol_estudiante_id);
$rol_query->fetch();
$rol_query->close();

// Obtener cursos y asignaturas
$cursos = $conn->query("SELECT id, nombre FROM curso ORDER BY nombre ASC");
$asignaturas = $conn->query("SELECT id, nombre FROM asignatura WHERE nombre IN ('Orientación', 'Religión') ORDER BY nombre ASC");

// Obtener indicadores
$indicadores = $conn->query("SELECT id, nombre FROM indicadores ORDER BY nombre ASC");

// Guardar indicadores
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['guardar_multiples_indicadores'])) {
    $curso_id = $_POST['curso_id'];
    $asignatura_id = $_POST['asignatura_id'];
    $semestre = $_POST['semestre'];

    foreach ($_POST['indicadores'] as $usuario_id => $indicadores) {
        // Eliminar indicadores anteriores para este estudiante/asignatura/semestre
        $delete_stmt = $conn->prepare("DELETE FROM notas_indicadores WHERE usuario_id = ? AND asignatura_id = ? AND semestre = ?");
        $delete_stmt->bind_param("iii", $usuario_id, $asignatura_id, $semestre);
        $delete_stmt->execute();
        $delete_stmt->close();

        $numero_nota = 1;

        for ($i = 1; $i <= 10; $i++) {
            if (!empty($indicadores["indicador_$i"])) {
                $indicador_id = $indicadores["indicador_$i"];

                $stmt = $conn->prepare("INSERT INTO notas_indicadores (usuario_id, asignatura_id, indicador_id, fecha, semestre, numero_nota)
                                        VALUES (?, ?, ?, NOW(), ?, ?)");
                $stmt->bind_param("iiiii", $usuario_id, $asignatura_id, $indicador_id, $semestre, $numero_nota);
                $stmt->execute();
                $stmt->close();

                $numero_nota++;
            }
        }
    }
// Obtener nombre del curso
$stmt = $conn->prepare("SELECT nombre FROM curso WHERE id = ?");
$stmt->bind_param("i", $curso_id);
$stmt->execute();
$stmt->bind_result($nombre_curso);
$stmt->fetch();
$stmt->close();

// Obtener nombre de la asignatura
$stmt = $conn->prepare("SELECT nombre FROM asignatura WHERE id = ?");
$stmt->bind_param("i", $asignatura_id);
$stmt->execute();
$stmt->bind_result($nombre_asignatura);
$stmt->fetch();
$stmt->close();

// Registrar actividad
$usuario_actual = $_SESSION['usuario'] ?? 'Desconocido';
$accion = "Guardó o modificó indicadores en el curso \"$nombre_curso\", asignatura \"$nombre_asignatura\", semestre $semestre";

$stmt = $conn->prepare("INSERT INTO registro_actividad (usuario, accion, curso_id, curso_nombre, fecha) VALUES (?, ?, ?, ?, NOW())");
$stmt->bind_param("ssis", $usuario_actual, $accion, $curso_id, $nombre_curso);
$stmt->execute();
$stmt->close();

    $message = 'Indicadores guardados correctamente.';
    $message_type = 'exito';
    header("Location: add_indicadores.php?curso_id=$curso_id&asignatura_id=$asignatura_id&semestre=$semestre&message=" . urlencode($message) . "&type=" . urlencode($message_type) . "&mostrar_indicadores=1");
    exit();
}

// Obtener estudiantes si se ha seleccionado curso
$estudiantes = [];
if ($curso_id !== null) {
    $stmt = $conn->prepare("SELECT id, CONCAT(apellido_paterno, ' ', apellido_materno, ' ', nombre) AS nombre_completo 
                            FROM usuario 
                            WHERE rol_id = ? AND curso_id = ? AND activo = 1
                            ORDER BY apellido_paterno, apellido_materno, nombre ASC");
    $stmt->bind_param("ii", $rol_estudiante_id, $curso_id);
    $stmt->execute();
    $result = $stmt->get_result();
    while ($fila = $result->fetch_assoc()) {
        $estudiantes[] = $fila;
    }
    $stmt->close();
}

// Obtener indicadores ya guardados
$indicadores_guardados = [];
if ($curso_id && $asignatura_id && $semestre) {
    $stmt = $conn->prepare("SELECT usuario_id, indicador_id, numero_nota FROM notas_indicadores 
                            WHERE asignatura_id = ? AND semestre = ? AND usuario_id IN (
                                SELECT id FROM usuario WHERE curso_id = ? AND rol_id = ? AND activo = 1
                            )");
    $stmt->bind_param("iiii", $asignatura_id, $semestre, $curso_id, $rol_estudiante_id);
    $stmt->execute();
    $result = $stmt->get_result();
    while ($row = $result->fetch_assoc()) {
        $usuario_id = $row['usuario_id'];
        $numero = $row['numero_nota'];
        $indicadores_guardados[$usuario_id]["indicador_$numero"] = $row['indicador_id'];
    }
    $stmt->close();
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Agregar Indicadores</title>
    <link rel="stylesheet" href="../css/agregar_indicadores.css">
</head>
    <body>
    <?php if (!empty($_GET['message']) && !empty($_GET['type'])): ?>
        <div class="toast-message <?php echo htmlspecialchars($_GET['type']); ?>">
            <?php echo htmlspecialchars($_GET['message']); ?>
        </div>
    <?php endif; ?>

    <div class="mensaje-flotante" id="mensajeNota">
    <span class="cerrar" onclick="this.parentElement.style.display='none';">&times;</span>
    <strong>Nota importante:</strong><br>
    Los indicadores deben seleccionarse. Ejemplo: <strong>MB</strong><br>
    No se permite escribir el indicador<br>
    Tiempo de inactividad 40 minutos, luego se cierra y no guardará nada.
</div>
<header>
    <img src="../images/INSIGNIA SF.png" alt="Escuela Porongo Insignia">
    <h1>Agregar Indicadores</h1>
    <nav>
        <ul>
            <li><a href="../index.php">Inicio</a></li>
            <li><a href="gestion_notas.php">Gestión de Notas</a></li>
            <li><a href="../logout.php">Cerrar Sesión</a></li>
        </ul>
    </nav>
</header>

<main>
    
    <form method="GET" action="add_indicadores.php">
        <label for="curso_id">Seleccionar Curso:</label>
        <select name="curso_id" id="curso_id" required>
            <option value="">Seleccione un curso</option>
            <?php $cursos->data_seek(0); while ($curso = $cursos->fetch_assoc()): ?>
                <option value="<?php echo $curso['id']; ?>" <?php echo ($curso_id == $curso['id']) ? 'selected' : ''; ?>>
                    <?php echo htmlspecialchars($curso['nombre']); ?>
                </option>
            <?php endwhile; ?>
        </select>

        <label for="asignatura_id">Seleccionar Asignatura:</label>
        <select name="asignatura_id" id="asignatura_id" required>
            <option value="">Seleccione una asignatura</option>
            <?php $asignaturas->data_seek(0); while ($asignatura = $asignaturas->fetch_assoc()): ?>
                <option value="<?php echo $asignatura['id']; ?>" <?php echo ($asignatura_id == $asignatura['id']) ? 'selected' : ''; ?>>
                    <?php echo htmlspecialchars($asignatura['nombre']); ?>
                </option>
            <?php endwhile; ?>
        </select>

        <label for="semestre">Seleccionar Semestre:</label>
        <select name="semestre" id="semestre" required>
            <option value="1" <?php echo ($semestre == '1') ? 'selected' : ''; ?>>Primer Semestre</option>
            <option value="2" <?php echo ($semestre == '2') ? 'selected' : ''; ?>>Segundo Semestre</option>
        </select>

        <button type="submit" name="mostrar_indicadores">Mostrar Indicadores Ingresados</button>
    </form>

    <?php if (isset($_GET['mostrar_indicadores'])): ?>
        <form method="POST" action="add_indicadores.php">
            <input type="hidden" name="curso_id" value="<?php echo htmlspecialchars($curso_id); ?>">
            <input type="hidden" name="asignatura_id" value="<?php echo htmlspecialchars($asignatura_id); ?>">
            <input type="hidden" name="semestre" value="<?php echo htmlspecialchars($semestre); ?>">

            <table>
                <thead>
                    <tr>
                        <th>Estudiantes</th>
                        <?php for ($i = 1; $i <= 10; $i++): ?>
                            <th>Indicador <?php echo $i; ?></th>
                        <?php endfor; ?>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($estudiantes as $estudiante): ?>
                        <tr>
                            <td><?php echo htmlspecialchars($estudiante['nombre_completo']); ?></td>
                            <?php for ($i = 1; $i <= 10; $i++): ?>
                                <?php
                                $indicadores->data_seek(0);
                                $sel = $indicadores_guardados[$estudiante['id']]["indicador_$i"] ?? '';
                                ?>
                                <td>
                                    <select name="indicadores[<?php echo $estudiante['id']; ?>][indicador_<?php echo $i; ?>]">
                                        <option value="">Seleccione indicador</option>
                                        <?php while ($indicador = $indicadores->fetch_assoc()): ?>
                                            <option value="<?php echo $indicador['id']; ?>" <?php echo ($sel == $indicador['id']) ? 'selected' : ''; ?>>
                                                <?php echo htmlspecialchars($indicador['nombre']); ?>
                                            </option>
                                        <?php endwhile; ?>
                                    </select>
                                </td>
                            <?php endfor; ?>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
            <button type="submit" name="guardar_multiples_indicadores">Guardar Indicadores</button>
        </form>
    <?php endif; ?>
</main>
</body>
    <script>
    document.addEventListener('DOMContentLoaded', function () {
        const toast = document.querySelector('.toast-message');
        if (toast) {
            setTimeout(() => {
                toast.style.opacity = '0';
                setTimeout(() => toast.remove(), 500);
            }, 4000); // Desaparece en 4 segundos
        }
    });
</script>

</html>
