<?php
include '../includes/db.php'; // Incluir conexión a la base de datos
include '../includes/auth.php'; // Verificar autenticación
checkAuth(); // Verificar si el usuario está autenticado

$conn->set_charset("utf8");
function registrarAccion($usuario, $accion, $curso_id, $curso_nombre, $ip_usuario) {
    global $conn;
    $stmt = $conn->prepare("INSERT INTO registro_actividad (usuario, curso_id, curso_nombre, accion, fecha, ip_usuario) VALUES (?, ?, ?, ?, NOW(), ?)");
    $stmt->bind_param("sisss", $usuario, $curso_id, $curso_nombre, $accion, $ip_usuario);
    $stmt->execute();
    $stmt->close();
}
$usuario_log = $_SESSION['nombre'] ?? 'Desconocido';
$ip_usuario = $_SERVER['REMOTE_ADDR'] ?? 'Desconocida';

$message = '';
$message_type = '';

// Obtener nombre curso si se envía curso_id
$nombre_curso = '';
if (isset($_POST['curso_id']) || isset($_GET['curso_id'])) {
    $curso_id = isset($_POST['curso_id']) ? intval($_POST['curso_id']) : intval($_GET['curso_id']);
    $stmt_curso = $conn->prepare("SELECT nombre FROM curso WHERE id = ?");
    $stmt_curso->bind_param("i", $curso_id);
    $stmt_curso->execute();
    $res_curso = $stmt_curso->get_result();
    $row_curso = $res_curso->fetch_assoc();
    $nombre_curso = $row_curso['nombre'] ?? '';
    $stmt_curso->close();
}
// Función para calcular el promedio
function calcular_promedio($notas) {
    if (count($notas) === 0) {
        return 0; // Evitar división por cero
    }
    return number_format(array_sum($notas) / count($notas), 1);
}

// Función para eliminar una nota individual
if (isset($_POST['eliminar_nota'])) {
    $nota_id = intval($_POST['nota_id']);
    // Obtener nombre asignatura
    $stmt_asig = $conn->prepare("SELECT asignatura.nombre FROM notas JOIN asignatura ON notas.asignatura_id = asignatura.id WHERE notas.id = ?");
    $stmt_asig->bind_param("i", $nota_id);
    $stmt_asig->execute();
    $stmt_asig->bind_result($nombre_asignatura);
    $stmt_asig->fetch();
    $stmt_asig->close();
    $stmt = $conn->prepare("DELETE FROM notas WHERE id = ?");
    $stmt->bind_param("i", $nota_id);
    $stmt->execute();
    $stmt->close();
     // Obtener nombre usuario desde sesión
    $usuario_log = $_SESSION['usuario'] ?? 'Usuario no identificado';
     $accion = "Eliminó nota con ID $nota_id en asignatura \"$nombre_asignatura\" del curso \"$nombre_curso\"";
    registrarAccion($usuario_log, $accion, $curso_id, $nombre_curso, $ip_usuario);
    header("Location: gestion_notas.php?alumno_id={$_POST['alumno_id']}&curso_id={$_POST['curso_id']}");
    exit();
}

// Eliminar múltiples notas
if (isset($_POST['eliminar_multiples_notas'])) {
    $notas_a_eliminar = $_POST['notas_a_eliminar'] ?? [];

    if (!empty($notas_a_eliminar)) {
        $ids = implode(',', array_map('intval', $notas_a_eliminar));

        // Obtener asignaturas involucradas
        $query_asig = "SELECT asignatura.nombre FROM notas JOIN asignatura ON notas.asignatura_id = asignatura.id WHERE notas.id IN ($ids)";
        $result_asig = $conn->query($query_asig);
        $asignaturas_eliminadas = [];
        while ($row = $result_asig->fetch_assoc()) {
            $asignaturas_eliminadas[] = $row['nombre'];
        }
        $lista_asignaturas = implode(', ', array_unique($asignaturas_eliminadas));

        $query = "DELETE FROM notas WHERE id IN ($ids)";
        if ($conn->query($query)) {
             // Obtener nombre usuario desde sesión
    $usuario_log = $_SESSION['usuario'] ?? 'Usuario no identificado';
            $accion = "Eliminó múltiples notas con IDs [$ids] en asignaturas [$lista_asignaturas] del curso \"$nombre_curso\"";
            registrarAccion($usuario_log, $accion, $curso_id, $nombre_curso, $ip_usuario);

            header("Location: gestion_notas.php?alumno_id={$_POST['alumno_id']}&curso_id={$_POST['curso_id']}");
            exit();
        } else {
            echo "Error al eliminar las notas: " . $conn->error;
        }
    }
}

// Función para actualizar una nota
if (isset($_POST['editar_nota'])) {
    $nota_id = intval($_POST['nota_id']);
    $nueva_nota = floatval($_POST['nueva_nota']);
    // Obtener nombre asignatura
    $stmt_asig = $conn->prepare("SELECT asignatura.nombre FROM notas JOIN asignatura ON notas.asignatura_id = asignatura.id WHERE notas.id = ?");
    $stmt_asig->bind_param("i", $nota_id);
    $stmt_asig->execute();
    $stmt_asig->bind_result($nombre_asignatura);
    $stmt_asig->fetch();
    $stmt_asig->close();
    $stmt = $conn->prepare("UPDATE notas SET nota = ? WHERE id = ?");
    $stmt->bind_param("di", $nueva_nota, $nota_id);
    $stmt->execute();
    $stmt->close();
     // Obtener nombre usuario desde sesión
    $usuario_log = $_SESSION['usuario'] ?? 'Usuario no identificado';
     $accion = "Editó nota con ID $nota_id a valor $nueva_nota en asignatura \"$nombre_asignatura\" del curso \"$nombre_curso\"";
    registrarAccion($usuario_log, $accion, $curso_id, $nombre_curso, $ip_usuario);
    header("Location: gestion_notas.php?alumno_id={$_POST['alumno_id']}&curso_id={$_POST['curso_id']}");
    exit();
}

// Variables iniciales
$curso_seleccionado = false;
$alumno_seleccionado = false;
$curso_id = null;
$alumno_id = null;

// Verificar si se ha seleccionado un curso
if (isset($_POST['curso_id'])) {
    $curso_id = intval($_POST['curso_id']);
    $curso_seleccionado = true;
}

// Verificar si se ha seleccionado un alumno para ver las notas
if (isset($_GET['alumno_id']) && isset($_GET['curso_id'])) {
    $alumno_id = intval($_GET['alumno_id']);
    $curso_id = intval($_GET['curso_id']);
    $alumno_seleccionado = true;
}

// Verificar si se ha seleccionado un curso
if (isset($_POST['curso_id'])) {
    $curso_id = intval($_POST['curso_id']);
    $curso_seleccionado = true;

    // Obtener el nombre del curso
    $stmt = $conn->prepare("SELECT nombre FROM curso WHERE id = ?");
    $stmt->bind_param("i", $curso_id);
    $stmt->execute();
    $curso = $stmt->get_result()->fetch_assoc();
    $nombre_curso = $curso['nombre'];
    $stmt->close();
}

?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="../css/gestion_notas.css">
    <title>Gestión de Notas</title>
    <style>
        
    </style>
</head>
<body>
    <header>
        <img src="../images/INSIGNIA SF.png" alt="Insignia del Colegio">
        <h1>Gestión de Notas</h1>
    
        <nav>
        <ul>
            <li><a href="../index.php">Inicio</a></li>
            <li><a href="gestion_notas_indicadores.php">Gestionar Indicadores</a></li>
        </ul>
    </nav>
        </header>
    <div class="container">
        <!-- Seleccionar curso -->
        <h2>Seleccionar Curso:</h2>
        <form method="POST" action="gestion_notas.php">
            <select name="curso_id" required>
                <?php
                // Obtener los cursos
                $query_cursos = "SELECT id, nombre FROM curso ORDER BY nombre";
                $result_cursos = $conn->query($query_cursos);

                while ($curso = $result_cursos->fetch_assoc()) {
                    echo "<option value='{$curso['id']}'>{$curso['nombre']}</option>";
                }
                ?>
            </select>
            <button type="submit">Ver Alumnos</button>
        </form>

        <!-- Mostrar alumnos si se ha seleccionado un curso -->
        <?php if ($curso_seleccionado): ?>
            <h2>Alumnos del Curso: <?php echo htmlspecialchars($nombre_curso); ?></h2>

            <?php
            // Excluir a los usuarios con el rol de profesor
            $query = "SELECT u.id, u.nombre, u.apellido_paterno, u.apellido_materno 
                      FROM usuario u 
                      JOIN roles r ON u.rol_id = r.id 
                      WHERE u.curso_id = ? AND r.nombre != 'Docente' 
                      ORDER BY u.apellido_paterno, u.apellido_materno, u.nombre";
            $stmt = $conn->prepare($query);
            $stmt->bind_param("i", $curso_id);
            $stmt->execute();
            $alumnos = $stmt->get_result();

            if ($alumnos->num_rows > 0): ?>
                <table border="1">
                    <tr>
                        <th>Nombre del Alumno</th>
                        <th>Acciones</th>
                    </tr>
                    <?php while ($alumno = $alumnos->fetch_assoc()): ?>
                        <tr>
                            <td><?php echo htmlspecialchars($alumno['nombre'] . ' ' . $alumno['apellido_paterno'] . ' ' . $alumno['apellido_materno']); ?></td>
                            <td>
                                <a href="gestion_notas.php?alumno_id=<?php echo $alumno['id']; ?>&curso_id=<?php echo $curso_id; ?>">Ver Notas</a>
                            </td>
                        </tr>
                    <?php endwhile; ?>
                </table>
            <?php else: ?>
                <p>No se encontraron alumnos para este curso.</p>
            <?php endif;

            $stmt->close();
            ?>
        <?php endif; ?>

        <!-- Mostrar notas del alumno si se ha seleccionado un alumno -->
        <?php if ($alumno_seleccionado): ?>
            <?php
            // Obtener información del alumno
            $stmt = $conn->prepare("SELECT usuario.rut, CONCAT(usuario.nombre, ' ', usuario.apellido_paterno, ' ', usuario.apellido_materno) AS nombre_completo, curso.nombre as curso 
                                    FROM usuario 
                                    JOIN curso ON usuario.curso_id = curso.id 
                                    WHERE usuario.id = ?");
            $stmt->bind_param('i', $alumno_id);
            $stmt->execute();
            $alumno = $stmt->get_result()->fetch_assoc();
            $stmt->close();

            // Obtener las notas del alumno
            $query_notas = "SELECT notas.id AS nota_id, asignatura.nombre AS asignatura, notas.nota, notas.numero_nota, notas.semestre 
                            FROM notas 
                            JOIN asignatura ON notas.asignatura_id = asignatura.id 
                            WHERE notas.usuario_id = ?
                            ORDER BY asignatura.nombre, notas.numero_nota";
            $stmt = $conn->prepare($query_notas);
            $stmt->bind_param("i", $alumno_id);
            $stmt->execute();
            $notas = $stmt->get_result();
            ?>

            <h2>Notas del Alumno: <?php echo htmlspecialchars($alumno['nombre_completo']); ?> (Curso: <?php echo htmlspecialchars($alumno['curso']); ?>)</h2>

            <?php if ($notas->num_rows > 0): ?>
                <form method="POST" action="gestion_notas.php" id="deleteMultipleForm">
                    <input type="hidden" name="alumno_id" value="<?php echo $alumno_id; ?>">
                    <input type="hidden" name="curso_id" value="<?php echo $curso_id; ?>">
                    <table>
                        <thead>
                            <tr>
                                <th>Seleccionar</th>
                                <th>Asignaturas</th>
                                <th>Nota</th>
                                <th>Semestre</th>
                                <th>Número de Nota</th>
                                <th>Acciones</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php while ($nota = $notas->fetch_assoc()): ?>
                                <tr>
                                    <td>
                                        <input type="checkbox" name="notas_a_eliminar[]" value="<?php echo $nota['nota_id']; ?>">
                                    </td>
                                    <td><?php echo htmlspecialchars($nota['asignatura']); ?></td>
                                    <td><?php echo htmlspecialchars($nota['nota']); ?></td>
                                    <td><?php echo htmlspecialchars($nota['semestre']); ?></td>
                                    <td><?php echo htmlspecialchars($nota['numero_nota']); ?></td>
                                    <td>
                                        <button type="button" onclick="openModalEdit(<?php echo $nota['nota_id']; ?>, <?php echo htmlspecialchars($nota['nota']); ?>)">Editar</button>
                                        <button type="button" onclick="openModalDelete(<?php echo $nota['nota_id']; ?>)">Eliminar</button>
                                    </td>
                                </tr>
                            <?php endwhile; ?>
                        </tbody>
                    </table>
                    <button type="submit" name="eliminar_multiples_notas" style="display: none;">Eliminar Seleccionados</button> <!-- Botón para eliminar múltiples notas -->
                </form>
            <?php else: ?>
                <p>Este alumno no tiene notas registradas.</p>
            <?php endif; ?>

            <?php $stmt->close(); ?>
        <?php endif; ?>

        <!-- Modal para editar nota -->
        <div id="editModal" class="modal">
            <div class="modal-content">
                <span class="close">&times;</span>
                <form method="POST" action="gestion_notas.php">
                    <input type="hidden" name="nota_id" id="nota_id">
                    <input type="hidden" name="alumno_id" value="<?php echo $alumno_id; ?>">
                    <input type="hidden" name="curso_id" value="<?php echo $curso_id; ?>">
                    <label for="nueva_nota">Nueva Nota:</label>
                    <input type="number" step="0.01" name="nueva_nota" id="nueva_nota" required>
                    <button type="submit" name="editar_nota">Actualizar Nota</button>
                </form>
            </div>
        </div>

        <!-- Modal para eliminar nota -->
        <div id="deleteModal" class="modal">
            <div class="modal-content">
                <span class="close">&times;</span>
                <form method="POST" action="gestion_notas.php">
                    <input type="hidden" name="nota_id" id="delete_nota_id">
                    <input type="hidden" name="alumno_id" value="<?php echo $alumno_id; ?>">
                    <input type="hidden" name="curso_id" value="<?php echo $curso_id; ?>">
                    <p>¿Estás seguro de que deseas eliminar esta nota?</p>
                    <button type="submit" name="eliminar_nota">Eliminar Nota</button>
                </form>
            </div>
        </div>
    </div>

    <script>
        // Modal JavaScript para editar nota
        var editModal = document.getElementById("editModal");
        var deleteModal = document.getElementById("deleteModal");
        var editClose = document.getElementsByClassName("close")[0];
        var deleteClose = document.getElementsByClassName("close")[1];

        function openModalEdit(nota_id, nota_actual) {
            document.getElementById("nota_id").value = nota_id;
            document.getElementById("nueva_nota").value = nota_actual;
            editModal.style.display = "block";
        }

        function openModalDelete(nota_id) {
            document.getElementById("delete_nota_id").value = nota_id;
            deleteModal.style.display = "block";
        }

        editClose.onclick = function() {
            editModal.style.display = "none";
        }

        deleteClose.onclick = function() {
            deleteModal.style.display = "none";
        }

        window.onclick = function(event) {
            if (event.target == editModal) {
                editModal.style.display = "none";
            }
            if (event.target == deleteModal) {
                deleteModal.style.display = "none";
            }
        }

        // Mostrar el botón de eliminar múltiple solo si hay notas seleccionadas
        const checkboxes = document.querySelectorAll('input[name="notas_a_eliminar[]"]');
        const deleteButton = document.querySelector('button[name="eliminar_multiples_notas"]');

        checkboxes.forEach(checkbox => {
            checkbox.addEventListener('change', () => {
                const anyChecked = Array.from(checkboxes).some(checkbox => checkbox.checked);
                deleteButton.style.display = anyChecked ? 'inline-block' : 'none';
            });
        });
    </script>
</body>
</html>

<?php
$conn->close();
?>
