<?php
include '../includes/db.php';
include '../includes/auth.php';
checkAuth();
$conn->set_charset("utf8");
// Función para registrar actividad mejorada: recibe nombre de curso y detalle extra (ej: indicador)
function registrarActividad($conn, $usuario, $accion, $curso_id, $curso_nombre, $detalle = '', $ip_usuario = '') {
    $accion_completa = $accion;
    if ($detalle !== '') {
        $accion_completa .= ": " . $detalle;
    }
    $stmt = $conn->prepare("INSERT INTO registro_actividad (usuario, accion, curso_id, curso_nombre, fecha, ip_usuario) VALUES (?, ?, ?, ?, NOW(), ?)");
    $stmt->bind_param("ssiss", $usuario, $accion_completa, $curso_id, $curso_nombre, $ip_usuario);
    $stmt->execute();
    $stmt->close();
}
// Obtener usuario e IP
$usuario = $_SESSION['usuario'] ?? 'Desconocido';
$ip_usuario = $_SERVER['REMOTE_ADDR'] ?? 'Desconocida';

// Obtener nombre curso si curso_id está definido (para registrar en actividad)
$nombre_curso = '';
if (isset($_POST['curso_id'])) {
    $curso_id = intval($_POST['curso_id']);
} elseif (isset($_GET['curso_id'])) {
    $curso_id = intval($_GET['curso_id']);
} else {
    $curso_id = null;
}

if ($curso_id !== null) {
    $stmt_curso = $conn->prepare("SELECT nombre FROM curso WHERE id = ?");
    $stmt_curso->bind_param("i", $curso_id);
    $stmt_curso->execute();
    $stmt_curso->bind_result($nombre_curso);
    $stmt_curso->fetch();
    $stmt_curso->close();
}
// Eliminar un solo indicador
if (isset($_POST['eliminar_indicador'])) {
    $indicador_id = intval($_POST['indicador_id']);
    // Obtener info del indicador y asignatura para el registro
    $stmt_info = $conn->prepare("SELECT i.nombre AS indicador_nombre, a.nombre AS asignatura_nombre FROM notas_indicadores ni JOIN indicadores i ON ni.indicador_id = i.id JOIN asignatura a ON ni.asignatura_id = a.id WHERE ni.id = ?");
    $stmt_info->bind_param("i", $indicador_id);
    $stmt_info->execute();
    $stmt_info->bind_result($indicador_nombre, $asignatura_nombre);
    $stmt_info->fetch();
    $stmt_info->close();
    $stmt = $conn->prepare("DELETE FROM notas_indicadores WHERE id = ?");
    $stmt->bind_param("i", $indicador_id);
    $stmt->execute();
    $stmt->close();
    // Registrar actividad con detalle
    $detalle = "Indicador \"$indicador_nombre\" (Asignatura: \"$asignatura_nombre\") eliminado";
    registrarActividad($conn, $usuario, "Eliminó un indicador individual", $curso_id, $nombre_curso, $detalle, $ip_usuario);
    header("Location: gestion_notas_indicadores.php?alumno_id={$_POST['alumno_id']}&curso_id={$_POST['curso_id']}");
    exit();
}

// Eliminar múltiples indicadores
if (isset($_POST['eliminar_multiples_indicadores']) && !empty($_POST['indicadores_a_eliminar'])) {
    $indicadores = array_map('intval', $_POST['indicadores_a_eliminar']);
    $placeholders = implode(',', array_fill(0, count($indicadores), '?'));
    $types = str_repeat('i', count($indicadores));
    // Obtener los nombres de indicadores y asignaturas para registro
    $stmt_info = $conn->prepare("SELECT i.nombre AS indicador_nombre, a.nombre AS asignatura_nombre FROM notas_indicadores ni JOIN indicadores i ON ni.indicador_id = i.id JOIN asignatura a ON ni.asignatura_id = a.id WHERE ni.id IN ($placeholders)");

    // Necesitamos pasar los parámetros dinámicos
    $stmt_info->bind_param($types, ...$indicadores);
    $stmt_info->execute();
    $result_info = $stmt_info->get_result();
    $detalles = [];
    while ($row = $result_info->fetch_assoc()) {
        $detalles[] = $row['indicador_nombre'] . " (Asignatura: " . $row['asignatura_nombre'] . ")";
    }
    $stmt_info->close();
    $stmt = $conn->prepare("DELETE FROM notas_indicadores WHERE id IN ($placeholders)");
    $stmt->bind_param($types, ...$indicadores);
    $stmt->execute();
    $stmt->close();
    // Registrar actividad con todos los detalles
    $detalle = "Indicadores eliminados: " . implode(", ", $detalles);
    registrarActividad($conn, $usuario, "Eliminó múltiples indicadores", $curso_id, $nombre_curso, $detalle, $ip_usuario);
    header("Location: gestion_notas_indicadores.php?alumno_id={$_POST['alumno_id']}&curso_id={$_POST['curso_id']}");
    exit();
}

// Editar indicador
if (isset($_POST['editar_indicador'])) {
    $indicador_id = intval($_POST['indicador_id']);
    $nuevo_indicador_id = intval($_POST['nuevo_indicador_id']);
    $nueva_nota = intval($_POST['numero_nota']);
// Obtener nombre indicador viejo y nuevo y asignatura
    $stmt_info = $conn->prepare("SELECT i.nombre AS indicador_actual, a.nombre AS asignatura_nombre FROM notas_indicadores ni JOIN indicadores i ON ni.indicador_id = i.id JOIN asignatura a ON ni.asignatura_id = a.id WHERE ni.id = ?");
    $stmt_info->bind_param("i", $indicador_id);
    $stmt_info->execute();
    $stmt_info->bind_result($indicador_actual, $asignatura_nombre);
    $stmt_info->fetch();
    $stmt_info->close();

    $stmt_nuevo = $conn->prepare("SELECT nombre FROM indicadores WHERE id = ?");
    $stmt_nuevo->bind_param("i", $nuevo_indicador_id);
    $stmt_nuevo->execute();
    $stmt_nuevo->bind_result($nuevo_indicador_nombre);
    $stmt_nuevo->fetch();
    $stmt_nuevo->close();
    $stmt = $conn->prepare("UPDATE notas_indicadores SET indicador_id = ?, numero_nota = ? WHERE id = ?");
    $stmt->bind_param("iii", $nuevo_indicador_id, $nueva_nota, $indicador_id);
    if ($stmt->execute() && $stmt->affected_rows > 0) {
        // Registrar actividad con detalle
        $detalle = "Indicador editado de \"$indicador_actual\" a \"$nuevo_indicador_nombre\" con nota $nueva_nota (Asignatura: \"$asignatura_nombre\")";
        registrarActividad($conn, $usuario, "Editó un indicador", $curso_id, $nombre_curso, $detalle, $ip_usuario);
        header("Location: gestion_notas_indicadores.php?alumno_id={$_POST['alumno_id']}&curso_id={$_POST['curso_id']}");
        exit();
    }
}

// Inicializar variables
$curso_seleccionado = false;
$alumno_seleccionado = false;
$curso_id = null;
$alumno_id = null;

// Verificar curso
if (isset($_POST['curso_id'])) {
    $curso_id = intval($_POST['curso_id']);
    $curso_seleccionado = true;
    $stmt = $conn->prepare("SELECT nombre FROM curso WHERE id = ?");
    $stmt->bind_param("i", $curso_id);
    $stmt->execute();
    $curso = $stmt->get_result()->fetch_assoc();
    $nombre_curso = $curso['nombre'];
    $stmt->close();
}

// Verificar alumno
if (isset($_GET['alumno_id']) && isset($_GET['curso_id'])) {
    $alumno_id = intval($_GET['alumno_id']);
    $curso_id = intval($_GET['curso_id']);
    $alumno_seleccionado = true;
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <link rel="stylesheet" href="../css/gestion_indicadores.css">
    <title>Gestión de Notas por Indicadores</title>
</head>
<body>
    <header>
        <img src="../images/INSIGNIA SF.png" alt="Escuela Porongo Insignia">
        <h1>Gestión de Notas por Indicadores</h1>
        <nav>
            <ul>
                <li><a href="../index.php">Inicio</a></li>
                <li><a href="gestion_notas.php">Gestionar Notas</a></li>
            </ul>
        </nav>
    </header>
    <div class="container">
        <h2>Seleccionar Curso:</h2>
        <form method="POST" action="gestion_notas_indicadores.php">
            <select name="curso_id" required>
                <?php
                $result_cursos = $conn->query("SELECT id, nombre FROM curso ORDER BY nombre");
                while ($curso = $result_cursos->fetch_assoc()) {
                    echo "<option value='{$curso['id']}'>{$curso['nombre']}</option>";
                }
                ?>
            </select>
            <button type="submit">Ver Alumnos</button>
        </form>

        <?php if ($curso_seleccionado): ?>
            <h2>Alumnos del Curso: <?php echo htmlspecialchars($nombre_curso); ?></h2>
            <?php
            $stmt = $conn->prepare("SELECT u.id, u.nombre, u.apellido_paterno, u.apellido_materno 
                FROM usuario u 
                JOIN roles r ON u.rol_id = r.id 
                WHERE u.curso_id = ? AND r.nombre != 'Docente' 
                ORDER BY u.apellido_paterno, u.apellido_materno, u.nombre");
            $stmt->bind_param("i", $curso_id);
            $stmt->execute();
            $alumnos = $stmt->get_result();
            ?>
            <table border="1">
                <tr>
                    <th>Nombre del Alumno</th>
                    <th>Acciones</th>
                </tr>
                <?php while ($alumno = $alumnos->fetch_assoc()): ?>
                    <tr>
                        <td><?php echo htmlspecialchars("{$alumno['nombre']} {$alumno['apellido_paterno']} {$alumno['apellido_materno']}"); ?></td>
                        <td><a href="?alumno_id=<?php echo $alumno['id']; ?>&curso_id=<?php echo $curso_id; ?>">Ver Indicadores</a></td>
                    </tr>
                <?php endwhile; ?>
            </table>
        <?php endif; ?>

        <?php if ($alumno_seleccionado): ?>
            <?php
            $stmt = $conn->prepare("SELECT CONCAT(usuario.nombre, ' ', usuario.apellido_paterno, ' ', usuario.apellido_materno) AS nombre_completo, curso.nombre AS curso 
                                    FROM usuario 
                                    JOIN curso ON usuario.curso_id = curso.id 
                                    WHERE usuario.id = ?");

            $stmt->bind_param("i", $alumno_id);
            $stmt->execute();
            $info_alumno = $stmt->get_result()->fetch_assoc();
            ?>

            <h2>Notas de <?php echo htmlspecialchars($info_alumno['nombre_completo']); ?> (Curso: <?php echo htmlspecialchars($info_alumno['curso']); ?>)</h2>

            <form method="POST" onsubmit="return confirm('¿Eliminar los indicadores seleccionados?');">
                <input type="hidden" name="alumno_id" value="<?php echo $alumno_id; ?>">
                <input type="hidden" name="curso_id" value="<?php echo $curso_id; ?>">

                <table>
                    <thead>
                        <tr>
                            <th><input type="checkbox" onclick="toggleSeleccionMasiva(this)"></th>
                            <th>Asignaturas</th>
                            <th>Indicador</th>
                            <th>Semestre</th>
                            <th>Número de Nota</th>
                            <th>Acciones</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        $query_notas = "SELECT ni.id, a.nombre AS asignatura, i.nombre AS indicador, ni.numero_nota, ni.semestre 
                            FROM notas_indicadores ni 
                            JOIN asignatura a ON ni.asignatura_id = a.id 
                            JOIN indicadores i ON ni.indicador_id = i.id  
                            WHERE ni.usuario_id = ? AND (ni.asignatura_id = 9 OR ni.asignatura_id = 10) 
                            ORDER BY a.nombre, ni.numero_nota";
                        $stmt = $conn->prepare($query_notas);
                        $stmt->bind_param("i", $alumno_id);
                        $stmt->execute();
                        $result_notas = $stmt->get_result();

                        if ($result_notas->num_rows > 0):
                            while ($nota = $result_notas->fetch_assoc()):
                        ?>
                            <tr>
                                <td><input type="checkbox" name="indicadores_a_eliminar[]" value="<?php echo $nota['id']; ?>"></td>
                                <td><?php echo htmlspecialchars($nota['asignatura']); ?></td>
                                <td><?php echo htmlspecialchars($nota['indicador']); ?></td>
                                <td><?php echo htmlspecialchars($nota['semestre']); ?></td>
                                <td><?php echo htmlspecialchars($nota['numero_nota']); ?></td>
                                <td>
                                    <button type="button" onclick="openEditModal(<?php echo $nota['id']; ?>, '<?php echo addslashes($nota['indicador']); ?>', '<?php echo $nota['numero_nota']; ?>')">Editar</button>
                                    <form method="POST" style="display:inline;">
                                        <input type="hidden" name="indicador_id" value="<?php echo $nota['id']; ?>">
                                        <input type="hidden" name="alumno_id" value="<?php echo $alumno_id; ?>">
                                        <input type="hidden" name="curso_id" value="<?php echo $curso_id; ?>">
                                        <button type="submit" name="eliminar_indicador" onclick="return confirm('¿Eliminar esta nota?');">Eliminar</button>
                                    </form>
                                </td>
                            </tr>
                        <?php endwhile; ?>
                        <?php else: ?>
                            <tr><td colspan="6">No hay notas disponibles.</td></tr>
                        <?php endif; ?>
                    </tbody>
                </table>
                <button type="submit" name="eliminar_multiples_indicadores" style="margin-top: 10px;">Eliminar Seleccionados</button>
            </form>
        <?php endif; ?>

        <!-- Modal -->
        <div id="editModal" style="display:none;">
            <form method="POST">
                <h2>Editar Nota</h2>
                <input type="hidden" name="indicador_id" id="modal_indicador_id">
                <input type="hidden" name="alumno_id" value="<?php echo $alumno_id; ?>">
                <input type="hidden" name="curso_id" value="<?php echo $curso_id; ?>">
                <label for="nuevo_indicador">Indicador:</label>
                <select name="nuevo_indicador_id" id="nuevo_indicador" required>
                    <?php
                    $result_indicadores = $conn->query("SELECT id, nombre FROM indicadores");
                    while ($ind = $result_indicadores->fetch_assoc()) {
                        echo "<option value='{$ind['id']}'>{$ind['nombre']}</option>";
                    }
                    ?>
                </select>
                <label for="numero_nota">Nota:</label>
                <input type="number" name="numero_nota" id="numero_nota" required>
                <button type="submit" name="editar_indicador">Actualizar</button>
                <button type="button" onclick="closeEditModal()">Cancelar</button>
            </form>
        </div>

        <script>
        function openEditModal(id, indicador, numero) {
            document.getElementById('modal_indicador_id').value = id;
            document.getElementById('numero_nota').value = numero;
            document.getElementById('editModal').style.display = 'block';
        }
        function closeEditModal() {
            document.getElementById('editModal').style.display = 'none';
        }
        function toggleSeleccionMasiva(source) {
            const checkboxes = document.querySelectorAll('input[name="indicadores_a_eliminar[]"]');
            checkboxes.forEach(cb => cb.checked = source.checked);
        }
        </script>
    </div>
</body>
</html>
