<?php
header('Content-Type: text/html; charset=utf-8');

include '../includes/db.php'; // Conexión a la base de datos
include '../includes/auth.php'; // Funciones de autenticación
checkAuth(); // Verificar si el usuario está autenticado

// Establecer la codificación de caracteres para la conexión de la base de datos
$conn->set_charset("utf8");

// Obtener el ID del usuario que ha iniciado sesión
$usuario_id = $_SESSION['usuario_id'];

// Obtener el semestre seleccionado por el usuario
$semestre = isset($_POST['semestre']) ? intval($_POST['semestre']) : 1;

// Obtener las notas del estudiante para el semestre seleccionado
try {
    // Asegurarse de que la consulta recupere todas las asignaturas, incluidas Religión y Orientación
    $sql = "SELECT asignatura.nombre AS asignatura, notas.nota, notas.semestre, notas.numero_nota 
            FROM notas 
            JOIN asignatura ON notas.asignatura_id = asignatura.id 
            WHERE notas.usuario_id = ? AND notas.semestre = ? 
            ORDER BY asignatura.nombre, notas.numero_nota ASC";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("ii", $usuario_id, $semestre);
    $stmt->execute();
    $notas = $stmt->get_result()->fetch_all(MYSQLI_ASSOC); // Obtener todas las notas
    $stmt->close();
} catch (Exception $e) {
    $error_message = $e->getMessage();
}

// Organizar las notas por asignatura
$notas_por_asignatura = [];
foreach ($notas as $nota) {
    $notas_por_asignatura[$nota['asignatura']][$nota['numero_nota']] = $nota['nota'];
}

// Calcular promedios
function calcular_promedio($notas) {
    return number_format(array_sum($notas) / count($notas), 1);
}

$promedios_asignaturas = []; // Array para almacenar los promedios por asignatura
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Mis Notas</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Poppins', sans-serif;
            margin: 0;
            padding: 0;
            background-color: #f0f2f5;
            display: flex;
            flex-direction: column;
            align-items: center;
            color: #333;
        }

        header {
            width: 100%;
            background-color: #3f51b5;
            color: white;
            padding: 20px 0;
            text-align: center;
            position: relative;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.2);
            margin-bottom: 30px;
        }

        header img {
             width: 120px;
             height: auto;
             margin-bottom: 10px;
        }

        nav ul {
            list-style-type: none;
            padding: 0;
            margin: 20px 0;
            text-align: center;
        }

        nav ul li {
            display: inline;
            margin: 0 15px;
        }

        nav ul li a {
            color: white;
            text-decoration: none;
            padding: 10px 20px;
            background-color: #333;
            border-radius: 20px;
            transition: background-color 0.3s ease;
        }

        nav ul li a:hover {
            background-color: #555;
        }

        main {
            width: 90%;
            max-width: 900px;
            margin: 0 auto;
            padding: 30px;
            background-color: #fff;
            box-shadow: 0 8px 16px rgba(0, 0, 0, 0.1);
            border-radius: 10px;
            animation: fadeIn 0.7s ease-in-out;
        }

        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(20px); }
            to { opacity: 1; transform: translateY(0); }
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
            font-size: 14px;
        }

        th, td {
            padding: 12px;
            text-align: center;
            border-bottom: 1px solid #ddd;
        }

        th {
            background-color: #3f51b5;
            color: white;
            text-align: center;
        }

        tr:nth-child(even) {
            background-color: #f9f9f9;
        }

        tr:hover {
            background-color: #f1f1f1;
        }

        .highlight {
            font-weight: bold;
        }

        .table-container {
            overflow-x: auto;
        }

        .text-right {
            text-align: right;
            padding-right: 20px;
        }

        .no-notes {
            font-size: 18px;
            text-align: center;
            padding: 40px 0;
            color: #555;
        }

        .semestre-form {
            text-align: center;
            margin-bottom: 20px;
        }

        .semestre-form select, .semestre-form button {
            font-size: 16px;
            padding: 8px 12px;
            margin: 0 5px;
            border-radius: 5px;
            border: 1px solid #ccc;
        }
    </style>
</head>
<body>
    <header>
        <img src="../images/INSIGNIA SF.png" alt="Escuela Porongo Insignia">
        <h1>Mis Notas</h1>
    
    <nav>
        <ul>
            <li><a href="../index.php">Inicio</a></li>
        </ul>
    </nav>
        </header>
    <main>
        <!-- Formulario para seleccionar el semestre -->
        <div class="semestre-form">
            <form method="POST">
                <label for="semestre">Seleccione el semestre:</label>
                <select name="semestre" id="semestre">
                    <option value="1" <?php echo ($semestre == 1) ? 'selected' : ''; ?>>Primer Semestre</option>
                    <option value="2" <?php echo ($semestre == 2) ? 'selected' : ''; ?>>Segundo Semestre</option>
                </select>
                <button type="submit">Ver Notas</button>
            </form>
        </div>

        <?php if (isset($error_message)): ?>
            <p>Error: <?php echo htmlspecialchars($error_message, ENT_QUOTES, 'UTF-8'); ?></p>
        <?php elseif (!empty($notas)): ?>
            <div class="table-container">
                <table>
                    <thead>
                        <tr>
                            <th>Asignatura</th>
                            <?php for ($i = 1; $i <= 10; $i++): ?>
                                <th>N<?php echo $i; ?></th>
                            <?php endfor; ?>
                            <th>Promedio</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php 
                        foreach ($notas_por_asignatura as $asignatura => $notas):
                            $promedio_asignatura = calcular_promedio($notas);
                            $promedios_asignaturas[] = $promedio_asignatura; // Guardar el promedio de cada asignatura
                        ?>
                            <tr>
                                <td class="highlight"><?php echo htmlspecialchars($asignatura, ENT_QUOTES, 'UTF-8'); ?></td>
                                <?php for ($i = 1; $i <= 10; $i++): ?>
                                    <td><?php echo isset($notas[$i]) ? htmlspecialchars($notas[$i], ENT_QUOTES, 'UTF-8') : '-'; ?></td>
                                <?php endfor; ?>
                                <td><?php echo htmlspecialchars($promedio_asignatura, ENT_QUOTES, 'UTF-8'); ?></td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                    <tfoot>
                        <tr>
                            <td colspan="11" class="text-right">Promedio Final de Todas las Asignaturas</td>
                            <td><?php echo htmlspecialchars(calcular_promedio($promedios_asignaturas), ENT_QUOTES, 'UTF-8'); ?></td>
                        </tr>
                    </tfoot>
                </table>
            </div>
        <?php else: ?>
            <div class="no-notes">No se encontraron notas para el semestre seleccionado.</div>
        <?php endif; ?>
    </main>
</body>
</html>
