

DROP TABLE IF EXISTS `alergias_alimentarias`;
CREATE TABLE `alergias_alimentarias` (
  `id` int NOT NULL AUTO_INCREMENT,
  `matricula_id` int DEFAULT NULL,
  `alergia` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `matricula_id` (`matricula_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;






DROP TABLE IF EXISTS `apoderados`;
CREATE TABLE `apoderados` (
  `id` int NOT NULL AUTO_INCREMENT,
  `matricula_id` int DEFAULT NULL,
  `rut` varchar(12) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `nombre` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `telefono` varchar(15) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `celular` varchar(15) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `parentesco` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `matricula_id` (`matricula_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;






DROP TABLE IF EXISTS `asignatura`;
CREATE TABLE `asignatura` (
  `id` int NOT NULL AUTO_INCREMENT,
  `nombre` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO asignatura VALUES('1', 'Lenguaje y Comunicación');
INSERT INTO asignatura VALUES('2', 'Matemática');
INSERT INTO asignatura VALUES('3', 'Música');
INSERT INTO asignatura VALUES('4', 'Artes Visuales');
INSERT INTO asignatura VALUES('5', 'Educación Física y Salud');
INSERT INTO asignatura VALUES('6', 'Ciencias Naturales');
INSERT INTO asignatura VALUES('7', 'Historia, Geografía y Ciencias Sociales');
INSERT INTO asignatura VALUES('8', 'Inglés');
INSERT INTO asignatura VALUES('9', 'Orientación');
INSERT INTO asignatura VALUES('10', 'Religión');
INSERT INTO asignatura VALUES('11', 'Lengua y Literatura');
INSERT INTO asignatura VALUES('12', 'Tecnología');





DROP TABLE IF EXISTS `curso`;
CREATE TABLE `curso` (
  `id` int NOT NULL AUTO_INCREMENT,
  `nombre` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `profesor_jefe_id` int DEFAULT NULL,
  `activo` tinyint(1) DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `profesor_jefe_id` (`profesor_jefe_id`)
) ENGINE=InnoDB AUTO_INCREMENT=66 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO curso VALUES('49', 'Pre Kinder A', '250', '1');
INSERT INTO curso VALUES('50', 'Kinder A', '242', '1');
INSERT INTO curso VALUES('51', 'Kinder B', '274', '1');
INSERT INTO curso VALUES('52', '1° Año A', '241', '1');
INSERT INTO curso VALUES('53', '1° Año B', '1373', '1');
INSERT INTO curso VALUES('54', '2° Año A', '825', '1');
INSERT INTO curso VALUES('55', '3° Año A', '273', '1');
INSERT INTO curso VALUES('56', '3° Año B', '253', '1');
INSERT INTO curso VALUES('57', '4° Año A', '267', '1');
INSERT INTO curso VALUES('58', '4° Año B', '259', '1');
INSERT INTO curso VALUES('59', '5° Año A', '263', '1');
INSERT INTO curso VALUES('60', '5° Año B', '945', '1');
INSERT INTO curso VALUES('61', '6° Año A', '269', '1');
INSERT INTO curso VALUES('62', '7° Año A', '260', '1');
INSERT INTO curso VALUES('63', '7° Año B', '266', '1');
INSERT INTO curso VALUES('64', '8° Año A', '257', '1');
INSERT INTO curso VALUES('65', '8° Año B', '243', '1');





DROP TABLE IF EXISTS `detalles_equipo`;
CREATE TABLE `detalles_equipo` (
  `id` int NOT NULL AUTO_INCREMENT,
  `equipo_id` int DEFAULT NULL,
  `marca` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `modelo` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `numero_serie` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `procesador` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `memoria_ram` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `almacenamiento` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tarjeta_grafica` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sistema_operativo` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `version_so` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `imagen` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `equipo_id` (`equipo_id`)
) ENGINE=InnoDB AUTO_INCREMENT=61 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO detalles_equipo VALUES('10', '7', 'HP', '240 G6', '3549-1 0000773', 'i3 6000', '4 GB', '500 GB HDD', 'Integrada', 'Windows 10 LTCS', '64 bits', 'uploads/equipos/670d57e7db5903.09910162.jpg');
INSERT INTO detalles_equipo VALUES('11', '8', 'EPSON', 'M100', 'NO POSEE', 'NO APLICA', 'NO APLICA', 'NO APLICA', 'NO APLICA', 'NO APLICA', 'NO APLICA', 'uploads/equipos/670d58ddbe7ac2.75180501.jpg');
INSERT INTO detalles_equipo VALUES('12', '9', 'LENOVO', 'C240', 'DAEM 3549-1 0000062', 'INTEL CELERON', '2 GB', '500 GB HDD', 'INTEGRADA', 'Windows 7 Ultimate', '64 bits', 'uploads/equipos/670d5a708682a0.73158851.jpg');
INSERT INTO detalles_equipo VALUES('13', '10', 'LENOVO', 'C240', 'DAEM 3549-1 0000063', 'INTEL CELERON', '2 GB', '500 GB HDD', 'INTEGRADA', 'Windows 7 Ultimate', '64 bits', 'uploads/equipos/670d5bfc9ae601.88036358.jpg');
INSERT INTO detalles_equipo VALUES('14', '11', 'LENOVO', 'C240', 'DAEM 3549-1 0000064', 'INTEL CELERON', '2 GB', '500 GB HDD', 'INTEGRADA', 'Windows 7 Ultimate', '64 bits', 'uploads/equipos/670d5c98d48864.37341798.jpg');
INSERT INTO detalles_equipo VALUES('15', '12', 'LENOVO', 'C240', 'DAEM 3549-1 0000065', 'INTEL CELERON', '2 GB', '500 GB HDD', 'INTEGRADA', 'Windows 7 Ultimate', '64 bits', 'uploads/equipos/670d5d873b49a7.00535370.jpg');
INSERT INTO detalles_equipo VALUES('16', '13', 'Generico', 'Generico', 'No aplica', 'No aplica', 'No aplica', 'No aplica', 'No aplica', 'No aplica', 'No aplica', 'uploads/equipos/671800602d66e6.55711710.webp');
INSERT INTO detalles_equipo VALUES('17', '14', 'No aplica', 'No aplica', 'No aplica', 'No aplica', 'No aplica', 'No aplica', 'No aplica', 'No aplica', 'No aplica', 'uploads/equipos/671800b6947789.35221750.webp');
INSERT INTO detalles_equipo VALUES('18', '15', 'No aplica', 'No aplica', 'No aplica', 'No aplica', 'No aplica', 'No aplica', 'No aplica', 'No aplica', 'No aplica', 'uploads/equipos/671800c0857395.92004298.webp');
INSERT INTO detalles_equipo VALUES('19', '16', 'Generica', 'No aplica', 'No aplica', 'No aplica', 'No aplica', 'No aplica', 'No aplica', 'No aplica', 'No aplica', 'uploads/equipos/67180070d9a842.71571147.webp');
INSERT INTO detalles_equipo VALUES('20', '17', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO detalles_equipo VALUES('21', '18', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO detalles_equipo VALUES('22', '19', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO detalles_equipo VALUES('23', '20', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO detalles_equipo VALUES('24', '21', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO detalles_equipo VALUES('25', '22', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO detalles_equipo VALUES('26', '23', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO detalles_equipo VALUES('27', '24', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO detalles_equipo VALUES('28', '25', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO detalles_equipo VALUES('29', '26', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO detalles_equipo VALUES('30', '27', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO detalles_equipo VALUES('31', '28', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO detalles_equipo VALUES('32', '29', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO detalles_equipo VALUES('33', '30', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO detalles_equipo VALUES('34', '31', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO detalles_equipo VALUES('35', '32', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO detalles_equipo VALUES('36', '33', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO detalles_equipo VALUES('37', '34', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO detalles_equipo VALUES('38', '35', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO detalles_equipo VALUES('39', '36', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO detalles_equipo VALUES('40', '37', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO detalles_equipo VALUES('41', '38', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO detalles_equipo VALUES('42', '39', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO detalles_equipo VALUES('43', '40', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO detalles_equipo VALUES('44', '41', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO detalles_equipo VALUES('45', '42', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO detalles_equipo VALUES('46', '43', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO detalles_equipo VALUES('47', '44', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO detalles_equipo VALUES('48', '45', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO detalles_equipo VALUES('49', '46', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO detalles_equipo VALUES('50', '47', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO detalles_equipo VALUES('51', '48', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO detalles_equipo VALUES('52', '49', 'itab', 'SP50W', 'No aplica.', 'No aplica.', 'No aplica.', 'No aplica.', 'No aplica.', 'No aplica.', 'No aplica.', 'uploads/equipos/6711556e4ef717.05861828.PNG');
INSERT INTO detalles_equipo VALUES('53', '50', 'HP', '240 G6', 'NO POSEE', 'i3 6000', '4 GB', '500 GB HDD', 'Tarjeta Gráfica	Integrada', 'Windows 10 LTCS', '64 bits', 'uploads/equipos/672cbd7a90cfb1.67368144.jpg');
INSERT INTO detalles_equipo VALUES('54', '51', 'HP', '240 G6', '3549-1 0000456', 'i3 6000', '4 GB', '500 GB HDD', 'Tarjeta Gráfica	Integrada', 'Windows 10 LTCS', '64 bits', 'uploads/equipos/672cc767b3c527.41022551.jpg');
INSERT INTO detalles_equipo VALUES('55', '52', 'Generica', 'Optico USB', 'NO APLICA', 'NO APLICA', 'NO APLICA', 'NO APLICA', 'NO APLICA', 'NO APLICA', 'NO APLICA', 'uploads/equipos/67407046db2452.87291470.webp');
INSERT INTO detalles_equipo VALUES('56', '53', 'DATAWORLD', 'NO APLICA', 'DAEM 3549-1 0000484', 'NO APLICA', 'NO APLICA', 'NO APLICA', 'NO APLICA', 'NO APLICA', 'NO APLICA', 'uploads/equipos/6745d0d5a5cb61.10219280.webp');
INSERT INTO detalles_equipo VALUES('57', '54', 'DATAWORLD', 'NO APLICA', 'NO APLICA', 'NO APLICA', 'NO APLICA', 'NO APLICA', 'NO APLICA', 'NO APLICA', 'NO APLICA', 'uploads/equipos/6745d10ce3eac7.09878740.webp');
INSERT INTO detalles_equipo VALUES('58', '55', 'VIEWSONIC', 'VS16905', '3549-1 0001405', 'No aplica', 'No aplica', 'No aplica', 'No aplica', 'No aplica', 'No aplica', 'uploads/equipos/6747092beb0397.69528320.webp');
INSERT INTO detalles_equipo VALUES('59', '56', 'View Sonic', 'VS16905', 'No Posee', 'No Posee', 'No Posee', 'No Posee', 'No Posee', 'No Posee', 'No Posee', 'uploads/equipos/67d07ae1a8ac23.30409899.jpg');
INSERT INTO detalles_equipo VALUES('60', '57', 'Generico', 'Generico', 'No posee', 'No posee', 'No posee', 'No posee', 'No posee', 'No posee', 'No posee', 'uploads/equipos/67d1af3f17ad92.37027663.webp');





DROP TABLE IF EXISTS `equipo`;
CREATE TABLE `equipo` (
  `id` int NOT NULL AUTO_INCREMENT,
  `nombre_equipo` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ubicacion` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `estado_equipo_id` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `estado_equipo_id` (`estado_equipo_id`)
) ENGINE=InnoDB AUTO_INCREMENT=58 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO equipo VALUES('7', 'Notebook Enlaces 1', 'Laboratorio de Enlaces', '1');
INSERT INTO equipo VALUES('8', 'Impresora Epson', 'Laboratorio de Enlaces', '1');
INSERT INTO equipo VALUES('9', 'All In One LENOVO 1', 'Laboratorio de Enlaces', '1');
INSERT INTO equipo VALUES('10', 'All In One LENOVO 2', 'Laboratorio de Enlaces', '1');
INSERT INTO equipo VALUES('11', 'All In One LENOVO 3', 'Laboratorio de Enlaces', '1');
INSERT INTO equipo VALUES('12', 'All In One LENOVO 4', 'Laboratorio de Enlaces', '1');
INSERT INTO equipo VALUES('13', 'Cable HDMI 1', 'Laboratorio de Enlaces', '1');
INSERT INTO equipo VALUES('14', 'Alargador 1', 'Laboratorio de Enlaces', '1');
INSERT INTO equipo VALUES('15', 'Alargador 2', 'Laboratorio de Enlaces', '1');
INSERT INTO equipo VALUES('16', 'Cable HDMI 2', 'Laboratorio de Enlaces', '1');
INSERT INTO equipo VALUES('49', 'Parlante Bluetooth', 'Laboratorio de Enlaces', '1');
INSERT INTO equipo VALUES('50', 'Notebook Enlaces 2', 'Laboratorio de Enlaces', '1');
INSERT INTO equipo VALUES('51', 'Notebook Enlaces 3', 'Laboratorio de Enlaces', '1');
INSERT INTO equipo VALUES('52', 'Mouse USB Azul', 'Laboratorio de Enlaces', '1');
INSERT INTO equipo VALUES('53', 'TELON + PEDESTAL 1', 'Laboratorio de Enlaces', '1');
INSERT INTO equipo VALUES('54', 'TELON + PEDESTAL 2', 'Laboratorio de Enlaces', '1');
INSERT INTO equipo VALUES('55', 'Data Blanco HDMI', 'Laboratorio Enlaces', '1');
INSERT INTO equipo VALUES('56', 'Proyector View Sonic 3° Año A', '3° Año A', '1');
INSERT INTO equipo VALUES('57', 'Cable HDMI Negro', 'Laboratorio de Enlaces', '1');





DROP TABLE IF EXISTS `estado_equipo`;
CREATE TABLE `estado_equipo` (
  `id` int NOT NULL AUTO_INCREMENT,
  `nombre_estado` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO estado_equipo VALUES('1', 'Operativo');
INSERT INTO estado_equipo VALUES('2', 'En reparación');
INSERT INTO estado_equipo VALUES('3', 'Fuera de servicio');
INSERT INTO estado_equipo VALUES('4', 'Dado de baja');





DROP TABLE IF EXISTS `familiares`;
CREATE TABLE `familiares` (
  `id` int NOT NULL AUTO_INCREMENT,
  `matricula_id` int DEFAULT NULL,
  `rut` varchar(12) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `nombre` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `apellido_paterno` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `apellido_materno` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `domicilio` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `escolaridad` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `trabaja` tinyint(1) DEFAULT NULL,
  `tipo_trabajo` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `dentro_fuera_hogar` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `parentesco` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `matricula_id` (`matricula_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;






DROP TABLE IF EXISTS `historial_cursos`;
CREATE TABLE `historial_cursos` (
  `id` int NOT NULL AUTO_INCREMENT,
  `usuario_id` int NOT NULL,
  `curso_id` int NOT NULL,
  `fecha` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `usuario_id` (`usuario_id`),
  KEY `curso_id` (`curso_id`),
  CONSTRAINT `historial_cursos_ibfk_1` FOREIGN KEY (`usuario_id`) REFERENCES `usuario` (`id`) ON DELETE CASCADE,
  CONSTRAINT `historial_cursos_ibfk_2` FOREIGN KEY (`curso_id`) REFERENCES `curso` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;






DROP TABLE IF EXISTS `horario`;
CREATE TABLE `horario` (
  `id` int NOT NULL AUTO_INCREMENT,
  `usuario_id` int DEFAULT NULL,
  `fecha` date NOT NULL,
  `hora_inicio` time NOT NULL,
  `hora_fin` time NOT NULL,
  `curso_id` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `usuario_id` (`usuario_id`),
  KEY `curso_id` (`curso_id`)
) ENGINE=InnoDB AUTO_INCREMENT=354 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO horario VALUES('205', '945', '2025-03-12', '10:20:00', '11:05:00', '59');
INSERT INTO horario VALUES('206', '945', '2025-03-12', '11:05:00', '11:50:00', '59');
INSERT INTO horario VALUES('207', '945', '2025-03-12', '12:00:00', '12:45:00', '61');
INSERT INTO horario VALUES('208', '945', '2025-03-12', '12:45:00', '13:30:00', '61');
INSERT INTO horario VALUES('211', '253', '2025-03-13', '10:20:00', '11:05:00', '56');
INSERT INTO horario VALUES('212', '253', '2025-03-13', '11:05:00', '11:50:00', '56');
INSERT INTO horario VALUES('213', '825', '2025-03-14', '10:20:00', '11:05:00', '54');
INSERT INTO horario VALUES('215', '825', '2025-03-14', '11:05:00', '11:50:00', '54');
INSERT INTO horario VALUES('216', '825', '2025-03-14', '12:00:00', '12:45:00', '54');
INSERT INTO horario VALUES('217', '825', '2025-03-14', '12:45:00', '13:30:00', '54');
INSERT INTO horario VALUES('218', '945', '2025-03-12', '15:10:00', '15:55:00', '62');
INSERT INTO horario VALUES('219', '945', '2025-03-12', '14:25:00', '15:10:00', '62');
INSERT INTO horario VALUES('221', '247', '2025-03-19', '15:10:00', '15:55:00', '59');
INSERT INTO horario VALUES('222', '247', '2025-03-19', '14:25:00', '15:10:00', '59');
INSERT INTO horario VALUES('223', '241', '2025-03-17', '10:20:00', '11:05:00', '52');
INSERT INTO horario VALUES('224', '241', '2025-03-17', '11:05:00', '11:50:00', '52');
INSERT INTO horario VALUES('225', '241', '2025-03-17', '12:00:00', '12:45:00', '52');
INSERT INTO horario VALUES('226', '241', '2025-03-17', '12:45:00', '13:30:00', '52');
INSERT INTO horario VALUES('227', '257', '2025-03-13', '12:00:00', '12:45:00', '62');
INSERT INTO horario VALUES('228', '257', '2025-03-13', '12:45:00', '13:30:00', '62');
INSERT INTO horario VALUES('230', '257', '2025-03-20', '10:20:00', '11:05:00', '62');
INSERT INTO horario VALUES('231', '257', '2025-03-20', '11:05:00', '11:50:00', '62');
INSERT INTO horario VALUES('232', '269', '2025-03-17', '08:30:00', '09:15:00', '61');
INSERT INTO horario VALUES('233', '269', '2025-03-17', '09:15:00', '10:00:00', '61');
INSERT INTO horario VALUES('234', '266', '2025-03-10', '14:25:00', '15:10:00', '65');
INSERT INTO horario VALUES('235', '266', '2025-03-10', '15:10:00', '15:55:00', '65');
INSERT INTO horario VALUES('237', '253', '2025-03-18', '09:15:00', '10:00:00', '56');
INSERT INTO horario VALUES('241', '253', '2025-03-18', '08:30:00', '09:15:00', '56');
INSERT INTO horario VALUES('242', '253', '2025-03-19', '10:20:00', '11:05:00', '56');
INSERT INTO horario VALUES('243', '253', '2025-03-19', '11:05:00', '11:50:00', '56');
INSERT INTO horario VALUES('244', '825', '2025-03-18', '10:20:00', '11:05:00', '54');
INSERT INTO horario VALUES('245', '825', '2025-03-18', '11:05:00', '11:50:00', '54');
INSERT INTO horario VALUES('246', '257', '2025-03-21', '08:30:00', '09:15:00', '65');
INSERT INTO horario VALUES('247', '257', '2025-03-21', '09:15:00', '10:00:00', '65');
INSERT INTO horario VALUES('248', '243', '2025-03-19', '12:00:00', '12:45:00', '63');
INSERT INTO horario VALUES('249', '243', '2025-03-19', '12:45:00', '13:30:00', '63');
INSERT INTO horario VALUES('250', '825', '2025-03-18', '14:25:00', '15:10:00', '54');
INSERT INTO horario VALUES('251', '825', '2025-03-18', '15:10:00', '15:55:00', '54');
INSERT INTO horario VALUES('252', '825', '2025-03-19', '08:30:00', '09:15:00', '54');
INSERT INTO horario VALUES('253', '825', '2025-03-19', '09:15:00', '10:00:00', '54');
INSERT INTO horario VALUES('254', '825', '2025-03-21', '10:20:00', '11:05:00', '54');
INSERT INTO horario VALUES('255', '825', '2025-03-21', '11:05:00', '11:50:00', '54');
INSERT INTO horario VALUES('256', '259', '2025-03-20', '08:30:00', '09:15:00', '58');
INSERT INTO horario VALUES('257', '259', '2025-03-20', '09:15:00', '10:00:00', '58');
INSERT INTO horario VALUES('258', '259', '2025-03-20', '12:00:00', '12:45:00', '58');
INSERT INTO horario VALUES('259', '259', '2025-03-20', '12:45:00', '13:30:00', '58');
INSERT INTO horario VALUES('260', '267', '2025-03-25', '08:30:00', '09:15:00', '57');
INSERT INTO horario VALUES('261', '267', '2025-03-25', '09:15:00', '10:00:00', '57');
INSERT INTO horario VALUES('262', '259', '2025-03-24', '10:20:00', '11:05:00', '58');
INSERT INTO horario VALUES('263', '259', '2025-03-24', '11:05:00', '11:50:00', '58');
INSERT INTO horario VALUES('264', '259', '2025-03-24', '14:25:00', '15:10:00', '59');
INSERT INTO horario VALUES('265', '259', '2025-03-24', '15:10:00', '15:55:00', '59');
INSERT INTO horario VALUES('267', '259', '2025-03-25', '12:00:00', '12:45:00', '58');
INSERT INTO horario VALUES('269', '259', '2025-03-25', '12:45:00', '13:30:00', '58');
INSERT INTO horario VALUES('270', '273', '2025-03-25', '14:25:00', '15:10:00', '55');
INSERT INTO horario VALUES('271', '273', '2025-03-25', '15:10:00', '15:55:00', '55');
INSERT INTO horario VALUES('272', '273', '2025-03-26', '10:20:00', '11:05:00', '55');
INSERT INTO horario VALUES('278', '273', '2025-03-26', '11:05:00', '11:50:00', '55');
INSERT INTO horario VALUES('279', '267', '2025-03-27', '12:00:00', '12:45:00', '57');
INSERT INTO horario VALUES('280', '267', '2025-03-27', '12:45:00', '13:30:00', '57');
INSERT INTO horario VALUES('281', '271', '2025-04-01', '12:00:00', '12:45:00', '61');
INSERT INTO horario VALUES('282', '271', '2025-04-01', '12:45:00', '13:30:00', '61');
INSERT INTO horario VALUES('285', '271', '2025-04-01', '08:30:00', '09:15:00', '59');
INSERT INTO horario VALUES('286', '271', '2025-04-01', '09:15:00', '10:00:00', '59');
INSERT INTO horario VALUES('291', '825', '2025-03-26', '12:00:00', '12:45:00', '52');
INSERT INTO horario VALUES('292', '825', '2025-03-28', '08:30:00', '09:15:00', '55');
INSERT INTO horario VALUES('293', '273', '2025-03-28', '09:15:00', '10:00:00', '55');
INSERT INTO horario VALUES('294', '266', '2025-03-24', '08:30:00', '09:15:00', '63');
INSERT INTO horario VALUES('295', '266', '2025-03-27', '09:15:00', '10:00:00', '63');
INSERT INTO horario VALUES('296', '266', '2025-03-24', '09:15:00', '10:00:00', '63');
INSERT INTO horario VALUES('297', '266', '2025-03-31', '08:30:00', '09:15:00', '63');
INSERT INTO horario VALUES('298', '271', '2025-04-04', '12:00:00', '12:45:00', '60');
INSERT INTO horario VALUES('299', '271', '2025-04-04', '12:45:00', '13:30:00', '60');
INSERT INTO horario VALUES('300', '271', '2025-04-01', '14:25:00', '15:10:00', '61');
INSERT INTO horario VALUES('301', '271', '2025-04-01', '15:10:00', '15:55:00', '61');
INSERT INTO horario VALUES('302', '271', '2025-04-07', '10:20:00', '11:05:00', '61');
INSERT INTO horario VALUES('303', '271', '2025-04-07', '11:05:00', '11:50:00', '61');
INSERT INTO horario VALUES('304', '271', '2025-04-04', '08:30:00', '09:15:00', '63');
INSERT INTO horario VALUES('305', '271', '2025-04-04', '09:15:00', '10:00:00', '63');
INSERT INTO horario VALUES('306', '825', '2025-04-02', '12:00:00', '12:45:00', '52');
INSERT INTO horario VALUES('307', '825', '2025-04-02', '10:20:00', '11:05:00', '61');
INSERT INTO horario VALUES('308', '1', '2025-04-02', '14:25:00', '15:10:00', '55');
INSERT INTO horario VALUES('309', '1', '2025-04-02', '15:10:00', '15:55:00', '56');
INSERT INTO horario VALUES('310', '1', '2025-04-03', '14:25:00', '15:10:00', '56');
INSERT INTO horario VALUES('311', '1', '2025-04-03', '15:10:00', '15:55:00', '55');
INSERT INTO horario VALUES('314', '945', '2025-04-04', '10:20:00', '11:05:00', '64');
INSERT INTO horario VALUES('315', '945', '2025-04-04', '11:05:00', '11:50:00', '64');
INSERT INTO horario VALUES('316', '259', '2025-04-07', '14:25:00', '15:10:00', '59');
INSERT INTO horario VALUES('317', '259', '2025-04-07', '15:10:00', '15:55:00', '59');
INSERT INTO horario VALUES('318', '825', '2025-04-09', '12:00:00', '12:45:00', '52');
INSERT INTO horario VALUES('319', '825', '2025-04-11', '08:30:00', '09:15:00', '55');
INSERT INTO horario VALUES('321', '253', '2025-04-09', '08:30:00', '09:15:00', '56');
INSERT INTO horario VALUES('322', '253', '2025-04-09', '09:15:00', '10:00:00', '56');
INSERT INTO horario VALUES('323', '259', '2025-04-09', '14:25:00', '15:10:00', '58');
INSERT INTO horario VALUES('324', '259', '2025-04-09', '15:10:00', '15:55:00', '58');
INSERT INTO horario VALUES('325', '825', '2025-04-10', '14:25:00', '15:10:00', '52');
INSERT INTO horario VALUES('326', '825', '2025-04-10', '15:10:00', '15:55:00', '52');
INSERT INTO horario VALUES('335', '1753', '2025-04-09', '10:20:00', '11:05:00', '55');
INSERT INTO horario VALUES('337', '1753', '2025-04-16', '12:45:00', '13:30:00', '54');
INSERT INTO horario VALUES('338', '1753', '2025-04-16', '12:00:00', '12:45:00', '54');
INSERT INTO horario VALUES('339', '1753', '2025-04-16', '14:25:00', '15:10:00', '55');
INSERT INTO horario VALUES('340', '1753', '2025-04-16', '15:10:00', '15:55:00', '56');
INSERT INTO horario VALUES('341', '273', '2025-04-11', '09:15:00', '10:00:00', '55');
INSERT INTO horario VALUES('343', '266', '2025-04-11', '12:00:00', '12:45:00', '63');
INSERT INTO horario VALUES('344', '266', '2025-04-11', '12:45:00', '13:30:00', '63');
INSERT INTO horario VALUES('345', '825', '2025-04-14', '08:30:00', '09:15:00', '54');
INSERT INTO horario VALUES('346', '825', '2025-04-14', '09:15:00', '10:00:00', '54');
INSERT INTO horario VALUES('347', '825', '2025-04-16', '10:20:00', '11:05:00', '61');
INSERT INTO horario VALUES('348', '825', '2025-04-17', '14:25:00', '15:10:00', '52');
INSERT INTO horario VALUES('349', '825', '2025-04-17', '15:10:00', '15:55:00', '52');
INSERT INTO horario VALUES('350', '263', '2025-04-14', '10:20:00', '11:05:00', '59');
INSERT INTO horario VALUES('351', '263', '2025-04-14', '11:05:00', '11:50:00', '59');
INSERT INTO horario VALUES('352', '269', '2025-04-14', '12:00:00', '12:45:00', '62');
INSERT INTO horario VALUES('353', '269', '2025-04-14', '12:45:00', '13:30:00', '62');





DROP TABLE IF EXISTS `indicadores`;
CREATE TABLE `indicadores` (
  `id` int NOT NULL AUTO_INCREMENT,
  `nombre` varchar(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `descripcion` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO indicadores VALUES('1', 'MB', 'Muy Bueno');
INSERT INTO indicadores VALUES('2', 'B', 'Bueno');
INSERT INTO indicadores VALUES('3', 'S', 'Suficiente');
INSERT INTO indicadores VALUES('4', 'I', 'Insuficiente');





DROP TABLE IF EXISTS `informacion_adicional`;
CREATE TABLE `informacion_adicional` (
  `id` int NOT NULL AUTO_INCREMENT,
  `matricula_id` int DEFAULT NULL,
  `es_bicultural` tinyint(1) DEFAULT NULL,
  `etnia` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `problemas_aprendizaje` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cursos_repetidos` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `matricula_id` (`matricula_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;






DROP TABLE IF EXISTS `mantenimiento_equipo`;
CREATE TABLE `mantenimiento_equipo` (
  `id` int NOT NULL AUTO_INCREMENT,
  `equipo_id` int DEFAULT NULL,
  `fecha_ultimo_mantenimiento` date DEFAULT NULL,
  `detalles_mantenimiento` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `proxima_fecha_mantenimiento` date DEFAULT NULL,
  `observaciones` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `equipo_id` (`equipo_id`)
) ENGINE=InnoDB AUTO_INCREMENT=61 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO mantenimiento_equipo VALUES('10', '7', '2024-10-14', 'Actualizacion de sistema.', '2024-12-30', 'TouchPad no funciona bien.');
INSERT INTO mantenimiento_equipo VALUES('11', '8', '2024-10-14', 'LIMPIEZA GENERAL', '2024-12-30', 'NO APLICA');
INSERT INTO mantenimiento_equipo VALUES('12', '9', '2024-10-14', 'Limpieza General a nivel de hardware.', '2024-12-30', 'No Posee');
INSERT INTO mantenimiento_equipo VALUES('13', '10', '2024-10-14', '', '2024-12-30', 'Limpieza General a nivel de hardware.');
INSERT INTO mantenimiento_equipo VALUES('14', '11', '2024-10-14', 'Limpieza General a nivel de hardware.', '2024-12-30', 'No Posee');
INSERT INTO mantenimiento_equipo VALUES('15', '12', '2024-10-14', 'Limpieza General a nivel de hardware.', '2024-12-30', 'No Posee');
INSERT INTO mantenimiento_equipo VALUES('16', '13', '2024-10-14', 'No aplica', '2024-10-14', 'No aplica');
INSERT INTO mantenimiento_equipo VALUES('17', '14', '2024-10-14', 'No aplica', '2024-10-14', 'No aplica');
INSERT INTO mantenimiento_equipo VALUES('18', '15', '2024-10-14', 'No aplica', '2024-10-14', 'No aplica');
INSERT INTO mantenimiento_equipo VALUES('19', '16', '2024-10-14', 'No aplica', '2024-10-14', 'No aplica');
INSERT INTO mantenimiento_equipo VALUES('20', '17', NULL, NULL, NULL, NULL);
INSERT INTO mantenimiento_equipo VALUES('21', '18', NULL, NULL, NULL, NULL);
INSERT INTO mantenimiento_equipo VALUES('22', '19', NULL, NULL, NULL, NULL);
INSERT INTO mantenimiento_equipo VALUES('23', '20', NULL, NULL, NULL, NULL);
INSERT INTO mantenimiento_equipo VALUES('24', '21', NULL, NULL, NULL, NULL);
INSERT INTO mantenimiento_equipo VALUES('25', '22', NULL, NULL, NULL, NULL);
INSERT INTO mantenimiento_equipo VALUES('26', '23', NULL, NULL, NULL, NULL);
INSERT INTO mantenimiento_equipo VALUES('27', '24', NULL, NULL, NULL, NULL);
INSERT INTO mantenimiento_equipo VALUES('28', '25', NULL, NULL, NULL, NULL);
INSERT INTO mantenimiento_equipo VALUES('29', '26', NULL, NULL, NULL, NULL);
INSERT INTO mantenimiento_equipo VALUES('30', '27', NULL, NULL, NULL, NULL);
INSERT INTO mantenimiento_equipo VALUES('31', '28', NULL, NULL, NULL, NULL);
INSERT INTO mantenimiento_equipo VALUES('32', '29', NULL, NULL, NULL, NULL);
INSERT INTO mantenimiento_equipo VALUES('33', '30', NULL, NULL, NULL, NULL);
INSERT INTO mantenimiento_equipo VALUES('34', '31', NULL, NULL, NULL, NULL);
INSERT INTO mantenimiento_equipo VALUES('35', '32', NULL, NULL, NULL, NULL);
INSERT INTO mantenimiento_equipo VALUES('36', '33', NULL, NULL, NULL, NULL);
INSERT INTO mantenimiento_equipo VALUES('37', '34', NULL, NULL, NULL, NULL);
INSERT INTO mantenimiento_equipo VALUES('38', '35', NULL, NULL, NULL, NULL);
INSERT INTO mantenimiento_equipo VALUES('39', '36', NULL, NULL, NULL, NULL);
INSERT INTO mantenimiento_equipo VALUES('40', '37', NULL, NULL, NULL, NULL);
INSERT INTO mantenimiento_equipo VALUES('41', '38', NULL, NULL, NULL, NULL);
INSERT INTO mantenimiento_equipo VALUES('42', '39', NULL, NULL, NULL, NULL);
INSERT INTO mantenimiento_equipo VALUES('43', '40', NULL, NULL, NULL, NULL);
INSERT INTO mantenimiento_equipo VALUES('44', '41', NULL, NULL, NULL, NULL);
INSERT INTO mantenimiento_equipo VALUES('45', '42', NULL, NULL, NULL, NULL);
INSERT INTO mantenimiento_equipo VALUES('46', '43', NULL, NULL, NULL, NULL);
INSERT INTO mantenimiento_equipo VALUES('47', '44', NULL, NULL, NULL, NULL);
INSERT INTO mantenimiento_equipo VALUES('48', '45', NULL, NULL, NULL, NULL);
INSERT INTO mantenimiento_equipo VALUES('49', '46', NULL, NULL, NULL, NULL);
INSERT INTO mantenimiento_equipo VALUES('50', '47', NULL, NULL, NULL, NULL);
INSERT INTO mantenimiento_equipo VALUES('51', '48', NULL, NULL, NULL, NULL);
INSERT INTO mantenimiento_equipo VALUES('52', '49', '2024-10-17', 'No aplica.', '2024-10-17', 'No aplica.');
INSERT INTO mantenimiento_equipo VALUES('53', '50', '2024-10-14', 'Actualizacion de sistema.', '2024-11-07', 'TouchPad no funciona bien.');
INSERT INTO mantenimiento_equipo VALUES('54', '51', '2024-10-14', 'Actualizacion de sistema.', '2024-11-29', '');
INSERT INTO mantenimiento_equipo VALUES('55', '52', '2024-11-22', 'NO APLICA', '2024-11-22', 'NO APLICA');
INSERT INTO mantenimiento_equipo VALUES('56', '53', '2024-11-26', 'NO APLICA', '2024-11-26', 'NO APLICA');
INSERT INTO mantenimiento_equipo VALUES('57', '54', '2024-11-26', 'NO APLICA', '2024-11-26', 'NO APLICA');
INSERT INTO mantenimiento_equipo VALUES('58', '55', '2024-11-27', 'No aplica', '2024-11-27', 'Data profesora Ines');
INSERT INTO mantenimiento_equipo VALUES('59', '56', '2025-03-11', 'No Posee', '2025-03-11', 'No Posee');
INSERT INTO mantenimiento_equipo VALUES('60', '57', '2025-03-12', 'No posee', '2025-03-30', 'No posee');





DROP TABLE IF EXISTS `matricula`;
CREATE TABLE `matricula` (
  `id` int NOT NULL AUTO_INCREMENT,
  `num_centro_apoderados` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `rut` varchar(12) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `nombre` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `apellido_paterno` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `apellido_materno` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `curso_id` int NOT NULL,
  `fecha_nac` date NOT NULL,
  `lugar_nac` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `dom_alumno` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fech_ing_curso` date DEFAULT NULL,
  `procedencia` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `persona_con_quien_vive` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `curso_id` (`curso_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;






DROP TABLE IF EXISTS `notas`;
CREATE TABLE `notas` (
  `id` int NOT NULL AUTO_INCREMENT,
  `usuario_id` int DEFAULT NULL,
  `asignatura_id` int DEFAULT NULL,
  `nota` float(5,2) DEFAULT NULL,
  `fecha` date NOT NULL,
  `semestre` tinyint NOT NULL,
  `numero_nota` int NOT NULL,
  PRIMARY KEY (`id`),
  KEY `usuario_id` (`usuario_id`),
  KEY `asignatura_id` (`asignatura_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;






DROP TABLE IF EXISTS `notas_indicadores`;
CREATE TABLE `notas_indicadores` (
  `id` int NOT NULL AUTO_INCREMENT,
  `usuario_id` int DEFAULT NULL,
  `asignatura_id` int DEFAULT NULL,
  `indicador_id` int DEFAULT NULL,
  `semestre` tinyint DEFAULT NULL,
  `fecha` date DEFAULT NULL,
  `numero_nota` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `usuario_id` (`usuario_id`),
  KEY `asignatura_id` (`asignatura_id`),
  KEY `indicador_id` (`indicador_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;






DROP TABLE IF EXISTS `permisos`;
CREATE TABLE `permisos` (
  `id` int NOT NULL AUTO_INCREMENT,
  `nombre` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `descripcion` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `url` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=42 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO permisos VALUES('20', 'Administrar Usuarios', NULL, 'admin.php');
INSERT INTO permisos VALUES('21', 'Gestionar Roles', NULL, 'gestionar_roles.php');
INSERT INTO permisos VALUES('22', 'Generar Informes de Notas', NULL, 'select_report.php');
INSERT INTO permisos VALUES('23', 'Agendar Horas', NULL, 'schedule.php');
INSERT INTO permisos VALUES('24', 'Generar Certificado Alumno Regular', NULL, 'certificado.php');
INSERT INTO permisos VALUES('25', 'Generar Certificado Traslado', NULL, 'traslado.php');
INSERT INTO permisos VALUES('26', 'Ver Cursos y Alumnos', NULL, 'view_courses.php');
INSERT INTO permisos VALUES('27', 'Agregar Asignaturas', NULL, 'add_subject.php');
INSERT INTO permisos VALUES('28', 'Agregar Curso', NULL, 'add_course.php');
INSERT INTO permisos VALUES('29', 'Agregar Alumnos', NULL, 'add_student.php');
INSERT INTO permisos VALUES('30', 'Agregar Notas', NULL, 'add_grade.php');
INSERT INTO permisos VALUES('31', 'Gestionar Notas', NULL, 'gestion_notas.php');
INSERT INTO permisos VALUES('32', 'Formulario de Matrícula', NULL, 'formulario_matricula.php');
INSERT INTO permisos VALUES('33', 'Gestionar Matrículas', NULL, 'crud_matriculas.php');
INSERT INTO permisos VALUES('34', 'Ingresar Equipos', NULL, 'equipos.php');
INSERT INTO permisos VALUES('35', 'Gestionar Equipos', NULL, 'crud_equipos.php');
INSERT INTO permisos VALUES('36', 'Respaldo y Recuperación', NULL, 'datos.php');
INSERT INTO permisos VALUES('37', 'Prestamos', NULL, 'prestamo.php');
INSERT INTO permisos VALUES('38', 'Permisos', NULL, 'permisos.php');
INSERT INTO permisos VALUES('40', 'Ver Notas', NULL, 'ver_notas.php');





DROP TABLE IF EXISTS `prestamos`;
CREATE TABLE `prestamos` (
  `id` int NOT NULL AUTO_INCREMENT,
  `equipo_id` int DEFAULT NULL,
  `usuario_id` int DEFAULT NULL,
  `fecha_prestamo` date DEFAULT NULL,
  `fecha_devolucion` date DEFAULT NULL,
  `estado` varchar(50) DEFAULT NULL,
  `observaciones` text,
  PRIMARY KEY (`id`),
  KEY `equipo_id` (`equipo_id`),
  KEY `usuario_id` (`usuario_id`),
  CONSTRAINT `prestamos_ibfk_1` FOREIGN KEY (`equipo_id`) REFERENCES `equipo` (`id`),
  CONSTRAINT `prestamos_ibfk_2` FOREIGN KEY (`usuario_id`) REFERENCES `usuario` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=57 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

INSERT INTO prestamos VALUES('19', '52', '904', '2024-09-09', '2024-11-29', 'Prestado', NULL);
INSERT INTO prestamos VALUES('29', '57', '945', '2025-03-10', '2025-03-14', 'Prestado', NULL);
INSERT INTO prestamos VALUES('32', '7', '243', '2025-03-13', '2025-03-13', 'Devuelto', NULL);
INSERT INTO prestamos VALUES('33', '50', '243', '2025-03-13', '2025-03-13', 'Devuelto', NULL);
INSERT INTO prestamos VALUES('34', '14', '864', '2025-03-13', '2025-03-13', 'Devuelto', NULL);
INSERT INTO prestamos VALUES('35', '51', '911', '2025-03-10', '2025-03-14', 'Devuelto', NULL);
INSERT INTO prestamos VALUES('36', '14', '243', '2025-03-13', '2025-03-13', 'Devuelto', NULL);
INSERT INTO prestamos VALUES('37', '56', '262', '2025-03-14', '2025-03-14', 'Devuelto', NULL);
INSERT INTO prestamos VALUES('38', '7', '1', '2025-03-10', '2025-03-31', 'Devuelto', NULL);
INSERT INTO prestamos VALUES('39', '14', '891', '2025-03-17', '2025-03-17', 'Devuelto', NULL);
INSERT INTO prestamos VALUES('40', '7', '905', '2025-03-18', '2025-03-18', 'Devuelto', NULL);
INSERT INTO prestamos VALUES('41', '7', '257', '2025-03-19', '2025-03-19', 'Devuelto', NULL);
INSERT INTO prestamos VALUES('42', '56', '262', '2025-03-19', '2025-03-19', 'Devuelto', NULL);
INSERT INTO prestamos VALUES('43', '56', '262', '2025-03-20', '2025-03-20', 'Devuelto', NULL);
INSERT INTO prestamos VALUES('44', '7', '257', '2025-03-20', '2025-03-20', 'Devuelto', NULL);
INSERT INTO prestamos VALUES('45', '7', '257', '2025-03-21', '2025-03-21', 'Devuelto', NULL);
INSERT INTO prestamos VALUES('46', '7', '257', '2025-03-26', '2025-03-26', 'Devuelto', NULL);
INSERT INTO prestamos VALUES('47', '50', '257', '2025-03-26', '2025-03-26', 'Devuelto', NULL);
INSERT INTO prestamos VALUES('48', '7', '257', '2025-03-31', '2025-03-31', 'Devuelto', NULL);
INSERT INTO prestamos VALUES('49', '7', '257', '2025-04-02', '2025-04-04', 'Devuelto', NULL);
INSERT INTO prestamos VALUES('50', '50', '245', '2025-04-07', '2025-04-07', 'Devuelto', NULL);
INSERT INTO prestamos VALUES('51', '50', '241', '2025-04-08', '2025-04-08', 'Devuelto', NULL);
INSERT INTO prestamos VALUES('52', '51', '241', '2025-04-08', '2025-04-08', 'Devuelto', NULL);
INSERT INTO prestamos VALUES('53', '50', '1', '2025-04-09', '2025-04-09', 'Devuelto', NULL);
INSERT INTO prestamos VALUES('54', '51', '1752', '2025-04-10', '2025-04-10', 'Devuelto', NULL);
INSERT INTO prestamos VALUES('55', '16', '269', '2025-04-10', '2025-04-10', 'Devuelto', NULL);
INSERT INTO prestamos VALUES('56', '51', '1752', '2025-04-15', '2025-04-15', 'Prestado', NULL);





DROP TABLE IF EXISTS `previsiones_salud`;
CREATE TABLE `previsiones_salud` (
  `id` int NOT NULL AUTO_INCREMENT,
  `matricula_id` int DEFAULT NULL,
  `tipo_prevision_id` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `matricula_id` (`matricula_id`),
  KEY `tipo_prevision_id` (`tipo_prevision_id`)
) ENGINE=InnoDB AUTO_INCREMENT=29 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;






DROP TABLE IF EXISTS `roles`;
CREATE TABLE `roles` (
  `id` int NOT NULL AUTO_INCREMENT,
  `nombre` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO roles VALUES('1', 'admin');
INSERT INTO roles VALUES('2', 'Docente');
INSERT INTO roles VALUES('3', 'Estudiante');
INSERT INTO roles VALUES('4', 'Administrativo');
INSERT INTO roles VALUES('8', 'Asistente');
INSERT INTO roles VALUES('10', 'Encargado de Enlaces');





DROP TABLE IF EXISTS `roles_permisos`;
CREATE TABLE `roles_permisos` (
  `rol_id` int NOT NULL,
  `permiso_id` int NOT NULL,
  PRIMARY KEY (`rol_id`,`permiso_id`),
  KEY `permiso_id` (`permiso_id`),
  CONSTRAINT `roles_permisos_ibfk_1` FOREIGN KEY (`rol_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE,
  CONSTRAINT `roles_permisos_ibfk_2` FOREIGN KEY (`permiso_id`) REFERENCES `permisos` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO roles_permisos VALUES('1', '20');
INSERT INTO roles_permisos VALUES('1', '21');
INSERT INTO roles_permisos VALUES('1', '22');
INSERT INTO roles_permisos VALUES('2', '22');
INSERT INTO roles_permisos VALUES('4', '22');
INSERT INTO roles_permisos VALUES('1', '23');
INSERT INTO roles_permisos VALUES('2', '23');
INSERT INTO roles_permisos VALUES('8', '23');
INSERT INTO roles_permisos VALUES('10', '23');
INSERT INTO roles_permisos VALUES('1', '24');
INSERT INTO roles_permisos VALUES('4', '24');
INSERT INTO roles_permisos VALUES('1', '25');
INSERT INTO roles_permisos VALUES('4', '25');
INSERT INTO roles_permisos VALUES('1', '26');
INSERT INTO roles_permisos VALUES('1', '27');
INSERT INTO roles_permisos VALUES('1', '28');
INSERT INTO roles_permisos VALUES('1', '29');
INSERT INTO roles_permisos VALUES('1', '30');
INSERT INTO roles_permisos VALUES('2', '30');
INSERT INTO roles_permisos VALUES('1', '31');
INSERT INTO roles_permisos VALUES('2', '31');
INSERT INTO roles_permisos VALUES('1', '32');
INSERT INTO roles_permisos VALUES('2', '32');
INSERT INTO roles_permisos VALUES('4', '32');
INSERT INTO roles_permisos VALUES('1', '33');
INSERT INTO roles_permisos VALUES('2', '33');
INSERT INTO roles_permisos VALUES('4', '33');
INSERT INTO roles_permisos VALUES('1', '34');
INSERT INTO roles_permisos VALUES('10', '34');
INSERT INTO roles_permisos VALUES('1', '35');
INSERT INTO roles_permisos VALUES('10', '35');
INSERT INTO roles_permisos VALUES('1', '36');
INSERT INTO roles_permisos VALUES('1', '37');
INSERT INTO roles_permisos VALUES('10', '37');
INSERT INTO roles_permisos VALUES('1', '38');
INSERT INTO roles_permisos VALUES('3', '40');





DROP TABLE IF EXISTS `software_instalado`;
CREATE TABLE `software_instalado` (
  `id` int NOT NULL AUTO_INCREMENT,
  `equipo_id` int NOT NULL,
  `programas_instalados` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `equipo_id` (`equipo_id`),
  CONSTRAINT `software_instalado_ibfk_1` FOREIGN KEY (`equipo_id`) REFERENCES `equipo` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO software_instalado VALUES('2', '7', 'Office 365, VLC, WINRAR, GOOGLE CHROME');
INSERT INTO software_instalado VALUES('3', '8', 'NO APLICA');
INSERT INTO software_instalado VALUES('4', '9', 'Office 2016, Winrar, Deepfrezzer, Adobe Reader, Google Chrome');
INSERT INTO software_instalado VALUES('5', '10', 'Office 2016, Winrar, Deepfrezzer, Adobe Reader, Google Chrome');
INSERT INTO software_instalado VALUES('6', '11', 'Office 2016, Winrar, Deepfrezzer, Adobe Reader, Google Chrome');
INSERT INTO software_instalado VALUES('7', '12', 'Office 2016, Winrar, Deepfrezzer, Adobe Reader, Google Chrome');
INSERT INTO software_instalado VALUES('8', '13', 'No aplica');
INSERT INTO software_instalado VALUES('9', '14', 'No aplica');
INSERT INTO software_instalado VALUES('10', '15', 'No aplica');
INSERT INTO software_instalado VALUES('11', '16', 'No aplica');
INSERT INTO software_instalado VALUES('12', '49', 'No aplica.');
INSERT INTO software_instalado VALUES('13', '50', 'Office 365, VLC, WINRAR, GOOGLE CHROME');
INSERT INTO software_instalado VALUES('14', '51', 'Office 365, VLC, WINRAR, GOOGLE CHROME');
INSERT INTO software_instalado VALUES('15', '52', 'NO APLICA');
INSERT INTO software_instalado VALUES('16', '53', 'NO APLICA');
INSERT INTO software_instalado VALUES('17', '54', 'NO APLICA');
INSERT INTO software_instalado VALUES('18', '55', 'No aplica');
INSERT INTO software_instalado VALUES('19', '56', 'No Posee');
INSERT INTO software_instalado VALUES('20', '57', 'No posee');





DROP TABLE IF EXISTS `tipo_prevision`;
CREATE TABLE `tipo_prevision` (
  `id` int NOT NULL AUTO_INCREMENT,
  `nombre` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO tipo_prevision VALUES('3', 'FONASA A');
INSERT INTO tipo_prevision VALUES('6', 'ISAPRE');
INSERT INTO tipo_prevision VALUES('7', 'FONASA B');
INSERT INTO tipo_prevision VALUES('8', 'FONASA C');
INSERT INTO tipo_prevision VALUES('12', 'FONASA D');
INSERT INTO tipo_prevision VALUES('13', 'DIPRECA');





DROP TABLE IF EXISTS `usuario`;
CREATE TABLE `usuario` (
  `id` int NOT NULL AUTO_INCREMENT,
  `rut` varchar(12) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `nombre` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `apellido_paterno` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `apellido_materno` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `contraseña` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `rol_id` int DEFAULT NULL,
  `curso_id` int DEFAULT NULL,
  `activo` tinyint(1) DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `rut` (`rut`),
  KEY `rol_id` (`rol_id`),
  KEY `curso_id` (`curso_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1754 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO usuario VALUES('1', '19098012-k', 'Matias', 'Aravena', 'Gómez', '$2y$10$AiCz7wdqlyH9ESt2wp.2DuIugpRbT415TzQNgffTE7kYFqip1W9Wq', '1', NULL, '1');
INSERT INTO usuario VALUES('241', '11917880-0', 'XIMENA DEL CARMEN', 'ERICES', 'CHÁVEZ', '$2y$10$f/9CyiQN09Wo9yiInjIJWOyE47.QgdpG3y2npXkYscezu7rOGEXS6', '2', '7', '1');
INSERT INTO usuario VALUES('242', '12792545-3', 'PAULA VERÓNICA', 'CERRO', 'RÍOS', '$2y$10$Mh7MUPXQt00h1NEOccPNN.dyWGRrGIG/gdidrklzm7rnteDRuE9gO', '2', NULL, '1');
INSERT INTO usuario VALUES('243', '13206506-3', 'RICHARD JORGE', 'TORRES', 'LARA', '$2y$10$vFGAHjlQQB8TkpEJJ59Rp.G9CkTMpjN0Y6a21E43Nmjk5xyf8GClW', '2', '12', '1');
INSERT INTO usuario VALUES('244', '13373354-k', 'BEATRIZ DEL CARMEN', 'CORTÉS', 'RÍOS', '$2y$10$dVjpqaxVXu4VSRD9oCS2OO2.hhZv1OiI3U4Ksu1QD0zuRKT.YQ.qK', '2', NULL, '1');
INSERT INTO usuario VALUES('245', '13465561-5', 'MARCELA ALEJANDRA', 'ROCA', 'URRUTIA', '$2y$10$N49ZgDSkAPeIPC6mWo/o1eR0A/k.UYcuNfx/sFE5FVJ3Jui1tgFXi', '2', NULL, '1');
INSERT INTO usuario VALUES('246', '13514231-k', 'ÚRSULA CELINA', 'CASTRO', 'MONTEIRO', '$2y$10$99v2OUtG9AwEWTGzU2QVt.g.CQSO2Wf1BFSMt4tyNLJ0i4/xAt3Sq', '2', NULL, '1');
INSERT INTO usuario VALUES('247', '13614576-2', 'JUAN PABLO', 'MUÑOZ', 'LUNA', '$2y$10$2/U9zUxO67eT7NJuxAVOmO6PkTaYjpiwerI2rU0RqjCRWlPVtr3fO', '2', NULL, '1');
INSERT INTO usuario VALUES('248', '15147405-5', 'DALILA ARLETTE', 'ARELLANO', 'SÁNCHEZ', '$2y$10$9VZjUv7ppqOezjp2urAIqe/r/AU6JDo9UVGm1LxkhT1I/iS0sGYdS', '2', NULL, '1');
INSERT INTO usuario VALUES('249', '15147948-0', 'MARÍA JOSÉ', 'ÁVILA', 'ÁVILA', '$2y$10$z4U3yzHjycrffa2wgabqNeSkdmpRwbtH/ampeVZsheKIUL35ztFNe', '2', NULL, '1');
INSERT INTO usuario VALUES('250', '15705679-4', 'MARIANELA EDITH DEL CARMEN', 'APABLAZA', 'OSORES', '$2y$10$YAVviRdsyQ/NkrFHsFPpOOFN3s.eWb1hBqwpuFdD.EpbJZKr8FCqS', '2', NULL, '1');
INSERT INTO usuario VALUES('252', '16050607-5', 'GERARDO ANTONIO', 'LOYOLA', 'ARELLANO', '$2y$10$CN4ouxKNwA6uNT9podAWU.uz/wYMBJKL0qUlgTEwp.yvSsXm57052', '2', NULL, '0');
INSERT INTO usuario VALUES('253', '16292911-9', 'CINTHIA INÉS', 'MUÑOZ', 'HORMAZÁBAL', '$2y$10$RiadPOqY4r5FytdeTD2mwO5qcvoF1rfYomvoj0N4L4z6lpNKHIBcO', '2', '3', '1');
INSERT INTO usuario VALUES('254', '16418115-4', 'FRANCISCA', 'GAJARDO', 'NAVARRETE', '$2y$10$NXOscEZ9w4vmjdK17SmjvuJ32887MMn0YXbTHpJd/5NJDSH1x9Tea', '2', NULL, '0');
INSERT INTO usuario VALUES('255', '16463326-8', 'MARCELO PATRICIO', 'MORALES', 'MUÑOZ', '$2y$10$mMhciS4v2ZUIh0Geh5/mg.kLg34Udm/VF0v.zXOmav8OcOxyaB93q', '2', NULL, '1');
INSERT INTO usuario VALUES('257', '16582871-2', 'NATALY DEL CARMEN', 'CERDA', 'LÓPEZ', '$2y$10$NnzU3yfZkfR.2kN4/22PGuVZgLh0TW21Slidh9EGqcp.P81vW998u', '2', NULL, '1');
INSERT INTO usuario VALUES('258', '17019740-2', 'BEATRIZ CAROLINA', 'LEPE', 'NEGRETE', '$2y$10$vcZhox9v.elDyTf.93nNOuhfzMPo9EkcCn3HKk4ZFOV8MTONutwqC', '2', NULL, '1');
INSERT INTO usuario VALUES('259', '17145508-1', 'EVA ROSA', 'SALGADO', 'SEPÚLVEDA', '$2y$10$zBOjFuzIG0SBuGB/8DIEh.FkLZHwW8pr6LWoZYpzd0WUwOA8cHRlO', '1', '58', '1');
INSERT INTO usuario VALUES('260', '17145894-3', 'CARLOS FELIPE', 'CÁRDENAS', 'FRIZ', '$2y$10$JhqtR/qJbLunWJNMLJuG2uJWXNydQJl8OkSFpEQdrVkg6FpigQ6W6', '2', '9', '1');
INSERT INTO usuario VALUES('261', '17410202-3', 'FELIPE ANDRÉS', 'MOYA', 'FAÚNDEZ', '$2y$10$kYJxY5C6W7Z9zKvSA94Xve74nJTxrTKSkJibAr.c8olOujhlN5xjK', '2', NULL, '1');
INSERT INTO usuario VALUES('262', '17669941-8', 'CATALINA CONSTANZA', 'TORRES', 'HERNÁNDEZ', '$2y$10$GKJYFX8z7aBfeBttJ.jzGuCdAHpmxRkZevavetWAtseSLK5oZZBuG', '2', NULL, '1');
INSERT INTO usuario VALUES('263', '17855376-3', 'ALICIA PAULINA', 'VEGA', 'GARCÍA', '$2y$10$1eKVLUomA23TcKPIqYTku.KCk7FdUUeGsppOdd6ikzm5ee0UyIRoK', '2', NULL, '1');
INSERT INTO usuario VALUES('264', '18202473-2', 'PAULA BEATRIZ INÉS', 'ORELLANA', 'ORELLANA', '$2y$10$THvjrWuLZzlKNhvx4iDTm.IMrpXV.nMQMCNe4h7gZR7sxAOnL1qhq', '2', NULL, '1');
INSERT INTO usuario VALUES('265', '18203061-9', 'BYRON ENRIQUE', 'CANCINO', 'RECABARREN', '$2y$10$pA8lNyBIjwloyzFpM8O9teHr5kxN70aRAMYiV2zFpA9o21k/gjMi.', '2', NULL, '1');
INSERT INTO usuario VALUES('266', '18222318-2', 'ALEX RODRIGO', 'ESCOBAR', 'FLORES', '$2y$10$WihK5Mt.g4cc3kif8W9T9uXw5HT/txiqxFC4AoGn1LORdGu7Nr9Qu', '2', '10', '1');
INSERT INTO usuario VALUES('267', '18283791-1', 'MARLYS ALEJANDRA', 'MORA', 'VALENZUELA', '$2y$10$CmFHJaSUnfk1MZy8DBp0OuFEcUR4ZAe3rUX6ZSafULpd35jA6ux3a', '2', '4', '1');
INSERT INTO usuario VALUES('268', '18519974-6', 'SOLANGE ESCARLET', 'MOYA', 'BUSTOS', '$2y$10$K8GhcFmfaf5lPcg/Rd2vMeU0.KHHuiOTGTLgVSskmCS1DYayIPZ3m', '2', NULL, '1');
INSERT INTO usuario VALUES('269', '19097205-4', 'EDGARD FELIPE', 'SUAZO', 'MUÑOZ', '$2y$10$tJ3obOO.iF0RjOgmqw5wYugEJB56cLsKJkM7FjLrqqdmps90SS.0K', '2', '8', '1');
INSERT INTO usuario VALUES('270', '19939142-9', 'FRANCISCA ALEJANDRA', 'SOTO', 'MARTÍNEZ', '$2y$10$EZq1vzpeIeBALMdo6mSHHe6hPVXrzYo/FZ/sC1P2xKSxmyxacWXQ2', '2', NULL, '1');
INSERT INTO usuario VALUES('271', '8897921-4', 'RAQUEL ENCARNACIÓN', 'EULUFI', 'MEDEL', '$2y$10$opMAnWHCBtB2tpuYzFhsW.Z3qwG/HSBLMeo3SSWbQkhpzUAZV2sqG', '2', NULL, '1');
INSERT INTO usuario VALUES('272', '9461931-9', 'ELBA HELIA', 'BARRUETO', 'GARRO', '$2y$10$Li4MhXz302JjFUFi92gMGefIw2eQwlYCBpeqSNb4XwKZxWqpEbLL2', '1', NULL, '1');
INSERT INTO usuario VALUES('273', '9560280-0', 'ERIKA SUSANA', 'MERINO', 'BARRIENTOS', '$2y$10$t0k897HoCiI58mWG72eUG.d8g5vVpRP8k.6FrqlPokivFZ3auHjry', '2', '2', '1');
INSERT INTO usuario VALUES('274', '9739624-8', 'INÉS IVONNE', 'RODRÍGUEZ', 'CASTRO', '$2y$10$2vDF5mZtmZdCwNB.1pKOyuP3zZDNWypcWZKnXhvmvSJMbs0z45d/e', '2', NULL, '1');
INSERT INTO usuario VALUES('742', '12965368-k', 'ELENA ALEJANDRA', 'MUÑOZ', 'PALMA', '$2y$10$0qw9XXzB2TmlHTcAGOrhout.b1zQy6xdobewpQ7oVdzYkW6kf396q', '4', NULL, '1');
INSERT INTO usuario VALUES('743', '11767688-9', 'LAURA BEATRIZ DEL CARMEN', 'VÁSQUEZ', 'GONZÁLEZ', '$2y$10$NkWNETnPe/RDPN/kkLb1WeqYv9Wv15WEb/3XK75WWDXvZo8JksQrm', '4', NULL, '1');
INSERT INTO usuario VALUES('825', '16582845-3', 'EVELYN ANDREA', 'SALGADO', 'SALGADO', '$2y$10$L4Ept6dWg8J8cfzCFSyj1urSCGGaF.IsFeVHZabCSUOH8FC2a8XXG', '2', NULL, '1');
INSERT INTO usuario VALUES('861', '17145780-7', 'MASIEL ELIZABETH', 'RÍOS', 'SEPÚLVEDA', '$2y$10$h5o.8X46XKi8.Laz1Dng3O7eJL7wTVUUcxUpl0aWGSqrtqyC.jLbS', '8', NULL, '1');
INSERT INTO usuario VALUES('862', '11442943-0', 'ALVARITA DE LAS MERCEDES', 'MONRROI', 'GARCÍA', '$2y$10$CVq4qV31TdhTzTbwXpJO7OOAxhF.1NKMFqCI7TV.BTT5PZ5bgL4Wu', '8', NULL, '1');
INSERT INTO usuario VALUES('863', '16582890-9', 'CATALINA DE LOS ANGELES', 'JARA', 'RETAMAL', '$2y$10$V7sC4XhuH0m25jvCHS0/JuJDxn8MgwidIGjAFFnThKPzRlFdtB8m6', '8', NULL, '1');
INSERT INTO usuario VALUES('864', '13791425-5', 'MABEL ANGÉLICA', 'ITURRA', 'LARA', '$2y$10$tu5yhHNpSZ2ySKt7mYUG2OuFlLTNIEFUcwT3FegDVpkIy.0Gl3H02', '8', NULL, '1');
INSERT INTO usuario VALUES('865', '12965010-9', 'LORETO IRENE', 'YÁÑEZ', 'HERNÁNDEZ', '$2y$10$/ZNBDSsBnuOza1jeXdRMuuLS5NtT4sQvElKBpM7ByxDfJrHoGsqPu', '8', NULL, '1');
INSERT INTO usuario VALUES('866', '11288445-9', 'BETTY DEL PILAR', 'DURÁN', 'REBOLLEDO', '$2y$10$AsZ3d52d.85DhniQTMvFGuNQerxBjP5uIb2pPeQ.PPKVigVV81CyK', '8', NULL, '1');
INSERT INTO usuario VALUES('867', '11320674-8', 'JESICA ALEJANDRA', 'BAHAMONDES', 'MUÑOZ', '$2y$10$FtJIQT/Hpv2KOyAiat5VK.Q4ShiGmb8EZTuhA5XGxlvAlbfB1srKq', '8', NULL, '1');
INSERT INTO usuario VALUES('868', '15932477-k', 'VÍCTOR ARMANDO', 'YÁÑEZ', 'RAMÍREZ', '$2y$10$kyRStTWqd9Q7vgWaiC.fl.spyLPapF2tq7veM3YjHAbSk4IoEv2bS', '8', NULL, '1');
INSERT INTO usuario VALUES('869', '9311681-k', 'EDMUNDO PATRICIO', 'ESPINOSA', 'GATICA', '$2y$10$FoI/5CJyT1jUlsChgDrVneg7H5bXeTWGF5LTwKUXUqmuMmW2TCXdK', '8', NULL, '1');
INSERT INTO usuario VALUES('870', '11532807-7', 'PAOLA DOLORES ANDREA', 'QUINTANA', 'LEAL', '$2y$10$ELm2iw8jERxvffbgNYo/Eu1kMGcxWDXUhwcL8.zQipU99nhTJxAaK', '8', NULL, '1');
INSERT INTO usuario VALUES('871', '13791534-0', 'ANDREA DEL CARMEN', 'QUEVEDO', 'ALBORNOZ', '$2y$10$wkBHTiRvk/I2RNOpy9toCeWXhe/z5SaD50XewlLfO0L9pGNhs0Vz.', '8', NULL, '1');
INSERT INTO usuario VALUES('872', '16051076-5', 'JENNIFER MARICEL', 'VARELA', 'GARCÍA', '$2y$10$WtGr/e.siWAzxnfmf9G1IOEOcOb6bxm2SNXhxY3eoi4chATmpa0iO', '8', NULL, '1');
INSERT INTO usuario VALUES('873', '8997145-4', 'VERÓNICA DEL CARMEN', 'ALARCÓN', 'LEÓN', '$2y$10$iUtOn48CWHvP14zUIfbD3eVz32fKGmDJ1dBkf6Y8GK.GOXaw3qqIq', '8', NULL, '1');
INSERT INTO usuario VALUES('874', '18519560-0', 'JENIFER YANIRA', 'VALENZUELA', 'CANALES', '$2y$10$t3.QbrujqsBZlkZn2YcyvO0Ne32pnR3.CHv2p6t8W.521hb1hEsMa', '8', NULL, '1');
INSERT INTO usuario VALUES('875', '18202410-4', 'CAMILA VIVIANA LOURDES', 'SUÁREZ', 'LARENAS', '$2y$10$RFNwrxCKg5kdPGH/i6SLS.JGIoVq5rGwUoePqNl0t/HF9XT/Zwl5.', '8', NULL, '1');
INSERT INTO usuario VALUES('876', '15676251-2', 'JACQUELINNE DE LAS MERCEDES', 'LARA', 'DÍAZ', '$2y$10$HdmnLAG/pFA0b7ErXspgJeQWCUxM5HpXFmbOvh4Njo2ybKwQRDuOO', '8', NULL, '1');
INSERT INTO usuario VALUES('877', '18202414-7', 'CAMILO IGNACIO DE JESÚS', 'VÁSQUEZ', 'VÁSQUEZ', '$2y$10$tFla.6TSKN0IKzjNp.WYBeym5vuc.c6NDMK5PgMQ0C8iNr9VCjl7W', '8', NULL, '1');
INSERT INTO usuario VALUES('878', '11532405-5', 'ALBINA DEL CARMEN', 'ARAVENA', 'FUENTES', '$2y$10$6OOAQWKSiwxC.CRurLWYtuyRUNBN.b0Yb39KMWka823k1L7bnBzEa', '8', NULL, '1');
INSERT INTO usuario VALUES('879', '11288536-6', 'HUGO ALEJANDRO', 'URRUTIA', 'GALDAMES', '$2y$10$Vl23Sb61xqwtmQp7pVvx1eY8d/Hr2WvAxg253tFoxgeoT65GiPHKq', '8', NULL, '1');
INSERT INTO usuario VALUES('880', '10370210-0', 'MARÍA ELISA DE LAS ROSAS', 'ESPINOZA', 'YÉVENES', '$2y$10$tp6eVjB/XgAHlOx5gf.8h.nX6f2mKsFXeDz8Bxpm5P9DOBz2SjXie', '8', NULL, '1');
INSERT INTO usuario VALUES('881', '10039425-1', 'PATRICIA DEL ROSARIO', 'MORAGA', 'SANHUEZA', '$2y$10$kMxqjKT/f30l8lF0KExJp.DS8GfcMCeGGbcZyzPNHPDytSJSugpC.', '8', NULL, '1');
INSERT INTO usuario VALUES('882', '8444809-5', 'MARÍA ELENA', 'VALENZUELA', 'QUEVEDO', '$2y$10$P85N.BtsIOa8B4c/wykhAu.W5DUmmSpdINBn114hS0qJJt8NMbDl6', '8', NULL, '1');
INSERT INTO usuario VALUES('883', '13792166-9', 'MARISOL VALERIA', 'VALENZUELA', 'JARA', '$2y$10$O2.cVhhHxGCo46fIvkYdT.Whkmc9XhgqBFz9hd/5uf8ZBR7PUfM3u', '8', NULL, '1');
INSERT INTO usuario VALUES('884', '11767715-k', 'PABLA SONIA', 'CERDA', 'RIVERA', '$2y$10$GFD92A1MPsinq8TTcd3ZdO/BYdip.u6srbGKQcG0M8VZkah8v90Ai', '8', NULL, '1');
INSERT INTO usuario VALUES('885', '11532665-1', 'OLGA VALENTINA', 'SANDOVAL', 'PINILLA', '$2y$10$38EqxDIGG2GrzkR6CxD5SOCfdsnHJU3HHeST.YvL6ReyQt/vaS4ji', '8', NULL, '1');
INSERT INTO usuario VALUES('886', '18813181-6', 'MARCO IGNACIO', 'GUZMÁN', 'OÑATE', '$2y$10$2Vp1Y6GWV9dT0jBWd5/ShuQeNX9BRkvL/sBPBYXmAekDwqUTWXph2', '8', NULL, '1');
INSERT INTO usuario VALUES('887', '17251874-5', 'HEDDER BASTIÁN', 'REYES', 'CÁCERES', '$2y$10$qxcVsIYhw/XW.51Pj.Vz0uf3bTH6uj39MnH8Fw5pwlOCl0.nCMTce', '8', NULL, '1');
INSERT INTO usuario VALUES('888', '23477985-0', 'ANDRES FELIPE', 'TORRES', 'PALMA', '$2y$10$QkhISc9.irAiQed2srcbfuwC7HazqqLgjAFjFq.JSAjVHiW3RGmyO', '8', NULL, '1');
INSERT INTO usuario VALUES('889', '16583368-6', 'VANESSA IRIS', 'ORELLANA', 'ORELLANA', '$2y$10$M.R27MuPoOrvYWqnYbKAY.6lVO6VxW5keyxD3jZWum1NzYcaPX63m', '8', NULL, '1');
INSERT INTO usuario VALUES('890', '21077345-2', 'YAMILET ALEXANDRA', 'LUNA', 'FRÍAS', '$2y$10$.fTQ4hUKKogYrIzhSK4zG.7/NSp6rhVatAE2yxiSu1H.U0VkN2Dw6', '8', NULL, '1');
INSERT INTO usuario VALUES('891', '19939324-3', 'MICHELLE ALEJANDRA', 'DOMÍNGUEZ', 'DOMÍNGUEZ', '$2y$10$YFrd8KMIAJR9ctGB9.duR.N0oWEaMsAteKCj7Nq9J9zqNsN4//Ydy', '8', NULL, '1');
INSERT INTO usuario VALUES('892', '18520254-2', 'JOCELIN ALEJANDRA', 'ORELLANA', 'MEZA', '$2y$10$QPqJU58j0rXvy.ZVbWBy3e2NMatWJj59TR43BHhfseHiR6bul5pze', '8', NULL, '1');
INSERT INTO usuario VALUES('893', '12317747-9', 'MARÍA FRANCISCA', 'IRIGOYEN', 'GONZÁLEZ', '$2y$10$72X.JNorJVb8h6v.5vCkNuAURYlzUdOOLjNOSUbmcUnuUBWEJGPLC', '8', NULL, '1');
INSERT INTO usuario VALUES('894', '17410305-4', 'JUAN EDUARDO', 'SALAZAR', 'SAN MARTÍN', '$2y$10$hG7Y00oqCDx8ULTZQN5RVuNre.WyVshNsMxaYsYa981hBeM.a62sa', '8', NULL, '1');
INSERT INTO usuario VALUES('895', '10182464-0', 'CLAUDIO ANTONIO', 'INZUNZA', 'YÁÑEZ', '$2y$10$vWAzk8l2xkj0FSfg.7H8PetZj9d486Mze.64hQBAQKVrrHy/MxOdq', '8', NULL, '1');
INSERT INTO usuario VALUES('896', '13881962-0', 'KATHERINE JOANNA', 'TRONCOSO', 'LATIN', '$2y$10$1BaFqflj6ZeweDpqep4dEOmwmFqrhhcFuCGKr97xv8v4lCw9D6CS6', '8', NULL, '1');
INSERT INTO usuario VALUES('897', '17145527-8', 'YESENIA MASIEL', 'ARRIAGADA', 'ALVEAR', '$2y$10$t2pX8LDWwBB8K2FNRCA2xuBj76pyNvcqUrfcXjLpY0SsPtkq2ag7G', '8', NULL, '1');
INSERT INTO usuario VALUES('898', '8010237-2', 'HAROLD HUGO', 'ZAMBRANO', 'GONZÁLEZ', '$2y$10$KRMVuyYfcUrJv2UbSCTqWuE1rq9.JrJVZZVgs4Du9Og5i8rJx57lG', '8', NULL, '1');
INSERT INTO usuario VALUES('899', '13614545-2', 'DANISA BÁRBARA', 'HERNÁNDEZ', 'VILLEGAS', '$2y$10$68b0.jGqAu.62dyGGMwXtO6MblOO6g3cKqa5VOMbqq7BvgDHXKFnC', '8', NULL, '1');
INSERT INTO usuario VALUES('900', '20274156-8', 'YANIS MABEL', 'HORMAZÁBAL', 'VERDUGO', '$2y$10$EQ7k4k5O59S0NJRYaieg6eSvDo.R6L/tgO/ha3/AASQLjDBHeM23m', '8', NULL, '1');
INSERT INTO usuario VALUES('901', '16904843-6', 'MARÍA DEL PILAR', 'PARRA', 'MOLINA', '$2y$10$nh0zdvm/UNQaX/JBea3pw.pGu2dhfBzfHgwq/5tU0LRyjy4k5vVz2', '8', NULL, '1');
INSERT INTO usuario VALUES('902', '12008813-0', 'GLADYS JACQUELINNE DEL CARMEN', 'VERA', 'GUTIÉRREZ', '$2y$10$3QNRJQ7IdTdCKblWMk8Jce1zcR/buCzrb1cHxsDrhNYFPjCS4nBXW', '8', NULL, '1');
INSERT INTO usuario VALUES('903', '19060207-9', 'VALERIA SCARLETH', 'RECABAL', 'VERGARA', '$2y$10$PbeuLkqyPmYd/xpgfL1P4u.Sg8oaGSWhunaOfmsaw.pBps4w7zL12', '8', NULL, '1');
INSERT INTO usuario VALUES('904', '17145410-7', 'PAULINA ROSA DEL CARMEN', 'SALAZAR', 'ARAVENA', '$2y$10$XkX3auHzUaq11riqi/KeqemP9NUg/qnP6VHUJyN12zjLknfnm5B1K', '8', NULL, '1');
INSERT INTO usuario VALUES('905', '16679051-4', 'NATALY ANDREA', 'RIQUELME', 'MUÑOZ', '$2y$10$Lwu.b8lCKpniWiXy0MBoEe5t4.Cr/l39t.B25wQtVZ/fmpXsrAQZq', '8', NULL, '1');
INSERT INTO usuario VALUES('906', '19767030-4', 'KATERIN ANDREA DANIELA', 'VILLEGAS', 'VILLEGAS', '$2y$10$3y0ZSoDCNtCzFds4BhPy0uL/1z3RmemA.GzK4Y7WkjMdpo6ghUg/2', '8', NULL, '1');
INSERT INTO usuario VALUES('907', '10498078-3', 'BENITA DEL CARMEN', 'ORELLANA', 'PEÑAILILLO', '$2y$10$TiDALo/SvlON1nLA3I2uyOmdguunVzWwL.WgyYg1rKfJujHa.6wsu', '8', NULL, '1');
INSERT INTO usuario VALUES('908', '14057022-2', 'LUZ ARIANA', 'DÍAZ', 'MUÑOZ', '$2y$10$aCcEhFk3TEVw4VTR0tXP5eSz5M7G/gqpZdnbkG.ze5Dz2jRluReRi', '8', NULL, '1');
INSERT INTO usuario VALUES('911', '10894871-k', 'ALICIA ELENA', 'GOMEZ', 'CHAVEZ', '$2y$10$75LTPWe0hZOPgw0BkZ6UA.UEgeDUAMazjkTfbcEoU63JW4pgTqoFG', '8', NULL, '1');
INSERT INTO usuario VALUES('945', '11768379-6', 'JOSÉ PATRICIO', 'SEPÚLVEDA', 'VELOZO', '$2y$10$EcSjTLRNcd55k5JaOOox4e4gDj7Dr3mgfB6Gha4bAfhn0B.gdKL.O', '2', NULL, '1');
INSERT INTO usuario VALUES('1373', '15755367-4', 'TAMARA ANDREA', 'JAQUE', 'VALLADARES', '$2y$10$7xMjD55Pmhg0wPWziAvyY.a0wvSJ9mL0frPitOI9IZB1dsq676B4S', '2', NULL, '1');
INSERT INTO usuario VALUES('1374', '27373916-5', 'MAURICE IGNACIO', 'ALARCÓN', 'SUAZO', '0', '3', '49', '1');
INSERT INTO usuario VALUES('1375', '27465153-9', 'TRINIDAD ANTONIA', 'ARAVENA', 'LUNA', '0', '3', '49', '1');
INSERT INTO usuario VALUES('1376', '27300139-5', 'BENJAMÍN IGNACIO', 'CIFUENTES', 'ORELLANA', '0', '3', '49', '1');
INSERT INTO usuario VALUES('1377', '27448418-7', 'WILSAELLE', 'DESCARTES', 'PAULIDOR', '0', '3', '49', '1');
INSERT INTO usuario VALUES('1378', '27410923-8', 'MARTÍN ALONSO', 'DÍAZ', 'PEÑAILILLO', '0', '3', '49', '1');
INSERT INTO usuario VALUES('1379', '27471280-5', 'JEANS LOUIS AARON', 'DONOSO', 'DÍAZ', '0', '3', '49', '1');
INSERT INTO usuario VALUES('1380', '27329738-3', 'AGUSTÍN IGNACIO', 'FUENTES', 'BARRUETO', '0', '3', '49', '1');
INSERT INTO usuario VALUES('1381', '27466355-3', 'MAITE AYLEN', 'GALLARDO', 'ALARCÓN', '0', '3', '49', '1');
INSERT INTO usuario VALUES('1382', '27468450-K', 'SOFÍA ELENA', 'GARCÍA', 'SEPÚLVEDA', '0', '3', '49', '1');
INSERT INTO usuario VALUES('1383', '27312709-7', 'LAURA ISABELLA', 'GODOY', 'MOYA', '0', '3', '49', '1');
INSERT INTO usuario VALUES('1384', '27289419-1', 'JESÚS ANTONIO', 'HERRERA', 'MORAGA', '0', '3', '49', '1');
INSERT INTO usuario VALUES('1385', '27470384-9', 'MARTINA ALESSANDRA', 'ILLANES', 'ROMERO', '0', '3', '49', '1');
INSERT INTO usuario VALUES('1386', '27495422-1', 'SOFÍA ANTONIA', 'LANDEROS', 'RUIZ', '0', '3', '49', '1');
INSERT INTO usuario VALUES('1387', '27486065-0', 'MAITHE ELIANIS', 'LEAL', 'MUÑOZ', '0', '3', '49', '1');
INSERT INTO usuario VALUES('1388', '27358091-3', 'AMANDA TRINIDAD', 'MOLINA', 'VEGA', '0', '3', '49', '1');
INSERT INTO usuario VALUES('1389', '27274309-6', 'JULIETTE ANTONIA', 'MORA', 'ROMERO', '0', '3', '49', '1');
INSERT INTO usuario VALUES('1390', '27433693-5', 'MIKEILA ALEXANDRA', 'MORAGA', 'VÁSQUEZ', '0', '3', '49', '1');
INSERT INTO usuario VALUES('1391', '27327360-3', 'MONTSERRAT ANTONIA', 'MOYA', 'OSES', '0', '3', '49', '1');
INSERT INTO usuario VALUES('1392', '27264621-K', 'IGNACIA PAULINA', 'REYES', 'RAMOS', '0', '3', '49', '1');
INSERT INTO usuario VALUES('1393', '27416603-7', 'AGUSTINA ISIDORA', 'SEPÚLVEDA', 'OSORES', '0', '3', '49', '1');
INSERT INTO usuario VALUES('1394', '27490252-3', 'TOMÁS IGNACIO', 'SUAZO', 'ESPINOSA', '0', '3', '49', '1');
INSERT INTO usuario VALUES('1395', '27282985-3', 'CATALINA DE LOS ANGELES', 'YÁÑEZ', 'TAPIA', '0', '3', '49', '1');
INSERT INTO usuario VALUES('1396', '27366190-5', 'ALMENDRA ELIZABETH', 'ZÚÑIGA', 'JARA', '0', '3', '49', '1');
INSERT INTO usuario VALUES('1397', '26926374-1', 'MAXIMILIANO TOMÁS', 'ARELLANO', 'ALLENDES', '0', '3', '50', '1');
INSERT INTO usuario VALUES('1398', '27037385-2', 'JOHN ALEXANDER', 'AYALA', 'JARA', '0', '3', '50', '1');
INSERT INTO usuario VALUES('1399', '27104735-5', 'LIAN ANDRÉS', 'BRAVO', 'ACUÑA', '0', '3', '50', '1');
INSERT INTO usuario VALUES('1400', '27230804-7', 'MOISÉS VICENTE', 'BRIONES', 'CHAPA', '0', '3', '50', '1');
INSERT INTO usuario VALUES('1401', '27159520-4', 'AIMARA PAZ', 'CÁCERES', 'CASTRO', '0', '3', '50', '1');
INSERT INTO usuario VALUES('1402', '26803346-7', 'EMMA CLAIRE', 'CARO', 'RÍOS', '0', '3', '50', '1');
INSERT INTO usuario VALUES('1403', '27043456-8', 'AGUSTINA EMILIA', 'CASTILLO', 'ANRÍQUEZ', '0', '3', '50', '1');
INSERT INTO usuario VALUES('1404', '27101602-6', 'JOSÉ MARTÍN', 'CHAVEZ', 'ARTEAGA', '0', '3', '50', '1');
INSERT INTO usuario VALUES('1405', '26977570-K', 'ADHASSA MARITZA', 'GERARD', 'LAURENT', '0', '3', '50', '1');
INSERT INTO usuario VALUES('1406', '27079633-8', 'ZOE ANAÍS', 'GÓMEZ', 'HERNÁNDEZ', '0', '3', '50', '1');
INSERT INTO usuario VALUES('1407', '27210939-7', 'TRINIDAD DEL CARMEN', 'HENRÍQUEZ', 'ORELLANA', '0', '3', '50', '1');
INSERT INTO usuario VALUES('1408', '27058731-3', 'TRINIDAD IGNACIA', 'JARA', 'VILLEGAS', '0', '3', '50', '1');
INSERT INTO usuario VALUES('1409', '26867757-7', 'SANTI EMILIANO', 'LA ROSA', 'SUÁREZ', '0', '3', '50', '1');
INSERT INTO usuario VALUES('1410', '100654818-7', 'MATIAS', 'LAURSEN', 'PAREDES', '0', '3', '50', '1');
INSERT INTO usuario VALUES('1411', '26815522-8', 'BRUNO ALEXSANDER', 'MENDOZA', 'HORMAZÁBAL', '0', '3', '50', '1');
INSERT INTO usuario VALUES('1412', '27195679-7', 'IDARA RACHEEL', 'NAVARRO', 'URETA', '0', '3', '50', '1');
INSERT INTO usuario VALUES('1413', '26927391-7', 'VALENTINA ANAÍS', 'SÁNCHEZ', 'SALGADO', '0', '3', '50', '1');
INSERT INTO usuario VALUES('1414', '26970844-1', 'IBRAHIM ANDRÉS', 'VACA', 'VALENZUELA', '0', '3', '50', '1');
INSERT INTO usuario VALUES('1415', '27170632-4', 'TOMÁS ANTONIO', 'VELOZO', 'VALENZUELA', '0', '3', '50', '1');
INSERT INTO usuario VALUES('1416', '26828114-2', 'THIAGO ALONSO', 'ACUÑA', 'CANCINO', '0', '3', '51', '1');
INSERT INTO usuario VALUES('1417', '26815694-1', 'LUCIANO NICOLÁS', 'ARELLANO', 'ROJAS', '0', '3', '51', '1');
INSERT INTO usuario VALUES('1418', '27237879-7', 'BENJAMÍN THOMAS', 'CÁCERES', 'PEDRAZA', '0', '3', '51', '1');
INSERT INTO usuario VALUES('1419', '27239825-9', 'ESPERANZA MARLENE', 'LARA', 'ARAVENA', '0', '3', '51', '1');
INSERT INTO usuario VALUES('1420', '27048267-8', 'MAXIMILIANO ANDRÉS', 'MADRID', 'MENA', '0', '3', '51', '1');
INSERT INTO usuario VALUES('1421', '26923372-9', 'AGUSTÍN ISAAC', 'MOYA', 'RIVAS', '0', '3', '51', '1');
INSERT INTO usuario VALUES('1422', '26827033-7', 'AYNARA MONSERRAT JOSÉ', 'MUÑOZ', 'ARAVENA', '0', '3', '51', '1');
INSERT INTO usuario VALUES('1423', '26896416-9', 'SEBASTIÁN ANDRÉS', 'PARRA', 'GARCÍA', '0', '3', '51', '1');
INSERT INTO usuario VALUES('1424', '26925633-8', 'EDITA ANTONELA', 'RÍOS', 'DOMKE', '0', '3', '51', '1');
INSERT INTO usuario VALUES('1425', '27258182-7', 'DAYRA ARLETTE', 'ROCHA', 'HENRÍQUEZ', '0', '3', '51', '1');
INSERT INTO usuario VALUES('1426', '26894123-1', 'KASSANDRA ARLETTE', 'SAAVEDRA', 'REYES', '0', '3', '51', '1');
INSERT INTO usuario VALUES('1427', '26793374-K', 'HÉCTOR NICOLÁS', 'SALGADO', 'ITURRA', '0', '3', '51', '1');
INSERT INTO usuario VALUES('1428', '26940428-0', 'MATEO EMILIO', 'VELOZO', 'ROLDÁN', '0', '3', '51', '1');
INSERT INTO usuario VALUES('1429', '26761694-9', 'PEDRO ARIEL', 'ALARCÓN', 'SUAZO', '0', '3', '52', '1');
INSERT INTO usuario VALUES('1430', '26673110-8', 'ISABELLA ALMENDRA', 'ALARCÓN', 'VILLEGAS', '0', '3', '52', '1');
INSERT INTO usuario VALUES('1431', '26700346-7', 'AGUSTÍN ATALIVAR', 'ALARCÓN', 'YÁÑEZ', '0', '3', '52', '1');
INSERT INTO usuario VALUES('1432', '26723160-5', 'MARTÍN ANDRÉS', 'ARAVENA', 'HORMAZÁBAL', '0', '3', '52', '1');
INSERT INTO usuario VALUES('1433', '26720376-8', 'BIANCA ALEXANDRA', 'ESPINOZA', 'BUSTOS', '0', '3', '52', '1');
INSERT INTO usuario VALUES('1434', '26422941-3', 'VICENTE GIOVANNI', 'FAÚNDEZ', 'MACAYA', '0', '3', '52', '1');
INSERT INTO usuario VALUES('1435', '26248398-3', 'AMANDA CATALELLA PASCALE', 'FAÚNDEZ', 'PÉREZ', '0', '3', '52', '1');
INSERT INTO usuario VALUES('1436', '26594453-1', 'AGUSTÍN ALEJANDRO', 'FUENTES', 'JARA', '0', '3', '52', '1');
INSERT INTO usuario VALUES('1437', '26418058-9', 'CATALINA ESTER', 'GALLARDO', 'LÓPEZ', '0', '3', '52', '1');
INSERT INTO usuario VALUES('1438', '26217175-2', 'MAXIMILIANO ELÍAS', 'GARCÍA', 'HORMAZÁBAL', '0', '3', '52', '1');
INSERT INTO usuario VALUES('1439', '26372505-0', 'EDUARDO ALFREDO', 'GÓMEZ', 'SOTO', '0', '3', '52', '1');
INSERT INTO usuario VALUES('1440', '26336306-K', 'NOELIA MARIANA', 'GONZÁLEZ', 'CASANOVA', '0', '3', '52', '1');
INSERT INTO usuario VALUES('1441', '26571323-8', 'VALENTINA IGNACIA', 'GUTIÉRREZ', 'HORMAZÁBAL', '0', '3', '52', '1');
INSERT INTO usuario VALUES('1442', '26727103-8', 'VALENTINA ANAÍS', 'HORMAZÁBAL', 'ÁVILA', '0', '3', '52', '1');
INSERT INTO usuario VALUES('1443', '26245420-7', 'AMPARO ANTONIA', 'HORMAZÁBAL', 'CASTILLO', '0', '3', '52', '1');
INSERT INTO usuario VALUES('1444', '26743926-5', 'IMMAY AYELEN', 'MARTÍNEZ', 'URTUBIA', '0', '3', '52', '1');
INSERT INTO usuario VALUES('1445', '26581894-3', 'BENJAMÍN EDUARDO', 'MERINO', 'GALLARDO', '0', '3', '52', '1');
INSERT INTO usuario VALUES('1446', '26412274-0', 'MARIANA POLETT', 'TORRES', 'VILLEGAS', '0', '3', '52', '1');
INSERT INTO usuario VALUES('1447', '26751919-6', 'JOSEFA PAOLA', 'VEGA', 'VEGA', '0', '3', '52', '1');
INSERT INTO usuario VALUES('1448', '26232674-8', 'KIARA INES', 'ALARCÓN', 'FONSECA', '0', '3', '53', '1');
INSERT INTO usuario VALUES('1449', '26686765-4', 'GABRIEL IGNACIO ALONSO', 'ALVARADO', 'TORRES', '0', '3', '53', '1');
INSERT INTO usuario VALUES('1450', '26378835-4', 'LUCIANA ANTONIA', 'ARELLANO', 'JARA', '0', '3', '53', '1');
INSERT INTO usuario VALUES('1451', '26391350-7', 'TOMÁS ALEJANDRO', 'DÍAZ', 'HERRERA', '0', '3', '53', '1');
INSERT INTO usuario VALUES('1452', '26490961-9', 'MARTIN ANDRES', 'ESCOBEDO', 'PARRA', '0', '3', '53', '1');
INSERT INTO usuario VALUES('1453', '26604931-5', 'ÁMBAR ISABEL', 'FRIZ', 'MORAGA', '0', '3', '53', '1');
INSERT INTO usuario VALUES('1454', '26739004-5', 'DYLAN ANTONIO', 'GALLARDO', 'ALARCÓN', '0', '3', '53', '1');
INSERT INTO usuario VALUES('1455', '26713696-3', 'TOMÁS MAXIMILIANO', 'GÓMEZ', 'CASTILLO', '0', '3', '53', '1');
INSERT INTO usuario VALUES('1456', '26587558-0', 'EMILIO NICOLÁS ANDRÉS', 'LEÓN', 'RECABAL', '0', '3', '53', '1');
INSERT INTO usuario VALUES('1457', '26282067-K', 'EDUARD IGNACIO', 'MOYA', 'MORAGA', '0', '3', '53', '1');
INSERT INTO usuario VALUES('1458', '26215718-0', 'YESSICA ANTONELA', 'PACHECO', 'MADRID', '0', '3', '53', '1');
INSERT INTO usuario VALUES('1459', '26516393-9', 'ALISON ANAÍS', 'PACHECO', 'OVIEDO', '0', '3', '53', '1');
INSERT INTO usuario VALUES('1460', '26254388-9', 'AYLIN ANTONELA', 'QUINTANA', 'YÉVENES', '0', '3', '53', '1');
INSERT INTO usuario VALUES('1461', '26289472-K', 'YADIEL ANTONIO', 'RETAMAL', 'SOTO', '0', '3', '53', '1');
INSERT INTO usuario VALUES('1462', '26497286-8', 'MIA ANTONELLA', 'ROJAS', 'PACHECO', '0', '3', '53', '1');
INSERT INTO usuario VALUES('1463', '26393770-8', 'JOSÉ TOMÁS', 'ROJAS', 'YÁÑEZ', '0', '3', '53', '1');
INSERT INTO usuario VALUES('1464', '26448754-4', 'EMILIA BELÉN', 'SÁNCHEZ', 'SALAZAR', '0', '3', '53', '1');
INSERT INTO usuario VALUES('1465', '26228688-6', 'EMILY ANAÍS', 'SUAZO', 'ANDRADES', '0', '3', '53', '1');
INSERT INTO usuario VALUES('1466', '26206046-2', 'JOSEFINA IGNACIA', 'SUAZO', 'CORTÉS', '0', '3', '53', '1');
INSERT INTO usuario VALUES('1467', '26626380-5', 'CELESTE CATALINA', 'ZÚÑIGA', 'JARA', '0', '3', '53', '1');
INSERT INTO usuario VALUES('1468', '25794199-K', 'DELFINA IGNACIA', 'ACUÑA', 'BARRERA', '0', '3', '54', '1');
INSERT INTO usuario VALUES('1469', '26130783-9', 'MARTÍN ALEJANDRO', 'ALARCÓN', 'REYES', '0', '3', '54', '1');
INSERT INTO usuario VALUES('1470', '25989596-0', 'GÉNESIS SARAI', 'ARELLANO', 'DÍAZ', '0', '3', '54', '1');
INSERT INTO usuario VALUES('1471', '25707197-9', 'VICENTE ANTONIO', 'BRAVO', 'SUAZO', '0', '3', '54', '1');
INSERT INTO usuario VALUES('1472', '25813471-0', 'PAZ TRINIDAD', 'CANCINO', 'PARRA', '0', '3', '54', '1');
INSERT INTO usuario VALUES('1473', '25841484-5', 'FELIPE ANDRÉS', 'CARRASCO', 'VELOSO', '0', '3', '54', '1');
INSERT INTO usuario VALUES('1474', '25909295-7', 'ALEXANDER PIERO', 'CASTILLO', 'SALGADO', '0', '3', '54', '1');
INSERT INTO usuario VALUES('1475', '25884266-9', 'MIA ISABELLA', 'ESPINOZA', 'BRAVO', '0', '3', '54', '1');
INSERT INTO usuario VALUES('1476', '25812438-3', 'FELIPE IGNACIO', 'ESPINOZA', 'CARVAJAL', '0', '3', '54', '1');
INSERT INTO usuario VALUES('1477', '25932022-4', 'MARTINA IGNACIA', 'GARCÍA', 'ÁVILA', '0', '3', '54', '1');
INSERT INTO usuario VALUES('1478', '26138881-2', 'CRISTIAN FRANCISCO', 'GARCÍA', 'RÍOS', '0', '3', '54', '1');
INSERT INTO usuario VALUES('1479', '25764997-0', 'NICOLETTE AMARAL', 'GÓMEZ', 'SOTO', '0', '3', '54', '1');
INSERT INTO usuario VALUES('1480', '25770731-8', 'MADELAINE IGNACIA', 'JARA', 'SOTO', '0', '3', '54', '1');
INSERT INTO usuario VALUES('1481', '25941112-2', 'SOFÍA AGUSTINA', 'LARA', 'CASTILLO', '0', '3', '54', '1');
INSERT INTO usuario VALUES('1482', '25814463-5', 'MAILEN ALAIA', 'MARTÍNEZ', 'URTUBIA', '0', '3', '54', '1');
INSERT INTO usuario VALUES('1483', '25919908-5', 'LISSETTE HELENA GERALDINE', 'MORA', 'PÉREZ', '0', '3', '54', '1');
INSERT INTO usuario VALUES('1484', '26044766-1', 'MAXIMILIANO ANDRÉS', 'MORAGA', 'SOTO', '0', '3', '54', '1');
INSERT INTO usuario VALUES('1485', '25915860-5', 'RAFAEL IGNACIO', 'MORENO', 'FUENTES', '0', '3', '54', '1');
INSERT INTO usuario VALUES('1486', '25969320-9', 'ISIDORA ANTONELLA', 'OLIVOS', 'PÉREZ', '0', '3', '54', '1');
INSERT INTO usuario VALUES('1487', '26018002-9', 'BELÉN ANDREA', 'ORELLANA', 'FUENZALIDA', '0', '3', '54', '1');
INSERT INTO usuario VALUES('1488', '25804358-8', 'ALEXANDER ARTURO', 'PINEDA', 'MORA', '0', '3', '54', '1');
INSERT INTO usuario VALUES('1489', '25868885-6', 'AMANDA MARTINA', 'RETAMAL', 'YÁÑEZ', '0', '3', '54', '1');
INSERT INTO usuario VALUES('1490', '25869631-K', 'MAXIMILIANO IGNACIO', 'RODRÍGUEZ', 'ZÚÑIGA', '0', '3', '54', '1');
INSERT INTO usuario VALUES('1491', '26190478-0', 'TOMÁS ALONSO', 'SALGADO', 'RIVEROS', '0', '3', '54', '1');
INSERT INTO usuario VALUES('1492', '26028173-9', 'YASMÍN VALENTINA', 'SÁNCHEZ', 'SAAVEDRA', '0', '3', '54', '1');
INSERT INTO usuario VALUES('1493', '26017669-2', 'ESTEBAN LEONARDO', 'SAN MARTÍN', 'MUÑOZ', '0', '3', '54', '1');
INSERT INTO usuario VALUES('1494', '26092459-1', 'MATEO EDUARDO', 'TEJEDA', 'JARA', '0', '3', '54', '1');
INSERT INTO usuario VALUES('1495', '25745651-K', 'JOEL RODRIGO', 'TORRES', 'FUENTES', '0', '3', '54', '1');
INSERT INTO usuario VALUES('1496', '25809870-6', 'FLORENCIA SCARLET', 'VEGA', 'CASTILLO', '0', '3', '54', '1');
INSERT INTO usuario VALUES('1497', '25954562-5', 'AGUSTINA EMILIA', 'VEGA', 'VEGA', '0', '3', '54', '1');
INSERT INTO usuario VALUES('1498', '26045404-8', 'EMILIO JAVIER', 'VEGA', 'VEGA', '0', '3', '54', '1');
INSERT INTO usuario VALUES('1499', '25861828-9', 'FLORENCIA FRANCESCA', 'VELOZO', 'HENRÍQUEZ', '0', '3', '54', '1');
INSERT INTO usuario VALUES('1500', '25748144-1', 'YOMARA MARCELA', 'VILLEGAS', 'ESPINOSA', '0', '3', '54', '1');
INSERT INTO usuario VALUES('1501', '25460388-0', 'MATEO IGNACIO', 'ARAVENA', 'RECABAL', '0', '3', '55', '1');
INSERT INTO usuario VALUES('1502', '25394820-5', 'MAXIMILIANO', 'BLANCO', 'CASTILLO', '0', '3', '55', '1');
INSERT INTO usuario VALUES('1503', '25692491-9', 'MAXIMILIANO IGNACIO', 'BUSTOS', 'TORRES', '0', '3', '55', '1');
INSERT INTO usuario VALUES('1504', '25381223-0', 'JULIÁN ELÍAS', 'CABRERA', 'JARA', '0', '3', '55', '1');
INSERT INTO usuario VALUES('1505', '25722260-8', 'GASPAR EMILIANO', 'CÁCERES', 'HORMAZÁBAL', '0', '3', '55', '1');
INSERT INTO usuario VALUES('1506', '25531131-K', 'STEFFIE IGNACIA', 'CORNEJO', 'CONTRERAS', '0', '3', '55', '1');
INSERT INTO usuario VALUES('1507', '25437512-8', 'BRUNO ALEJANDRO', 'DÍAZ', 'MARTÍNEZ', '0', '3', '55', '1');
INSERT INTO usuario VALUES('1508', '25463062-4', 'DIEGO FRANCISCO', 'DONOSO', 'CANCINO', '0', '3', '55', '1');
INSERT INTO usuario VALUES('1509', '25448946-8', 'ALLYS ANTONELLA', 'ESPINOZA', 'BARRUETO', '0', '3', '55', '1');
INSERT INTO usuario VALUES('1510', '25413467-8', 'CRISTOFER ALEXANDER', 'FAÚNDEZ', 'PÉREZ', '0', '3', '55', '1');
INSERT INTO usuario VALUES('1511', '25368732-0', 'RODRIGO MAXIMILIANO', 'GARRIDO', 'LARA', '0', '3', '55', '1');
INSERT INTO usuario VALUES('1512', '25717349-6', 'FABIÁN IGNACIO', 'ILUFI', 'GARCÍA', '0', '3', '55', '1');
INSERT INTO usuario VALUES('1513', '25677680-4', 'SOFÍA ANTONELLA', 'LARA', 'ARAVENA', '0', '3', '55', '1');
INSERT INTO usuario VALUES('1514', '25597332-0', 'VALENTINA DENISSE', 'LEAL', 'MUÑOZ', '0', '3', '55', '1');
INSERT INTO usuario VALUES('1515', '25631670-6', 'BERNARDITA ANDREA', 'MENDOZA', 'HORMAZÁBAL', '0', '3', '55', '1');
INSERT INTO usuario VALUES('1516', '25391710-5', 'JOSÉ FERNANDO', 'MORAGA', 'ESPINOSA', '0', '3', '55', '1');
INSERT INTO usuario VALUES('1517', '25414389-8', 'FABIÁN ALEJANDRO', 'MUÑOZ', 'OSES', '0', '3', '55', '1');
INSERT INTO usuario VALUES('1518', '25466193-7', 'JOAQUÍN CRISTÓBAL', 'SEPÚLVEDA', 'PADILLA', '0', '3', '55', '1');
INSERT INTO usuario VALUES('1519', '25557893-6', 'BENJAMÍN JESÚS', 'SOLÍS', 'RIQUELME', '0', '3', '55', '1');
INSERT INTO usuario VALUES('1520', '25637833-7', 'PEDRO ALEXANDER', 'TORRES', 'FAÚNDEZ', '0', '3', '55', '1');
INSERT INTO usuario VALUES('1521', '25512630-K', 'ISIDORA IGNACIA', 'YÁÑEZ', 'CONSTENLA', '0', '3', '55', '1');
INSERT INTO usuario VALUES('1522', '25566517-0', 'EMILY ALEXANDRA', 'ARAVENA', 'TORRES', '0', '3', '56', '1');
INSERT INTO usuario VALUES('1523', '25359667-8', 'DOMINIQUE ANTONIA', 'CANCINO', 'GARCÍA', '0', '3', '56', '1');
INSERT INTO usuario VALUES('1524', '25354083-4', 'LÍA ANTONIA PAZ', 'CORTÉS', 'QUILODRÁN', '0', '3', '56', '1');
INSERT INTO usuario VALUES('1525', '25434425-7', 'NAYARETH SAMANTA', 'CURÍN', 'VELOZO', '0', '3', '56', '1');
INSERT INTO usuario VALUES('1526', '25355660-9', 'MAURICIO IGNACIO', 'DÍAZ', 'MEZA', '0', '3', '56', '1');
INSERT INTO usuario VALUES('1527', '25447465-7', 'EMILIO SEGUNDO', 'HORMAZÁBAL', 'LEAL', '0', '3', '56', '1');
INSERT INTO usuario VALUES('1528', '25455190-2', 'NICOLÁS ANTONIO', 'LANDEROS', 'CHAMORRO', '0', '3', '56', '1');
INSERT INTO usuario VALUES('1529', '25694217-8', 'EMILIANO ALONSO', 'LEÓN', 'PINTO', '0', '3', '56', '1');
INSERT INTO usuario VALUES('1530', '25711892-4', 'ENZO EDUARDO', 'LUNA', 'SALAZAR', '0', '3', '56', '1');
INSERT INTO usuario VALUES('1531', '25376743-K', 'KIARA CHARLOTTE', 'MORAGA', 'VÁSQUEZ', '0', '3', '56', '1');
INSERT INTO usuario VALUES('1532', '25341689-0', 'MATÍAS NICOLÁS', 'MORÁN', 'ORELLANA', '0', '3', '56', '1');
INSERT INTO usuario VALUES('1533', '25591718-8', 'JULIÁN EDUARDO', 'PARRA', 'VILLEGAS', '0', '3', '56', '1');
INSERT INTO usuario VALUES('1534', '25443333-0', 'RENATA DEL CARMEN', 'RIVAS', 'RETAMAL', '0', '3', '56', '1');
INSERT INTO usuario VALUES('1535', '25501685-7', 'KENDALL AGUSTÍN', 'RIVERA', 'SUÁREZ', '0', '3', '56', '1');
INSERT INTO usuario VALUES('1536', '25357303-1', 'THOMAS ANGEL', 'ROJAS', 'ARELLANO', '0', '3', '56', '1');
INSERT INTO usuario VALUES('1537', '25460536-0', 'SOFÍA FERNANDA', 'ROMERO', 'SALAZAR', '0', '3', '56', '1');
INSERT INTO usuario VALUES('1538', '25448690-6', 'DARLYNG ALEXANDRA', 'SEPÚLVEDA', 'GÓMEZ', '0', '3', '56', '1');
INSERT INTO usuario VALUES('1539', '25585479-8', 'MONSERRATH ANTONELLA', 'SOTO', 'BAEZA', '0', '3', '56', '1');
INSERT INTO usuario VALUES('1540', '25660272-5', 'GONZALO NICOLÁS', 'SUAZO', 'SUAZO', '0', '3', '56', '1');
INSERT INTO usuario VALUES('1541', '25690873-5', 'MAURO STEPHANO', 'ZÚÑIGA', 'VELOZO', '0', '3', '56', '1');
INSERT INTO usuario VALUES('1542', '25022470-2', 'JULIETA IGNACIA', 'ALARCÓN', 'VALDÉS', '0', '3', '57', '1');
INSERT INTO usuario VALUES('1543', '25043292-5', 'YESSIA ASHLEY REBECA', 'ALCAÍNO', 'HENRÍQUEZ', '0', '3', '57', '1');
INSERT INTO usuario VALUES('1544', '25024795-8', 'ANGEL ANTONIO', 'AYALA', 'ORELLANA', '0', '3', '57', '1');
INSERT INTO usuario VALUES('1545', '25028047-5', 'CONSTANZA JOSEFA', 'CORNEJO', 'RIVAS', '0', '3', '57', '1');
INSERT INTO usuario VALUES('1546', '25183257-9', 'CRISTIAN ALEJANDRO', 'GARCÍA', 'ARAVENA', '0', '3', '57', '1');
INSERT INTO usuario VALUES('1547', '25336548-K', 'BENJAMÍN NICOLÁS', 'HENRÍQUEZ', 'DÍAZ', '0', '3', '57', '1');
INSERT INTO usuario VALUES('1548', '25065973-3', 'RENATA ANTONELA ANAÍS', 'HERNÁNDEZ', 'CÁCERES', '0', '3', '57', '1');
INSERT INTO usuario VALUES('1549', '25305717-3', 'MAITE ANTONIA', 'INOSTROZA', 'FUENTES', '0', '3', '57', '1');
INSERT INTO usuario VALUES('1550', '25079282-4', 'DIEGO ALEXIS', 'JARA', 'YÉVENES', '0', '3', '57', '1');
INSERT INTO usuario VALUES('1551', '25200797-0', 'KAADAR HATICE', 'MENA', 'CABRERA', '0', '3', '57', '1');
INSERT INTO usuario VALUES('1552', '25229901-7', 'MATÍAS ANTONIO', 'MORAGA', 'MOYA', '0', '3', '57', '1');
INSERT INTO usuario VALUES('1553', '25199421-8', 'FRANCISCO AGUSTÍN', 'PÉREZ', 'ÁVALOS', '0', '3', '57', '1');
INSERT INTO usuario VALUES('1554', '25002475-4', 'MARCELA SOFIA', 'RIQUELME', 'TRONCOSO', '0', '3', '57', '1');
INSERT INTO usuario VALUES('1555', '24948131-9', 'VALENTINA EMILIA', 'RIVAS', 'DURÁN', '0', '3', '57', '1');
INSERT INTO usuario VALUES('1556', '24969175-5', 'AYLEEN ARIANA', 'ROJAS', 'YÁÑEZ', '0', '3', '57', '1');
INSERT INTO usuario VALUES('1557', '25104409-0', 'TOMÁS ANTONIO', 'SÁEZ', 'ANDRADES', '0', '3', '57', '1');
INSERT INTO usuario VALUES('1558', '25315863-8', 'LUCAS AGUSTÍN', 'SALGADO', 'RIVEROS', '0', '3', '57', '1');
INSERT INTO usuario VALUES('1559', '25315837-9', 'MATEO SEBASTIÁN', 'SALGADO', 'RIVEROS', '0', '3', '57', '1');
INSERT INTO usuario VALUES('1560', '24604971-8', 'TOMÁS FERNANDO', 'SUAZO', 'RIVAS', '0', '3', '57', '1');
INSERT INTO usuario VALUES('1561', '25286436-9', 'MARITZA FERNANDA ANDREA', 'TAPIA', 'QUINTANA', '0', '3', '57', '1');
INSERT INTO usuario VALUES('1562', '25297672-8', 'DAMARY YAINARA', 'TORRES', 'CARO', '0', '3', '57', '1');
INSERT INTO usuario VALUES('1563', '25083469-1', 'EMILIA AGUSTINA', 'YÁÑEZ', 'TAPIA', '0', '3', '57', '1');
INSERT INTO usuario VALUES('1564', '25302514-K', 'NÉSTOR ELADIO', 'ACUÑA', 'BARRERA', '0', '3', '58', '1');
INSERT INTO usuario VALUES('1565', '25047381-8', 'LUCAS GONZALO', 'ALARCÓN', 'VILLEGAS', '0', '3', '58', '1');
INSERT INTO usuario VALUES('1566', '24950571-4', 'BEATRIZ LILIANA', 'ALVARADO', 'TORRES', '0', '3', '58', '1');
INSERT INTO usuario VALUES('1567', '25039256-7', 'MAXIMILIANO LUIS ENRIQUE', 'CÁCERES', 'CASTRO', '0', '3', '58', '1');
INSERT INTO usuario VALUES('1568', '25073206-6', 'MARTÍN ALONSO', 'CANCINO', 'PARRA', '0', '3', '58', '1');
INSERT INTO usuario VALUES('1569', '25237922-3', 'BENJAMÍN IGNACIO', 'CASTILLO', 'SÁNCHEZ', '0', '3', '58', '1');
INSERT INTO usuario VALUES('1570', '25133771-3', 'DILAN ANTONIO', 'DÍAZ', 'BRUNO', '0', '3', '58', '1');
INSERT INTO usuario VALUES('1571', '24983475-0', 'JESÚS IGNACIA', 'FLORES', 'CANCINO', '0', '3', '58', '1');
INSERT INTO usuario VALUES('1572', '25284982-3', 'AGUSTÍN ANTONIO', 'GALLARDO', 'CANALES', '0', '3', '58', '1');
INSERT INTO usuario VALUES('1573', '25015705-3', 'FRANCISCO JAVIER', 'GARRIDO', 'GARCÍA', '0', '3', '58', '1');
INSERT INTO usuario VALUES('1574', '25015750-9', 'JESÚS ANDRÉS', 'GARRIDO', 'GARCÍA', '0', '3', '58', '1');
INSERT INTO usuario VALUES('1575', '25225243-6', 'MARIANA BEATRIZ', 'HENRÍQUEZ', 'VALDÉS', '0', '3', '58', '1');
INSERT INTO usuario VALUES('1576', '25312334-6', 'ANTONELLA PASCAL', 'HERNÁNDEZ', 'CHAMORRO', '0', '3', '58', '1');
INSERT INTO usuario VALUES('1577', '25183512-8', 'ROCÍO ISABELLA', 'LATORRE', 'CHANDÍA', '0', '3', '58', '1');
INSERT INTO usuario VALUES('1578', '25320693-4', 'ÁMBAR VIOLETA MILUFER', 'LEÓN', 'RECABAL', '0', '3', '58', '1');
INSERT INTO usuario VALUES('1579', '25016675-3', 'EMILY ANASTASIA', 'LÓPEZ', 'JOPIA', '0', '3', '58', '1');
INSERT INTO usuario VALUES('1580', '24885646-7', 'BENJAMÍN FELIPE', 'MENDOZA', 'HORMAZÁBAL', '0', '3', '58', '1');
INSERT INTO usuario VALUES('1581', '25118863-7', 'MAYLY ANAÍS', 'RIVAS', 'VEGA', '0', '3', '58', '1');
INSERT INTO usuario VALUES('1582', '25013227-1', 'TOMÁS ANTONIO', 'SALGADO', 'GUTIÉRREZ', '0', '3', '58', '1');
INSERT INTO usuario VALUES('1583', '25174726-1', 'NAZARET PASCAL', 'TORRES', 'PÉREZ', '0', '3', '58', '1');
INSERT INTO usuario VALUES('1584', '25330108-2', 'NICOLÁS AGUSTÍN', 'VENEGAS', 'SUÁREZ', '0', '3', '58', '1');
INSERT INTO usuario VALUES('1585', '24683487-3', 'EMILIO ANTONIO', 'ARAVENA', 'ARELLANO', '0', '3', '59', '1');
INSERT INTO usuario VALUES('1586', '24743150-0', 'BRAHIAN BAYRON ANTONIO', 'BERRÍOS', 'MUÑOZ', '0', '3', '59', '1');
INSERT INTO usuario VALUES('1587', '24647901-1', 'MARTINA PAZ', 'CASTRO', 'DÍAZ', '0', '3', '59', '1');
INSERT INTO usuario VALUES('1588', '24692367-1', 'FLORENCIA MARIANA CATHERINA', 'CATRIQUIR', 'ALARCÓN', '0', '3', '59', '1');
INSERT INTO usuario VALUES('1589', '24625900-3', 'RODRIGO ALEXIS', 'DÍAZ', 'BRUNO', '0', '3', '59', '1');
INSERT INTO usuario VALUES('1590', '24845979-4', 'JEAN-PIERRE ALEXANDER', 'DÍAZ', 'CANALES', '0', '3', '59', '1');
INSERT INTO usuario VALUES('1591', '24616549-1', 'BENJAMÍN ANTONIO', 'FAÚNDEZ', 'BURGOS', '0', '3', '59', '1');
INSERT INTO usuario VALUES('1592', '24942840-K', 'MICHAEL ANDRÉS', 'FAÚNDEZ', 'PEÑAILILLO', '0', '3', '59', '1');
INSERT INTO usuario VALUES('1593', '24839636-9', 'GENESIS GISELLE', 'GARRIDO', 'VÁSQUEZ', '0', '3', '59', '1');
INSERT INTO usuario VALUES('1594', '24778677-5', 'NOEMY AGUSTINA', 'LEAL', 'QUEVEDO', '0', '3', '59', '1');
INSERT INTO usuario VALUES('1595', '24685064-K', 'JONATHAN EMILIO', 'MANRÍQUEZ', 'ESPINOZA', '0', '3', '59', '1');
INSERT INTO usuario VALUES('1596', '24837564-7', 'BENJAMÍN ALEJANDRO', 'MORAGA', 'SEPÚLVEDA', '0', '3', '59', '1');
INSERT INTO usuario VALUES('1597', '24682903-9', 'AGUSTINA ALICIA', 'NORAMBUENA', 'VILLALOBOS', '0', '3', '59', '1');
INSERT INTO usuario VALUES('1598', '24813160-8', 'ÁNGELA DENISSE', 'OLIVOS', 'DÍAZ', '0', '3', '59', '1');
INSERT INTO usuario VALUES('1599', '24737084-6', 'ARIADME ISABELLA', 'QUIJANO', 'AVARIA', '0', '3', '59', '1');
INSERT INTO usuario VALUES('1600', '24822591-2', 'MARLYZ DEL PILAR', 'QUILODRÁN', 'CONTRERAS', '0', '3', '59', '1');
INSERT INTO usuario VALUES('1601', '24770074-9', 'SANTIAGO ALONSO', 'RETAMAL', 'YÁÑEZ', '0', '3', '59', '1');
INSERT INTO usuario VALUES('1602', '24596992-9', 'ANTONELLA SCARLETT', 'REYES', 'AVILÉS', '0', '3', '59', '1');
INSERT INTO usuario VALUES('1603', '24630683-4', 'JORGE NICOLÁS', 'RIVAS', 'VEGA', '0', '3', '59', '1');
INSERT INTO usuario VALUES('1604', '24740532-1', 'ESPERANZA EMILIA', 'SÁNCHEZ', 'BARRUETO', '0', '3', '59', '1');
INSERT INTO usuario VALUES('1605', '24702403-4', 'RENATA IGNACIA', 'SANDOVAL', 'MACHUCA', '0', '3', '59', '1');
INSERT INTO usuario VALUES('1606', '24840026-9', 'EMILIANO ANDRÉS', 'SANTANDER', 'MADRID', '0', '3', '59', '1');
INSERT INTO usuario VALUES('1607', '20651650-K', 'MARTÍN ALONSO', 'TORRES', 'LEAL', '0', '3', '59', '1');
INSERT INTO usuario VALUES('1608', '24807168-0', 'VICENTE LEÓN', 'VÁSQUEZ', 'ALARCÓN', '0', '3', '59', '1');
INSERT INTO usuario VALUES('1609', '24787572-7', 'LEON EMILIANO', 'VILCHES', 'SANTIS', '0', '3', '59', '1');
INSERT INTO usuario VALUES('1610', '24597154-0', 'VIOLETA ESPERANZA', 'AGUILERA', 'BASTÍAS', '0', '3', '60', '1');
INSERT INTO usuario VALUES('1611', '24890651-0', 'JUAN EMILIO ALEJANDRO', 'ALVIAL', 'BÓRQUEZ', '0', '3', '60', '1');
INSERT INTO usuario VALUES('1612', '24608979-5', 'BENJAMÍN EDUARDO', 'ARAVENA', 'TORRES', '0', '3', '60', '1');
INSERT INTO usuario VALUES('1613', '24862958-4', 'SAMUEL ISAI', 'ARELLANO', 'DÍAZ', '0', '3', '60', '1');
INSERT INTO usuario VALUES('1614', '24897632-2', 'ANAÍS VALENTINA', 'AYALA', 'ALARCÓN', '0', '3', '60', '1');
INSERT INTO usuario VALUES('1615', '24810470-8', 'THOMAS EDUARDO', 'BELTRÁN', 'GARCÍA', '0', '3', '60', '1');
INSERT INTO usuario VALUES('1616', '24899088-0', 'OSVALDO ALEJANDRO', 'BUENO', 'DURÁN', '0', '3', '60', '1');
INSERT INTO usuario VALUES('1617', '24845023-1', 'BRITANY ANAÍS DEL CARMEN', 'BUSTOS', 'VILLEGAS', '0', '3', '60', '1');
INSERT INTO usuario VALUES('1618', '24843106-7', 'SOFÍA VALENTINA', 'CAMPOS', 'AGURTO', '0', '3', '60', '1');
INSERT INTO usuario VALUES('1619', '24829248-2', 'MONSERRAT ALEJANDRA', 'CHAVARRÍA', 'VILLENA', '0', '3', '60', '1');
INSERT INTO usuario VALUES('1620', '23819811-9', 'MARTÍN ALEJANDRO MASSIMO', 'CIFUENTES', 'ORELLANA', '0', '3', '60', '1');
INSERT INTO usuario VALUES('1621', '24607498-4', 'JOSEPH EMIR', 'FAÚNDEZ', 'MACAYA', '0', '3', '60', '1');
INSERT INTO usuario VALUES('1622', '24794804-K', 'FRANCO ARENDELLE', 'GÓMEZ', 'SOTO', '0', '3', '60', '1');
INSERT INTO usuario VALUES('1623', '24769041-7', 'MAYRA CATALINA', 'JARA', 'GARCÍA', '0', '3', '60', '1');
INSERT INTO usuario VALUES('1624', '24674126-3', 'CRISTÓBAL TOMÁS', 'JARA', 'YÉVENES', '0', '3', '60', '1');
INSERT INTO usuario VALUES('1625', '24665000-4', 'ALICE DOMINIQUE STACY', 'LÓPEZ', 'BUSTAMANTE', '0', '3', '60', '1');
INSERT INTO usuario VALUES('1626', '24688110-3', 'PASKAL ANTONELLA', 'MEDINA', 'CANCINO', '0', '3', '60', '1');
INSERT INTO usuario VALUES('1627', '24676644-4', 'AARON MOISÉS', 'NAVARRETE', 'TORRES', '0', '3', '60', '1');
INSERT INTO usuario VALUES('1628', '24709477-6', 'ALONDRA MARIEL', 'PINEDA', 'MORA', '0', '3', '60', '1');
INSERT INTO usuario VALUES('1629', '24613547-9', 'VICENTE ALEXIS', 'PINOCHET', 'CISTERNAS', '0', '3', '60', '1');
INSERT INTO usuario VALUES('1630', '24610805-6', 'PASCAL FRANCISCA', 'REINOSO', 'CASTILLO', '0', '3', '60', '1');
INSERT INTO usuario VALUES('1631', '24765308-2', 'EMILY NAOMÍ', 'RODRÍGUEZ', 'ORTIZ', '0', '3', '60', '1');
INSERT INTO usuario VALUES('1632', '24781203-2', 'LUIS ANDRÉS', 'SÁNCHEZ', 'SALGADO', '0', '3', '60', '1');
INSERT INTO usuario VALUES('1633', '24823584-5', 'MAGDALENA ESPERANZA', 'TORRES', 'VILLEGAS', '0', '3', '60', '1');
INSERT INTO usuario VALUES('1634', '24793885-0', 'YASMIN ELIZABETH', 'ZURITA', 'ZURITA', '0', '3', '60', '1');
INSERT INTO usuario VALUES('1635', '24573692-4', 'JOSÉ MIGUEL', 'ARAVENA', 'CASTILLO', '0', '3', '61', '1');
INSERT INTO usuario VALUES('1636', '24484826-5', 'EMILIO DAYAEL', 'ARAVENA', 'VEGA', '0', '3', '61', '1');
INSERT INTO usuario VALUES('1637', '24566014-6', 'ALONDRA NOEMÍ', 'BAEZA', 'MANRÍQUEZ', '0', '3', '61', '1');
INSERT INTO usuario VALUES('1638', '24497179-2', 'MÁXIMO WILLIAM', 'BUENO', 'CANCINO', '0', '3', '61', '1');
INSERT INTO usuario VALUES('1639', '24308420-2', 'MARTINA ISIDORA', 'CÁCERES', 'PEDRAZA', '0', '3', '61', '1');
INSERT INTO usuario VALUES('1640', '24318796-6', 'SOFÍA ANTONIA', 'CANTERO', 'CASTILLO', '0', '3', '61', '1');
INSERT INTO usuario VALUES('1641', '24329270-0', 'DANIEL IGNACIO', 'COFRÉ', 'CORTÉS', '0', '3', '61', '1');
INSERT INTO usuario VALUES('1642', '24323888-9', 'ANAIS AMARAL', 'ESCOBEDO', 'PARRA', '0', '3', '61', '1');
INSERT INTO usuario VALUES('1643', '24588886-4', 'EMILIA SCARLETT', 'ESPINOSA', 'LARA', '0', '3', '61', '1');
INSERT INTO usuario VALUES('1644', '24498504-1', 'EDUARDO MARTÍN', 'FLORES', 'BRAVO', '0', '3', '61', '1');
INSERT INTO usuario VALUES('1645', '24394493-7', 'MARTINA FERNANDA', 'GALLARDO', 'HORMAZÁBAL', '0', '3', '61', '1');
INSERT INTO usuario VALUES('1646', '24353612-K', 'BENJAMÍN ANTONIO', 'GARCÍA', 'MOYA', '0', '3', '61', '1');
INSERT INTO usuario VALUES('1647', '24404918-4', 'ANDRÉS EMANUEL', 'GARCÍA', 'MUÑOZ', '0', '3', '61', '1');
INSERT INTO usuario VALUES('1648', '24521438-3', 'FELIPE ANDRÉS', 'HENRÍQUEZ', 'GÓMEZ', '0', '3', '61', '1');
INSERT INTO usuario VALUES('1649', '24508119-7', 'LAURA RAFAELA', 'HERRERA', 'CASANOVA', '0', '3', '61', '1');
INSERT INTO usuario VALUES('1650', '24330632-9', 'ELIÚ NICOLÁS', 'INOSTROZA', 'FUENTES', '0', '3', '61', '1');
INSERT INTO usuario VALUES('1651', '24400974-3', 'VICENTE EMILIO', 'LARA', 'CASTILLO', '0', '3', '61', '1');
INSERT INTO usuario VALUES('1652', '24330328-1', 'CRISTÓBAL EMILIO', 'LEAL', 'BASTÍAS', '0', '3', '61', '1');
INSERT INTO usuario VALUES('1653', '24349144-4', 'JOSÉ ESTEBAN', 'LEÓN', 'PINTO', '0', '3', '61', '1');
INSERT INTO usuario VALUES('1654', '24353807-6', 'SEBASTIÁN ANTONIO', 'LÓPEZ', 'REYES', '0', '3', '61', '1');
INSERT INTO usuario VALUES('1655', '24401670-7', 'NICOLE ESPERANZA', 'LUNA', 'SALGADO', '0', '3', '61', '1');
INSERT INTO usuario VALUES('1656', '24541388-2', 'DIXON ALEXIS', 'MEDEL', 'QUEZADA', '0', '3', '61', '1');
INSERT INTO usuario VALUES('1657', '24571437-8', 'IGNACIO ESTEBAN', 'MENA', 'MADRID', '0', '3', '61', '1');
INSERT INTO usuario VALUES('1658', '24405361-0', 'SIMONEY JOSEFINA', 'MORAGA', 'BASTÍAS', '0', '3', '61', '1');
INSERT INTO usuario VALUES('1659', '24547785-6', 'JUAN IGNACIO', 'MUÑOZ', 'BRAVO', '0', '3', '61', '1');
INSERT INTO usuario VALUES('1660', '24477972-7', 'LUIS MATÍAS', 'MUÑOZ', 'ESPINOSA', '0', '3', '61', '1');
INSERT INTO usuario VALUES('1661', '24386222-1', 'EMILY JULIETTE', 'MUÑOZ', 'OSES', '0', '3', '61', '1');
INSERT INTO usuario VALUES('1662', '24469065-3', 'YEIKO ALEJANDRO', 'MUÑOZ', 'SANHUEZA', '0', '3', '61', '1');
INSERT INTO usuario VALUES('1663', '24356242-2', 'BEATRIZ ARIADNE', 'OBREQUE', 'DÍAZ', '0', '3', '61', '1');
INSERT INTO usuario VALUES('1664', '23902537-4', 'TRINIDAD ELENA', 'PÉREZ', 'AGURTO', '0', '3', '61', '1');
INSERT INTO usuario VALUES('1665', '24356386-0', 'EVOLET FLORENCIA', 'PÉREZ', 'VILLEGAS', '0', '3', '61', '1');
INSERT INTO usuario VALUES('1666', '24268012-K', 'JESÚS IGNACIO ALEJANDRO', 'PÉREZ', 'VILLEGAS', '0', '3', '61', '1');
INSERT INTO usuario VALUES('1667', '24428188-5', 'VERÓNICA DE LAS MERCEDES', 'QUILODRÁN', 'CONTRERAS', '0', '3', '61', '1');
INSERT INTO usuario VALUES('1668', '24458499-3', 'MATEO JESÚS', 'REBOLLEDO', 'GUTIÉRREZ', '0', '3', '61', '1');
INSERT INTO usuario VALUES('1669', '24098216-1', 'BENJAMÍN AURELIO', 'RODRÍGUEZ', 'ZÚÑIGA', '0', '3', '61', '1');
INSERT INTO usuario VALUES('1670', '24457128-K', 'GERALDINE ALEJANDRA', 'ROJAS', 'PACHECO', '0', '3', '61', '1');
INSERT INTO usuario VALUES('1671', '24400524-1', 'MONSERRATH ELENA', 'SÁNCHEZ', 'CANCINO', '0', '3', '61', '1');
INSERT INTO usuario VALUES('1672', '24496267-K', 'ANTONIA NOEMÍ', 'SUAZO', 'PEÑAILILLO', '0', '3', '61', '1');
INSERT INTO usuario VALUES('1673', '23825043-9', 'MATÍAS ANDRÉS', 'TORRES', 'BARRUETO', '0', '3', '61', '1');
INSERT INTO usuario VALUES('1674', '24487047-3', 'EMILIA ANTONIA', 'YÁÑEZ', 'RODRÍGUEZ', '0', '3', '61', '1');
INSERT INTO usuario VALUES('1675', '23986425-2', 'TOMÁS IGNACIO', 'AGUILAR', 'JAQUE', '0', '3', '62', '1');
INSERT INTO usuario VALUES('1676', '24033003-2', 'CATALINA ANAÍS', 'ALVIAL', 'BÓRQUEZ', '0', '3', '62', '1');
INSERT INTO usuario VALUES('1677', '23986942-4', 'CAMILA ALEJANDRA', 'BURGOA', 'VILLEGAS', '0', '3', '62', '1');
INSERT INTO usuario VALUES('1678', '24013719-4', 'KRISCHNA ALEJANDRA', 'FAÚNDEZ', 'VELOZO', '0', '3', '62', '1');
INSERT INTO usuario VALUES('1679', '23899659-7', 'KRHISNA DAYANNE', 'GARCÍA', 'VÁSQUEZ', '0', '3', '62', '1');
INSERT INTO usuario VALUES('1680', '24261108-K', 'JULIETA ANDREA', 'GUTIÉRREZ', 'HORMAZÁBAL', '0', '3', '62', '1');
INSERT INTO usuario VALUES('1681', '24136237-K', 'LISSETH KATALINA PAZ', 'LÓPEZ', 'BUSTAMANTE', '0', '3', '62', '1');
INSERT INTO usuario VALUES('1682', '24190914-K', 'VALENTÍN CHRISTIAN ANTONIO', 'MARÍN', 'SALDÍVAR', '0', '3', '62', '1');
INSERT INTO usuario VALUES('1683', '24260039-8', 'FELIPE ANDRÉS', 'MONROY', 'RÍOS', '0', '3', '62', '1');
INSERT INTO usuario VALUES('1684', '24227347-8', 'SAMANTHA BELÉN', 'MORAGA', 'HENRÍQUEZ', '0', '3', '62', '1');
INSERT INTO usuario VALUES('1685', '24060230-K', 'GIOVANNI BASTIÁN', 'MUÑOZ', 'SAN MARTÍN', '0', '3', '62', '1');
INSERT INTO usuario VALUES('1686', '23959765-3', 'HIKER VICENTE', 'QUIÑONES', 'CASTILLO', '0', '3', '62', '1');
INSERT INTO usuario VALUES('1687', '24112515-7', 'SEBASTIÁN FELICIANO', 'RETAMAL', 'PÉREZ', '0', '3', '62', '1');
INSERT INTO usuario VALUES('1688', '24005547-3', 'CAMILA ALEXANDRA', 'SUAZO', 'LANDERO', '0', '3', '62', '1');
INSERT INTO usuario VALUES('1689', '24228734-7', 'ISIDORA PASCALE', 'TEJEDA', 'JARA', '0', '3', '62', '1');
INSERT INTO usuario VALUES('1690', '24104023-2', 'MAITE ELIZABETH', 'TORRES', 'FAÚNDEZ', '0', '3', '62', '1');
INSERT INTO usuario VALUES('1691', '24231374-7', 'ANTONELLA IGNACIA', 'YÁÑEZ', 'TAPIA', '0', '3', '62', '1');
INSERT INTO usuario VALUES('1692', '23941246-7', 'TRINIDAD PAZ', 'ALARCÓN', 'MENA', '0', '3', '63', '1');
INSERT INTO usuario VALUES('1693', '24090913-8', 'BENJAMÍN IGNACIO', 'ARAVENA', 'JARA', '0', '3', '63', '1');
INSERT INTO usuario VALUES('1694', '24025422-0', 'ISAAC ESTEBAN', 'ARELLANO', 'DÍAZ', '0', '3', '63', '1');
INSERT INTO usuario VALUES('1695', '24080809-9', 'IGNACIA KATALEYA', 'BELLO', 'TOLEDO', '0', '3', '63', '1');
INSERT INTO usuario VALUES('1696', '23648700-8', 'JORGE ESTEBAN', 'BERRÍOS', 'SANTANDER', '0', '3', '63', '1');
INSERT INTO usuario VALUES('1697', '24130177-K', 'EMILI FERNANDA ANTONELLA', 'CANALES', 'LEÓN', '0', '3', '63', '1');
INSERT INTO usuario VALUES('1698', '23892529-0', 'EDISON BRAYAN', 'CONTRERAS', 'PEREIRA', '0', '3', '63', '1');
INSERT INTO usuario VALUES('1699', '24040137-1', 'FERNANDA IGNACIA', 'CORNEJO', 'RIVAS', '0', '3', '63', '1');
INSERT INTO usuario VALUES('1700', '23941272-6', 'DAVID ESTEBAN', 'JARA', 'PEÑAILILLO', '0', '3', '63', '1');
INSERT INTO usuario VALUES('1701', '24200578-3', 'FÉLIX LEONARDO', 'JORQUERA', 'CANALES', '0', '3', '63', '1');
INSERT INTO usuario VALUES('1702', '23994814-6', 'MATÍAS NICOLÁS', 'LARA', 'GARCÍA', '0', '3', '63', '1');
INSERT INTO usuario VALUES('1703', '24107500-1', 'MAXIMILIANO ANTONIO', 'LUNA', 'FRÍAS', '0', '3', '63', '1');
INSERT INTO usuario VALUES('1704', '24138534-5', 'LUIS MANUEL', 'MENA', 'CABRERA', '0', '3', '63', '1');
INSERT INTO usuario VALUES('1705', '24119850-2', 'FERNANDA ARIANA', 'MORÁN', 'ORELLANA', '0', '3', '63', '1');
INSERT INTO usuario VALUES('1706', '24093699-2', 'ARTURO VIDAL', 'MOYA', 'DÍAZ', '0', '3', '63', '1');
INSERT INTO usuario VALUES('1707', '24292764-8', 'ARMIN MAURICIO', 'MUÑOZ', 'DOMÍNGUEZ', '0', '3', '63', '1');
INSERT INTO usuario VALUES('1708', '23857767-5', 'FRANCISCO AARON', 'QUEZADA', 'VARELA', '0', '3', '63', '1');
INSERT INTO usuario VALUES('1709', '24191631-6', 'KEYLY DENNISSE', 'QUILODRAN', 'CANALES', '0', '3', '63', '1');
INSERT INTO usuario VALUES('1710', '23989770-3', 'ANAHIS ESTEFANÍA', 'SAAVEDRA', 'REYES', '0', '3', '63', '1');
INSERT INTO usuario VALUES('1711', '24126942-6', 'MAURICIO ANTONIO', 'SOTO', 'TEJO', '0', '3', '63', '1');
INSERT INTO usuario VALUES('1712', '24001983-3', 'IVÁN ARMANDO', 'VILLEGAS', 'HERRERA', '0', '3', '63', '1');
INSERT INTO usuario VALUES('1713', '23692820-9', 'JAIME ARNALDO', 'BARRA', 'MIRANDA', '0', '3', '64', '1');
INSERT INTO usuario VALUES('1714', '23787379-3', 'YANITZIA FERNANDA VICTORIA', 'CÁCERES', 'ANDRADES', '0', '3', '64', '1');
INSERT INTO usuario VALUES('1715', '23530134-2', 'ALDO IGNACIO ALEJANDRO', 'ESPINOSA', 'ROJAS', '0', '3', '64', '1');
INSERT INTO usuario VALUES('1716', '23896248-K', 'JAVIERA IGNACIA', 'GARCÍA', 'ARAVENA', '0', '3', '64', '1');
INSERT INTO usuario VALUES('1717', '23743792-6', 'DAMIÁN ALEXANDER', 'GONZÁLEZ', 'MACHUCA', '0', '3', '64', '1');
INSERT INTO usuario VALUES('1718', '23877765-8', 'MAITE FERMINA', 'HENRÍQUEZ', 'AGUILERA', '0', '3', '64', '1');
INSERT INTO usuario VALUES('1719', '23833554-K', 'JULIANA PASKAL', 'HERRERA', 'CASANOVA', '0', '3', '64', '1');
INSERT INTO usuario VALUES('1720', '23811856-5', 'DIEGO ARTURO', 'JAQUE', 'MORAGA', '0', '3', '64', '1');
INSERT INTO usuario VALUES('1721', '23832852-7', 'LUCAS ALEJANDRO', 'MORAGA', 'CANALES', '0', '3', '64', '1');
INSERT INTO usuario VALUES('1722', '23940234-8', 'MARTINA EMILIA', 'ORELLANA', 'ALARCÓN', '0', '3', '64', '1');
INSERT INTO usuario VALUES('1723', '23857138-3', 'PAZ ALEJANDRA', 'RETAMAL', 'VÁSQUEZ', '0', '3', '64', '1');
INSERT INTO usuario VALUES('1724', '23833104-8', 'MAXIMILIANO ARIEL', 'RODRÍGUEZ', 'SALAZAR', '0', '3', '64', '1');
INSERT INTO usuario VALUES('1725', '23717580-8', 'ALEXANDER ANTONIO', 'SANTA CRUZ', 'FERNÁNDEZ', '0', '3', '64', '1');
INSERT INTO usuario VALUES('1726', '23860053-7', 'ANTONELLA IGNACIA', 'TEJEDA', 'JARA', '0', '3', '64', '1');
INSERT INTO usuario VALUES('1727', '23758278-0', 'SOFÍA IGNACIA', 'TORRES', 'LEAL', '0', '3', '64', '1');
INSERT INTO usuario VALUES('1728', '23887086-0', 'JOHAN ALEXIS', 'VEGA', 'VILLEGAS', '0', '3', '64', '1');
INSERT INTO usuario VALUES('1729', '23758068-0', 'MARTÍN ANTONIO', 'VILLALOBOS', 'RIQUELME', '0', '3', '64', '1');
INSERT INTO usuario VALUES('1730', '23709889-7', 'JESÚS IGNACIO', 'YÉVENES', 'CASTILLO', '0', '3', '64', '1');
INSERT INTO usuario VALUES('1731', '23731897-8', 'JOSÉ MANUEL', 'ARAVENA', 'ESPINOSA', '0', '3', '65', '1');
INSERT INTO usuario VALUES('1732', '23708176-5', 'ARIADNA FERNANDA', 'BAEZA', 'BUSTOS', '0', '3', '65', '1');
INSERT INTO usuario VALUES('1733', '23849539-3', 'TATIANA VALENTINA', 'CHAVARRIA', 'VILLENA', '0', '3', '65', '1');
INSERT INTO usuario VALUES('1734', '23976309-K', 'FLORENCIA EMILIA ISIDORA', 'DÍAZ', 'SÁNCHEZ', '0', '3', '65', '1');
INSERT INTO usuario VALUES('1735', '23951343-3', 'MARIANO DIEGO ANDRÉS', 'GALLARDO', 'SUAZO', '0', '3', '65', '1');
INSERT INTO usuario VALUES('1736', '23704982-9', 'PATRIK BERNABÉ DE JESUS', 'LÉPEZ', 'CANALES', '0', '3', '65', '1');
INSERT INTO usuario VALUES('1737', '23795738-5', 'VÍCTOR MANUEL', 'LÓPEZ', 'REYES', '0', '3', '65', '1');
INSERT INTO usuario VALUES('1738', '23644914-9', 'PATRIX JOEL', 'MENA', 'CABRERA', '0', '3', '65', '1');
INSERT INTO usuario VALUES('1739', '23765143-K', 'ALEXIS IGNACIO', 'MORENO', 'CÁCERES', '0', '3', '65', '1');
INSERT INTO usuario VALUES('1740', '23735648-9', 'JERUSALÉN CECILIA', 'ORTEGA', 'GÓMEZ', '0', '3', '65', '1');
INSERT INTO usuario VALUES('1741', '23853259-0', 'MÁXIMO ARIEL', 'PÉREZ', 'PEÑA', '0', '3', '65', '1');
INSERT INTO usuario VALUES('1742', '23191135-9', 'ALONSO ESTEBAN', 'PINOCHET', 'CISTERNAS', '0', '3', '65', '1');
INSERT INTO usuario VALUES('1743', '23914144-7', 'FRANCHESCA ANAÍS', 'QUINTANA', 'AGUILERA', '0', '3', '65', '1');
INSERT INTO usuario VALUES('1744', '23794506-9', 'WILLIAMS MAXIMILIANO', 'ROCHA', 'JARA', '0', '3', '65', '1');
INSERT INTO usuario VALUES('1745', '23895768-0', 'RAMÓN IGNACIO', 'SÁNCHEZ', 'SALGADO', '0', '3', '65', '1');
INSERT INTO usuario VALUES('1746', '23433661-4', 'DIEGO ARTURO', 'TORRES', 'BARRUETO', '0', '3', '65', '1');
INSERT INTO usuario VALUES('1747', '23730606-6', 'STEPHANIE MARCELA ALEJANDRA', 'TORRES', 'TORRES', '0', '3', '65', '1');
INSERT INTO usuario VALUES('1748', '23896295-1', 'ANY KARLA', 'VALDÉS', 'MARTÍNEZ', '0', '3', '65', '1');
INSERT INTO usuario VALUES('1749', '23680899-8', 'AGUSTÍN ALONSO', 'VILLALOBOS', 'FAÚNDEZ', '$2y$10$r4U10wV5yU2mGvu7MYT1d.H89F1OPWVRXggTnj5UQTrcJw/zE0ROi', '3', '65', '1');
INSERT INTO usuario VALUES('1750', '23834728-9', 'JOAQUÍN ALEXIS', 'YÁÑEZ', 'GÓMEZ', '0', '3', '65', '1');
INSERT INTO usuario VALUES('1751', '21331036-4', 'Jordan', 'Vergara', 'Arellano', '$2y$10$0WZDumfFABZ0YrEBddZH8eutTAW.1K0isXTW1OPYiDeU3IZSyDsBa', '1', NULL, '1');
INSERT INTO usuario VALUES('1752', '9849834-6', 'NORA ELIZABETH', 'ARRAU', 'CANCINO', '$2y$10$.rPHxv0IMJbICKugLoN5p.RkpI4d1.bsQGyb/lBH7Q1CsZIhHbu0S', '2', NULL, '1');
INSERT INTO usuario VALUES('1753', '19393874-4', 'SIMON', 'TORRES', 'ROJAS', '$2y$10$WWUgJIWcHpwiw1xi4ARDYeN84k.7Aggo.iX8Qpg2v1ui5BNfgZ8.G', '2', NULL, '1');





DROP TABLE IF EXISTS `usuario_permisos`;
CREATE TABLE `usuario_permisos` (
  `usuario_id` int NOT NULL,
  `permiso_id` int NOT NULL,
  PRIMARY KEY (`usuario_id`,`permiso_id`),
  KEY `permiso_id` (`permiso_id`),
  CONSTRAINT `usuario_permisos_ibfk_1` FOREIGN KEY (`usuario_id`) REFERENCES `usuario` (`id`) ON DELETE CASCADE,
  CONSTRAINT `usuario_permisos_ibfk_2` FOREIGN KEY (`permiso_id`) REFERENCES `permisos` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO usuario_permisos VALUES('1', '20');
INSERT INTO usuario_permisos VALUES('1751', '20');
INSERT INTO usuario_permisos VALUES('1', '21');
INSERT INTO usuario_permisos VALUES('1751', '21');
INSERT INTO usuario_permisos VALUES('1', '22');
INSERT INTO usuario_permisos VALUES('1751', '22');
INSERT INTO usuario_permisos VALUES('1', '23');
INSERT INTO usuario_permisos VALUES('904', '23');
INSERT INTO usuario_permisos VALUES('911', '23');
INSERT INTO usuario_permisos VALUES('1751', '23');
INSERT INTO usuario_permisos VALUES('1', '24');
INSERT INTO usuario_permisos VALUES('1751', '24');
INSERT INTO usuario_permisos VALUES('1', '25');
INSERT INTO usuario_permisos VALUES('1751', '25');
INSERT INTO usuario_permisos VALUES('1', '26');
INSERT INTO usuario_permisos VALUES('1751', '26');
INSERT INTO usuario_permisos VALUES('1', '27');
INSERT INTO usuario_permisos VALUES('1751', '27');
INSERT INTO usuario_permisos VALUES('1', '28');
INSERT INTO usuario_permisos VALUES('1751', '28');
INSERT INTO usuario_permisos VALUES('1', '29');
INSERT INTO usuario_permisos VALUES('1751', '29');
INSERT INTO usuario_permisos VALUES('1', '30');
INSERT INTO usuario_permisos VALUES('1751', '30');
INSERT INTO usuario_permisos VALUES('1', '31');
INSERT INTO usuario_permisos VALUES('1751', '31');
INSERT INTO usuario_permisos VALUES('1', '32');
INSERT INTO usuario_permisos VALUES('1751', '32');
INSERT INTO usuario_permisos VALUES('1', '33');
INSERT INTO usuario_permisos VALUES('1751', '33');
INSERT INTO usuario_permisos VALUES('1', '34');
INSERT INTO usuario_permisos VALUES('904', '34');
INSERT INTO usuario_permisos VALUES('1751', '34');
INSERT INTO usuario_permisos VALUES('1', '35');
INSERT INTO usuario_permisos VALUES('904', '35');
INSERT INTO usuario_permisos VALUES('1751', '35');
INSERT INTO usuario_permisos VALUES('1', '36');
INSERT INTO usuario_permisos VALUES('1751', '36');
INSERT INTO usuario_permisos VALUES('1', '37');
INSERT INTO usuario_permisos VALUES('904', '37');
INSERT INTO usuario_permisos VALUES('1751', '37');
INSERT INTO usuario_permisos VALUES('1', '38');
INSERT INTO usuario_permisos VALUES('1751', '38');



