

CREATE TABLE `apoderados` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `alumno_id` int(11) NOT NULL,
  `nombre_apod1` varchar(100) NOT NULL,
  `rut_apod1` varchar(12) NOT NULL,
  `telf_apod1` varchar(15) NOT NULL,
  `cel_apod1` varchar(15) DEFAULT NULL,
  `nombre_apod2` varchar(100) DEFAULT NULL,
  `rut_apod2` varchar(12) DEFAULT NULL,
  `telf_apod2` varchar(15) DEFAULT NULL,
  `cel_apod2` varchar(15) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `alumno_id` (`alumno_id`),
  CONSTRAINT `apoderados_ibfk_1` FOREIGN KEY (`alumno_id`) REFERENCES `matriculas` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO apoderados VALUES('4', '7', 'Marcos Rojas', '15741963-2 ', '123456789', '123456789', 'Susana Mesa', '15883221-1', '987654321', '987654321');





CREATE TABLE `asignaturas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nombre` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO asignaturas VALUES('1', 'Lenguaje');
INSERT INTO asignaturas VALUES('2', 'Matematicas');
INSERT INTO asignaturas VALUES('3', 'Musica');
INSERT INTO asignaturas VALUES('4', 'Artes');
INSERT INTO asignaturas VALUES('5', 'Educacion Fisica');
INSERT INTO asignaturas VALUES('6', 'Ciencias Naturales');
INSERT INTO asignaturas VALUES('7', 'Historia');
INSERT INTO asignaturas VALUES('8', 'Ingles');





CREATE TABLE `cursos` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nombre` varchar(100) NOT NULL,
  `profesor_jefe_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `profesor_jefe_id` (`profesor_jefe_id`),
  CONSTRAINT `cursos_ibfk_1` FOREIGN KEY (`profesor_jefe_id`) REFERENCES `usuarios` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO cursos VALUES('1', 'Primer Ao A', '8');
INSERT INTO cursos VALUES('2', 'Pre Kinder', '11');
INSERT INTO cursos VALUES('3', 'Kinder', '10');
INSERT INTO cursos VALUES('4', 'Segundo Ao A', '8');
INSERT INTO cursos VALUES('5', 'Tercer Ao A', '9');





CREATE TABLE `equipos` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nombre_equipo` varchar(100) NOT NULL,
  `ubicacion` varchar(100) NOT NULL,
  `marca` varchar(100) NOT NULL,
  `modelo` varchar(100) NOT NULL,
  `imagen` varchar(255) DEFAULT NULL,
  `numero_serie` varchar(100) DEFAULT NULL,
  `procesador` varchar(100) DEFAULT NULL,
  `memoria_ram` varchar(50) DEFAULT NULL,
  `almacenamiento` varchar(50) DEFAULT NULL,
  `tarjeta_grafica` varchar(100) DEFAULT NULL,
  `sistema_operativo` varchar(100) NOT NULL,
  `version_so` varchar(50) DEFAULT NULL,
  `licencia` tinyint(1) DEFAULT 1,
  `programas_instalados` text DEFAULT NULL,
  `estado_equipo` varchar(50) NOT NULL,
  `observaciones` text DEFAULT NULL,
  `fecha_ultimo_mantenimiento` date DEFAULT NULL,
  `detalles_mantenimiento` text DEFAULT NULL,
  `proxima_fecha_mantenimiento` date DEFAULT NULL,
  `fecha_registro` timestamp NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=33 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO equipos VALUES('1', 'HP ALL IN ONE 23.5', 'LABORATORIO ENLACES', 'HP', 'ALL IN ONE 23.5', 'uploads/equipos/66c37b464e58b9.79489857.PNG', '1123HG44J467L', 'i5 9400', '4 GB', '1 TB HDD', 'INTEGRADA', 'WINDOWS 10 LTNCS', '22H2', '1', 'OFFICE 365, WINRAR, VLC, GOOGLE CHROME, ADOBE PDF', 'Operativo', 'CUENTA CON MOUSE Y TECLADO ORIGINAL HP', '2024-08-02', 'MANTENIMIENTO GENERAL A NIVEL DE HARDWARE Y SOFTWARE', '2024-12-31', '2024-08-12 17:40:02');
INSERT INTO equipos VALUES('2', 'Lenovo All in One', 'Laboratorio Enlaces', 'Lenovo', 'C240', 'uploads/equipos/66c37bc3a11e56.49421796.PNG', 'DAEM 3549-1      0000062', 'Intel Celeron', '2 GB', '500 GB HDD', 'Integrada', 'Windows 7 Ultimate', 'Ultimate', '1', 'OFFICE 365, WINRAR, VLC, GOOGLE CHROME, ADOBE PDF', 'Operativo', 'CUENTA CON MOUSE Y TECLADO', '2024-08-14', 'MANTENIMIENTO GENERAL A NIVEL DE HARDWARE Y SOFTWARE', '2025-07-14', '2024-08-14 08:36:27');
INSERT INTO equipos VALUES('3', 'Equipo1', 'Laboratotio Enlaces', 'Dell', 'Optiplex 7080', NULL, 'SN123456789', 'Intel i7-10700', '16GB', '512GB SSD', 'NVIDIA GTX 1650', 'Windows 10 Pro', '21H1', '1', 'Office 365, Chrome', 'Operativo', 'Ninguna', '2024-01-15', 'Limpieza general', '2024-07-15', '2024-08-14 08:42:06');
INSERT INTO equipos VALUES('4', 'Equipo2', 'Laboratotio Enlaces', 'HP', 'ProBook 450', NULL, 'SN987654321', 'Intel i5-10210U', '8GB', '256GB SSD', 'Intel UHD Graphics', 'Windows 10 Home', '20H2', '1', 'Office 2019', 'Operativo', 'Ninguna', '2024-02-01', 'Actualizacin de software', '2024-08-01', '2024-08-14 08:42:06');
INSERT INTO equipos VALUES('5', 'Equipo3', 'Sala 3', 'Lenovo', 'ThinkPad X1', NULL, 'SN112233445', 'Intel i7-1165G7', '16GB', '1TB SSD', 'Intel Iris Xe', 'Windows 11 Pro', '22H2', '1', 'Visual Studio, Zoom', 'Operativo', 'Ninguna', '2024-03-10', 'Reemplazo de batera', '2024-09-10', '2024-08-14 08:42:06');
INSERT INTO equipos VALUES('6', 'Equipo4', 'Sala 4', 'Acer', 'Aspire 5', NULL, 'SN223344556', 'AMD Ryzen 5 5500U', '8GB', '512GB SSD', 'AMD Radeon Vega 8', 'Windows 11 Home', '22H1', '1', 'Firefox, LibreOffice', 'Operativo', 'Ninguna', '2024-04-20', 'Chequeo de hardware', '2024-10-20', '2024-08-14 08:42:06');
INSERT INTO equipos VALUES('7', 'Equipo5', 'Sala 5', 'Asus', 'ROG Strix', NULL, 'SN334455667', 'Intel i9-11900K', '32GB', '1TB SSD', 'NVIDIA RTX 3080', 'Windows 10 Pro', '21H2', '1', 'Adobe CC, Autodesk', 'Operativo', 'Ninguna', '2024-05-25', 'Actualizacin de drivers', '2024-11-25', '2024-08-14 08:42:06');
INSERT INTO equipos VALUES('8', 'Equipo6', 'Sala 6', 'Dell', 'XPS 13', NULL, 'SN445566778', 'Intel i7-1185G7', '16GB', '512GB SSD', 'Intel Iris Xe', 'Windows 11 Pro', '22H2', '1', 'Office 365, Teams', 'Operativo', 'Ninguna', '2024-06-15', 'Actualizacin del sistema', '2024-12-15', '2024-08-14 08:42:06');
INSERT INTO equipos VALUES('9', 'Equipo7', 'Sala 7', 'HP', 'Envy 15', NULL, 'SN556677889', 'Intel i5-11400H', '16GB', '512GB SSD', 'NVIDIA GTX 1650', 'Windows 10 Home', '21H2', '1', 'Chrome, Notepad++', 'Operativo', 'Ninguna', '2024-07-20', 'Chequeo de rendimiento', '2025-01-20', '2024-08-14 08:42:06');
INSERT INTO equipos VALUES('10', 'Equipo8', 'Sala 8', 'Lenovo', 'Legion 5', NULL, 'SN667788990', 'AMD Ryzen 7 5800H', '32GB', '1TB SSD', 'NVIDIA RTX 3060', 'Windows 11 Home', '22H1', '1', 'Steam, Blender', 'Operativo', 'Ninguna', '2024-08-05', 'Limpieza de ventiladores', '2025-02-05', '2024-08-14 08:42:06');
INSERT INTO equipos VALUES('11', 'Equipo9', 'Sala 9', 'Acer', 'Predator Helios', NULL, 'SN778899001', 'Intel i7-12700H', '32GB', '1TB SSD', 'NVIDIA RTX 3070', 'Windows 11 Pro', '22H2', '1', 'Photoshop, Premiere Pro', 'Operativo', 'Ninguna', '2024-09-12', 'Revisin de disco', '2025-03-12', '2024-08-14 08:42:06');
INSERT INTO equipos VALUES('12', 'Equipo10', 'Sala 10', 'Asus', 'ZenBook 14', NULL, 'SN889900112', 'Intel i5-1135G7', '8GB', '256GB SSD', 'Intel Iris Xe', 'Windows 10 Home', '21H1', '1', 'Office 2019, Edge', 'Operativo', 'Ninguna', '2024-10-18', 'Actualizacin de BIOS', '2025-04-18', '2024-08-14 08:42:06');
INSERT INTO equipos VALUES('13', 'Equipo11', 'Sala 11', 'Dell', 'Inspiron 15', NULL, 'SN990011223', 'Intel i5-1035G1', '8GB', '512GB SSD', 'Intel UHD Graphics', 'Windows 10 Home', '20H2', '1', 'LibreOffice, VLC', 'Operativo', 'Ninguna', '2024-11-22', 'Chequeo de seguridad', '2025-05-22', '2024-08-14 08:42:06');
INSERT INTO equipos VALUES('14', 'Equipo12', 'Sala 12', 'HP', 'Pavilion 14', NULL, 'SN001122334', 'Intel i7-1165G7', '16GB', '512GB SSD', 'Intel Iris Xe', 'Windows 11 Pro', '22H2', '1', 'Office 365, Spotify', 'Operativo', 'Ninguna', '2024-12-14', 'Reemplazo de teclado', '2025-06-14', '2024-08-14 08:42:06');
INSERT INTO equipos VALUES('15', 'Equipo13', 'Sala 13', 'Lenovo', 'ThinkCentre', NULL, 'SN112233446', 'Intel i7-11700', '16GB', '512GB SSD', 'NVIDIA GTX 1650', 'Windows 10 Pro', '21H1', '1', 'Teams, Zoom', 'Operativo', 'Ninguna', '2025-01-08', 'Limpieza de hardware', '2025-07-08', '2024-08-14 08:42:06');
INSERT INTO equipos VALUES('16', 'Equipo14', 'Sala 14', 'Acer', 'Swift 3', NULL, 'SN223344557', 'AMD Ryzen 5 5500U', '8GB', '256GB SSD', 'AMD Radeon Graphics', 'Windows 11 Home', '22H1', '1', 'Google Chrome, LibreOffice', 'Operativo', 'Ninguna', '2025-02-12', 'Actualizacin de software', '2025-08-12', '2024-08-14 08:42:06');
INSERT INTO equipos VALUES('17', 'Equipo15', 'Sala 15', 'Asus', 'TUF Gaming', NULL, 'SN334455668', 'Intel i5-11400F', '16GB', '1TB SSD', 'NVIDIA RTX 3060', 'Windows 10 Home', '21H2', '1', 'Blender, Discord', 'Operativo', 'Ninguna', '2025-03-15', 'Chequeo de rendimiento', '2025-09-15', '2024-08-14 08:42:06');
INSERT INTO equipos VALUES('18', 'Equipo16', 'Sala 16', 'Dell', 'Latitude 7420', NULL, 'SN445566779', 'Intel i7-1185G7', '16GB', '512GB SSD', 'Intel Iris Xe', 'Windows 11 Pro', '22H2', '1', 'Office 365, Adobe Reader', 'Operativo', 'Ninguna', '2025-04-20', 'Revisin de conexiones', '2025-10-20', '2024-08-14 08:42:06');
INSERT INTO equipos VALUES('19', 'Equipo17', 'Sala 17', 'HP', 'Spectre x360', NULL, 'SN556677880', 'Intel i7-1195G7', '16GB', '1TB SSD', 'Intel Iris Xe', 'Windows 11 Pro', '22H2', '1', 'Office 2019, OneDrive', 'Operativo', 'Ninguna', '2025-05-25', 'Actualizacin de drivers', '2025-11-25', '2024-08-14 08:42:06');
INSERT INTO equipos VALUES('20', 'Equipo18', 'Sala 18', 'Lenovo', 'ThinkPad T14', NULL, 'SN667788991', 'AMD Ryzen 7 5800U', '32GB', '512GB SSD', 'AMD Radeon Graphics', 'Windows 10 Pro', '21H2', '1', 'Slack, Visual Studio', 'Operativo', 'Ninguna', '2025-06-30', 'Reemplazo de disco', '2026-01-30', '2024-08-14 08:42:06');
INSERT INTO equipos VALUES('21', 'Equipo19', 'Sala 19', 'Acer', 'Nitro 5', NULL, 'SN778899002', 'Intel i7-12700H', '32GB', '1TB SSD', 'NVIDIA RTX 3070', 'Windows 11 Home', '22H1', '1', 'Autocad, Chrome', 'Operativo', 'Ninguna', '2025-07-15', 'Limpieza de ventiladores', '2026-02-15', '2024-08-14 08:42:06');
INSERT INTO equipos VALUES('22', 'Equipo20', 'Sala 20', 'Asus', 'VivoBook 15', NULL, 'SN889900113', 'Intel i5-11300H', '8GB', '512GB SSD', 'Intel Iris Xe', 'Windows 11 Home', '22H2', '1', 'Office 365, VLC', 'Operativo', 'Ninguna', '2025-08-10', 'Chequeo de seguridad', '2026-03-10', '2024-08-14 08:42:06');
INSERT INTO equipos VALUES('23', 'Equipo21', 'Sala 21', 'Dell', 'G5 Gaming', NULL, 'SN990011224', 'Intel i7-11800H', '16GB', '1TB SSD', 'NVIDIA RTX 3070', 'Windows 10 Home', '21H2', '1', 'Steam, Photoshop', 'Operativo', 'Ninguna', '2025-09-15', 'Revisin de disco', '2026-04-15', '2024-08-14 08:42:06');
INSERT INTO equipos VALUES('24', 'Equipo22', 'Sala 22', 'HP', 'Elite Dragonfly', NULL, 'SN001122335', 'Intel i7-1185G7', '16GB', '512GB SSD', 'Intel Iris Xe', 'Windows 11 Pro', '22H2', '1', 'Teams, Office 365', 'Operativo', 'Ninguna', '2025-10-20', 'Limpieza general', '2026-05-20', '2024-08-14 08:42:06');
INSERT INTO equipos VALUES('25', 'Equipo23', 'Sala 23', 'Lenovo', 'IdeaPad 5', NULL, 'SN112233447', 'AMD Ryzen 7 5700U', '16GB', '512GB SSD', 'AMD Radeon Graphics', 'Windows 10 Home', '21H1', '1', 'Chrome, LibreOffice', 'Operativo', 'Ninguna', '2025-11-25', 'Actualizacin de software', '2026-06-25', '2024-08-14 08:42:06');
INSERT INTO equipos VALUES('26', 'Equipo24', 'Sala 24', 'Acer', 'ConceptD 5', NULL, 'SN223344558', 'Intel i9-11900K', '32GB', '1TB SSD', 'NVIDIA RTX 3070', 'Windows 11 Pro', '22H2', '1', 'Adobe CC, Blender', 'Operativo', 'Ninguna', '2026-01-10', 'Chequeo de rendimiento', '2026-07-10', '2024-08-14 08:42:06');
INSERT INTO equipos VALUES('27', 'Equipo25', 'Sala 25', 'Asus', 'ProArt StudioBook', NULL, 'SN334455669', 'Intel i7-11800H', '32GB', '1TB SSD', 'NVIDIA RTX 3080', 'Windows 10 Pro', '21H2', '1', 'Photoshop, Premiere Pro', 'Operativo', 'Ninguna', '2026-02-15', 'Reemplazo de batera', '2026-08-15', '2024-08-14 08:42:06');
INSERT INTO equipos VALUES('28', 'Equipo26', 'Sala 26', 'Dell', 'Optiplex 3090', NULL, 'SN445566780', 'Intel i5-10500', '16GB', '512GB SSD', 'Intel UHD Graphics', 'Windows 10 Pro', '20H2', '1', 'Office 2019, Edge', 'Operativo', 'Ninguna', '2026-03-20', 'Limpieza de hardware', '2026-09-20', '2024-08-14 08:42:06');
INSERT INTO equipos VALUES('29', 'Equipo27', 'Sala 27', 'HP', 'ZBook Create', NULL, 'SN556677881', 'Intel i9-11950H', '32GB', '1TB SSD', 'NVIDIA RTX 3070', 'Windows 11 Pro', '22H1', '1', 'AutoCAD, Premiere Pro', 'Operativo', 'Ninguna', '2026-04-25', 'Actualizacin de BIOS', '2026-10-25', '2024-08-14 08:42:06');
INSERT INTO equipos VALUES('30', 'Equipo28', 'Sala 28', 'Lenovo', 'ThinkStation P620', NULL, 'SN667788992', 'AMD Ryzen Threadripper PRO 3955WX', '64GB', '2TB SSD', 'NVIDIA RTX A5000', 'Windows 10 Pro', '20H2', '1', 'SolidWorks, AutoCAD', 'Operativo', 'Ninguna', '2026-05-30', 'Chequeo de rendimiento', '2026-11-30', '2024-08-14 08:42:06');
INSERT INTO equipos VALUES('31', 'Equipo29', 'Sala 29', 'Acer', 'Predator Triton', NULL, 'SN778899003', 'Intel i7-11800H', '32GB', '1TB SSD', 'NVIDIA RTX 3070', 'Windows 11 Home', '22H2', '1', 'Adobe CC, Steam', 'Operativo', 'Ninguna', '2026-06-15', 'Revisin de disco', '2027-01-15', '2024-08-14 08:42:06');
INSERT INTO equipos VALUES('32', 'Equipo30', 'Sala 30', 'Asus', 'ZenBook Pro', NULL, 'SN889900114', 'Intel i9-11900H', '32GB', '1TB SSD', 'NVIDIA RTX 3080', 'Windows 11 Pro', '22H2', '1', 'Office 365, Zoom', 'Operativo', 'Ninguna', '2026-07-20', 'Limpieza general', '2027-02-20', '2024-08-14 08:42:06');





CREATE TABLE `familiares` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `alumno_id` int(11) NOT NULL,
  `nombre_mama` varchar(100) NOT NULL,
  `rut_mama` varchar(12) NOT NULL,
  `dom_mama` varchar(255) NOT NULL,
  `escolaridad_mama` varchar(100) DEFAULT NULL,
  `trabaja_mama` tinyint(1) NOT NULL,
  `tpo_trabajo_mama` varchar(100) DEFAULT NULL,
  `dentro_fuera_hogar_mama` varchar(100) DEFAULT NULL,
  `nombre_papa` varchar(100) NOT NULL,
  `rut_papa` varchar(12) NOT NULL,
  `dom_papa` varchar(255) NOT NULL,
  `escolaridad_papa` varchar(100) DEFAULT NULL,
  `trabaja_papa` tinyint(1) NOT NULL,
  `tpo_trabajo_papa` varchar(100) DEFAULT NULL,
  `dentro_fuera_hogar_papa` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `alumno_id` (`alumno_id`),
  CONSTRAINT `familiares_ibfk_1` FOREIGN KEY (`alumno_id`) REFERENCES `matriculas` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO familiares VALUES('4', '7', 'Susana Mesa', '15883221-1', 'Mi casa', 'Enseanza Media Completa', '0', NULL, NULL, 'Marcos Rojas', '15741963-2', 'mi casa', 'Enseanza Media Completa', '0', NULL, NULL);





CREATE TABLE `horarios` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `usuario_id` int(11) NOT NULL,
  `fecha` date NOT NULL,
  `hora_inicio` time NOT NULL,
  `hora_fin` time NOT NULL,
  `curso_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `usuario_id` (`usuario_id`),
  KEY `curso_id` (`curso_id`),
  CONSTRAINT `horarios_ibfk_1` FOREIGN KEY (`usuario_id`) REFERENCES `usuarios` (`id`),
  CONSTRAINT `horarios_ibfk_2` FOREIGN KEY (`curso_id`) REFERENCES `cursos` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO horarios VALUES('1', '1', '2024-07-31', '08:30:00', '09:15:00', '1');
INSERT INTO horarios VALUES('2', '1', '2024-08-14', '08:30:00', '09:15:00', '1');
INSERT INTO horarios VALUES('3', '1', '2024-08-12', '08:30:00', '09:15:00', '5');
INSERT INTO horarios VALUES('4', '1', '2024-08-12', '09:15:00', '10:00:00', '5');
INSERT INTO horarios VALUES('5', '1', '2024-08-19', '08:30:00', '09:15:00', '1');
INSERT INTO horarios VALUES('6', '1', '2024-08-19', '09:15:00', '10:00:00', '1');
INSERT INTO horarios VALUES('7', '1', '2024-08-20', '08:30:00', '09:15:00', '1');
INSERT INTO horarios VALUES('8', '1', '2024-08-20', '09:15:00', '10:00:00', '1');
INSERT INTO horarios VALUES('9', '1', '2024-08-21', '08:30:00', '09:15:00', '4');
INSERT INTO horarios VALUES('10', '1', '2024-08-21', '09:15:00', '10:00:00', '4');
INSERT INTO horarios VALUES('11', '1', '2024-08-22', '08:30:00', '09:15:00', '5');
INSERT INTO horarios VALUES('12', '1', '2024-08-22', '09:15:00', '10:00:00', '5');
INSERT INTO horarios VALUES('13', '1', '2024-08-23', '08:30:00', '09:15:00', '4');
INSERT INTO horarios VALUES('14', '1', '2024-08-23', '09:15:00', '10:00:00', '4');
INSERT INTO horarios VALUES('15', '1', '2024-08-19', '10:20:00', '11:05:00', '3');
INSERT INTO horarios VALUES('16', '1', '2024-08-19', '11:05:00', '11:50:00', '3');
INSERT INTO horarios VALUES('17', '1', '2024-08-19', '12:00:00', '12:45:00', '4');
INSERT INTO horarios VALUES('18', '1', '2024-08-19', '12:45:00', '13:30:00', '4');
INSERT INTO horarios VALUES('20', '1', '2024-08-19', '14:25:00', '15:10:00', '5');
INSERT INTO horarios VALUES('21', '1', '2024-08-19', '15:10:00', '15:55:00', '5');
INSERT INTO horarios VALUES('22', '1', '2024-08-20', '10:20:00', '11:05:00', '4');
INSERT INTO horarios VALUES('23', '1', '2024-08-20', '11:05:00', '11:50:00', '1');





CREATE TABLE `informacion_adicional` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `alumno_id` int(11) NOT NULL,
  `es_bicultural` tinyint(1) NOT NULL,
  `etnia` varchar(255) DEFAULT NULL,
  `problemas_aprendizaje` text DEFAULT NULL,
  `cursos_repetidos` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `alumno_id` (`alumno_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO informacion_adicional VALUES('1', '7', '0', NULL, 'Ninguno', 'Ninguno');





CREATE TABLE `matriculas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `num_centro_apoderados` int(11) NOT NULL,
  `rut` varchar(12) NOT NULL,
  `nombres` varchar(100) NOT NULL,
  `apellidos` varchar(100) NOT NULL,
  `curso_id` int(11) NOT NULL,
  `fecha_nac` date NOT NULL,
  `lugar_nac` varchar(100) NOT NULL,
  `dom_alumno` varchar(255) NOT NULL,
  `fech_ing_curso` date NOT NULL,
  `procedencia` varchar(100) NOT NULL,
  `persona_con_quien_vive` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `rut` (`rut`),
  KEY `curso_id` (`curso_id`),
  CONSTRAINT `matriculas_ibfk_1` FOREIGN KEY (`curso_id`) REFERENCES `cursos` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO matriculas VALUES('7', '14', '23615741-1', 'Catalina Alejandra', 'Rojas Mesa', '3', '0000-00-00', 'Cauquenes', 'Mi casa', '2024-08-14', 'Anibal Pinto', 'Padres');





CREATE TABLE `notas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `usuario_id` int(11) NOT NULL,
  `asignatura_id` int(11) NOT NULL,
  `nota` decimal(5,2) NOT NULL,
  `fecha` date NOT NULL,
  `semestre` tinyint(1) NOT NULL,
  `numero_nota` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `usuario_id` (`usuario_id`),
  KEY `asignatura_id` (`asignatura_id`),
  CONSTRAINT `notas_ibfk_1` FOREIGN KEY (`usuario_id`) REFERENCES `usuarios` (`id`),
  CONSTRAINT `notas_ibfk_2` FOREIGN KEY (`asignatura_id`) REFERENCES `asignaturas` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=38 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO notas VALUES('12', '79', '1', '6.20', '2024-08-13', '1', '1');
INSERT INTO notas VALUES('13', '79', '1', '5.20', '2024-08-13', '1', '2');
INSERT INTO notas VALUES('14', '79', '1', '6.60', '2024-08-13', '1', '3');
INSERT INTO notas VALUES('15', '79', '1', '5.10', '2024-08-13', '1', '4');
INSERT INTO notas VALUES('16', '79', '1', '7.00', '2024-08-13', '1', '5');
INSERT INTO notas VALUES('17', '79', '2', '5.10', '2024-08-13', '1', '1');
INSERT INTO notas VALUES('18', '79', '2', '5.80', '2024-08-13', '1', '2');
INSERT INTO notas VALUES('19', '79', '2', '6.10', '2024-08-13', '1', '3');
INSERT INTO notas VALUES('20', '79', '2', '6.20', '2024-08-13', '1', '4');
INSERT INTO notas VALUES('21', '79', '2', '5.10', '2024-08-13', '1', '5');
INSERT INTO notas VALUES('22', '79', '4', '7.00', '2024-08-13', '1', '1');
INSERT INTO notas VALUES('23', '79', '4', '7.00', '2024-08-13', '1', '2');
INSERT INTO notas VALUES('24', '79', '4', '6.80', '2024-08-13', '1', '3');
INSERT INTO notas VALUES('25', '79', '5', '7.00', '2024-08-13', '1', '1');
INSERT INTO notas VALUES('26', '79', '5', '7.00', '2024-08-13', '1', '2');
INSERT INTO notas VALUES('27', '79', '7', '5.20', '2024-08-13', '1', '1');
INSERT INTO notas VALUES('28', '79', '7', '6.60', '2024-08-13', '1', '2');
INSERT INTO notas VALUES('29', '79', '7', '6.60', '2024-08-13', '1', '3');
INSERT INTO notas VALUES('30', '79', '7', '6.10', '2024-08-13', '1', '4');
INSERT INTO notas VALUES('31', '79', '8', '6.60', '2024-08-13', '1', '1');
INSERT INTO notas VALUES('32', '79', '8', '6.10', '2024-08-13', '1', '2');
INSERT INTO notas VALUES('33', '79', '8', '6.10', '2024-08-13', '1', '3');
INSERT INTO notas VALUES('34', '79', '8', '5.20', '2024-08-13', '1', '4');
INSERT INTO notas VALUES('35', '79', '3', '5.20', '2024-08-13', '1', '1');
INSERT INTO notas VALUES('36', '79', '3', '7.00', '2024-08-13', '1', '2');
INSERT INTO notas VALUES('37', '79', '3', '7.00', '2024-08-13', '1', '3');





CREATE TABLE `prevision_salud` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `alumno_id` int(11) NOT NULL,
  `prevision_salud` varchar(100) NOT NULL,
  `alergico_alimentario` varchar(255) DEFAULT NULL,
  `isapre` varchar(100) DEFAULT NULL,
  `fonasa_letra` varchar(100) DEFAULT NULL,
  `chile_solidario` tinyint(1) NOT NULL,
  `programa_puente` tinyint(1) NOT NULL,
  `ant_clinicos` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `alumno_id` (`alumno_id`),
  CONSTRAINT `prevision_salud_ibfk_1` FOREIGN KEY (`alumno_id`) REFERENCES `matriculas` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO prevision_salud VALUES('1', '7', 'FONASA', NULL, '', 'A', '0', '0', 'Ninguno');





CREATE TABLE `usuarios` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rut` varchar(12) NOT NULL,
  `nombre` varchar(100) NOT NULL,
  `contrasena` varchar(255) NOT NULL,
  `rol` enum('admin','profesor','estudiante','administrativo') NOT NULL,
  `curso_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `rut` (`rut`)
) ENGINE=InnoDB AUTO_INCREMENT=101 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO usuarios VALUES('1', '19098012-k', 'Matias Aravena', '$2y$10$ByLrw9DfLFXNnKR67.D37O09MU8SNHTbCWlWeJL/mVJgzN8z3KYx2', 'admin', NULL);
INSERT INTO usuarios VALUES('4', '12965066-4', 'Pepe Tapia', '$2y$10$Brgkh3vnuWLqvwXZnWuNPOTHTfIRX1zwrTrwZEenyQhLd.G1TCPNW', 'estudiante', '2');
INSERT INTO usuarios VALUES('5', '19098012-1', 'Carlos Salazar', '$2y$10$bHs7BrLDLKpH8V1tidA9cOwuVpiWUI7E3UGdxnSzwcQDSP0neVVJO', 'administrativo', '0');
INSERT INTO usuarios VALUES('7', '22566788-9', 'Sebastian Muoz', '$2y$10$XvLOr8F1Xe41.eMz5wYbTuMKSXPJtiOSE0fdR1MbxkEMU3FeQq7la', 'estudiante', '3');
INSERT INTO usuarios VALUES('8', '18667445-2', 'Samuel Ferrada', '$2y$10$fKr6OdqnQKuZikpZ6K.MKOzaZBuEdqAWvmlOCkO6pwMlQIljXM6dq', 'profesor', NULL);
INSERT INTO usuarios VALUES('9', '12554668-3', 'Carlos Fuentes', '$2y$10$CoP2Oc5j1QVNJ.MbdVSE0eAb.AgSzbmbUTWNOCXNM4Zo3DD/O0Q7q', 'profesor', NULL);
INSERT INTO usuarios VALUES('10', '14567098-2', 'Camila Suarez', '$2y$10$VMe2LME1ZUTwiIZNENQaz.rbGXrQSvfPBIUW2Mph4d3O4/bTbavUm', 'profesor', NULL);
INSERT INTO usuarios VALUES('11', '16887345-2', 'Sofia Menares', '$2y$10$c3FwoAsfdx.BwOxIyZGrJOtSvULzIYOcossYaLWl.lTuKCywvJXg.', 'profesor', NULL);
INSERT INTO usuarios VALUES('12', '17145508-1', 'Eva Salgado', '$2y$10$OsfoRa5j6izSo9buNhngHutPh75srbAxPfo72UAm5kYaDTMTmgZeq', 'admin', NULL);
INSERT INTO usuarios VALUES('13', '12345678-1', 'carlos parada', '$2y$10$1sgWBqn4BQtvwIp8AMZ6eePrBpcdeJ3OTKCOaB/l5Pamsb/lzM7ma', 'estudiante', '1');
INSERT INTO usuarios VALUES('61', '10246912-2', 'Juan Prez Vasques Parada', '$2y$10$9qgE8SVaneKkYjRy7rYePu7UVJ7CoefEeNUsMvDjSkWZJ/OqFYKU6', 'estudiante', '5');
INSERT INTO usuarios VALUES('62', '10370368-3', 'Sam Canales', '$2y$10$I6/a4InLBW0Fy2ooW91jKevNefVkWw7aiuG6yoJ7P2fmaGgDaF94e', 'estudiante', '5');
INSERT INTO usuarios VALUES('63', '10493824-4', 'Luis Morales Guerra', '$2y$10$4lndqB2rq/ptnNueqstQCe.DNbdC.9iCesbnqAscEax78Qi6ejib.', 'estudiante', '5');
INSERT INTO usuarios VALUES('64', '10617280-5', 'Sofa Castillo Mesa', '$2y$10$kg2vhUl66ITwW7eMBJZXuO4IokHyYfeuc54J47T29g7ex/fgwyoIa', 'estudiante', '5');
INSERT INTO usuarios VALUES('65', '10740736-6', 'Camila Rodrguez', '$2y$10$UOFodVPw2OUyS8UCdlNKtOwDuS9Q7lj2ngnCYInyNutep.ScftQC2', 'estudiante', '5');
INSERT INTO usuarios VALUES('66', '10864192-7', 'Diego Lpez', '$2y$10$vOm6Sd8JkT0YK2q8PgNYvO8cah0XeHTNQOhicpvSDZeEIYUia1O9G', 'estudiante', '5');
INSERT INTO usuarios VALUES('67', '10987648-8', 'Valentina Martnez', '$2y$10$1BZYCRRrw0d9S5grRH6wVOCcc7naC/Yj.TaZCJkHxYloOCu/CbBBS', 'estudiante', '5');
INSERT INTO usuarios VALUES('68', '11111104-9', 'Benjamn Hernndez', '$2y$10$aMeKdPCed9KG6a1p.4lTl.nHs/jR/zzgL0yobkBILzBW9CLKffXru', 'estudiante', '5');
INSERT INTO usuarios VALUES('69', '11234560-0', 'Matas Fernndez', '$2y$10$bN7KKE/NkD3t78FaOwOhE.2CDD4ARJbtQFmWXLfyAbRVOY1K8WjOa', 'estudiante', '5');
INSERT INTO usuarios VALUES('70', '11358016-1', 'Josefa Ramrez', '$2y$10$wOWkrO2DApwns/.e.dC.BOcaOpa6lQlRCrR0bTRZ2ecMF2yGANBrK', 'estudiante', '5');
INSERT INTO usuarios VALUES('71', '11481472-2', 'Catalina Gutirrez', '$2y$10$eHBpVYWTuZp2ITaYLgzXPOnfwDb2IUG4XUw2xlfCGeVmK24giEb5u', 'estudiante', '5');
INSERT INTO usuarios VALUES('72', '11604928-3', 'Sebastin Rojas', '$2y$10$8spe9CLkc/YNJuzhgD7C..dy7YfkMBILP/2W7EXY4J2yTiqPGVeAS', 'estudiante', '5');
INSERT INTO usuarios VALUES('73', '11728384-4', 'Mara Vsquez', '$2y$10$G6d.TrC2PTGNhx/5/Z.Q9ezzs17NoWGduCpPbvCSqBJfoEYuZ0g5e', 'estudiante', '5');
INSERT INTO usuarios VALUES('74', '11851840-5', 'Martn Romero', '$2y$10$wbS7JbgzVsigI66YlJbgSe6cnLoov9LwUcfhJb//QK87aXhGG0mTi', 'estudiante', '5');
INSERT INTO usuarios VALUES('75', '11975296-6', 'Florencia Nuez', '$2y$10$U7y3VPnYlRDkYTilZX6fI.9XEkkar.lytL9HaJx7DCVUSPc1069A.', 'estudiante', '5');
INSERT INTO usuarios VALUES('76', '12098752-7', 'Gabriel Vera', '$2y$10$7.k7btuV1kJoyvjQfg3plOKD4DcgR1Yl4SxCKgEYY6ss7CMyEMHGK', 'estudiante', '5');
INSERT INTO usuarios VALUES('77', '12222208-8', 'Isabella Riquelme', '$2y$10$GIgYQJhcogEoKX0rwUHsbekD.BHMNVM9VESNSagptyWan8tww02Eu', 'estudiante', '5');
INSERT INTO usuarios VALUES('78', '12345664-9', 'Joaqun Muoz', '$2y$10$G2HVT/vqWofso49swRcZwOkInRWDnieqS7YrOXY.zKriS3gpyRG.O', 'estudiante', '5');
INSERT INTO usuarios VALUES('79', '12469120-0', 'Amanda Soto', '$2y$10$vfLs8NjtvqyDenwdKI.IbOXLYCBrsV8iO/dRqARlQcR0n75xF8lta', 'estudiante', '5');
INSERT INTO usuarios VALUES('80', '12592576-1', 'Toms Torres', '$2y$10$9Br3Ujdj5Pax5cwUP5yyg.KEVf51m1patP/IbjZ9Ov/kipdfrAnZi', 'estudiante', '5');
INSERT INTO usuarios VALUES('81', '12716032-2', 'Carmen Moya', '$2y$10$.Lp68FGhiyA3BhaB6Xy.f.wSd1rc9.wzrQm1EuQ0JoJUsWi9.cSPy', 'estudiante', '5');
INSERT INTO usuarios VALUES('82', '12839488-3', 'Nicols Gmez', '$2y$10$4PHOLABrpdb.o7zvqbhH4OiadQ54IL3Ghj3rYxlXNcI9r4i19BXEy', 'estudiante', '5');
INSERT INTO usuarios VALUES('83', '12962944-4', 'Constanza Reyes', '$2y$10$wwuoYRsRI7H8uW6ISY0GxedP8Sd0dDGl2ufazpmHp97lsUGBwGrz6', 'estudiante', '5');
INSERT INTO usuarios VALUES('84', '13086400-5', 'Maximiliano Pizarro', '$2y$10$MjZCmQs8h.n1I7Uk0fCTWOuzfheKcX2okQCRss9vhtZcjI2isVlbG', 'estudiante', '5');
INSERT INTO usuarios VALUES('85', '13209856-6', 'Paula Garca', '$2y$10$.e6R.RusdykDTfW5xvve2uUGvlQw3UHua7kbrM/mV5CxSlNTQb6n2', 'estudiante', '5');
INSERT INTO usuarios VALUES('86', '13333312-7', 'Vicente Pino', '$2y$10$gLN1Tk7COK5uD4uB61BnkORVQg9RpUegGtQDmzjyiDWvV/AtH96.e', 'estudiante', '5');
INSERT INTO usuarios VALUES('87', '13456768-8', 'Antonia Cceres', '$2y$10$/xdw3HwlhbL4dhyOrNStyOJfOgnLPLEf58JII3ug2h3iRO4HGiOHK', 'estudiante', '5');
INSERT INTO usuarios VALUES('88', '13580224-9', 'Felipe Durn', '$2y$10$pTAs4ZTJ8O0h6a93ot3lG.9DKZFvIGpqqkV6d/kxFkMWL.O1i/pIS', 'estudiante', '5');
INSERT INTO usuarios VALUES('89', '13703680-0', 'Francisca Poblete', '$2y$10$byTAagvvc8dl.SdfUOw0K.MAccySj5jsit7W8sx1eYr0Z80HOZgYu', 'estudiante', '5');
INSERT INTO usuarios VALUES('90', '13827136-1', 'Cristbal Espinoza', '$2y$10$pFP2qG25pykCMVnAm4opeu1XzLX8A48KHbMFS.IBGBEvLH62AbKny', 'estudiante', '5');
INSERT INTO usuarios VALUES('91', '13950592-2', 'Brbara Ortiz', '$2y$10$/gUnQ17029f8ULmMK5KqWup3zgEPQQ7NiLMugS0sK79upgr5Egz3a', 'estudiante', '5');
INSERT INTO usuarios VALUES('92', '14074048-3', 'Ignacio Guzmn', '$2y$10$U/jWrrPJorCJHuPq5euevuRwhMAQqjDdEoWpcAZ/lnOic0BLZDwl.', 'estudiante', '5');
INSERT INTO usuarios VALUES('93', '14197504-4', 'Julieta Navarro', '$2y$10$iJOVZDJjT5IA6Uh8SGYo5eN9Cm4sgbOi4VqoCzvUoPuSpXmUS4f0m', 'estudiante', '5');
INSERT INTO usuarios VALUES('94', '14320960-5', 'Renato Orellana', '$2y$10$OgwAp2jy3183vv8s7kRwKe8CgNXsFPmHzVpv12jiCDHv83kYo7OcS', 'estudiante', '5');
INSERT INTO usuarios VALUES('95', '19097718-8', 'Jose Moya Garrido', '$2y$10$GhRMaOIQJW14QxmuFYzVmeAVPpDS3ronIG4usMlD1eupyvK.xdSp.', 'admin', NULL);
INSERT INTO usuarios VALUES('96', '23615741-1', 'Catalina Alejandra', '$2y$10$ZzdD90USKfpArqT8gQuQi.xCte47AIEQyeMM92dBohOGZUcAx.1My', 'estudiante', '3');
INSERT INTO usuarios VALUES('100', '18675099-1', 'Kira Yushiro', '$2y$10$2eUu7sFsbW8LLhXqALwUjuXBFnGjwKAn5hwUgonBY0WN1rxSAV3d.', 'profesor', NULL);



