define("core_courseformat/local/activitychooser/dialoguedom",["exports","core/loadingicon","theme_boost/bootstrap/carousel","core/normalise","core/notification","core/pending","core_courseformat/local/activitychooser/selectors","theme_boost/bootstrap/tab","core/templates"],(function(_exports,_loadingicon,_carousel,_normalise,_notification,_pending,_selectors,_tab,Templates){function _getRequireWildcardCache(nodeInterop){if("function"!=typeof WeakMap)return null;var cacheBabelInterop=new WeakMap,cacheNodeInterop=new WeakMap;return(_getRequireWildcardCache=function(nodeInterop){return nodeInterop?cacheNodeInterop:cacheBabelInterop})(nodeInterop)}function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}
/**
   * The activity changer dialogue DOM manipulation module.
   *
   * @module     core_courseformat/local/activitychooser/dialoguedom
   * @copyright  2025 Ferran Recio <ferran@moodle.com>
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0,_carousel=_interopRequireDefault(_carousel),_notification=_interopRequireDefault(_notification),_pending=_interopRequireDefault(_pending),_selectors=_interopRequireDefault(_selectors),_tab=_interopRequireDefault(_tab),Templates=function(obj,nodeInterop){if(!nodeInterop&&obj&&obj.__esModule)return obj;if(null===obj||"object"!=typeof obj&&"function"!=typeof obj)return{default:obj};var cache=_getRequireWildcardCache(nodeInterop);if(cache&&cache.has(obj))return cache.get(obj);var newObj={},hasPropertyDescriptor=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var key in obj)if("default"!==key&&Object.prototype.hasOwnProperty.call(obj,key)){var desc=hasPropertyDescriptor?Object.getOwnPropertyDescriptor(obj,key):null;desc&&(desc.get||desc.set)?Object.defineProperty(newObj,key,desc):newObj[key]=obj[key]}newObj.default=obj,cache&&cache.set(obj,newObj);return newObj}(Templates);return _exports.default=class{constructor(dialogue,modal,exporter){this.modal=modal,this.modalBody=(0,_normalise.getFirst)(this.modal.getBody()),this.exporter=exporter,this.dialogue=dialogue}getSearchInputElement(){return this.modalBody.querySelector(_selectors.default.actions.search)}getClosestChooserOption(element){return element.closest(_selectors.default.regions.chooserOption.container)}isFavoutiteTabActive(){const favouriteTab=this.modalBody.querySelector(_selectors.default.regions.favouriteTabNav);return favouriteTab&&favouriteTab.classList.contains("active")}getChooserOptionUrl(optionContainer){const optionLink=optionContainer.querySelector(_selectors.default.actions.addChooser);if(!optionLink)throw new Error("Invalid chooser option container: no link found");return optionLink.getAttribute("href")}async refreshSearchResults(searchQuery,searchResultsData){const searchResultsContainer=this.modalBody.querySelector(_selectors.default.regions.searchResults),clearSearchButton=this.modalBody.querySelector(_selectors.default.actions.clearSearch);await this.renderSearchResults(searchResultsContainer,searchQuery,searchResultsData);const firstSearchResultItem=searchResultsContainer.querySelector(_selectors.default.regions.chooserOptions).querySelector(_selectors.default.regions.chooserOption.container);firstSearchResultItem&&this.toggleFocusableChooserOption(firstSearchResultItem,!0),clearSearchButton.classList.remove("d-none");searchResultsContainer.closest(_selectors.default.regions.tabContent).querySelector(_selectors.default.regions.categoryContent).classList.add("d-none")}cleanSearchResults(){const searchResultsContainer=this.modalBody.querySelector(_selectors.default.regions.searchResults),clearSearchButton=this.modalBody.querySelector(_selectors.default.actions.clearSearch);searchResultsContainer.innerHTML="",clearSearchButton.classList.add("d-none");searchResultsContainer.closest(_selectors.default.regions.tabContent).querySelector(_selectors.default.regions.categoryContent).classList.remove("d-none")}async renderSearchResults(searchResultsContainer,searchQuery,searchResultsData){const templateData=this.exporter.getSearchResultData(searchQuery,searchResultsData),{html:html,js:js}=await Templates.renderForPromise("core_courseformat/local/activitychooser/search_results",templateData);await Templates.replaceNodeContents(searchResultsContainer,html,js)}showAllActivitiesTab(){return this.showCategoryTab("all")}showCategoryTab(category){const navTab=this.modalBody.querySelector(_selectors.default.regions.categoryTabNav(category));if(navTab.classList.contains("active"))return navTab;const pendingPromise=new _pending.default("core_courseformat/activitychooser:".concat(category,"-tab"));return navTab.addEventListener("shown.bs.tab",pendingPromise.resolve,{once:!0}),_tab.default.getOrCreateInstance(navTab).show(),navTab}updateItemStarredIcons(internal,favourite){const favouriteButtons=this.modalBody.querySelectorAll("".concat(_selectors.default.elements.moduleItem(internal)," ").concat(_selectors.default.actions.optionActions.manageFavourite));Array.from(favouriteButtons).forEach((element=>{var _element$querySelecto,_element$querySelecto2;element.dataset.favourited=favourite,element.setAttribute("aria-pressed",favourite),null===(_element$querySelecto=element.querySelector(_selectors.default.elements.favouriteIconActive))||void 0===_element$querySelecto||_element$querySelecto.classList.toggle("d-none",!favourite),null===(_element$querySelecto2=element.querySelector(_selectors.default.elements.favouriteIconInactive))||void 0===_element$querySelecto2||_element$querySelecto2.classList.toggle("d-none",favourite);const iconSelectsor=favourite?_selectors.default.elements.favouriteIconActive:_selectors.default.elements.favouriteIconInactive,favouriteIcon=element.querySelector(iconSelectsor);element.setAttribute("aria-label",(null==favouriteIcon?void 0:favouriteIcon.getAttribute("data-action-label"))||""),element.setAttribute("title",(null==favouriteIcon?void 0:favouriteIcon.getAttribute("data-action-label"))||"")}))}async refreshFavouritesTabContent(mappedModules){const templateData=await this.exporter.getFavouriteTabData(mappedModules),favouriteArea=this.modalBody.querySelector(_selectors.default.regions.favouriteTab),{html:html,js:js}=await Templates.renderForPromise("core_courseformat/local/activitychooser/tabcontent",templateData);await Templates.replaceNodeContents(favouriteArea,html,js)}toggleFavouriteTabDisplay(displayed){const favouriteTabNav=this.modalBody.querySelector(_selectors.default.regions.favouriteTabNav);let moveFocusTo;!displayed&&favouriteTabNav.classList.contains("active")&&(moveFocusTo=this.showAllActivitiesTab()),null==favouriteTabNav||favouriteTabNav.classList.toggle("d-none",!displayed),favouriteTabNav.tabIndex=displayed?0:-1,displayed?favouriteTabNav.classList.remove("disabled"):favouriteTabNav.classList.add("disabled"),moveFocusTo&&moveFocusTo.focus(),this.initActiveTabNavigation()}async showModuleHelp(moduleData){const carousel=this.modalBody.querySelector(_selectors.default.regions.carousel),help=carousel.querySelector(_selectors.default.regions.help);help.innerHTML="",help.classList.add("m-auto");const spinnerPromise=(0,_loadingicon.addIconToContainer)(help);let transitionPromiseResolver=null;const transitionPromise=new Promise((resolve=>{transitionPromiseResolver=resolve})),contentPromise=Templates.renderForPromise("core_courseformat/local/activitychooser/help",await this.exporter.getModuleHelpTemplateData(moduleData));Promise.all([contentPromise,spinnerPromise,transitionPromise]).then((_ref=>{let[{html:html,js:js}]=_ref;return Templates.replaceNodeContents(help,html,js)})).then((()=>(help.querySelector(_selectors.default.regions.chooserSummary.header).focus(),help))).catch(_notification.default.exception),carousel.addEventListener("slid.bs.carousel",(()=>{transitionPromiseResolver()}),{once:!0}),_carousel.default.getInstance(carousel).next()}hideModuleHelp(){let internal=arguments.length>0&&void 0!==arguments[0]?arguments[0]:null;const carousel=this.modalBody.querySelector(_selectors.default.regions.carousel);_carousel.default.getInstance(carousel).to(0),internal&&carousel.addEventListener("slid.bs.carousel",(()=>{this.focusChooserOption(internal)}),{once:!0})}setBackButtonModuleData(moduleData){const footer=(0,_normalise.getFirst)(this.modal.getFooter()),modnameValue="".concat(moduleData.componentname,"_").concat(moduleData.link);footer.querySelector(_selectors.default.actions.closeOption).dataset.modname=modnameValue}toggleBackButton(show){(0,_normalise.getFirst)(this.modal.getFooter()).querySelector(_selectors.default.actions.closeOption).classList.toggle("d-none",!show)}toggleAddButton(show){(0,_normalise.getFirst)(this.modal.getFooter()).querySelector(_selectors.default.actions.addSelectedChooserOption).classList.toggle("d-none",!show)}toggleActiveFooter(show){(0,_normalise.getFirst)(this.modal.getFooter()).querySelector(_selectors.default.regions.activeFooter).classList.toggle("d-none",!show)}focusChooserOption(internal){const currentTabNav=this.modalBody.querySelector(_selectors.default.elements.activetab),activeSectionId=currentTabNav.getAttribute("href"),newCurrent=this.modalBody.querySelector(_selectors.default.regions.getSectionChooserOptions(activeSectionId)).querySelector(_selectors.default.regions.getModuleSelector(internal));if(!newCurrent)throw new Error("Invalid chooser option to focus on: ".concat(internal));this.disableFocusAllChooserOptions(currentTabNav),this.toggleFocusableChooserOption(newCurrent,!0),newCurrent.contentEditable=!0,newCurrent.focus(),newCurrent.contentEditable=!1}initActiveTabNavigation(){const activeSectionId=this.modalBody.querySelector(_selectors.default.elements.activetab).getAttribute("href"),sectionChooserOptions=this.modalBody.querySelector(_selectors.default.regions.getSectionChooserOptions(activeSectionId)),firstChooserOption=null==sectionChooserOptions?void 0:sectionChooserOptions.querySelector(_selectors.default.regions.chooserOption.container);firstChooserOption&&this.toggleFocusableChooserOption(firstChooserOption,!0)}initBootstrapComponents(){this.modalBody.querySelectorAll(_selectors.default.elements.tab).forEach((navTab=>{_tab.default.getOrCreateInstance(navTab)}));const carousel=this.modalBody.querySelector(_selectors.default.regions.carousel);new _carousel.default(carousel,{interval:!1,pause:!0,keyboard:!1})}disableFocusAllChooserOptions(tabNav){const tabId=tabNav.getAttribute("href"),chooserOptions=this.modalBody.querySelector(_selectors.default.regions.getSectionChooserOptions(tabId));if(null===chooserOptions)return;chooserOptions.querySelectorAll(_selectors.default.regions.chooserOption.container).forEach((chooserOption=>{this.toggleFocusableChooserOption(chooserOption,!1)}))}toggleFocusableChooserOption(chooserOption,isFocusable){const chooserOptionLink=chooserOption.querySelector(_selectors.default.actions.addChooser),chooserOptionHelp=chooserOption.querySelector(_selectors.default.actions.optionActions.showSummary),chooserOptionFavourite=chooserOption.querySelector(_selectors.default.actions.optionActions.manageFavourite);isFocusable?(chooserOption.tabIndex=0,chooserOptionLink.tabIndex=0,chooserOptionHelp.tabIndex=0,chooserOptionFavourite.tabIndex=0):(chooserOption.tabIndex=-1,chooserOptionLink.tabIndex=-1,chooserOptionHelp.tabIndex=-1,chooserOptionFavourite.tabIndex=-1)}focusNextChooserOption(current){this.moveChooserOptionFocus(current,(currentOption=>{var _currentOption$nextEl;return null!==(_currentOption$nextEl=currentOption.nextElementSibling)&&void 0!==_currentOption$nextEl?_currentOption$nextEl:currentOption}))}focusPreviousChooserOption(current){this.moveChooserOptionFocus(current,(currentOption=>{var _currentOption$previo;return null!==(_currentOption$previo=currentOption.previousElementSibling)&&void 0!==_currentOption$previo?_currentOption$previo:currentOption}))}focusFirstChooserOption(current){this.moveChooserOptionFocus(current,((currentOption,container)=>{var _container$firstEleme;return null!==(_container$firstEleme=container.firstElementChild)&&void 0!==_container$firstEleme?_container$firstEleme:currentOption}))}focusLastChooserOption(current){this.moveChooserOptionFocus(current,((currentOption,container)=>{var _container$lastElemen;return null!==(_container$lastElemen=container.lastElementChild)&&void 0!==_container$lastElemen?_container$lastElemen:currentOption}))}moveChooserOptionFocus(current,getNextFocus){const currentOption=this.getClosestChooserOption(current),container=current.closest(_selectors.default.regions.chooserOptions);if(!container||!currentOption)throw new Error("Invalid chooser options container or current option");const newFocusOption=getNextFocus(currentOption,container);newFocusOption&&(this.toggleFocusableChooserOption(currentOption,!1),this.toggleFocusableChooserOption(newFocusOption,!0),newFocusOption.focus())}markChooserOptionAsSelected(chooserOption){this.unmarkAllChooserOptionAsSelected(),chooserOption.classList.add("selected"),chooserOption.setAttribute("aria-selected","true");const addButton=(0,_normalise.getFirst)(this.modal.getFooter()).querySelector(_selectors.default.actions.addSelectedChooserOption);addButton&&addButton.removeAttribute("disabled")}unmarkAllChooserOptionAsSelected(){this.modalBody.querySelectorAll("".concat(_selectors.default.regions.chooserOption.container,".selected")).forEach((option=>{option.classList.remove("selected"),option.setAttribute("aria-selected","false")}));const addButton=(0,_normalise.getFirst)(this.modal.getFooter()).querySelector(_selectors.default.actions.addSelectedChooserOption);addButton&&addButton.setAttribute("disabled","disabled")}},_exports.default}));

//# sourceMappingURL=dialoguedom.min.js.map